/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Log;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

final class BinderProxy
implements IBinder {
    private final WeakReference mSelf = new WeakReference<BinderProxy>(this);
    private long mObject;
    private long mOrgue;

    @Override
    public native boolean pingBinder();

    @Override
    public native boolean isBinderAlive();

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        return null;
    }

    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        Binder.checkParcel(this, code, data, "Unreasonably large binder buffer");
        return this.transactNative(code, data, reply, flags);
    }

    @Override
    public native String getInterfaceDescriptor() throws RemoteException;

    public native boolean transactNative(int var1, Parcel var2, Parcel var3, int var4) throws RemoteException;

    @Override
    public native void linkToDeath(IBinder.DeathRecipient var1, int var2) throws RemoteException;

    @Override
    public native boolean unlinkToDeath(IBinder.DeathRecipient var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 1);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    BinderProxy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private final native void destroy();

    private static final void sendDeathNotice(IBinder.DeathRecipient recipient) {
        try {
            recipient.binderDied();
        }
        catch (RuntimeException exc) {
            Log.w("BinderNative", "Uncaught exception from death notification", exc);
        }
    }
}

