/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Slog;
import dalvik.system.VMRuntime;
import java.util.Objects;

public class Build {
    private static final String TAG = "Build";
    public static final String UNKNOWN = "unknown";
    public static final String ID = Build.getString("ro.build.id");
    public static final String DISPLAY = Build.getString("ro.build.display.id");
    public static final String PRODUCT = Build.getString("ro.product.name");
    public static final String DEVICE = Build.getString("ro.product.device");
    public static final String BOARD = Build.getString("ro.product.board");
    @Deprecated
    public static final String CPU_ABI;
    @Deprecated
    public static final String CPU_ABI2;
    public static final String MANUFACTURER;
    public static final String BRAND;
    public static final String MODEL;
    public static final String BOOTLOADER;
    @Deprecated
    public static final String RADIO;
    public static final String HARDWARE;
    public static final String SERIAL;
    public static final String[] SUPPORTED_ABIS;
    public static final String[] SUPPORTED_32_BIT_ABIS;
    public static final String[] SUPPORTED_64_BIT_ABIS;
    public static final String TYPE;
    public static final String TAGS;
    public static final String FINGERPRINT;
    public static final long TIME;
    public static final String USER;
    public static final String HOST;
    public static final boolean IS_DEBUGGABLE;

    private static String deriveFingerprint() {
        String finger = SystemProperties.get("ro.build.fingerprint");
        if (TextUtils.isEmpty(finger)) {
            finger = Build.getString("ro.product.brand") + '/' + Build.getString("ro.product.name") + '/' + Build.getString("ro.product.device") + ':' + Build.getString("ro.build.version.release") + '/' + Build.getString("ro.build.id") + '/' + Build.getString("ro.build.version.incremental") + ':' + Build.getString("ro.build.type") + '/' + Build.getString("ro.build.tags");
        }
        return finger;
    }

    public static void ensureFingerprintProperty() {
        if (TextUtils.isEmpty(SystemProperties.get("ro.build.fingerprint"))) {
            try {
                SystemProperties.set("ro.build.fingerprint", FINGERPRINT);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Failed to set fingerprint property", e);
            }
        }
    }

    public static boolean isBuildConsistent() {
        String system = SystemProperties.get("ro.build.fingerprint");
        String vendor = SystemProperties.get("ro.vendor.build.fingerprint");
        String bootimage = SystemProperties.get("ro.bootimage.build.fingerprint");
        String requiredBootloader = SystemProperties.get("ro.build.expect.bootloader");
        String currentBootloader = SystemProperties.get("ro.bootloader");
        String requiredRadio = SystemProperties.get("ro.build.expect.baseband");
        String currentRadio = SystemProperties.get("gsm.version.baseband");
        if (TextUtils.isEmpty(system)) {
            Slog.e(TAG, "Required ro.build.fingerprint is empty!");
            return false;
        }
        if (!TextUtils.isEmpty(vendor) && !Objects.equals(system, vendor)) {
            Slog.e(TAG, "Mismatched fingerprints; system reported " + system + " but vendor reported " + vendor);
            return false;
        }
        return true;
    }

    public static String getRadioVersion() {
        return SystemProperties.get("gsm.version.baseband", null);
    }

    private static String getString(String property) {
        return SystemProperties.get(property, UNKNOWN);
    }

    private static String[] getStringList(String property, String separator) {
        String value = SystemProperties.get(property);
        if (value.isEmpty()) {
            return new String[0];
        }
        return value.split(separator);
    }

    private static long getLong(String property) {
        try {
            return Long.parseLong(SystemProperties.get(property));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    static /* synthetic */ String access$000(String x0) {
        return Build.getString(x0);
    }

    static /* synthetic */ String[] access$100(String x0, String x1) {
        return Build.getStringList(x0, x1);
    }

    static {
        MANUFACTURER = Build.getString("ro.product.manufacturer");
        BRAND = Build.getString("ro.product.brand");
        MODEL = Build.getString("ro.product.model");
        BOOTLOADER = Build.getString("ro.bootloader");
        RADIO = Build.getString("gsm.version.baseband");
        HARDWARE = Build.getString("ro.hardware");
        SERIAL = Build.getString("ro.serialno");
        SUPPORTED_ABIS = Build.getStringList("ro.product.cpu.abilist", ",");
        SUPPORTED_32_BIT_ABIS = Build.getStringList("ro.product.cpu.abilist32", ",");
        SUPPORTED_64_BIT_ABIS = Build.getStringList("ro.product.cpu.abilist64", ",");
        String[] abiList = VMRuntime.getRuntime().is64Bit() ? SUPPORTED_64_BIT_ABIS : SUPPORTED_32_BIT_ABIS;
        CPU_ABI = abiList[0];
        CPU_ABI2 = abiList.length > 1 ? abiList[1] : "";
        TYPE = Build.getString("ro.build.type");
        TAGS = Build.getString("ro.build.tags");
        FINGERPRINT = Build.deriveFingerprint();
        TIME = Build.getLong("ro.build.date.utc") * 1000L;
        USER = Build.getString("ro.build.user");
        HOST = Build.getString("ro.build.host");
        IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;
    }

    public static class VERSION_CODES {
        public static final int CUR_DEVELOPMENT = 10000;
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
        public static final int HONEYCOMB = 11;
        public static final int HONEYCOMB_MR1 = 12;
        public static final int HONEYCOMB_MR2 = 13;
        public static final int ICE_CREAM_SANDWICH = 14;
        public static final int ICE_CREAM_SANDWICH_MR1 = 15;
        public static final int JELLY_BEAN = 16;
        public static final int JELLY_BEAN_MR1 = 17;
        public static final int JELLY_BEAN_MR2 = 18;
        public static final int KITKAT = 19;
        public static final int KITKAT_WATCH = 20;
        public static final int L = 21;
        public static final int LOLLIPOP = 21;
        public static final int LOLLIPOP_MR1 = 22;
        public static final int M = 23;
    }

    public static class VERSION {
        public static final String INCREMENTAL = Build.access$000("ro.build.version.incremental");
        public static final String RELEASE = Build.access$000("ro.build.version.release");
        public static final String BASE_OS = SystemProperties.get("ro.build.version.base_os", "");
        public static final String SECURITY_PATCH = SystemProperties.get("ro.build.version.security_patch", "");
        @Deprecated
        public static final String SDK = Build.access$000("ro.build.version.sdk");
        public static final int SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
        public static final int PREVIEW_SDK_INT = SystemProperties.getInt("ro.build.version.preview_sdk", 0);
        public static final String CODENAME = Build.access$000("ro.build.version.codename");
        private static final String[] ALL_CODENAMES = Build.access$100("ro.build.version.all_codenames", ",");
        public static final String[] ACTIVE_CODENAMES = "REL".equals(ALL_CODENAMES[0]) ? new String[]{} : ALL_CODENAMES;
        public static final int RESOURCES_SDK_INT = SDK_INT + ACTIVE_CODENAMES.length;
    }
}

