/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.app.admin.DevicePolicyManager;
import android.content.ActivityNotFoundException;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.net.Uri;
import android.os.Process;
import android.os.UserHandle;
import android.provider.ContactsContract;
import android.text.TextUtils;
import android.widget.Toast;
import java.util.List;

public class ContactsInternal {
    private static final UriMatcher sContactsUriMatcher;
    private static final int CONTACTS_URI_LOOKUP_ID = 1000;

    private ContactsInternal() {
    }

    public static void startQuickContactWithErrorToast(Context context, Intent intent) {
        Uri uri = intent.getData();
        int match = sContactsUriMatcher.match(uri);
        switch (match) {
            case 1000: {
                if (!ContactsInternal.maybeStartManagedQuickContact(context, intent)) break;
                return;
            }
        }
        ContactsInternal.startQuickContactWithErrorToastForUser(context, intent, Process.myUserHandle());
    }

    public static void startQuickContactWithErrorToastForUser(Context context, Intent intent, UserHandle user) {
        try {
            context.startActivityAsUser(intent, user);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText(context, 17039959, 0).show();
        }
    }

    private static boolean maybeStartManagedQuickContact(Context context, Intent originalIntent) {
        Uri uri = originalIntent.getData();
        List<String> pathSegments = uri.getPathSegments();
        long contactId = ContentUris.parseId(uri);
        String lookupKey = pathSegments.get(2);
        if (TextUtils.isEmpty(lookupKey) || !lookupKey.startsWith(ContactsContract.Contacts.ENTERPRISE_CONTACT_LOOKUP_PREFIX)) {
            return false;
        }
        DevicePolicyManager dpm = context.getSystemService(DevicePolicyManager.class);
        String actualLookupKey = lookupKey.substring(ContactsContract.Contacts.ENTERPRISE_CONTACT_LOOKUP_PREFIX.length());
        long actualContactId = contactId - ContactsContract.Contacts.ENTERPRISE_CONTACT_ID_BASE;
        dpm.startManagedQuickContact(actualLookupKey, actualContactId, originalIntent);
        return true;
    }

    static {
        UriMatcher matcher = sContactsUriMatcher = new UriMatcher(-1);
        matcher.addURI("com.android.contacts", "contacts/lookup/*/#", 1000);
    }
}

