/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.os.Trace;
import android.renderscript.AllocationAdapter;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import android.util.Log;
import android.view.Surface;
import java.lang.reflect.Array;
import java.util.HashMap;

public class Allocation
extends BaseObj {
    Type mType;
    Bitmap mBitmap;
    int mUsage;
    Allocation mAdaptedAllocation;
    int mSize;
    boolean mReadAllowed = true;
    boolean mWriteAllowed = true;
    boolean mAutoPadding = false;
    int mSelectedX;
    int mSelectedY;
    int mSelectedZ;
    int mSelectedLOD;
    int[] mSelectedArray;
    Type.CubemapFace mSelectedFace = Type.CubemapFace.POSITIVE_X;
    int mCurrentDimX;
    int mCurrentDimY;
    int mCurrentDimZ;
    int mCurrentCount;
    static HashMap<Long, Allocation> mAllocationMap = new HashMap();
    OnBufferAvailableListener mBufferNotifier;
    private Surface mGetSurfaceSurface = null;
    public static final int USAGE_SCRIPT = 1;
    public static final int USAGE_GRAPHICS_TEXTURE = 2;
    public static final int USAGE_GRAPHICS_VERTEX = 4;
    public static final int USAGE_GRAPHICS_CONSTANTS = 8;
    public static final int USAGE_GRAPHICS_RENDER_TARGET = 16;
    public static final int USAGE_IO_INPUT = 32;
    public static final int USAGE_IO_OUTPUT = 64;
    public static final int USAGE_SHARED = 128;
    static BitmapFactory.Options mBitmapOptions = new BitmapFactory.Options();

    private Element.DataType validateObjectIsPrimitiveArray(Object d, boolean checkType) {
        Class<?> c = d.getClass();
        if (!c.isArray()) {
            throw new RSIllegalArgumentException("Object passed is not an array of primitives.");
        }
        Class<?> cmp = c.getComponentType();
        if (!cmp.isPrimitive()) {
            throw new RSIllegalArgumentException("Object passed is not an Array of primitives.");
        }
        if (cmp == Long.TYPE) {
            if (checkType) {
                this.validateIsInt64();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_64;
        }
        if (cmp == Integer.TYPE) {
            if (checkType) {
                this.validateIsInt32();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_32;
        }
        if (cmp == Short.TYPE) {
            if (checkType) {
                this.validateIsInt16();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_16;
        }
        if (cmp == Byte.TYPE) {
            if (checkType) {
                this.validateIsInt8();
                return this.mType.mElement.mType;
            }
            return Element.DataType.SIGNED_8;
        }
        if (cmp == Float.TYPE) {
            if (checkType) {
                this.validateIsFloat32();
            }
            return Element.DataType.FLOAT_32;
        }
        if (cmp == Double.TYPE) {
            if (checkType) {
                this.validateIsFloat64();
            }
            return Element.DataType.FLOAT_64;
        }
        return null;
    }

    private long getIDSafe() {
        if (this.mAdaptedAllocation != null) {
            return this.mAdaptedAllocation.getID(this.mRS);
        }
        return this.getID(this.mRS);
    }

    public Element getElement() {
        return this.mType.getElement();
    }

    public int getUsage() {
        return this.mUsage;
    }

    public void setAutoPadding(boolean useAutoPadding) {
        this.mAutoPadding = useAutoPadding;
    }

    public int getBytesSize() {
        if (this.mType.mDimYuv != 0) {
            return (int)Math.ceil((double)(this.mType.getCount() * this.mType.getElement().getBytesSize()) * 1.5);
        }
        return this.mType.getCount() * this.mType.getElement().getBytesSize();
    }

    private void updateCacheInfo(Type t) {
        this.mCurrentDimX = t.getX();
        this.mCurrentDimY = t.getY();
        this.mCurrentDimZ = t.getZ();
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
    }

    private void setBitmap(Bitmap b) {
        this.mBitmap = b;
    }

    Allocation(long id2, RenderScript rs, Type t, int usage) {
        super(id2, rs);
        if ((usage & 0xFFFFFF00) != 0) {
            throw new RSIllegalArgumentException("Unknown usage specified.");
        }
        if ((usage & 0x20) != 0) {
            this.mWriteAllowed = false;
            if ((usage & 0xFFFFFFDC) != 0) {
                throw new RSIllegalArgumentException("Invalid usage combination.");
            }
        }
        this.mType = t;
        this.mUsage = usage;
        if (t != null) {
            this.mSize = this.mType.getCount() * this.mType.getElement().getBytesSize();
            this.updateCacheInfo(t);
        }
        try {
            RenderScript.registerNativeAllocation.invoke(RenderScript.sRuntime, this.mSize);
        }
        catch (Exception e) {
            Log.e("RenderScript_jni", "Couldn't invoke registerNativeAllocation:" + e);
            throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + e);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        RenderScript.registerNativeFree.invoke(RenderScript.sRuntime, this.mSize);
        super.finalize();
    }

    private void validateIsInt64() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_64 || this.mType.mElement.mType == Element.DataType.UNSIGNED_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt32() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_32 || this.mType.mElement.mType == Element.DataType.UNSIGNED_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt16() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_16 || this.mType.mElement.mType == Element.DataType.UNSIGNED_16) {
            return;
        }
        throw new RSIllegalArgumentException("16 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsInt8() {
        if (this.mType.mElement.mType == Element.DataType.SIGNED_8 || this.mType.mElement.mType == Element.DataType.UNSIGNED_8) {
            return;
        }
        throw new RSIllegalArgumentException("8 bit integer source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsFloat32() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_32) {
            return;
        }
        throw new RSIllegalArgumentException("32 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsFloat64() {
        if (this.mType.mElement.mType == Element.DataType.FLOAT_64) {
            return;
        }
        throw new RSIllegalArgumentException("64 bit float source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    private void validateIsObject() {
        if (this.mType.mElement.mType == Element.DataType.RS_ELEMENT || this.mType.mElement.mType == Element.DataType.RS_TYPE || this.mType.mElement.mType == Element.DataType.RS_ALLOCATION || this.mType.mElement.mType == Element.DataType.RS_SAMPLER || this.mType.mElement.mType == Element.DataType.RS_SCRIPT || this.mType.mElement.mType == Element.DataType.RS_MESH || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_FRAGMENT || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_VERTEX || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_RASTER || this.mType.mElement.mType == Element.DataType.RS_PROGRAM_STORE) {
            return;
        }
        throw new RSIllegalArgumentException("Object source does not match allocation type " + (Object)((Object)this.mType.mElement.mType));
    }

    @Override
    void updateFromNative() {
        super.updateFromNative();
        long typeID = this.mRS.nAllocationGetType(this.getID(this.mRS));
        if (typeID != 0L) {
            this.mType = new Type(typeID, this.mRS);
            this.mType.updateFromNative();
            this.updateCacheInfo(this.mType);
        }
    }

    public Type getType() {
        return this.mType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncAll(int srcLocation) {
        try {
            Trace.traceBegin(32768L, "syncAll");
            switch (srcLocation) {
                case 1: 
                case 2: {
                    if ((this.mUsage & 0x80) == 0) break;
                    this.copyFrom(this.mBitmap);
                    break;
                }
                case 4: 
                case 8: {
                    break;
                }
                case 128: {
                    if ((this.mUsage & 0x80) == 0) break;
                    this.copyTo(this.mBitmap);
                    break;
                }
                default: {
                    throw new RSIllegalArgumentException("Source must be exactly one usage type.");
                }
            }
            this.mRS.validate();
            this.mRS.nAllocationSyncAll(this.getIDSafe(), srcLocation);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ioSend() {
        try {
            Trace.traceBegin(32768L, "ioSend");
            if ((this.mUsage & 0x40) == 0) {
                throw new RSIllegalArgumentException("Can only send buffer if IO_OUTPUT usage specified.");
            }
            this.mRS.validate();
            this.mRS.nAllocationIoSend(this.getID(this.mRS));
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ioReceive() {
        try {
            Trace.traceBegin(32768L, "ioReceive");
            if ((this.mUsage & 0x20) == 0) {
                throw new RSIllegalArgumentException("Can only receive if IO_INPUT usage specified.");
            }
            this.mRS.validate();
            this.mRS.nAllocationIoReceive(this.getID(this.mRS));
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(BaseObj[] d) {
        try {
            Trace.traceBegin(32768L, "copyFrom");
            this.mRS.validate();
            this.validateIsObject();
            if (d.length != this.mCurrentCount) {
                throw new RSIllegalArgumentException("Array size mismatch, allocation sizeX = " + this.mCurrentCount + ", array length = " + d.length);
            }
            if (RenderScript.sPointerSize == 8) {
                long[] i = new long[d.length * 4];
                for (int ct = 0; ct < d.length; ++ct) {
                    i[ct * 4] = d[ct].getID(this.mRS);
                }
                this.copy1DRangeFromUnchecked(0, this.mCurrentCount, (Object)i);
            } else {
                int[] i = new int[d.length];
                for (int ct = 0; ct < d.length; ++ct) {
                    i[ct] = (int)d[ct].getID(this.mRS);
                }
                this.copy1DRangeFromUnchecked(0, this.mCurrentCount, i);
            }
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    private void validateBitmapFormat(Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == null) {
            throw new RSIllegalArgumentException("Bitmap has an unsupported format for this operation");
        }
        switch (bc) {
            case ALPHA_8: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_A) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case ARGB_8888: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 4) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case RGB_565: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGB && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
            case ARGB_4444: {
                if (this.mType.getElement().mKind == Element.DataKind.PIXEL_RGBA && this.mType.getElement().getBytesSize() == 2) break;
                throw new RSIllegalArgumentException("Allocation kind is " + (Object)((Object)this.mType.getElement().mKind) + ", type " + (Object)((Object)this.mType.getElement().mType) + " of " + this.mType.getElement().getBytesSize() + " bytes, passed bitmap was " + (Object)((Object)bc));
            }
        }
    }

    private void validateBitmapSize(Bitmap b) {
        if (this.mCurrentDimX != b.getWidth() || this.mCurrentDimY != b.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFromUnchecked(Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copyFromUnchecked");
            this.mRS.validate();
            if (this.mCurrentDimZ > 0) {
                this.copy3DRangeFromUnchecked(0, 0, 0, this.mCurrentDimX, this.mCurrentDimY, this.mCurrentDimZ, array2, dt, arrayLen);
            } else if (this.mCurrentDimY > 0) {
                this.copy2DRangeFromUnchecked(0, 0, this.mCurrentDimX, this.mCurrentDimY, array2, dt, arrayLen);
            } else {
                this.copy1DRangeFromUnchecked(0, this.mCurrentCount, array2, dt, arrayLen);
            }
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFromUnchecked(Object array2) {
        try {
            Trace.traceBegin(32768L, "copyFromUnchecked");
            this.copyFromUnchecked(array2, this.validateObjectIsPrimitiveArray(array2, false), Array.getLength(array2));
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copyFromUnchecked(int[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_32, d.length);
    }

    public void copyFromUnchecked(short[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_16, d.length);
    }

    public void copyFromUnchecked(byte[] d) {
        this.copyFromUnchecked(d, Element.DataType.SIGNED_8, d.length);
    }

    public void copyFromUnchecked(float[] d) {
        this.copyFromUnchecked(d, Element.DataType.FLOAT_32, d.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(Object array2) {
        try {
            Trace.traceBegin(32768L, "copyFrom");
            this.copyFromUnchecked(array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copyFrom(int[] d) {
        this.validateIsInt32();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_32, d.length);
    }

    public void copyFrom(short[] d) {
        this.validateIsInt16();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_16, d.length);
    }

    public void copyFrom(byte[] d) {
        this.validateIsInt8();
        this.copyFromUnchecked(d, Element.DataType.SIGNED_8, d.length);
    }

    public void copyFrom(float[] d) {
        this.validateIsFloat32();
        this.copyFromUnchecked(d, Element.DataType.FLOAT_32, d.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(Bitmap b) {
        try {
            Trace.traceBegin(32768L, "copyFrom");
            this.mRS.validate();
            if (b.getConfig() == null) {
                Bitmap newBitmap = Bitmap.createBitmap(b.getWidth(), b.getHeight(), Bitmap.Config.ARGB_8888);
                Canvas c = new Canvas(newBitmap);
                c.drawBitmap(b, 0.0f, 0.0f, null);
                this.copyFrom(newBitmap);
                return;
            }
            this.validateBitmapSize(b);
            this.validateBitmapFormat(b);
            this.mRS.nAllocationCopyFromBitmap(this.getID(this.mRS), b);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(Allocation a) {
        try {
            Trace.traceBegin(32768L, "copyFrom");
            this.mRS.validate();
            if (!this.mType.equals(a.getType())) {
                throw new RSIllegalArgumentException("Types of allocations must match.");
            }
            this.copy2DRangeFrom(0, 0, this.mCurrentDimX, this.mCurrentDimY, a, 0, 0);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void setFromFieldPacker(int xoff, FieldPacker fp) {
        this.mRS.validate();
        int eSize = this.mType.mElement.getBytesSize();
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int count = data_length / eSize;
        if (eSize * count != data_length) {
            throw new RSIllegalArgumentException("Field packer length " + data_length + " not divisible by element size " + eSize + ".");
        }
        this.copy1DRangeFromUnchecked(xoff, count, data);
    }

    public void setFromFieldPacker(int xoff, int component_number, FieldPacker fp) {
        this.setFromFieldPacker(xoff, 0, 0, component_number, fp);
    }

    public void setFromFieldPacker(int xoff, int yoff, int zoff, int component_number, FieldPacker fp) {
        this.mRS.validate();
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset x must be >= 0.");
        }
        if (yoff < 0) {
            throw new RSIllegalArgumentException("Offset y must be >= 0.");
        }
        if (zoff < 0) {
            throw new RSIllegalArgumentException("Offset z must be >= 0.");
        }
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int eSize = this.mType.mElement.mElements[component_number].getBytesSize();
        if (data_length != (eSize *= this.mType.mElement.mArraySizes[component_number])) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data_length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementData(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, component_number, data, data_length);
    }

    private void data1DChecks(int off, int count, int len, int dataSize, boolean usePadding) {
        this.mRS.validate();
        if (off < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (count < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (off + count > this.mCurrentCount) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mCurrentCount + ", got " + count + " at offset " + off + ".");
        }
        if (usePadding ? len < dataSize / 4 * 3 : len < dataSize) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    public void generateMipmaps() {
        this.mRS.nAllocationGenerateMipmaps(this.getID(this.mRS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy1DRangeFromUnchecked(int off, int count, Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copy1DRangeFromUnchecked");
            int dataSize = this.mType.mElement.getBytesSize() * count;
            boolean usePadding = false;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                usePadding = true;
            }
            this.data1DChecks(off, count, arrayLen * dt.mSize, dataSize, usePadding);
            this.mRS.nAllocationData1D(this.getIDSafe(), off, this.mSelectedLOD, count, array2, dataSize, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copy1DRangeFromUnchecked(int off, int count, Object array2) {
        this.copy1DRangeFromUnchecked(off, count, array2, this.validateObjectIsPrimitiveArray(array2, false), Array.getLength(array2));
    }

    public void copy1DRangeFromUnchecked(int off, int count, int[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeFromUnchecked(int off, int count, short[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeFromUnchecked(int off, int count, byte[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeFromUnchecked(int off, int count, float[] d) {
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    public void copy1DRangeFrom(int off, int count, Object array2) {
        this.copy1DRangeFromUnchecked(off, count, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    public void copy1DRangeFrom(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeFrom(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeFrom(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeFrom(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeFromUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    public void copy1DRangeFrom(int off, int count, Allocation data, int dataOff) {
        Trace.traceBegin(32768L, "copy1DRangeFrom");
        this.mRS.nAllocationData2D(this.getIDSafe(), off, 0, this.mSelectedLOD, this.mSelectedFace.mID, count, 1, data.getID(this.mRS), dataOff, 0, data.mSelectedLOD, data.mSelectedFace.mID);
        Trace.traceEnd(32768L);
    }

    private void validate2DRange(int xoff, int yoff, int w, int h) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copy2DRangeFromUnchecked(int xoff, int yoff, int w, int h, Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copy2DRangeFromUnchecked");
            this.mRS.validate();
            this.validate2DRange(xoff, yoff, w, h);
            int dataSize = this.mType.mElement.getBytesSize() * w * h;
            boolean usePadding = false;
            int sizeBytes = arrayLen * dt.mSize;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                if (dataSize / 4 * 3 > sizeBytes) {
                    throw new RSIllegalArgumentException("Array too small for allocation type.");
                }
                usePadding = true;
                sizeBytes = dataSize;
            } else if (dataSize > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, array2, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Object array2) {
        try {
            Trace.traceBegin(32768L, "copy2DRangeFrom");
            this.copy2DRangeFromUnchecked(xoff, yoff, w, h, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, byte[] data) {
        this.validateIsInt8();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_8, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, short[] data) {
        this.validateIsInt16();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_16, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, int[] data) {
        this.validateIsInt32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_32, data.length);
    }

    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, float[] data) {
        this.validateIsFloat32();
        this.copy2DRangeFromUnchecked(xoff, yoff, w, h, data, Element.DataType.FLOAT_32, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy2DRangeFrom(int xoff, int yoff, int w, int h, Allocation data, int dataXoff, int dataYoff) {
        try {
            Trace.traceBegin(32768L, "copy2DRangeFrom");
            this.mRS.validate();
            this.validate2DRange(xoff, yoff, w, h);
            this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, data.getID(this.mRS), dataXoff, dataYoff, data.mSelectedLOD, data.mSelectedFace.mID);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy2DRangeFrom(int xoff, int yoff, Bitmap data) {
        try {
            Trace.traceBegin(32768L, "copy2DRangeFrom");
            this.mRS.validate();
            if (data.getConfig() == null) {
                Bitmap newBitmap = Bitmap.createBitmap(data.getWidth(), data.getHeight(), Bitmap.Config.ARGB_8888);
                Canvas c = new Canvas(newBitmap);
                c.drawBitmap(data, 0.0f, 0.0f, null);
                this.copy2DRangeFrom(xoff, yoff, newBitmap);
                return;
            }
            this.validateBitmapFormat(data);
            this.validate2DRange(xoff, yoff, data.getWidth(), data.getHeight());
            this.mRS.nAllocationData2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, data);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    private void validate3DRange(int xoff, int yoff, int zoff, int w, int h, int d) {
        if (this.mAdaptedAllocation == null) {
            if (xoff < 0 || yoff < 0 || zoff < 0) {
                throw new RSIllegalArgumentException("Offset cannot be negative.");
            }
            if (h < 0 || w < 0 || d < 0) {
                throw new RSIllegalArgumentException("Height or width cannot be negative.");
            }
            if (xoff + w > this.mCurrentDimX || yoff + h > this.mCurrentDimY || zoff + d > this.mCurrentDimZ) {
                throw new RSIllegalArgumentException("Updated region larger than allocation.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy3DRangeFromUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copy3DRangeFromUnchecked");
            this.mRS.validate();
            this.validate3DRange(xoff, yoff, zoff, w, h, d);
            int dataSize = this.mType.mElement.getBytesSize() * w * h * d;
            boolean usePadding = false;
            int sizeBytes = arrayLen * dt.mSize;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                if (dataSize / 4 * 3 > sizeBytes) {
                    throw new RSIllegalArgumentException("Array too small for allocation type.");
                }
                usePadding = true;
                sizeBytes = dataSize;
            } else if (dataSize > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, array2, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Object array2) {
        try {
            Trace.traceBegin(32768L, "copy3DRangeFrom");
            this.copy3DRangeFromUnchecked(xoff, yoff, zoff, w, h, d, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copy3DRangeFrom(int xoff, int yoff, int zoff, int w, int h, int d, Allocation data, int dataXoff, int dataYoff, int dataZoff) {
        this.mRS.validate();
        this.validate3DRange(xoff, yoff, zoff, w, h, d);
        this.mRS.nAllocationData3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, data.getID(this.mRS), dataXoff, dataYoff, dataZoff, data.mSelectedLOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(Bitmap b) {
        try {
            Trace.traceBegin(32768L, "copyTo");
            this.mRS.validate();
            this.validateBitmapFormat(b);
            this.validateBitmapSize(b);
            this.mRS.nAllocationCopyToBitmap(this.getID(this.mRS), b);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyTo(Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copyTo");
            this.mRS.validate();
            boolean usePadding = false;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                usePadding = true;
            }
            if (usePadding ? dt.mSize * arrayLen < this.mSize / 4 * 3 : dt.mSize * arrayLen < this.mSize) {
                throw new RSIllegalArgumentException("Size of output array cannot be smaller than size of allocation.");
            }
            this.mRS.nAllocationRead(this.getID(this.mRS), array2, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copyTo(Object array2) {
        this.copyTo(array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    public void copyTo(byte[] d) {
        this.validateIsInt8();
        this.copyTo(d, Element.DataType.SIGNED_8, d.length);
    }

    public void copyTo(short[] d) {
        this.validateIsInt16();
        this.copyTo(d, Element.DataType.SIGNED_16, d.length);
    }

    public void copyTo(int[] d) {
        this.validateIsInt32();
        this.copyTo(d, Element.DataType.SIGNED_32, d.length);
    }

    public void copyTo(float[] d) {
        this.validateIsFloat32();
        this.copyTo(d, Element.DataType.FLOAT_32, d.length);
    }

    public void copyToFieldPacker(int xoff, int yoff, int zoff, int component_number, FieldPacker fp) {
        this.mRS.validate();
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset x must be >= 0.");
        }
        if (yoff < 0) {
            throw new RSIllegalArgumentException("Offset y must be >= 0.");
        }
        if (zoff < 0) {
            throw new RSIllegalArgumentException("Offset z must be >= 0.");
        }
        byte[] data = fp.getData();
        int data_length = fp.getPos();
        int eSize = this.mType.mElement.mElements[component_number].getBytesSize();
        if (data_length != (eSize *= this.mType.mElement.mArraySizes[component_number])) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data_length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementRead(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, component_number, data, data_length);
    }

    public synchronized void resize(int dimX) {
        if (this.mRS.getApplicationContext().getApplicationInfo().targetSdkVersion >= 21) {
            throw new RSRuntimeException("Resize is not allowed in API 21+.");
        }
        if (this.mType.getY() > 0 || this.mType.getZ() > 0 || this.mType.hasFaces() || this.mType.hasMipmaps()) {
            throw new RSInvalidStateException("Resize only support for 1D allocations at this time.");
        }
        this.mRS.nAllocationResize1D(this.getID(this.mRS), dimX);
        this.mRS.finish();
        long typeID = this.mRS.nAllocationGetType(this.getID(this.mRS));
        this.mType = new Type(typeID, this.mRS);
        this.mType.updateFromNative();
        this.updateCacheInfo(this.mType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy1DRangeToUnchecked(int off, int count, Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copy1DRangeToUnchecked");
            int dataSize = this.mType.mElement.getBytesSize() * count;
            boolean usePadding = false;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                usePadding = true;
            }
            this.data1DChecks(off, count, arrayLen * dt.mSize, dataSize, usePadding);
            this.mRS.nAllocationRead1D(this.getIDSafe(), off, this.mSelectedLOD, count, array2, dataSize, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copy1DRangeToUnchecked(int off, int count, Object array2) {
        this.copy1DRangeToUnchecked(off, count, array2, this.validateObjectIsPrimitiveArray(array2, false), Array.getLength(array2));
    }

    public void copy1DRangeToUnchecked(int off, int count, int[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeToUnchecked(int off, int count, short[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeToUnchecked(int off, int count, byte[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeToUnchecked(int off, int count, float[] d) {
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    public void copy1DRangeTo(int off, int count, Object array2) {
        this.copy1DRangeToUnchecked(off, count, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    public void copy1DRangeTo(int off, int count, int[] d) {
        this.validateIsInt32();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_32, d.length);
    }

    public void copy1DRangeTo(int off, int count, short[] d) {
        this.validateIsInt16();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_16, d.length);
    }

    public void copy1DRangeTo(int off, int count, byte[] d) {
        this.validateIsInt8();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.SIGNED_8, d.length);
    }

    public void copy1DRangeTo(int off, int count, float[] d) {
        this.validateIsFloat32();
        this.copy1DRangeToUnchecked(off, count, d, Element.DataType.FLOAT_32, d.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copy2DRangeToUnchecked(int xoff, int yoff, int w, int h, Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copy2DRangeToUnchecked");
            this.mRS.validate();
            this.validate2DRange(xoff, yoff, w, h);
            int dataSize = this.mType.mElement.getBytesSize() * w * h;
            boolean usePadding = false;
            int sizeBytes = arrayLen * dt.mSize;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                if (dataSize / 4 * 3 > sizeBytes) {
                    throw new RSIllegalArgumentException("Array too small for allocation type.");
                }
                usePadding = true;
                sizeBytes = dataSize;
            } else if (dataSize > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            this.mRS.nAllocationRead2D(this.getIDSafe(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, array2, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, Object array2) {
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, byte[] data) {
        this.validateIsInt8();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_8, data.length);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, short[] data) {
        this.validateIsInt16();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_16, data.length);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, int[] data) {
        this.validateIsInt32();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.SIGNED_32, data.length);
    }

    public void copy2DRangeTo(int xoff, int yoff, int w, int h, float[] data) {
        this.validateIsFloat32();
        this.copy2DRangeToUnchecked(xoff, yoff, w, h, data, Element.DataType.FLOAT_32, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy3DRangeToUnchecked(int xoff, int yoff, int zoff, int w, int h, int d, Object array2, Element.DataType dt, int arrayLen) {
        try {
            Trace.traceBegin(32768L, "copy3DRangeToUnchecked");
            this.mRS.validate();
            this.validate3DRange(xoff, yoff, zoff, w, h, d);
            int dataSize = this.mType.mElement.getBytesSize() * w * h * d;
            boolean usePadding = false;
            int sizeBytes = arrayLen * dt.mSize;
            if (this.mAutoPadding && this.mType.getElement().getVectorSize() == 3) {
                if (dataSize / 4 * 3 > sizeBytes) {
                    throw new RSIllegalArgumentException("Array too small for allocation type.");
                }
                usePadding = true;
                sizeBytes = dataSize;
            } else if (dataSize > sizeBytes) {
                throw new RSIllegalArgumentException("Array too small for allocation type.");
            }
            this.mRS.nAllocationRead3D(this.getIDSafe(), xoff, yoff, zoff, this.mSelectedLOD, w, h, d, array2, sizeBytes, dt, this.mType.mElement.mType.mSize, usePadding);
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public void copy3DRangeTo(int xoff, int yoff, int zoff, int w, int h, int d, Object array2) {
        this.copy3DRangeToUnchecked(xoff, yoff, zoff, w, h, d, array2, this.validateObjectIsPrimitiveArray(array2, true), Array.getLength(array2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Allocation createTyped(RenderScript rs, Type type, MipmapControl mips, int usage) {
        try {
            Trace.traceBegin(32768L, "createTyped");
            rs.validate();
            if (type.getID(rs) == 0L) {
                throw new RSInvalidStateException("Bad Type");
            }
            long id2 = rs.nAllocationCreateTyped(type.getID(rs), mips.mID, usage, 0L);
            if (id2 == 0L) {
                throw new RSRuntimeException("Allocation creation failed.");
            }
            Allocation allocation = new Allocation(id2, rs, type, usage);
            return allocation;
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public static Allocation createTyped(RenderScript rs, Type type, int usage) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, usage);
    }

    public static Allocation createTyped(RenderScript rs, Type type) {
        return Allocation.createTyped(rs, type, MipmapControl.MIPMAP_NONE, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Allocation createSized(RenderScript rs, Element e, int count, int usage) {
        try {
            Trace.traceBegin(32768L, "createSized");
            rs.validate();
            Type.Builder b = new Type.Builder(rs, e);
            b.setX(count);
            Type t = b.create();
            long id2 = rs.nAllocationCreateTyped(t.getID(rs), MipmapControl.MIPMAP_NONE.mID, usage, 0L);
            if (id2 == 0L) {
                throw new RSRuntimeException("Allocation creation failed.");
            }
            Allocation allocation = new Allocation(id2, rs, t, usage);
            return allocation;
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public static Allocation createSized(RenderScript rs, Element e, int count) {
        return Allocation.createSized(rs, e, count, 1);
    }

    static Element elementFromBitmap(RenderScript rs, Bitmap b) {
        Bitmap.Config bc = b.getConfig();
        if (bc == Bitmap.Config.ALPHA_8) {
            return Element.A_8(rs);
        }
        if (bc == Bitmap.Config.ARGB_4444) {
            return Element.RGBA_4444(rs);
        }
        if (bc == Bitmap.Config.ARGB_8888) {
            return Element.RGBA_8888(rs);
        }
        if (bc == Bitmap.Config.RGB_565) {
            return Element.RGB_565(rs);
        }
        throw new RSInvalidStateException("Bad bitmap type: " + (Object)((Object)bc));
    }

    static Type typeFromBitmap(RenderScript rs, Bitmap b, MipmapControl mip) {
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(b.getWidth());
        tb.setY(b.getHeight());
        tb.setMipmaps(mip == MipmapControl.MIPMAP_FULL);
        return tb.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Allocation createFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        try {
            Trace.traceBegin(32768L, "createFromBitmap");
            rs.validate();
            if (b.getConfig() == null) {
                if ((usage & 0x80) != 0) {
                    throw new RSIllegalArgumentException("USAGE_SHARED cannot be used with a Bitmap that has a null config.");
                }
                Bitmap newBitmap = Bitmap.createBitmap(b.getWidth(), b.getHeight(), Bitmap.Config.ARGB_8888);
                Canvas c = new Canvas(newBitmap);
                c.drawBitmap(b, 0.0f, 0.0f, null);
                Allocation allocation = Allocation.createFromBitmap(rs, newBitmap, mips, usage);
                return allocation;
            }
            Type t = Allocation.typeFromBitmap(rs, b, mips);
            if (mips == MipmapControl.MIPMAP_NONE && t.getElement().isCompatible(Element.RGBA_8888(rs)) && usage == 131) {
                long id2 = rs.nAllocationCreateBitmapBackedAllocation(t.getID(rs), mips.mID, b, usage);
                if (id2 == 0L) {
                    throw new RSRuntimeException("Load failed.");
                }
                Allocation alloc = new Allocation(id2, rs, t, usage);
                alloc.setBitmap(b);
                Allocation allocation = alloc;
                return allocation;
            }
            long id3 = rs.nAllocationCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
            if (id3 == 0L) {
                throw new RSRuntimeException("Load failed.");
            }
            Allocation allocation = new Allocation(id3, rs, t, usage);
            return allocation;
        }
        finally {
            Trace.traceEnd(32768L);
        }
    }

    public Surface getSurface() {
        if ((this.mUsage & 0x20) == 0) {
            throw new RSInvalidStateException("Allocation is not a surface texture.");
        }
        if (this.mGetSurfaceSurface == null) {
            this.mGetSurfaceSurface = this.mRS.nAllocationGetSurface(this.getID(this.mRS));
        }
        return this.mGetSurfaceSurface;
    }

    public void setSurface(Surface sur) {
        this.mRS.validate();
        if ((this.mUsage & 0x40) == 0) {
            throw new RSInvalidStateException("Allocation is not USAGE_IO_OUTPUT.");
        }
        this.mRS.nAllocationSetSurface(this.getID(this.mRS), sur);
    }

    public static Allocation createFromBitmap(RenderScript rs, Bitmap b) {
        if (rs.getApplicationContext().getApplicationInfo().targetSdkVersion >= 18) {
            return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 131);
        }
        return Allocation.createFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b, MipmapControl mips, int usage) {
        boolean isPow2;
        rs.validate();
        int height = b.getHeight();
        int width = b.getWidth();
        if (width % 6 != 0) {
            throw new RSIllegalArgumentException("Cubemap height must be multiple of 6");
        }
        if (width / 6 != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, b);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        long id2 = rs.nAllocationCubeCreateFromBitmap(t.getID(rs), mips.mID, b, usage);
        if (id2 == 0L) {
            throw new RSRuntimeException("Load failed for bitmap " + b + " element " + e);
        }
        return new Allocation(id2, rs, t, usage);
    }

    public static Allocation createCubemapFromBitmap(RenderScript rs, Bitmap b) {
        return Allocation.createCubemapFromBitmap(rs, b, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg, MipmapControl mips, int usage) {
        boolean isPow2;
        int height = xpos.getHeight();
        if (xpos.getWidth() != height || xneg.getWidth() != height || xneg.getHeight() != height || ypos.getWidth() != height || ypos.getHeight() != height || yneg.getWidth() != height || yneg.getHeight() != height || zpos.getWidth() != height || zpos.getHeight() != height || zneg.getWidth() != height || zneg.getHeight() != height) {
            throw new RSIllegalArgumentException("Only square cube map faces supported");
        }
        boolean bl = isPow2 = (height & height - 1) == 0;
        if (!isPow2) {
            throw new RSIllegalArgumentException("Only power of 2 cube faces supported");
        }
        Element e = Allocation.elementFromBitmap(rs, xpos);
        Type.Builder tb = new Type.Builder(rs, e);
        tb.setX(height);
        tb.setY(height);
        tb.setFaces(true);
        tb.setMipmaps(mips == MipmapControl.MIPMAP_FULL);
        Type t = tb.create();
        Allocation cubemap = Allocation.createTyped(rs, t, mips, usage);
        AllocationAdapter adapter = AllocationAdapter.create2D(rs, cubemap);
        adapter.setFace(Type.CubemapFace.POSITIVE_X);
        adapter.copyFrom(xpos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_X);
        adapter.copyFrom(xneg);
        adapter.setFace(Type.CubemapFace.POSITIVE_Y);
        adapter.copyFrom(ypos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_Y);
        adapter.copyFrom(yneg);
        adapter.setFace(Type.CubemapFace.POSITIVE_Z);
        adapter.copyFrom(zpos);
        adapter.setFace(Type.CubemapFace.NEGATIVE_Z);
        adapter.copyFrom(zneg);
        return cubemap;
    }

    public static Allocation createCubemapFromCubeFaces(RenderScript rs, Bitmap xpos, Bitmap xneg, Bitmap ypos, Bitmap yneg, Bitmap zpos, Bitmap zneg) {
        return Allocation.createCubemapFromCubeFaces(rs, xpos, xneg, ypos, yneg, zpos, zneg, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id2, MipmapControl mips, int usage) {
        rs.validate();
        if ((usage & 0xE0) != 0) {
            throw new RSIllegalArgumentException("Unsupported usage specified.");
        }
        Bitmap b = BitmapFactory.decodeResource(res, id2);
        Allocation alloc = Allocation.createFromBitmap(rs, b, mips, usage);
        b.recycle();
        return alloc;
    }

    public static Allocation createFromBitmapResource(RenderScript rs, Resources res, int id2) {
        if (rs.getApplicationContext().getApplicationInfo().targetSdkVersion >= 18) {
            return Allocation.createFromBitmapResource(rs, res, id2, MipmapControl.MIPMAP_NONE, 3);
        }
        return Allocation.createFromBitmapResource(rs, res, id2, MipmapControl.MIPMAP_NONE, 2);
    }

    public static Allocation createFromString(RenderScript rs, String str, int usage) {
        rs.validate();
        byte[] allocArray = null;
        try {
            allocArray = str.getBytes("UTF-8");
            Allocation alloc = Allocation.createSized(rs, Element.U8(rs), allocArray.length, usage);
            alloc.copyFrom(allocArray);
            return alloc;
        }
        catch (Exception e) {
            throw new RSRuntimeException("Could not convert string to utf-8.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnBufferAvailableListener(OnBufferAvailableListener callback) {
        HashMap<Long, Allocation> hashMap = mAllocationMap;
        synchronized (hashMap) {
            mAllocationMap.put(new Long(this.getID(this.mRS)), this);
            this.mBufferNotifier = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sendBufferNotification(long id2) {
        HashMap<Long, Allocation> hashMap = mAllocationMap;
        synchronized (hashMap) {
            Allocation a = mAllocationMap.get(new Long(id2));
            if (a != null && a.mBufferNotifier != null) {
                a.mBufferNotifier.onBufferAvailable(a);
            }
        }
    }

    @Override
    public void destroy() {
        if ((this.mUsage & 0x40) != 0) {
            this.setSurface(null);
        }
        super.destroy();
    }

    static {
        Allocation.mBitmapOptions.inScaled = false;
    }

    public static interface OnBufferAvailableListener {
        public void onBufferAvailable(Allocation var1);
    }

    public static enum MipmapControl {
        MIPMAP_NONE(0),
        MIPMAP_FULL(1),
        MIPMAP_ON_SYNC_TO_TEXTURE(2);

        int mID;

        private MipmapControl(int id2) {
            this.mID = id2;
        }
    }
}

