/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.RenderScriptCacheDir;
import android.renderscript.Script;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ScriptC
extends Script {
    private static final String TAG = "ScriptC";
    private static final String CACHE_PATH = "com.android.renderscript.cache";
    static String mCachePath;

    protected ScriptC(int id2, RenderScript rs) {
        super(id2, rs);
    }

    protected ScriptC(long id2, RenderScript rs) {
        super(id2, rs);
    }

    protected ScriptC(RenderScript rs, Resources resources, int resourceID) {
        super(0L, rs);
        long id2 = ScriptC.internalCreate(rs, resources, resourceID);
        if (id2 == 0L) {
            throw new RSRuntimeException("Loading of ScriptC script failed.");
        }
        this.setID(id2);
    }

    protected ScriptC(RenderScript rs, String resName, byte[] bitcode32, byte[] bitcode64) {
        super(0L, rs);
        long id2 = 0L;
        id2 = RenderScript.sPointerSize == 4 ? ScriptC.internalStringCreate(rs, resName, bitcode32) : ScriptC.internalStringCreate(rs, resName, bitcode64);
        if (id2 == 0L) {
            throw new RSRuntimeException("Loading of ScriptC script failed.");
        }
        this.setID(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized long internalCreate(RenderScript rs, Resources resources, int resourceID) {
        int pgmLength;
        byte[] pgm;
        InputStream is = resources.openRawResource(resourceID);
        try {
            try {
                pgm = new byte[1024];
                pgmLength = 0;
                while (true) {
                    int bytesRead;
                    int bytesLeft;
                    if ((bytesLeft = pgm.length - pgmLength) == 0) {
                        byte[] buf2 = new byte[pgm.length * 2];
                        System.arraycopy((byte[])pgm, (int)0, (byte[])buf2, (int)0, (int)pgm.length);
                        pgm = buf2;
                        bytesLeft = pgm.length - pgmLength;
                    }
                    if ((bytesRead = is.read(pgm, pgmLength, bytesLeft)) <= 0) {
                        break;
                    }
                    pgmLength += bytesRead;
                }
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new Resources.NotFoundException();
        }
        String resName = resources.getResourceEntryName(resourceID);
        if (mCachePath == null) {
            File f = new File(RenderScriptCacheDir.mCacheDir, CACHE_PATH);
            mCachePath = f.getAbsolutePath();
            f.mkdirs();
        }
        return rs.nScriptCCreate(resName, mCachePath, pgm, pgmLength);
    }

    private static synchronized long internalStringCreate(RenderScript rs, String resName, byte[] bitcode) {
        if (mCachePath == null) {
            File f = new File(RenderScriptCacheDir.mCacheDir, CACHE_PATH);
            mCachePath = f.getAbsolutePath();
            f.mkdirs();
        }
        return rs.nScriptCCreate(resName, mCachePath, bitcode, bitcode.length);
    }
}

