/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.OperationResult;
import android.security.keystore.AndroidKeyStoreCipherSpiBase;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.ArrayUtils;
import android.security.keystore.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.GCMParameterSpec;
import libcore.util.EmptyArray;

abstract class AndroidKeyStoreAuthenticatedAESCipherSpi
extends AndroidKeyStoreCipherSpiBase {
    private static final int BLOCK_SIZE_BYTES = 16;
    private final int mKeymasterBlockMode;
    private final int mKeymasterPadding;
    private byte[] mIv;
    private boolean mIvHasBeenUsed;

    AndroidKeyStoreAuthenticatedAESCipherSpi(int keymasterBlockMode, int keymasterPadding) {
        this.mKeymasterBlockMode = keymasterBlockMode;
        this.mKeymasterPadding = keymasterPadding;
    }

    @Override
    protected void resetAll() {
        this.mIv = null;
        this.mIvHasBeenUsed = false;
        super.resetAll();
    }

    @Override
    protected final void initKey(int opmode, Key key) throws InvalidKeyException {
        if (!(key instanceof AndroidKeyStoreSecretKey)) {
            throw new InvalidKeyException("Unsupported key: " + (key != null ? key.getClass().getName() : "null"));
        }
        if (!"AES".equalsIgnoreCase(key.getAlgorithm())) {
            throw new InvalidKeyException("Unsupported key algorithm: " + key.getAlgorithm() + ". Only " + "AES" + " supported");
        }
        this.setKey((AndroidKeyStoreSecretKey)key);
    }

    @Override
    protected void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
        if (this.isEncrypting() && this.mIvHasBeenUsed) {
            throw new IllegalStateException("IV has already been used. Reusing IV in encryption mode violates security best practices.");
        }
        keymasterArgs.addEnum(0x10000002, 32);
        keymasterArgs.addEnum(0x20000004, this.mKeymasterBlockMode);
        keymasterArgs.addEnum(0x20000006, this.mKeymasterPadding);
        if (this.mIv != null) {
            keymasterArgs.addBytes(-1879047191, this.mIv);
        }
    }

    @Override
    protected final void loadAlgorithmSpecificParametersFromBeginResult(KeymasterArguments keymasterArgs) {
        this.mIvHasBeenUsed = true;
        byte[] returnedIv = keymasterArgs.getBytes(-1879047191, null);
        if (returnedIv != null && returnedIv.length == 0) {
            returnedIv = null;
        }
        if (this.mIv == null) {
            this.mIv = returnedIv;
        } else if (returnedIv != null && !Arrays.equals(returnedIv, this.mIv)) {
            throw new ProviderException("IV in use differs from provided IV");
        }
    }

    @Override
    protected final int engineGetBlockSize() {
        return 16;
    }

    @Override
    protected final byte[] engineGetIV() {
        return ArrayUtils.cloneIfNotEmpty(this.mIv);
    }

    protected void setIv(byte[] iv) {
        this.mIv = iv;
    }

    protected byte[] getIv() {
        return this.mIv;
    }

    private static class AdditionalAuthenticationDataStream
    implements KeyStoreCryptoOperationChunkedStreamer.Stream {
        private final KeyStore mKeyStore;
        private final IBinder mOperationToken;

        private AdditionalAuthenticationDataStream(KeyStore keyStore, IBinder operationToken) {
            this.mKeyStore = keyStore;
            this.mOperationToken = operationToken;
        }

        @Override
        public OperationResult update(byte[] input) {
            KeymasterArguments keymasterArgs = new KeymasterArguments();
            keymasterArgs.addBytes(-1879047192, input);
            OperationResult result = this.mKeyStore.update(this.mOperationToken, keymasterArgs, null);
            if (result.resultCode == 1) {
                result = new OperationResult(result.resultCode, result.token, result.operationHandle, input.length, result.output, result.outParams);
            }
            return result;
        }

        @Override
        public OperationResult finish(byte[] signature, byte[] additionalEntropy) {
            if (additionalEntropy != null && additionalEntropy.length > 0) {
                throw new ProviderException("AAD stream does not support additional entropy");
            }
            return new OperationResult(1, this.mOperationToken, 0L, 0, EmptyArray.BYTE, new KeymasterArguments());
        }
    }

    private static class BufferAllOutputUntilDoFinalStreamer
    implements KeyStoreCryptoOperationStreamer {
        private final KeyStoreCryptoOperationStreamer mDelegate;
        private ByteArrayOutputStream mBufferedOutput = new ByteArrayOutputStream();
        private long mProducedOutputSizeBytes;

        private BufferAllOutputUntilDoFinalStreamer(KeyStoreCryptoOperationStreamer delegate) {
            this.mDelegate = delegate;
        }

        @Override
        public byte[] update(byte[] input, int inputOffset, int inputLength) throws KeyStoreException {
            byte[] output = this.mDelegate.update(input, inputOffset, inputLength);
            if (output != null) {
                try {
                    this.mBufferedOutput.write(output);
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
            }
            return EmptyArray.BYTE;
        }

        @Override
        public byte[] doFinal(byte[] input, int inputOffset, int inputLength, byte[] signature, byte[] additionalEntropy) throws KeyStoreException {
            byte[] output = this.mDelegate.doFinal(input, inputOffset, inputLength, signature, additionalEntropy);
            if (output != null) {
                try {
                    this.mBufferedOutput.write(output);
                }
                catch (IOException e) {
                    throw new ProviderException("Failed to buffer output", e);
                }
            }
            byte[] result = this.mBufferedOutput.toByteArray();
            this.mBufferedOutput.reset();
            this.mProducedOutputSizeBytes += (long)result.length;
            return result;
        }

        @Override
        public long getConsumedInputSizeBytes() {
            return this.mDelegate.getConsumedInputSizeBytes();
        }

        @Override
        public long getProducedOutputSizeBytes() {
            return this.mProducedOutputSizeBytes;
        }
    }

    static abstract class GCM
    extends AndroidKeyStoreAuthenticatedAESCipherSpi {
        static final int MIN_SUPPORTED_TAG_LENGTH_BITS = 96;
        private static final int MAX_SUPPORTED_TAG_LENGTH_BITS = 128;
        private static final int DEFAULT_TAG_LENGTH_BITS = 128;
        private static final int IV_LENGTH_BYTES = 12;
        private int mTagLengthBits = 128;

        GCM(int keymasterPadding) {
            super(32, keymasterPadding);
        }

        @Override
        protected final void resetAll() {
            this.mTagLengthBits = 128;
            super.resetAll();
        }

        @Override
        protected final void resetWhilePreservingInitState() {
            super.resetWhilePreservingInitState();
        }

        @Override
        protected final void initAlgorithmSpecificParameters() throws InvalidKeyException {
            if (!this.isEncrypting()) {
                throw new InvalidKeyException("IV required when decrypting. Use IvParameterSpec or AlgorithmParameters to provide it.");
            }
        }

        @Override
        protected final void initAlgorithmSpecificParameters(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params == null) {
                if (!this.isEncrypting()) {
                    throw new InvalidAlgorithmParameterException("GCMParameterSpec must be provided when decrypting");
                }
                return;
            }
            if (!(params instanceof GCMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only GCMParameterSpec supported");
            }
            GCMParameterSpec spec = (GCMParameterSpec)params;
            byte[] iv = spec.getIV();
            if (iv == null) {
                throw new InvalidAlgorithmParameterException("Null IV in GCMParameterSpec");
            }
            if (iv.length != 12) {
                throw new InvalidAlgorithmParameterException("Unsupported IV length: " + iv.length + " bytes. Only " + 12 + " bytes long IV supported");
            }
            int tagLengthBits = spec.getTLen();
            if (tagLengthBits < 96 || tagLengthBits > 128 || tagLengthBits % 8 != 0) {
                throw new InvalidAlgorithmParameterException("Unsupported tag length: " + tagLengthBits + " bits" + ". Supported lengths: 96, 104, 112, 120, 128");
            }
            this.setIv(iv);
            this.mTagLengthBits = tagLengthBits;
        }

        @Override
        protected final void initAlgorithmSpecificParameters(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            GCMParameterSpec spec;
            if (params == null) {
                if (!this.isEncrypting()) {
                    throw new InvalidAlgorithmParameterException("IV required when decrypting. Use GCMParameterSpec or GCM AlgorithmParameters to provide it.");
                }
                return;
            }
            if (!"GCM".equalsIgnoreCase(params.getAlgorithm())) {
                throw new InvalidAlgorithmParameterException("Unsupported AlgorithmParameters algorithm: " + params.getAlgorithm() + ". Supported: GCM");
            }
            try {
                spec = params.getParameterSpec(GCMParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                if (!this.isEncrypting()) {
                    throw new InvalidAlgorithmParameterException("IV and tag length required when decrypting, but not found in parameters: " + params, e);
                }
                this.setIv(null);
                return;
            }
            this.initAlgorithmSpecificParameters(spec);
        }

        @Override
        protected final AlgorithmParameters engineGetParameters() {
            byte[] iv = this.getIv();
            if (iv != null && iv.length > 0) {
                try {
                    AlgorithmParameters params = AlgorithmParameters.getInstance("GCM");
                    params.init(new GCMParameterSpec(this.mTagLengthBits, iv));
                    return params;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ProviderException("Failed to obtain GCM AlgorithmParameters", e);
                }
                catch (InvalidParameterSpecException e) {
                    throw new ProviderException("Failed to initialize GCM AlgorithmParameters", e);
                }
            }
            return null;
        }

        @Override
        protected KeyStoreCryptoOperationStreamer createMainDataStreamer(KeyStore keyStore, IBinder operationToken) {
            KeyStoreCryptoOperationChunkedStreamer streamer = new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(keyStore, operationToken));
            if (this.isEncrypting()) {
                return streamer;
            }
            return new BufferAllOutputUntilDoFinalStreamer(streamer);
        }

        @Override
        protected final KeyStoreCryptoOperationStreamer createAdditionalAuthenticationDataStreamer(KeyStore keyStore, IBinder operationToken) {
            return new KeyStoreCryptoOperationChunkedStreamer(new AdditionalAuthenticationDataStream(keyStore, operationToken));
        }

        @Override
        protected final int getAdditionalEntropyAmountForBegin() {
            if (this.getIv() == null && this.isEncrypting()) {
                return 12;
            }
            return 0;
        }

        @Override
        protected final int getAdditionalEntropyAmountForFinish() {
            return 0;
        }

        @Override
        protected final void addAlgorithmSpecificParametersToBegin(KeymasterArguments keymasterArgs) {
            super.addAlgorithmSpecificParametersToBegin(keymasterArgs);
            keymasterArgs.addUnsignedInt(805307371, this.mTagLengthBits);
        }

        protected final int getTagLengthBits() {
            return this.mTagLengthBits;
        }

        public static final class NoPadding
        extends GCM {
            public NoPadding() {
                super(1);
            }

            @Override
            protected final int engineGetOutputSize(int inputLen) {
                int tagLengthBytes = (this.getTagLengthBits() + 7) / 8;
                long result = this.isEncrypting() ? this.getConsumedInputSizeBytes() - this.getProducedOutputSizeBytes() + (long)inputLen + (long)tagLengthBytes : this.getConsumedInputSizeBytes() - this.getProducedOutputSizeBytes() + (long)inputLen - (long)tagLengthBytes;
                if (result < 0L) {
                    return 0;
                }
                if (result > Integer.MAX_VALUE) {
                    return Integer.MAX_VALUE;
                }
                return (int)result;
            }
        }
    }
}

