/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.AndroidKeyStorePublicKey;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

public class AndroidKeyStoreRSAPublicKey
extends AndroidKeyStorePublicKey
implements RSAPublicKey {
    private final BigInteger mModulus;
    private final BigInteger mPublicExponent;

    public AndroidKeyStoreRSAPublicKey(String alias, byte[] x509EncodedForm, BigInteger modulus, BigInteger publicExponent) {
        super(alias, "RSA", x509EncodedForm);
        this.mModulus = modulus;
        this.mPublicExponent = publicExponent;
    }

    public AndroidKeyStoreRSAPublicKey(String alias, RSAPublicKey info) {
        this(alias, info.getEncoded(), info.getModulus(), info.getPublicExponent());
        if (!"X.509".equalsIgnoreCase(info.getFormat())) {
            throw new IllegalArgumentException("Unsupported key export format: " + info.getFormat());
        }
    }

    @Override
    public BigInteger getModulus() {
        return this.mModulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.mPublicExponent;
    }
}

