/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.OperationResult;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStorePublicKey;
import android.security.keystore.ArrayUtils;
import android.security.keystore.KeyStoreConnectException;
import android.security.keystore.KeyStoreCryptoOperation;
import android.security.keystore.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import android.security.keystore.KeyStoreCryptoOperationUtils;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import libcore.util.EmptyArray;

abstract class AndroidKeyStoreSignatureSpiBase
extends SignatureSpi
implements KeyStoreCryptoOperation {
    private final KeyStore mKeyStore = KeyStore.getInstance();
    private boolean mSigning;
    private AndroidKeyStoreKey mKey;
    private IBinder mOperationToken;
    private long mOperationHandle;
    private KeyStoreCryptoOperationStreamer mMessageStreamer;
    private Exception mCachedException;

    AndroidKeyStoreSignatureSpiBase() {
    }

    @Override
    protected final void engineInitSign(PrivateKey key) throws InvalidKeyException {
        this.engineInitSign(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.resetAll();
        boolean success = false;
        try {
            if (privateKey == null) {
                throw new InvalidKeyException("Unsupported key: null");
            }
            if (!(privateKey instanceof AndroidKeyStorePrivateKey)) {
                throw new InvalidKeyException("Unsupported private key type: " + privateKey);
            }
            AndroidKeyStoreKey keystoreKey = (AndroidKeyStoreKey)((Object)privateKey);
            this.mSigning = true;
            this.initKey(keystoreKey);
            this.appRandom = random;
            this.ensureKeystoreOperationInitialized();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.resetAll();
        boolean success = false;
        try {
            if (publicKey == null) {
                throw new InvalidKeyException("Unsupported key: null");
            }
            if (!(publicKey instanceof AndroidKeyStorePublicKey)) {
                throw new InvalidKeyException("Unsupported public key type: " + publicKey);
            }
            AndroidKeyStorePublicKey keystoreKey = (AndroidKeyStorePublicKey)publicKey;
            this.mSigning = false;
            this.initKey(keystoreKey);
            this.appRandom = null;
            this.ensureKeystoreOperationInitialized();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    protected void initKey(AndroidKeyStoreKey key) throws InvalidKeyException {
        this.mKey = key;
    }

    protected void resetAll() {
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mOperationToken = null;
            this.mKeyStore.abort(operationToken);
        }
        this.mSigning = false;
        this.mKey = null;
        this.appRandom = null;
        this.mOperationToken = null;
        this.mOperationHandle = 0L;
        this.mMessageStreamer = null;
        this.mCachedException = null;
    }

    protected void resetWhilePreservingInitState() {
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mOperationToken = null;
            this.mKeyStore.abort(operationToken);
        }
        this.mOperationHandle = 0L;
        this.mMessageStreamer = null;
        this.mCachedException = null;
    }

    private void ensureKeystoreOperationInitialized() throws InvalidKeyException {
        if (this.mMessageStreamer != null) {
            return;
        }
        if (this.mCachedException != null) {
            return;
        }
        if (this.mKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        KeymasterArguments keymasterInputArgs = new KeymasterArguments();
        this.addAlgorithmSpecificParametersToBegin(keymasterInputArgs);
        OperationResult opResult = this.mKeyStore.begin(this.mKey.getAlias(), this.mSigning ? 2 : 3, true, keymasterInputArgs, null);
        if (opResult == null) {
            throw new KeyStoreConnectException();
        }
        this.mOperationToken = opResult.token;
        this.mOperationHandle = opResult.operationHandle;
        InvalidKeyException e = KeyStoreCryptoOperationUtils.getInvalidKeyExceptionForInit(this.mKeyStore, this.mKey, opResult.resultCode);
        if (e != null) {
            throw e;
        }
        if (this.mOperationToken == null) {
            throw new ProviderException("Keystore returned null operation token");
        }
        if (this.mOperationHandle == 0L) {
            throw new ProviderException("Keystore returned invalid operation handle");
        }
        this.mMessageStreamer = this.createMainDataStreamer(this.mKeyStore, opResult.token);
    }

    protected KeyStoreCryptoOperationStreamer createMainDataStreamer(KeyStore keyStore, IBinder operationToken) {
        return new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(keyStore, operationToken));
    }

    @Override
    public final long getOperationHandle() {
        return this.mOperationHandle;
    }

    @Override
    protected final void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        byte[] output;
        if (this.mCachedException != null) {
            throw new SignatureException(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        if (len == 0) {
            return;
        }
        try {
            output = this.mMessageStreamer.update(b, off, len);
        }
        catch (KeyStoreException e) {
            throw new SignatureException(e);
        }
        if (output.length != 0) {
            throw new ProviderException("Update operation unexpectedly produced output: " + output.length + " bytes");
        }
    }

    @Override
    protected final void engineUpdate(byte b) throws SignatureException {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    @Override
    protected final void engineUpdate(ByteBuffer input) {
        int off;
        byte[] b;
        int len = input.remaining();
        if (input.hasArray()) {
            b = input.array();
            off = input.arrayOffset() + input.position();
            input.position(input.limit());
        } else {
            b = new byte[len];
            off = 0;
            input.get(b);
        }
        try {
            this.engineUpdate(b, off, len);
        }
        catch (SignatureException e) {
            this.mCachedException = e;
        }
    }

    @Override
    protected final int engineSign(byte[] out, int outOffset, int outLen) throws SignatureException {
        return super.engineSign(out, outOffset, outLen);
    }

    @Override
    protected final byte[] engineSign() throws SignatureException {
        byte[] signature;
        if (this.mCachedException != null) {
            throw new SignatureException(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized();
            byte[] additionalEntropy = KeyStoreCryptoOperationUtils.getRandomBytesToMixIntoKeystoreRng(this.appRandom, this.getAdditionalEntropyAmountForSign());
            signature = this.mMessageStreamer.doFinal(EmptyArray.BYTE, 0, 0, null, additionalEntropy);
        }
        catch (KeyStoreException | InvalidKeyException e) {
            throw new SignatureException(e);
        }
        this.resetWhilePreservingInitState();
        return signature;
    }

    @Override
    protected final boolean engineVerify(byte[] signature) throws SignatureException {
        boolean verified;
        if (this.mCachedException != null) {
            throw new SignatureException(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        try {
            byte[] output = this.mMessageStreamer.doFinal(EmptyArray.BYTE, 0, 0, signature, null);
            if (output.length != 0) {
                throw new ProviderException("Signature verification unexpected produced output: " + output.length + " bytes");
            }
            verified = true;
        }
        catch (KeyStoreException e) {
            switch (e.getErrorCode()) {
                case -30: {
                    verified = false;
                    break;
                }
                default: {
                    throw new SignatureException(e);
                }
            }
        }
        this.resetWhilePreservingInitState();
        return verified;
    }

    @Override
    protected final boolean engineVerify(byte[] sigBytes, int offset, int len) throws SignatureException {
        return this.engineVerify(ArrayUtils.subarray(sigBytes, offset, len));
    }

    @Override
    @Deprecated
    protected final Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    @Override
    @Deprecated
    protected final void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    protected final KeyStore getKeyStore() {
        return this.mKeyStore;
    }

    protected final boolean isSigning() {
        return this.mSigning;
    }

    protected abstract int getAdditionalEntropyAmountForSign();

    protected abstract void addAlgorithmSpecificParametersToBegin(KeymasterArguments var1);
}

