/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.KeyStore;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.UserNotAuthenticatedException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import libcore.util.EmptyArray;

abstract class KeyStoreCryptoOperationUtils {
    private static volatile SecureRandom sRng;

    private KeyStoreCryptoOperationUtils() {
    }

    static InvalidKeyException getInvalidKeyExceptionForInit(KeyStore keyStore, AndroidKeyStoreKey key, int beginOpResultCode) {
        if (beginOpResultCode == 1) {
            return null;
        }
        InvalidKeyException e = keyStore.getInvalidKeyException(key.getAlias(), beginOpResultCode);
        switch (beginOpResultCode) {
            case 15: {
                if (!(e instanceof UserNotAuthenticatedException)) break;
                return null;
            }
        }
        return e;
    }

    public static GeneralSecurityException getExceptionForCipherInit(KeyStore keyStore, AndroidKeyStoreKey key, int beginOpResultCode) {
        if (beginOpResultCode == 1) {
            return null;
        }
        switch (beginOpResultCode) {
            case -52: {
                return new InvalidAlgorithmParameterException("Invalid IV");
            }
            case -55: {
                return new InvalidAlgorithmParameterException("Caller-provided IV not permitted");
            }
        }
        return KeyStoreCryptoOperationUtils.getInvalidKeyExceptionForInit(keyStore, key, beginOpResultCode);
    }

    static byte[] getRandomBytesToMixIntoKeystoreRng(SecureRandom rng, int sizeBytes) {
        if (sizeBytes <= 0) {
            return EmptyArray.BYTE;
        }
        if (rng == null) {
            rng = KeyStoreCryptoOperationUtils.getRng();
        }
        byte[] result = new byte[sizeBytes];
        rng.nextBytes(result);
        return result;
    }

    private static SecureRandom getRng() {
        if (sRng == null) {
            sRng = new SecureRandom();
        }
        return sRng;
    }
}

