/*
 * Decompiled with CFR 0.152.
 */
package android.service.media;

import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.media.browse.MediaBrowser;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;

public abstract class MediaBrowserService
extends Service {
    private static final String TAG = "MediaBrowserService";
    private static final boolean DBG = false;
    public static final String SERVICE_INTERFACE = "android.media.browse.MediaBrowserService";
    public static final String KEY_MEDIA_ITEM = "media_item";
    private final ArrayMap<IBinder, ConnectionRecord> mConnections = new ArrayMap();
    private final Handler mHandler = new Handler();
    private ServiceBinder mBinder;
    MediaSession.Token mSession;

    @Override
    public void onCreate() {
        super.onCreate();
        this.mBinder = new ServiceBinder();
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
    }

    public abstract BrowserRoot onGetRoot(String var1, int var2, Bundle var3);

    public abstract void onLoadChildren(String var1, Result<List<MediaBrowser.MediaItem>> var2);

    public void onLoadItem(String itemId, Result<MediaBrowser.MediaItem> result) {
        result.sendResult(null);
    }

    public void setSessionToken(final MediaSession.Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Session token may not be null.");
        }
        if (this.mSession != null) {
            throw new IllegalStateException("The session token has already been set.");
        }
        this.mSession = token;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IBinder key : MediaBrowserService.this.mConnections.keySet()) {
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserService.this.mConnections.get(key);
                    try {
                        connection.callbacks.onConnect(connection.root.getRootId(), token, connection.root.getExtras());
                    }
                    catch (RemoteException e) {
                        Log.w(MediaBrowserService.TAG, "Connection for " + connection.pkg + " is no longer valid.");
                        MediaBrowserService.this.mConnections.remove(key);
                    }
                }
            }
        });
    }

    public MediaSession.Token getSessionToken() {
        return this.mSession;
    }

    public void notifyChildrenChanged(final String parentId) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                for (IBinder binder : MediaBrowserService.this.mConnections.keySet()) {
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserService.this.mConnections.get(binder);
                    if (!connection.subscriptions.contains(parentId)) continue;
                    MediaBrowserService.this.performLoadChildren(parentId, connection);
                }
            }
        });
    }

    private boolean isValidPackage(String pkg, int uid) {
        if (pkg == null) {
            return false;
        }
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(uid);
        int N = packages.length;
        for (int i = 0; i < N; ++i) {
            if (!packages[i].equals(pkg)) continue;
            return true;
        }
        return false;
    }

    private void addSubscription(String id2, ConnectionRecord connection) {
        connection.subscriptions.add(id2);
        this.performLoadChildren(id2, connection);
    }

    private void performLoadChildren(final String parentId, final ConnectionRecord connection) {
        Result<List<MediaBrowser.MediaItem>> result = new Result<List<MediaBrowser.MediaItem>>((Object)parentId){

            @Override
            void onResultSent(List<MediaBrowser.MediaItem> list) {
                if (list == null) {
                    throw new IllegalStateException("onLoadChildren sent null list for id " + parentId);
                }
                if (MediaBrowserService.this.mConnections.get(connection.callbacks.asBinder()) != connection) {
                    return;
                }
                ParceledListSlice<MediaBrowser.MediaItem> pls = new ParceledListSlice<MediaBrowser.MediaItem>(list);
                try {
                    connection.callbacks.onLoadChildren(parentId, pls);
                }
                catch (RemoteException ex) {
                    Log.w(MediaBrowserService.TAG, "Calling onLoadChildren() failed for id=" + parentId + " package=" + connection.pkg);
                }
            }
        };
        this.onLoadChildren(parentId, result);
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + connection.pkg + " id=" + parentId);
        }
    }

    private void performLoadItem(String itemId, final ResultReceiver receiver) {
        Result<MediaBrowser.MediaItem> result = new Result<MediaBrowser.MediaItem>((Object)itemId){

            @Override
            void onResultSent(MediaBrowser.MediaItem item) {
                Bundle bundle = new Bundle();
                bundle.putParcelable(MediaBrowserService.KEY_MEDIA_ITEM, item);
                receiver.send(0, bundle);
            }
        };
        this.onLoadItem(itemId, result);
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadItem must call detach() or sendResult() before returning for id=" + itemId);
        }
    }

    public static final class BrowserRoot {
        private final String mRootId;
        private final Bundle mExtras;

        public BrowserRoot(String rootId, Bundle extras) {
            if (rootId == null) {
                throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead.");
            }
            this.mRootId = rootId;
            this.mExtras = extras;
        }

        public String getRootId() {
            return this.mRootId;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }
    }

    private class ServiceBinder
    extends IMediaBrowserService.Stub {
        private ServiceBinder() {
        }

        @Override
        public void connect(final String pkg, final Bundle rootHints, final IMediaBrowserServiceCallbacks callbacks) {
            final int uid = Binder.getCallingUid();
            if (!MediaBrowserService.this.isValidPackage(pkg, uid)) {
                throw new IllegalArgumentException("Package/uid mismatch: uid=" + uid + " package=" + pkg);
            }
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    MediaBrowserService.this.mConnections.remove(b);
                    ConnectionRecord connection = new ConnectionRecord();
                    connection.pkg = pkg;
                    connection.rootHints = rootHints;
                    connection.callbacks = callbacks;
                    connection.root = MediaBrowserService.this.onGetRoot(pkg, uid, rootHints);
                    if (connection.root == null) {
                        Log.i(MediaBrowserService.TAG, "No root for client " + pkg + " from service " + this.getClass().getName());
                        try {
                            callbacks.onConnectFailed();
                        }
                        catch (RemoteException ex) {
                            Log.w(MediaBrowserService.TAG, "Calling onConnectFailed() failed. Ignoring. pkg=" + pkg);
                        }
                    } else {
                        try {
                            MediaBrowserService.this.mConnections.put(b, connection);
                            if (MediaBrowserService.this.mSession != null) {
                                callbacks.onConnect(connection.root.getRootId(), MediaBrowserService.this.mSession, connection.root.getExtras());
                            }
                        }
                        catch (RemoteException ex) {
                            Log.w(MediaBrowserService.TAG, "Calling onConnect() failed. Dropping client. pkg=" + pkg);
                            MediaBrowserService.this.mConnections.remove(b);
                        }
                    }
                }
            });
        }

        @Override
        public void disconnect(final IMediaBrowserServiceCallbacks callbacks) {
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    ConnectionRecord old = (ConnectionRecord)MediaBrowserService.this.mConnections.remove(b);
                    if (old != null) {
                        // empty if block
                    }
                }
            });
        }

        @Override
        public void addSubscription(final String id2, final IMediaBrowserServiceCallbacks callbacks) {
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserService.this.mConnections.get(b);
                    if (connection == null) {
                        Log.w(MediaBrowserService.TAG, "addSubscription for callback that isn't registered id=" + id2);
                        return;
                    }
                    MediaBrowserService.this.addSubscription(id2, connection);
                }
            });
        }

        @Override
        public void removeSubscription(final String id2, final IMediaBrowserServiceCallbacks callbacks) {
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    IBinder b = callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)MediaBrowserService.this.mConnections.get(b);
                    if (connection == null) {
                        Log.w(MediaBrowserService.TAG, "removeSubscription for callback that isn't registered id=" + id2);
                        return;
                    }
                    if (!connection.subscriptions.remove(id2)) {
                        Log.w(MediaBrowserService.TAG, "removeSubscription called for " + id2 + " which is not subscribed");
                    }
                }
            });
        }

        @Override
        public void getMediaItem(final String mediaId, final ResultReceiver receiver) {
            if (TextUtils.isEmpty(mediaId) || receiver == null) {
                return;
            }
            MediaBrowserService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    MediaBrowserService.this.performLoadItem(mediaId, receiver);
                }
            });
        }
    }

    public class Result<T> {
        private Object mDebug;
        private boolean mDetachCalled;
        private boolean mSendResultCalled;

        Result(Object debug) {
            this.mDebug = debug;
        }

        public void sendResult(T result) {
            if (this.mSendResultCalled) {
                throw new IllegalStateException("sendResult() called twice for: " + this.mDebug);
            }
            this.mSendResultCalled = true;
            this.onResultSent(result);
        }

        public void detach() {
            if (this.mDetachCalled) {
                throw new IllegalStateException("detach() called when detach() had already been called for: " + this.mDebug);
            }
            if (this.mSendResultCalled) {
                throw new IllegalStateException("detach() called when sendResult() had already been called for: " + this.mDebug);
            }
            this.mDetachCalled = true;
        }

        boolean isDone() {
            return this.mDetachCalled || this.mSendResultCalled;
        }

        void onResultSent(T result) {
        }
    }

    private class ConnectionRecord {
        String pkg;
        Bundle rootHints;
        IMediaBrowserServiceCallbacks callbacks;
        BrowserRoot root;
        HashSet<String> subscriptions = new HashSet();

        private ConnectionRecord() {
        }
    }
}

