/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.Xml;
import com.android.internal.R;

public class VoiceInteractionServiceInfo {
    static final String TAG = "VoiceInteractionServiceInfo";
    private String mParseError;
    private ServiceInfo mServiceInfo;
    private String mSessionService;
    private String mRecognitionService;
    private String mSettingsActivity;
    private boolean mSupportsAssist;
    private boolean mSupportsLaunchFromKeyguard;

    public VoiceInteractionServiceInfo(PackageManager pm, ComponentName comp) throws PackageManager.NameNotFoundException {
        this(pm, pm.getServiceInfo(comp, 128));
    }

    public VoiceInteractionServiceInfo(PackageManager pm, ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException, RemoteException {
        this(pm, AppGlobals.getPackageManager().getServiceInfo(comp, 128, userHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VoiceInteractionServiceInfo(PackageManager pm, ServiceInfo si) {
        if (!"android.permission.BIND_VOICE_INTERACTION".equals(si.permission)) {
            this.mParseError = "Service does not require permission android.permission.BIND_VOICE_INTERACTION";
            return;
        }
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.voice_interaction");
            if (parser == null) {
                this.mParseError = "No android.voice_interaction meta-data for " + si.packageName;
                return;
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"voice-interaction-service".equals(nodeName)) {
                this.mParseError = "Meta-data does not start with voice-interaction-service tag";
                return;
            }
            TypedArray array2 = res.obtainAttributes(attrs, R.styleable.VoiceInteractionService);
            this.mSessionService = array2.getString(1);
            this.mRecognitionService = array2.getString(2);
            this.mSettingsActivity = array2.getString(0);
            this.mSupportsAssist = array2.getBoolean(3, false);
            this.mSupportsLaunchFromKeyguard = array2.getBoolean(4, false);
            array2.recycle();
            if (this.mSessionService == null) {
                this.mParseError = "No sessionService specified";
                return;
            }
            if (this.mRecognitionService == null) {
                this.mParseError = "No recognitionService specified";
                return;
            }
        }
        this.mServiceInfo = si;
    }

    public String getParseError() {
        return this.mParseError;
    }

    public ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public String getSessionService() {
        return this.mSessionService;
    }

    public String getRecognitionService() {
        return this.mRecognitionService;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivity;
    }

    public boolean getSupportsAssist() {
        return this.mSupportsAssist;
    }

    public boolean getSupportsLaunchFromKeyguard() {
        return this.mSupportsLaunchFromKeyguard;
    }
}

