/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.telecom.CallAudioState;
import android.telecom.Conference;
import android.telecom.Conferenceable;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionServiceAdapter;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConference;
import android.telecom.RemoteConnection;
import android.telecom.RemoteConnectionManager;
import android.telecom.StatusHints;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionService
extends Service {
    public static final String SERVICE_INTERFACE = "android.telecom.ConnectionService";
    private static final boolean PII_DEBUG = Log.isLoggable(3);
    private static final int MSG_ADD_CONNECTION_SERVICE_ADAPTER = 1;
    private static final int MSG_CREATE_CONNECTION = 2;
    private static final int MSG_ABORT = 3;
    private static final int MSG_ANSWER = 4;
    private static final int MSG_REJECT = 5;
    private static final int MSG_DISCONNECT = 6;
    private static final int MSG_HOLD = 7;
    private static final int MSG_UNHOLD = 8;
    private static final int MSG_ON_CALL_AUDIO_STATE_CHANGED = 9;
    private static final int MSG_PLAY_DTMF_TONE = 10;
    private static final int MSG_STOP_DTMF_TONE = 11;
    private static final int MSG_CONFERENCE = 12;
    private static final int MSG_SPLIT_FROM_CONFERENCE = 13;
    private static final int MSG_ON_POST_DIAL_CONTINUE = 14;
    private static final int MSG_REMOVE_CONNECTION_SERVICE_ADAPTER = 16;
    private static final int MSG_ANSWER_VIDEO = 17;
    private static final int MSG_MERGE_CONFERENCE = 18;
    private static final int MSG_SWAP_CONFERENCE = 19;
    private static Connection sNullConnection;
    private final Map<String, Connection> mConnectionById = new ConcurrentHashMap<String, Connection>();
    private final Map<Connection, String> mIdByConnection = new ConcurrentHashMap<Connection, String>();
    private final Map<String, Conference> mConferenceById = new ConcurrentHashMap<String, Conference>();
    private final Map<Conference, String> mIdByConference = new ConcurrentHashMap<Conference, String>();
    private final RemoteConnectionManager mRemoteConnectionManager = new RemoteConnectionManager(this);
    private final List<Runnable> mPreInitializationConnectionRequests = new ArrayList<Runnable>();
    private final ConnectionServiceAdapter mAdapter = new ConnectionServiceAdapter();
    private boolean mAreAccountsInitialized = false;
    private Conference sNullConference;
    private final IBinder mBinder = new IConnectionService.Stub(){

        @Override
        public void addConnectionServiceAdapter(IConnectionServiceAdapter adapter) {
            ConnectionService.this.mHandler.obtainMessage(1, adapter).sendToTarget();
        }

        @Override
        public void removeConnectionServiceAdapter(IConnectionServiceAdapter adapter) {
            ConnectionService.this.mHandler.obtainMessage(16, adapter).sendToTarget();
        }

        @Override
        public void createConnection(PhoneAccountHandle connectionManagerPhoneAccount, String id2, ConnectionRequest request, boolean isIncoming, boolean isUnknown) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = connectionManagerPhoneAccount;
            args.arg2 = id2;
            args.arg3 = request;
            args.argi1 = isIncoming ? 1 : 0;
            args.argi2 = isUnknown ? 1 : 0;
            ConnectionService.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void abort(String callId) {
            ConnectionService.this.mHandler.obtainMessage(3, callId).sendToTarget();
        }

        @Override
        public void answerVideo(String callId, int videoState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.argi1 = videoState;
            ConnectionService.this.mHandler.obtainMessage(17, args).sendToTarget();
        }

        @Override
        public void answer(String callId) {
            ConnectionService.this.mHandler.obtainMessage(4, callId).sendToTarget();
        }

        @Override
        public void reject(String callId) {
            ConnectionService.this.mHandler.obtainMessage(5, callId).sendToTarget();
        }

        @Override
        public void disconnect(String callId) {
            ConnectionService.this.mHandler.obtainMessage(6, callId).sendToTarget();
        }

        @Override
        public void hold(String callId) {
            ConnectionService.this.mHandler.obtainMessage(7, callId).sendToTarget();
        }

        @Override
        public void unhold(String callId) {
            ConnectionService.this.mHandler.obtainMessage(8, callId).sendToTarget();
        }

        @Override
        public void onCallAudioStateChanged(String callId, CallAudioState callAudioState) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.arg2 = callAudioState;
            ConnectionService.this.mHandler.obtainMessage(9, args).sendToTarget();
        }

        @Override
        public void playDtmfTone(String callId, char digit) {
            ConnectionService.this.mHandler.obtainMessage(10, digit, 0, callId).sendToTarget();
        }

        @Override
        public void stopDtmfTone(String callId) {
            ConnectionService.this.mHandler.obtainMessage(11, callId).sendToTarget();
        }

        @Override
        public void conference(String callId1, String callId2) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId1;
            args.arg2 = callId2;
            ConnectionService.this.mHandler.obtainMessage(12, args).sendToTarget();
        }

        @Override
        public void splitFromConference(String callId) {
            ConnectionService.this.mHandler.obtainMessage(13, callId).sendToTarget();
        }

        @Override
        public void mergeConference(String callId) {
            ConnectionService.this.mHandler.obtainMessage(18, callId).sendToTarget();
        }

        @Override
        public void swapConference(String callId) {
            ConnectionService.this.mHandler.obtainMessage(19, callId).sendToTarget();
        }

        @Override
        public void onPostDialContinue(String callId, boolean proceed) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = callId;
            args.argi1 = proceed ? 1 : 0;
            ConnectionService.this.mHandler.obtainMessage(14, args).sendToTarget();
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ConnectionService.this.mAdapter.addAdapter((IConnectionServiceAdapter)msg.obj);
                    ConnectionService.this.onAdapterAttached();
                    break;
                }
                case 16: {
                    ConnectionService.this.mAdapter.removeAdapter((IConnectionServiceAdapter)msg.obj);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        boolean isUnknown;
                        final PhoneAccountHandle connectionManagerPhoneAccount = (PhoneAccountHandle)args.arg1;
                        final String id2 = (String)args.arg2;
                        final ConnectionRequest request = (ConnectionRequest)args.arg3;
                        final boolean isIncoming = args.argi1 == 1;
                        boolean bl = isUnknown = args.argi2 == 1;
                        if (!ConnectionService.this.mAreAccountsInitialized) {
                            Log.d(this, "Enqueueing pre-init request %s", id2);
                            ConnectionService.this.mPreInitializationConnectionRequests.add(new Runnable(){

                                @Override
                                public void run() {
                                    ConnectionService.this.createConnection(connectionManagerPhoneAccount, id2, request, isIncoming, isUnknown);
                                }
                            });
                            break;
                        }
                        ConnectionService.this.createConnection(connectionManagerPhoneAccount, id2, request, isIncoming, isUnknown);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    ConnectionService.this.abort((String)msg.obj);
                    break;
                }
                case 4: {
                    ConnectionService.this.answer((String)msg.obj);
                    break;
                }
                case 17: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId = (String)args.arg1;
                        int videoState = args.argi1;
                        ConnectionService.this.answerVideo(callId, videoState);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    ConnectionService.this.reject((String)msg.obj);
                    break;
                }
                case 6: {
                    ConnectionService.this.disconnect((String)msg.obj);
                    break;
                }
                case 7: {
                    ConnectionService.this.hold((String)msg.obj);
                    break;
                }
                case 8: {
                    ConnectionService.this.unhold((String)msg.obj);
                    break;
                }
                case 9: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId = (String)args.arg1;
                        CallAudioState audioState = (CallAudioState)args.arg2;
                        ConnectionService.this.onCallAudioStateChanged(callId, new CallAudioState(audioState));
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 10: {
                    ConnectionService.this.playDtmfTone((String)msg.obj, (char)msg.arg1);
                    break;
                }
                case 11: {
                    ConnectionService.this.stopDtmfTone((String)msg.obj);
                    break;
                }
                case 12: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId1 = (String)args.arg1;
                        String callId2 = (String)args.arg2;
                        ConnectionService.this.conference(callId1, callId2);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 13: {
                    ConnectionService.this.splitFromConference((String)msg.obj);
                    break;
                }
                case 18: {
                    ConnectionService.this.mergeConference((String)msg.obj);
                    break;
                }
                case 19: {
                    ConnectionService.this.swapConference((String)msg.obj);
                    break;
                }
                case 14: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        String callId = (String)args.arg1;
                        boolean proceed = args.argi1 == 1;
                        ConnectionService.this.onPostDialContinue(callId, proceed);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
            }
        }
    };
    private final Conference.Listener mConferenceListener = new Conference.Listener(){

        @Override
        public void onStateChanged(Conference conference, int oldState, int newState) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            switch (newState) {
                case 4: {
                    ConnectionService.this.mAdapter.setActive(id2);
                    break;
                }
                case 5: {
                    ConnectionService.this.mAdapter.setOnHold(id2);
                    break;
                }
            }
        }

        @Override
        public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            ConnectionService.this.mAdapter.setDisconnected(id2, disconnectCause);
        }

        @Override
        public void onConnectionAdded(Conference conference, Connection connection) {
        }

        @Override
        public void onConnectionRemoved(Conference conference, Connection connection) {
        }

        @Override
        public void onConferenceableConnectionsChanged(Conference conference, List<Connection> conferenceableConnections) {
            ConnectionService.this.mAdapter.setConferenceableConnections((String)ConnectionService.this.mIdByConference.get(conference), ConnectionService.this.createConnectionIdList(conferenceableConnections));
        }

        @Override
        public void onDestroyed(Conference conference) {
            ConnectionService.this.removeConference(conference);
        }

        @Override
        public void onConnectionCapabilitiesChanged(Conference conference, int connectionCapabilities) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            Log.d(this, "call capabilities: conference: %s", Connection.capabilitiesToString(connectionCapabilities));
            ConnectionService.this.mAdapter.setConnectionCapabilities(id2, connectionCapabilities);
        }

        @Override
        public void onVideoStateChanged(Conference c, int videoState) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            Log.d(this, "onVideoStateChanged set video state %d", videoState);
            ConnectionService.this.mAdapter.setVideoState(id2, videoState);
        }

        @Override
        public void onVideoProviderChanged(Conference c, Connection.VideoProvider videoProvider) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            Log.d(this, "onVideoProviderChanged: Connection: %s, VideoProvider: %s", c, videoProvider);
            ConnectionService.this.mAdapter.setVideoProvider(id2, videoProvider);
        }

        @Override
        public void onStatusHintsChanged(Conference conference, StatusHints statusHints) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            ConnectionService.this.mAdapter.setStatusHints(id2, statusHints);
        }

        @Override
        public void onExtrasChanged(Conference conference, Bundle extras) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            ConnectionService.this.mAdapter.setExtras(id2, extras);
        }
    };
    private final Connection.Listener mConnectionListener = new Connection.Listener(){

        @Override
        public void onStateChanged(Connection c, int state) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter set state %s %s", id2, Connection.stateToString(state));
            switch (state) {
                case 4: {
                    ConnectionService.this.mAdapter.setActive(id2);
                    break;
                }
                case 3: {
                    ConnectionService.this.mAdapter.setDialing(id2);
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    ConnectionService.this.mAdapter.setOnHold(id2);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ConnectionService.this.mAdapter.setRinging(id2);
                }
            }
        }

        @Override
        public void onDisconnected(Connection c, DisconnectCause disconnectCause) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter set disconnected %s", disconnectCause);
            ConnectionService.this.mAdapter.setDisconnected(id2, disconnectCause);
        }

        @Override
        public void onVideoStateChanged(Connection c, int videoState) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter set video state %d", videoState);
            ConnectionService.this.mAdapter.setVideoState(id2, videoState);
        }

        @Override
        public void onAddressChanged(Connection c, Uri address, int presentation) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setAddress(id2, address, presentation);
        }

        @Override
        public void onCallerDisplayNameChanged(Connection c, String callerDisplayName, int presentation) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setCallerDisplayName(id2, callerDisplayName, presentation);
        }

        @Override
        public void onDestroyed(Connection c) {
            ConnectionService.this.removeConnection(c);
        }

        @Override
        public void onPostDialWait(Connection c, String remaining) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter onPostDialWait %s, %s", c, remaining);
            ConnectionService.this.mAdapter.onPostDialWait(id2, remaining);
        }

        @Override
        public void onPostDialChar(Connection c, char nextChar) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter onPostDialChar %s, %s", c, Character.valueOf(nextChar));
            ConnectionService.this.mAdapter.onPostDialChar(id2, nextChar);
        }

        @Override
        public void onRingbackRequested(Connection c, boolean ringback) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter onRingback %b", ringback);
            ConnectionService.this.mAdapter.setRingbackRequested(id2, ringback);
        }

        @Override
        public void onConnectionCapabilitiesChanged(Connection c, int capabilities) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "capabilities: parcelableconnection: %s", Connection.capabilitiesToString(capabilities));
            ConnectionService.this.mAdapter.setConnectionCapabilities(id2, capabilities);
        }

        @Override
        public void onVideoProviderChanged(Connection c, Connection.VideoProvider videoProvider) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "onVideoProviderChanged: Connection: %s, VideoProvider: %s", c, videoProvider);
            ConnectionService.this.mAdapter.setVideoProvider(id2, videoProvider);
        }

        @Override
        public void onAudioModeIsVoipChanged(Connection c, boolean isVoip) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setIsVoipAudioMode(id2, isVoip);
        }

        @Override
        public void onStatusHintsChanged(Connection c, StatusHints statusHints) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setStatusHints(id2, statusHints);
        }

        @Override
        public void onConferenceablesChanged(Connection connection, List<Conferenceable> conferenceables) {
            ConnectionService.this.mAdapter.setConferenceableConnections((String)ConnectionService.this.mIdByConnection.get(connection), ConnectionService.this.createIdList(conferenceables));
        }

        @Override
        public void onConferenceChanged(Connection connection, Conference conference) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(connection);
            if (id2 != null) {
                String conferenceId = null;
                if (conference != null) {
                    conferenceId = (String)ConnectionService.this.mIdByConference.get(conference);
                }
                ConnectionService.this.mAdapter.setIsConferenced(id2, conferenceId);
            }
        }

        @Override
        public void onConferenceMergeFailed(Connection connection) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(connection);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onConferenceMergeFailed(id2);
            }
        }

        @Override
        public void onExtrasChanged(Connection connection, Bundle extras) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(connection);
            if (id2 != null) {
                ConnectionService.this.mAdapter.setExtras(id2, extras);
            }
        }
    };

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.endAllConnections();
        return super.onUnbind(intent);
    }

    private void createConnection(PhoneAccountHandle callManagerAccount, String callId, ConnectionRequest request, boolean isIncoming, boolean isUnknown) {
        Uri address;
        Log.d(this, "createConnection, callManagerAccount: %s, callId: %s, request: %s, isIncoming: %b, isUnknown: %b", callManagerAccount, callId, request, isIncoming, isUnknown);
        Connection connection = isUnknown ? this.onCreateUnknownConnection(callManagerAccount, request) : (isIncoming ? this.onCreateIncomingConnection(callManagerAccount, request) : this.onCreateOutgoingConnection(callManagerAccount, request));
        Log.d(this, "createConnection, connection: %s", connection);
        if (connection == null) {
            connection = Connection.createFailedConnection(new DisconnectCause(1));
        }
        if (connection.getState() != 6) {
            this.addConnection(callId, connection);
        }
        String number = (address = connection.getAddress()) == null ? "null" : address.getSchemeSpecificPart();
        Log.v(this, "createConnection, number: %s, state: %s, capabilities: %s", Connection.toLogSafePhoneNumber(number), Connection.stateToString(connection.getState()), Connection.capabilitiesToString(connection.getConnectionCapabilities()));
        Log.d(this, "createConnection, calling handleCreateConnectionSuccessful %s", callId);
        this.mAdapter.handleCreateConnectionComplete(callId, request, new ParcelableConnection(request.getAccountHandle(), connection.getState(), connection.getConnectionCapabilities(), connection.getAddress(), connection.getAddressPresentation(), connection.getCallerDisplayName(), connection.getCallerDisplayNamePresentation(), connection.getVideoProvider() == null ? null : connection.getVideoProvider().getInterface(), connection.getVideoState(), connection.isRingbackRequested(), connection.getAudioModeIsVoip(), connection.getConnectTimeMillis(), connection.getStatusHints(), connection.getDisconnectCause(), this.createIdList(connection.getConferenceables()), connection.getExtras()));
    }

    private void abort(String callId) {
        Log.d(this, "abort %s", callId);
        this.findConnectionForAction(callId, "abort").onAbort();
    }

    private void answerVideo(String callId, int videoState) {
        Log.d(this, "answerVideo %s", callId);
        this.findConnectionForAction(callId, "answer").onAnswer(videoState);
    }

    private void answer(String callId) {
        Log.d(this, "answer %s", callId);
        this.findConnectionForAction(callId, "answer").onAnswer();
    }

    private void reject(String callId) {
        Log.d(this, "reject %s", callId);
        this.findConnectionForAction(callId, "reject").onReject();
    }

    private void disconnect(String callId) {
        Log.d(this, "disconnect %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "disconnect").onDisconnect();
        } else {
            this.findConferenceForAction(callId, "disconnect").onDisconnect();
        }
    }

    private void hold(String callId) {
        Log.d(this, "hold %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "hold").onHold();
        } else {
            this.findConferenceForAction(callId, "hold").onHold();
        }
    }

    private void unhold(String callId) {
        Log.d(this, "unhold %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "unhold").onUnhold();
        } else {
            this.findConferenceForAction(callId, "unhold").onUnhold();
        }
    }

    private void onCallAudioStateChanged(String callId, CallAudioState callAudioState) {
        Log.d(this, "onAudioStateChanged %s %s", callId, callAudioState);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "onCallAudioStateChanged").setCallAudioState(callAudioState);
        } else {
            this.findConferenceForAction(callId, "onCallAudioStateChanged").setCallAudioState(callAudioState);
        }
    }

    private void playDtmfTone(String callId, char digit) {
        Log.d(this, "playDtmfTone %s %c", callId, Character.valueOf(digit));
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "playDtmfTone").onPlayDtmfTone(digit);
        } else {
            this.findConferenceForAction(callId, "playDtmfTone").onPlayDtmfTone(digit);
        }
    }

    private void stopDtmfTone(String callId) {
        Log.d(this, "stopDtmfTone %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "stopDtmfTone").onStopDtmfTone();
        } else {
            this.findConferenceForAction(callId, "stopDtmfTone").onStopDtmfTone();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void conference(String callId1, String callId2) {
        Log.d(this, "conference %s, %s", callId1, callId2);
        Connection connection2 = this.findConnectionForAction(callId2, "conference");
        Conference conference2 = this.getNullConference();
        if (connection2 == ConnectionService.getNullConnection() && (conference2 = this.findConferenceForAction(callId2, "conference")) == this.getNullConference()) {
            Log.w(this, "Connection2 or Conference2 missing in conference request %s.", callId2);
            return;
        }
        Connection connection1 = this.findConnectionForAction(callId1, "conference");
        if (connection1 == ConnectionService.getNullConnection()) {
            Conference conference1 = this.findConferenceForAction(callId1, "addConnection");
            if (conference1 == this.getNullConference()) {
                Log.w(this, "Connection1 or Conference1 missing in conference request %s.", callId1);
                return;
            }
            if (connection2 != ConnectionService.getNullConnection()) {
                conference1.onMerge(connection2);
                return;
            }
            Log.wtf((Object)this, "There can only be one conference and an attempt was made to merge two conferences.", new Object[0]);
            return;
        }
        if (conference2 != this.getNullConference()) {
            conference2.onMerge(connection1);
            return;
        }
        this.onConference(connection1, connection2);
    }

    private void splitFromConference(String callId) {
        Log.d(this, "splitFromConference(%s)", callId);
        Connection connection = this.findConnectionForAction(callId, "splitFromConference");
        if (connection == ConnectionService.getNullConnection()) {
            Log.w(this, "Connection missing in conference request %s.", callId);
            return;
        }
        Conference conference = connection.getConference();
        if (conference != null) {
            conference.onSeparate(connection);
        }
    }

    private void mergeConference(String callId) {
        Log.d(this, "mergeConference(%s)", callId);
        Conference conference = this.findConferenceForAction(callId, "mergeConference");
        if (conference != null) {
            conference.onMerge();
        }
    }

    private void swapConference(String callId) {
        Log.d(this, "swapConference(%s)", callId);
        Conference conference = this.findConferenceForAction(callId, "swapConference");
        if (conference != null) {
            conference.onSwap();
        }
    }

    private void onPostDialContinue(String callId, boolean proceed) {
        Log.d(this, "onPostDialContinue(%s)", callId);
        this.findConnectionForAction(callId, "stopDtmfTone").onPostDialContinue(proceed);
    }

    private void onAdapterAttached() {
        if (this.mAreAccountsInitialized) {
            return;
        }
        this.mAdapter.queryRemoteConnectionServices(new RemoteServiceCallback.Stub(){

            @Override
            public void onResult(final List<ComponentName> componentNames, final List<IBinder> services) {
                ConnectionService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < componentNames.size() && i < services.size(); ++i) {
                            ConnectionService.this.mRemoteConnectionManager.addConnectionService((ComponentName)componentNames.get(i), IConnectionService.Stub.asInterface((IBinder)services.get(i)));
                        }
                        ConnectionService.this.onAccountsInitialized();
                        Log.d(this, "remote connection services found: " + services, new Object[0]);
                    }
                });
            }

            @Override
            public void onError() {
                ConnectionService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionService.this.mAreAccountsInitialized = true;
                    }
                });
            }
        });
    }

    public final RemoteConnection createRemoteIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return this.mRemoteConnectionManager.createRemoteConnection(connectionManagerPhoneAccount, request, true);
    }

    public final RemoteConnection createRemoteOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return this.mRemoteConnectionManager.createRemoteConnection(connectionManagerPhoneAccount, request, false);
    }

    public final void conferenceRemoteConnections(RemoteConnection remoteConnection1, RemoteConnection remoteConnection2) {
        this.mRemoteConnectionManager.conferenceRemoteConnections(remoteConnection1, remoteConnection2);
    }

    public final void addConference(Conference conference) {
        Log.d(this, "addConference: conference=%s", conference);
        String id2 = this.addConferenceInternal(conference);
        if (id2 != null) {
            ArrayList<String> connectionIds = new ArrayList<String>(2);
            for (Connection connection : conference.getConnections()) {
                if (!this.mIdByConnection.containsKey(connection)) continue;
                connectionIds.add(this.mIdByConnection.get(connection));
            }
            ParcelableConference parcelableConference = new ParcelableConference(conference.getPhoneAccountHandle(), conference.getState(), conference.getConnectionCapabilities(), connectionIds, conference.getVideoProvider() == null ? null : conference.getVideoProvider().getInterface(), conference.getVideoState(), conference.getConnectTimeMillis(), conference.getStatusHints(), conference.getExtras());
            this.mAdapter.addConferenceCall(id2, parcelableConference);
            this.mAdapter.setVideoProvider(id2, conference.getVideoProvider());
            this.mAdapter.setVideoState(id2, conference.getVideoState());
            for (Connection connection : conference.getConnections()) {
                String connectionId = this.mIdByConnection.get(connection);
                if (connectionId == null) continue;
                this.mAdapter.setIsConferenced(connectionId, id2);
            }
        }
    }

    public final void addExistingConnection(PhoneAccountHandle phoneAccountHandle, Connection connection) {
        String id2 = this.addExistingConnectionInternal(connection);
        if (id2 != null) {
            ArrayList<String> emptyList = new ArrayList<String>(0);
            ParcelableConnection parcelableConnection = new ParcelableConnection(phoneAccountHandle, connection.getState(), connection.getConnectionCapabilities(), connection.getAddress(), connection.getAddressPresentation(), connection.getCallerDisplayName(), connection.getCallerDisplayNamePresentation(), connection.getVideoProvider() == null ? null : connection.getVideoProvider().getInterface(), connection.getVideoState(), connection.isRingbackRequested(), connection.getAudioModeIsVoip(), connection.getConnectTimeMillis(), connection.getStatusHints(), connection.getDisconnectCause(), emptyList, connection.getExtras());
            this.mAdapter.addExistingConnection(id2, parcelableConnection);
        }
    }

    public final Collection<Connection> getAllConnections() {
        return this.mConnectionById.values();
    }

    public Connection onCreateIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    public Connection onCreateOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    public Connection onCreateUnknownConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    public void onConference(Connection connection1, Connection connection2) {
    }

    public void onRemoteConferenceAdded(RemoteConference conference) {
    }

    public void onRemoteExistingConnectionAdded(RemoteConnection connection) {
    }

    public boolean containsConference(Conference conference) {
        return this.mIdByConference.containsKey(conference);
    }

    void addRemoteConference(RemoteConference remoteConference) {
        this.onRemoteConferenceAdded(remoteConference);
    }

    void addRemoteExistingConnection(RemoteConnection remoteConnection) {
        this.onRemoteExistingConnectionAdded(remoteConnection);
    }

    private void onAccountsInitialized() {
        this.mAreAccountsInitialized = true;
        for (Runnable r : this.mPreInitializationConnectionRequests) {
            r.run();
        }
        this.mPreInitializationConnectionRequests.clear();
    }

    private String addExistingConnectionInternal(Connection connection) {
        String id2 = UUID.randomUUID().toString();
        this.addConnection(id2, connection);
        return id2;
    }

    private void addConnection(String callId, Connection connection) {
        this.mConnectionById.put(callId, connection);
        this.mIdByConnection.put(connection, callId);
        connection.addConnectionListener(this.mConnectionListener);
        connection.setConnectionService(this);
    }

    protected void removeConnection(Connection connection) {
        String id2 = this.mIdByConnection.get(connection);
        connection.unsetConnectionService(this);
        connection.removeConnectionListener(this.mConnectionListener);
        this.mConnectionById.remove(this.mIdByConnection.get(connection));
        this.mIdByConnection.remove(connection);
        this.mAdapter.removeCall(id2);
    }

    private String addConferenceInternal(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            Log.w(this, "Re-adding an existing conference: %s.", conference);
        } else if (conference != null) {
            String id2 = UUID.randomUUID().toString();
            this.mConferenceById.put(id2, conference);
            this.mIdByConference.put(conference, id2);
            conference.addListener(this.mConferenceListener);
            return id2;
        }
        return null;
    }

    private void removeConference(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            conference.removeListener(this.mConferenceListener);
            String id2 = this.mIdByConference.get(conference);
            this.mConferenceById.remove(id2);
            this.mIdByConference.remove(conference);
            this.mAdapter.removeCall(id2);
        }
    }

    private Connection findConnectionForAction(String callId, String action) {
        if (this.mConnectionById.containsKey(callId)) {
            return this.mConnectionById.get(callId);
        }
        Log.w(this, "%s - Cannot find Connection %s", action, callId);
        return ConnectionService.getNullConnection();
    }

    static synchronized Connection getNullConnection() {
        if (sNullConnection == null) {
            sNullConnection = new Connection(){};
        }
        return sNullConnection;
    }

    private Conference findConferenceForAction(String conferenceId, String action) {
        if (this.mConferenceById.containsKey(conferenceId)) {
            return this.mConferenceById.get(conferenceId);
        }
        Log.w(this, "%s - Cannot find conference %s", action, conferenceId);
        return this.getNullConference();
    }

    private List<String> createConnectionIdList(List<Connection> connections) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Connection c : connections) {
            if (!this.mIdByConnection.containsKey(c)) continue;
            ids.add(this.mIdByConnection.get(c));
        }
        Collections.sort(ids);
        return ids;
    }

    private List<String> createIdList(List<Conferenceable> conferenceables) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Conferenceable c : conferenceables) {
            Conference conference;
            if (c instanceof Connection) {
                Connection connection = (Connection)c;
                if (!this.mIdByConnection.containsKey(connection)) continue;
                ids.add(this.mIdByConnection.get(connection));
                continue;
            }
            if (!(c instanceof Conference) || !this.mIdByConference.containsKey(conference = (Conference)c)) continue;
            ids.add(this.mIdByConference.get(conference));
        }
        Collections.sort(ids);
        return ids;
    }

    private Conference getNullConference() {
        if (this.sNullConference == null) {
            this.sNullConference = new Conference(null){};
        }
        return this.sNullConference;
    }

    private void endAllConnections() {
        for (Connection connection : this.mIdByConnection.keySet()) {
            if (connection.getConference() != null) continue;
            connection.onDisconnect();
        }
        for (Conference conference : this.mIdByConference.keySet()) {
            conference.onDisconnect();
        }
    }
}

