/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class DefaultDialerManager {
    private static final String TAG = "DefaultDialerManager";

    public static boolean setDefaultDialerApplication(Context context, String packageName) {
        return DefaultDialerManager.setDefaultDialerApplication(context, packageName, ActivityManager.getCurrentUser());
    }

    public static boolean setDefaultDialerApplication(Context context, String packageName, int user) {
        String oldPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "dialer_default_application", user);
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return false;
        }
        List<String> packageNames = DefaultDialerManager.getInstalledDialerApplications(context);
        if (packageNames.contains(packageName)) {
            Settings.Secure.putStringForUser(context.getContentResolver(), "dialer_default_application", packageName, user);
            return true;
        }
        return false;
    }

    public static String getDefaultDialerApplication(Context context) {
        return DefaultDialerManager.getDefaultDialerApplication(context, context.getUserId());
    }

    public static String getDefaultDialerApplication(Context context, int user) {
        String defaultPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "dialer_default_application", user);
        List<String> packageNames = DefaultDialerManager.getInstalledDialerApplications(context);
        if (packageNames.contains(defaultPackageName)) {
            return defaultPackageName;
        }
        String systemDialerPackageName = DefaultDialerManager.getTelecomManager(context).getSystemDialerPackage();
        if (TextUtils.isEmpty(systemDialerPackageName)) {
            return null;
        }
        if (packageNames.contains(systemDialerPackageName)) {
            return systemDialerPackageName;
        }
        return null;
    }

    public static List<String> getInstalledDialerApplications(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.DIAL");
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivities(intent, 0);
        ArrayList<String> packageNames = new ArrayList<String>();
        for (ResolveInfo resolveInfo : resolveInfoList) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || packageNames.contains(activityInfo.packageName)) continue;
            packageNames.add(activityInfo.packageName);
        }
        Intent dialIntentWithTelScheme = new Intent("android.intent.action.DIAL");
        dialIntentWithTelScheme.setData(Uri.fromParts("tel", "", null));
        return DefaultDialerManager.filterByIntent(context, packageNames, dialIntentWithTelScheme);
    }

    public static boolean isDefaultOrSystemDialer(Context context, String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        TelecomManager tm = DefaultDialerManager.getTelecomManager(context);
        return packageName.equals(tm.getDefaultDialerPackage()) || packageName.equals(tm.getSystemDialerPackage());
    }

    private static List<String> filterByIntent(Context context, List<String> packageNames, Intent intent) {
        if (packageNames == null || packageNames.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        List<ResolveInfo> resolveInfoList = context.getPackageManager().queryIntentActivities(intent, 0);
        int length = resolveInfoList.size();
        for (int i = 0; i < length; ++i) {
            ActivityInfo info = resolveInfoList.get((int)i).activityInfo;
            if (info == null || !packageNames.contains(info.packageName) || result.contains(info.packageName)) continue;
            result.add(info.packageName);
        }
        return result;
    }

    private static TelecomManager getTelecomManager(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }
}

