/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.emoji.EmojiFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.text.AndroidBidi;
import android.text.GetChars;
import android.text.MeasuredText;
import android.text.SpanSet;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextLine;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.TextKeyListener;
import android.text.style.AlignmentSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineBackgroundSpan;
import android.text.style.ParagraphStyle;
import android.text.style.ReplacementSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.util.Arrays;

public abstract class Layout {
    public static final int BREAK_STRATEGY_SIMPLE = 0;
    public static final int BREAK_STRATEGY_HIGH_QUALITY = 1;
    public static final int BREAK_STRATEGY_BALANCED = 2;
    public static final int HYPHENATION_FREQUENCY_NONE = 0;
    public static final int HYPHENATION_FREQUENCY_NORMAL = 1;
    public static final int HYPHENATION_FREQUENCY_FULL = 2;
    private static final ParagraphStyle[] NO_PARA_SPANS = ArrayUtils.emptyArray(ParagraphStyle.class);
    static final EmojiFactory EMOJI_FACTORY = EmojiFactory.newAvailableInstance();
    static final int MIN_EMOJI;
    static final int MAX_EMOJI;
    private CharSequence mText;
    private TextPaint mPaint;
    private int mWidth;
    private Alignment mAlignment = Alignment.ALIGN_NORMAL;
    private float mSpacingMult;
    private float mSpacingAdd;
    private static final Rect sTempRect;
    private boolean mSpannedText;
    private TextDirectionHeuristic mTextDir;
    private SpanSet<LineBackgroundSpan> mLineBackgroundSpans;
    public static final int DIR_LEFT_TO_RIGHT = 1;
    public static final int DIR_RIGHT_TO_LEFT = -1;
    static final int DIR_REQUEST_LTR = 1;
    static final int DIR_REQUEST_RTL = -1;
    static final int DIR_REQUEST_DEFAULT_LTR = 2;
    static final int DIR_REQUEST_DEFAULT_RTL = -2;
    static final int RUN_LENGTH_MASK = 0x3FFFFFF;
    static final int RUN_LEVEL_SHIFT = 26;
    static final int RUN_LEVEL_MASK = 63;
    static final int RUN_RTL_FLAG = 0x4000000;
    private static final int TAB_INCREMENT = 20;
    static final Directions DIRS_ALL_LEFT_TO_RIGHT;
    static final Directions DIRS_ALL_RIGHT_TO_LEFT;

    public static float getDesiredWidth(CharSequence source, TextPaint paint) {
        return Layout.getDesiredWidth(source, 0, source.length(), paint);
    }

    public static float getDesiredWidth(CharSequence source, int start, int end, TextPaint paint) {
        float need = 0.0f;
        int i = start;
        while (i <= end) {
            float w;
            int next = TextUtils.indexOf(source, '\n', i, end);
            if (next < 0) {
                next = end;
            }
            if ((w = Layout.measurePara(paint, source, i, next)) > need) {
                need = w;
            }
            i = ++next;
        }
        return need;
    }

    protected Layout(CharSequence text, TextPaint paint, int width, Alignment align, float spacingMult, float spacingAdd) {
        this(text, paint, width, align, TextDirectionHeuristics.FIRSTSTRONG_LTR, spacingMult, spacingAdd);
    }

    protected Layout(CharSequence text, TextPaint paint, int width, Alignment align, TextDirectionHeuristic textDir, float spacingMult, float spacingAdd) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        if (paint != null) {
            paint.bgColor = 0;
            paint.baselineShift = 0;
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpacingMult = spacingMult;
        this.mSpacingAdd = spacingAdd;
        this.mSpannedText = text instanceof Spanned;
        this.mTextDir = textDir;
    }

    void replaceWith(CharSequence text, TextPaint paint, int width, Alignment align, float spacingmult, float spacingadd) {
        if (width < 0) {
            throw new IllegalArgumentException("Layout: " + width + " < 0");
        }
        this.mText = text;
        this.mPaint = paint;
        this.mWidth = width;
        this.mAlignment = align;
        this.mSpacingMult = spacingmult;
        this.mSpacingAdd = spacingadd;
        this.mSpannedText = text instanceof Spanned;
    }

    public void draw(Canvas c) {
        this.draw(c, null, null, 0);
    }

    public void draw(Canvas canvas, Path highlight, Paint highlightPaint, int cursorOffsetVertical) {
        long lineRange = this.getLineRangeForDraw(canvas);
        int firstLine = TextUtils.unpackRangeStartFromLong(lineRange);
        int lastLine = TextUtils.unpackRangeEndFromLong(lineRange);
        if (lastLine < 0) {
            return;
        }
        this.drawBackground(canvas, highlight, highlightPaint, cursorOffsetVertical, firstLine, lastLine);
        this.drawText(canvas, firstLine, lastLine);
    }

    public void drawText(Canvas canvas, int firstLine, int lastLine) {
        int previousLineBottom = this.getLineTop(firstLine);
        int previousLineEnd = this.getLineStart(firstLine);
        Object[] spans = NO_PARA_SPANS;
        int spanEnd = 0;
        TextPaint paint = this.mPaint;
        CharSequence buf = this.mText;
        Alignment paraAlign = this.mAlignment;
        TabStops tabStops = null;
        boolean tabStopsIsInitialized = false;
        TextLine tl = TextLine.obtain();
        for (int lineNum = firstLine; lineNum <= lastLine; ++lineNum) {
            int x;
            Alignment align;
            boolean hasTabOrEmoji;
            int lbottom;
            int start = previousLineEnd;
            previousLineEnd = this.getLineStart(lineNum + 1);
            int end = this.getLineVisibleEnd(lineNum, start, previousLineEnd);
            int ltop = previousLineBottom;
            previousLineBottom = lbottom = this.getLineTop(lineNum + 1);
            int lbaseline = lbottom - this.getLineDescent(lineNum);
            int dir = this.getParagraphDirection(lineNum);
            int left = 0;
            int right = this.mWidth;
            if (this.mSpannedText) {
                int n;
                boolean isFirstParaLine;
                Spanned sp = (Spanned)buf;
                int textLength = buf.length();
                boolean bl = isFirstParaLine = start == 0 || buf.charAt(start - 1) == '\n';
                if (start >= spanEnd && (lineNum == firstLine || isFirstParaLine)) {
                    spanEnd = sp.nextSpanTransition(start, textLength, ParagraphStyle.class);
                    spans = Layout.getParagraphSpans(sp, start, spanEnd, ParagraphStyle.class);
                    paraAlign = this.mAlignment;
                    for (int n2 = spans.length - 1; n2 >= 0; --n2) {
                        if (!(spans[n2] instanceof AlignmentSpan)) continue;
                        paraAlign = ((AlignmentSpan)spans[n2]).getAlignment();
                        break;
                    }
                    tabStopsIsInitialized = false;
                }
                int length = spans.length;
                boolean useFirstLineMargin = isFirstParaLine;
                for (n = 0; n < length; ++n) {
                    if (!(spans[n] instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    int count = ((LeadingMarginSpan.LeadingMarginSpan2)spans[n]).getLeadingMarginLineCount();
                    int startLine = this.getLineForOffset(sp.getSpanStart(spans[n]));
                    if (lineNum >= startLine + count) continue;
                    useFirstLineMargin = true;
                    break;
                }
                for (n = 0; n < length; ++n) {
                    if (!(spans[n] instanceof LeadingMarginSpan)) continue;
                    LeadingMarginSpan margin = (LeadingMarginSpan)spans[n];
                    if (dir == -1) {
                        margin.drawLeadingMargin(canvas, paint, right, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                        right -= margin.getLeadingMargin(useFirstLineMargin);
                        continue;
                    }
                    margin.drawLeadingMargin(canvas, paint, left, dir, ltop, lbaseline, lbottom, buf, start, end, isFirstParaLine, this);
                    left += margin.getLeadingMargin(useFirstLineMargin);
                }
            }
            if ((hasTabOrEmoji = this.getLineContainsTab(lineNum)) && !tabStopsIsInitialized) {
                if (tabStops == null) {
                    tabStops = new TabStops(20, spans);
                } else {
                    tabStops.reset(20, spans);
                }
                tabStopsIsInitialized = true;
            }
            if ((align = paraAlign) == Alignment.ALIGN_LEFT) {
                align = dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
            } else if (align == Alignment.ALIGN_RIGHT) {
                Alignment alignment = align = dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
            }
            if (align == Alignment.ALIGN_NORMAL) {
                x = dir == 1 ? left + this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT) : right + this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT);
            } else {
                int max = (int)this.getLineExtent(lineNum, tabStops, false);
                x = align == Alignment.ALIGN_OPPOSITE ? (dir == 1 ? right - max + this.getIndentAdjust(lineNum, Alignment.ALIGN_RIGHT) : left - max + this.getIndentAdjust(lineNum, Alignment.ALIGN_LEFT)) : (right + left - (max &= 0xFFFFFFFE) >> 1) + this.getIndentAdjust(lineNum, Alignment.ALIGN_CENTER);
            }
            paint.setHyphenEdit(this.getHyphen(lineNum));
            Directions directions = this.getLineDirections(lineNum);
            if (directions == DIRS_ALL_LEFT_TO_RIGHT && !this.mSpannedText && !hasTabOrEmoji) {
                canvas.drawText(buf, start, end, (float)x, (float)lbaseline, (Paint)paint);
            } else {
                tl.set(paint, buf, start, end, dir, directions, hasTabOrEmoji, tabStops);
                tl.draw(canvas, x, ltop, lbaseline, lbottom);
            }
            paint.setHyphenEdit(0);
        }
        TextLine.recycle(tl);
    }

    public void drawBackground(Canvas canvas, Path highlight, Paint highlightPaint, int cursorOffsetVertical, int firstLine, int lastLine) {
        if (this.mSpannedText) {
            if (this.mLineBackgroundSpans == null) {
                this.mLineBackgroundSpans = new SpanSet<LineBackgroundSpan>(LineBackgroundSpan.class);
            }
            Spanned buffer = (Spanned)this.mText;
            int textLength = buffer.length();
            this.mLineBackgroundSpans.init(buffer, 0, textLength);
            if (this.mLineBackgroundSpans.numberOfSpans > 0) {
                int previousLineBottom = this.getLineTop(firstLine);
                int previousLineEnd = this.getLineStart(firstLine);
                ParagraphStyle[] spans = NO_PARA_SPANS;
                int spansLength = 0;
                TextPaint paint = this.mPaint;
                int spanEnd = 0;
                int width = this.mWidth;
                for (int i = firstLine; i <= lastLine; ++i) {
                    int lbottom;
                    int end;
                    int start = previousLineEnd;
                    previousLineEnd = end = this.getLineStart(i + 1);
                    int ltop = previousLineBottom;
                    previousLineBottom = lbottom = this.getLineTop(i + 1);
                    int lbaseline = lbottom - this.getLineDescent(i);
                    if (start >= spanEnd) {
                        spanEnd = this.mLineBackgroundSpans.getNextTransition(start, textLength);
                        spansLength = 0;
                        if (start != end || start == 0) {
                            for (int j = 0; j < this.mLineBackgroundSpans.numberOfSpans; ++j) {
                                if (this.mLineBackgroundSpans.spanStarts[j] >= end || this.mLineBackgroundSpans.spanEnds[j] <= start) continue;
                                spans = GrowingArrayUtils.append(spans, spansLength, ((LineBackgroundSpan[])this.mLineBackgroundSpans.spans)[j]);
                                ++spansLength;
                            }
                        }
                    }
                    for (int n = 0; n < spansLength; ++n) {
                        LineBackgroundSpan lineBackgroundSpan = (LineBackgroundSpan)spans[n];
                        lineBackgroundSpan.drawBackground(canvas, paint, 0, width, ltop, lbaseline, lbottom, buffer, start, end, i);
                    }
                }
            }
            this.mLineBackgroundSpans.recycle();
        }
        if (highlight != null) {
            if (cursorOffsetVertical != 0) {
                canvas.translate(0.0f, cursorOffsetVertical);
            }
            canvas.drawPath(highlight, highlightPaint);
            if (cursorOffsetVertical != 0) {
                canvas.translate(0.0f, -cursorOffsetVertical);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLineRangeForDraw(Canvas canvas) {
        int dbottom;
        int dtop;
        Rect rect = sTempRect;
        synchronized (rect) {
            if (!canvas.getClipBounds(sTempRect)) {
                return TextUtils.packRangeInLong(0, -1);
            }
            dtop = Layout.sTempRect.top;
            dbottom = Layout.sTempRect.bottom;
        }
        int top = Math.max(dtop, 0);
        int bottom = Math.min(this.getLineTop(this.getLineCount()), dbottom);
        if (top >= bottom) {
            return TextUtils.packRangeInLong(0, -1);
        }
        return TextUtils.packRangeInLong(this.getLineForVertical(top), this.getLineForVertical(bottom));
    }

    private int getLineStartPos(int line, int left, int right) {
        int x;
        Alignment align = this.getParagraphAlignment(line);
        int dir = this.getParagraphDirection(line);
        if (align == Alignment.ALIGN_LEFT) {
            align = dir == 1 ? Alignment.ALIGN_NORMAL : Alignment.ALIGN_OPPOSITE;
        } else if (align == Alignment.ALIGN_RIGHT) {
            Alignment alignment = align = dir == 1 ? Alignment.ALIGN_OPPOSITE : Alignment.ALIGN_NORMAL;
        }
        if (align == Alignment.ALIGN_NORMAL) {
            x = dir == 1 ? left + this.getIndentAdjust(line, Alignment.ALIGN_LEFT) : right + this.getIndentAdjust(line, Alignment.ALIGN_RIGHT);
        } else {
            int spanEnd;
            int start;
            Spanned spanned;
            Object[] tabSpans;
            TabStops tabStops = null;
            if (this.mSpannedText && this.getLineContainsTab(line) && (tabSpans = Layout.getParagraphSpans(spanned = (Spanned)this.mText, start = this.getLineStart(line), spanEnd = spanned.nextSpanTransition(start, spanned.length(), TabStopSpan.class), TabStopSpan.class)).length > 0) {
                tabStops = new TabStops(20, tabSpans);
            }
            int max = (int)this.getLineExtent(line, tabStops, false);
            x = align == Alignment.ALIGN_OPPOSITE ? (dir == 1 ? right - max + this.getIndentAdjust(line, Alignment.ALIGN_RIGHT) : left - max + this.getIndentAdjust(line, Alignment.ALIGN_LEFT)) : left + right - (max &= 0xFFFFFFFE) >> 1 + this.getIndentAdjust(line, Alignment.ALIGN_CENTER);
        }
        return x;
    }

    public final CharSequence getText() {
        return this.mText;
    }

    public final TextPaint getPaint() {
        return this.mPaint;
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public int getEllipsizedWidth() {
        return this.mWidth;
    }

    public final void increaseWidthTo(int wid) {
        if (wid < this.mWidth) {
            throw new RuntimeException("attempted to reduce Layout width");
        }
        this.mWidth = wid;
    }

    public int getHeight() {
        return this.getLineTop(this.getLineCount());
    }

    public final Alignment getAlignment() {
        return this.mAlignment;
    }

    public final float getSpacingMultiplier() {
        return this.mSpacingMult;
    }

    public final float getSpacingAdd() {
        return this.mSpacingAdd;
    }

    public final TextDirectionHeuristic getTextDirectionHeuristic() {
        return this.mTextDir;
    }

    public abstract int getLineCount();

    public int getLineBounds(int line, Rect bounds) {
        if (bounds != null) {
            bounds.left = 0;
            bounds.top = this.getLineTop(line);
            bounds.right = this.mWidth;
            bounds.bottom = this.getLineTop(line + 1);
        }
        return this.getLineBaseline(line);
    }

    public abstract int getLineTop(int var1);

    public abstract int getLineDescent(int var1);

    public abstract int getLineStart(int var1);

    public abstract int getParagraphDirection(int var1);

    public abstract boolean getLineContainsTab(int var1);

    public abstract Directions getLineDirections(int var1);

    public abstract int getTopPadding();

    public abstract int getBottomPadding();

    public int getHyphen(int line) {
        return 0;
    }

    public int getIndentAdjust(int line, Alignment alignment) {
        return 0;
    }

    public boolean isLevelBoundary(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == DIRS_ALL_LEFT_TO_RIGHT || dirs == DIRS_ALL_RIGHT_TO_LEFT) {
            return false;
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        if (offset == lineStart || offset == lineEnd) {
            int paraLevel = this.getParagraphDirection(line) == 1 ? 0 : 1;
            int runIndex = offset == lineStart ? 0 : runs.length - 2;
            return (runs[runIndex + 1] >>> 26 & 0x3F) != paraLevel;
        }
        offset -= lineStart;
        for (int i = 0; i < runs.length; i += 2) {
            if (offset != runs[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isRtlCharAt(int offset) {
        int line = this.getLineForOffset(offset);
        Directions dirs = this.getLineDirections(line);
        if (dirs == DIRS_ALL_LEFT_TO_RIGHT) {
            return false;
        }
        if (dirs == DIRS_ALL_RIGHT_TO_LEFT) {
            return true;
        }
        int[] runs = dirs.mDirections;
        int lineStart = this.getLineStart(line);
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (offset < start || offset >= limit) continue;
            int level = runs[i + 1] >>> 26 & 0x3F;
            return (level & 1) != 0;
        }
        return false;
    }

    private boolean primaryIsTrailingPrevious(int offset) {
        int line = this.getLineForOffset(offset);
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int[] runs = this.getLineDirections((int)line).mDirections;
        int levelAt = -1;
        for (int i = 0; i < runs.length; i += 2) {
            int start = lineStart + runs[i];
            int limit = start + (runs[i + 1] & 0x3FFFFFF);
            if (limit > lineEnd) {
                limit = lineEnd;
            }
            if (offset < start || offset >= limit) continue;
            if (offset > start) {
                return false;
            }
            levelAt = runs[i + 1] >>> 26 & 0x3F;
            break;
        }
        if (levelAt == -1) {
            levelAt = this.getParagraphDirection(line) == 1 ? 0 : 1;
        }
        int levelBefore = -1;
        if (offset == lineStart) {
            levelBefore = this.getParagraphDirection(line) == 1 ? 0 : 1;
        } else {
            --offset;
            for (int i = 0; i < runs.length; i += 2) {
                int start = lineStart + runs[i];
                int limit = start + (runs[i + 1] & 0x3FFFFFF);
                if (limit > lineEnd) {
                    limit = lineEnd;
                }
                if (offset < start || offset >= limit) continue;
                levelBefore = runs[i + 1] >>> 26 & 0x3F;
                break;
            }
        }
        return levelBefore < levelAt;
    }

    public float getPrimaryHorizontal(int offset) {
        return this.getPrimaryHorizontal(offset, false);
    }

    public float getPrimaryHorizontal(int offset, boolean clamped) {
        boolean trailing = this.primaryIsTrailingPrevious(offset);
        return this.getHorizontal(offset, trailing, clamped);
    }

    public float getSecondaryHorizontal(int offset) {
        return this.getSecondaryHorizontal(offset, false);
    }

    public float getSecondaryHorizontal(int offset, boolean clamped) {
        boolean trailing = this.primaryIsTrailingPrevious(offset);
        return this.getHorizontal(offset, !trailing, clamped);
    }

    private float getHorizontal(int offset, boolean trailing, boolean clamped) {
        int line = this.getLineForOffset(offset);
        return this.getHorizontal(offset, trailing, line, clamped);
    }

    private float getHorizontal(int offset, boolean trailing, int line, boolean clamped) {
        Object[] tabs;
        int start = this.getLineStart(line);
        int end = this.getLineEnd(line);
        int dir = this.getParagraphDirection(line);
        boolean hasTabOrEmoji = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        TabStops tabStops = null;
        if (hasTabOrEmoji && this.mText instanceof Spanned && (tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).length > 0) {
            tabStops = new TabStops(20, tabs);
        }
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTabOrEmoji, tabStops);
        float wid = tl.measure(offset - start, trailing, null);
        TextLine.recycle(tl);
        if (clamped && wid > (float)this.mWidth) {
            wid = this.mWidth;
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        return (float)this.getLineStartPos(line, left, right) + wid;
    }

    public float getLineLeft(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == Alignment.ALIGN_LEFT) {
            return 0.0f;
        }
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return (float)this.getParagraphRight(line) - this.getLineMax(line);
            }
            return 0.0f;
        }
        if (align == Alignment.ALIGN_RIGHT) {
            return (float)this.mWidth - this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return 0.0f;
            }
            return (float)this.mWidth - this.getLineMax(line);
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int max = (int)this.getLineMax(line) & 0xFFFFFFFE;
        return left + (right - left - max) / 2;
    }

    public float getLineRight(int line) {
        int dir = this.getParagraphDirection(line);
        Alignment align = this.getParagraphAlignment(line);
        if (align == Alignment.ALIGN_LEFT) {
            return (float)this.getParagraphLeft(line) + this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_NORMAL) {
            if (dir == -1) {
                return this.mWidth;
            }
            return (float)this.getParagraphLeft(line) + this.getLineMax(line);
        }
        if (align == Alignment.ALIGN_RIGHT) {
            return this.mWidth;
        }
        if (align == Alignment.ALIGN_OPPOSITE) {
            if (dir == -1) {
                return this.getLineMax(line);
            }
            return this.mWidth;
        }
        int left = this.getParagraphLeft(line);
        int right = this.getParagraphRight(line);
        int max = (int)this.getLineMax(line) & 0xFFFFFFFE;
        return right - (right - left - max) / 2;
    }

    public float getLineMax(int line) {
        float margin = this.getParagraphLeadingMargin(line);
        float signedExtent = this.getLineExtent(line, false);
        return margin + (signedExtent >= 0.0f ? signedExtent : -signedExtent);
    }

    public float getLineWidth(int line) {
        float margin = this.getParagraphLeadingMargin(line);
        float signedExtent = this.getLineExtent(line, true);
        return margin + (signedExtent >= 0.0f ? signedExtent : -signedExtent);
    }

    private float getLineExtent(int line, boolean full) {
        Directions directions;
        Object[] tabs;
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean hasTabsOrEmoji = this.getLineContainsTab(line);
        TabStops tabStops = null;
        if (hasTabsOrEmoji && this.mText instanceof Spanned && (tabs = Layout.getParagraphSpans((Spanned)this.mText, start, end, TabStopSpan.class)).length > 0) {
            tabStops = new TabStops(20, tabs);
        }
        if ((directions = this.getLineDirections(line)) == null) {
            return 0.0f;
        }
        int dir = this.getParagraphDirection(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTabsOrEmoji, tabStops);
        float width = tl.metrics(null);
        TextLine.recycle(tl);
        return width;
    }

    private float getLineExtent(int line, TabStops tabStops, boolean full) {
        int start = this.getLineStart(line);
        int end = full ? this.getLineEnd(line) : this.getLineVisibleEnd(line);
        boolean hasTabsOrEmoji = this.getLineContainsTab(line);
        Directions directions = this.getLineDirections(line);
        int dir = this.getParagraphDirection(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, start, end, dir, directions, hasTabsOrEmoji, tabStops);
        float width = tl.metrics(null);
        TextLine.recycle(tl);
        return width;
    }

    public int getLineForVertical(int vertical) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineTop(guess) > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    public int getLineForOffset(int offset) {
        int high = this.getLineCount();
        int low = -1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (this.getLineStart(guess) > offset) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    public int getOffsetForHorizontal(int line, float horiz) {
        int max = this.getLineEnd(line) - 1;
        int min = this.getLineStart(line);
        Directions dirs = this.getLineDirections(line);
        if (line == this.getLineCount() - 1) {
            ++max;
        }
        int best = min;
        float bestdist = Math.abs(this.getPrimaryHorizontal(best) - horiz);
        for (int i = 0; i < dirs.mDirections.length; i += 2) {
            float dist;
            int swap;
            int here = min + dirs.mDirections[i];
            int there = here + (dirs.mDirections[i + 1] & 0x3FFFFFF);
            int n = swap = (dirs.mDirections[i + 1] & 0x4000000) != 0 ? -1 : 1;
            if (there > max) {
                there = max;
            }
            int high = there - 1 + 1;
            int low = here + 1 - 1;
            while (high - low > 1) {
                int guess = (high + low) / 2;
                int adguess = this.getOffsetAtStartOf(guess);
                if (this.getPrimaryHorizontal(adguess) * (float)swap >= horiz * (float)swap) {
                    high = guess;
                    continue;
                }
                low = guess;
            }
            if (low < here + 1) {
                low = here + 1;
            }
            if (low < there) {
                float other;
                low = this.getOffsetAtStartOf(low);
                float dist2 = Math.abs(this.getPrimaryHorizontal(low) - horiz);
                int aft = TextUtils.getOffsetAfter(this.mText, low);
                if (aft < there && (other = Math.abs(this.getPrimaryHorizontal(aft) - horiz)) < dist2) {
                    dist2 = other;
                    low = aft;
                }
                if (dist2 < bestdist) {
                    bestdist = dist2;
                    best = low;
                }
            }
            if (!((dist = Math.abs(this.getPrimaryHorizontal(here) - horiz)) < bestdist)) continue;
            bestdist = dist;
            best = here;
        }
        float dist = Math.abs(this.getPrimaryHorizontal(max) - horiz);
        if (dist <= bestdist) {
            bestdist = dist;
            best = max;
        }
        return best;
    }

    public final int getLineEnd(int line) {
        return this.getLineStart(line + 1);
    }

    public int getLineVisibleEnd(int line) {
        return this.getLineVisibleEnd(line, this.getLineStart(line), this.getLineStart(line + 1));
    }

    private int getLineVisibleEnd(int line, int start, int end) {
        CharSequence text = this.mText;
        if (line == this.getLineCount() - 1) {
            return end;
        }
        while (end > start) {
            char ch = text.charAt(end - 1);
            if (ch == '\n') {
                return end - 1;
            }
            if (ch != ' ' && ch != '\t' && ch != '\u1680' && ('\u2000' > ch || ch > '\u200a' || ch == '\u2007') && ch != '\u205f' && ch != '\u3000') break;
            --end;
        }
        return end;
    }

    public final int getLineBottom(int line) {
        return this.getLineTop(line + 1);
    }

    public final int getLineBaseline(int line) {
        return this.getLineTop(line + 1) - this.getLineDescent(line);
    }

    public final int getLineAscent(int line) {
        return this.getLineTop(line) - (this.getLineTop(line + 1) - this.getLineDescent(line));
    }

    public int getOffsetToLeftOf(int offset) {
        return this.getOffsetToLeftRightOf(offset, true);
    }

    public int getOffsetToRightOf(int offset) {
        return this.getOffsetToLeftRightOf(offset, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getOffsetToLeftRightOf(int caret, boolean toLeft) {
        boolean advance;
        int line = this.getLineForOffset(caret);
        int lineStart = this.getLineStart(line);
        int lineEnd = this.getLineEnd(line);
        int lineDir = this.getParagraphDirection(line);
        boolean lineChanged = false;
        boolean bl = advance = toLeft == (lineDir == -1);
        if (advance) {
            if (caret == lineEnd) {
                if (line >= this.getLineCount() - 1) return caret;
                lineChanged = true;
                ++line;
            }
        } else if (caret == lineStart) {
            if (line <= 0) return caret;
            lineChanged = true;
            --line;
        }
        if (lineChanged) {
            lineStart = this.getLineStart(line);
            lineEnd = this.getLineEnd(line);
            int newDir = this.getParagraphDirection(line);
            if (newDir != lineDir) {
                toLeft = !toLeft;
                lineDir = newDir;
            }
        }
        Directions directions = this.getLineDirections(line);
        TextLine tl = TextLine.obtain();
        tl.set(this.mPaint, this.mText, lineStart, lineEnd, lineDir, directions, false, null);
        caret = lineStart + tl.getOffsetToLeftRightOf(caret - lineStart, toLeft);
        tl = TextLine.recycle(tl);
        return caret;
    }

    private int getOffsetAtStartOf(int offset) {
        char c1;
        if (offset == 0) {
            return 0;
        }
        CharSequence text = this.mText;
        char c = text.charAt(offset);
        if (c >= '\udc00' && c <= '\udfff' && (c1 = text.charAt(offset - 1)) >= '\ud800' && c1 <= '\udbff') {
            --offset;
        }
        if (this.mSpannedText) {
            ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int start = ((Spanned)text).getSpanStart(spans[i]);
                int end = ((Spanned)text).getSpanEnd(spans[i]);
                if (start >= offset || end <= offset) continue;
                offset = start;
            }
        }
        return offset;
    }

    public boolean shouldClampCursor(int line) {
        switch (this.getParagraphAlignment(line)) {
            case ALIGN_LEFT: {
                return true;
            }
            case ALIGN_NORMAL: {
                return this.getParagraphDirection(line) > 0;
            }
        }
        return false;
    }

    public void getCursorPath(int point, Path dest, CharSequence editingBuffer) {
        dest.reset();
        int line = this.getLineForOffset(point);
        int top = this.getLineTop(line);
        int bottom = this.getLineTop(line + 1);
        boolean clamped = this.shouldClampCursor(line);
        float h1 = this.getPrimaryHorizontal(point, clamped) - 0.5f;
        float h2 = this.isLevelBoundary(point) ? this.getSecondaryHorizontal(point, clamped) - 0.5f : h1;
        int caps = TextKeyListener.getMetaState(editingBuffer, 1) | TextKeyListener.getMetaState(editingBuffer, 2048);
        int fn = TextKeyListener.getMetaState(editingBuffer, 2);
        int dist = 0;
        if (caps != 0 || fn != 0) {
            dist = bottom - top >> 2;
            if (fn != 0) {
                top += dist;
            }
            if (caps != 0) {
                bottom -= dist;
            }
        }
        if (h1 < 0.5f) {
            h1 = 0.5f;
        }
        if (h2 < 0.5f) {
            h2 = 0.5f;
        }
        if (Float.compare(h1, h2) == 0) {
            dest.moveTo(h1, top);
            dest.lineTo(h1, bottom);
        } else {
            dest.moveTo(h1, top);
            dest.lineTo(h1, top + bottom >> 1);
            dest.moveTo(h2, top + bottom >> 1);
            dest.lineTo(h2, bottom);
        }
        if (caps == 2) {
            dest.moveTo(h2, bottom);
            dest.lineTo(h2 - (float)dist, bottom + dist);
            dest.lineTo(h2, bottom);
            dest.lineTo(h2 + (float)dist, bottom + dist);
        } else if (caps == 1) {
            dest.moveTo(h2, bottom);
            dest.lineTo(h2 - (float)dist, bottom + dist);
            dest.moveTo(h2 - (float)dist, (float)(bottom + dist) - 0.5f);
            dest.lineTo(h2 + (float)dist, (float)(bottom + dist) - 0.5f);
            dest.moveTo(h2 + (float)dist, bottom + dist);
            dest.lineTo(h2, bottom);
        }
        if (fn == 2) {
            dest.moveTo(h1, top);
            dest.lineTo(h1 - (float)dist, top - dist);
            dest.lineTo(h1, top);
            dest.lineTo(h1 + (float)dist, top - dist);
        } else if (fn == 1) {
            dest.moveTo(h1, top);
            dest.lineTo(h1 - (float)dist, top - dist);
            dest.moveTo(h1 - (float)dist, (float)(top - dist) + 0.5f);
            dest.lineTo(h1 + (float)dist, (float)(top - dist) + 0.5f);
            dest.moveTo(h1 + (float)dist, top - dist);
            dest.lineTo(h1, top);
        }
    }

    private void addSelection(int line, int start, int end, int top, int bottom, Path dest) {
        int linestart = this.getLineStart(line);
        int lineend = this.getLineEnd(line);
        Directions dirs = this.getLineDirections(line);
        if (lineend > linestart && this.mText.charAt(lineend - 1) == '\n') {
            --lineend;
        }
        for (int i = 0; i < dirs.mDirections.length; i += 2) {
            int en;
            int st;
            int here = linestart + dirs.mDirections[i];
            int there = here + (dirs.mDirections[i + 1] & 0x3FFFFFF);
            if (there > lineend) {
                there = lineend;
            }
            if (start > there || end < here || (st = Math.max(start, here)) == (en = Math.min(end, there))) continue;
            float h1 = this.getHorizontal(st, false, line, false);
            float h2 = this.getHorizontal(en, true, line, false);
            float left = Math.min(h1, h2);
            float right = Math.max(h1, h2);
            dest.addRect(left, top, right, bottom, Path.Direction.CW);
        }
    }

    public void getSelectionPath(int start, int end, Path dest) {
        dest.reset();
        if (start == end) {
            return;
        }
        if (end < start) {
            int temp = end;
            end = start;
            start = temp;
        }
        int startline = this.getLineForOffset(start);
        int endline = this.getLineForOffset(end);
        int top = this.getLineTop(startline);
        int bottom = this.getLineBottom(endline);
        if (startline == endline) {
            this.addSelection(startline, start, end, top, bottom, dest);
        } else {
            float width = this.mWidth;
            this.addSelection(startline, start, this.getLineEnd(startline), top, this.getLineBottom(startline), dest);
            if (this.getParagraphDirection(startline) == -1) {
                dest.addRect(this.getLineLeft(startline), top, 0.0f, this.getLineBottom(startline), Path.Direction.CW);
            } else {
                dest.addRect(this.getLineRight(startline), top, width, this.getLineBottom(startline), Path.Direction.CW);
            }
            for (int i = startline + 1; i < endline; ++i) {
                top = this.getLineTop(i);
                bottom = this.getLineBottom(i);
                dest.addRect(0.0f, top, width, bottom, Path.Direction.CW);
            }
            top = this.getLineTop(endline);
            bottom = this.getLineBottom(endline);
            this.addSelection(endline, this.getLineStart(endline), end, top, bottom, dest);
            if (this.getParagraphDirection(endline) == -1) {
                dest.addRect(width, top, this.getLineRight(endline), bottom, Path.Direction.CW);
            } else {
                dest.addRect(0.0f, top, this.getLineLeft(endline), bottom, Path.Direction.CW);
            }
        }
    }

    public final Alignment getParagraphAlignment(int line) {
        Spanned sp;
        AlignmentSpan[] spans;
        int spanLength;
        Alignment align = this.mAlignment;
        if (this.mSpannedText && (spanLength = (spans = Layout.getParagraphSpans(sp = (Spanned)this.mText, this.getLineStart(line), this.getLineEnd(line), AlignmentSpan.class)).length) > 0) {
            align = spans[spanLength - 1].getAlignment();
        }
        return align;
    }

    public final int getParagraphLeft(int line) {
        int left = 0;
        int dir = this.getParagraphDirection(line);
        if (dir == -1 || !this.mSpannedText) {
            return left;
        }
        return this.getParagraphLeadingMargin(line);
    }

    public final int getParagraphRight(int line) {
        int right = this.mWidth;
        int dir = this.getParagraphDirection(line);
        if (dir == 1 || !this.mSpannedText) {
            return right;
        }
        return right - this.getParagraphLeadingMargin(line);
    }

    private int getParagraphLeadingMargin(int line) {
        int i;
        boolean isFirstParaLine;
        int lineEnd;
        int spanEnd;
        if (!this.mSpannedText) {
            return 0;
        }
        Spanned spanned = (Spanned)this.mText;
        int lineStart = this.getLineStart(line);
        LeadingMarginSpan[] spans = Layout.getParagraphSpans(spanned, lineStart, spanEnd = spanned.nextSpanTransition(lineStart, lineEnd = this.getLineEnd(line), LeadingMarginSpan.class), LeadingMarginSpan.class);
        if (spans.length == 0) {
            return 0;
        }
        int margin = 0;
        boolean useFirstLineMargin = isFirstParaLine = lineStart == 0 || spanned.charAt(lineStart - 1) == '\n';
        for (i = 0; i < spans.length; ++i) {
            int count;
            if (!(spans[i] instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
            int spStart = spanned.getSpanStart(spans[i]);
            int spanLine = this.getLineForOffset(spStart);
            useFirstLineMargin |= line < spanLine + (count = ((LeadingMarginSpan.LeadingMarginSpan2)spans[i]).getLeadingMarginLineCount());
        }
        for (i = 0; i < spans.length; ++i) {
            LeadingMarginSpan span = spans[i];
            margin += span.getLeadingMargin(useFirstLineMargin);
        }
        return margin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static float measurePara(TextPaint paint, CharSequence text, int start, int end) {
        MeasuredText mt = MeasuredText.obtain();
        TextLine tl = TextLine.obtain();
        try {
            int dir;
            Directions directions;
            mt.setPara(text, start, end, TextDirectionHeuristics.LTR, null);
            if (mt.mEasy) {
                directions = DIRS_ALL_LEFT_TO_RIGHT;
                dir = 1;
            } else {
                directions = AndroidBidi.directions(mt.mDir, mt.mLevels, 0, mt.mChars, 0, mt.mLen);
                dir = mt.mDir;
            }
            char[] chars = mt.mChars;
            int len = mt.mLen;
            boolean hasTabs = false;
            TabStops tabStops = null;
            int margin = 0;
            if (text instanceof Spanned) {
                LeadingMarginSpan[] spans;
                Spanned spanned = (Spanned)text;
                for (LeadingMarginSpan lms : spans = Layout.getParagraphSpans(spanned, start, end, LeadingMarginSpan.class)) {
                    margin += lms.getLeadingMargin(true);
                }
            }
            for (int i = 0; i < len; ++i) {
                int spanEnd;
                Spanned spanned;
                Object[] spans;
                if (chars[i] != '\t') continue;
                hasTabs = true;
                if (!(text instanceof Spanned) || (spans = Layout.getParagraphSpans(spanned = (Spanned)text, start, spanEnd = spanned.nextSpanTransition(start, end, TabStopSpan.class), TabStopSpan.class)).length <= 0) break;
                tabStops = new TabStops(20, spans);
                break;
            }
            tl.set(paint, text, start, end, dir, directions, hasTabs, tabStops);
            float f = (float)margin + tl.metrics(null);
            return f;
        }
        finally {
            TextLine.recycle(tl);
            MeasuredText.recycle(mt);
        }
    }

    static float nextTab(CharSequence text, int start, int end, float h, Object[] tabs) {
        float nh = Float.MAX_VALUE;
        boolean alltabs = false;
        if (text instanceof Spanned) {
            if (tabs == null) {
                tabs = Layout.getParagraphSpans((Spanned)text, start, end, TabStopSpan.class);
                alltabs = true;
            }
            for (int i = 0; i < tabs.length; ++i) {
                int where;
                if (!alltabs && !(tabs[i] instanceof TabStopSpan) || !((float)(where = ((TabStopSpan)tabs[i]).getTabStop()) < nh) || !((float)where > h)) continue;
                nh = where;
            }
            if (nh != Float.MAX_VALUE) {
                return nh;
            }
        }
        return (int)((h + 20.0f) / 20.0f) * 20;
    }

    protected final boolean isSpanned() {
        return this.mSpannedText;
    }

    static <T> T[] getParagraphSpans(Spanned text, int start, int end, Class<T> type) {
        if (start == end && start > 0) {
            return ArrayUtils.emptyArray(type);
        }
        return text.getSpans(start, end, type);
    }

    private char getEllipsisChar(TextUtils.TruncateAt method) {
        return method == TextUtils.TruncateAt.END_SMALL ? TextUtils.ELLIPSIS_TWO_DOTS[0] : TextUtils.ELLIPSIS_NORMAL[0];
    }

    private void ellipsize(int start, int end, int line, char[] dest, int destoff, TextUtils.TruncateAt method) {
        int ellipsisCount = this.getEllipsisCount(line);
        if (ellipsisCount == 0) {
            return;
        }
        int ellipsisStart = this.getEllipsisStart(line);
        int linestart = this.getLineStart(line);
        for (int i = ellipsisStart; i < ellipsisStart + ellipsisCount; ++i) {
            int c = i == ellipsisStart ? (int)this.getEllipsisChar(method) : 65279;
            int a = i + linestart;
            if (a < start || a >= end) continue;
            dest[destoff + a - start] = c;
        }
    }

    public abstract int getEllipsisStart(int var1);

    public abstract int getEllipsisCount(int var1);

    static {
        if (EMOJI_FACTORY != null) {
            MIN_EMOJI = EMOJI_FACTORY.getMinimumAndroidPua();
            MAX_EMOJI = EMOJI_FACTORY.getMaximumAndroidPua();
        } else {
            MIN_EMOJI = -1;
            MAX_EMOJI = -1;
        }
        sTempRect = new Rect();
        DIRS_ALL_LEFT_TO_RIGHT = new Directions(new int[]{0, 0x3FFFFFF});
        DIRS_ALL_RIGHT_TO_LEFT = new Directions(new int[]{0, 0x7FFFFFF});
    }

    public static enum Alignment {
        ALIGN_NORMAL,
        ALIGN_OPPOSITE,
        ALIGN_CENTER,
        ALIGN_LEFT,
        ALIGN_RIGHT;

    }

    static class SpannedEllipsizer
    extends Ellipsizer
    implements Spanned {
        private Spanned mSpanned;

        public SpannedEllipsizer(CharSequence display) {
            super(display);
            this.mSpanned = (Spanned)display;
        }

        @Override
        public <T> T[] getSpans(int start, int end, Class<T> type) {
            return this.mSpanned.getSpans(start, end, type);
        }

        @Override
        public int getSpanStart(Object tag) {
            return this.mSpanned.getSpanStart(tag);
        }

        @Override
        public int getSpanEnd(Object tag) {
            return this.mSpanned.getSpanEnd(tag);
        }

        @Override
        public int getSpanFlags(Object tag) {
            return this.mSpanned.getSpanFlags(tag);
        }

        @Override
        public int nextSpanTransition(int start, int limit, Class type) {
            return this.mSpanned.nextSpanTransition(start, limit, type);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            SpannableString ss = new SpannableString(new String(s));
            TextUtils.copySpansFrom(this.mSpanned, start, end, Object.class, ss, 0);
            return ss;
        }
    }

    static class Ellipsizer
    implements CharSequence,
    GetChars {
        CharSequence mText;
        Layout mLayout;
        int mWidth;
        TextUtils.TruncateAt mMethod;

        public Ellipsizer(CharSequence s) {
            this.mText = s;
        }

        @Override
        public char charAt(int off) {
            char[] buf = TextUtils.obtain(1);
            this.getChars(off, off + 1, buf, 0);
            char ret = buf[0];
            TextUtils.recycle(buf);
            return ret;
        }

        @Override
        public void getChars(int start, int end, char[] dest, int destoff) {
            int line1 = this.mLayout.getLineForOffset(start);
            int line2 = this.mLayout.getLineForOffset(end);
            TextUtils.getChars(this.mText, start, end, dest, destoff);
            for (int i = line1; i <= line2; ++i) {
                this.mLayout.ellipsize(start, end, i, dest, destoff, this.mMethod);
            }
        }

        @Override
        public int length() {
            return this.mText.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            char[] s = new char[end - start];
            this.getChars(start, end, s, 0);
            return new String(s);
        }

        @Override
        public String toString() {
            char[] s = new char[this.length()];
            this.getChars(0, this.length(), s, 0);
            return new String(s);
        }
    }

    public static class Directions {
        int[] mDirections;

        Directions(int[] dirs) {
            this.mDirections = dirs;
        }
    }

    static class TabStops {
        private int[] mStops;
        private int mNumStops;
        private int mIncrement;

        TabStops(int increment, Object[] spans) {
            this.reset(increment, spans);
        }

        void reset(int increment, Object[] spans) {
            this.mIncrement = increment;
            int ns = 0;
            if (spans != null) {
                int[] stops = this.mStops;
                for (Object o : spans) {
                    if (!(o instanceof TabStopSpan)) continue;
                    if (stops == null) {
                        stops = new int[10];
                    } else if (ns == stops.length) {
                        int[] nstops = new int[ns * 2];
                        for (int i = 0; i < ns; ++i) {
                            nstops[i] = stops[i];
                        }
                        stops = nstops;
                    }
                    stops[ns++] = ((TabStopSpan)o).getTabStop();
                }
                if (ns > 1) {
                    Arrays.sort(stops, 0, ns);
                }
                if (stops != this.mStops) {
                    this.mStops = stops;
                }
            }
            this.mNumStops = ns;
        }

        float nextTab(float h) {
            int ns = this.mNumStops;
            if (ns > 0) {
                int[] stops = this.mStops;
                for (int i = 0; i < ns; ++i) {
                    int stop = stops[i];
                    if (!((float)stop > h)) continue;
                    return stop;
                }
            }
            return TabStops.nextDefaultStop(h, this.mIncrement);
        }

        public static float nextDefaultStop(float h, int inc) {
            return (int)((h + (float)inc) / (float)inc) * inc;
        }
    }
}

