/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;

public abstract class Visibility
extends Transition {
    static final String PROPNAME_VISIBILITY = "android:visibility:visibility";
    private static final String PROPNAME_PARENT = "android:visibility:parent";
    private static final String PROPNAME_SCREEN_LOCATION = "android:visibility:screenLocation";
    public static final int MODE_IN = 1;
    public static final int MODE_OUT = 2;
    private static final String[] sTransitionProperties = new String[]{"android:visibility:visibility", "android:visibility:parent"};
    private int mMode = 3;
    private int mForcedStartVisibility = -1;
    private int mForcedEndVisibility = -1;

    public Visibility() {
    }

    public Visibility(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VisibilityTransition);
        int mode = a.getInt(0, 0);
        a.recycle();
        if (mode != 0) {
            this.setMode(mode);
        }
    }

    public void setMode(int mode) {
        if ((mode & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
        }
        this.mMode = mode;
    }

    public int getMode() {
        return this.mMode;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    private void captureValues(TransitionValues transitionValues, int forcedVisibility) {
        int visibility = forcedVisibility != -1 ? forcedVisibility : transitionValues.view.getVisibility();
        transitionValues.values.put(PROPNAME_VISIBILITY, visibility);
        transitionValues.values.put(PROPNAME_PARENT, transitionValues.view.getParent());
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put(PROPNAME_SCREEN_LOCATION, loc);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedStartVisibility);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues, this.mForcedEndVisibility);
    }

    @Override
    public void forceVisibility(int visibility, boolean isStartValue) {
        if (isStartValue) {
            this.mForcedStartVisibility = visibility;
        } else {
            this.mForcedEndVisibility = visibility;
        }
    }

    public boolean isVisible(TransitionValues values) {
        if (values == null) {
            return false;
        }
        int visibility = (Integer)values.values.get(PROPNAME_VISIBILITY);
        View parent = (View)values.values.get(PROPNAME_PARENT);
        return visibility == 0 && parent != null;
    }

    private static VisibilityInfo getVisibilityChangeInfo(TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = new VisibilityInfo();
        visInfo.visibilityChange = false;
        visInfo.fadeIn = false;
        if (startValues != null && startValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visInfo.startVisibility = (Integer)startValues.values.get(PROPNAME_VISIBILITY);
            visInfo.startParent = (ViewGroup)startValues.values.get(PROPNAME_PARENT);
        } else {
            visInfo.startVisibility = -1;
            visInfo.startParent = null;
        }
        if (endValues != null && endValues.values.containsKey(PROPNAME_VISIBILITY)) {
            visInfo.endVisibility = (Integer)endValues.values.get(PROPNAME_VISIBILITY);
            visInfo.endParent = (ViewGroup)endValues.values.get(PROPNAME_PARENT);
        } else {
            visInfo.endVisibility = -1;
            visInfo.endParent = null;
        }
        if (startValues != null && endValues != null) {
            if (visInfo.startVisibility == visInfo.endVisibility && visInfo.startParent == visInfo.endParent) {
                return visInfo;
            }
            if (visInfo.startVisibility != visInfo.endVisibility) {
                if (visInfo.startVisibility == 0) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.endVisibility == 0) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            } else if (visInfo.startParent != visInfo.endParent) {
                if (visInfo.endParent == null) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.startParent == null) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            }
        } else if (startValues == null && visInfo.endVisibility == 0) {
            visInfo.fadeIn = true;
            visInfo.visibilityChange = true;
        } else if (endValues == null && visInfo.startVisibility == 0) {
            visInfo.fadeIn = false;
            visInfo.visibilityChange = true;
        }
        return visInfo;
    }

    @Override
    public Animator createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = Visibility.getVisibilityChangeInfo(startValues, endValues);
        if (visInfo.visibilityChange && (visInfo.startParent != null || visInfo.endParent != null)) {
            if (visInfo.fadeIn) {
                return this.onAppear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
            }
            return this.onDisappear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
        }
        return null;
    }

    public Animator onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        boolean isForcedVisibility;
        if ((this.mMode & 1) != 1 || endValues == null) {
            return null;
        }
        if (startValues == null) {
            VisibilityInfo parentVisibilityInfo = null;
            View endParent = (View)((Object)endValues.view.getParent());
            TransitionValues startParentValues = this.getMatchedTransitionValues(endParent, false);
            TransitionValues endParentValues = this.getTransitionValues(endParent, false);
            parentVisibilityInfo = Visibility.getVisibilityChangeInfo(startParentValues, endParentValues);
            if (parentVisibilityInfo.visibilityChange) {
                return null;
            }
        }
        boolean bl = isForcedVisibility = this.mForcedStartVisibility != -1 || this.mForcedEndVisibility != -1;
        if (isForcedVisibility) {
            endValues.view.setTransitionAlpha(1.0f);
        }
        return this.onAppear(sceneRoot, endValues.view, startValues, endValues);
    }

    public Animator onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    public Animator onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 2) != 2) {
            return null;
        }
        View startView = startValues != null ? startValues.view : null;
        View endView = endValues != null ? endValues.view : null;
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                overlayView = endView;
            } else if (startView != null) {
                if (startView.getParent() == null) {
                    overlayView = startView;
                } else if (startView.getParent() instanceof View) {
                    int id2;
                    View startParent = (View)((Object)startView.getParent());
                    TransitionValues startParentValues = this.getTransitionValues(startParent, true);
                    TransitionValues endParentValues = this.getMatchedTransitionValues(startParent, true);
                    VisibilityInfo parentVisibilityInfo = Visibility.getVisibilityChangeInfo(startParentValues, endParentValues);
                    if (!parentVisibilityInfo.visibilityChange) {
                        overlayView = TransitionUtils.copyViewImage(sceneRoot, startView, startParent);
                    } else if (startParent.getParent() == null && (id2 = startParent.getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                        overlayView = startView;
                    }
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = endView;
        } else if (startView == endView) {
            viewToKeep = endView;
        } else {
            overlayView = startView;
        }
        int finalVisibility = endVisibility;
        final ViewGroup finalSceneRoot = sceneRoot;
        if (overlayView != null) {
            int[] screenLoc = (int[])startValues.values.get(PROPNAME_SCREEN_LOCATION);
            int screenX = screenLoc[0];
            int screenY = screenLoc[1];
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            overlayView.offsetLeftAndRight(screenX - loc[0] - overlayView.getLeft());
            overlayView.offsetTopAndBottom(screenY - loc[1] - overlayView.getTop());
            sceneRoot.getOverlay().add(overlayView);
            Animator animator2 = this.onDisappear(sceneRoot, overlayView, startValues, endValues);
            if (animator2 == null) {
                sceneRoot.getOverlay().remove(overlayView);
            } else {
                final View finalOverlayView = overlayView;
                this.addListener(new Transition.TransitionListenerAdapter(){

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        finalSceneRoot.getOverlay().remove(finalOverlayView);
                    }
                });
            }
            return animator2;
        }
        if (viewToKeep != null) {
            Animator animator3;
            boolean isForcedVisibility;
            int originalVisibility = -1;
            boolean bl = isForcedVisibility = this.mForcedStartVisibility != -1 || this.mForcedEndVisibility != -1;
            if (!isForcedVisibility) {
                originalVisibility = viewToKeep.getVisibility();
                viewToKeep.setTransitionVisibility(0);
            }
            if ((animator3 = this.onDisappear(sceneRoot, viewToKeep, startValues, endValues)) != null) {
                DisappearListener disappearListener = new DisappearListener(viewToKeep, finalVisibility, isForcedVisibility);
                animator3.addListener(disappearListener);
                animator3.addPauseListener(disappearListener);
                this.addListener(disappearListener);
            } else if (!isForcedVisibility) {
                viewToKeep.setTransitionVisibility(originalVisibility);
            }
            return animator3;
        }
        return null;
    }

    @Override
    public boolean isTransitionRequired(TransitionValues startValues, TransitionValues newValues) {
        if (startValues == null && newValues == null) {
            return false;
        }
        if (startValues != null && newValues != null && newValues.values.containsKey(PROPNAME_VISIBILITY) != startValues.values.containsKey(PROPNAME_VISIBILITY)) {
            return false;
        }
        VisibilityInfo changeInfo = Visibility.getVisibilityChangeInfo(startValues, newValues);
        return changeInfo.visibilityChange && (changeInfo.startVisibility == 0 || changeInfo.endVisibility == 0);
    }

    public Animator onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    private static class DisappearListener
    extends Transition.TransitionListenerAdapter
    implements Animator.AnimatorListener,
    Animator.AnimatorPauseListener {
        private final boolean mIsForcedVisibility;
        private final View mView;
        private final int mFinalVisibility;
        private final ViewGroup mParent;
        private boolean mLayoutSuppressed;
        private boolean mFinalVisibilitySet = false;
        boolean mCanceled = false;

        public DisappearListener(View view, int finalVisibility, boolean isForcedVisibility) {
            this.mView = view;
            this.mIsForcedVisibility = isForcedVisibility;
            this.mFinalVisibility = finalVisibility;
            this.mParent = (ViewGroup)view.getParent();
            this.suppressLayout(true);
        }

        @Override
        public void onAnimationPause(Animator animation) {
            if (!this.mCanceled && !this.mIsForcedVisibility) {
                this.mView.setTransitionVisibility(this.mFinalVisibility);
            }
        }

        @Override
        public void onAnimationResume(Animator animation) {
            if (!this.mCanceled && !this.mIsForcedVisibility) {
                this.mView.setTransitionVisibility(0);
            }
        }

        @Override
        public void onAnimationCancel(Animator animation) {
            this.mCanceled = true;
        }

        @Override
        public void onAnimationRepeat(Animator animation) {
        }

        @Override
        public void onAnimationStart(Animator animation) {
        }

        @Override
        public void onAnimationEnd(Animator animation) {
            this.hideViewWhenNotCanceled();
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            this.hideViewWhenNotCanceled();
        }

        @Override
        public void onTransitionPause(Transition transition2) {
            this.suppressLayout(false);
        }

        @Override
        public void onTransitionResume(Transition transition2) {
            this.suppressLayout(true);
        }

        private void hideViewWhenNotCanceled() {
            if (!this.mCanceled) {
                if (this.mIsForcedVisibility) {
                    this.mView.setTransitionAlpha(0.0f);
                } else if (!this.mFinalVisibilitySet) {
                    this.mView.setTransitionVisibility(this.mFinalVisibility);
                    if (this.mParent != null) {
                        this.mParent.invalidate();
                    }
                    this.mFinalVisibilitySet = true;
                }
            }
            this.suppressLayout(false);
        }

        private void suppressLayout(boolean suppress) {
            if (this.mLayoutSuppressed != suppress && this.mParent != null && !this.mIsForcedVisibility) {
                this.mLayoutSuppressed = suppress;
                this.mParent.suppressLayout(suppress);
            }
        }
    }

    private static class VisibilityInfo {
        boolean visibilityChange;
        boolean fadeIn;
        int startVisibility;
        int endVisibility;
        ViewGroup startParent;
        ViewGroup endParent;

        private VisibilityInfo() {
        }
    }
}

