/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.text.TextUtils;
import android.util.ArrayMap;

public class KeyValueListParser {
    private final ArrayMap<String, String> mValues = new ArrayMap();
    private final TextUtils.StringSplitter mSplitter;

    public KeyValueListParser(char delim) {
        this.mSplitter = new TextUtils.SimpleStringSplitter(delim);
    }

    public void setString(String str) throws IllegalArgumentException {
        this.mValues.clear();
        if (str != null) {
            this.mSplitter.setString(str);
            for (String pair : this.mSplitter) {
                int sep = pair.indexOf(61);
                if (sep < 0) {
                    this.mValues.clear();
                    throw new IllegalArgumentException("'" + pair + "' in '" + str + "' is not a valid key-value pair");
                }
                this.mValues.put(pair.substring(0, sep).trim(), pair.substring(sep + 1).trim());
            }
        }
    }

    public long getLong(String key, long def) {
        String value = this.mValues.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return def;
    }

    public float getFloat(String key, float def) {
        String value = this.mValues.get(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String key, String def) {
        String value = this.mValues.get(key);
        if (value != null) {
            return value;
        }
        return def;
    }
}

