/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.os.RuntimeInit;
import com.android.internal.util.FastPrintWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;

public final class Log {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int ASSERT = 7;
    private static TerribleFailureHandler sWtfHandler = new TerribleFailureHandler(){

        @Override
        public void onTerribleFailure(String tag, TerribleFailure what, boolean system) {
            RuntimeInit.wtf(tag, what, system);
        }
    };
    public static final int LOG_ID_MAIN = 0;
    public static final int LOG_ID_RADIO = 1;
    public static final int LOG_ID_EVENTS = 2;
    public static final int LOG_ID_SYSTEM = 3;
    public static final int LOG_ID_CRASH = 4;

    private Log() {
    }

    public static int v(String tag, String msg) {
        return Log.println_native(0, 2, tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return Log.println_native(0, 2, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int d(String tag, String msg) {
        return Log.println_native(0, 3, tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return Log.println_native(0, 3, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int i(String tag, String msg) {
        return Log.println_native(0, 4, tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return Log.println_native(0, 4, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, String msg) {
        return Log.println_native(0, 5, tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return Log.println_native(0, 5, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static native boolean isLoggable(String var0, int var1);

    public static int w(String tag, Throwable tr) {
        return Log.println_native(0, 5, tag, Log.getStackTraceString(tr));
    }

    public static int e(String tag, String msg) {
        return Log.println_native(0, 6, tag, msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return Log.println_native(0, 6, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int wtf(String tag, String msg) {
        return Log.wtf(0, tag, msg, null, false, false);
    }

    public static int wtfStack(String tag, String msg) {
        return Log.wtf(0, tag, msg, null, true, false);
    }

    public static int wtf(String tag, Throwable tr) {
        return Log.wtf(0, tag, tr.getMessage(), tr, false, false);
    }

    public static int wtf(String tag, String msg, Throwable tr) {
        return Log.wtf(0, tag, msg, tr, false, false);
    }

    static int wtf(int logId, String tag, String msg, Throwable tr, boolean localStack, boolean system) {
        TerribleFailure what = new TerribleFailure(msg, tr);
        int bytes = Log.println_native(logId, 6, tag, msg + '\n' + Log.getStackTraceString(localStack ? what : tr));
        sWtfHandler.onTerribleFailure(tag, what, system);
        return bytes;
    }

    static void wtfQuiet(int logId, String tag, String msg, boolean system) {
        TerribleFailure what = new TerribleFailure(msg, null);
        sWtfHandler.onTerribleFailure(tag, what, system);
    }

    public static TerribleFailureHandler setWtfHandler(TerribleFailureHandler handler) {
        if (handler == null) {
            throw new NullPointerException("handler == null");
        }
        TerribleFailureHandler oldHandler = sWtfHandler;
        sWtfHandler = handler;
        return oldHandler;
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
        tr.printStackTrace(pw);
        ((PrintWriter)pw).flush();
        return sw.toString();
    }

    public static int println(int priority, String tag, String msg) {
        return Log.println_native(0, priority, tag, msg);
    }

    public static native int println_native(int var0, int var1, String var2, String var3);

    public static interface TerribleFailureHandler {
        public void onTerribleFailure(String var1, TerribleFailure var2, boolean var3);
    }

    private static class TerribleFailure
    extends Exception {
        TerribleFailure(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

