/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import com.android.internal.util.XmlUtils;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import libcore.util.ZoneInfoDB;

public class TimeUtils {
    private static final boolean DBG = false;
    private static final String TAG = "TimeUtils";
    private static final Object sLastLockObj = new Object();
    private static ArrayList<TimeZone> sLastZones = null;
    private static String sLastCountry = null;
    private static final Object sLastUniqueLockObj = new Object();
    private static ArrayList<TimeZone> sLastUniqueZoneOffsets = null;
    private static String sLastUniqueCountry = null;
    private static SimpleDateFormat sLoggingFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final int HUNDRED_DAY_FIELD_LEN = 19;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    public static final long NANOS_PER_MS = 1000000L;
    private static final Object sFormatSync = new Object();
    private static char[] sFormatStr = new char[29];
    private static char[] sTmpFormatStr = new char[29];

    public static TimeZone getTimeZone(int offset, boolean dst, long when, String country) {
        TimeZone best = null;
        Date d = new Date(when);
        TimeZone current = TimeZone.getDefault();
        String currentName = current.getID();
        int currentOffset = current.getOffset(when);
        boolean currentDst = current.inDaylightTime(d);
        for (TimeZone tz : TimeUtils.getTimeZones(country)) {
            if (tz.getID().equals(currentName) && currentOffset == offset && currentDst == dst) {
                return current;
            }
            if (best != null || tz.getOffset(when) != offset || tz.inDaylightTime(d) != dst) continue;
            best = tz;
        }
        return best;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TimeZone> getTimeZonesWithUniqueOffsets(String country) {
        Object object = sLastUniqueLockObj;
        synchronized (object) {
            if (country != null && country.equals(sLastUniqueCountry)) {
                return sLastUniqueZoneOffsets;
            }
        }
        ArrayList<TimeZone> zones = TimeUtils.getTimeZones(country);
        ArrayList<TimeZone> uniqueTimeZones = new ArrayList<TimeZone>();
        for (TimeZone zone : zones) {
            boolean found = false;
            for (int i = 0; i < uniqueTimeZones.size(); ++i) {
                if (((TimeZone)uniqueTimeZones.get(i)).getRawOffset() != zone.getRawOffset()) continue;
                found = true;
                break;
            }
            if (found) continue;
            uniqueTimeZones.add(zone);
        }
        Object object2 = sLastUniqueLockObj;
        synchronized (object2) {
            sLastUniqueZoneOffsets = uniqueTimeZones;
            sLastUniqueCountry = country;
            return sLastUniqueZoneOffsets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<TimeZone> getTimeZones(String country) {
        Object object = sLastLockObj;
        synchronized (object) {
            if (country != null && country.equals(sLastCountry)) {
                return sLastZones;
            }
        }
        ArrayList<TimeZone> tzs = new ArrayList<TimeZone>();
        if (country == null) {
            return tzs;
        }
        Resources r = Resources.getSystem();
        try (XmlResourceParser parser = r.getXml(0x1110014);){
            XmlUtils.beginDocument(parser, "timezones");
            while (true) {
                String zoneIdString;
                TimeZone tz;
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (!element.equals("timezone")) {
                    break;
                }
                String code = parser.getAttributeValue(null, "code");
                if (!country.equals(code) || parser.next() != 4 || (tz = TimeZone.getTimeZone(zoneIdString = parser.getText())).getID().startsWith("GMT")) continue;
                tzs.add(tz);
            }
        }
        Object object2 = sLastLockObj;
        synchronized (object2) {
            sLastZones = tzs;
            sLastCountry = country;
            return sLastZones;
        }
    }

    public static String getTimeZoneDatabaseVersion() {
        return ZoneInfoDB.getInstance().getVersion();
    }

    private static int accumField(int amt, int suffix, boolean always, int zeropad) {
        if (amt > 999) {
            int num = 0;
            while (amt != 0) {
                ++num;
                amt /= 10;
            }
            return num + suffix;
        }
        if (amt > 99 || always && zeropad >= 3) {
            return 3 + suffix;
        }
        if (amt > 9 || always && zeropad >= 2) {
            return 2 + suffix;
        }
        if (always || amt > 0) {
            return 1 + suffix;
        }
        return 0;
    }

    private static int printFieldLocked(char[] formatStr, int amt, char suffix, int pos, boolean always, int zeropad) {
        if (always || amt > 0) {
            int startPos = pos;
            if (amt > 999) {
                int tmp;
                for (tmp = 0; amt != 0 && tmp < sTmpFormatStr.length; ++tmp, amt /= 10) {
                    int dig = amt % 10;
                    TimeUtils.sTmpFormatStr[tmp] = (char)(dig + 48);
                }
                --tmp;
                while (tmp >= 0) {
                    formatStr[pos] = sTmpFormatStr[tmp];
                    ++pos;
                    --tmp;
                }
            } else {
                int dig;
                if (always && zeropad >= 3 || amt > 99) {
                    dig = amt / 100;
                    formatStr[pos] = (char)(dig + 48);
                    ++pos;
                    amt -= dig * 100;
                }
                if (always && zeropad >= 2 || amt > 9 || startPos != pos) {
                    dig = amt / 10;
                    formatStr[pos] = (char)(dig + 48);
                    ++pos;
                    amt -= dig * 10;
                }
                formatStr[pos] = (char)(amt + 48);
                ++pos;
            }
            formatStr[pos] = suffix;
            ++pos;
        }
        return pos;
    }

    private static int formatDurationLocked(long duration, int fieldLen) {
        int prefix;
        if (sFormatStr.length < fieldLen) {
            sFormatStr = new char[fieldLen];
        }
        char[] formatStr = sFormatStr;
        if (duration == 0L) {
            int pos = 0;
            --fieldLen;
            while (pos < fieldLen) {
                formatStr[pos++] = 32;
            }
            formatStr[pos] = 48;
            return pos + 1;
        }
        if (duration > 0L) {
            prefix = 43;
        } else {
            prefix = 45;
            duration = -duration;
        }
        int millis = (int)(duration % 1000L);
        int seconds = (int)Math.floor(duration / 1000L);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (seconds > 86400) {
            days = seconds / 86400;
            seconds -= days * 86400;
        }
        if (seconds > 3600) {
            hours = seconds / 3600;
            seconds -= hours * 3600;
        }
        if (seconds > 60) {
            minutes = seconds / 60;
            seconds -= minutes * 60;
        }
        int pos = 0;
        if (fieldLen != 0) {
            int myLen;
            myLen += TimeUtils.accumField(millis, 2, true, (myLen += TimeUtils.accumField(seconds, 1, (myLen += TimeUtils.accumField(minutes, 1, (myLen += TimeUtils.accumField(hours, 1, (myLen = TimeUtils.accumField(days, 1, false, 0)) > 0, 2)) > 0, 2)) > 0, 2)) > 0 ? 3 : 0) + 1;
            while (myLen < fieldLen) {
                formatStr[pos] = 32;
                ++pos;
                ++myLen;
            }
        }
        formatStr[pos] = prefix;
        int start = ++pos;
        boolean zeropad = fieldLen != 0;
        pos = TimeUtils.printFieldLocked(formatStr, days, 'd', pos, false, 0);
        pos = TimeUtils.printFieldLocked(formatStr, hours, 'h', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, minutes, 'm', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, seconds, 's', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printFieldLocked(formatStr, millis, 'm', pos, true, zeropad && pos != start ? 3 : 0);
        formatStr[pos] = 115;
        return pos + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatDuration(long duration, StringBuilder builder) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, 0);
            builder.append(sFormatStr, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void formatDuration(long duration, PrintWriter pw, int fieldLen) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, fieldLen);
            pw.print(new String(sFormatStr, 0, len));
        }
    }

    public static void formatDuration(long duration, PrintWriter pw) {
        TimeUtils.formatDuration(duration, pw, 0);
    }

    public static void formatDuration(long time, long now, PrintWriter pw) {
        if (time == 0L) {
            pw.print("--");
            return;
        }
        TimeUtils.formatDuration(time - now, pw, 0);
    }

    public static String formatUptime(long time) {
        long diff = time - SystemClock.uptimeMillis();
        if (diff > 0L) {
            return time + " (in " + diff + " ms)";
        }
        if (diff < 0L) {
            return time + " (" + -diff + " ms ago)";
        }
        return time + " (now)";
    }

    public static String logTimeOfDay(long millis) {
        Calendar c = Calendar.getInstance();
        if (millis >= 0L) {
            c.setTimeInMillis(millis);
            return String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c);
        }
        return Long.toString(millis);
    }

    public static String formatForLogging(long millis) {
        if (millis <= 0L) {
            return "unknown";
        }
        return sLoggingFormat.format(new Date(millis));
    }
}

