/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import java.util.Arrays;

public final class Display {
    private static final String TAG = "Display";
    private static final boolean DEBUG = false;
    private final DisplayManagerGlobal mGlobal;
    private final int mDisplayId;
    private final int mLayerStack;
    private final int mFlags;
    private final int mType;
    private final String mAddress;
    private final int mOwnerUid;
    private final String mOwnerPackageName;
    private final DisplayAdjustments mDisplayAdjustments;
    private DisplayInfo mDisplayInfo;
    private boolean mIsValid;
    private final DisplayMetrics mTempMetrics = new DisplayMetrics();
    private static final int CACHED_APP_SIZE_DURATION_MILLIS = 20;
    private long mLastCachedAppSizeUpdate;
    private int mCachedAppWidthCompat;
    private int mCachedAppHeightCompat;
    public static final int DEFAULT_DISPLAY = 0;
    public static final int INVALID_DISPLAY = -1;
    public static final int FLAG_SUPPORTS_PROTECTED_BUFFERS = 1;
    public static final int FLAG_SECURE = 2;
    public static final int FLAG_PRIVATE = 4;
    public static final int FLAG_PRESENTATION = 8;
    public static final int FLAG_ROUND = 16;
    public static final int FLAG_SCALING_DISABLED = 0x40000000;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_BUILT_IN = 1;
    public static final int TYPE_HDMI = 2;
    public static final int TYPE_WIFI = 3;
    public static final int TYPE_OVERLAY = 4;
    public static final int TYPE_VIRTUAL = 5;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_OFF = 1;
    public static final int STATE_ON = 2;
    public static final int STATE_DOZE = 3;
    public static final int STATE_DOZE_SUSPEND = 4;

    public Display(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj) {
        this.mGlobal = global;
        this.mDisplayId = displayId;
        this.mDisplayInfo = displayInfo;
        this.mDisplayAdjustments = new DisplayAdjustments(daj);
        this.mIsValid = true;
        this.mLayerStack = displayInfo.layerStack;
        this.mFlags = displayInfo.flags;
        this.mType = displayInfo.type;
        this.mAddress = displayInfo.address;
        this.mOwnerUid = displayInfo.ownerUid;
        this.mOwnerPackageName = displayInfo.ownerPackageName;
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisplayInfo(DisplayInfo outDisplayInfo) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outDisplayInfo.copyFrom(this.mDisplayInfo);
            return this.mIsValid;
        }
    }

    public int getLayerStack() {
        return this.mLayerStack;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int getType() {
        return this.mType;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public int getOwnerUid() {
        return this.mOwnerUid;
    }

    public String getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return this.mDisplayAdjustments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSize(Point outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            outSize.x = this.mTempMetrics.widthPixels;
            outSize.y = this.mTempMetrics.heightPixels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRectSize(Rect outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            outSize.set(0, 0, this.mTempMetrics.widthPixels, this.mTempMetrics.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outSmallestSize.x = this.mDisplayInfo.smallestNominalAppWidth;
            outSmallestSize.y = this.mDisplayInfo.smallestNominalAppHeight;
            outLargestSize.x = this.mDisplayInfo.largestNominalAppWidth;
            outLargestSize.y = this.mDisplayInfo.largestNominalAppHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumSizeDimension() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return Math.max(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getWidth() {
        Display display = this;
        synchronized (display) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppWidthCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getHeight() {
        Display display = this;
        synchronized (display) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppHeightCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOverscanInsets(Rect outRect) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outRect.set(this.mDisplayInfo.overscanLeft, this.mDisplayInfo.overscanTop, this.mDisplayInfo.overscanRight, this.mDisplayInfo.overscanBottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRotation() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.rotation;
        }
    }

    @Deprecated
    public int getOrientation() {
        return this.getRotation();
    }

    @Deprecated
    public int getPixelFormat() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getRefreshRate() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode().getRefreshRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public float[] getSupportedRefreshRates() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getDefaultRefreshRates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode getMode() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode[] getSupportedModes() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            Mode[] modes = this.mDisplayInfo.supportedModes;
            return Arrays.copyOf(modes, modes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAppVsyncOffsetNanos() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.appVsyncOffsetNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPresentationDeadlineNanos() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.presentationDeadlineNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getMetrics(DisplayMetrics outMetrics) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(outMetrics, this.mDisplayAdjustments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRealSize(Point outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outSize.x = this.mDisplayInfo.logicalWidth;
            outSize.y = this.mDisplayInfo.logicalHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRealMetrics(DisplayMetrics outMetrics) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getLogicalMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, this.mDisplayAdjustments.getConfiguration());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mIsValid ? this.mDisplayInfo.state : 0;
        }
    }

    public boolean hasAccess(int uid) {
        return Display.hasAccess(uid, this.mFlags, this.mOwnerUid);
    }

    public static boolean hasAccess(int uid, int flags, int ownerUid) {
        return (flags & 4) == 0 || uid == ownerUid || uid == 1000 || uid == 0;
    }

    public boolean isPublicPresentation() {
        return (this.mFlags & 0xC) == 8;
    }

    private void updateDisplayInfoLocked() {
        DisplayInfo newInfo = this.mGlobal.getDisplayInfo(this.mDisplayId);
        if (newInfo == null) {
            if (this.mIsValid) {
                this.mIsValid = false;
            }
        } else {
            this.mDisplayInfo = newInfo;
            if (!this.mIsValid) {
                this.mIsValid = true;
            }
        }
    }

    private void updateCachedAppSizeIfNeededLocked() {
        long now = SystemClock.uptimeMillis();
        if (now > this.mLastCachedAppSizeUpdate + 20L) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            this.mCachedAppWidthCompat = this.mTempMetrics.widthPixels;
            this.mCachedAppHeightCompat = this.mTempMetrics.heightPixels;
            this.mLastCachedAppSizeUpdate = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.mDisplayAdjustments);
            return "Display id " + this.mDisplayId + ": " + this.mDisplayInfo + ", " + this.mTempMetrics + ", isValid=" + this.mIsValid;
        }
    }

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "BUILT_IN";
            }
            case 2: {
                return "HDMI";
            }
            case 3: {
                return "WIFI";
            }
            case 4: {
                return "OVERLAY";
            }
            case 5: {
                return "VIRTUAL";
            }
        }
        return Integer.toString(type);
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "ON";
            }
            case 3: {
                return "DOZE";
            }
            case 4: {
                return "DOZE_SUSPEND";
            }
        }
        return Integer.toString(state);
    }

    public static boolean isSuspendedState(int state) {
        return state == 1 || state == 4;
    }

    public static final class Mode
    implements Parcelable {
        public static final Mode[] EMPTY_ARRAY = new Mode[0];
        private final int mModeId;
        private final int mWidth;
        private final int mHeight;
        private final float mRefreshRate;
        public static final Parcelable.Creator<Mode> CREATOR = new Parcelable.Creator<Mode>(){

            @Override
            public Mode createFromParcel(Parcel in) {
                return new Mode(in);
            }

            public Mode[] newArray(int size) {
                return new Mode[size];
            }
        };

        public Mode(int modeId, int width, int height, float refreshRate) {
            this.mModeId = modeId;
            this.mWidth = width;
            this.mHeight = height;
            this.mRefreshRate = refreshRate;
        }

        public int getModeId() {
            return this.mModeId;
        }

        public int getPhysicalWidth() {
            return this.mWidth;
        }

        public int getPhysicalHeight() {
            return this.mHeight;
        }

        public float getRefreshRate() {
            return this.mRefreshRate;
        }

        public boolean matches(int width, int height, float refreshRate) {
            return this.mWidth == width && this.mHeight == height && Float.floatToIntBits(this.mRefreshRate) == Float.floatToIntBits(refreshRate);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mode)) {
                return false;
            }
            Mode that = (Mode)other;
            return this.mModeId == that.mModeId && this.matches(that.mWidth, that.mHeight, that.mRefreshRate);
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + this.mModeId;
            hash = hash * 17 + this.mWidth;
            hash = hash * 17 + this.mHeight;
            hash = hash * 17 + Float.floatToIntBits(this.mRefreshRate);
            return hash;
        }

        public String toString() {
            return "{" + "id=" + this.mModeId + ", width=" + this.mWidth + ", height=" + this.mHeight + ", fps=" + this.mRefreshRate + "}";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        private Mode(Parcel in) {
            this(in.readInt(), in.readInt(), in.readInt(), in.readFloat());
        }

        @Override
        public void writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.mModeId);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            out.writeFloat(this.mRefreshRate);
        }
    }
}

