/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Pools;
import android.view.HardwareLayer;
import android.view.RenderNode;

public class DisplayListCanvas
extends Canvas {
    private static final int POOL_LIMIT = 25;
    private static final Pools.SynchronizedPool<DisplayListCanvas> sPool = new Pools.SynchronizedPool(25);
    RenderNode mNode;
    private int mWidth;
    private int mHeight;
    private static boolean sIsAvailable = DisplayListCanvas.nIsAvailable();

    static DisplayListCanvas obtain(RenderNode node) {
        if (node == null) {
            throw new IllegalArgumentException("node cannot be null");
        }
        DisplayListCanvas canvas = sPool.acquire();
        if (canvas == null) {
            canvas = new DisplayListCanvas();
        }
        canvas.mNode = node;
        return canvas;
    }

    void recycle() {
        this.mNode = null;
        sPool.release(this);
    }

    long finishRecording() {
        return DisplayListCanvas.nFinishRecording(this.mNativeCanvasWrapper);
    }

    @Override
    public boolean isRecordingFor(Object o) {
        return o == this.mNode;
    }

    private static native boolean nIsAvailable();

    static boolean isAvailable() {
        return sIsAvailable;
    }

    private DisplayListCanvas() {
        super(DisplayListCanvas.nCreateDisplayListCanvas());
        this.mDensity = 0;
    }

    private static native long nCreateDisplayListCanvas();

    @Override
    public void setDensity(int density) {
    }

    @Override
    public boolean isHardwareAccelerated() {
        return true;
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }

    @Override
    public int getMaximumBitmapWidth() {
        return DisplayListCanvas.nGetMaximumTextureWidth();
    }

    @Override
    public int getMaximumBitmapHeight() {
        return DisplayListCanvas.nGetMaximumTextureHeight();
    }

    private static native int nGetMaximumTextureWidth();

    private static native int nGetMaximumTextureHeight();

    long getRenderer() {
        return this.mNativeCanvasWrapper;
    }

    @Override
    public void setViewport(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        DisplayListCanvas.nSetViewport(this.mNativeCanvasWrapper, width, height);
    }

    private static native void nSetViewport(long var0, int var2, int var3);

    @Override
    public void setHighContrastText(boolean highContrastText) {
        DisplayListCanvas.nSetHighContrastText(this.mNativeCanvasWrapper, highContrastText);
    }

    private static native void nSetHighContrastText(long var0, boolean var2);

    @Override
    public void insertReorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, true);
    }

    @Override
    public void insertInorderBarrier() {
        DisplayListCanvas.nInsertReorderBarrier(this.mNativeCanvasWrapper, false);
    }

    private static native void nInsertReorderBarrier(long var0, boolean var2);

    public void onPreDraw(Rect dirty) {
        if (dirty != null) {
            DisplayListCanvas.nPrepareDirty(this.mNativeCanvasWrapper, dirty.left, dirty.top, dirty.right, dirty.bottom);
        } else {
            DisplayListCanvas.nPrepare(this.mNativeCanvasWrapper);
        }
    }

    private static native void nPrepare(long var0);

    private static native void nPrepareDirty(long var0, int var2, int var3, int var4, int var5);

    public void onPostDraw() {
        DisplayListCanvas.nFinish(this.mNativeCanvasWrapper);
    }

    private static native void nFinish(long var0);

    public void callDrawGLFunction2(long drawGLFunction) {
        DisplayListCanvas.nCallDrawGLFunction(this.mNativeCanvasWrapper, drawGLFunction);
    }

    private static native void nCallDrawGLFunction(long var0, long var2);

    protected static native long nFinishRecording(long var0);

    public void drawRenderNode(RenderNode renderNode) {
        DisplayListCanvas.nDrawRenderNode(this.mNativeCanvasWrapper, renderNode.getNativeDisplayList());
    }

    private static native void nDrawRenderNode(long var0, long var2);

    void drawHardwareLayer(HardwareLayer layer, float x, float y, Paint paint) {
        layer.setLayerPaint(paint);
        DisplayListCanvas.nDrawLayer(this.mNativeCanvasWrapper, layer.getLayerHandle(), x, y);
    }

    private static native void nDrawLayer(long var0, long var2, float var4, float var5);

    @Override
    public void drawPatch(NinePatch patch, Rect dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        DisplayListCanvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        DisplayListCanvas.nDrawPatch(this.mNativeCanvasWrapper, bitmap, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    @Override
    public void drawPatch(NinePatch patch, RectF dst, Paint paint) {
        Bitmap bitmap = patch.getBitmap();
        DisplayListCanvas.throwIfCannotDraw(bitmap);
        long nativePaint = paint == null ? 0L : paint.getNativeInstance();
        DisplayListCanvas.nDrawPatch(this.mNativeCanvasWrapper, bitmap, patch.mNativeChunk, dst.left, dst.top, dst.right, dst.bottom, nativePaint);
    }

    private static native void nDrawPatch(long var0, Bitmap var2, long var3, float var5, float var6, float var7, float var8, long var9);

    public void drawCircle(CanvasProperty<Float> cx, CanvasProperty<Float> cy, CanvasProperty<Float> radius, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawCircle(this.mNativeCanvasWrapper, cx.getNativeContainer(), cy.getNativeContainer(), radius.getNativeContainer(), paint.getNativeContainer());
    }

    private static native void nDrawCircle(long var0, long var2, long var4, long var6, long var8);

    public void drawRoundRect(CanvasProperty<Float> left, CanvasProperty<Float> top, CanvasProperty<Float> right, CanvasProperty<Float> bottom, CanvasProperty<Float> rx, CanvasProperty<Float> ry, CanvasProperty<Paint> paint) {
        DisplayListCanvas.nDrawRoundRect(this.mNativeCanvasWrapper, left.getNativeContainer(), top.getNativeContainer(), right.getNativeContainer(), bottom.getNativeContainer(), rx.getNativeContainer(), ry.getNativeContainer(), paint.getNativeContainer());
    }

    private static native void nDrawRoundRect(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    @Override
    public void drawPath(Path path, Paint paint) {
        if (path.isSimplePath) {
            if (path.rects != null) {
                DisplayListCanvas.nDrawRects(this.mNativeCanvasWrapper, path.rects.mNativeRegion, paint.getNativeInstance());
            }
        } else {
            super.drawPath(path, paint);
        }
    }

    private static native void nDrawRects(long var0, long var2, long var4);
}

