/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.Pools;
import android.view.MotionEvent;

public final class VelocityTracker {
    private static final Pools.SynchronizedPool<VelocityTracker> sPool = new Pools.SynchronizedPool(2);
    private static final int ACTIVE_POINTER_ID = -1;
    private long mPtr;
    private final String mStrategy;

    private static native long nativeInitialize(String var0);

    private static native void nativeDispose(long var0);

    private static native void nativeClear(long var0);

    private static native void nativeAddMovement(long var0, MotionEvent var2);

    private static native void nativeComputeCurrentVelocity(long var0, int var2, float var3);

    private static native float nativeGetXVelocity(long var0, int var2);

    private static native float nativeGetYVelocity(long var0, int var2);

    private static native boolean nativeGetEstimator(long var0, int var2, Estimator var3);

    public static VelocityTracker obtain() {
        VelocityTracker instance = sPool.acquire();
        return instance != null ? instance : new VelocityTracker(null);
    }

    public static VelocityTracker obtain(String strategy) {
        if (strategy == null) {
            return VelocityTracker.obtain();
        }
        return new VelocityTracker(strategy);
    }

    public void recycle() {
        if (this.mStrategy == null) {
            this.clear();
            sPool.release(this);
        }
    }

    private VelocityTracker(String strategy) {
        this.mPtr = VelocityTracker.nativeInitialize(strategy);
        this.mStrategy = strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.mPtr != 0L) {
                VelocityTracker.nativeDispose(this.mPtr);
                this.mPtr = 0L;
            }
        }
        finally {
            super.finalize();
        }
    }

    public void clear() {
        VelocityTracker.nativeClear(this.mPtr);
    }

    public void addMovement(MotionEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        VelocityTracker.nativeAddMovement(this.mPtr, event);
    }

    public void computeCurrentVelocity(int units) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        VelocityTracker.nativeComputeCurrentVelocity(this.mPtr, units, maxVelocity);
    }

    public float getXVelocity() {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, -1);
    }

    public float getYVelocity() {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, -1);
    }

    public float getXVelocity(int id2) {
        return VelocityTracker.nativeGetXVelocity(this.mPtr, id2);
    }

    public float getYVelocity(int id2) {
        return VelocityTracker.nativeGetYVelocity(this.mPtr, id2);
    }

    public boolean getEstimator(int id2, Estimator outEstimator) {
        if (outEstimator == null) {
            throw new IllegalArgumentException("outEstimator must not be null");
        }
        return VelocityTracker.nativeGetEstimator(this.mPtr, id2, outEstimator);
    }

    public static final class Estimator {
        private static final int MAX_DEGREE = 4;
        public final float[] xCoeff = new float[5];
        public final float[] yCoeff = new float[5];
        public int degree;
        public float confidence;

        public float estimateX(float time) {
            return this.estimate(time, this.xCoeff);
        }

        public float estimateY(float time) {
            return this.estimate(time, this.yCoeff);
        }

        public float getXCoeff(int index) {
            return index <= this.degree ? this.xCoeff[index] : 0.0f;
        }

        public float getYCoeff(int index) {
            return index <= this.degree ? this.yCoeff[index] : 0.0f;
        }

        private float estimate(float time, float[] c) {
            float a = 0.0f;
            float scale = 1.0f;
            for (int i = 0; i <= this.degree; ++i) {
                a += c[i] * scale;
                scale *= time;
            }
            return a;
        }
    }
}

