/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Transformation;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.Scroller;
import com.android.internal.R;

@Deprecated
public class Gallery
extends AbsSpinner
implements GestureDetector.OnGestureListener {
    private static final String TAG = "Gallery";
    private static final boolean localLOGV = false;
    private static final int SCROLL_TO_FLING_UNCERTAINTY_TIMEOUT = 250;
    private int mSpacing = 0;
    private int mAnimationDuration = 400;
    private float mUnselectedAlpha;
    private int mLeftMost;
    private int mRightMost;
    private int mGravity;
    private GestureDetector mGestureDetector;
    private int mDownTouchPosition;
    private View mDownTouchView;
    private FlingRunnable mFlingRunnable = new FlingRunnable();
    private Runnable mDisableSuppressSelectionChangedRunnable = new Runnable(){

        @Override
        public void run() {
            Gallery.this.mSuppressSelectionChanged = false;
            Gallery.this.selectionChanged();
        }
    };
    private boolean mShouldStopFling;
    private View mSelectedChild;
    private boolean mShouldCallbackDuringFling = true;
    private boolean mShouldCallbackOnUnselectedItemClick = true;
    private boolean mSuppressSelectionChanged;
    private boolean mReceivedInvokeKeyDown;
    private AdapterView.AdapterContextMenuInfo mContextMenuInfo;
    private boolean mIsFirstScroll;
    private boolean mIsRtl = true;
    private int mSelectedCenterOffset;

    public Gallery(Context context) {
        this(context, null);
    }

    public Gallery(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010070);
    }

    public Gallery(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public Gallery(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        int animationDuration;
        this.mGestureDetector = new GestureDetector(context, this);
        this.mGestureDetector.setIsLongpressEnabled(true);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Gallery, defStyleAttr, defStyleRes);
        int index = a.getInt(0, -1);
        if (index >= 0) {
            this.setGravity(index);
        }
        if ((animationDuration = a.getInt(1, -1)) > 0) {
            this.setAnimationDuration(animationDuration);
        }
        int spacing = a.getDimensionPixelOffset(2, 0);
        this.setSpacing(spacing);
        float unselectedAlpha = a.getFloat(3, 0.5f);
        this.setUnselectedAlpha(unselectedAlpha);
        a.recycle();
        this.mGroupFlags |= 0x400;
        this.mGroupFlags |= 0x800;
    }

    public void setCallbackDuringFling(boolean shouldCallback) {
        this.mShouldCallbackDuringFling = shouldCallback;
    }

    public void setCallbackOnUnselectedItemClick(boolean shouldCallback) {
        this.mShouldCallbackOnUnselectedItemClick = shouldCallback;
    }

    public void setAnimationDuration(int animationDurationMillis) {
        this.mAnimationDuration = animationDurationMillis;
    }

    public void setSpacing(int spacing) {
        this.mSpacing = spacing;
    }

    public void setUnselectedAlpha(float unselectedAlpha) {
        this.mUnselectedAlpha = unselectedAlpha;
    }

    @Override
    protected boolean getChildStaticTransformation(View child, Transformation t) {
        t.clear();
        t.setAlpha(child == this.mSelectedChild ? 1.0f : this.mUnselectedAlpha);
        return true;
    }

    @Override
    protected int computeHorizontalScrollExtent() {
        return 1;
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return this.mSelectedPosition;
    }

    @Override
    protected int computeHorizontalScrollRange() {
        return this.mItemCount;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    @Override
    int getChildHeight(View child) {
        return child.getMeasuredHeight();
    }

    void trackMotionScroll(int deltaX) {
        if (this.getChildCount() == 0) {
            return;
        }
        boolean toLeft = deltaX < 0;
        int limitedDeltaX = this.getLimitedMotionScrollAmount(toLeft, deltaX);
        if (limitedDeltaX != deltaX) {
            this.mFlingRunnable.endFling(false);
            this.onFinishedMovement();
        }
        this.offsetChildrenLeftAndRight(limitedDeltaX);
        this.detachOffScreenChildren(toLeft);
        if (toLeft) {
            this.fillToGalleryRight();
        } else {
            this.fillToGalleryLeft();
        }
        this.mRecycler.clear();
        this.setSelectionToCenterChild();
        View selChild = this.mSelectedChild;
        if (selChild != null) {
            int childLeft = selChild.getLeft();
            int childCenter = selChild.getWidth() / 2;
            int galleryCenter = this.getWidth() / 2;
            this.mSelectedCenterOffset = childLeft + childCenter - galleryCenter;
        }
        this.onScrollChanged(0, 0, 0, 0);
        this.invalidate();
    }

    int getLimitedMotionScrollAmount(boolean motionToLeft, int deltaX) {
        int extremeItemPosition = motionToLeft != this.mIsRtl ? this.mItemCount - 1 : 0;
        View extremeChild = this.getChildAt(extremeItemPosition - this.mFirstPosition);
        if (extremeChild == null) {
            return deltaX;
        }
        int extremeChildCenter = Gallery.getCenterOfView(extremeChild);
        int galleryCenter = this.getCenterOfGallery();
        if (motionToLeft ? extremeChildCenter <= galleryCenter : extremeChildCenter >= galleryCenter) {
            return 0;
        }
        int centerDifference = galleryCenter - extremeChildCenter;
        return motionToLeft ? Math.max(centerDifference, deltaX) : Math.min(centerDifference, deltaX);
    }

    private void offsetChildrenLeftAndRight(int offset) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).offsetLeftAndRight(offset);
        }
    }

    private int getCenterOfGallery() {
        return (this.getWidth() - this.mPaddingLeft - this.mPaddingRight) / 2 + this.mPaddingLeft;
    }

    private static int getCenterOfView(View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    private void detachOffScreenChildren(boolean toLeft) {
        int numChildren = this.getChildCount();
        int firstPosition = this.mFirstPosition;
        int start = 0;
        int count = 0;
        if (toLeft) {
            int n;
            View child;
            int galleryLeft = this.mPaddingLeft;
            for (int i = 0; i < numChildren && (child = this.getChildAt(n = this.mIsRtl ? numChildren - 1 - i : i)).getRight() < galleryLeft; ++i) {
                start = n;
                ++count;
                this.mRecycler.put(firstPosition + n, child);
            }
            if (!this.mIsRtl) {
                start = 0;
            }
        } else {
            int n;
            View child;
            int galleryRight = this.getWidth() - this.mPaddingRight;
            for (int i = numChildren - 1; i >= 0 && (child = this.getChildAt(n = this.mIsRtl ? numChildren - 1 - i : i)).getLeft() > galleryRight; --i) {
                start = n;
                ++count;
                this.mRecycler.put(firstPosition + n, child);
            }
            if (this.mIsRtl) {
                start = 0;
            }
        }
        this.detachViewsFromParent(start, count);
        if (toLeft != this.mIsRtl) {
            this.mFirstPosition += count;
        }
    }

    private void scrollIntoSlots() {
        if (this.getChildCount() == 0 || this.mSelectedChild == null) {
            return;
        }
        int selectedCenter = Gallery.getCenterOfView(this.mSelectedChild);
        int targetCenter = this.getCenterOfGallery();
        int scrollAmount = targetCenter - selectedCenter;
        if (scrollAmount != 0) {
            this.mFlingRunnable.startUsingDistance(scrollAmount);
        } else {
            this.onFinishedMovement();
        }
    }

    private void onFinishedMovement() {
        if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
            super.selectionChanged();
        }
        this.mSelectedCenterOffset = 0;
        this.invalidate();
    }

    @Override
    void selectionChanged() {
        if (!this.mSuppressSelectionChanged) {
            super.selectionChanged();
        }
    }

    private void setSelectionToCenterChild() {
        int newPos;
        View selView = this.mSelectedChild;
        if (this.mSelectedChild == null) {
            return;
        }
        int galleryCenter = this.getCenterOfGallery();
        if (selView.getLeft() <= galleryCenter && selView.getRight() >= galleryCenter) {
            return;
        }
        int closestEdgeDistance = Integer.MAX_VALUE;
        int newSelectedChildIndex = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getLeft() <= galleryCenter && child.getRight() >= galleryCenter) {
                newSelectedChildIndex = i;
                break;
            }
            int childClosestEdgeDistance = Math.min(Math.abs(child.getLeft() - galleryCenter), Math.abs(child.getRight() - galleryCenter));
            if (childClosestEdgeDistance >= closestEdgeDistance) continue;
            closestEdgeDistance = childClosestEdgeDistance;
            newSelectedChildIndex = i;
        }
        if ((newPos = this.mFirstPosition + newSelectedChildIndex) != this.mSelectedPosition) {
            this.setSelectedPositionInt(newPos);
            this.setNextSelectedPositionInt(newPos);
            this.checkSelectionChanged();
        }
    }

    @Override
    void layout(int delta, boolean animate) {
        this.mIsRtl = this.isLayoutRtl();
        int childrenLeft = this.mSpinnerPadding.left;
        int childrenWidth = this.mRight - this.mLeft - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.detachAllViewsFromParent();
        this.mRightMost = 0;
        this.mLeftMost = 0;
        this.mFirstPosition = this.mSelectedPosition;
        View sel = this.makeAndAddView(this.mSelectedPosition, 0, 0, true);
        int selectedOffset = childrenLeft + childrenWidth / 2 - sel.getWidth() / 2 + this.mSelectedCenterOffset;
        sel.offsetLeftAndRight(selectedOffset);
        this.fillToGalleryRight();
        this.fillToGalleryLeft();
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
        this.updateSelectedItemMetadata();
    }

    private void fillToGalleryLeft() {
        if (this.mIsRtl) {
            this.fillToGalleryLeftRtl();
        } else {
            this.fillToGalleryLeftLtr();
        }
    }

    private void fillToGalleryLeftRtl() {
        int curRightEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryLeft = this.mPaddingLeft;
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curRightEdge = this.mRight - this.mLeft - this.mPaddingRight;
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryLeft && curPosition < this.mItemCount) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
            ++curPosition;
        }
    }

    private void fillToGalleryLeftLtr() {
        int curRightEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryLeft = this.mPaddingLeft;
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        } else {
            curPosition = 0;
            curRightEdge = this.mRight - this.mLeft - this.mPaddingRight;
            this.mShouldStopFling = true;
        }
        while (curRightEdge > galleryLeft && curPosition >= 0) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curRightEdge, false);
            this.mFirstPosition = curPosition--;
            curRightEdge = prevIterationView.getLeft() - itemSpacing;
        }
    }

    private void fillToGalleryRight() {
        if (this.mIsRtl) {
            this.fillToGalleryRightRtl();
        } else {
            this.fillToGalleryRightLtr();
        }
    }

    private void fillToGalleryRightRtl() {
        int curLeftEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryRight = this.mRight - this.mLeft - this.mPaddingRight;
        View prevIterationView = this.getChildAt(0);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition - 1;
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
        } else {
            curPosition = 0;
            curLeftEdge = this.mPaddingLeft;
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryRight && curPosition >= 0) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            this.mFirstPosition = curPosition--;
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
        }
    }

    private void fillToGalleryRightLtr() {
        int curLeftEdge;
        int curPosition;
        int itemSpacing = this.mSpacing;
        int galleryRight = this.mRight - this.mLeft - this.mPaddingRight;
        int numChildren = this.getChildCount();
        int numItems = this.mItemCount;
        View prevIterationView = this.getChildAt(numChildren - 1);
        if (prevIterationView != null) {
            curPosition = this.mFirstPosition + numChildren;
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
        } else {
            this.mFirstPosition = curPosition = this.mItemCount - 1;
            curLeftEdge = this.mPaddingLeft;
            this.mShouldStopFling = true;
        }
        while (curLeftEdge < galleryRight && curPosition < numItems) {
            prevIterationView = this.makeAndAddView(curPosition, curPosition - this.mSelectedPosition, curLeftEdge, true);
            curLeftEdge = prevIterationView.getRight() + itemSpacing;
            ++curPosition;
        }
    }

    private View makeAndAddView(int position, int offset, int x, boolean fromLeft) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            int childLeft = child.getLeft();
            this.mRightMost = Math.max(this.mRightMost, childLeft + child.getMeasuredWidth());
            this.mLeftMost = Math.min(this.mLeftMost, childLeft);
            this.setUpChild(child, offset, x, fromLeft);
            return child;
        }
        child = this.mAdapter.getView(position, null, this);
        this.setUpChild(child, offset, x, fromLeft);
        return child;
    }

    private void setUpChild(View child, int offset, int x, boolean fromLeft) {
        int childRight;
        int childLeft;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp == null) {
            lp = (LayoutParams)this.generateDefaultLayoutParams();
        }
        this.addViewInLayout(child, fromLeft != this.mIsRtl ? -1 : 0, lp, true);
        child.setSelected(offset == 0);
        int childHeightSpec = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPadding.top + this.mSpinnerPadding.bottom, lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPadding.left + this.mSpinnerPadding.right, lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.calculateTop(child, true);
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        if (fromLeft) {
            childLeft = x;
            childRight = childLeft + width;
        } else {
            childLeft = x - width;
            childRight = x;
        }
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private int calculateTop(View child, boolean duringLayout) {
        int myHeight = duringLayout ? this.getMeasuredHeight() : this.getHeight();
        int childHeight = duringLayout ? child.getMeasuredHeight() : child.getHeight();
        int childTop = 0;
        switch (this.mGravity) {
            case 48: {
                childTop = this.mSpinnerPadding.top;
                break;
            }
            case 16: {
                int availableSpace = myHeight - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - childHeight;
                childTop = this.mSpinnerPadding.top + availableSpace / 2;
                break;
            }
            case 80: {
                childTop = myHeight - this.mSpinnerPadding.bottom - childHeight;
            }
        }
        return childTop;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        boolean retValue = this.mGestureDetector.onTouchEvent(event);
        int action = event.getAction();
        if (action == 1) {
            this.onUp();
        } else if (action == 3) {
            this.onCancel();
        }
        return retValue;
    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        if (this.mDownTouchPosition >= 0) {
            this.scrollToChild(this.mDownTouchPosition - this.mFirstPosition);
            if (this.mShouldCallbackOnUnselectedItemClick || this.mDownTouchPosition == this.mSelectedPosition) {
                this.performItemClick(this.mDownTouchView, this.mDownTouchPosition, this.mAdapter.getItemId(this.mDownTouchPosition));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mShouldCallbackDuringFling) {
            this.removeCallbacks(this.mDisableSuppressSelectionChangedRunnable);
            if (!this.mSuppressSelectionChanged) {
                this.mSuppressSelectionChanged = true;
            }
        }
        this.mFlingRunnable.startUsingVelocity((int)(-velocityX));
        return true;
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        this.mParent.requestDisallowInterceptTouchEvent(true);
        if (!this.mShouldCallbackDuringFling) {
            if (this.mIsFirstScroll) {
                if (!this.mSuppressSelectionChanged) {
                    this.mSuppressSelectionChanged = true;
                }
                this.postDelayed(this.mDisableSuppressSelectionChangedRunnable, 250L);
            }
        } else if (this.mSuppressSelectionChanged) {
            this.mSuppressSelectionChanged = false;
        }
        this.trackMotionScroll(-1 * (int)distanceX);
        this.mIsFirstScroll = false;
        return true;
    }

    @Override
    public boolean onDown(MotionEvent e) {
        this.mFlingRunnable.stop(false);
        this.mDownTouchPosition = this.pointToPosition((int)e.getX(), (int)e.getY());
        if (this.mDownTouchPosition >= 0) {
            this.mDownTouchView = this.getChildAt(this.mDownTouchPosition - this.mFirstPosition);
            this.mDownTouchView.setPressed(true);
        }
        this.mIsFirstScroll = true;
        return true;
    }

    void onUp() {
        if (this.mFlingRunnable.mScroller.isFinished()) {
            this.scrollIntoSlots();
        }
        this.dispatchUnpress();
    }

    void onCancel() {
        this.onUp();
    }

    @Override
    public void onLongPress(MotionEvent e) {
        if (this.mDownTouchPosition < 0) {
            return;
        }
        this.performHapticFeedback(0);
        long id2 = this.getItemIdAtPosition(this.mDownTouchPosition);
        this.dispatchLongPress(this.mDownTouchView, this.mDownTouchPosition, id2);
    }

    @Override
    public void onShowPress(MotionEvent e) {
    }

    private void dispatchPress(View child) {
        if (child != null) {
            child.setPressed(true);
        }
        this.setPressed(true);
    }

    private void dispatchUnpress() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.getChildAt(i).setPressed(false);
        }
        this.setPressed(false);
    }

    @Override
    public void dispatchSetSelected(boolean selected) {
    }

    @Override
    protected void dispatchSetPressed(boolean pressed) {
        if (this.mSelectedChild != null) {
            this.mSelectedChild.setPressed(pressed);
        }
    }

    @Override
    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    @Override
    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition < 0) {
            return false;
        }
        long longPressId = this.mAdapter.getItemId(longPressPosition);
        return this.dispatchLongPress(originalView, longPressPosition, longPressId);
    }

    @Override
    public boolean showContextMenu() {
        if (this.isPressed() && this.mSelectedPosition >= 0) {
            int index = this.mSelectedPosition - this.mFirstPosition;
            View v = this.getChildAt(index);
            return this.dispatchLongPress(v, this.mSelectedPosition, this.mSelectedRowId);
        }
        return false;
    }

    private boolean dispatchLongPress(View view, int position, long id2) {
        boolean handled = false;
        if (this.mOnItemLongClickListener != null) {
            handled = this.mOnItemLongClickListener.onItemLongClick(this, this.mDownTouchView, this.mDownTouchPosition, id2);
        }
        if (!handled) {
            this.mContextMenuInfo = new AdapterView.AdapterContextMenuInfo(view, position, id2);
            handled = super.showContextMenuForChild(this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        return event.dispatch(this, null, null);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 21: {
                if (!this.moveDirection(-1)) break;
                this.playSoundEffect(1);
                return true;
            }
            case 22: {
                if (!this.moveDirection(1)) break;
                this.playSoundEffect(3);
                return true;
            }
            case 23: 
            case 66: {
                this.mReceivedInvokeKeyDown = true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (KeyEvent.isConfirmKey(keyCode)) {
            if (this.mReceivedInvokeKeyDown && this.mItemCount > 0) {
                this.dispatchPress(this.mSelectedChild);
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Gallery.this.dispatchUnpress();
                    }
                }, ViewConfiguration.getPressedStateDuration());
                int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
                this.performItemClick(this.getChildAt(selectedIndex), this.mSelectedPosition, this.mAdapter.getItemId(this.mSelectedPosition));
            }
            this.mReceivedInvokeKeyDown = false;
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    boolean moveDirection(int direction) {
        direction = this.isLayoutRtl() ? -direction : direction;
        int targetPosition = this.mSelectedPosition + direction;
        if (this.mItemCount > 0 && targetPosition >= 0 && targetPosition < this.mItemCount) {
            this.scrollToChild(targetPosition - this.mFirstPosition);
            return true;
        }
        return false;
    }

    private boolean scrollToChild(int childPosition) {
        View child = this.getChildAt(childPosition);
        if (child != null) {
            int distance = this.getCenterOfGallery() - Gallery.getCenterOfView(child);
            this.mFlingRunnable.startUsingDistance(distance);
            return true;
        }
        return false;
    }

    @Override
    void setSelectedPositionInt(int position) {
        super.setSelectedPositionInt(position);
        this.updateSelectedItemMetadata();
    }

    private void updateSelectedItemMetadata() {
        View oldSelectedChild = this.mSelectedChild;
        this.mSelectedChild = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        View child = this.mSelectedChild;
        if (child == null) {
            return;
        }
        child.setSelected(true);
        child.setFocusable(true);
        if (this.hasFocus()) {
            child.requestFocus();
        }
        if (oldSelectedChild != null && oldSelectedChild != child) {
            oldSelectedChild.setSelected(false);
            oldSelectedChild.setFocusable(false);
        }
    }

    public void setGravity(int gravity) {
        if (this.mGravity != gravity) {
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    @Override
    protected int getChildDrawingOrder(int childCount, int i) {
        int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
        if (selectedIndex < 0) {
            return i;
        }
        if (i == childCount - 1) {
            return selectedIndex;
        }
        if (i >= selectedIndex) {
            return i + 1;
        }
        return i;
    }

    @Override
    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.mSelectedChild != null) {
            this.mSelectedChild.requestFocus(direction);
            this.mSelectedChild.setSelected(true);
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return Gallery.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setScrollable(this.mItemCount > 1);
        if (this.isEnabled()) {
            if (this.mItemCount > 0 && this.mSelectedPosition < this.mItemCount - 1) {
                info.addAction(4096);
            }
            if (this.isEnabled() && this.mItemCount > 0 && this.mSelectedPosition > 0) {
                info.addAction(8192);
            }
        }
    }

    @Override
    public boolean performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        switch (action) {
            case 4096: {
                if (this.isEnabled() && this.mItemCount > 0 && this.mSelectedPosition < this.mItemCount - 1) {
                    int currentChildIndex = this.mSelectedPosition - this.mFirstPosition;
                    return this.scrollToChild(currentChildIndex + 1);
                }
                return false;
            }
            case 8192: {
                if (this.isEnabled() && this.mItemCount > 0 && this.mSelectedPosition > 0) {
                    int currentChildIndex = this.mSelectedPosition - this.mFirstPosition;
                    return this.scrollToChild(currentChildIndex - 1);
                }
                return false;
            }
        }
        return false;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class FlingRunnable
    implements Runnable {
        private Scroller mScroller;
        private int mLastFlingX;

        public FlingRunnable() {
            this.mScroller = new Scroller(Gallery.this.getContext());
        }

        private void startCommon() {
            Gallery.this.removeCallbacks(this);
        }

        public void startUsingVelocity(int initialVelocity) {
            int initialX;
            if (initialVelocity == 0) {
                return;
            }
            this.startCommon();
            this.mLastFlingX = initialX = initialVelocity < 0 ? Integer.MAX_VALUE : 0;
            this.mScroller.fling(initialX, 0, initialVelocity, 0, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            Gallery.this.post(this);
        }

        public void startUsingDistance(int distance) {
            if (distance == 0) {
                return;
            }
            this.startCommon();
            this.mLastFlingX = 0;
            this.mScroller.startScroll(0, 0, -distance, 0, Gallery.this.mAnimationDuration);
            Gallery.this.post(this);
        }

        public void stop(boolean scrollIntoSlots) {
            Gallery.this.removeCallbacks(this);
            this.endFling(scrollIntoSlots);
        }

        private void endFling(boolean scrollIntoSlots) {
            this.mScroller.forceFinished(true);
            if (scrollIntoSlots) {
                Gallery.this.scrollIntoSlots();
            }
        }

        @Override
        public void run() {
            if (Gallery.this.mItemCount == 0) {
                this.endFling(true);
                return;
            }
            Gallery.this.mShouldStopFling = false;
            Scroller scroller = this.mScroller;
            boolean more = scroller.computeScrollOffset();
            int x = scroller.getCurrX();
            int delta = this.mLastFlingX - x;
            if (delta > 0) {
                Gallery.this.mDownTouchPosition = Gallery.this.mIsRtl ? Gallery.this.mFirstPosition + Gallery.this.getChildCount() - 1 : Gallery.this.mFirstPosition;
                delta = Math.min(Gallery.this.getWidth() - Gallery.this.mPaddingLeft - Gallery.this.mPaddingRight - 1, delta);
            } else {
                int offsetToLast = Gallery.this.getChildCount() - 1;
                Gallery.this.mDownTouchPosition = Gallery.this.mIsRtl ? Gallery.this.mFirstPosition : Gallery.this.mFirstPosition + Gallery.this.getChildCount() - 1;
                delta = Math.max(-(Gallery.this.getWidth() - Gallery.this.mPaddingRight - Gallery.this.mPaddingLeft - 1), delta);
            }
            Gallery.this.trackMotionScroll(delta);
            if (more && !Gallery.this.mShouldStopFling) {
                this.mLastFlingX = x;
                Gallery.this.post(this);
            } else {
                this.endFling(true);
            }
        }
    }
}

