/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.LogPrinter;
import android.util.Pair;
import android.util.Printer;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import android.widget.Space;
import com.android.internal.R;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

@RemoteViews.RemoteView
public class GridLayout
extends ViewGroup {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    public static final int ALIGN_BOUNDS = 0;
    public static final int ALIGN_MARGINS = 1;
    static final int MAX_SIZE = 100000;
    static final int DEFAULT_CONTAINER_MARGIN = 0;
    static final int UNINITIALIZED_HASH = 0;
    static final Printer LOG_PRINTER = new LogPrinter(3, GridLayout.class.getName());
    static final Printer NO_PRINTER = new Printer(){

        @Override
        public void println(String x) {
        }
    };
    private static final int DEFAULT_ORIENTATION = 0;
    private static final int DEFAULT_COUNT = Integer.MIN_VALUE;
    private static final boolean DEFAULT_USE_DEFAULT_MARGINS = false;
    private static final boolean DEFAULT_ORDER_PRESERVED = true;
    private static final int DEFAULT_ALIGNMENT_MODE = 1;
    private static final int ORIENTATION = 0;
    private static final int ROW_COUNT = 1;
    private static final int COLUMN_COUNT = 3;
    private static final int USE_DEFAULT_MARGINS = 5;
    private static final int ALIGNMENT_MODE = 6;
    private static final int ROW_ORDER_PRESERVED = 2;
    private static final int COLUMN_ORDER_PRESERVED = 4;
    final Axis mHorizontalAxis = new Axis(true);
    final Axis mVerticalAxis = new Axis(false);
    int mOrientation = 0;
    boolean mUseDefaultMargins = false;
    int mAlignmentMode = 1;
    int mDefaultGap;
    int mLastLayoutParamsHashCode = 0;
    Printer mPrinter = LOG_PRINTER;
    static final Alignment UNDEFINED_ALIGNMENT = new Alignment(){

        @Override
        int getGravityOffset(View view, int cellDelta) {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getAlignmentValue(View view, int viewSize, int mode) {
            return Integer.MIN_VALUE;
        }
    };
    private static final Alignment LEADING = new Alignment(){

        @Override
        int getGravityOffset(View view, int cellDelta) {
            return 0;
        }

        @Override
        public int getAlignmentValue(View view, int viewSize, int mode) {
            return 0;
        }
    };
    private static final Alignment TRAILING = new Alignment(){

        @Override
        int getGravityOffset(View view, int cellDelta) {
            return cellDelta;
        }

        @Override
        public int getAlignmentValue(View view, int viewSize, int mode) {
            return viewSize;
        }
    };
    public static final Alignment TOP = LEADING;
    public static final Alignment BOTTOM = TRAILING;
    public static final Alignment START = LEADING;
    public static final Alignment END = TRAILING;
    public static final Alignment LEFT = GridLayout.createSwitchingAlignment(START, END);
    public static final Alignment RIGHT = GridLayout.createSwitchingAlignment(END, START);
    public static final Alignment CENTER = new Alignment(){

        @Override
        int getGravityOffset(View view, int cellDelta) {
            return cellDelta >> 1;
        }

        @Override
        public int getAlignmentValue(View view, int viewSize, int mode) {
            return viewSize >> 1;
        }
    };
    public static final Alignment BASELINE = new Alignment(){

        @Override
        int getGravityOffset(View view, int cellDelta) {
            return 0;
        }

        @Override
        public int getAlignmentValue(View view, int viewSize, int mode) {
            if (view.getVisibility() == 8) {
                return 0;
            }
            int baseline = view.getBaseline();
            return baseline == -1 ? Integer.MIN_VALUE : baseline;
        }

        @Override
        public Bounds getBounds() {
            return new Bounds(){
                private int size;

                @Override
                protected void reset() {
                    super.reset();
                    this.size = Integer.MIN_VALUE;
                }

                @Override
                protected void include(int before, int after) {
                    super.include(before, after);
                    this.size = Math.max(this.size, before + after);
                }

                @Override
                protected int size(boolean min) {
                    return Math.max(super.size(min), this.size);
                }

                @Override
                protected int getOffset(GridLayout gl, View c, Alignment a, int size, boolean hrz) {
                    return Math.max(0, super.getOffset(gl, c, a, size, hrz));
                }
            };
        }
    };
    public static final Alignment FILL = new Alignment(){

        @Override
        int getGravityOffset(View view, int cellDelta) {
            return 0;
        }

        @Override
        public int getAlignmentValue(View view, int viewSize, int mode) {
            return Integer.MIN_VALUE;
        }

        @Override
        public int getSizeInCell(View view, int viewSize, int cellSize) {
            return cellSize;
        }
    };
    private static final int INFLEXIBLE = 0;
    private static final int CAN_STRETCH = 2;

    public GridLayout(Context context) {
        this(context, null);
    }

    public GridLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GridLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mDefaultGap = context.getResources().getDimensionPixelOffset(17104974);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridLayout, defStyleAttr, defStyleRes);
        try {
            this.setRowCount(a.getInt(1, Integer.MIN_VALUE));
            this.setColumnCount(a.getInt(3, Integer.MIN_VALUE));
            this.setOrientation(a.getInt(0, 0));
            this.setUseDefaultMargins(a.getBoolean(5, false));
            this.setAlignmentMode(a.getInt(6, 1));
            this.setRowOrderPreserved(a.getBoolean(2, true));
            this.setColumnOrderPreserved(a.getBoolean(4, true));
        }
        finally {
            a.recycle();
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation != orientation) {
            this.mOrientation = orientation;
            this.invalidateStructure();
            this.requestLayout();
        }
    }

    public int getRowCount() {
        return this.mVerticalAxis.getCount();
    }

    public void setRowCount(int rowCount) {
        this.mVerticalAxis.setCount(rowCount);
        this.invalidateStructure();
        this.requestLayout();
    }

    public int getColumnCount() {
        return this.mHorizontalAxis.getCount();
    }

    public void setColumnCount(int columnCount) {
        this.mHorizontalAxis.setCount(columnCount);
        this.invalidateStructure();
        this.requestLayout();
    }

    public boolean getUseDefaultMargins() {
        return this.mUseDefaultMargins;
    }

    public void setUseDefaultMargins(boolean useDefaultMargins) {
        this.mUseDefaultMargins = useDefaultMargins;
        this.requestLayout();
    }

    public int getAlignmentMode() {
        return this.mAlignmentMode;
    }

    public void setAlignmentMode(int alignmentMode) {
        this.mAlignmentMode = alignmentMode;
        this.requestLayout();
    }

    public boolean isRowOrderPreserved() {
        return this.mVerticalAxis.isOrderPreserved();
    }

    public void setRowOrderPreserved(boolean rowOrderPreserved) {
        this.mVerticalAxis.setOrderPreserved(rowOrderPreserved);
        this.invalidateStructure();
        this.requestLayout();
    }

    public boolean isColumnOrderPreserved() {
        return this.mHorizontalAxis.isOrderPreserved();
    }

    public void setColumnOrderPreserved(boolean columnOrderPreserved) {
        this.mHorizontalAxis.setOrderPreserved(columnOrderPreserved);
        this.invalidateStructure();
        this.requestLayout();
    }

    public Printer getPrinter() {
        return this.mPrinter;
    }

    public void setPrinter(Printer printer) {
        this.mPrinter = printer == null ? NO_PRINTER : printer;
    }

    static int max2(int[] a, int valueIfEmpty) {
        int result = valueIfEmpty;
        int N = a.length;
        for (int i = 0; i < N; ++i) {
            result = Math.max(result, a[i]);
        }
        return result;
    }

    static <T> T[] append(T[] a, T[] b) {
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    static Alignment getAlignment(int gravity, boolean horizontal) {
        int mask = horizontal ? 7 : 112;
        int shift = horizontal ? 0 : 4;
        int flags = (gravity & mask) >> shift;
        switch (flags) {
            case 3: {
                return horizontal ? LEFT : TOP;
            }
            case 5: {
                return horizontal ? RIGHT : BOTTOM;
            }
            case 7: {
                return FILL;
            }
            case 1: {
                return CENTER;
            }
            case 0x800003: {
                return START;
            }
            case 0x800005: {
                return END;
            }
        }
        return UNDEFINED_ALIGNMENT;
    }

    private int getDefaultMargin(View c, boolean horizontal, boolean leading) {
        if (c.getClass() == Space.class) {
            return 0;
        }
        return this.mDefaultGap / 2;
    }

    private int getDefaultMargin(View c, boolean isAtEdge, boolean horizontal, boolean leading) {
        return this.getDefaultMargin(c, horizontal, leading);
    }

    private int getDefaultMargin(View c, LayoutParams p, boolean horizontal, boolean leading) {
        boolean leading1;
        if (!this.mUseDefaultMargins) {
            return 0;
        }
        Spec spec = horizontal ? p.columnSpec : p.rowSpec;
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        Interval span = spec.span;
        boolean bl = horizontal && this.isLayoutRtl() ? !leading : (leading1 = leading);
        boolean isAtEdge = leading1 ? span.min == 0 : span.max == axis.getCount();
        return this.getDefaultMargin(c, isAtEdge, horizontal, leading);
    }

    int getMargin1(View view, boolean horizontal, boolean leading) {
        LayoutParams lp = this.getLayoutParams(view);
        int margin = horizontal ? (leading ? lp.leftMargin : lp.rightMargin) : (leading ? lp.topMargin : lp.bottomMargin);
        return margin == Integer.MIN_VALUE ? this.getDefaultMargin(view, lp, horizontal, leading) : margin;
    }

    private int getMargin(View view, boolean horizontal, boolean leading) {
        if (this.mAlignmentMode == 1) {
            return this.getMargin1(view, horizontal, leading);
        }
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        int[] margins = leading ? axis.getLeadingMargins() : axis.getTrailingMargins();
        LayoutParams lp = this.getLayoutParams(view);
        Spec spec = horizontal ? lp.columnSpec : lp.rowSpec;
        int index = leading ? spec.span.min : spec.span.max;
        return margins[index];
    }

    private int getTotalMargin(View child, boolean horizontal) {
        return this.getMargin(child, horizontal, true) + this.getMargin(child, horizontal, false);
    }

    private static boolean fits(int[] a, int value, int start, int end) {
        if (end > a.length) {
            return false;
        }
        for (int i = start; i < end; ++i) {
            if (a[i] <= value) continue;
            return false;
        }
        return true;
    }

    private static void procrusteanFill(int[] a, int start, int end, int value) {
        int length = a.length;
        Arrays.fill(a, Math.min(start, length), Math.min(end, length), value);
    }

    private static void setCellGroup(LayoutParams lp, int row, int rowSpan, int col, int colSpan) {
        lp.setRowSpecSpan(new Interval(row, row + rowSpan));
        lp.setColumnSpecSpan(new Interval(col, col + colSpan));
    }

    private static int clip(Interval minorRange, boolean minorWasDefined, int count) {
        int size = minorRange.size();
        if (count == 0) {
            return size;
        }
        int min = minorWasDefined ? Math.min(minorRange.min, count) : 0;
        return Math.min(size, count - min);
    }

    private void validateLayoutParams() {
        boolean horizontal = this.mOrientation == 0;
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        int count = axis.definedCount != Integer.MIN_VALUE ? axis.definedCount : 0;
        int major = 0;
        int minor = 0;
        int[] maxSizes = new int[count];
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            Spec majorSpec = horizontal ? lp.rowSpec : lp.columnSpec;
            Interval majorRange = majorSpec.span;
            boolean majorWasDefined = majorSpec.startDefined;
            int majorSpan = majorRange.size();
            if (majorWasDefined) {
                major = majorRange.min;
            }
            Spec minorSpec = horizontal ? lp.columnSpec : lp.rowSpec;
            Interval minorRange = minorSpec.span;
            boolean minorWasDefined = minorSpec.startDefined;
            int minorSpan = GridLayout.clip(minorRange, minorWasDefined, count);
            if (minorWasDefined) {
                minor = minorRange.min;
            }
            if (count != 0) {
                if (!majorWasDefined || !minorWasDefined) {
                    while (!GridLayout.fits(maxSizes, major, minor, minor + minorSpan)) {
                        if (minorWasDefined) {
                            ++major;
                            continue;
                        }
                        if (minor + minorSpan <= count) {
                            ++minor;
                            continue;
                        }
                        minor = 0;
                        ++major;
                    }
                }
                GridLayout.procrusteanFill(maxSizes, minor, minor + minorSpan, major + majorSpan);
            }
            if (horizontal) {
                GridLayout.setCellGroup(lp, major, majorSpan, minor, minorSpan);
            } else {
                GridLayout.setCellGroup(lp, minor, minorSpan, major, majorSpan);
            }
            minor += minorSpan;
        }
    }

    private void invalidateStructure() {
        this.mLastLayoutParamsHashCode = 0;
        this.mHorizontalAxis.invalidateStructure();
        this.mVerticalAxis.invalidateStructure();
        this.invalidateValues();
    }

    private void invalidateValues() {
        if (this.mHorizontalAxis != null && this.mVerticalAxis != null) {
            this.mHorizontalAxis.invalidateValues();
            this.mVerticalAxis.invalidateValues();
        }
    }

    @Override
    protected void onSetLayoutParams(View child, ViewGroup.LayoutParams layoutParams) {
        super.onSetLayoutParams(child, layoutParams);
        if (!this.checkLayoutParams(layoutParams)) {
            GridLayout.handleInvalidParams("supplied LayoutParams are of the wrong type");
        }
        this.invalidateStructure();
    }

    final LayoutParams getLayoutParams(View c) {
        return (LayoutParams)c.getLayoutParams();
    }

    private static void handleInvalidParams(String msg) {
        throw new IllegalArgumentException(msg + ". ");
    }

    private void checkLayoutParams(LayoutParams lp, boolean horizontal) {
        String groupName = horizontal ? "column" : "row";
        Spec spec = horizontal ? lp.columnSpec : lp.rowSpec;
        Interval span = spec.span;
        if (span.min != Integer.MIN_VALUE && span.min < 0) {
            GridLayout.handleInvalidParams(groupName + " indices must be positive");
        }
        Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
        int count = axis.definedCount;
        if (count != Integer.MIN_VALUE) {
            if (span.max > count) {
                GridLayout.handleInvalidParams(groupName + " indices (start + span) mustn't exceed the " + groupName + " count");
            }
            if (span.size() > count) {
                GridLayout.handleInvalidParams(groupName + " span mustn't exceed the " + groupName + " count");
            }
        }
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        if (!(p instanceof LayoutParams)) {
            return false;
        }
        LayoutParams lp = (LayoutParams)p;
        this.checkLayoutParams(lp, true);
        this.checkLayoutParams(lp, false);
        return true;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private void drawLine(Canvas graphics, int x1, int y1, int x2, int y2, Paint paint) {
        if (this.isLayoutRtl()) {
            int width = this.getWidth();
            graphics.drawLine(width - x1, y1, width - x2, y2, paint);
        } else {
            graphics.drawLine(x1, y1, x2, y2, paint);
        }
    }

    @Override
    protected void onDebugDrawMargins(Canvas canvas, Paint paint) {
        LayoutParams lp = new LayoutParams();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View c = this.getChildAt(i);
            lp.setMargins(this.getMargin1(c, true, true), this.getMargin1(c, false, true), this.getMargin1(c, true, false), this.getMargin1(c, false, false));
            lp.onDebugDraw(c, canvas, paint);
        }
    }

    @Override
    protected void onDebugDraw(Canvas canvas) {
        int[] ys;
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(Color.argb(50, 255, 255, 255));
        Insets insets = this.getOpticalInsets();
        int top = this.getPaddingTop() + insets.top;
        int left = this.getPaddingLeft() + insets.left;
        int right = this.getWidth() - this.getPaddingRight() - insets.right;
        int bottom = this.getHeight() - this.getPaddingBottom() - insets.bottom;
        int[] xs = this.mHorizontalAxis.locations;
        if (xs != null) {
            int length = xs.length;
            for (int i = 0; i < length; ++i) {
                int x = left + xs[i];
                this.drawLine(canvas, x, top, x, bottom, paint);
            }
        }
        if ((ys = this.mVerticalAxis.locations) != null) {
            int length = ys.length;
            for (int i = 0; i < length; ++i) {
                int y = top + ys[i];
                this.drawLine(canvas, left, y, right, y, paint);
            }
        }
        super.onDebugDraw(canvas);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.invalidateStructure();
    }

    @Override
    public void onViewRemoved(View child) {
        super.onViewRemoved(child);
        this.invalidateStructure();
    }

    @Override
    protected void onChildVisibilityChanged(View child, int oldVisibility, int newVisibility) {
        super.onChildVisibilityChanged(child, oldVisibility, newVisibility);
        if (oldVisibility == 8 || newVisibility == 8) {
            this.invalidateStructure();
        }
    }

    private int computeLayoutParamsHashCode() {
        int result = 1;
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)c.getLayoutParams();
            result = 31 * result + lp.hashCode();
        }
        return result;
    }

    private void consistencyCheck() {
        if (this.mLastLayoutParamsHashCode == 0) {
            this.validateLayoutParams();
            this.mLastLayoutParamsHashCode = this.computeLayoutParamsHashCode();
        } else if (this.mLastLayoutParamsHashCode != this.computeLayoutParamsHashCode()) {
            this.mPrinter.println("The fields of some layout parameters were modified in between layout operations. Check the javadoc for GridLayout.LayoutParams#rowSpec.");
            this.invalidateStructure();
            this.consistencyCheck();
        }
    }

    private void measureChildWithMargins2(View child, int parentWidthSpec, int parentHeightSpec, int childWidth, int childHeight) {
        int childWidthSpec = GridLayout.getChildMeasureSpec(parentWidthSpec, this.getTotalMargin(child, true), childWidth);
        int childHeightSpec = GridLayout.getChildMeasureSpec(parentHeightSpec, this.getTotalMargin(child, false), childHeight);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private void measureChildrenWithMargins(int widthSpec, int heightSpec, boolean firstPass) {
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            Spec spec;
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            LayoutParams lp = this.getLayoutParams(c);
            if (firstPass) {
                this.measureChildWithMargins2(c, widthSpec, heightSpec, lp.width, lp.height);
                continue;
            }
            boolean horizontal = this.mOrientation == 0;
            Spec spec2 = spec = horizontal ? lp.columnSpec : lp.rowSpec;
            if (spec.getAbsoluteAlignment(horizontal) != FILL) continue;
            Interval span = spec.span;
            Axis axis = horizontal ? this.mHorizontalAxis : this.mVerticalAxis;
            int[] locations = axis.getLocations();
            int cellSize = locations[span.max] - locations[span.min];
            int viewSize = cellSize - this.getTotalMargin(c, horizontal);
            if (horizontal) {
                this.measureChildWithMargins2(c, widthSpec, heightSpec, viewSize, lp.height);
                continue;
            }
            this.measureChildWithMargins2(c, widthSpec, heightSpec, lp.width, viewSize);
        }
    }

    static int adjust(int measureSpec, int delta) {
        return View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(measureSpec + delta), View.MeasureSpec.getMode(measureSpec));
    }

    @Override
    protected void onMeasure(int widthSpec, int heightSpec) {
        int heightSansPadding;
        int widthSansPadding;
        this.consistencyCheck();
        this.invalidateValues();
        int hPadding = this.getPaddingLeft() + this.getPaddingRight();
        int vPadding = this.getPaddingTop() + this.getPaddingBottom();
        int widthSpecSansPadding = GridLayout.adjust(widthSpec, -hPadding);
        int heightSpecSansPadding = GridLayout.adjust(heightSpec, -vPadding);
        this.measureChildrenWithMargins(widthSpecSansPadding, heightSpecSansPadding, true);
        if (this.mOrientation == 0) {
            widthSansPadding = this.mHorizontalAxis.getMeasure(widthSpecSansPadding);
            this.measureChildrenWithMargins(widthSpecSansPadding, heightSpecSansPadding, false);
            heightSansPadding = this.mVerticalAxis.getMeasure(heightSpecSansPadding);
        } else {
            heightSansPadding = this.mVerticalAxis.getMeasure(heightSpecSansPadding);
            this.measureChildrenWithMargins(widthSpecSansPadding, heightSpecSansPadding, false);
            widthSansPadding = this.mHorizontalAxis.getMeasure(widthSpecSansPadding);
        }
        int measuredWidth = Math.max(widthSansPadding + hPadding, this.getSuggestedMinimumWidth());
        int measuredHeight = Math.max(heightSansPadding + vPadding, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(GridLayout.resolveSizeAndState(measuredWidth, widthSpec, 0), GridLayout.resolveSizeAndState(measuredHeight, heightSpec, 0));
    }

    private int getMeasurement(View c, boolean horizontal) {
        return horizontal ? c.getMeasuredWidth() : c.getMeasuredHeight();
    }

    final int getMeasurementIncludingMargin(View c, boolean horizontal) {
        if (c.getVisibility() == 8) {
            return 0;
        }
        return this.getMeasurement(c, horizontal) + this.getTotalMargin(c, horizontal);
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.invalidateValues();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.consistencyCheck();
        int targetWidth = right - left;
        int targetHeight = bottom - top;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        this.mHorizontalAxis.layout(targetWidth - paddingLeft - paddingRight);
        this.mVerticalAxis.layout(targetHeight - paddingTop - paddingBottom);
        int[] hLocations = this.mHorizontalAxis.getLocations();
        int[] vLocations = this.mVerticalAxis.getLocations();
        int N = this.getChildCount();
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c.getVisibility() == 8) continue;
            LayoutParams lp = this.getLayoutParams(c);
            Spec columnSpec = lp.columnSpec;
            Spec rowSpec = lp.rowSpec;
            Interval colSpan = columnSpec.span;
            Interval rowSpan = rowSpec.span;
            int x1 = hLocations[colSpan.min];
            int y1 = vLocations[rowSpan.min];
            int x2 = hLocations[colSpan.max];
            int y2 = vLocations[rowSpan.max];
            int cellWidth = x2 - x1;
            int cellHeight = y2 - y1;
            int pWidth = this.getMeasurement(c, true);
            int pHeight = this.getMeasurement(c, false);
            Alignment hAlign = columnSpec.getAbsoluteAlignment(true);
            Alignment vAlign = rowSpec.getAbsoluteAlignment(false);
            Bounds boundsX = this.mHorizontalAxis.getGroupBounds().getValue(i);
            Bounds boundsY = this.mVerticalAxis.getGroupBounds().getValue(i);
            int gravityOffsetX = hAlign.getGravityOffset(c, cellWidth - boundsX.size(true));
            int gravityOffsetY = vAlign.getGravityOffset(c, cellHeight - boundsY.size(true));
            int leftMargin = this.getMargin(c, true, true);
            int topMargin = this.getMargin(c, false, true);
            int rightMargin = this.getMargin(c, true, false);
            int bottomMargin = this.getMargin(c, false, false);
            int sumMarginsX = leftMargin + rightMargin;
            int sumMarginsY = topMargin + bottomMargin;
            int alignmentOffsetX = boundsX.getOffset(this, c, hAlign, pWidth + sumMarginsX, true);
            int alignmentOffsetY = boundsY.getOffset(this, c, vAlign, pHeight + sumMarginsY, false);
            int width = hAlign.getSizeInCell(c, pWidth, cellWidth - sumMarginsX);
            int height = vAlign.getSizeInCell(c, pHeight, cellHeight - sumMarginsY);
            int dx = x1 + gravityOffsetX + alignmentOffsetX;
            int cx = !this.isLayoutRtl() ? paddingLeft + leftMargin + dx : targetWidth - width - paddingRight - rightMargin - dx;
            int cy = paddingTop + y1 + gravityOffsetY + alignmentOffsetY + topMargin;
            if (width != c.getMeasuredWidth() || height != c.getMeasuredHeight()) {
                c.measure(View.MeasureSpec.makeMeasureSpec(width, 0x40000000), View.MeasureSpec.makeMeasureSpec(height, 0x40000000));
            }
            c.layout(cx, cy, cx + width, cy + height);
        }
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return GridLayout.class.getName();
    }

    public static Spec spec(int start, int size, Alignment alignment, float weight) {
        return new Spec(start != Integer.MIN_VALUE, start, size, alignment, weight);
    }

    public static Spec spec(int start, Alignment alignment, float weight) {
        return GridLayout.spec(start, 1, alignment, weight);
    }

    public static Spec spec(int start, int size, float weight) {
        return GridLayout.spec(start, size, UNDEFINED_ALIGNMENT, weight);
    }

    public static Spec spec(int start, float weight) {
        return GridLayout.spec(start, 1, weight);
    }

    public static Spec spec(int start, int size, Alignment alignment) {
        return GridLayout.spec(start, size, alignment, 0.0f);
    }

    public static Spec spec(int start, Alignment alignment) {
        return GridLayout.spec(start, 1, alignment);
    }

    public static Spec spec(int start, int size) {
        return GridLayout.spec(start, size, UNDEFINED_ALIGNMENT);
    }

    public static Spec spec(int start) {
        return GridLayout.spec(start, 1);
    }

    private static Alignment createSwitchingAlignment(final Alignment ltr, final Alignment rtl) {
        return new Alignment(){

            @Override
            int getGravityOffset(View view, int cellDelta) {
                return (!view.isLayoutRtl() ? ltr : rtl).getGravityOffset(view, cellDelta);
            }

            @Override
            public int getAlignmentValue(View view, int viewSize, int mode) {
                return (!view.isLayoutRtl() ? ltr : rtl).getAlignmentValue(view, viewSize, mode);
            }
        };
    }

    static boolean canStretch(int flexibility) {
        return (flexibility & 2) != 0;
    }

    public static abstract class Alignment {
        Alignment() {
        }

        abstract int getGravityOffset(View var1, int var2);

        abstract int getAlignmentValue(View var1, int var2, int var3);

        int getSizeInCell(View view, int viewSize, int cellSize) {
            return viewSize;
        }

        Bounds getBounds() {
            return new Bounds();
        }
    }

    public static class Spec {
        static final Spec UNDEFINED = GridLayout.spec(Integer.MIN_VALUE);
        static final float DEFAULT_WEIGHT = 0.0f;
        final boolean startDefined;
        final Interval span;
        final Alignment alignment;
        final float weight;

        private Spec(boolean startDefined, Interval span, Alignment alignment, float weight) {
            this.startDefined = startDefined;
            this.span = span;
            this.alignment = alignment;
            this.weight = weight;
        }

        private Spec(boolean startDefined, int start, int size, Alignment alignment, float weight) {
            this(startDefined, new Interval(start, start + size), alignment, weight);
        }

        private Alignment getAbsoluteAlignment(boolean horizontal) {
            if (this.alignment != UNDEFINED_ALIGNMENT) {
                return this.alignment;
            }
            if (this.weight == 0.0f) {
                return horizontal ? START : BASELINE;
            }
            return FILL;
        }

        final Spec copyWriteSpan(Interval span) {
            return new Spec(this.startDefined, span, this.alignment, this.weight);
        }

        final Spec copyWriteAlignment(Alignment alignment) {
            return new Spec(this.startDefined, this.span, alignment, this.weight);
        }

        final int getFlexibility() {
            return this.alignment == UNDEFINED_ALIGNMENT && this.weight == 0.0f ? 0 : 2;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Spec spec = (Spec)that;
            if (!this.alignment.equals(spec.alignment)) {
                return false;
            }
            return this.span.equals(spec.span);
        }

        public int hashCode() {
            int result = this.span.hashCode();
            result = 31 * result + this.alignment.hashCode();
            return result;
        }
    }

    static final class Interval {
        public final int min;
        public final int max;

        public Interval(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int size() {
            return this.max - this.min;
        }

        Interval inverse() {
            return new Interval(this.max, this.min);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null || this.getClass() != that.getClass()) {
                return false;
            }
            Interval interval = (Interval)that;
            if (this.max != interval.max) {
                return false;
            }
            return this.min == interval.min;
        }

        public int hashCode() {
            int result = this.min;
            result = 31 * result + this.max;
            return result;
        }

        public String toString() {
            return "[" + this.min + ", " + this.max + "]";
        }
    }

    static class Bounds {
        public int before;
        public int after;
        public int flexibility;

        private Bounds() {
            this.reset();
        }

        protected void reset() {
            this.before = Integer.MIN_VALUE;
            this.after = Integer.MIN_VALUE;
            this.flexibility = 2;
        }

        protected void include(int before, int after) {
            this.before = Math.max(this.before, before);
            this.after = Math.max(this.after, after);
        }

        protected int size(boolean min) {
            if (!min && GridLayout.canStretch(this.flexibility)) {
                return 100000;
            }
            return this.before + this.after;
        }

        protected int getOffset(GridLayout gl, View c, Alignment a, int size, boolean horizontal) {
            return this.before - a.getAlignmentValue(c, size, gl.getLayoutMode());
        }

        protected final void include(GridLayout gl, View c, Spec spec, Axis axis, int size) {
            this.flexibility &= spec.getFlexibility();
            boolean horizontal = axis.horizontal;
            Alignment alignment = spec.getAbsoluteAlignment(axis.horizontal);
            int before = alignment.getAlignmentValue(c, size, gl.getLayoutMode());
            this.include(before, size - before);
        }

        public String toString() {
            return "Bounds{before=" + this.before + ", after=" + this.after + '}';
        }
    }

    static final class PackedMap<K, V> {
        public final int[] index;
        public final K[] keys;
        public final V[] values;

        private PackedMap(K[] keys, V[] values) {
            this.index = PackedMap.createIndex(keys);
            this.keys = PackedMap.compact(keys, this.index);
            this.values = PackedMap.compact(values, this.index);
        }

        public V getValue(int i) {
            return this.values[this.index[i]];
        }

        private static <K> int[] createIndex(K[] keys) {
            int size = keys.length;
            int[] result = new int[size];
            HashMap<K, Integer> keyToIndex = new HashMap<K, Integer>();
            for (int i = 0; i < size; ++i) {
                K key = keys[i];
                Integer index = (Integer)keyToIndex.get(key);
                if (index == null) {
                    index = keyToIndex.size();
                    keyToIndex.put(key, index);
                }
                result[i] = index;
            }
            return result;
        }

        private static <K> K[] compact(K[] a, int[] index) {
            int size = a.length;
            Class<?> componentType = a.getClass().getComponentType();
            Object[] result = (Object[])Array.newInstance(componentType, GridLayout.max2(index, -1) + 1);
            for (int i = 0; i < size; ++i) {
                result[index[i]] = a[i];
            }
            return result;
        }
    }

    static final class Assoc<K, V>
    extends ArrayList<Pair<K, V>> {
        private final Class<K> keyType;
        private final Class<V> valueType;

        private Assoc(Class<K> keyType, Class<V> valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public static <K, V> Assoc<K, V> of(Class<K> keyType, Class<V> valueType) {
            return new Assoc<K, V>(keyType, valueType);
        }

        public void put(K key, V value) {
            this.add(Pair.create(key, value));
        }

        public PackedMap<K, V> pack() {
            int N = this.size();
            Object[] keys = (Object[])Array.newInstance(this.keyType, N);
            Object[] values = (Object[])Array.newInstance(this.valueType, N);
            for (int i = 0; i < N; ++i) {
                keys[i] = ((Pair)this.get((int)i)).first;
                values[i] = ((Pair)this.get((int)i)).second;
            }
            return new PackedMap(keys, values);
        }
    }

    static final class MutableInt {
        public int value;

        public MutableInt() {
            this.reset();
        }

        public MutableInt(int value) {
            this.value = value;
        }

        public void reset() {
            this.value = Integer.MIN_VALUE;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    static final class Arc {
        public final Interval span;
        public final MutableInt value;
        public boolean valid = true;

        public Arc(Interval span, MutableInt value) {
            this.span = span;
            this.value = value;
        }

        public String toString() {
            return this.span + " " + (!this.valid ? "+>" : "->") + " " + this.value;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int DEFAULT_WIDTH = -2;
        private static final int DEFAULT_HEIGHT = -2;
        private static final int DEFAULT_MARGIN = Integer.MIN_VALUE;
        private static final int DEFAULT_ROW = Integer.MIN_VALUE;
        private static final int DEFAULT_COLUMN = Integer.MIN_VALUE;
        private static final Interval DEFAULT_SPAN = new Interval(Integer.MIN_VALUE, -2147483647);
        private static final int DEFAULT_SPAN_SIZE = DEFAULT_SPAN.size();
        private static final int MARGIN = 2;
        private static final int LEFT_MARGIN = 3;
        private static final int TOP_MARGIN = 4;
        private static final int RIGHT_MARGIN = 5;
        private static final int BOTTOM_MARGIN = 6;
        private static final int COLUMN = 1;
        private static final int COLUMN_SPAN = 4;
        private static final int COLUMN_WEIGHT = 6;
        private static final int ROW = 2;
        private static final int ROW_SPAN = 3;
        private static final int ROW_WEIGHT = 5;
        private static final int GRAVITY = 0;
        public Spec rowSpec = Spec.UNDEFINED;
        public Spec columnSpec = Spec.UNDEFINED;

        private LayoutParams(int width, int height, int left, int top, int right, int bottom, Spec rowSpec, Spec columnSpec) {
            super(width, height);
            this.setMargins(left, top, right, bottom);
            this.rowSpec = rowSpec;
            this.columnSpec = columnSpec;
        }

        public LayoutParams(Spec rowSpec, Spec columnSpec) {
            this(-2, -2, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, rowSpec, columnSpec);
        }

        public LayoutParams() {
            this(Spec.UNDEFINED, Spec.UNDEFINED);
        }

        public LayoutParams(ViewGroup.LayoutParams params) {
            super(params);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams params) {
            super(params);
        }

        public LayoutParams(LayoutParams source) {
            super(source);
            this.rowSpec = source.rowSpec;
            this.columnSpec = source.columnSpec;
        }

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            this.reInitSuper(context, attrs);
            this.init(context, attrs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reInitSuper(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ViewGroup_MarginLayout);
            try {
                int margin = a.getDimensionPixelSize(2, Integer.MIN_VALUE);
                this.leftMargin = a.getDimensionPixelSize(3, margin);
                this.topMargin = a.getDimensionPixelSize(4, margin);
                this.rightMargin = a.getDimensionPixelSize(5, margin);
                this.bottomMargin = a.getDimensionPixelSize(6, margin);
            }
            finally {
                a.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(Context context, AttributeSet attrs) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GridLayout_Layout);
            try {
                int gravity = a.getInt(0, 0);
                int column = a.getInt(1, Integer.MIN_VALUE);
                int colSpan = a.getInt(4, DEFAULT_SPAN_SIZE);
                float colWeight = a.getFloat(6, 0.0f);
                this.columnSpec = GridLayout.spec(column, colSpan, GridLayout.getAlignment(gravity, true), colWeight);
                int row = a.getInt(2, Integer.MIN_VALUE);
                int rowSpan = a.getInt(3, DEFAULT_SPAN_SIZE);
                float rowWeight = a.getFloat(5, 0.0f);
                this.rowSpec = GridLayout.spec(row, rowSpan, GridLayout.getAlignment(gravity, false), rowWeight);
            }
            finally {
                a.recycle();
            }
        }

        public void setGravity(int gravity) {
            this.rowSpec = this.rowSpec.copyWriteAlignment(GridLayout.getAlignment(gravity, false));
            this.columnSpec = this.columnSpec.copyWriteAlignment(GridLayout.getAlignment(gravity, true));
        }

        @Override
        protected void setBaseAttributes(TypedArray attributes, int widthAttr, int heightAttr) {
            this.width = attributes.getLayoutDimension(widthAttr, -2);
            this.height = attributes.getLayoutDimension(heightAttr, -2);
        }

        final void setRowSpecSpan(Interval span) {
            this.rowSpec = this.rowSpec.copyWriteSpan(span);
        }

        final void setColumnSpecSpan(Interval span) {
            this.columnSpec = this.columnSpec.copyWriteSpan(span);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LayoutParams that = (LayoutParams)o;
            if (!this.columnSpec.equals(that.columnSpec)) {
                return false;
            }
            return this.rowSpec.equals(that.rowSpec);
        }

        public int hashCode() {
            int result = this.rowSpec.hashCode();
            result = 31 * result + this.columnSpec.hashCode();
            return result;
        }
    }

    final class Axis {
        private static final int NEW = 0;
        private static final int PENDING = 1;
        private static final int COMPLETE = 2;
        public final boolean horizontal;
        public int definedCount = Integer.MIN_VALUE;
        private int maxIndex = Integer.MIN_VALUE;
        PackedMap<Spec, Bounds> groupBounds;
        public boolean groupBoundsValid = false;
        PackedMap<Interval, MutableInt> forwardLinks;
        public boolean forwardLinksValid = false;
        PackedMap<Interval, MutableInt> backwardLinks;
        public boolean backwardLinksValid = false;
        public int[] leadingMargins;
        public boolean leadingMarginsValid = false;
        public int[] trailingMargins;
        public boolean trailingMarginsValid = false;
        public Arc[] arcs;
        public boolean arcsValid = false;
        public int[] locations;
        public boolean locationsValid = false;
        public boolean hasWeights;
        public boolean hasWeightsValid = false;
        public int[] deltas;
        boolean orderPreserved = true;
        private MutableInt parentMin = new MutableInt(0);
        private MutableInt parentMax = new MutableInt(-100000);

        private Axis(boolean horizontal) {
            this.horizontal = horizontal;
        }

        private int calculateMaxIndex() {
            int result = -1;
            int N = GridLayout.this.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = GridLayout.this.getChildAt(i);
                LayoutParams params = GridLayout.this.getLayoutParams(c);
                Spec spec = this.horizontal ? params.columnSpec : params.rowSpec;
                Interval span = spec.span;
                result = Math.max(result, span.min);
                result = Math.max(result, span.max);
                result = Math.max(result, span.size());
            }
            return result == -1 ? Integer.MIN_VALUE : result;
        }

        private int getMaxIndex() {
            if (this.maxIndex == Integer.MIN_VALUE) {
                this.maxIndex = Math.max(0, this.calculateMaxIndex());
            }
            return this.maxIndex;
        }

        public int getCount() {
            return Math.max(this.definedCount, this.getMaxIndex());
        }

        public void setCount(int count) {
            if (count != Integer.MIN_VALUE && count < this.getMaxIndex()) {
                GridLayout.handleInvalidParams((this.horizontal ? "column" : "row") + "Count must be greater than or equal to the maximum of all grid indices " + "(and spans) defined in the LayoutParams of each child");
            }
            this.definedCount = count;
        }

        public boolean isOrderPreserved() {
            return this.orderPreserved;
        }

        public void setOrderPreserved(boolean orderPreserved) {
            this.orderPreserved = orderPreserved;
            this.invalidateStructure();
        }

        private PackedMap<Spec, Bounds> createGroupBounds() {
            Assoc<Spec, Bounds> assoc = Assoc.of(Spec.class, Bounds.class);
            int N = GridLayout.this.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = GridLayout.this.getChildAt(i);
                LayoutParams lp = GridLayout.this.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                Bounds bounds = spec.getAbsoluteAlignment(this.horizontal).getBounds();
                assoc.put(spec, bounds);
            }
            return assoc.pack();
        }

        private void computeGroupBounds() {
            int i;
            Bounds[] values = (Bounds[])this.groupBounds.values;
            for (i = 0; i < values.length; ++i) {
                values[i].reset();
            }
            int N = GridLayout.this.getChildCount();
            for (i = 0; i < N; ++i) {
                View c = GridLayout.this.getChildAt(i);
                LayoutParams lp = GridLayout.this.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                int size = GridLayout.this.getMeasurementIncludingMargin(c, this.horizontal) + (spec.weight == 0.0f ? 0 : this.getDeltas()[i]);
                this.groupBounds.getValue(i).include(GridLayout.this, c, spec, this, size);
            }
        }

        public PackedMap<Spec, Bounds> getGroupBounds() {
            if (this.groupBounds == null) {
                this.groupBounds = this.createGroupBounds();
            }
            if (!this.groupBoundsValid) {
                this.computeGroupBounds();
                this.groupBoundsValid = true;
            }
            return this.groupBounds;
        }

        private PackedMap<Interval, MutableInt> createLinks(boolean min) {
            Assoc<Interval, MutableInt> result = Assoc.of(Interval.class, MutableInt.class);
            Spec[] keys = (Spec[])this.getGroupBounds().keys;
            int N = keys.length;
            for (int i = 0; i < N; ++i) {
                Interval span = min ? keys[i].span : keys[i].span.inverse();
                result.put(span, new MutableInt());
            }
            return result.pack();
        }

        private void computeLinks(PackedMap<Interval, MutableInt> links, boolean min) {
            MutableInt[] spans = (MutableInt[])links.values;
            for (int i = 0; i < spans.length; ++i) {
                spans[i].reset();
            }
            Bounds[] bounds = (Bounds[])this.getGroupBounds().values;
            for (int i = 0; i < bounds.length; ++i) {
                int size = bounds[i].size(min);
                MutableInt valueHolder = links.getValue(i);
                valueHolder.value = Math.max(valueHolder.value, min ? size : -size);
            }
        }

        private PackedMap<Interval, MutableInt> getForwardLinks() {
            if (this.forwardLinks == null) {
                this.forwardLinks = this.createLinks(true);
            }
            if (!this.forwardLinksValid) {
                this.computeLinks(this.forwardLinks, true);
                this.forwardLinksValid = true;
            }
            return this.forwardLinks;
        }

        private PackedMap<Interval, MutableInt> getBackwardLinks() {
            if (this.backwardLinks == null) {
                this.backwardLinks = this.createLinks(false);
            }
            if (!this.backwardLinksValid) {
                this.computeLinks(this.backwardLinks, false);
                this.backwardLinksValid = true;
            }
            return this.backwardLinks;
        }

        private void include(List<Arc> arcs, Interval key, MutableInt size, boolean ignoreIfAlreadyPresent) {
            if (key.size() == 0) {
                return;
            }
            if (ignoreIfAlreadyPresent) {
                for (Arc arc : arcs) {
                    Interval span = arc.span;
                    if (!span.equals(key)) continue;
                    return;
                }
            }
            arcs.add(new Arc(key, size));
        }

        private void include(List<Arc> arcs, Interval key, MutableInt size) {
            this.include(arcs, key, size, true);
        }

        Arc[][] groupArcsByFirstVertex(Arc[] arcs) {
            int N = this.getCount() + 1;
            Arc[][] result = new Arc[N][];
            int[] sizes = new int[N];
            for (Arc arc : arcs) {
                int n = arc.span.min;
                sizes[n] = sizes[n] + 1;
            }
            for (int i = 0; i < sizes.length; ++i) {
                result[i] = new Arc[sizes[i]];
            }
            Arrays.fill(sizes, 0);
            for (Arc arc : arcs) {
                int i;
                int n = i = arc.span.min;
                int n2 = sizes[n];
                sizes[n] = n2 + 1;
                result[i][n2] = arc;
            }
            return result;
        }

        private Arc[] topologicalSort(final Arc[] arcs) {
            return new Object(){
                Arc[] result;
                int cursor;
                Arc[][] arcsByVertex;
                int[] visited;
                {
                    this.result = new Arc[arcs.length];
                    this.cursor = this.result.length - 1;
                    this.arcsByVertex = Axis.this.groupArcsByFirstVertex(arcs);
                    this.visited = new int[Axis.this.getCount() + 1];
                }

                void walk(int loc) {
                    switch (this.visited[loc]) {
                        case 0: {
                            this.visited[loc] = 1;
                            for (Arc arc : this.arcsByVertex[loc]) {
                                this.walk(arc.span.max);
                                this.result[this.cursor--] = arc;
                            }
                            this.visited[loc] = 2;
                            break;
                        }
                        case 1: {
                            assert (false);
                            break;
                        }
                    }
                }

                Arc[] sort() {
                    int N = this.arcsByVertex.length;
                    for (int loc = 0; loc < N; ++loc) {
                        this.walk(loc);
                    }
                    assert (this.cursor == -1);
                    return this.result;
                }
            }.sort();
        }

        private Arc[] topologicalSort(List<Arc> arcs) {
            return this.topologicalSort(arcs.toArray(new Arc[arcs.size()]));
        }

        private void addComponentSizes(List<Arc> result, PackedMap<Interval, MutableInt> links) {
            for (int i = 0; i < ((Interval[])links.keys).length; ++i) {
                Interval key = ((Interval[])links.keys)[i];
                this.include(result, key, ((MutableInt[])links.values)[i], false);
            }
        }

        private Arc[] createArcs() {
            ArrayList<Arc> mins = new ArrayList<Arc>();
            ArrayList<Arc> maxs = new ArrayList<Arc>();
            this.addComponentSizes(mins, this.getForwardLinks());
            this.addComponentSizes(maxs, this.getBackwardLinks());
            if (this.orderPreserved) {
                for (int i = 0; i < this.getCount(); ++i) {
                    this.include(mins, new Interval(i, i + 1), new MutableInt(0));
                }
            }
            int N = this.getCount();
            this.include(mins, new Interval(0, N), this.parentMin, false);
            this.include(maxs, new Interval(N, 0), this.parentMax, false);
            Arc[] sMins = this.topologicalSort(mins);
            Arc[] sMaxs = this.topologicalSort(maxs);
            return GridLayout.append(sMins, sMaxs);
        }

        private void computeArcs() {
            this.getForwardLinks();
            this.getBackwardLinks();
        }

        public Arc[] getArcs() {
            if (this.arcs == null) {
                this.arcs = this.createArcs();
            }
            if (!this.arcsValid) {
                this.computeArcs();
                this.arcsValid = true;
            }
            return this.arcs;
        }

        private boolean relax(int[] locations, Arc entry) {
            if (!entry.valid) {
                return false;
            }
            Interval span = entry.span;
            int u = span.min;
            int value = entry.value.value;
            int candidate = locations[u] + value;
            int v = span.max;
            if (candidate > locations[v]) {
                locations[v] = candidate;
                return true;
            }
            return false;
        }

        private void init(int[] locations) {
            Arrays.fill(locations, 0);
        }

        private String arcsToString(List<Arc> arcs) {
            String var = this.horizontal ? "x" : "y";
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Arc arc : arcs) {
                if (first) {
                    first = false;
                } else {
                    result = result.append(", ");
                }
                int src = arc.span.min;
                int dst = arc.span.max;
                int value = arc.value.value;
                result.append(src < dst ? var + dst + "-" + var + src + ">=" + value : var + src + "-" + var + dst + "<=" + -value);
            }
            return result.toString();
        }

        private void logError(String axisName, Arc[] arcs, boolean[] culprits0) {
            ArrayList<Arc> culprits = new ArrayList<Arc>();
            ArrayList<Arc> removed = new ArrayList<Arc>();
            for (int c = 0; c < arcs.length; ++c) {
                Arc arc = arcs[c];
                if (culprits0[c]) {
                    culprits.add(arc);
                }
                if (arc.valid) continue;
                removed.add(arc);
            }
            GridLayout.this.mPrinter.println(axisName + " constraints: " + this.arcsToString(culprits) + " are inconsistent; permanently removing: " + this.arcsToString(removed) + ". ");
        }

        private boolean solve(Arc[] arcs, int[] locations) {
            return this.solve(arcs, locations, true);
        }

        private boolean solve(Arc[] arcs, int[] locations, boolean modifyOnError) {
            String axisName = this.horizontal ? "horizontal" : "vertical";
            int N = this.getCount() + 1;
            boolean[] originalCulprits = null;
            block0: for (int p = 0; p < arcs.length; ++p) {
                int i;
                int j;
                int length;
                this.init(locations);
                for (int i2 = 0; i2 < N; ++i2) {
                    boolean changed = false;
                    length = arcs.length;
                    for (j = 0; j < length; ++j) {
                        changed |= this.relax(locations, arcs[j]);
                    }
                    if (changed) continue;
                    if (originalCulprits != null) {
                        this.logError(axisName, arcs, originalCulprits);
                    }
                    return true;
                }
                if (!modifyOnError) {
                    return false;
                }
                boolean[] culprits = new boolean[arcs.length];
                for (i = 0; i < N; ++i) {
                    length = arcs.length;
                    for (j = 0; j < length; ++j) {
                        int n = j;
                        culprits[n] = culprits[n] | this.relax(locations, arcs[j]);
                    }
                }
                if (p == 0) {
                    originalCulprits = culprits;
                }
                for (i = 0; i < arcs.length; ++i) {
                    if (!culprits[i]) continue;
                    Arc arc = arcs[i];
                    if (arc.span.min < arc.span.max) continue;
                    arc.valid = false;
                    continue block0;
                }
            }
            return true;
        }

        private void computeMargins(boolean leading) {
            int[] margins = leading ? this.leadingMargins : this.trailingMargins;
            int N = GridLayout.this.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = GridLayout.this.getChildAt(i);
                if (c.getVisibility() == 8) continue;
                LayoutParams lp = GridLayout.this.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                Interval span = spec.span;
                int index = leading ? span.min : span.max;
                margins[index] = Math.max(margins[index], GridLayout.this.getMargin1(c, this.horizontal, leading));
            }
        }

        public int[] getLeadingMargins() {
            if (this.leadingMargins == null) {
                this.leadingMargins = new int[this.getCount() + 1];
            }
            if (!this.leadingMarginsValid) {
                this.computeMargins(true);
                this.leadingMarginsValid = true;
            }
            return this.leadingMargins;
        }

        public int[] getTrailingMargins() {
            if (this.trailingMargins == null) {
                this.trailingMargins = new int[this.getCount() + 1];
            }
            if (!this.trailingMarginsValid) {
                this.computeMargins(false);
                this.trailingMarginsValid = true;
            }
            return this.trailingMargins;
        }

        private boolean solve(int[] a) {
            return this.solve(this.getArcs(), a);
        }

        private boolean computeHasWeights() {
            int N = GridLayout.this.getChildCount();
            for (int i = 0; i < N; ++i) {
                Spec spec;
                View child = GridLayout.this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                LayoutParams lp = GridLayout.this.getLayoutParams(child);
                Spec spec2 = spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                if (spec.weight == 0.0f) continue;
                return true;
            }
            return false;
        }

        private boolean hasWeights() {
            if (!this.hasWeightsValid) {
                this.hasWeights = this.computeHasWeights();
                this.hasWeightsValid = true;
            }
            return this.hasWeights;
        }

        public int[] getDeltas() {
            if (this.deltas == null) {
                this.deltas = new int[GridLayout.this.getChildCount()];
            }
            return this.deltas;
        }

        private void shareOutDelta(int totalDelta, float totalWeight) {
            Arrays.fill(this.deltas, 0);
            int N = GridLayout.this.getChildCount();
            for (int i = 0; i < N; ++i) {
                int delta;
                View c = GridLayout.this.getChildAt(i);
                if (c.getVisibility() == 8) continue;
                LayoutParams lp = GridLayout.this.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                float weight = spec.weight;
                if (weight == 0.0f) continue;
                this.deltas[i] = delta = Math.round(weight * (float)totalDelta / totalWeight);
                totalDelta -= delta;
                totalWeight -= weight;
            }
        }

        private void solveAndDistributeSpace(int[] a) {
            Arrays.fill(this.getDeltas(), 0);
            this.solve(a);
            int deltaMax = this.parentMin.value * GridLayout.this.getChildCount() + 1;
            if (deltaMax < 2) {
                return;
            }
            int deltaMin = 0;
            float totalWeight = this.calculateTotalWeight();
            int validDelta = -1;
            boolean validSolution = true;
            while (deltaMin < deltaMax) {
                int delta = (deltaMin + deltaMax) / 2;
                this.invalidateValues();
                this.shareOutDelta(delta, totalWeight);
                validSolution = this.solve(this.getArcs(), a, false);
                if (validSolution) {
                    validDelta = delta;
                    deltaMin = delta + 1;
                    continue;
                }
                deltaMax = delta;
            }
            if (validDelta > 0 && !validSolution) {
                this.invalidateValues();
                this.shareOutDelta(validDelta, totalWeight);
                this.solve(a);
            }
        }

        private float calculateTotalWeight() {
            float totalWeight = 0.0f;
            int N = GridLayout.this.getChildCount();
            for (int i = 0; i < N; ++i) {
                View c = GridLayout.this.getChildAt(i);
                if (c.getVisibility() == 8) continue;
                LayoutParams lp = GridLayout.this.getLayoutParams(c);
                Spec spec = this.horizontal ? lp.columnSpec : lp.rowSpec;
                totalWeight += spec.weight;
            }
            return totalWeight;
        }

        private void computeLocations(int[] a) {
            if (!this.hasWeights()) {
                this.solve(a);
            } else {
                this.solveAndDistributeSpace(a);
            }
            if (!this.orderPreserved) {
                int a0 = a[0];
                int N = a.length;
                for (int i = 0; i < N; ++i) {
                    a[i] = a[i] - a0;
                }
            }
        }

        public int[] getLocations() {
            if (this.locations == null) {
                int N = this.getCount() + 1;
                this.locations = new int[N];
            }
            if (!this.locationsValid) {
                this.computeLocations(this.locations);
                this.locationsValid = true;
            }
            return this.locations;
        }

        private int size(int[] locations) {
            return locations[this.getCount()];
        }

        private void setParentConstraints(int min, int max) {
            this.parentMin.value = min;
            this.parentMax.value = -max;
            this.locationsValid = false;
        }

        private int getMeasure(int min, int max) {
            this.setParentConstraints(min, max);
            return this.size(this.getLocations());
        }

        public int getMeasure(int measureSpec) {
            int mode = View.MeasureSpec.getMode(measureSpec);
            int size = View.MeasureSpec.getSize(measureSpec);
            switch (mode) {
                case 0: {
                    return this.getMeasure(0, 100000);
                }
                case 0x40000000: {
                    return this.getMeasure(size, size);
                }
                case -2147483648: {
                    return this.getMeasure(0, size);
                }
            }
            assert (false);
            return 0;
        }

        public void layout(int size) {
            this.setParentConstraints(size, size);
            this.getLocations();
        }

        public void invalidateStructure() {
            this.maxIndex = Integer.MIN_VALUE;
            this.groupBounds = null;
            this.forwardLinks = null;
            this.backwardLinks = null;
            this.leadingMargins = null;
            this.trailingMargins = null;
            this.arcs = null;
            this.locations = null;
            this.deltas = null;
            this.hasWeightsValid = false;
            this.invalidateValues();
        }

        public void invalidateValues() {
            this.groupBoundsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.leadingMarginsValid = false;
            this.trailingMarginsValid = false;
            this.arcsValid = false;
            this.locationsValid = false;
        }
    }
}

