/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.Log;
import android.util.MathUtils;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;

public class RadialTimePickerView
extends View {
    private static final String TAG = "RadialTimePickerView";
    private static final int HOURS = 0;
    private static final int MINUTES = 1;
    private static final int HOURS_INNER = 2;
    private static final int SELECTOR_CIRCLE = 0;
    private static final int SELECTOR_DOT = 1;
    private static final int SELECTOR_LINE = 2;
    private static final int AM = 0;
    private static final int PM = 1;
    private static final int ALPHA_OPAQUE = 255;
    private static final int ALPHA_TRANSPARENT = 0;
    private static final int HOURS_IN_CIRCLE = 12;
    private static final int MINUTES_IN_CIRCLE = 60;
    private static final int DEGREES_FOR_ONE_HOUR = 30;
    private static final int DEGREES_FOR_ONE_MINUTE = 6;
    private static final int[] HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
    private static final int FADE_OUT_DURATION = 500;
    private static final int FADE_IN_DURATION = 500;
    private static final int[] SNAP_PREFER_30S_MAP = new int[361];
    private static final int NUM_POSITIONS = 12;
    private static final float[] COS_30 = new float[12];
    private static final float[] SIN_30 = new float[12];
    private final InvalidateUpdateListener mInvalidateUpdateListener = new InvalidateUpdateListener();
    private final String[] mHours12Texts = new String[12];
    private final String[] mOuterHours24Texts = new String[12];
    private final String[] mInnerHours24Texts = new String[12];
    private final String[] mMinutesTexts = new String[12];
    private final Paint[] mPaint = new Paint[2];
    private final IntHolder[] mAlpha = new IntHolder[2];
    private final Paint mPaintCenter = new Paint();
    private final Paint[][] mPaintSelector = new Paint[2][3];
    private final int mSelectorColor;
    private final int mSelectorDotColor;
    private final Paint mPaintBackground = new Paint();
    private final Typeface mTypeface;
    private final ColorStateList[] mTextColor = new ColorStateList[3];
    private final int[] mTextSize = new int[3];
    private final int[] mTextInset = new int[3];
    private final float[][] mOuterTextX = new float[2][12];
    private final float[][] mOuterTextY = new float[2][12];
    private final float[] mInnerTextX = new float[12];
    private final float[] mInnerTextY = new float[12];
    private final int[] mSelectionDegrees = new int[2];
    private final ArrayList<Animator> mHoursToMinutesAnims = new ArrayList();
    private final ArrayList<Animator> mMinuteToHoursAnims = new ArrayList();
    private final RadialPickerTouchHelper mTouchHelper;
    private final Path mSelectorPath = new Path();
    private boolean mIs24HourMode;
    private boolean mShowHours;
    private boolean mIsOnInnerCircle;
    private int mSelectorRadius;
    private int mSelectorStroke;
    private int mSelectorDotRadius;
    private int mCenterDotRadius;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;
    private int mMinDistForInnerNumber;
    private int mMaxDistForOuterNumber;
    private int mHalfwayDist;
    private String[] mOuterTextHours;
    private String[] mInnerTextHours;
    private String[] mMinutesText;
    private AnimatorSet mTransition;
    private int mAmOrPm;
    private float mDisabledAlpha;
    private OnValueSelectedListener mListener;
    private boolean mInputEnabled = true;
    boolean mChangedDuringTouch = false;

    private static void preparePrefer30sMap() {
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            RadialTimePickerView.SNAP_PREFER_30S_MAP[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private static int snapPrefer30s(int degrees) {
        if (SNAP_PREFER_30S_MAP == null) {
            return -1;
        }
        return SNAP_PREFER_30S_MAP[degrees];
    }

    private static int snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / 30 * 30;
        int ceiling = floor + 30;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= 30;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    public RadialTimePickerView(Context context) {
        this(context, null);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843933);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RadialTimePickerView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs);
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        this.mDisabledAlpha = outValue.getFloat();
        Resources res = this.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        this.mTypeface = Typeface.create("sans-serif", 0);
        for (int i = 0; i < this.mAlpha.length; ++i) {
            this.mAlpha[i] = new IntHolder(255);
        }
        this.mTextColor[0] = a.getColorStateList(3);
        this.mTextColor[2] = a.getColorStateList(9);
        this.mTextColor[1] = this.mTextColor[0];
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        ColorStateList selectorColors = a.getColorStateList(5);
        int selectorActivatedColor = selectorColors.getColorForState(StateSet.get(40), 0);
        this.mPaintCenter.setColor(selectorActivatedColor);
        this.mPaintCenter.setAntiAlias(true);
        int[] activatedStateSet = StateSet.get(40);
        this.mSelectorColor = selectorActivatedColor;
        this.mSelectorDotColor = this.mTextColor[0].getColorForState(activatedStateSet, 0);
        this.mPaintSelector[0][0] = new Paint();
        this.mPaintSelector[0][0].setAntiAlias(true);
        this.mPaintSelector[0][1] = new Paint();
        this.mPaintSelector[0][1].setAntiAlias(true);
        this.mPaintSelector[0][2] = new Paint();
        this.mPaintSelector[0][2].setAntiAlias(true);
        this.mPaintSelector[0][2].setStrokeWidth(2.0f);
        this.mPaintSelector[1][0] = new Paint();
        this.mPaintSelector[1][0].setAntiAlias(true);
        this.mPaintSelector[1][1] = new Paint();
        this.mPaintSelector[1][1].setAntiAlias(true);
        this.mPaintSelector[1][2] = new Paint();
        this.mPaintSelector[1][2].setAntiAlias(true);
        this.mPaintSelector[1][2].setStrokeWidth(2.0f);
        this.mPaintBackground.setColor(a.getColor(4, context.getColor(17170652)));
        this.mPaintBackground.setAntiAlias(true);
        this.mSelectorRadius = res.getDimensionPixelSize(17105167);
        this.mSelectorStroke = res.getDimensionPixelSize(0x1050110);
        this.mSelectorDotRadius = res.getDimensionPixelSize(17105170);
        this.mCenterDotRadius = res.getDimensionPixelSize(0x1050111);
        this.mTextSize[0] = res.getDimensionPixelSize(17105172);
        this.mTextSize[1] = res.getDimensionPixelSize(17105172);
        this.mTextSize[2] = res.getDimensionPixelSize(0x1050115);
        this.mTextInset[0] = res.getDimensionPixelSize(17105171);
        this.mTextInset[1] = res.getDimensionPixelSize(17105171);
        this.mTextInset[2] = res.getDimensionPixelSize(17105065);
        this.mShowHours = true;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mTouchHelper = new RadialPickerTouchHelper();
        this.setAccessibilityDelegate(this.mTouchHelper);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.initHoursAndMinutesText();
        this.initData();
        a.recycle();
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.setCurrentHourInternal(currentHour, false, false);
        this.setCurrentMinuteInternal(currentMinute, false);
        this.setHapticFeedbackEnabled(true);
    }

    public void initialize(int hour, int minute, boolean is24HourMode) {
        if (this.mIs24HourMode != is24HourMode) {
            this.mIs24HourMode = is24HourMode;
            this.initData();
        }
        this.setCurrentHourInternal(hour, false, false);
        this.setCurrentMinuteInternal(minute, false);
    }

    public void setCurrentItemShowing(int item, boolean animate) {
        switch (item) {
            case 0: {
                this.showHours(animate);
                break;
            }
            case 1: {
                this.showMinutes(animate);
                break;
            }
            default: {
                Log.e(TAG, "ClockView does not support showing item " + item);
            }
        }
    }

    public int getCurrentItemShowing() {
        return this.mShowHours ? 0 : 1;
    }

    public void setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    public void setCurrentHour(int hour) {
        this.setCurrentHourInternal(hour, true, false);
    }

    private void setCurrentHourInternal(int hour, boolean callback, boolean autoAdvance) {
        int degrees;
        this.mSelectionDegrees[0] = degrees = hour % 12 * 30;
        int amOrPm = hour == 0 || hour % 24 < 12 ? 0 : 1;
        boolean isOnInnerCircle = this.getInnerCircleForHour(hour);
        if (this.mAmOrPm != amOrPm || this.mIsOnInnerCircle != isOnInnerCircle) {
            this.mAmOrPm = amOrPm;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.initData();
            this.mTouchHelper.invalidateRoot();
        }
        this.invalidate();
        if (callback && this.mListener != null) {
            this.mListener.onValueSelected(0, hour, autoAdvance);
        }
    }

    public int getCurrentHour() {
        return this.getHourForDegrees(this.mSelectionDegrees[0], this.mIsOnInnerCircle);
    }

    private int getHourForDegrees(int degrees, boolean innerCircle) {
        int hour = degrees / 30 % 12;
        if (this.mIs24HourMode) {
            if (!innerCircle && hour == 0) {
                hour = 12;
            } else if (innerCircle && hour != 0) {
                hour += 12;
            }
        } else if (this.mAmOrPm == 1) {
            hour += 12;
        }
        return hour;
    }

    private int getDegreesForHour(int hour) {
        if (this.mIs24HourMode) {
            if (hour >= 12) {
                hour -= 12;
            }
        } else if (hour == 12) {
            hour = 0;
        }
        return hour * 30;
    }

    private boolean getInnerCircleForHour(int hour) {
        return this.mIs24HourMode && (hour == 0 || hour > 12);
    }

    public void setCurrentMinute(int minute) {
        this.setCurrentMinuteInternal(minute, true);
    }

    private void setCurrentMinuteInternal(int minute, boolean callback) {
        this.mSelectionDegrees[1] = minute % 60 * 6;
        this.invalidate();
        if (callback && this.mListener != null) {
            this.mListener.onValueSelected(1, minute, false);
        }
    }

    public int getCurrentMinute() {
        return this.getMinuteForDegrees(this.mSelectionDegrees[1]);
    }

    private int getMinuteForDegrees(int degrees) {
        return degrees / 6;
    }

    private int getDegreesForMinute(int minute) {
        return minute * 6;
    }

    public void setAmOrPm(int val) {
        this.mAmOrPm = val % 2;
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
    }

    public int getAmOrPm() {
        return this.mAmOrPm;
    }

    public void showHours(boolean animate) {
        if (this.mShowHours) {
            return;
        }
        this.mShowHours = true;
        if (animate) {
            this.startMinutesToHoursAnimation();
        }
        this.initData();
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
    }

    public void showMinutes(boolean animate) {
        if (!this.mShowHours) {
            return;
        }
        this.mShowHours = false;
        if (animate) {
            this.startHoursToMinutesAnimation();
        }
        this.initData();
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
    }

    private void initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            this.mHours12Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mInnerHours24Texts[i] = String.format("%02d", HOURS_NUMBERS_24[i]);
            this.mOuterHours24Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mMinutesTexts[i] = String.format("%02d", MINUTES_NUMBERS[i]);
        }
    }

    private void initData() {
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = this.mHours12Texts;
        }
        this.mMinutesText = this.mMinutesTexts;
        int hoursAlpha = this.mShowHours ? 255 : 0;
        this.mAlpha[0].setValue(hoursAlpha);
        int minutesAlpha = this.mShowHours ? 0 : 255;
        this.mAlpha[1].setValue(minutesAlpha);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        this.mCircleRadius = Math.min(this.mXCenter, this.mYCenter);
        this.mMinDistForInnerNumber = this.mCircleRadius - this.mTextInset[2] - this.mSelectorRadius;
        this.mMaxDistForOuterNumber = this.mCircleRadius - this.mTextInset[0] + this.mSelectorRadius;
        this.mHalfwayDist = this.mCircleRadius - (this.mTextInset[0] + this.mTextInset[2]) / 2;
        this.calculatePositionsHours();
        this.calculatePositionsMinutes();
        this.mTouchHelper.invalidateRoot();
    }

    @Override
    public void onDraw(Canvas canvas) {
        float alphaMod = this.mInputEnabled ? 1.0f : this.mDisabledAlpha;
        this.drawCircleBackground(canvas);
        this.drawHours(canvas, alphaMod);
        this.drawMinutes(canvas, alphaMod);
        this.drawCenter(canvas, alphaMod);
    }

    private void drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius, this.mPaintBackground);
    }

    private void drawHours(Canvas canvas, float alphaMod) {
        int hoursAlpha = (int)((float)this.mAlpha[0].getValue() * alphaMod + 0.5f);
        if (hoursAlpha > 0) {
            this.drawSelector(canvas, this.mIsOnInnerCircle ? 2 : 0, null, alphaMod);
            this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mTextColor[0], this.mOuterTextHours, this.mOuterTextX[0], this.mOuterTextY[0], this.mPaint[0], hoursAlpha, !this.mIsOnInnerCircle, this.mSelectionDegrees[0], false);
            if (this.mIs24HourMode && this.mInnerTextHours != null) {
                this.drawTextElements(canvas, this.mTextSize[2], this.mTypeface, this.mTextColor[2], this.mInnerTextHours, this.mInnerTextX, this.mInnerTextY, this.mPaint[0], hoursAlpha, this.mIsOnInnerCircle, this.mSelectionDegrees[0], false);
            }
        }
    }

    private void drawMinutes(Canvas canvas, float alphaMod) {
        int minutesAlpha = (int)((float)this.mAlpha[1].getValue() * alphaMod + 0.5f);
        if (minutesAlpha > 0) {
            this.drawSelector(canvas, 1, this.mSelectorPath, alphaMod);
            canvas.save(2);
            canvas.clipPath(this.mSelectorPath, Region.Op.DIFFERENCE);
            this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mTextColor[1], this.mMinutesText, this.mOuterTextX[1], this.mOuterTextY[1], this.mPaint[1], minutesAlpha, false, 0, false);
            canvas.restore();
            canvas.save(2);
            canvas.clipPath(this.mSelectorPath, Region.Op.INTERSECT);
            this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mTextColor[1], this.mMinutesText, this.mOuterTextX[1], this.mOuterTextY[1], this.mPaint[1], minutesAlpha, true, this.mSelectionDegrees[1], true);
            canvas.restore();
        }
    }

    private void drawCenter(Canvas canvas, float alphaMod) {
        this.mPaintCenter.setAlpha((int)(255.0f * alphaMod + 0.5f));
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCenterDotRadius, this.mPaintCenter);
    }

    private int applyAlpha(int argb, int alpha) {
        int srcAlpha = argb >> 24 & 0xFF;
        int dstAlpha = (int)((double)srcAlpha * ((double)alpha / 255.0) + 0.5);
        return 0xFFFFFF & argb | dstAlpha << 24;
    }

    private int getMultipliedAlpha(int argb, int alpha) {
        return (int)((double)Color.alpha(argb) * ((double)alpha / 255.0) + 0.5);
    }

    private void drawSelector(Canvas canvas, int index, Path selectorPath, float alphaMod) {
        boolean shouldDrawDot;
        int alpha = (int)((float)this.mAlpha[index % 2].getValue() * alphaMod + 0.5f);
        int color2 = this.applyAlpha(this.mSelectorColor, alpha);
        int selRadius = this.mSelectorRadius;
        int selLength = this.mCircleRadius - this.mTextInset[index];
        double selAngleRad = Math.toRadians(this.mSelectionDegrees[index % 2]);
        float selCenterX = (float)this.mXCenter + (float)selLength * (float)Math.sin(selAngleRad);
        float selCenterY = (float)this.mYCenter - (float)selLength * (float)Math.cos(selAngleRad);
        Paint paint = this.mPaintSelector[index % 2][0];
        paint.setColor(color2);
        canvas.drawCircle(selCenterX, selCenterY, selRadius, paint);
        if (selectorPath != null) {
            selectorPath.reset();
            selectorPath.addCircle(selCenterX, selCenterY, selRadius, Path.Direction.CCW);
        }
        boolean bl = shouldDrawDot = this.mSelectionDegrees[index % 2] % 30 != 0;
        if (shouldDrawDot) {
            Paint dotPaint = this.mPaintSelector[index % 2][1];
            dotPaint.setColor(this.mSelectorDotColor);
            canvas.drawCircle(selCenterX, selCenterY, this.mSelectorDotRadius, dotPaint);
        }
        double sin = Math.sin(selAngleRad);
        double cos = Math.cos(selAngleRad);
        int lineLength = selLength - selRadius;
        int centerX = this.mXCenter + (int)((double)this.mCenterDotRadius * sin);
        int centerY = this.mYCenter - (int)((double)this.mCenterDotRadius * cos);
        float linePointX = centerX + (int)((double)lineLength * sin);
        float linePointY = centerY - (int)((double)lineLength * cos);
        Paint linePaint = this.mPaintSelector[index % 2][2];
        linePaint.setColor(color2);
        linePaint.setStrokeWidth(this.mSelectorStroke);
        canvas.drawLine(this.mXCenter, this.mYCenter, linePointX, linePointY, linePaint);
    }

    private void calculatePositionsHours() {
        float numbersRadius = this.mCircleRadius - this.mTextInset[0];
        RadialTimePickerView.calculatePositions(this.mPaint[0], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mOuterTextX[0], this.mOuterTextY[0]);
        if (this.mIs24HourMode) {
            int innerNumbersRadius = this.mCircleRadius - this.mTextInset[2];
            RadialTimePickerView.calculatePositions(this.mPaint[0], innerNumbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[2], this.mInnerTextX, this.mInnerTextY);
        }
    }

    private void calculatePositionsMinutes() {
        float numbersRadius = this.mCircleRadius - this.mTextInset[1];
        RadialTimePickerView.calculatePositions(this.mPaint[1], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mOuterTextX[1], this.mOuterTextY[1]);
    }

    private static void calculatePositions(Paint paint, float radius, float xCenter, float yCenter, float textSize, float[] x, float[] y) {
        paint.setTextSize(textSize);
        yCenter -= (paint.descent() + paint.ascent()) / 2.0f;
        for (int i = 0; i < 12; ++i) {
            x[i] = xCenter - radius * COS_30[i];
            y[i] = yCenter - radius * SIN_30[i];
        }
    }

    private void drawTextElements(Canvas canvas, float textSize, Typeface typeface, ColorStateList textColor, String[] texts, float[] textX, float[] textY, Paint paint, int alpha, boolean showActivated, int activatedDegrees, boolean activatedOnly) {
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        float activatedIndex = (float)activatedDegrees / 30.0f;
        int activatedFloor = (int)activatedIndex;
        int activatedCeil = (int)Math.ceil(activatedIndex) % 12;
        for (int i = 0; i < 12; ++i) {
            boolean activated;
            boolean bl = activated = activatedFloor == i || activatedCeil == i;
            if (activatedOnly && !activated) continue;
            int stateMask = 8 | (showActivated && activated ? 32 : 0);
            int color2 = textColor.getColorForState(StateSet.get(stateMask), 0);
            paint.setColor(color2);
            paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
            canvas.drawText(texts[i], textX[i], textY[i], paint);
        }
    }

    private static ObjectAnimator getFadeOutAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        ObjectAnimator animator2 = ObjectAnimator.ofInt((Object)target, "value", startAlpha, endAlpha);
        animator2.setDuration(500L);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static ObjectAnimator getFadeInAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = 1.25f;
        int totalDuration = 625;
        float delayPoint = 0.2f;
        Keyframe kf0 = Keyframe.ofInt(0.0f, startAlpha);
        Keyframe kf1 = Keyframe.ofInt(0.2f, startAlpha);
        Keyframe kf2 = Keyframe.ofInt(1.0f, endAlpha);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe("value", kf0, kf1, kf2);
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, fadeIn);
        animator2.setDuration(625L);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private void startHoursToMinutesAnimation() {
        if (this.mHoursToMinutesAnims.size() == 0) {
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[0], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[1], 0, 255, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mHoursToMinutesAnims);
        this.mTransition.start();
    }

    private void startMinutesToHoursAnimation() {
        if (this.mMinuteToHoursAnims.size() == 0) {
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[0], 0, 255, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mMinuteToHoursAnims);
        this.mTransition.start();
    }

    private int getDegreesFromXY(float x, float y, boolean constrainOutside) {
        int outerBound;
        int innerBound;
        if (this.mIs24HourMode && this.mShowHours) {
            innerBound = this.mMinDistForInnerNumber;
            outerBound = this.mMaxDistForOuterNumber;
        } else {
            int index = this.mShowHours ? 0 : 1;
            int center = this.mCircleRadius - this.mTextInset[index];
            innerBound = center - this.mSelectorRadius;
            outerBound = center + this.mSelectorRadius;
        }
        double dX = x - (float)this.mXCenter;
        double dY = y - (float)this.mYCenter;
        double distFromCenter = Math.sqrt(dX * dX + dY * dY);
        if (distFromCenter < (double)innerBound || constrainOutside && distFromCenter > (double)outerBound) {
            return -1;
        }
        int degrees = (int)(Math.toDegrees(Math.atan2(dY, dX) + 1.5707963267948966) + 0.5);
        if (degrees < 0) {
            return degrees + 360;
        }
        return degrees;
    }

    private boolean getInnerCircleFromXY(float x, float y) {
        if (this.mIs24HourMode && this.mShowHours) {
            double dX = x - (float)this.mXCenter;
            double dY = y - (float)this.mYCenter;
            double distFromCenter = Math.sqrt(dX * dX + dY * dY);
            return distFromCenter <= (double)this.mHalfwayDist;
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mInputEnabled) {
            return true;
        }
        int action = event.getActionMasked();
        if (action == 2 || action == 1 || action == 0) {
            boolean forceSelection = false;
            boolean autoAdvance = false;
            if (action == 0) {
                this.mChangedDuringTouch = false;
            } else if (action == 1) {
                autoAdvance = true;
                if (!this.mChangedDuringTouch) {
                    forceSelection = true;
                }
            }
            this.mChangedDuringTouch |= this.handleTouchInput(event.getX(), event.getY(), forceSelection, autoAdvance);
        }
        return true;
    }

    private boolean handleTouchInput(float x, float y, boolean forceSelection, boolean autoAdvance) {
        int newValue;
        int type;
        boolean valueChanged;
        boolean isOnInnerCircle = this.getInnerCircleFromXY(x, y);
        int degrees = this.getDegreesFromXY(x, y, false);
        if (degrees == -1) {
            return false;
        }
        if (this.mShowHours) {
            int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
            valueChanged = this.mIsOnInnerCircle != isOnInnerCircle || this.mSelectionDegrees[0] != snapDegrees;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.mSelectionDegrees[0] = snapDegrees;
            type = 0;
            newValue = this.getCurrentHour();
        } else {
            int snapDegrees = RadialTimePickerView.snapPrefer30s(degrees) % 360;
            valueChanged = this.mSelectionDegrees[1] != snapDegrees;
            this.mSelectionDegrees[1] = snapDegrees;
            type = 1;
            newValue = this.getCurrentMinute();
        }
        if (valueChanged || forceSelection || autoAdvance) {
            if (this.mListener != null) {
                this.mListener.onValueSelected(type, newValue, autoAdvance);
            }
            if (valueChanged || forceSelection) {
                this.performHapticFeedback(4);
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent event) {
        if (this.mTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    public void setInputEnabled(boolean inputEnabled) {
        this.mInputEnabled = inputEnabled;
        this.invalidate();
    }

    static {
        RadialTimePickerView.preparePrefer30sMap();
        double increment = 0.5235987755982988;
        double angle = 1.5707963267948966;
        for (int i = 0; i < 12; ++i) {
            RadialTimePickerView.COS_30[i] = (float)Math.cos(angle);
            RadialTimePickerView.SIN_30[i] = (float)Math.sin(angle);
            angle += 0.5235987755982988;
        }
    }

    private static class IntHolder {
        private int mValue;

        public IntHolder(int value) {
            this.mValue = value;
        }

        public void setValue(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }

    private class RadialPickerTouchHelper
    extends ExploreByTouchHelper {
        private final Rect mTempRect;
        private final int TYPE_HOUR = 1;
        private final int TYPE_MINUTE = 2;
        private final int SHIFT_TYPE = 0;
        private final int MASK_TYPE = 15;
        private final int SHIFT_VALUE = 8;
        private final int MASK_VALUE = 255;
        private final int MINUTE_INCREMENT = 5;

        public RadialPickerTouchHelper() {
            super(RadialTimePickerView.this);
            this.mTempRect = new Rect();
            this.TYPE_HOUR = 1;
            this.TYPE_MINUTE = 2;
            this.SHIFT_TYPE = 0;
            this.MASK_TYPE = 15;
            this.SHIFT_VALUE = 8;
            this.MASK_VALUE = 255;
            this.MINUTE_INCREMENT = 5;
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        }

        @Override
        public boolean performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            switch (action) {
                case 4096: {
                    this.adjustPicker(1);
                    return true;
                }
                case 8192: {
                    this.adjustPicker(-1);
                    return true;
                }
            }
            return false;
        }

        private void adjustPicker(int step) {
            int maxValue;
            int minValue;
            int initialStep;
            int stepSize;
            if (RadialTimePickerView.this.mShowHours) {
                stepSize = 1;
                int currentHour24 = RadialTimePickerView.this.getCurrentHour();
                if (RadialTimePickerView.this.mIs24HourMode) {
                    initialStep = currentHour24;
                    minValue = 0;
                    maxValue = 23;
                } else {
                    initialStep = this.hour24To12(currentHour24);
                    minValue = 1;
                    maxValue = 12;
                }
            } else {
                stepSize = 5;
                initialStep = RadialTimePickerView.this.getCurrentMinute() / stepSize;
                minValue = 0;
                maxValue = 55;
            }
            int nextValue = (initialStep + step) * stepSize;
            int clampedValue = MathUtils.constrain(nextValue, minValue, maxValue);
            if (RadialTimePickerView.this.mShowHours) {
                RadialTimePickerView.this.setCurrentHour(clampedValue);
            } else {
                RadialTimePickerView.this.setCurrentMinute(clampedValue);
            }
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            int id2;
            int degrees = RadialTimePickerView.this.getDegreesFromXY(x, y, true);
            if (degrees != -1) {
                int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
                if (RadialTimePickerView.this.mShowHours) {
                    boolean isOnInnerCircle = RadialTimePickerView.this.getInnerCircleFromXY(x, y);
                    int hour24 = RadialTimePickerView.this.getHourForDegrees(snapDegrees, isOnInnerCircle);
                    int hour = RadialTimePickerView.this.mIs24HourMode ? hour24 : this.hour24To12(hour24);
                    id2 = this.makeId(1, hour);
                } else {
                    int snappedOffset;
                    int current = RadialTimePickerView.this.getCurrentMinute();
                    int touched = RadialTimePickerView.this.getMinuteForDegrees(degrees);
                    int snapped = RadialTimePickerView.this.getMinuteForDegrees(snapDegrees);
                    int currentOffset = this.getCircularDiff(current, touched, 60);
                    int minute = currentOffset < (snappedOffset = this.getCircularDiff(snapped, touched, 60)) ? current : snapped;
                    id2 = this.makeId(2, minute);
                }
            } else {
                id2 = Integer.MIN_VALUE;
            }
            return id2;
        }

        private int getCircularDiff(int first, int second, int max) {
            int midpoint;
            int diff = Math.abs(first - second);
            return diff > (midpoint = max / 2) ? max - diff : diff;
        }

        @Override
        protected void getVisibleVirtualViews(IntArray virtualViewIds) {
            if (RadialTimePickerView.this.mShowHours) {
                int min = RadialTimePickerView.this.mIs24HourMode ? 0 : 1;
                int max = RadialTimePickerView.this.mIs24HourMode ? 23 : 12;
                for (int i = min; i <= max; ++i) {
                    virtualViewIds.add(this.makeId(1, i));
                }
            } else {
                int current = RadialTimePickerView.this.getCurrentMinute();
                for (int i = 0; i < 60; i += 5) {
                    virtualViewIds.add(this.makeId(2, i));
                    if (current <= i || current >= i + 5) continue;
                    virtualViewIds.add(this.makeId(2, current));
                }
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setClassName(this.getClass().getName());
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value);
            event.setContentDescription(description);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            node.setClassName(this.getClass().getName());
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value);
            node.setContentDescription(description);
            this.getBoundsForVirtualView(virtualViewId, this.mTempRect);
            node.setBoundsInParent(this.mTempRect);
            boolean selected = this.isVirtualViewSelected(type, value);
            node.setSelected(selected);
            int nextId = this.getVirtualViewIdAfter(type, value);
            if (nextId != Integer.MIN_VALUE) {
                node.setTraversalBefore(RadialTimePickerView.this, nextId);
            }
        }

        private int getVirtualViewIdAfter(int type, int value) {
            if (type == 1) {
                int max;
                int nextValue = value + 1;
                int n = max = RadialTimePickerView.this.mIs24HourMode ? 23 : 12;
                if (nextValue <= max) {
                    return this.makeId(type, nextValue);
                }
            } else if (type == 2) {
                int current = RadialTimePickerView.this.getCurrentMinute();
                int snapValue = value - value % 5;
                int nextValue = snapValue + 5;
                if (value < current && nextValue > current) {
                    return this.makeId(type, current);
                }
                if (nextValue < 60) {
                    return this.makeId(type, nextValue);
                }
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            if (action == 16) {
                int type = this.getTypeFromId(virtualViewId);
                int value = this.getValueFromId(virtualViewId);
                if (type == 1) {
                    int hour = RadialTimePickerView.this.mIs24HourMode ? value : this.hour12To24(value, RadialTimePickerView.this.mAmOrPm);
                    RadialTimePickerView.this.setCurrentHour(hour);
                    return true;
                }
                if (type == 2) {
                    RadialTimePickerView.this.setCurrentMinute(value);
                    return true;
                }
            }
            return false;
        }

        private int hour12To24(int hour12, int amOrPm) {
            int hour24 = hour12;
            if (hour12 == 12) {
                if (amOrPm == 0) {
                    hour24 = 0;
                }
            } else if (amOrPm == 1) {
                hour24 += 12;
            }
            return hour24;
        }

        private int hour24To12(int hour24) {
            if (hour24 == 0) {
                return 12;
            }
            if (hour24 > 12) {
                return hour24 - 12;
            }
            return hour24;
        }

        private void getBoundsForVirtualView(int virtualViewId, Rect bounds) {
            float degrees;
            float radius;
            float centerRadius;
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            if (type == 1) {
                boolean innerCircle = RadialTimePickerView.this.getInnerCircleForHour(value);
                if (innerCircle) {
                    centerRadius = RadialTimePickerView.this.mCircleRadius - RadialTimePickerView.this.mTextInset[2];
                    radius = RadialTimePickerView.this.mSelectorRadius;
                } else {
                    centerRadius = RadialTimePickerView.this.mCircleRadius - RadialTimePickerView.this.mTextInset[0];
                    radius = RadialTimePickerView.this.mSelectorRadius;
                }
                degrees = RadialTimePickerView.this.getDegreesForHour(value);
            } else if (type == 2) {
                centerRadius = RadialTimePickerView.this.mCircleRadius - RadialTimePickerView.this.mTextInset[1];
                degrees = RadialTimePickerView.this.getDegreesForMinute(value);
                radius = RadialTimePickerView.this.mSelectorRadius;
            } else {
                centerRadius = 0.0f;
                degrees = 0.0f;
                radius = 0.0f;
            }
            double radians = Math.toRadians(degrees);
            float xCenter = (float)RadialTimePickerView.this.mXCenter + centerRadius * (float)Math.sin(radians);
            float yCenter = (float)RadialTimePickerView.this.mYCenter - centerRadius * (float)Math.cos(radians);
            bounds.set((int)(xCenter - radius), (int)(yCenter - radius), (int)(xCenter + radius), (int)(yCenter + radius));
        }

        private CharSequence getVirtualViewDescription(int type, int value) {
            String description = type == 1 || type == 2 ? Integer.toString(value) : null;
            return description;
        }

        private boolean isVirtualViewSelected(int type, int value) {
            boolean selected = type == 1 ? RadialTimePickerView.this.getCurrentHour() == value : (type == 2 ? RadialTimePickerView.this.getCurrentMinute() == value : false);
            return selected;
        }

        private int makeId(int type, int value) {
            return type << 0 | value << 8;
        }

        private int getTypeFromId(int id2) {
            return id2 >>> 0 & 0xF;
        }

        private int getValueFromId(int id2) {
            return id2 >>> 8 & 0xFF;
        }
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        private InvalidateUpdateListener() {
        }

        @Override
        public void onAnimationUpdate(ValueAnimator animation) {
            RadialTimePickerView.this.invalidate();
        }
    }

    public static interface OnValueSelectedListener {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

