/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.MathUtils;
import android.util.StateSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

class SimpleMonthView
extends View {
    private static final int DAYS_IN_WEEK = 7;
    private static final int MAX_WEEKS_IN_MONTH = 6;
    private static final int DEFAULT_SELECTED_DAY = -1;
    private static final int DEFAULT_WEEK_START = 1;
    private static final String DEFAULT_TITLE_FORMAT = "MMMMy";
    private static final String DAY_OF_WEEK_FORMAT = "EEEEE";
    private final TextPaint mMonthPaint = new TextPaint();
    private final TextPaint mDayOfWeekPaint = new TextPaint();
    private final TextPaint mDayPaint = new TextPaint();
    private final Paint mDaySelectorPaint = new Paint();
    private final Paint mDayHighlightPaint = new Paint();
    private final Calendar mCalendar = Calendar.getInstance();
    private final Calendar mDayOfWeekLabelCalendar = Calendar.getInstance();
    private final MonthViewTouchHelper mTouchHelper;
    private final SimpleDateFormat mTitleFormatter;
    private final SimpleDateFormat mDayOfWeekFormatter;
    private final NumberFormat mDayFormatter;
    private final int mDesiredMonthHeight;
    private final int mDesiredDayOfWeekHeight;
    private final int mDesiredDayHeight;
    private final int mDesiredCellWidth;
    private final int mDesiredDaySelectorRadius;
    private CharSequence mTitle;
    private int mMonth;
    private int mYear;
    private int mMonthHeight;
    private int mDayOfWeekHeight;
    private int mDayHeight;
    private int mCellWidth;
    private int mDaySelectorRadius;
    private int mPaddedWidth;
    private int mPaddedHeight;
    private int mActivatedDay = -1;
    private int mToday = -1;
    private int mWeekStart = 1;
    private int mDaysInMonth;
    private int mDayOfWeekStart;
    private int mEnabledDayStart = 1;
    private int mEnabledDayEnd = 31;
    private OnDayClickListener mOnDayClickListener;
    private ColorStateList mDayTextColor;
    private int mTouchedItem = -1;

    public SimpleMonthView(Context context) {
        this(context, null);
    }

    public SimpleMonthView(Context context, AttributeSet attrs) {
        this(context, attrs, 16843612);
    }

    public SimpleMonthView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public SimpleMonthView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = context.getResources();
        this.mDesiredMonthHeight = res.getDimensionPixelSize(17105189);
        this.mDesiredDayOfWeekHeight = res.getDimensionPixelSize(17105190);
        this.mDesiredDayHeight = res.getDimensionPixelSize(17105191);
        this.mDesiredCellWidth = res.getDimensionPixelSize(17105192);
        this.mDesiredDaySelectorRadius = res.getDimensionPixelSize(17105193);
        this.mTouchHelper = new MonthViewTouchHelper(this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        this.setImportantForAccessibility(1);
        Locale locale = res.getConfiguration().locale;
        String titleFormat = DateFormat.getBestDateTimePattern(locale, DEFAULT_TITLE_FORMAT);
        this.mTitleFormatter = new SimpleDateFormat(titleFormat, locale);
        this.mDayOfWeekFormatter = new SimpleDateFormat(DAY_OF_WEEK_FORMAT, locale);
        this.mDayFormatter = NumberFormat.getIntegerInstance(locale);
        this.initPaints(res);
    }

    private ColorStateList applyTextAppearance(Paint p, int resId) {
        TypedArray ta = this.mContext.obtainStyledAttributes(null, R.styleable.TextAppearance, 0, resId);
        String fontFamily = ta.getString(12);
        if (fontFamily != null) {
            p.setTypeface(Typeface.create(fontFamily, 0));
        }
        p.setTextSize(ta.getDimensionPixelSize(0, (int)p.getTextSize()));
        ColorStateList textColor = ta.getColorStateList(3);
        if (textColor != null) {
            int enabledColor = textColor.getColorForState(ENABLED_STATE_SET, 0);
            p.setColor(enabledColor);
        }
        ta.recycle();
        return textColor;
    }

    public int getMonthHeight() {
        return this.mMonthHeight;
    }

    public int getCellWidth() {
        return this.mCellWidth;
    }

    public void setMonthTextAppearance(int resId) {
        this.applyTextAppearance(this.mMonthPaint, resId);
        this.invalidate();
    }

    public void setDayOfWeekTextAppearance(int resId) {
        this.applyTextAppearance(this.mDayOfWeekPaint, resId);
        this.invalidate();
    }

    public void setDayTextAppearance(int resId) {
        ColorStateList textColor = this.applyTextAppearance(this.mDayPaint, resId);
        if (textColor != null) {
            this.mDayTextColor = textColor;
        }
        this.invalidate();
    }

    public CharSequence getTitle() {
        if (this.mTitle == null) {
            this.mTitle = this.mTitleFormatter.format(this.mCalendar.getTime());
        }
        return this.mTitle;
    }

    private void initPaints(Resources res) {
        String monthTypeface = res.getString(17040738);
        String dayOfWeekTypeface = res.getString(17040739);
        String dayTypeface = res.getString(17040740);
        int monthTextSize = res.getDimensionPixelSize(17105186);
        int dayOfWeekTextSize = res.getDimensionPixelSize(17105187);
        int dayTextSize = res.getDimensionPixelSize(17105188);
        this.mMonthPaint.setAntiAlias(true);
        this.mMonthPaint.setTextSize(monthTextSize);
        this.mMonthPaint.setTypeface(Typeface.create(monthTypeface, 0));
        this.mMonthPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthPaint.setStyle(Paint.Style.FILL);
        this.mDayOfWeekPaint.setAntiAlias(true);
        this.mDayOfWeekPaint.setTextSize(dayOfWeekTextSize);
        this.mDayOfWeekPaint.setTypeface(Typeface.create(dayOfWeekTypeface, 0));
        this.mDayOfWeekPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayOfWeekPaint.setStyle(Paint.Style.FILL);
        this.mDaySelectorPaint.setAntiAlias(true);
        this.mDaySelectorPaint.setStyle(Paint.Style.FILL);
        this.mDayHighlightPaint.setAntiAlias(true);
        this.mDayHighlightPaint.setStyle(Paint.Style.FILL);
        this.mDayPaint.setAntiAlias(true);
        this.mDayPaint.setTextSize(dayTextSize);
        this.mDayPaint.setTypeface(Typeface.create(dayTypeface, 0));
        this.mDayPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayPaint.setStyle(Paint.Style.FILL);
    }

    void setMonthTextColor(ColorStateList monthTextColor) {
        int enabledColor = monthTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mMonthPaint.setColor(enabledColor);
        this.invalidate();
    }

    void setDayOfWeekTextColor(ColorStateList dayOfWeekTextColor) {
        int enabledColor = dayOfWeekTextColor.getColorForState(ENABLED_STATE_SET, 0);
        this.mDayOfWeekPaint.setColor(enabledColor);
        this.invalidate();
    }

    void setDayTextColor(ColorStateList dayTextColor) {
        this.mDayTextColor = dayTextColor;
        this.invalidate();
    }

    void setDaySelectorColor(ColorStateList dayBackgroundColor) {
        int activatedColor = dayBackgroundColor.getColorForState(StateSet.get(40), 0);
        this.mDaySelectorPaint.setColor(activatedColor);
        this.invalidate();
    }

    void setDayHighlightColor(ColorStateList dayHighlightColor) {
        int pressedColor = dayHighlightColor.getColorForState(StateSet.get(24), 0);
        this.mDayHighlightPaint.setColor(pressedColor);
        this.invalidate();
    }

    public void setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent event) {
        return this.mTouchHelper.dispatchHoverEvent(event) || super.dispatchHoverEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        int x = (int)(event.getX() + 0.5f);
        int y = (int)(event.getY() + 0.5f);
        int action = event.getAction();
        switch (action) {
            case 0: 
            case 2: {
                int touchedItem = this.getDayAtLocation(x, y);
                if (this.mTouchedItem != touchedItem) {
                    this.mTouchedItem = touchedItem;
                    this.invalidate();
                }
                if (action != 0 || touchedItem >= 0) break;
                return false;
            }
            case 1: {
                int clickedDay = this.getDayAtLocation(x, y);
                this.onDayClicked(clickedDay);
            }
            case 3: {
                this.mTouchedItem = -1;
                this.invalidate();
            }
        }
        return true;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        canvas.translate(paddingLeft, paddingTop);
        this.drawMonth(canvas);
        this.drawDaysOfWeek(canvas);
        this.drawDays(canvas);
        canvas.translate(-paddingLeft, -paddingTop);
    }

    private void drawMonth(Canvas canvas) {
        float x = (float)this.mPaddedWidth / 2.0f;
        float lineHeight = this.mMonthPaint.ascent() + this.mMonthPaint.descent();
        float y = ((float)this.mMonthHeight - lineHeight) / 2.0f;
        canvas.drawText(this.getTitle().toString(), x, y, this.mMonthPaint);
    }

    private void drawDaysOfWeek(Canvas canvas) {
        TextPaint p = this.mDayOfWeekPaint;
        int headerHeight = this.mMonthHeight;
        int rowHeight = this.mDayOfWeekHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        for (int col = 0; col < 7; ++col) {
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = this.isLayoutRtl() ? this.mPaddedWidth - colCenter : colCenter;
            int dayOfWeek = (col + this.mWeekStart) % 7;
            String label = this.getDayOfWeekLabel(dayOfWeek);
            canvas.drawText(label, colCenterRtl, (float)rowCenter - halfLineHeight, p);
        }
    }

    private String getDayOfWeekLabel(int dayOfWeek) {
        this.mDayOfWeekLabelCalendar.set(7, dayOfWeek);
        return this.mDayOfWeekFormatter.format(this.mDayOfWeekLabelCalendar.getTime());
    }

    private void drawDays(Canvas canvas) {
        TextPaint p = this.mDayPaint;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int rowHeight = this.mDayHeight;
        int colWidth = this.mCellWidth;
        float halfLineHeight = (p.ascent() + p.descent()) / 2.0f;
        int rowCenter = headerHeight + rowHeight / 2;
        int col = this.findDayOffset();
        for (int day = 1; day <= this.mDaysInMonth; ++day) {
            int dayTextColor;
            boolean isDayToday;
            boolean isDayActivated;
            int colCenter = colWidth * col + colWidth / 2;
            int colCenterRtl = this.isLayoutRtl() ? this.mPaddedWidth - colCenter : colCenter;
            int stateMask = 0;
            boolean isDayEnabled = this.isDayEnabled(day);
            if (isDayEnabled) {
                stateMask |= 8;
            }
            boolean bl = isDayActivated = this.mActivatedDay == day;
            if (isDayActivated) {
                stateMask |= 0x20;
                canvas.drawCircle(colCenterRtl, rowCenter, this.mDaySelectorRadius, this.mDaySelectorPaint);
            } else if (this.mTouchedItem == day) {
                stateMask |= 0x10;
                if (isDayEnabled) {
                    canvas.drawCircle(colCenterRtl, rowCenter, this.mDaySelectorRadius, this.mDayHighlightPaint);
                }
            }
            boolean bl2 = isDayToday = this.mToday == day;
            if (isDayToday && !isDayActivated) {
                dayTextColor = this.mDaySelectorPaint.getColor();
            } else {
                int[] stateSet = StateSet.get(stateMask);
                dayTextColor = this.mDayTextColor.getColorForState(stateSet, 0);
            }
            p.setColor(dayTextColor);
            canvas.drawText(this.mDayFormatter.format(day), colCenterRtl, (float)rowCenter - halfLineHeight, p);
            if (++col != 7) continue;
            col = 0;
            rowCenter += rowHeight;
        }
    }

    private boolean isDayEnabled(int day) {
        return day >= this.mEnabledDayStart && day <= this.mEnabledDayEnd;
    }

    private boolean isValidDayOfMonth(int day) {
        return day >= 1 && day <= this.mDaysInMonth;
    }

    private static boolean isValidDayOfWeek(int day) {
        return day >= 1 && day <= 7;
    }

    private static boolean isValidMonth(int month) {
        return month >= 0 && month <= 11;
    }

    public void setSelectedDay(int dayOfMonth) {
        this.mActivatedDay = dayOfMonth;
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    public void setFirstDayOfWeek(int weekStart) {
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        this.mTouchHelper.invalidateRoot();
        this.invalidate();
    }

    void setMonthParams(int selectedDay, int month, int year, int weekStart, int enabledDayStart, int enabledDayEnd) {
        this.mActivatedDay = selectedDay;
        if (SimpleMonthView.isValidMonth(month)) {
            this.mMonth = month;
        }
        this.mYear = year;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        Calendar today = Calendar.getInstance();
        this.mToday = -1;
        this.mDaysInMonth = SimpleMonthView.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mDaysInMonth; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mToday = day;
        }
        this.mEnabledDayStart = MathUtils.constrain(enabledDayStart, 1, this.mDaysInMonth);
        this.mEnabledDayEnd = MathUtils.constrain(enabledDayEnd, this.mEnabledDayStart, this.mDaysInMonth);
        this.mTitle = null;
        this.mTouchHelper.invalidateRoot();
    }

    private static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private boolean sameDay(int day, Calendar today) {
        return this.mYear == today.get(1) && this.mMonth == today.get(2) && day == today.get(5);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int preferredHeight = this.mDesiredDayHeight * 6 + this.mDesiredDayOfWeekHeight + this.mDesiredMonthHeight + this.getPaddingTop() + this.getPaddingBottom();
        int preferredWidth = this.mDesiredCellWidth * 7 + this.getPaddingStart() + this.getPaddingEnd();
        int resolvedWidth = SimpleMonthView.resolveSize(preferredWidth, widthMeasureSpec);
        int resolvedHeight = SimpleMonthView.resolveSize(preferredHeight, heightMeasureSpec);
        this.setMeasuredDimension(resolvedWidth, resolvedHeight);
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.requestLayout();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        int w = right - left;
        int h = bottom - top;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int paddedRight = w - paddingRight;
        int paddedBottom = h - paddingBottom;
        int paddedWidth = paddedRight - paddingLeft;
        int paddedHeight = paddedBottom - paddingTop;
        if (paddedWidth == this.mPaddedWidth || paddedHeight == this.mPaddedHeight) {
            return;
        }
        this.mPaddedWidth = paddedWidth;
        this.mPaddedHeight = paddedHeight;
        int measuredPaddedHeight = this.getMeasuredHeight() - paddingTop - paddingBottom;
        float scaleH = (float)paddedHeight / (float)measuredPaddedHeight;
        int monthHeight = (int)((float)this.mDesiredMonthHeight * scaleH);
        int cellWidth = this.mPaddedWidth / 7;
        this.mMonthHeight = monthHeight;
        this.mDayOfWeekHeight = (int)((float)this.mDesiredDayOfWeekHeight * scaleH);
        this.mDayHeight = (int)((float)this.mDesiredDayHeight * scaleH);
        this.mCellWidth = cellWidth;
        int maxSelectorWidth = cellWidth / 2 + Math.min(paddingLeft, paddingRight);
        int maxSelectorHeight = this.mDayHeight / 2 + paddingBottom;
        this.mDaySelectorRadius = Math.min(this.mDesiredDaySelectorRadius, Math.min(maxSelectorWidth, maxSelectorHeight));
        this.mTouchHelper.invalidateRoot();
    }

    private int findDayOffset() {
        int offset = this.mDayOfWeekStart - this.mWeekStart;
        if (this.mDayOfWeekStart < this.mWeekStart) {
            return offset + 7;
        }
        return offset;
    }

    private int getDayAtLocation(int x, int y) {
        int row;
        int paddedX = x - this.getPaddingLeft();
        if (paddedX < 0 || paddedX >= this.mPaddedWidth) {
            return -1;
        }
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int paddedY = y - this.getPaddingTop();
        if (paddedY < headerHeight || paddedY >= this.mPaddedHeight) {
            return -1;
        }
        int paddedXRtl = this.isLayoutRtl() ? this.mPaddedWidth - paddedX : paddedX;
        int col = paddedXRtl * 7 / this.mPaddedWidth;
        int index = col + (row = (paddedY - headerHeight) / this.mDayHeight) * 7;
        int day = index + 1 - this.findDayOffset();
        if (!this.isValidDayOfMonth(day)) {
            return -1;
        }
        return day;
    }

    private boolean getBoundsForDay(int id2, Rect outBounds) {
        if (!this.isValidDayOfMonth(id2)) {
            return false;
        }
        int index = id2 - 1 + this.findDayOffset();
        int col = index % 7;
        int colWidth = this.mCellWidth;
        int left = this.isLayoutRtl() ? this.getWidth() - this.getPaddingRight() - (col + 1) * colWidth : this.getPaddingLeft() + col * colWidth;
        int row = index / 7;
        int rowHeight = this.mDayHeight;
        int headerHeight = this.mMonthHeight + this.mDayOfWeekHeight;
        int top = this.getPaddingTop() + headerHeight + row * rowHeight;
        outBounds.set(left, top, left + colWidth, top + rowHeight);
        return true;
    }

    private boolean onDayClicked(int day) {
        if (!this.isValidDayOfMonth(day) || !this.isDayEnabled(day)) {
            return false;
        }
        if (this.mOnDayClickListener != null) {
            Calendar date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
            this.mOnDayClickListener.onDayClick(this, date);
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
        return true;
    }

    public static interface OnDayClickListener {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper {
        private static final String DATE_FORMAT = "dd MMMM yyyy";
        private final Rect mTempRect;
        private final Calendar mTempCalendar;

        public MonthViewTouchHelper(View host) {
            super(host);
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            int day = SimpleMonthView.this.getDayAtLocation((int)(x + 0.5f), (int)(y + 0.5f));
            if (day != -1) {
                return day;
            }
            return Integer.MIN_VALUE;
        }

        @Override
        protected void getVisibleVirtualViews(IntArray virtualViewIds) {
            for (int day = 1; day <= SimpleMonthView.this.mDaysInMonth; ++day) {
                virtualViewIds.add(day);
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.getDayDescription(virtualViewId));
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            boolean hasBounds = SimpleMonthView.this.getBoundsForDay(virtualViewId, this.mTempRect);
            if (!hasBounds) {
                this.mTempRect.setEmpty();
                node.setContentDescription("");
                node.setBoundsInParent(this.mTempRect);
                node.setVisibleToUser(false);
                return;
            }
            node.setText(this.getDayText(virtualViewId));
            node.setContentDescription(this.getDayDescription(virtualViewId));
            node.setBoundsInParent(this.mTempRect);
            boolean isDayEnabled = SimpleMonthView.this.isDayEnabled(virtualViewId);
            if (isDayEnabled) {
                node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            }
            node.setEnabled(isDayEnabled);
            if (virtualViewId == SimpleMonthView.this.mActivatedDay) {
                node.setChecked(true);
            }
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    return SimpleMonthView.this.onDayClicked(virtualViewId);
                }
            }
            return false;
        }

        private CharSequence getDayDescription(int id2) {
            if (SimpleMonthView.this.isValidDayOfMonth(id2)) {
                this.mTempCalendar.set(SimpleMonthView.this.mYear, SimpleMonthView.this.mMonth, id2);
                return DateFormat.format((CharSequence)DATE_FORMAT, this.mTempCalendar.getTimeInMillis());
            }
            return "";
        }

        private CharSequence getDayText(int id2) {
            if (SimpleMonthView.this.isValidDayOfMonth(id2)) {
                return SimpleMonthView.this.mDayFormatter.format(id2);
            }
            return null;
        }
    }
}

