/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.NumberPicker;
import android.widget.TextView;
import android.widget.TimePicker;
import com.android.internal.R;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;

class TimePickerSpinnerDelegate
extends TimePicker.AbstractTimePickerDelegate {
    private static final boolean DEFAULT_ENABLED_STATE = true;
    private static final int HOURS_IN_HALF_DAY = 12;
    private boolean mIs24HourView;
    private boolean mIsAm;
    private final NumberPicker mHourSpinner;
    private final NumberPicker mMinuteSpinner;
    private final NumberPicker mAmPmSpinner;
    private final EditText mHourSpinnerInput;
    private final EditText mMinuteSpinnerInput;
    private final EditText mAmPmSpinnerInput;
    private final TextView mDivider;
    private final Button mAmPmButton;
    private final String[] mAmPmStrings;
    private boolean mIsEnabled = true;
    private Calendar mTempCalendar;
    private boolean mHourWithTwoDigit;
    private char mHourFormat;

    public TimePickerSpinnerDelegate(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(delegator, context);
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        int layoutResourceId = a.getResourceId(12, 17367282);
        a.recycle();
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        inflater.inflate(layoutResourceId, (ViewGroup)this.mDelegator, true);
        this.mHourSpinner = (NumberPicker)delegator.findViewById(16909297);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePickerSpinnerDelegate.this.updateInputState();
                if (!TimePickerSpinnerDelegate.this.is24HourView() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    TimePickerSpinnerDelegate.this.mIsAm = !TimePickerSpinnerDelegate.this.mIsAm;
                    TimePickerSpinnerDelegate.this.updateAmPmControl();
                }
                TimePickerSpinnerDelegate.this.onTimeChanged();
            }
        });
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.findViewById(16909186);
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.mDelegator.findViewById(16909300);
        if (this.mDivider != null) {
            this.setDividerText();
        }
        this.mMinuteSpinner = (NumberPicker)this.mDelegator.findViewById(16909298);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            @Override
            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePickerSpinnerDelegate.this.updateInputState();
                int minValue = TimePickerSpinnerDelegate.this.mMinuteSpinner.getMinValue();
                int maxValue = TimePickerSpinnerDelegate.this.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = TimePickerSpinnerDelegate.this.mHourSpinner.getValue() + 1;
                    if (!TimePickerSpinnerDelegate.this.is24HourView() && newHour == 12) {
                        TimePickerSpinnerDelegate.this.mIsAm = !TimePickerSpinnerDelegate.this.mIsAm;
                        TimePickerSpinnerDelegate.this.updateAmPmControl();
                    }
                    TimePickerSpinnerDelegate.this.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = TimePickerSpinnerDelegate.this.mHourSpinner.getValue() - 1;
                    if (!TimePickerSpinnerDelegate.this.is24HourView() && newHour == 11) {
                        TimePickerSpinnerDelegate.this.mIsAm = !TimePickerSpinnerDelegate.this.mIsAm;
                        TimePickerSpinnerDelegate.this.updateAmPmControl();
                    }
                    TimePickerSpinnerDelegate.this.mHourSpinner.setValue(newHour);
                }
                TimePickerSpinnerDelegate.this.onTimeChanged();
            }
        });
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.findViewById(16909186);
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = TimePickerSpinnerDelegate.getAmPmStrings(context);
        View amPmView = this.mDelegator.findViewById(16909299);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View button) {
                    button.requestFocus();
                    TimePickerSpinnerDelegate.this.mIsAm = !TimePickerSpinnerDelegate.this.mIsAm;
                    TimePickerSpinnerDelegate.this.updateAmPmControl();
                    TimePickerSpinnerDelegate.this.onTimeChanged();
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

                @Override
                public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    TimePickerSpinnerDelegate.this.updateInputState();
                    picker.requestFocus();
                    TimePickerSpinnerDelegate.this.mIsAm = !TimePickerSpinnerDelegate.this.mIsAm;
                    TimePickerSpinnerDelegate.this.updateAmPmControl();
                    TimePickerSpinnerDelegate.this.onTimeChanged();
                }
            });
            this.mAmPmSpinnerInput = (EditText)this.mAmPmSpinner.findViewById(16909186);
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        if (this.isAmPmAtStart()) {
            ViewGroup amPmParent = (ViewGroup)delegator.findViewById(16909296);
            amPmParent.removeView(amPmView);
            amPmParent.addView(amPmView, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)amPmView.getLayoutParams();
            int startMargin = lp.getMarginStart();
            int endMargin = lp.getMarginEnd();
            if (startMargin != endMargin) {
                lp.setMarginStart(endMargin);
                lp.setMarginEnd(startMargin);
            }
        }
        this.getHourFormatData();
        this.updateHourControl();
        this.updateMinuteControl();
        this.updateAmPmControl();
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
        if (this.mDelegator.getImportantForAccessibility() == 0) {
            this.mDelegator.setImportantForAccessibility(1);
        }
    }

    private void getHourFormatData() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        this.mHourWithTwoDigit = false;
        boolean hourFormat = false;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            this.mHourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            this.mHourWithTwoDigit = true;
            break;
        }
    }

    private boolean isAmPmAtStart() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "hm");
        return bestDateTimePattern.startsWith("a");
    }

    private void setDividerText() {
        int minuteIndex;
        String skeleton = this.mIs24HourView ? "Hm" : "hm";
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, skeleton);
        int hourIndex = bestDateTimePattern.lastIndexOf(72);
        if (hourIndex == -1) {
            hourIndex = bestDateTimePattern.lastIndexOf(104);
        }
        String separatorText = hourIndex == -1 ? ":" : ((minuteIndex = bestDateTimePattern.indexOf(109, hourIndex + 1)) == -1 ? Character.toString(bestDateTimePattern.charAt(hourIndex + 1)) : bestDateTimePattern.substring(hourIndex + 1, minuteIndex));
        this.mDivider.setText(separatorText);
    }

    @Override
    public void setCurrentHour(int currentHour) {
        this.setCurrentHour(currentHour, true);
    }

    private void setCurrentHour(int currentHour, boolean notifyTimeChanged) {
        if (currentHour == this.getCurrentHour()) {
            return;
        }
        if (!this.is24HourView()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour -= 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        if (notifyTimeChanged) {
            this.onTimeChanged();
        }
    }

    @Override
    public int getCurrentHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    @Override
    public void setCurrentMinute(int currentMinute) {
        if (currentMinute == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(currentMinute);
        this.onTimeChanged();
    }

    @Override
    public int getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    @Override
    public void setIs24HourView(boolean is24HourView) {
        if (this.mIs24HourView == is24HourView) {
            return;
        }
        int currentHour = this.getCurrentHour();
        this.mIs24HourView = is24HourView;
        this.getHourFormatData();
        this.updateHourControl();
        this.setCurrentHour(currentHour, false);
        this.updateMinuteControl();
        this.updateAmPmControl();
    }

    @Override
    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    @Override
    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    @Override
    public int getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable superState) {
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute());
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
    }

    private void updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive(this.mHourSpinnerInput)) {
                this.mHourSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mAmPmSpinnerInput)) {
                this.mAmPmSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            }
        }
    }

    private void updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.mDelegator.sendAccessibilityEvent(4);
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    private void onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private void updateHourControl() {
        if (this.is24HourView()) {
            if (this.mHourFormat == 'k') {
                this.mHourSpinner.setMinValue(1);
                this.mHourSpinner.setMaxValue(24);
            } else {
                this.mHourSpinner.setMinValue(0);
                this.mHourSpinner.setMaxValue(23);
            }
        } else if (this.mHourFormat == 'K') {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(11);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
        }
        this.mHourSpinner.setFormatter(this.mHourWithTwoDigit ? NumberPicker.getTwoDigitFormatter() : null);
    }

    private void updateMinuteControl() {
        if (this.is24HourView()) {
            this.mMinuteSpinnerInput.setImeOptions(6);
        } else {
            this.mMinuteSpinnerInput.setImeOptions(5);
        }
    }

    private void setContentDescriptions() {
        this.trySetContentDescription(this.mMinuteSpinner, 16909185, 17040478);
        this.trySetContentDescription(this.mMinuteSpinner, 16909187, 17040479);
        this.trySetContentDescription(this.mHourSpinner, 16909185, 17040480);
        this.trySetContentDescription(this.mHourSpinner, 16909187, 17040481);
        if (this.mAmPmSpinner != null) {
            this.trySetContentDescription(this.mAmPmSpinner, 16909185, 17040482);
            this.trySetContentDescription(this.mAmPmSpinner, 16909187, 17040483);
        }
    }

    private void trySetContentDescription(View root, int viewId, int contDescResId) {
        View target = root.findViewById(viewId);
        if (target != null) {
            target.setContentDescription(this.mContext.getString(contDescResId));
        }
    }

    public static String[] getAmPmStrings(Context context) {
        String[] result = new String[2];
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        result[0] = d.amPm[0].length() > 4 ? d.narrowAm : d.amPm[0];
        result[1] = d.amPm[1].length() > 4 ? d.narrowPm : d.amPm[1];
        return result;
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }
    }
}

