/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.chooser.ChooserTarget;
import android.service.chooser.IChooserTargetResult;
import android.service.chooser.IChooserTargetService;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.logging.MetricsLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ChooserActivity
extends ResolverActivity {
    private static final String TAG = "ChooserActivity";
    private static final boolean DEBUG = false;
    private static final int QUERY_TARGET_SERVICE_LIMIT = 5;
    private static final int WATCHDOG_TIMEOUT_MILLIS = 5000;
    private Bundle mReplacementExtras;
    private IntentSender mChosenComponentSender;
    private IntentSender mRefinementIntentSender;
    private RefinementResultReceiver mRefinementResultReceiver;
    private Intent mReferrerFillInIntent;
    private ChooserListAdapter mChooserListAdapter;
    private final List<ChooserTargetServiceConnection> mServiceConnections = new ArrayList<ChooserTargetServiceConnection>();
    private static final int CHOOSER_TARGET_SERVICE_RESULT = 1;
    private static final int CHOOSER_TARGET_SERVICE_WATCHDOG_TIMEOUT = 2;
    private final Handler mChooserHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (ChooserActivity.this.isDestroyed()) break;
                    ServiceResultInfo sri = (ServiceResultInfo)msg.obj;
                    if (!ChooserActivity.this.mServiceConnections.contains(sri.connection)) {
                        Log.w(ChooserActivity.TAG, "ChooserTargetServiceConnection " + sri.connection + " returned after being removed from active connections." + " Have you considered returning results faster?");
                        break;
                    }
                    if (sri.resultTargets != null) {
                        ChooserActivity.this.mChooserListAdapter.addServiceResults(sri.originalTarget, sri.resultTargets);
                    }
                    ChooserActivity.this.unbindService(sri.connection);
                    ChooserActivity.this.mServiceConnections.remove(sri.connection);
                    if (!ChooserActivity.this.mServiceConnections.isEmpty()) break;
                    ChooserActivity.this.mChooserHandler.removeMessages(2);
                    ChooserActivity.this.sendVoiceChoicesIfNeeded();
                    break;
                }
                case 2: {
                    ChooserActivity.this.unbindRemainingServices();
                    ChooserActivity.this.sendVoiceChoicesIfNeeded();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Parcelable[] targetsParcelable;
        Intent intent = this.getIntent();
        Object targetParcelable = intent.getParcelableExtra("android.intent.extra.INTENT");
        if (!(targetParcelable instanceof Intent)) {
            Log.w(TAG, "Target is not an intent: " + targetParcelable);
            this.finish();
            super.onCreate(null);
            return;
        }
        Intent target = (Intent)targetParcelable;
        if (target != null) {
            this.modifyTargetIntent(target);
        }
        if ((targetsParcelable = intent.getParcelableArrayExtra("android.intent.extra.ALTERNATE_INTENTS")) != null) {
            boolean offset = target == null;
            Intent[] additionalTargets = new Intent[offset ? targetsParcelable.length - 1 : targetsParcelable.length];
            for (int i = 0; i < targetsParcelable.length; ++i) {
                if (!(targetsParcelable[i] instanceof Intent)) {
                    Log.w(TAG, "EXTRA_ALTERNATE_INTENTS array entry #" + i + " is not an Intent: " + targetsParcelable[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent additionalTarget = (Intent)targetsParcelable[i];
                if (i == 0 && target == null) {
                    target = additionalTarget;
                    this.modifyTargetIntent(target);
                    continue;
                }
                additionalTargets[offset ? i - 1 : i] = additionalTarget;
                this.modifyTargetIntent(additionalTarget);
            }
            this.setAdditionalTargets(additionalTargets);
        }
        this.mReplacementExtras = intent.getBundleExtra("android.intent.extra.REPLACEMENT_EXTRAS");
        CharSequence title = intent.getCharSequenceExtra("android.intent.extra.TITLE");
        int defaultTitleRes = 0;
        if (title == null) {
            defaultTitleRes = 17040212;
        }
        Parcelable[] pa = intent.getParcelableArrayExtra("android.intent.extra.INITIAL_INTENTS");
        Intent[] initialIntents = null;
        if (pa != null) {
            initialIntents = new Intent[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof Intent)) {
                    Log.w(TAG, "Initial intent #" + i + " not an Intent: " + pa[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent in = (Intent)pa[i];
                this.modifyTargetIntent(in);
                initialIntents[i] = in;
            }
        }
        this.mReferrerFillInIntent = new Intent().putExtra("android.intent.extra.REFERRER", this.getReferrer());
        this.mChosenComponentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOSEN_COMPONENT_INTENT_SENDER");
        this.mRefinementIntentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOOSER_REFINEMENT_INTENT_SENDER");
        this.setSafeForwardingMode(true);
        super.onCreate(savedInstanceState, target, title, defaultTitleRes, initialIntents, null, false);
        MetricsLogger.action(this, 214);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
    }

    @Override
    public Intent getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        Bundle replExtras;
        Intent result = defIntent;
        if (this.mReplacementExtras != null && (replExtras = this.mReplacementExtras.getBundle(aInfo.packageName)) != null) {
            result = new Intent(defIntent);
            result.putExtras(replExtras);
        }
        if (aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_USER_OWNER) || aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            result = Intent.createChooser(result, this.getIntent().getCharSequenceExtra("android.intent.extra.TITLE"));
        }
        return result;
    }

    @Override
    void onActivityStarted(ResolverActivity.TargetInfo cti) {
        ComponentName target;
        if (this.mChosenComponentSender != null && (target = cti.getResolvedComponentName()) != null) {
            Intent fillIn = new Intent().putExtra("android.intent.extra.CHOSEN_COMPONENT", target);
            try {
                this.mChosenComponentSender.sendIntent(this, -1, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                Slog.e(TAG, "Unable to launch supplied IntentSender to report the chosen component: " + e);
            }
        }
    }

    @Override
    void onPrepareAdapterView(AbsListView adapterView, ResolverActivity.ResolveListAdapter adapter, boolean alwaysUseOption) {
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        this.mChooserListAdapter = (ChooserListAdapter)adapter;
        adapterView.setAdapter(new ChooserRowAdapter(this.mChooserListAdapter));
        if (listView != null) {
            listView.setItemsCanFocus(true);
        }
    }

    @Override
    int getLayoutResource() {
        return 17367106;
    }

    @Override
    boolean shouldGetActivityMetadata() {
        return true;
    }

    private void modifyTargetIntent(Intent in) {
        String action = in.getAction();
        if ("android.intent.action.SEND".equals(action) || "android.intent.action.SEND_MULTIPLE".equals(action)) {
            in.addFlags(0x8080000);
        }
    }

    @Override
    protected boolean onTargetSelected(ResolverActivity.TargetInfo target, boolean alwaysCheck) {
        if (this.mRefinementIntentSender != null) {
            Intent fillIn = new Intent();
            List<Intent> sourceIntents = target.getAllSourceIntents();
            if (!sourceIntents.isEmpty()) {
                fillIn.putExtra("android.intent.extra.INTENT", sourceIntents.get(0));
                if (sourceIntents.size() > 1) {
                    Parcelable[] alts = new Intent[sourceIntents.size() - 1];
                    int N = sourceIntents.size();
                    for (int i = 1; i < N; ++i) {
                        alts[i - 1] = sourceIntents.get(i);
                    }
                    fillIn.putExtra("android.intent.extra.ALTERNATE_INTENTS", alts);
                }
                if (this.mRefinementResultReceiver != null) {
                    this.mRefinementResultReceiver.destroy();
                }
                this.mRefinementResultReceiver = new RefinementResultReceiver(this, target, null);
                fillIn.putExtra("android.intent.extra.RESULT_RECEIVER", this.mRefinementResultReceiver);
                try {
                    this.mRefinementIntentSender.sendIntent(this, 0, fillIn, null, null);
                    return false;
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e(TAG, "Refinement IntentSender failed to send", e);
                }
            }
        }
        return super.onTargetSelected(target, alwaysCheck);
    }

    @Override
    void startSelected(int which, boolean always, boolean filtered) {
        super.startSelected(which, always, filtered);
        if (this.mChooserListAdapter != null) {
            int cat = 0;
            int value = which;
            switch (this.mChooserListAdapter.getPositionTargetType(which)) {
                case 0: {
                    cat = 215;
                    break;
                }
                case 1: {
                    cat = 216;
                    value -= this.mChooserListAdapter.getCallerTargetCount();
                    break;
                }
                case 2: {
                    cat = 217;
                    value -= this.mChooserListAdapter.getCallerTargetCount() + this.mChooserListAdapter.getServiceTargetCount();
                }
            }
            if (cat != 0) {
                MetricsLogger.action((Context)this, cat, value);
            }
        }
    }

    void queryTargetServices(ChooserListAdapter adapter) {
        PackageManager pm = this.getPackageManager();
        int targetsToQuery = 0;
        int N = adapter.getDisplayResolveInfoCount();
        for (int i = 0; i < N; ++i) {
            String serviceName;
            ResolverActivity.DisplayResolveInfo dri = adapter.getDisplayResolveInfo(i);
            ActivityInfo ai = dri.getResolveInfo().activityInfo;
            Bundle md = ai.metaData;
            String string2 = serviceName = md != null ? this.convertServiceName(ai.packageName, md.getString("android.service.chooser.chooser_target_service")) : null;
            if (serviceName != null) {
                Intent serviceIntent;
                block8: {
                    ComponentName serviceComponent = new ComponentName(ai.packageName, serviceName);
                    serviceIntent = new Intent("android.service.chooser.ChooserTargetService").setComponent(serviceComponent);
                    try {
                        String perm = pm.getServiceInfo((ComponentName)serviceComponent, (int)0).permission;
                        if (!"android.permission.BIND_CHOOSER_TARGET_SERVICE".equals(perm)) {
                            Log.w(TAG, "ChooserTargetService " + serviceComponent + " does not require" + " permission " + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + " - this service will not be queried for ChooserTargets." + " add android:permission=\"" + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + "\"" + " to the <service> tag for " + serviceComponent + " in the manifest.");
                        }
                        break block8;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.e(TAG, "Could not look up service " + serviceComponent, e);
                    }
                    continue;
                }
                ChooserTargetServiceConnection conn = new ChooserTargetServiceConnection(dri);
                if (this.bindServiceAsUser(serviceIntent, conn, 5, UserHandle.CURRENT)) {
                    this.mServiceConnections.add(conn);
                    ++targetsToQuery;
                }
            }
            if (targetsToQuery >= 5) break;
        }
        if (!this.mServiceConnections.isEmpty()) {
            this.mChooserHandler.sendEmptyMessageDelayed(2, 5000L);
        } else {
            this.sendVoiceChoicesIfNeeded();
        }
    }

    private String convertServiceName(String packageName, String serviceName) {
        if (TextUtils.isEmpty(serviceName)) {
            return null;
        }
        String fullName = serviceName.startsWith(".") ? packageName + serviceName : (serviceName.indexOf(46) >= 0 ? serviceName : null);
        return fullName;
    }

    void unbindRemainingServices() {
        int N = this.mServiceConnections.size();
        for (int i = 0; i < N; ++i) {
            ChooserTargetServiceConnection conn = this.mServiceConnections.get(i);
            this.unbindService(conn);
        }
        this.mServiceConnections.clear();
        this.mChooserHandler.removeMessages(2);
    }

    @Override
    void onSetupVoiceInteraction() {
    }

    void onRefinementResult(ResolverActivity.TargetInfo selectedTarget, Intent matchingIntent) {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        if (selectedTarget == null) {
            Log.e(TAG, "Refinement result intent did not match any known targets; canceling");
        } else if (!this.checkTargetSourceIntent(selectedTarget, matchingIntent)) {
            Log.e(TAG, "onRefinementResult: Selected target " + selectedTarget + " cannot match refined source intent " + matchingIntent);
        } else if (super.onTargetSelected(selectedTarget.cloneFilledIn(matchingIntent, 0), false)) {
            this.finish();
            return;
        }
        this.onRefinementCanceled();
    }

    void onRefinementCanceled() {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.finish();
    }

    boolean checkTargetSourceIntent(ResolverActivity.TargetInfo target, Intent matchingIntent) {
        List<Intent> targetIntents = target.getAllSourceIntents();
        int N = targetIntents.size();
        for (int i = 0; i < N; ++i) {
            Intent targetIntent = targetIntents.get(i);
            if (!targetIntent.filterEquals(matchingIntent)) continue;
            return true;
        }
        return false;
    }

    void filterServiceTargets(String packageName, List<ChooserTarget> targets) {
        if (targets == null) {
            return;
        }
        PackageManager pm = this.getPackageManager();
        for (int i = targets.size() - 1; i >= 0; --i) {
            boolean remove;
            ChooserTarget target = targets.get(i);
            ComponentName targetName = target.getComponentName();
            if (packageName != null && packageName.equals(targetName.getPackageName())) continue;
            try {
                ActivityInfo ai = pm.getActivityInfo(targetName, 0);
                remove = !ai.exported || ai.permission != null;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "Target " + target + " returned by " + packageName + " component not found");
                remove = true;
            }
            if (!remove) continue;
            targets.remove(i);
        }
    }

    @Override
    ResolverActivity.ResolveListAdapter createAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
        ChooserListAdapter adapter = new ChooserListAdapter(context, payloadIntents, initialIntents, rList, launchedFromUid, filterLastUsed);
        this.queryTargetServices(adapter);
        return adapter;
    }

    static class RefinementResultReceiver
    extends ResultReceiver {
        private ChooserActivity mChooserActivity;
        private ResolverActivity.TargetInfo mSelectedTarget;

        public RefinementResultReceiver(ChooserActivity host, ResolverActivity.TargetInfo target, Handler handler) {
            super(handler);
            this.mChooserActivity = host;
            this.mSelectedTarget = target;
        }

        @Override
        protected void onReceiveResult(int resultCode, Bundle resultData) {
            if (this.mChooserActivity == null) {
                Log.e(ChooserActivity.TAG, "Destroyed RefinementResultReceiver received a result");
                return;
            }
            if (resultData == null) {
                Log.e(ChooserActivity.TAG, "RefinementResultReceiver received null resultData");
                return;
            }
            switch (resultCode) {
                case 0: {
                    this.mChooserActivity.onRefinementCanceled();
                    break;
                }
                case -1: {
                    Object intentParcelable = resultData.getParcelable("android.intent.extra.INTENT");
                    if (intentParcelable instanceof Intent) {
                        this.mChooserActivity.onRefinementResult(this.mSelectedTarget, (Intent)intentParcelable);
                        break;
                    }
                    Log.e(ChooserActivity.TAG, "RefinementResultReceiver received RESULT_OK but no Intent in resultData with key Intent.EXTRA_INTENT");
                    break;
                }
                default: {
                    Log.w(ChooserActivity.TAG, "Unknown result code " + resultCode + " sent to RefinementResultReceiver");
                }
            }
        }

        public void destroy() {
            this.mChooserActivity = null;
            this.mSelectedTarget = null;
        }
    }

    static class ServiceResultInfo {
        public final ResolverActivity.DisplayResolveInfo originalTarget;
        public final List<ChooserTarget> resultTargets;
        public final ChooserTargetServiceConnection connection;

        public ServiceResultInfo(ResolverActivity.DisplayResolveInfo ot, List<ChooserTarget> rt, ChooserTargetServiceConnection c) {
            this.originalTarget = ot;
            this.resultTargets = rt;
            this.connection = c;
        }
    }

    class ChooserTargetServiceConnection
    implements ServiceConnection {
        private final ResolverActivity.DisplayResolveInfo mOriginalTarget;
        private final IChooserTargetResult mChooserTargetResult = new IChooserTargetResult.Stub(){

            @Override
            public void sendResult(List<ChooserTarget> targets) throws RemoteException {
                ChooserActivity.this.filterServiceTargets(((ChooserTargetServiceConnection)ChooserTargetServiceConnection.this).mOriginalTarget.getResolveInfo().activityInfo.packageName, targets);
                Message msg = Message.obtain();
                msg.what = 1;
                msg.obj = new ServiceResultInfo(ChooserTargetServiceConnection.this.mOriginalTarget, targets, ChooserTargetServiceConnection.this);
                ChooserActivity.this.mChooserHandler.sendMessage(msg);
            }
        };

        public ChooserTargetServiceConnection(ResolverActivity.DisplayResolveInfo dri) {
            this.mOriginalTarget = dri;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IChooserTargetService icts = IChooserTargetService.Stub.asInterface(service);
            try {
                icts.getChooserTargets(this.mOriginalTarget.getResolvedComponentName(), this.mOriginalTarget.getResolveInfo().filter, this.mChooserTargetResult);
            }
            catch (RemoteException e) {
                Log.e(ChooserActivity.TAG, "Querying ChooserTargetService " + name + " failed.", e);
                ChooserActivity.this.unbindService(this);
                ChooserActivity.this.mServiceConnections.remove(this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            ChooserActivity.this.unbindService(this);
            ChooserActivity.this.mServiceConnections.remove(this);
            if (ChooserActivity.this.mServiceConnections.isEmpty()) {
                ChooserActivity.this.mChooserHandler.removeMessages(2);
                ChooserActivity.this.sendVoiceChoicesIfNeeded();
            }
        }

        public String toString() {
            return this.mOriginalTarget.getResolveInfo().activityInfo.toString();
        }
    }

    class ChooserRowAdapter
    extends BaseAdapter {
        private ChooserListAdapter mChooserListAdapter;
        private final LayoutInflater mLayoutInflater;
        private final int mColumnCount = 4;

        public ChooserRowAdapter(ChooserListAdapter wrappedAdapter) {
            this.mChooserListAdapter = wrappedAdapter;
            this.mLayoutInflater = LayoutInflater.from(ChooserActivity.this);
            wrappedAdapter.registerDataSetObserver(new DataSetObserver(){

                @Override
                public void onChanged() {
                    super.onChanged();
                    ChooserRowAdapter.this.notifyDataSetChanged();
                }

                @Override
                public void onInvalidated() {
                    super.onInvalidated();
                    ChooserRowAdapter.this.notifyDataSetInvalidated();
                }
            });
        }

        @Override
        public int getCount() {
            return (int)(Math.ceil((float)this.mChooserListAdapter.getCallerTargetCount() / 4.0f) + Math.ceil((float)this.mChooserListAdapter.getServiceTargetCount() / 4.0f) + Math.ceil((float)this.mChooserListAdapter.getStandardTargetCount() / 4.0f));
        }

        @Override
        public Object getItem(int position) {
            return position;
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            View[] holder = convertView == null ? this.createViewHolder(parent) : (View[])convertView.getTag();
            this.bindViewHolder(position, holder);
            return holder[4];
        }

        View[] createViewHolder(ViewGroup parent) {
            View[] holder = new View[5];
            ViewGroup row = (ViewGroup)this.mLayoutInflater.inflate(17367107, parent, false);
            for (int i = 0; i < 4; ++i) {
                holder[i] = this.mChooserListAdapter.createView(row);
                row.addView(holder[i]);
            }
            row.setTag(holder);
            holder[4] = row;
            return holder;
        }

        void bindViewHolder(int rowPosition, View[] holder) {
            int end;
            int start = this.getFirstRowPosition(rowPosition);
            int startType = this.mChooserListAdapter.getPositionTargetType(start);
            for (end = start + 4 - 1; this.mChooserListAdapter.getPositionTargetType(end) != startType && end >= start; --end) {
            }
            ViewGroup row = (ViewGroup)holder[4];
            if (startType == 1) {
                row.setBackgroundColor(ChooserActivity.this.getColor(17170545));
            } else {
                row.setBackground(null);
            }
            for (int i = 0; i < 4; ++i) {
                View v = holder[i];
                if (start + i <= end) {
                    v.setVisibility(0);
                    final int itemIndex = start + i;
                    this.mChooserListAdapter.bindView(itemIndex, v);
                    v.setOnClickListener(new View.OnClickListener(){

                        @Override
                        public void onClick(View v) {
                            ChooserActivity.this.startSelected(itemIndex, false, true);
                        }
                    });
                    v.setOnLongClickListener(new View.OnLongClickListener(){

                        @Override
                        public boolean onLongClick(View v) {
                            ChooserActivity.this.showAppDetails(ChooserRowAdapter.this.mChooserListAdapter.resolveInfoForPosition(itemIndex, true));
                            return true;
                        }
                    });
                    continue;
                }
                v.setVisibility(8);
            }
        }

        int getFirstRowPosition(int row) {
            int callerCount = this.mChooserListAdapter.getCallerTargetCount();
            int callerRows = (int)Math.ceil((float)callerCount / 4.0f);
            if (row < callerRows) {
                return row * 4;
            }
            int serviceCount = this.mChooserListAdapter.getServiceTargetCount();
            int serviceRows = (int)Math.ceil((float)serviceCount / 4.0f);
            if (row < callerRows + serviceRows) {
                return callerCount + (row - callerRows) * 4;
            }
            return callerCount + serviceCount + (row - callerRows - serviceRows) * 4;
        }
    }

    static class BaseChooserTargetComparator
    implements Comparator<ChooserTarget> {
        BaseChooserTargetComparator() {
        }

        @Override
        public int compare(ChooserTarget lhs, ChooserTarget rhs) {
            return (int)Math.signum(lhs.getScore() - rhs.getScore());
        }
    }

    public class ChooserListAdapter
    extends ResolverActivity.ResolveListAdapter {
        public static final int TARGET_BAD = -1;
        public static final int TARGET_CALLER = 0;
        public static final int TARGET_SERVICE = 1;
        public static final int TARGET_STANDARD = 2;
        private static final int MAX_SERVICE_TARGETS = 8;
        private final List<ChooserTargetInfo> mServiceTargets;
        private final List<ResolverActivity.TargetInfo> mCallerTargets;
        private float mLateFee;
        private final BaseChooserTargetComparator mBaseTargetComparator;

        public ChooserListAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
            super(context, payloadIntents, null, rList, launchedFromUid, filterLastUsed);
            this.mServiceTargets = new ArrayList<ChooserTargetInfo>();
            this.mCallerTargets = new ArrayList<ResolverActivity.TargetInfo>();
            this.mLateFee = 1.0f;
            this.mBaseTargetComparator = new BaseChooserTargetComparator();
            if (initialIntents != null) {
                PackageManager pm = ChooserActivity.this.getPackageManager();
                for (int i = 0; i < initialIntents.length; ++i) {
                    Intent ii = initialIntents[i];
                    if (ii == null) continue;
                    ActivityInfo ai = ii.resolveActivityInfo(pm, 0);
                    if (ai == null) {
                        Log.w(ChooserActivity.TAG, "No activity found for " + ii);
                        continue;
                    }
                    ResolveInfo ri = new ResolveInfo();
                    ri.activityInfo = ai;
                    UserManager userManager = (UserManager)ChooserActivity.this.getSystemService("user");
                    if (ii instanceof LabeledIntent) {
                        LabeledIntent li = (LabeledIntent)ii;
                        ri.resolvePackageName = li.getSourcePackage();
                        ri.labelRes = li.getLabelResource();
                        ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                        ri.iconResourceId = ri.icon = li.getIconResource();
                    }
                    if (userManager.isManagedProfile()) {
                        ri.noResourceId = true;
                        ri.icon = 0;
                    }
                    this.mCallerTargets.add(new ResolverActivity.DisplayResolveInfo(ii, ri, ri.loadLabel(pm), null, ii));
                }
            }
        }

        @Override
        public boolean showsExtendedInfo(ResolverActivity.TargetInfo info) {
            return this.hasExtendedInfo();
        }

        @Override
        public View onCreateView(ViewGroup parent) {
            return this.mInflater.inflate(17367229, parent, false);
        }

        @Override
        public void onListRebuilt() {
            if (this.mServiceTargets != null) {
                this.pruneServiceTargets();
            }
        }

        @Override
        public boolean shouldGetResolvedFilter() {
            return true;
        }

        @Override
        public int getCount() {
            return super.getCount() + this.getServiceTargetCount() + this.getCallerTargetCount();
        }

        @Override
        public int getUnfilteredCount() {
            return super.getUnfilteredCount() + this.getServiceTargetCount() + this.getCallerTargetCount();
        }

        public int getCallerTargetCount() {
            return this.mCallerTargets.size();
        }

        public int getServiceTargetCount() {
            return Math.min(this.mServiceTargets.size(), 8);
        }

        public int getStandardTargetCount() {
            return super.getCount();
        }

        public int getPositionTargetType(int position) {
            int offset = 0;
            int callerTargetCount = this.getCallerTargetCount();
            if (position < callerTargetCount) {
                return 0;
            }
            int serviceTargetCount = this.getServiceTargetCount();
            if (position - (offset += callerTargetCount) < serviceTargetCount) {
                return 1;
            }
            int standardTargetCount = super.getCount();
            if (position - (offset += serviceTargetCount) < standardTargetCount) {
                return 2;
            }
            return -1;
        }

        @Override
        public ResolverActivity.TargetInfo getItem(int position) {
            return this.targetInfoForPosition(position, true);
        }

        @Override
        public ResolverActivity.TargetInfo targetInfoForPosition(int position, boolean filtered) {
            int offset = 0;
            int callerTargetCount = this.getCallerTargetCount();
            if (position < callerTargetCount) {
                return this.mCallerTargets.get(position);
            }
            int serviceTargetCount = this.getServiceTargetCount();
            if (position - (offset += callerTargetCount) < serviceTargetCount) {
                return this.mServiceTargets.get(position - offset);
            }
            return filtered ? super.getItem(position - offset) : this.getDisplayInfoAt(position - (offset += serviceTargetCount));
        }

        public void addServiceResults(ResolverActivity.DisplayResolveInfo origTarget, List<ChooserTarget> targets) {
            float parentScore = this.getScore(origTarget);
            Collections.sort(targets, this.mBaseTargetComparator);
            float lastScore = 0.0f;
            int N = targets.size();
            for (int i = 0; i < N; ++i) {
                ChooserTarget target = targets.get(i);
                float targetScore = target.getScore();
                targetScore *= parentScore;
                targetScore *= this.mLateFee;
                if (i > 0 && targetScore >= lastScore) {
                    targetScore = lastScore * 0.95f;
                }
                this.insertServiceTarget(new ChooserTargetInfo(origTarget, target, targetScore));
                lastScore = targetScore;
            }
            this.mLateFee *= 0.95f;
            this.notifyDataSetChanged();
        }

        private void insertServiceTarget(ChooserTargetInfo chooserTargetInfo) {
            float newScore = chooserTargetInfo.getModifiedScore();
            int N = this.mServiceTargets.size();
            for (int i = 0; i < N; ++i) {
                ChooserTargetInfo serviceTarget = this.mServiceTargets.get(i);
                if (!(newScore > serviceTarget.getModifiedScore())) continue;
                this.mServiceTargets.add(i, chooserTargetInfo);
                return;
            }
            this.mServiceTargets.add(chooserTargetInfo);
        }

        private void pruneServiceTargets() {
            for (int i = this.mServiceTargets.size() - 1; i >= 0; --i) {
                ChooserTargetInfo cti = this.mServiceTargets.get(i);
                if (this.hasResolvedTarget(cti.getResolveInfo())) continue;
                this.mServiceTargets.remove(i);
            }
        }
    }

    final class ChooserTargetInfo
    implements ResolverActivity.TargetInfo {
        private final ResolverActivity.DisplayResolveInfo mSourceInfo;
        private final ResolveInfo mBackupResolveInfo;
        private final ChooserTarget mChooserTarget;
        private Drawable mBadgeIcon = null;
        private CharSequence mBadgeContentDescription;
        private Drawable mDisplayIcon;
        private final Intent mFillInIntent;
        private final int mFillInFlags;
        private final float mModifiedScore;

        public ChooserTargetInfo(ResolverActivity.DisplayResolveInfo sourceInfo, ChooserTarget chooserTarget, float modifiedScore) {
            Icon icon;
            ActivityInfo ai;
            ResolveInfo ri;
            this.mSourceInfo = sourceInfo;
            this.mChooserTarget = chooserTarget;
            this.mModifiedScore = modifiedScore;
            if (sourceInfo != null && (ri = sourceInfo.getResolveInfo()) != null && (ai = ri.activityInfo) != null && ai.applicationInfo != null) {
                PackageManager pm = ChooserActivity.this.getPackageManager();
                this.mBadgeIcon = pm.getApplicationIcon(ai.applicationInfo);
                this.mBadgeContentDescription = pm.getApplicationLabel(ai.applicationInfo);
            }
            this.mDisplayIcon = (icon = chooserTarget.getIcon()) != null ? icon.loadDrawable(ChooserActivity.this) : null;
            this.mBackupResolveInfo = sourceInfo != null ? null : ChooserActivity.this.getPackageManager().resolveActivity(this.getResolvedIntent(), 0);
            this.mFillInIntent = null;
            this.mFillInFlags = 0;
        }

        private ChooserTargetInfo(ChooserTargetInfo other, Intent fillInIntent, int flags) {
            this.mSourceInfo = other.mSourceInfo;
            this.mBackupResolveInfo = other.mBackupResolveInfo;
            this.mChooserTarget = other.mChooserTarget;
            this.mBadgeIcon = other.mBadgeIcon;
            this.mBadgeContentDescription = other.mBadgeContentDescription;
            this.mDisplayIcon = other.mDisplayIcon;
            this.mFillInIntent = fillInIntent;
            this.mFillInFlags = flags;
            this.mModifiedScore = other.mModifiedScore;
        }

        public float getModifiedScore() {
            return this.mModifiedScore;
        }

        @Override
        public Intent getResolvedIntent() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedIntent();
            }
            return ChooserActivity.this.getTargetIntent();
        }

        @Override
        public ComponentName getResolvedComponentName() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedComponentName();
            }
            if (this.mBackupResolveInfo != null) {
                return new ComponentName(this.mBackupResolveInfo.activityInfo.packageName, this.mBackupResolveInfo.activityInfo.name);
            }
            return null;
        }

        private Intent getBaseIntentToSend() {
            Intent result;
            Intent intent = result = this.mSourceInfo != null ? this.mSourceInfo.getResolvedIntent() : ChooserActivity.this.getTargetIntent();
            if (result == null) {
                Log.e(ChooserActivity.TAG, "ChooserTargetInfo: no base intent available to send");
            } else {
                result = new Intent(result);
                if (this.mFillInIntent != null) {
                    result.fillIn(this.mFillInIntent, this.mFillInFlags);
                }
                result.fillIn(ChooserActivity.this.mReferrerFillInIntent, 0);
            }
            return result;
        }

        @Override
        public boolean start(Activity activity, Bundle options) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        @Override
        public boolean startAsCaller(Activity activity, Bundle options, int userId) {
            Intent intent = this.getBaseIntentToSend();
            if (intent == null) {
                return false;
            }
            intent.setComponent(this.mChooserTarget.getComponentName());
            intent.putExtras(this.mChooserTarget.getIntentExtras());
            activity.startActivityAsCaller(intent, options, true, userId);
            return true;
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle options, UserHandle user) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return this.mSourceInfo != null ? this.mSourceInfo.getResolveInfo() : this.mBackupResolveInfo;
        }

        @Override
        public CharSequence getDisplayLabel() {
            return this.mChooserTarget.getTitle();
        }

        @Override
        public CharSequence getExtendedInfo() {
            return this.mSourceInfo != null ? this.mSourceInfo.getExtendedInfo() : null;
        }

        @Override
        public Drawable getDisplayIcon() {
            return this.mDisplayIcon;
        }

        @Override
        public Drawable getBadgeIcon() {
            return this.mBadgeIcon;
        }

        @Override
        public CharSequence getBadgeContentDescription() {
            return this.mBadgeContentDescription;
        }

        @Override
        public ResolverActivity.TargetInfo cloneFilledIn(Intent fillInIntent, int flags) {
            return new ChooserTargetInfo(this, fillInIntent, flags);
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            ArrayList<Intent> results = new ArrayList<Intent>();
            if (this.mSourceInfo != null) {
                results.add(this.mSourceInfo.getAllSourceIntents().get(0));
            }
            return results;
        }
    }
}

