/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserManager;
import android.util.Slog;
import android.widget.Toast;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverActivity;
import java.util.List;

public class IntentForwarderActivity
extends Activity {
    public static String TAG = "IntentForwarderActivity";
    public static String FORWARD_INTENT_TO_USER_OWNER = "com.android.internal.app.ForwardIntentToUserOwner";
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        int targetUserId;
        int userMessageId;
        super.onCreate(savedInstanceState);
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_USER_OWNER)) {
            userMessageId = 17040423;
            targetUserId = 0;
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessageId = 17040424;
            targetUserId = this.getManagedProfile();
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessageId = -1;
            targetUserId = -10000;
        }
        if (targetUserId == -10000) {
            this.finish();
            return;
        }
        Intent newIntent = new Intent(intentReceived);
        newIntent.setComponent(null);
        newIntent.setPackage(null);
        newIntent.addFlags(0x3000000);
        int callingUserId = this.getUserId();
        if (this.canForward(newIntent, targetUserId)) {
            if (newIntent.getAction().equals("android.intent.action.CHOOSER")) {
                Intent innerIntent = (Intent)newIntent.getParcelableExtra("android.intent.extra.INTENT");
                innerIntent.prepareToLeaveUser(callingUserId);
            } else {
                newIntent.prepareToLeaveUser(callingUserId);
            }
            ResolveInfo ri = this.getPackageManager().resolveActivityAsUser(newIntent, 65536, targetUserId);
            boolean shouldShowDisclosure = ri == null || ri.activityInfo == null || !"android".equals(ri.activityInfo.packageName) || !ResolverActivity.class.getName().equals(ri.activityInfo.name) && !ChooserActivity.class.getName().equals(ri.activityInfo.name);
            try {
                this.startActivityAsCaller(newIntent, null, false, targetUserId);
            }
            catch (RuntimeException e) {
                int launchedFromUid = -1;
                String launchedFromPackage = "?";
                try {
                    launchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
                    launchedFromPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
                }
                catch (RemoteException ignored) {
                    // empty catch block
                }
                Slog.wtf(TAG, "Unable to launch as UID " + launchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
            }
            if (shouldShowDisclosure) {
                Toast.makeText((Context)this, this.getString(userMessageId), 1).show();
            }
        } else {
            Slog.wtf(TAG, "the intent: " + newIntent + "cannot be forwarded from user " + callingUserId + " to user " + targetUserId);
        }
        this.finish();
    }

    boolean canForward(Intent intent, int targetUserId) {
        IPackageManager ipm = AppGlobals.getPackageManager();
        if (intent.getAction().equals("android.intent.action.CHOOSER")) {
            if (intent.hasExtra("android.intent.extra.INITIAL_INTENTS")) {
                Slog.wtf(TAG, "An chooser intent with extra initial intents cannot be forwarded to a different user");
                return false;
            }
            if (intent.hasExtra("android.intent.extra.REPLACEMENT_EXTRAS")) {
                Slog.wtf(TAG, "A chooser intent with replacement extras cannot be forwarded to a different user");
                return false;
            }
            intent = (Intent)intent.getParcelableExtra("android.intent.extra.INTENT");
        }
        String resolvedType = intent.resolveTypeIfNeeded(this.getContentResolver());
        if (intent.getSelector() != null) {
            intent = intent.getSelector();
        }
        try {
            return ipm.canForwardTo(intent, resolvedType, this.getUserId(), targetUserId);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
            return false;
        }
    }

    private int getManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        List<UserInfo> relatedUsers = userManager.getProfiles(0);
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return userInfo.id;
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return -10000;
    }
}

