/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class NetInitiatedActivity
extends AlertActivity
implements DialogInterface.OnClickListener {
    private static final String TAG = "NetInitiatedActivity";
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    private static final int POSITIVE_BUTTON = -1;
    private static final int NEGATIVE_BUTTON = -2;
    private static final int GPS_NO_RESPONSE_TIME_OUT = 1;
    private int notificationId = -1;
    private int timeout = -1;
    private int default_response = -1;
    private int default_response_timeout = 6;
    private BroadcastReceiver mNetInitiatedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d(NetInitiatedActivity.TAG, "NetInitiatedReceiver onReceive: " + intent.getAction());
            if (intent.getAction() == "android.intent.action.NETWORK_INITIATED_VERIFY") {
                NetInitiatedActivity.this.handleNIVerify(intent);
            }
        }
    };
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    if (NetInitiatedActivity.this.notificationId != -1) {
                        NetInitiatedActivity.this.sendUserResponse(NetInitiatedActivity.this.default_response);
                    }
                    NetInitiatedActivity.this.finish();
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        AlertController.AlertParams p = this.mAlertParams;
        Context context = this.getApplicationContext();
        p.mTitle = intent.getStringExtra("title");
        p.mMessage = intent.getStringExtra("message");
        p.mPositiveButtonText = String.format(context.getString(17040464), new Object[0]);
        p.mPositiveButtonListener = this;
        p.mNegativeButtonText = String.format(context.getString(17040465), new Object[0]);
        p.mNegativeButtonListener = this;
        this.notificationId = intent.getIntExtra("notif_id", -1);
        this.timeout = intent.getIntExtra("timeout", this.default_response_timeout);
        this.default_response = intent.getIntExtra("default_resp", 1);
        Log.d(TAG, "onCreate() : notificationId: " + this.notificationId + " timeout: " + this.timeout + " default_response:" + this.default_response);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), this.timeout * 1000);
        this.setupAlert();
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume");
        this.registerReceiver(this.mNetInitiatedReceiver, new IntentFilter("android.intent.action.NETWORK_INITIATED_VERIFY"));
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d(TAG, "onPause");
        this.unregisterReceiver(this.mNetInitiatedReceiver);
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            this.sendUserResponse(1);
        }
        if (which == -2) {
            this.sendUserResponse(2);
        }
        this.finish();
        this.notificationId = -1;
    }

    private void sendUserResponse(int response) {
        Log.d(TAG, "sendUserResponse, response: " + response);
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        locationManager.sendNiResponse(this.notificationId, response);
    }

    private void handleNIVerify(Intent intent) {
        int notifId;
        this.notificationId = notifId = intent.getIntExtra("notif_id", -1);
        Log.d(TAG, "handleNIVerify action: " + intent.getAction());
    }

    private void showNIError() {
        Toast.makeText((Context)this, "NI error", 1).show();
    }
}

