/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.os.Bundle;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;

public class PlatLogoActivity
extends Activity {
    FrameLayout mLayout;
    int mTapCount;
    int mKeyCount;
    PathInterpolator mInterpolator = new PathInterpolator(0.0f, 0.0f, 0.5f, 1.0f);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mLayout = new FrameLayout(this);
        this.setContentView(this.mLayout);
    }

    @Override
    public void onAttachedToWindow() {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        final float dp = dm.density;
        int size = (int)(Math.min((float)Math.min(dm.widthPixels, dm.heightPixels), 600.0f * dp) - 100.0f * dp);
        final View im = new View(this);
        im.setTranslationZ(20.0f);
        im.setScaleX(0.5f);
        im.setScaleY(0.5f);
        im.setAlpha(0.0f);
        im.setOutlineProvider(new ViewOutlineProvider(){

            @Override
            public void getOutline(View view, Outline outline) {
                int pad = (int)(8.0f * dp);
                outline.setOval(pad, pad, view.getWidth() - pad, view.getHeight() - pad);
            }
        });
        float hue = (float)Math.random();
        final Paint bgPaint = new Paint();
        bgPaint.setColor(Color.HSBtoColor(hue, 0.4f, 1.0f));
        final Paint fgPaint = new Paint();
        fgPaint.setColor(Color.HSBtoColor(hue, 0.5f, 1.0f));
        final Drawable M = this.getDrawable(17302841);
        Drawable platlogo = new Drawable(){

            @Override
            public void setAlpha(int alpha) {
            }

            @Override
            public void setColorFilter(ColorFilter colorFilter) {
            }

            @Override
            public int getOpacity() {
                return -3;
            }

            @Override
            public void draw(Canvas c) {
                float r = (float)c.getWidth() / 2.0f;
                c.drawCircle(r, r, r, bgPaint);
                c.drawArc(0.0f, 0.0f, 2.0f * r, 2.0f * r, 135.0f, 180.0f, false, fgPaint);
                M.setBounds(0, 0, c.getWidth(), c.getHeight());
                M.draw(c);
            }
        };
        im.setBackground(new RippleDrawable(ColorStateList.valueOf(-1), platlogo, null));
        im.setOutlineProvider(new ViewOutlineProvider(){

            @Override
            public void getOutline(View view, Outline outline) {
                outline.setOval(0, 0, view.getWidth(), view.getHeight());
            }
        });
        im.setClickable(true);
        im.setOnClickListener(new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                if (PlatLogoActivity.this.mTapCount == 0) {
                    PlatLogoActivity.this.showMarshmallow(im);
                }
                im.setOnLongClickListener(new View.OnLongClickListener(){

                    @Override
                    public boolean onLongClick(View v) {
                        if (PlatLogoActivity.this.mTapCount < 5) {
                            return false;
                        }
                        ContentResolver cr = PlatLogoActivity.this.getContentResolver();
                        if (Settings.System.getLong(cr, "egg_mode", 0L) == 0L) {
                            try {
                                Settings.System.putLong(cr, "egg_mode", System.currentTimeMillis());
                            }
                            catch (RuntimeException e) {
                                Log.e("PlatLogoActivity", "Can't write settings", e);
                            }
                        }
                        im.post(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    PlatLogoActivity.this.startActivity(new Intent("android.intent.action.MAIN").setFlags(0x10808000).addCategory("com.android.internal.category.PLATLOGO"));
                                }
                                catch (ActivityNotFoundException ex) {
                                    Log.e("PlatLogoActivity", "No more eggs.");
                                }
                                PlatLogoActivity.this.finish();
                            }
                        });
                        return true;
                    }
                });
                ++PlatLogoActivity.this.mTapCount;
            }
        });
        im.setFocusable(true);
        im.requestFocus();
        im.setOnKeyListener(new View.OnKeyListener(){

            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode != 4 && event.getAction() == 0) {
                    if (PlatLogoActivity.this.mKeyCount == 0) {
                        PlatLogoActivity.this.showMarshmallow(im);
                    }
                    ++PlatLogoActivity.this.mKeyCount;
                    if (PlatLogoActivity.this.mKeyCount > 2) {
                        if (PlatLogoActivity.this.mTapCount > 5) {
                            im.performLongClick();
                        } else {
                            im.performClick();
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        this.mLayout.addView(im, new FrameLayout.LayoutParams(size, size, 17));
        im.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).setInterpolator(this.mInterpolator).setDuration(500L).setStartDelay(800L).start();
    }

    public void showMarshmallow(View im) {
        Drawable fg = this.getDrawable(17302840);
        fg.setBounds(0, 0, im.getWidth(), im.getHeight());
        fg.setAlpha(0);
        im.getOverlay().add(fg);
        ObjectAnimator fadeIn = ObjectAnimator.ofInt((Object)fg, "alpha", 255);
        ((Animator)fadeIn).setInterpolator(this.mInterpolator);
        ((Animator)fadeIn).setDuration(300L);
        ((Animator)fadeIn).start();
    }
}

