/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import com.android.internal.app.ResolverActivity;
import java.text.Collator;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    private static final String TAG = "ResolverComparator";
    private static final boolean DEBUG = false;
    private static final long USAGE_STATS_PERIOD = 1209600000L;
    private static final long RECENCY_TIME_PERIOD = 43200000L;
    private static final float RECENCY_MULTIPLIER = 3.0f;
    private final Collator mCollator;
    private final boolean mHttp;
    private final PackageManager mPm;
    private final UsageStatsManager mUsm;
    private final Map<String, UsageStats> mStats;
    private final long mCurrentTime;
    private final long mSinceTime;
    private final LinkedHashMap<ComponentName, ScoredTarget> mScoredTargets = new LinkedHashMap();
    private final String mReferrerPackage;

    public ResolverComparator(Context context, Intent intent, String referrerPackage) {
        this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mReferrerPackage = referrerPackage;
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mCurrentTime = System.currentTimeMillis();
        this.mSinceTime = this.mCurrentTime - 1209600000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(this.mSinceTime, this.mCurrentTime);
    }

    public void compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.mScoredTargets.clear();
        long recentSinceTime = this.mCurrentTime - 43200000L;
        long mostRecentlyUsedTime = recentSinceTime + 1L;
        long mostTimeSpent = 1L;
        int mostLaunched = 1;
        for (ResolverActivity.ResolvedComponentInfo resolvedComponentInfo : targets) {
            long timeSpent;
            ScoredTarget scoredTarget = new ScoredTarget(resolvedComponentInfo.getResolveInfoAt((int)0).activityInfo);
            this.mScoredTargets.put(resolvedComponentInfo.name, scoredTarget);
            UsageStats pkStats = this.mStats.get(resolvedComponentInfo.name.getPackageName());
            if (pkStats == null) continue;
            if (!resolvedComponentInfo.name.getPackageName().equals(this.mReferrerPackage) && !ResolverComparator.isPersistentProcess(resolvedComponentInfo)) {
                long lastTimeUsed;
                scoredTarget.lastTimeUsed = lastTimeUsed = pkStats.getLastTimeUsed();
                if (lastTimeUsed > mostRecentlyUsedTime) {
                    mostRecentlyUsedTime = lastTimeUsed;
                }
            }
            scoredTarget.timeSpent = timeSpent = pkStats.getTotalTimeInForeground();
            if (timeSpent > mostTimeSpent) {
                mostTimeSpent = timeSpent;
            }
            int launched = pkStats.mLaunchCount;
            scoredTarget.launchCount = launched;
            if (launched <= mostLaunched) continue;
            mostLaunched = launched;
        }
        for (ScoredTarget scoredTarget : this.mScoredTargets.values()) {
            float recency = (float)Math.max(scoredTarget.lastTimeUsed - recentSinceTime, 0L) / (float)(mostRecentlyUsedTime - recentSinceTime);
            float recencyScore = recency * recency * 3.0f;
            float usageTimeScore = (float)scoredTarget.timeSpent / (float)mostTimeSpent;
            float launchCountScore = (float)scoredTarget.launchCount / (float)mostLaunched;
            scoredTarget.score = recencyScore + usageTimeScore + launchCountScore;
        }
    }

    static boolean isPersistentProcess(ResolverActivity.ResolvedComponentInfo rci) {
        if (rci != null && rci.getCount() > 0) {
            return (rci.getResolveInfoAt((int)0).activityInfo.applicationInfo.flags & 8) != 0;
        }
        return false;
    }

    @Override
    public int compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        CharSequence sb;
        CharSequence sa;
        boolean rhsSpecific;
        boolean lhsSpecific;
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        if (lhs.targetUserId != -2) {
            return 1;
        }
        if (this.mHttp && (lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match)) != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
            return lhsSpecific ? -1 : 1;
        }
        if (this.mStats != null) {
            ScoredTarget lhsTarget = this.mScoredTargets.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
            ScoredTarget rhsTarget = this.mScoredTargets.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
            float diff = rhsTarget.score - lhsTarget.score;
            if (diff != 0.0f) {
                return diff > 0.0f ? 1 : -1;
            }
        }
        if ((sa = lhs.loadLabel(this.mPm)) == null) {
            sa = lhs.activityInfo.name;
        }
        if ((sb = rhs.loadLabel(this.mPm)) == null) {
            sb = rhs.activityInfo.name;
        }
        return this.mCollator.compare(sa.toString().trim(), sb.toString().trim());
    }

    public float getScore(ComponentName name) {
        ScoredTarget target = this.mScoredTargets.get(name);
        if (target != null) {
            return target.score;
        }
        return 0.0f;
    }

    static class ScoredTarget {
        public final ComponentInfo componentInfo;
        public float score;
        public long lastTimeUsed;
        public long timeSpent;
        public long launchCount;

        public ScoredTarget(ComponentInfo ci) {
            this.componentInfo = ci;
        }

        public String toString() {
            return "ScoredTarget{" + this.componentInfo + " score: " + this.score + " lastTimeUsed: " + this.lastTimeUsed + " timeSpent: " + this.timeSpent + " launchCount: " + this.launchCount + "}";
        }
    }
}

