/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.os.Bundle;
import android.os.UserManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;

public class RestrictionsPinActivity
extends AlertActivity
implements View.OnClickListener,
TextWatcher,
TextView.OnEditorActionListener {
    protected UserManager mUserManager;
    protected boolean mHasRestrictionsPin;
    protected EditText mPinText;
    protected TextView mPinErrorMessage;
    private Button mOkButton;
    private Button mCancelButton;
    private Runnable mCountdownRunnable = new Runnable(){

        @Override
        public void run() {
            if (RestrictionsPinActivity.this.updatePinTimer(-1)) {
                RestrictionsPinActivity.this.mPinErrorMessage.setVisibility(4);
            }
        }
    };

    @Override
    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mUserManager = (UserManager)this.getSystemService("user");
        this.mHasRestrictionsPin = this.mUserManager.hasRestrictionsChallenge();
        this.initUi();
        this.setupAlert();
    }

    protected void initUi() {
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mTitle = this.getString(17040982);
        LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
        ap.mView = inflater.inflate(17367216, null);
        this.mPinErrorMessage = (TextView)ap.mView.findViewById(16909160);
        this.mPinText = (EditText)ap.mView.findViewById(16909159);
        this.mOkButton = (Button)ap.mView.findViewById(16909162);
        this.mCancelButton = (Button)ap.mView.findViewById(16909161);
        this.mPinText.addTextChangedListener(this);
        this.mOkButton.setOnClickListener(this);
        this.mCancelButton.setOnClickListener(this);
    }

    protected boolean verifyingPin() {
        return true;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.setPositiveButtonState(false);
        boolean hasPin = this.mUserManager.hasRestrictionsChallenge();
        if (hasPin) {
            this.mPinErrorMessage.setVisibility(4);
            this.mPinText.setOnEditorActionListener(this);
            this.updatePinTimer(-1);
        } else if (this.verifyingPin()) {
            this.setResult(-1);
            this.finish();
        }
    }

    protected void setPositiveButtonState(boolean enabled) {
        this.mOkButton.setEnabled(enabled);
    }

    private boolean updatePinTimer(int pinTimerMs) {
        boolean enableInput;
        if (pinTimerMs < 0) {
            pinTimerMs = this.mUserManager.checkRestrictionsChallenge(null);
        }
        if (pinTimerMs >= 200) {
            if (pinTimerMs <= 60000) {
                int seconds = (pinTimerMs + 200) / 1000;
                String formatString = this.getResources().getQuantityString(18087960, seconds);
                this.mPinErrorMessage.setText(String.format(formatString, seconds));
            } else {
                this.mPinErrorMessage.setText(17040991);
            }
            enableInput = false;
            this.mPinErrorMessage.setVisibility(0);
            this.mPinText.setText("");
            this.mPinText.postDelayed(this.mCountdownRunnable, Math.min(1000, pinTimerMs));
        } else {
            enableInput = true;
            this.mPinErrorMessage.setText(17040984);
        }
        this.mPinText.setEnabled(enableInput);
        this.setPositiveButtonState(enableInput);
        return enableInput;
    }

    protected void performPositiveButtonAction() {
        int result = this.mUserManager.checkRestrictionsChallenge(this.mPinText.getText().toString());
        if (result == -1) {
            this.setResult(-1);
            this.finish();
        } else if (result >= 0) {
            this.mPinErrorMessage.setText(17040984);
            this.mPinErrorMessage.setVisibility(0);
            this.updatePinTimer(result);
            this.mPinText.setText("");
        }
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    @Override
    public void onTextChanged(CharSequence s, int start, int before, int count) {
        Editable pin = this.mPinText.getText();
        this.setPositiveButtonState(pin != null && pin.length() >= 4);
    }

    @Override
    public void afterTextChanged(Editable s) {
    }

    @Override
    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        this.performPositiveButtonAction();
        return true;
    }

    @Override
    public void onClick(View v) {
        if (v == this.mOkButton) {
            this.performPositiveButtonAction();
        } else if (v == this.mCancelButton) {
            this.setResult(0);
            this.finish();
        }
    }
}

