/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Slog;

public class ShutdownActivity
extends Activity {
    private static final String TAG = "ShutdownActivity";
    private boolean mReboot;
    private boolean mConfirm;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mReboot = "android.intent.action.REBOOT".equals(intent.getAction());
        this.mConfirm = intent.getBooleanExtra("android.intent.extra.KEY_CONFIRM", false);
        Slog.i(TAG, "onCreate(): confirm=" + this.mConfirm);
        Thread thr = new Thread(TAG){

            @Override
            public void run() {
                IPowerManager pm = IPowerManager.Stub.asInterface(ServiceManager.getService("power"));
                try {
                    if (ShutdownActivity.this.mReboot) {
                        pm.reboot(ShutdownActivity.this.mConfirm, null, false);
                    } else {
                        pm.shutdown(ShutdownActivity.this.mConfirm, false);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        };
        thr.start();
        this.finish();
        try {
            thr.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

