/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.content.NativeLibraryHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;

public class PackageHelper {
    public static final int RECOMMEND_INSTALL_INTERNAL = 1;
    public static final int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static final int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static final int RECOMMEND_FAILED_INVALID_APK = -2;
    public static final int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static final int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static final int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    public static final int RECOMMEND_FAILED_INVALID_URI = -6;
    public static final int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    private static final boolean localLOGV = false;
    private static final String TAG = "PackageHelper";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;

    public static IMountService getMountService() throws RemoteException {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IMountService.Stub.asInterface(service);
        }
        Log.e(TAG, "Can't get mount service");
        throw new RemoteException("Could not contact mount service");
    }

    public static String createSdDir(long sizeBytes, String cid, String sdEncKey, int uid, boolean isExternal) {
        int sizeMb = (int)((sizeBytes + 0x100000L) / 0x100000L) + 1;
        try {
            IMountService mountService = PackageHelper.getMountService();
            int rc = mountService.createSecureContainer(cid, sizeMb, "ext4", sdEncKey, uid, isExternal);
            if (rc != 0) {
                Log.e(TAG, "Failed to create secure container " + cid);
                return null;
            }
            String cachePath = mountService.getSecureContainerPath(cid);
            return cachePath;
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static boolean resizeSdDir(long sizeBytes, String cid, String sdEncKey) {
        int sizeMb = (int)((sizeBytes + 0x100000L) / 0x100000L) + 1;
        try {
            IMountService mountService = PackageHelper.getMountService();
            int rc = mountService.resizeSecureContainer(cid, sizeMb, sdEncKey);
            if (rc == 0) {
                return true;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
        }
        Log.e(TAG, "Failed to create secure container " + cid);
        return false;
    }

    public static String mountSdDir(String cid, String key, int ownerUid) {
        return PackageHelper.mountSdDir(cid, key, ownerUid, true);
    }

    public static String mountSdDir(String cid, String key, int ownerUid, boolean readOnly) {
        try {
            int rc = PackageHelper.getMountService().mountSecureContainer(cid, key, ownerUid, readOnly);
            if (rc != 0) {
                Log.i(TAG, "Failed to mount container " + cid + " rc : " + rc);
                return null;
            }
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return null;
        }
    }

    public static boolean unMountSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().unmountSecureContainer(cid, true);
            if (rc != 0) {
                Log.e(TAG, "Failed to unmount " + cid + " with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "MountService running?");
            return false;
        }
    }

    public static boolean renameSdDir(String oldId, String newId) {
        try {
            int rc = PackageHelper.getMountService().renameSecureContainer(oldId, newId);
            if (rc != 0) {
                Log.e(TAG, "Failed to rename " + oldId + " to " + newId + "with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.i(TAG, "Failed ot rename  " + oldId + " to " + newId + " with exception : " + e);
            return false;
        }
    }

    public static String getSdDir(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static String getSdFilesystem(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerFilesystemPath(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    public static boolean finalizeSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().finalizeSecureContainer(cid);
            if (rc != 0) {
                Log.i(TAG, "Failed to finalize container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to finalize container " + cid + " with exception " + e);
            return false;
        }
    }

    public static boolean destroySdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().destroySecureContainer(cid, true);
            if (rc != 0) {
                Log.i(TAG, "Failed to destroy container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to destroy container " + cid + " with exception " + e);
            return false;
        }
    }

    public static String[] getSecureContainerList() {
        try {
            return PackageHelper.getMountService().getSecureContainerList();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to get secure container list with exception" + e);
            return null;
        }
    }

    public static boolean isContainerMounted(String cid) {
        try {
            return PackageHelper.getMountService().isSecureContainerMounted(cid);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to find out if container " + cid + " mounted");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long extractPublicFiles(File apkFile, File publicZipFile) throws IOException {
        ZipOutputStream publicZipOutStream;
        FileOutputStream fstr;
        if (publicZipFile == null) {
            fstr = null;
            publicZipOutStream = null;
        } else {
            fstr = new FileOutputStream(publicZipFile);
            publicZipOutStream = new ZipOutputStream(fstr);
            Log.d(TAG, "Extracting " + apkFile + " to " + publicZipFile);
        }
        long size = 0L;
        try {
            ZipFile privateZip = new ZipFile(apkFile.getAbsolutePath());
            try {
                for (ZipEntry zipEntry : Collections.list(privateZip.entries())) {
                    String zipEntryName = zipEntry.getName();
                    if (!"AndroidManifest.xml".equals(zipEntryName) && !"resources.arsc".equals(zipEntryName) && !zipEntryName.startsWith("res/")) continue;
                    size += zipEntry.getSize();
                    if (publicZipFile == null) continue;
                    PackageHelper.copyZipEntry(zipEntry, privateZip, publicZipOutStream);
                }
            }
            finally {
                try {
                    privateZip.close();
                }
                catch (IOException e) {}
            }
            if (publicZipFile != null) {
                publicZipOutStream.finish();
                publicZipOutStream.flush();
                FileUtils.sync(fstr);
                publicZipOutStream.close();
                FileUtils.setPermissions(publicZipFile.getAbsolutePath(), 420, -1, -1);
            }
        }
        finally {
            IoUtils.closeQuietly(publicZipOutStream);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyZipEntry(ZipEntry zipEntry, ZipFile inZipFile, ZipOutputStream outZipStream) throws IOException {
        byte[] buffer = new byte[4096];
        ZipEntry newEntry = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
        outZipStream.putNextEntry(newEntry);
        InputStream data = inZipFile.getInputStream(zipEntry);
        try {
            int num;
            while ((num = data.read(buffer)) > 0) {
                outZipStream.write(buffer, 0, num);
            }
            outZipStream.flush();
        }
        finally {
            IoUtils.closeQuietly(data);
        }
    }

    public static boolean fixSdPermissions(String cid, int gid, String filename) {
        try {
            int rc = PackageHelper.getMountService().fixPermissionsSecureContainer(cid, gid, filename);
            if (rc != 0) {
                Log.i(TAG, "Failed to fixperms container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to fixperms container " + cid + " with exception " + e);
            return false;
        }
    }

    public static String resolveInstallVolume(Context context, String packageName, int installLocation, long sizeBytes) throws IOException {
        ApplicationInfo existingInfo = null;
        try {
            existingInfo = context.getPackageManager().getApplicationInfo(packageName, 8192);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            // empty catch block
        }
        StorageManager storageManager = context.getSystemService(StorageManager.class);
        boolean fitsOnInternal = PackageHelper.fitsOnInternal(context, sizeBytes);
        ArraySet<String> allCandidates = new ArraySet<String>();
        VolumeInfo bestCandidate = null;
        long bestCandidateAvailBytes = Long.MIN_VALUE;
        for (VolumeInfo vol : storageManager.getVolumes()) {
            if (vol.type != 1 || !vol.isMountedWritable()) continue;
            long availBytes = storageManager.getStorageBytesUntilLow(new File(vol.path));
            if (availBytes >= sizeBytes) {
                allCandidates.add(vol.fsUuid);
            }
            if (availBytes < bestCandidateAvailBytes) continue;
            bestCandidate = vol;
            bestCandidateAvailBytes = availBytes;
        }
        if (existingInfo != null && existingInfo.isSystemApp()) {
            installLocation = 1;
        }
        if (installLocation == 1) {
            if (fitsOnInternal) {
                return null;
            }
            throw new IOException("Requested internal only, but not enough space");
        }
        if (existingInfo != null) {
            if (existingInfo.volumeUuid == null && fitsOnInternal) {
                return null;
            }
            if (allCandidates.contains(existingInfo.volumeUuid)) {
                return existingInfo.volumeUuid;
            }
        }
        if (bestCandidate != null) {
            return bestCandidate.fsUuid;
        }
        if (fitsOnInternal) {
            return null;
        }
        throw new IOException("No special requests, but no room anywhere");
    }

    public static boolean fitsOnInternal(Context context, long sizeBytes) {
        File target;
        StorageManager storage = context.getSystemService(StorageManager.class);
        return sizeBytes <= storage.getStorageBytesUntilLow(target = Environment.getDataDirectory());
    }

    public static boolean fitsOnExternal(Context context, long sizeBytes) {
        StorageManager storage = context.getSystemService(StorageManager.class);
        StorageVolume primary = storage.getPrimaryVolume();
        return sizeBytes > 0L && !primary.isEmulated() && "mounted".equals(primary.getState()) && sizeBytes <= storage.getStorageBytesUntilLow(primary.getPathFile());
    }

    public static int resolveInstallLocation(Context context, String packageName, int installLocation, long sizeBytes, int installFlags) {
        boolean checkBoth;
        int prefer;
        ApplicationInfo existingInfo = null;
        try {
            existingInfo = context.getPackageManager().getApplicationInfo(packageName, 8192);
        }
        catch (PackageManager.NameNotFoundException ignored) {
            // empty catch block
        }
        if ((installFlags & 0x10) != 0) {
            prefer = 1;
            checkBoth = false;
        } else if ((installFlags & 8) != 0) {
            prefer = 2;
            checkBoth = false;
        } else if (installLocation == 1) {
            prefer = 1;
            checkBoth = false;
        } else if (installLocation == 2) {
            prefer = 2;
            checkBoth = true;
        } else if (installLocation == 0) {
            prefer = existingInfo != null ? ((existingInfo.flags & 0x40000) != 0 ? 2 : 1) : 1;
            checkBoth = true;
        } else {
            prefer = 1;
            checkBoth = false;
        }
        boolean fitsOnInternal = false;
        if (checkBoth || prefer == 1) {
            fitsOnInternal = PackageHelper.fitsOnInternal(context, sizeBytes);
        }
        boolean fitsOnExternal = false;
        if (checkBoth || prefer == 2) {
            fitsOnExternal = PackageHelper.fitsOnExternal(context, sizeBytes);
        }
        if (prefer == 1) {
            if (fitsOnInternal) {
                return 1;
            }
        } else if (prefer == 2 && fitsOnExternal) {
            return 2;
        }
        if (checkBoth) {
            if (fitsOnInternal) {
                return 1;
            }
            if (fitsOnExternal) {
                return 2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, String abiOverride) throws IOException {
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(pkg);
            long l = PackageHelper.calculateInstalledSize(pkg, handle, isForwardLocked, abiOverride);
            return l;
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
    }

    public static long calculateInstalledSize(PackageParser.PackageLite pkg, NativeLibraryHelper.Handle handle, boolean isForwardLocked, String abiOverride) throws IOException {
        long sizeBytes = 0L;
        for (String codePath : pkg.getAllCodePaths()) {
            File codeFile = new File(codePath);
            sizeBytes += codeFile.length();
            if (!isForwardLocked) continue;
            sizeBytes += PackageHelper.extractPublicFiles(codeFile, null);
        }
        return sizeBytes += NativeLibraryHelper.sumNativeBinariesWithOverride(handle, abiOverride);
    }

    public static String replaceEnd(String str, String before, String after) {
        if (!str.endsWith(before)) {
            throw new IllegalArgumentException("Expected " + str + " to end with " + before);
        }
        return str.substring(0, str.length() - before.length()) + after;
    }
}

