/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.INetInitiatedListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.telephony.PhoneNumberUtils;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.app.NetInitiatedActivity;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;

public class GpsNetInitiatedHandler {
    private static final String TAG = "GpsNetInitiatedHandler";
    private static final boolean DEBUG = true;
    private static final boolean VERBOSE = false;
    public static final String ACTION_NI_VERIFY = "android.intent.action.NETWORK_INITIATED_VERIFY";
    public static final String NI_INTENT_KEY_NOTIF_ID = "notif_id";
    public static final String NI_INTENT_KEY_TITLE = "title";
    public static final String NI_INTENT_KEY_MESSAGE = "message";
    public static final String NI_INTENT_KEY_TIMEOUT = "timeout";
    public static final String NI_INTENT_KEY_DEFAULT_RESPONSE = "default_resp";
    public static final String NI_RESPONSE_EXTRA_CMD = "send_ni_response";
    public static final String NI_EXTRA_CMD_NOTIF_ID = "notif_id";
    public static final String NI_EXTRA_CMD_RESPONSE = "response";
    public static final int GPS_NI_TYPE_VOICE = 1;
    public static final int GPS_NI_TYPE_UMTS_SUPL = 2;
    public static final int GPS_NI_TYPE_UMTS_CTRL_PLANE = 3;
    public static final int GPS_NI_TYPE_EMERGENCY_SUPL = 4;
    public static final int GPS_NI_RESPONSE_ACCEPT = 1;
    public static final int GPS_NI_RESPONSE_DENY = 2;
    public static final int GPS_NI_RESPONSE_NORESP = 3;
    public static final int GPS_NI_RESPONSE_IGNORE = 4;
    public static final int GPS_NI_NEED_NOTIFY = 1;
    public static final int GPS_NI_NEED_VERIFY = 2;
    public static final int GPS_NI_PRIVACY_OVERRIDE = 4;
    public static final int GPS_ENC_NONE = 0;
    public static final int GPS_ENC_SUPL_GSM_DEFAULT = 1;
    public static final int GPS_ENC_SUPL_UTF8 = 2;
    public static final int GPS_ENC_SUPL_UCS2 = 3;
    public static final int GPS_ENC_UNKNOWN = -1;
    private final Context mContext;
    private final TelephonyManager mTelephonyManager;
    private final PhoneStateListener mPhoneStateListener;
    private final LocationManager mLocationManager;
    private boolean mPlaySounds = false;
    private boolean mPopupImmediately = true;
    private volatile boolean mIsSuplEsEnabled;
    private volatile boolean mIsInEmergency;
    private volatile boolean mIsLocationEnabled = false;
    private final INetInitiatedListener mNetInitiatedListener;
    private static boolean mIsHexInput = true;
    private final BroadcastReceiver mBroadcastReciever = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.NEW_OUTGOING_CALL")) {
                String phoneNumber = intent.getStringExtra("android.intent.extra.PHONE_NUMBER");
                GpsNetInitiatedHandler.this.setInEmergency(PhoneNumberUtils.isEmergencyNumber(phoneNumber));
                Log.v(GpsNetInitiatedHandler.TAG, "ACTION_NEW_OUTGOING_CALL - " + GpsNetInitiatedHandler.this.getInEmergency());
            } else if (action.equals("android.location.MODE_CHANGED")) {
                GpsNetInitiatedHandler.this.updateLocationMode();
                Log.d(GpsNetInitiatedHandler.TAG, "location enabled :" + GpsNetInitiatedHandler.this.getLocationEnabled());
            }
        }
    };
    private Notification.Builder mNiNotificationBuilder;

    public GpsNetInitiatedHandler(Context context, INetInitiatedListener netInitiatedListener, boolean isSuplEsEnabled) {
        this.mContext = context;
        if (netInitiatedListener == null) {
            throw new IllegalArgumentException("netInitiatedListener is null");
        }
        this.mNetInitiatedListener = netInitiatedListener;
        this.setSuplEsEnabled(isSuplEsEnabled);
        this.mLocationManager = (LocationManager)context.getSystemService("location");
        this.updateLocationMode();
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mPhoneStateListener = new PhoneStateListener(){

            @Override
            public void onCallStateChanged(int state, String incomingNumber) {
                Log.d(GpsNetInitiatedHandler.TAG, "onCallStateChanged(): state is " + state);
                if (state == 0) {
                    GpsNetInitiatedHandler.this.setInEmergency(false);
                }
            }
        };
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        intentFilter.addAction("android.location.MODE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReciever, intentFilter);
    }

    public void setSuplEsEnabled(boolean isEnabled) {
        this.mIsSuplEsEnabled = isEnabled;
    }

    public boolean getSuplEsEnabled() {
        return this.mIsSuplEsEnabled;
    }

    public void updateLocationMode() {
        this.mIsLocationEnabled = this.mLocationManager.isProviderEnabled("gps");
    }

    public boolean getLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    public void setInEmergency(boolean isInEmergency) {
        this.mIsInEmergency = isInEmergency;
    }

    public boolean getInEmergency() {
        boolean isInEmergencyCallback = Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"));
        return this.mIsInEmergency || isInEmergencyCallback;
    }

    public void handleNiNotification(GpsNiNotification notif) {
        Log.d(TAG, "in handleNiNotification () : notificationId: " + notif.notificationId + " requestorId: " + notif.requestorId + " text: " + notif.text + " mIsSuplEsEnabled" + this.getSuplEsEnabled() + " mIsLocationEnabled" + this.getLocationEnabled());
        if (this.getSuplEsEnabled()) {
            this.handleNiInEs(notif);
        } else {
            this.handleNi(notif);
        }
    }

    private void handleNi(GpsNiNotification notif) {
        Log.d(TAG, "in handleNi () : needNotify: " + notif.needNotify + " needVerify: " + notif.needVerify + " privacyOverride: " + notif.privacyOverride + " mPopupImmediately: " + this.mPopupImmediately + " mInEmergency: " + this.getInEmergency());
        if (!this.getLocationEnabled() && !this.getInEmergency()) {
            try {
                this.mNetInitiatedListener.sendNiResponse(notif.notificationId, 4);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in sendNiResponse");
            }
        }
        if (notif.needNotify) {
            if (notif.needVerify && this.mPopupImmediately) {
                this.openNiDialog(notif);
            } else {
                this.setNiNotification(notif);
            }
        }
        if (!notif.needVerify || notif.privacyOverride) {
            try {
                this.mNetInitiatedListener.sendNiResponse(notif.notificationId, 1);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in sendNiResponse");
            }
        }
    }

    private void handleNiInEs(GpsNiNotification notif) {
        boolean isNiTypeES;
        Log.d(TAG, "in handleNiInEs () : niType: " + notif.niType + " notificationId: " + notif.notificationId);
        boolean bl = isNiTypeES = notif.niType == 4;
        if (isNiTypeES != this.getInEmergency()) {
            try {
                this.mNetInitiatedListener.sendNiResponse(notif.notificationId, 4);
            }
            catch (RemoteException e) {
                Log.e(TAG, "RemoteException in sendNiResponse");
            }
        } else {
            this.handleNi(notif);
        }
    }

    private synchronized void setNiNotification(GpsNiNotification notif) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        String title = GpsNetInitiatedHandler.getNotifTitle(notif, this.mContext);
        String message = GpsNetInitiatedHandler.getNotifMessage(notif, this.mContext);
        Log.d(TAG, "setNiNotification, notifyId: " + notif.notificationId + ", title: " + title + ", message: " + message);
        if (this.mNiNotificationBuilder == null) {
            this.mNiNotificationBuilder = new Notification.Builder(this.mContext).setSmallIcon(17303147).setWhen(0L).setOngoing(true).setAutoCancel(true).setColor(this.mContext.getColor(17170521));
        }
        if (this.mPlaySounds) {
            this.mNiNotificationBuilder.setDefaults(1);
        } else {
            this.mNiNotificationBuilder.setDefaults(0);
        }
        Intent intent = !this.mPopupImmediately ? this.getDlgIntent(notif) : new Intent();
        PendingIntent pi = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mNiNotificationBuilder.setTicker(GpsNetInitiatedHandler.getNotifTicker(notif, this.mContext)).setContentTitle(title).setContentText(message).setContentIntent(pi);
        notificationManager.notifyAsUser(null, notif.notificationId, this.mNiNotificationBuilder.build(), UserHandle.ALL);
    }

    private void openNiDialog(GpsNiNotification notif) {
        Intent intent = this.getDlgIntent(notif);
        Log.d(TAG, "openNiDialog, notifyId: " + notif.notificationId + ", requestorId: " + notif.requestorId + ", text: " + notif.text);
        this.mContext.startActivity(intent);
    }

    private Intent getDlgIntent(GpsNiNotification notif) {
        Intent intent = new Intent();
        String title = GpsNetInitiatedHandler.getDialogTitle(notif, this.mContext);
        String message = GpsNetInitiatedHandler.getDialogMessage(notif, this.mContext);
        intent.setFlags(0x10008000);
        intent.setClass(this.mContext, NetInitiatedActivity.class);
        intent.putExtra("notif_id", notif.notificationId);
        intent.putExtra(NI_INTENT_KEY_TITLE, title);
        intent.putExtra(NI_INTENT_KEY_MESSAGE, message);
        intent.putExtra(NI_INTENT_KEY_TIMEOUT, notif.timeout);
        intent.putExtra(NI_INTENT_KEY_DEFAULT_RESPONSE, notif.defaultResponse);
        Log.d(TAG, "generateIntent, title: " + title + ", message: " + message + ", timeout: " + notif.timeout);
        return intent;
    }

    static byte[] stringToByteArray(String original, boolean isHex) {
        int length = isHex ? original.length() / 2 : original.length();
        byte[] output = new byte[length];
        if (isHex) {
            for (int i = 0; i < length; ++i) {
                output[i] = (byte)Integer.parseInt(original.substring(i * 2, i * 2 + 2), 16);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                output[i] = (byte)original.charAt(i);
            }
        }
        return output;
    }

    static String decodeGSMPackedString(byte[] input) {
        String decoded;
        boolean PADDING_CHAR = false;
        int lengthBytes = input.length;
        int lengthSeptets = lengthBytes * 8 / 7;
        if (lengthBytes % 7 == 0 && lengthBytes > 0 && input[lengthBytes - 1] >> 1 == 0) {
            --lengthSeptets;
        }
        if (null == (decoded = GsmAlphabet.gsm7BitPackedToString(input, 0, lengthSeptets))) {
            Log.e(TAG, "Decoding of GSM packed string failed");
            decoded = "";
        }
        return decoded;
    }

    static String decodeUTF8String(byte[] input) {
        String decoded = "";
        try {
            decoded = new String(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        return decoded;
    }

    static String decodeUCS2String(byte[] input) {
        String decoded = "";
        try {
            decoded = new String(input, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        return decoded;
    }

    private static String decodeString(String original, boolean isHex, int coding) {
        String decoded = original;
        byte[] input = GpsNetInitiatedHandler.stringToByteArray(original, isHex);
        switch (coding) {
            case 0: {
                decoded = original;
                break;
            }
            case 1: {
                decoded = GpsNetInitiatedHandler.decodeGSMPackedString(input);
                break;
            }
            case 2: {
                decoded = GpsNetInitiatedHandler.decodeUTF8String(input);
                break;
            }
            case 3: {
                decoded = GpsNetInitiatedHandler.decodeUCS2String(input);
                break;
            }
            case -1: {
                decoded = original;
                break;
            }
            default: {
                Log.e(TAG, "Unknown encoding " + coding + " for NI text " + original);
            }
        }
        return decoded;
    }

    private static String getNotifTicker(GpsNiNotification notif, Context context) {
        String ticker = String.format(context.getString(17040461), GpsNetInitiatedHandler.decodeString(notif.requestorId, mIsHexInput, notif.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(notif.text, mIsHexInput, notif.textEncoding));
        return ticker;
    }

    private static String getNotifTitle(GpsNiNotification notif, Context context) {
        String title = String.format(context.getString(17040462), new Object[0]);
        return title;
    }

    private static String getNotifMessage(GpsNiNotification notif, Context context) {
        String message = String.format(context.getString(17040463), GpsNetInitiatedHandler.decodeString(notif.requestorId, mIsHexInput, notif.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(notif.text, mIsHexInput, notif.textEncoding));
        return message;
    }

    public static String getDialogTitle(GpsNiNotification notif, Context context) {
        return GpsNetInitiatedHandler.getNotifTitle(notif, context);
    }

    private static String getDialogMessage(GpsNiNotification notif, Context context) {
        return GpsNetInitiatedHandler.getNotifMessage(notif, context);
    }

    public static class GpsNiResponse {
        int userResponse;
        Bundle extras;
    }

    public static class GpsNiNotification {
        public int notificationId;
        public int niType;
        public boolean needNotify;
        public boolean needVerify;
        public boolean privacyOverride;
        public int timeout;
        public int defaultResponse;
        public String requestorId;
        public String text;
        public int requestorIdEncoding;
        public int textEncoding;
        public Bundle extras;
    }
}

