/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkStats;
import android.net.wifi.WifiActivityEnergyInfo;
import android.net.wifi.WifiManager;
import android.os.BatteryStats;
import android.os.Build;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFormatException;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.SignalStrength;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LogWriter;
import android.util.MutableInt;
import android.util.Printer;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.KernelCpuSpeedReader;
import com.android.internal.os.KernelUidCpuTimeReader;
import com.android.internal.os.KernelWakelockReader;
import com.android.internal.os.KernelWakelockStats;
import com.android.internal.os.PowerProfile;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public final class BatteryStatsImpl
extends BatteryStats {
    private static final String TAG = "BatteryStatsImpl";
    private static final boolean DEBUG = false;
    public static final boolean DEBUG_ENERGY = false;
    private static final boolean DEBUG_ENERGY_CPU = false;
    private static final boolean DEBUG_HISTORY = false;
    private static final boolean USE_OLD_HISTORY = false;
    private static final int MAGIC = -1166707595;
    private static final int VERSION = 130;
    private static final int MAX_HISTORY_ITEMS = 2000;
    private static final int MAX_MAX_HISTORY_ITEMS = 3000;
    private static final int MAX_WAKELOCKS_PER_UID = 100;
    private static int sNumSpeedSteps;
    private final JournaledFile mFile;
    public final AtomicFile mCheckinFile;
    public final AtomicFile mDailyFile;
    static final int MSG_UPDATE_WAKELOCKS = 1;
    static final int MSG_REPORT_POWER_CHANGE = 2;
    static final int MSG_REPORT_CHARGING = 3;
    static final long DELAY_UPDATE_WAKELOCKS = 5000L;
    private final KernelWakelockReader mKernelWakelockReader = new KernelWakelockReader();
    private final KernelWakelockStats mTmpWakelockStats = new KernelWakelockStats();
    private final KernelUidCpuTimeReader mKernelUidCpuTimeReader = new KernelUidCpuTimeReader();
    private final KernelCpuSpeedReader mKernelCpuSpeedReader = new KernelCpuSpeedReader();
    public final MyHandler mHandler;
    private final ExternalStatsSync mExternalSync;
    private BatteryCallback mCallback;
    final SparseIntArray mIsolatedUids = new SparseIntArray();
    final SparseArray<Uid> mUidStats = new SparseArray();
    final ArrayList<StopwatchTimer> mPartialTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFullTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWindowTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mDrawTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mSensorTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mWifiRunningTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFullWifiLockTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiMulticastTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mWifiScanTimers = new ArrayList();
    final SparseArray<ArrayList<StopwatchTimer>> mWifiBatchedScanTimers = new SparseArray();
    final ArrayList<StopwatchTimer> mAudioTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mVideoTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mFlashlightTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mCameraTurnedOnTimers = new ArrayList();
    final ArrayList<StopwatchTimer> mLastPartialTimers = new ArrayList();
    final TimeBase mOnBatteryTimeBase = new TimeBase();
    final TimeBase mOnBatteryScreenOffTimeBase = new TimeBase();
    boolean mDistributeWakelockCpu;
    boolean mShuttingDown;
    final BatteryStats.HistoryEventTracker mActiveEvents = new BatteryStats.HistoryEventTracker();
    long mHistoryBaseTime;
    boolean mHaveBatteryLevel = false;
    boolean mRecordingHistory = false;
    int mNumHistoryItems;
    static final int MAX_HISTORY_BUFFER = 262144;
    static final int MAX_MAX_HISTORY_BUFFER = 327680;
    final Parcel mHistoryBuffer = Parcel.obtain();
    final BatteryStats.HistoryItem mHistoryLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryLastLastWritten = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryReadTmp = new BatteryStats.HistoryItem();
    final BatteryStats.HistoryItem mHistoryAddTmp = new BatteryStats.HistoryItem();
    final HashMap<BatteryStats.HistoryTag, Integer> mHistoryTagPool = new HashMap();
    String[] mReadHistoryStrings;
    int[] mReadHistoryUids;
    int mReadHistoryChars;
    int mNextHistoryTagIdx = 0;
    int mNumHistoryTagChars = 0;
    int mHistoryBufferLastPos = -1;
    boolean mHistoryOverflow = false;
    int mActiveHistoryStates = -1;
    int mActiveHistoryStates2 = -1;
    long mLastHistoryElapsedRealtime = 0L;
    long mTrackRunningHistoryElapsedRealtime = 0L;
    long mTrackRunningHistoryUptime = 0L;
    final BatteryStats.HistoryItem mHistoryCur = new BatteryStats.HistoryItem();
    BatteryStats.HistoryItem mHistory;
    BatteryStats.HistoryItem mHistoryEnd;
    BatteryStats.HistoryItem mHistoryLastEnd;
    BatteryStats.HistoryItem mHistoryCache;
    BatteryStats.HistoryStepDetails mLastHistoryStepDetails = null;
    byte mLastHistoryStepLevel = 0;
    final BatteryStats.HistoryStepDetails mCurHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    final BatteryStats.HistoryStepDetails mTmpHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    long mLastStepCpuUserTime;
    long mCurStepCpuUserTime;
    long mLastStepCpuSystemTime;
    long mCurStepCpuSystemTime;
    long mLastStepStatUserTime;
    long mLastStepStatSystemTime;
    long mLastStepStatIOWaitTime;
    long mLastStepStatIrqTime;
    long mLastStepStatSoftIrqTime;
    long mLastStepStatIdleTime;
    long mCurStepStatUserTime;
    long mCurStepStatSystemTime;
    long mCurStepStatIOWaitTime;
    long mCurStepStatIrqTime;
    long mCurStepStatSoftIrqTime;
    long mCurStepStatIdleTime;
    private BatteryStats.HistoryItem mHistoryIterator;
    private boolean mReadOverflow;
    private boolean mIteratingHistory;
    int mStartCount;
    long mStartClockTime;
    String mStartPlatformVersion;
    String mEndPlatformVersion;
    long mUptime;
    long mUptimeStart;
    long mRealtime;
    long mRealtimeStart;
    int mWakeLockNesting;
    boolean mWakeLockImportant;
    public boolean mRecordAllHistory;
    boolean mNoAutoReset;
    int mScreenState = 0;
    StopwatchTimer mScreenOnTimer;
    int mScreenBrightnessBin = -1;
    final StopwatchTimer[] mScreenBrightnessTimer = new StopwatchTimer[5];
    boolean mInteractive;
    StopwatchTimer mInteractiveTimer;
    boolean mPowerSaveModeEnabled;
    StopwatchTimer mPowerSaveModeEnabledTimer;
    boolean mDeviceIdling;
    StopwatchTimer mDeviceIdlingTimer;
    boolean mDeviceIdleModeEnabled;
    StopwatchTimer mDeviceIdleModeEnabledTimer;
    boolean mPhoneOn;
    StopwatchTimer mPhoneOnTimer;
    int mAudioOnNesting;
    StopwatchTimer mAudioOnTimer;
    int mVideoOnNesting;
    StopwatchTimer mVideoOnTimer;
    int mFlashlightOnNesting;
    StopwatchTimer mFlashlightOnTimer;
    int mCameraOnNesting;
    StopwatchTimer mCameraOnTimer;
    int mPhoneSignalStrengthBin = -1;
    int mPhoneSignalStrengthBinRaw = -1;
    final StopwatchTimer[] mPhoneSignalStrengthsTimer = new StopwatchTimer[5];
    StopwatchTimer mPhoneSignalScanningTimer;
    int mPhoneDataConnectionType = -1;
    final StopwatchTimer[] mPhoneDataConnectionsTimer = new StopwatchTimer[17];
    final LongSamplingCounter[] mNetworkByteActivityCounters = new LongSamplingCounter[4];
    final LongSamplingCounter[] mNetworkPacketActivityCounters = new LongSamplingCounter[4];
    final LongSamplingCounter[] mBluetoothActivityCounters = new LongSamplingCounter[4];
    final LongSamplingCounter[] mWifiActivityCounters = new LongSamplingCounter[4];
    boolean mWifiOn;
    StopwatchTimer mWifiOnTimer;
    boolean mGlobalWifiRunning;
    StopwatchTimer mGlobalWifiRunningTimer;
    int mWifiState = -1;
    final StopwatchTimer[] mWifiStateTimer = new StopwatchTimer[8];
    int mWifiSupplState = -1;
    final StopwatchTimer[] mWifiSupplStateTimer = new StopwatchTimer[13];
    int mWifiSignalStrengthBin = -1;
    final StopwatchTimer[] mWifiSignalStrengthsTimer = new StopwatchTimer[5];
    int mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
    long mMobileRadioActiveStartTime;
    StopwatchTimer mMobileRadioActiveTimer;
    StopwatchTimer mMobileRadioActivePerAppTimer;
    LongSamplingCounter mMobileRadioActiveAdjustedTime;
    LongSamplingCounter mMobileRadioActiveUnknownTime;
    LongSamplingCounter mMobileRadioActiveUnknownCount;
    int mWifiRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
    boolean mOnBattery;
    boolean mOnBatteryInternal;
    boolean mCharging = true;
    int mLastChargingStateLevel;
    int mDischargeStartLevel;
    int mDischargeUnplugLevel;
    int mDischargePlugLevel;
    int mDischargeCurrentLevel;
    int mCurrentBatteryLevel;
    int mLowDischargeAmountSinceCharge;
    int mHighDischargeAmountSinceCharge;
    int mDischargeScreenOnUnplugLevel;
    int mDischargeScreenOffUnplugLevel;
    int mDischargeAmountScreenOn;
    int mDischargeAmountScreenOnSinceCharge;
    int mDischargeAmountScreenOff;
    int mDischargeAmountScreenOffSinceCharge;
    static final int MAX_LEVEL_STEPS = 200;
    int mInitStepMode = 0;
    int mCurStepMode = 0;
    int mModStepMode = 0;
    int mLastDischargeStepLevel;
    int mMinDischargeStepLevel;
    final BatteryStats.LevelStepTracker mDischargeStepTracker = new BatteryStats.LevelStepTracker(200);
    final BatteryStats.LevelStepTracker mDailyDischargeStepTracker = new BatteryStats.LevelStepTracker(400);
    ArrayList<BatteryStats.PackageChange> mDailyPackageChanges;
    int mLastChargeStepLevel;
    int mMaxChargeStepLevel;
    final BatteryStats.LevelStepTracker mChargeStepTracker = new BatteryStats.LevelStepTracker(200);
    final BatteryStats.LevelStepTracker mDailyChargeStepTracker = new BatteryStats.LevelStepTracker(400);
    static final int MAX_DAILY_ITEMS = 10;
    long mDailyStartTime = 0L;
    long mNextMinDailyDeadline = 0L;
    long mNextMaxDailyDeadline = 0L;
    final ArrayList<BatteryStats.DailyItem> mDailyItems = new ArrayList();
    long mLastWriteTime = 0L;
    private int mPhoneServiceState = -1;
    private int mPhoneServiceStateRaw = -1;
    private int mPhoneSimStateRaw = -1;
    private int mNumConnectivityChange;
    private int mLoadedNumConnectivityChange;
    private int mUnpluggedNumConnectivityChange;
    private final NetworkStats.Entry mTmpNetworkStatsEntry = new NetworkStats.Entry();
    private PowerProfile mPowerProfile;
    private boolean mHasWifiEnergyReporting = false;
    private boolean mHasBluetoothEnergyReporting = false;
    private final HashMap<String, SamplingTimer> mKernelWakelockStats = new HashMap();
    String mLastWakeupReason = null;
    long mLastWakeupUptimeMs = 0L;
    private final HashMap<String, SamplingTimer> mWakeupReasonStats = new HashMap();
    static final int DELTA_TIME_MASK = 524287;
    static final int DELTA_TIME_LONG = 524287;
    static final int DELTA_TIME_INT = 524286;
    static final int DELTA_TIME_ABS = 524285;
    static final int DELTA_BATTERY_LEVEL_FLAG = 524288;
    static final int DELTA_STATE_FLAG = 0x100000;
    static final int DELTA_STATE2_FLAG = 0x200000;
    static final int DELTA_WAKELOCK_FLAG = 0x400000;
    static final int DELTA_EVENT_FLAG = 0x800000;
    static final int DELTA_STATE_MASK = -16777216;
    static final int STATE_BATTERY_STATUS_MASK = 7;
    static final int STATE_BATTERY_STATUS_SHIFT = 29;
    static final int STATE_BATTERY_HEALTH_MASK = 7;
    static final int STATE_BATTERY_HEALTH_SHIFT = 26;
    static final int STATE_BATTERY_PLUG_MASK = 3;
    static final int STATE_BATTERY_PLUG_SHIFT = 24;
    static final int BATTERY_DELTA_LEVEL_FLAG = 1;
    int mChangedStates = 0;
    int mChangedStates2 = 0;
    private String mInitialAcquireWakeName;
    private int mInitialAcquireWakeUid = -1;
    int mSensorNesting;
    int mGpsNesting;
    int mWifiFullLockNesting = 0;
    int mWifiScanNesting = 0;
    int mWifiMulticastNesting = 0;
    private String[] mMobileIfaces = EmptyArray.STRING;
    private String[] mWifiIfaces = EmptyArray.STRING;
    private final NetworkStatsFactory mNetworkStatsFactory = new NetworkStatsFactory();
    private static final int NETWORK_STATS_LAST = 0;
    private static final int NETWORK_STATS_NEXT = 1;
    private static final int NETWORK_STATS_DELTA = 2;
    private final NetworkStats[] mMobileNetworkStats = new NetworkStats[]{new NetworkStats(SystemClock.elapsedRealtime(), 50), new NetworkStats(SystemClock.elapsedRealtime(), 50), new NetworkStats(SystemClock.elapsedRealtime(), 50)};
    private final NetworkStats[] mWifiNetworkStats = new NetworkStats[]{new NetworkStats(SystemClock.elapsedRealtime(), 50), new NetworkStats(SystemClock.elapsedRealtime(), 50), new NetworkStats(SystemClock.elapsedRealtime(), 50)};
    long mTempTotalCpuUserTimeUs;
    long mTempTotalCpuSystemTimeUs;
    public static final int BATTERY_PLUGGED_NONE = 0;
    Parcel mPendingWrite = null;
    final ReentrantLock mWriteLock = new ReentrantLock();
    public static final Parcelable.Creator<BatteryStatsImpl> CREATOR;

    public Map<String, ? extends Timer> getKernelWakelockStats() {
        return this.mKernelWakelockStats;
    }

    public Map<String, ? extends Timer> getWakeupReasonStats() {
        return this.mWakeupReasonStats;
    }

    public BatteryStatsImpl() {
        this.mFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mHandler = null;
        this.mExternalSync = null;
        this.clearHistoryLocked();
    }

    public SamplingTimer getWakeupReasonTimerLocked(String name) {
        SamplingTimer timer = this.mWakeupReasonStats.get(name);
        if (timer == null) {
            timer = new SamplingTimer(this.mOnBatteryTimeBase, true);
            this.mWakeupReasonStats.put(name, timer);
        }
        return timer;
    }

    public SamplingTimer getKernelWakelockTimerLocked(String name) {
        SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
        if (kwlt == null) {
            kwlt = new SamplingTimer(this.mOnBatteryScreenOffTimeBase, true);
            this.mKernelWakelockStats.put(name, kwlt);
        }
        return kwlt;
    }

    private int writeHistoryTag(BatteryStats.HistoryTag tag) {
        int idx;
        Integer idxObj = this.mHistoryTagPool.get(tag);
        if (idxObj != null) {
            idx = idxObj;
        } else {
            idx = this.mNextHistoryTagIdx++;
            BatteryStats.HistoryTag key = new BatteryStats.HistoryTag();
            key.setTo(tag);
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(key, idx);
            this.mNumHistoryTagChars += key.string.length() + 1;
        }
        return idx;
    }

    private void readHistoryTag(int index, BatteryStats.HistoryTag tag) {
        tag.string = this.mReadHistoryStrings[index];
        tag.uid = this.mReadHistoryUids[index];
        tag.poolIdx = index;
    }

    public void writeHistoryDelta(Parcel dest, BatteryStats.HistoryItem cur, BatteryStats.HistoryItem last) {
        boolean state2IntChanged;
        int stateInt;
        boolean stateIntChanged;
        boolean batteryLevelIntChanged;
        if (last == null || cur.cmd != 0) {
            dest.writeInt(524285);
            cur.writeToParcel(dest, 0);
            return;
        }
        long deltaTime = cur.time - last.time;
        int lastBatteryLevelInt = this.buildBatteryLevelInt(last);
        int lastStateInt = this.buildStateInt(last);
        int deltaTimeToken = deltaTime < 0L || deltaTime > Integer.MAX_VALUE ? 524287 : (deltaTime >= 524285L ? 524286 : (int)deltaTime);
        int firstToken = deltaTimeToken | cur.states & 0xFF000000;
        int includeStepDetails = this.mLastHistoryStepLevel > cur.batteryLevel ? 1 : 0;
        boolean computeStepDetails = includeStepDetails != 0 || this.mLastHistoryStepDetails == null;
        int batteryLevelInt = this.buildBatteryLevelInt(cur) | includeStepDetails;
        boolean bl = batteryLevelIntChanged = batteryLevelInt != lastBatteryLevelInt;
        if (batteryLevelIntChanged) {
            firstToken |= 0x80000;
        }
        boolean bl2 = stateIntChanged = (stateInt = this.buildStateInt(cur)) != lastStateInt;
        if (stateIntChanged) {
            firstToken |= 0x100000;
        }
        boolean bl3 = state2IntChanged = cur.states2 != last.states2;
        if (state2IntChanged) {
            firstToken |= 0x200000;
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            firstToken |= 0x400000;
        }
        if (cur.eventCode != 0) {
            firstToken |= 0x800000;
        }
        dest.writeInt(firstToken);
        if (deltaTimeToken >= 524286) {
            if (deltaTimeToken == 524286) {
                dest.writeInt((int)deltaTime);
            } else {
                dest.writeLong(deltaTime);
            }
        }
        if (batteryLevelIntChanged) {
            dest.writeInt(batteryLevelInt);
        }
        if (stateIntChanged) {
            dest.writeInt(stateInt);
        }
        if (state2IntChanged) {
            dest.writeInt(cur.states2);
        }
        if (cur.wakelockTag != null || cur.wakeReasonTag != null) {
            int wakeLockIndex = cur.wakelockTag != null ? this.writeHistoryTag(cur.wakelockTag) : 65535;
            int wakeReasonIndex = cur.wakeReasonTag != null ? this.writeHistoryTag(cur.wakeReasonTag) : 65535;
            dest.writeInt(wakeReasonIndex << 16 | wakeLockIndex);
        }
        if (cur.eventCode != 0) {
            int index = this.writeHistoryTag(cur.eventTag);
            int codeAndIndex = cur.eventCode & 0xFFFF | index << 16;
            dest.writeInt(codeAndIndex);
        }
        if (computeStepDetails) {
            this.computeHistoryStepDetails(this.mCurHistoryStepDetails, this.mLastHistoryStepDetails);
            if (includeStepDetails != 0) {
                this.mCurHistoryStepDetails.writeToParcel(dest);
            }
            cur.stepDetails = this.mCurHistoryStepDetails;
            this.mLastHistoryStepDetails = this.mCurHistoryStepDetails;
        } else {
            cur.stepDetails = null;
        }
        if (this.mLastHistoryStepLevel < cur.batteryLevel) {
            this.mLastHistoryStepDetails = null;
        }
        this.mLastHistoryStepLevel = cur.batteryLevel;
    }

    private int buildBatteryLevelInt(BatteryStats.HistoryItem h) {
        return h.batteryLevel << 25 & 0xFE000000 | h.batteryTemperature << 14 & 0x1FF8000 | h.batteryVoltage << 1 & Short.MAX_VALUE;
    }

    private int buildStateInt(BatteryStats.HistoryItem h) {
        int plugType = 0;
        if ((h.batteryPlugType & 1) != 0) {
            plugType = 1;
        } else if ((h.batteryPlugType & 2) != 0) {
            plugType = 2;
        } else if ((h.batteryPlugType & 4) != 0) {
            plugType = 3;
        }
        return (h.batteryStatus & 7) << 29 | (h.batteryHealth & 7) << 26 | (plugType & 3) << 24 | h.states & 0xFFFFFF;
    }

    private void computeHistoryStepDetails(BatteryStats.HistoryStepDetails out, BatteryStats.HistoryStepDetails last) {
        BatteryStats.HistoryStepDetails tmp = last != null ? this.mTmpHistoryStepDetails : out;
        this.requestImmediateCpuUpdate();
        if (last == null) {
            int NU = this.mUidStats.size();
            for (int i = 0; i < NU; ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.mLastStepUserTime = uid.mCurStepUserTime;
                uid.mLastStepSystemTime = uid.mCurStepSystemTime;
            }
            this.mLastStepCpuUserTime = this.mCurStepCpuUserTime;
            this.mLastStepCpuSystemTime = this.mCurStepCpuSystemTime;
            this.mLastStepStatUserTime = this.mCurStepStatUserTime;
            this.mLastStepStatSystemTime = this.mCurStepStatSystemTime;
            this.mLastStepStatIOWaitTime = this.mCurStepStatIOWaitTime;
            this.mLastStepStatIrqTime = this.mCurStepStatIrqTime;
            this.mLastStepStatSoftIrqTime = this.mCurStepStatSoftIrqTime;
            this.mLastStepStatIdleTime = this.mCurStepStatIdleTime;
            tmp.clear();
            return;
        }
        out.userTime = (int)(this.mCurStepCpuUserTime - this.mLastStepCpuUserTime);
        out.systemTime = (int)(this.mCurStepCpuSystemTime - this.mLastStepCpuSystemTime);
        out.statUserTime = (int)(this.mCurStepStatUserTime - this.mLastStepStatUserTime);
        out.statSystemTime = (int)(this.mCurStepStatSystemTime - this.mLastStepStatSystemTime);
        out.statIOWaitTime = (int)(this.mCurStepStatIOWaitTime - this.mLastStepStatIOWaitTime);
        out.statIrqTime = (int)(this.mCurStepStatIrqTime - this.mLastStepStatIrqTime);
        out.statSoftIrqTime = (int)(this.mCurStepStatSoftIrqTime - this.mLastStepStatSoftIrqTime);
        out.statIdlTime = (int)(this.mCurStepStatIdleTime - this.mLastStepStatIdleTime);
        out.appCpuUid3 = -1;
        out.appCpuUid2 = -1;
        out.appCpuUid1 = -1;
        out.appCpuUTime3 = 0;
        out.appCpuUTime2 = 0;
        out.appCpuUTime1 = 0;
        out.appCpuSTime3 = 0;
        out.appCpuSTime2 = 0;
        out.appCpuSTime1 = 0;
        int NU = this.mUidStats.size();
        for (int i = 0; i < NU; ++i) {
            Uid uid = this.mUidStats.valueAt(i);
            int totalUTime = (int)(uid.mCurStepUserTime - uid.mLastStepUserTime);
            int totalSTime = (int)(uid.mCurStepSystemTime - uid.mLastStepSystemTime);
            int totalTime = totalUTime + totalSTime;
            uid.mLastStepUserTime = uid.mCurStepUserTime;
            uid.mLastStepSystemTime = uid.mCurStepSystemTime;
            if (totalTime <= out.appCpuUTime3 + out.appCpuSTime3) continue;
            if (totalTime <= out.appCpuUTime2 + out.appCpuSTime2) {
                out.appCpuUid3 = uid.mUid;
                out.appCpuUTime3 = totalUTime;
                out.appCpuSTime3 = totalSTime;
                continue;
            }
            out.appCpuUid3 = out.appCpuUid2;
            out.appCpuUTime3 = out.appCpuUTime2;
            out.appCpuSTime3 = out.appCpuSTime2;
            if (totalTime <= out.appCpuUTime1 + out.appCpuSTime1) {
                out.appCpuUid2 = uid.mUid;
                out.appCpuUTime2 = totalUTime;
                out.appCpuSTime2 = totalSTime;
                continue;
            }
            out.appCpuUid2 = out.appCpuUid1;
            out.appCpuUTime2 = out.appCpuUTime1;
            out.appCpuSTime2 = out.appCpuSTime1;
            out.appCpuUid1 = uid.mUid;
            out.appCpuUTime1 = totalUTime;
            out.appCpuSTime1 = totalSTime;
        }
        this.mLastStepCpuUserTime = this.mCurStepCpuUserTime;
        this.mLastStepCpuSystemTime = this.mCurStepCpuSystemTime;
        this.mLastStepStatUserTime = this.mCurStepStatUserTime;
        this.mLastStepStatSystemTime = this.mCurStepStatSystemTime;
        this.mLastStepStatIOWaitTime = this.mCurStepStatIOWaitTime;
        this.mLastStepStatIrqTime = this.mCurStepStatIrqTime;
        this.mLastStepStatSoftIrqTime = this.mCurStepStatSoftIrqTime;
        this.mLastStepStatIdleTime = this.mCurStepStatIdleTime;
    }

    public void readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.time = src.readLong();
                cur.numReadInts += 2;
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            cur.batteryLevel = (byte)(batteryLevelInt >> 25 & 0x7F);
            cur.batteryTemperature = (short)(batteryLevelInt << 7 >> 21);
            cur.batteryVoltage = (char)(batteryLevelInt & 0x3FFF);
            ++cur.numReadInts;
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFF000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFF000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            if (wakeLockIndex != 65535) {
                cur.wakelockTag = cur.localWakelockTag;
                this.readHistoryTag(wakeLockIndex, cur.wakelockTag);
            } else {
                cur.wakelockTag = null;
            }
            if (wakeReasonIndex != 65535) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                this.readHistoryTag(wakeReasonIndex, cur.wakeReasonTag);
            } else {
                cur.wakeReasonTag = null;
            }
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            this.readHistoryTag(index, cur.eventTag);
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
    }

    @Override
    public void commitCurrentHistoryBatchLocked() {
        this.mHistoryLastWritten.cmd = (byte)-1;
    }

    void addHistoryBufferLocked(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        int dataSize;
        if (!this.mHaveBatteryLevel || !this.mRecordingHistory) {
            return;
        }
        long timeDiff = this.mHistoryBaseTime + elapsedRealtimeMs - this.mHistoryLastWritten.time;
        int diffStates = this.mHistoryLastWritten.states ^ cur.states & this.mActiveHistoryStates;
        int diffStates2 = this.mHistoryLastWritten.states2 ^ cur.states2 & this.mActiveHistoryStates2;
        int lastDiffStates = this.mHistoryLastWritten.states ^ this.mHistoryLastLastWritten.states;
        int lastDiffStates2 = this.mHistoryLastWritten.states2 ^ this.mHistoryLastLastWritten.states2;
        if (!(this.mHistoryBufferLastPos < 0 || this.mHistoryLastWritten.cmd != 0 || timeDiff >= 1000L || (diffStates & lastDiffStates) != 0 || (diffStates2 & lastDiffStates2) != 0 || this.mHistoryLastWritten.wakelockTag != null && cur.wakelockTag != null || this.mHistoryLastWritten.wakeReasonTag != null && cur.wakeReasonTag != null || this.mHistoryLastWritten.stepDetails != null || this.mHistoryLastWritten.eventCode != 0 && cur.eventCode != 0 || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || this.mHistoryLastWritten.batteryStatus != cur.batteryStatus || this.mHistoryLastWritten.batteryHealth != cur.batteryHealth || this.mHistoryLastWritten.batteryPlugType != cur.batteryPlugType || this.mHistoryLastWritten.batteryTemperature != cur.batteryTemperature || this.mHistoryLastWritten.batteryVoltage != cur.batteryVoltage)) {
            this.mHistoryBuffer.setDataSize(this.mHistoryBufferLastPos);
            this.mHistoryBuffer.setDataPosition(this.mHistoryBufferLastPos);
            this.mHistoryBufferLastPos = -1;
            elapsedRealtimeMs = this.mHistoryLastWritten.time - this.mHistoryBaseTime;
            if (this.mHistoryLastWritten.wakelockTag != null) {
                cur.wakelockTag = cur.localWakelockTag;
                cur.wakelockTag.setTo(this.mHistoryLastWritten.wakelockTag);
            }
            if (this.mHistoryLastWritten.wakeReasonTag != null) {
                cur.wakeReasonTag = cur.localWakeReasonTag;
                cur.wakeReasonTag.setTo(this.mHistoryLastWritten.wakeReasonTag);
            }
            if (this.mHistoryLastWritten.eventCode != 0) {
                cur.eventCode = this.mHistoryLastWritten.eventCode;
                cur.eventTag = cur.localEventTag;
                cur.eventTag.setTo(this.mHistoryLastWritten.eventTag);
            }
            this.mHistoryLastWritten.setTo(this.mHistoryLastLastWritten);
        }
        if ((dataSize = this.mHistoryBuffer.dataSize()) >= 262144) {
            int curStates2;
            if (!this.mHistoryOverflow) {
                this.mHistoryOverflow = true;
                this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)0, cur);
                this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)6, cur);
                return;
            }
            boolean writeAnyway = false;
            int curStates = cur.states & 0xFFE70000 & this.mActiveHistoryStates;
            if (this.mHistoryLastWritten.states != curStates) {
                int old = this.mActiveHistoryStates;
                this.mActiveHistoryStates &= curStates | 0x18FFFF;
                writeAnyway |= old != this.mActiveHistoryStates;
            }
            if (this.mHistoryLastWritten.states2 != (curStates2 = cur.states2 & 0x687F0000 & this.mActiveHistoryStates2)) {
                int old = this.mActiveHistoryStates2;
                this.mActiveHistoryStates2 &= curStates2 | 0x9780FFFF;
                writeAnyway |= old != this.mActiveHistoryStates2;
            }
            if (!(writeAnyway || this.mHistoryLastWritten.batteryLevel != cur.batteryLevel || dataSize < 327680 && ((this.mHistoryLastWritten.states ^ cur.states) & 0x180000) != 0 && ((this.mHistoryLastWritten.states2 ^ cur.states2) & 0x97800000) != 0)) {
                return;
            }
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)0, cur);
            return;
        }
        if (dataSize == 0) {
            cur.currentTime = System.currentTimeMillis();
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)7, cur);
        }
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)0, cur);
    }

    private void addHistoryBufferLocked(long elapsedRealtimeMs, long uptimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        if (this.mIteratingHistory) {
            throw new IllegalStateException("Can't do this while iterating history!");
        }
        this.mHistoryBufferLastPos = this.mHistoryBuffer.dataPosition();
        this.mHistoryLastLastWritten.setTo(this.mHistoryLastWritten);
        this.mHistoryLastWritten.setTo(this.mHistoryBaseTime + elapsedRealtimeMs, cmd, cur);
        this.mHistoryLastWritten.states &= this.mActiveHistoryStates;
        this.mHistoryLastWritten.states2 &= this.mActiveHistoryStates2;
        this.writeHistoryDelta(this.mHistoryBuffer, this.mHistoryLastWritten, this.mHistoryLastLastWritten);
        this.mLastHistoryElapsedRealtime = elapsedRealtimeMs;
        cur.wakelockTag = null;
        cur.wakeReasonTag = null;
        cur.eventCode = 0;
        cur.eventTag = null;
    }

    void addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs) {
        long diffElapsed;
        long diffUptime;
        if (this.mTrackRunningHistoryElapsedRealtime != 0L && (diffUptime = uptimeMs - this.mTrackRunningHistoryUptime) < (diffElapsed = elapsedRealtimeMs - this.mTrackRunningHistoryElapsedRealtime) - 20L) {
            long wakeElapsedTime = elapsedRealtimeMs - (diffElapsed - diffUptime);
            this.mHistoryAddTmp.setTo(this.mHistoryLastWritten);
            this.mHistoryAddTmp.wakelockTag = null;
            this.mHistoryAddTmp.wakeReasonTag = null;
            this.mHistoryAddTmp.eventCode = 0;
            this.mHistoryAddTmp.states &= Integer.MAX_VALUE;
            this.addHistoryRecordInnerLocked(wakeElapsedTime, uptimeMs, this.mHistoryAddTmp);
        }
        this.mHistoryCur.states |= Integer.MIN_VALUE;
        this.mTrackRunningHistoryElapsedRealtime = elapsedRealtimeMs;
        this.mTrackRunningHistoryUptime = uptimeMs;
        this.addHistoryRecordInnerLocked(elapsedRealtimeMs, uptimeMs, this.mHistoryCur);
    }

    void addHistoryRecordInnerLocked(long elapsedRealtimeMs, long uptimeMs, BatteryStats.HistoryItem cur) {
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, cur);
    }

    public void addHistoryEventLocked(long elapsedRealtimeMs, long uptimeMs, int code, String name, int uid) {
        this.mHistoryCur.eventCode = code;
        this.mHistoryCur.eventTag = this.mHistoryCur.localEventTag;
        this.mHistoryCur.eventTag.string = name;
        this.mHistoryCur.eventTag.uid = uid;
        this.addHistoryRecordLocked(elapsedRealtimeMs, uptimeMs);
    }

    void addHistoryRecordLocked(long elapsedRealtimeMs, long uptimeMs, byte cmd, BatteryStats.HistoryItem cur) {
        BatteryStats.HistoryItem rec = this.mHistoryCache;
        if (rec != null) {
            this.mHistoryCache = rec.next;
        } else {
            rec = new BatteryStats.HistoryItem();
        }
        rec.setTo(this.mHistoryBaseTime + elapsedRealtimeMs, cmd, cur);
        this.addHistoryRecordLocked(rec);
    }

    void addHistoryRecordLocked(BatteryStats.HistoryItem rec) {
        ++this.mNumHistoryItems;
        rec.next = null;
        this.mHistoryLastEnd = this.mHistoryEnd;
        if (this.mHistoryEnd != null) {
            this.mHistoryEnd.next = rec;
            this.mHistoryEnd = rec;
        } else {
            this.mHistory = this.mHistoryEnd = rec;
        }
    }

    void clearHistoryLocked() {
        this.mHistoryBaseTime = 0L;
        this.mLastHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryElapsedRealtime = 0L;
        this.mTrackRunningHistoryUptime = 0L;
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryBuffer.setDataCapacity(131072);
        this.mHistoryLastLastWritten.clear();
        this.mHistoryLastWritten.clear();
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        this.mHistoryBufferLastPos = -1;
        this.mHistoryOverflow = false;
        this.mActiveHistoryStates = -1;
        this.mActiveHistoryStates2 = -1;
    }

    public void updateTimeBasesLocked(boolean unplugged, boolean screenOff, long uptime, long realtime) {
        boolean unpluggedScreenOff;
        this.mOnBatteryTimeBase.setRunning(unplugged, uptime, realtime);
        boolean bl = unpluggedScreenOff = unplugged && screenOff;
        if (unpluggedScreenOff != this.mOnBatteryScreenOffTimeBase.isRunning()) {
            this.updateKernelWakelocksLocked();
            this.updateCpuTimeLocked();
            this.mOnBatteryScreenOffTimeBase.setRunning(unpluggedScreenOff, uptime, realtime);
        }
    }

    public void addIsolatedUidLocked(int isolatedUid, int appUid) {
        this.mIsolatedUids.put(isolatedUid, appUid);
    }

    public void scheduleRemoveIsolatedUidLocked(int isolatedUid, int appUid) {
        int curUid = this.mIsolatedUids.get(isolatedUid, -1);
        if (curUid == appUid && this.mExternalSync != null) {
            this.mExternalSync.scheduleCpuSyncDueToRemovedUid(isolatedUid);
        }
    }

    public void removeIsolatedUidLocked(int isolatedUid) {
        this.mIsolatedUids.delete(isolatedUid);
        this.mKernelUidCpuTimeReader.removeUid(isolatedUid);
    }

    public int mapUid(int uid) {
        int isolated = this.mIsolatedUids.get(uid, -1);
        return isolated > 0 ? isolated : uid;
    }

    public void noteEventLocked(int code, String name, int uid) {
        if (!this.mActiveEvents.updateState(code, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, code, name, uid);
    }

    boolean ensureStartClockTime(long currentTime) {
        long ABOUT_ONE_YEAR = 31536000000L;
        if (currentTime > 31536000000L && this.mStartClockTime < currentTime - 31536000000L) {
            this.mStartClockTime = currentTime - (SystemClock.elapsedRealtime() - this.mRealtimeStart / 1000L);
            return true;
        }
        return false;
    }

    public void noteCurrentTimeChangedLocked() {
        long currentTime = System.currentTimeMillis();
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.recordCurrentTimeChangeLocked(currentTime, elapsedRealtime, uptime);
        this.ensureStartClockTime(currentTime);
    }

    public void noteProcessStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incStartsLocked();
        }
        if (!this.mActiveEvents.updateState(32769, name, uid, 0)) {
            return;
        }
        if (!this.mRecordAllHistory) {
            return;
        }
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32769, name, uid);
    }

    public void noteProcessCrashLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incNumCrashesLocked();
        }
    }

    public void noteProcessAnrLocked(String name, int uid) {
        uid = this.mapUid(uid);
        if (this.isOnBattery()) {
            Uid u = this.getUidStatsLocked(uid);
            u.getProcessStatsLocked(name).incNumAnrsLocked();
        }
    }

    public void noteProcessStateLocked(String name, int uid, int state) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.getUidStatsLocked(uid).updateProcessStateLocked(name, state, elapsedRealtime);
    }

    public void noteProcessFinishLocked(String name, int uid) {
        if (!this.mActiveEvents.updateState(16385, name, uid = this.mapUid(uid), 0)) {
            return;
        }
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.getUidStatsLocked(uid).updateProcessStateLocked(name, 3, elapsedRealtime);
        if (!this.mRecordAllHistory) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16385, name, uid);
    }

    public void noteSyncStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.getUidStatsLocked(uid).noteStartSyncLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(32772, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32772, name, uid);
    }

    public void noteSyncFinishLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.getUidStatsLocked(uid).noteStopSyncLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(16388, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16388, name, uid);
    }

    public void noteJobStartLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.getUidStatsLocked(uid).noteStartJobLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(32774, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32774, name, uid);
    }

    public void noteJobFinishLocked(String name, int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.getUidStatsLocked(uid).noteStopJobLocked(name, elapsedRealtime);
        if (!this.mActiveEvents.updateState(16390, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16390, name, uid);
    }

    public void noteAlarmStartLocked(String name, int uid) {
        if (!this.mRecordAllHistory) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (!this.mActiveEvents.updateState(32781, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 32781, name, uid);
    }

    public void noteAlarmFinishLocked(String name, int uid) {
        if (!this.mRecordAllHistory) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (!this.mActiveEvents.updateState(16397, name, uid, 0)) {
            return;
        }
        this.addHistoryEventLocked(elapsedRealtime, uptime, 16397, name, uid);
    }

    private void requestWakelockCpuUpdate() {
        if (!this.mHandler.hasMessages(1)) {
            Message m = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(m, 5000L);
        }
    }

    private void requestImmediateCpuUpdate() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessage(1);
    }

    public void setRecordAllHistoryLocked(boolean enabled) {
        block6: {
            block5: {
                this.mRecordAllHistory = enabled;
                if (enabled) break block5;
                this.mActiveEvents.removeEvents(5);
                this.mActiveEvents.removeEvents(13);
                HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
                if (active == null) break block6;
                long mSecRealtime = SystemClock.elapsedRealtime();
                long mSecUptime = SystemClock.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 16385, ent.getKey(), uids.keyAt(j));
                    }
                }
                break block6;
            }
            HashMap<String, SparseIntArray> active = this.mActiveEvents.getStateForEvent(1);
            if (active != null) {
                long mSecRealtime = SystemClock.elapsedRealtime();
                long mSecUptime = SystemClock.uptimeMillis();
                for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                    SparseIntArray uids = ent.getValue();
                    for (int j = 0; j < uids.size(); ++j) {
                        this.addHistoryEventLocked(mSecRealtime, mSecUptime, 32769, ent.getKey(), uids.keyAt(j));
                    }
                }
            }
        }
    }

    public void setNoAutoReset(boolean enabled) {
        this.mNoAutoReset = enabled;
    }

    public void noteStartWakeLocked(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging, long elapsedRealtime, long uptime) {
        uid = this.mapUid(uid);
        if (type == 0) {
            this.aggregateLastWakeupUptimeLocked(uptime);
            if (historyName == null) {
                historyName = name;
            }
            if (this.mRecordAllHistory && this.mActiveEvents.updateState(32773, historyName, uid, 0)) {
                this.addHistoryEventLocked(elapsedRealtime, uptime, 32773, historyName, uid);
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states |= 0x40000000;
                this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = uid;
                this.mWakeLockImportant = !unimportantForLogging;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            } else if (!this.mWakeLockImportant && !unimportantForLogging && this.mHistoryLastWritten.cmd == 0) {
                if (this.mHistoryLastWritten.wakelockTag != null) {
                    this.mHistoryLastWritten.wakelockTag = null;
                    this.mHistoryCur.wakelockTag = this.mHistoryCur.localWakelockTag;
                    this.mHistoryCur.wakelockTag.string = this.mInitialAcquireWakeName = historyName;
                    this.mHistoryCur.wakelockTag.uid = this.mInitialAcquireWakeUid = uid;
                    this.addHistoryRecordLocked(elapsedRealtime, uptime);
                }
                this.mWakeLockImportant = true;
            }
            ++this.mWakeLockNesting;
        }
        if (uid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(uid).noteStartWakeLocked(pid, name, type, elapsedRealtime);
        }
    }

    public void noteStopWakeLocked(int uid, int pid, String name, String historyName, int type, long elapsedRealtime, long uptime) {
        uid = this.mapUid(uid);
        if (type == 0) {
            --this.mWakeLockNesting;
            if (this.mRecordAllHistory) {
                if (historyName == null) {
                    historyName = name;
                }
                if (this.mActiveEvents.updateState(16389, historyName, uid, 0)) {
                    this.addHistoryEventLocked(elapsedRealtime, uptime, 16389, historyName, uid);
                }
            }
            if (this.mWakeLockNesting == 0) {
                this.mHistoryCur.states &= 0xBFFFFFFF;
                this.mInitialAcquireWakeName = null;
                this.mInitialAcquireWakeUid = -1;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
        }
        if (uid >= 0) {
            if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
                this.requestWakelockCpuUpdate();
            }
            this.getUidStatsLocked(uid).noteStopWakeLocked(pid, name, type, elapsedRealtime);
        }
    }

    public void noteStartWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStartWakeLocked(ws.get(i), pid, name, historyName, type, unimportantForLogging, elapsedRealtime, uptime);
        }
    }

    public void noteChangeWakelockFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        int NN = newWs.size();
        for (int i = 0; i < NN; ++i) {
            this.noteStartWakeLocked(newWs.get(i), newPid, newName, newHistoryName, newType, newUnimportantForLogging, elapsedRealtime, uptime);
        }
        int NO = ws.size();
        for (int i = 0; i < NO; ++i) {
            this.noteStopWakeLocked(ws.get(i), pid, name, historyName, type, elapsedRealtime, uptime);
        }
    }

    public void noteStopWakeFromSourceLocked(WorkSource ws, int pid, String name, String historyName, int type) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteStopWakeLocked(ws.get(i), pid, name, historyName, type, elapsedRealtime, uptime);
        }
    }

    void aggregateLastWakeupUptimeLocked(long uptimeMs) {
        if (this.mLastWakeupReason != null) {
            long deltaUptime = uptimeMs - this.mLastWakeupUptimeMs;
            SamplingTimer timer = this.getWakeupReasonTimerLocked(this.mLastWakeupReason);
            timer.addCurrentReportedCount(1);
            timer.addCurrentReportedTotalTime(deltaUptime * 1000L);
            this.mLastWakeupReason = null;
        }
    }

    public void noteWakeupReasonLocked(String reason) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.aggregateLastWakeupUptimeLocked(uptime);
        this.mHistoryCur.wakeReasonTag = this.mHistoryCur.localWakeReasonTag;
        this.mHistoryCur.wakeReasonTag.string = reason;
        this.mHistoryCur.wakeReasonTag.uid = 0;
        this.mLastWakeupReason = reason;
        this.mLastWakeupUptimeMs = uptime;
        this.addHistoryRecordLocked(elapsedRealtime, uptime);
    }

    public boolean startAddingCpuLocked() {
        this.mHandler.removeMessages(1);
        return this.mOnBatteryInternal;
    }

    public void finishAddingCpuLocked(int totalUTime, int totalSTime, int statUserTime, int statSystemTime, int statIOWaitTime, int statIrqTime, int statSoftIrqTime, int statIdleTime) {
        this.mCurStepCpuUserTime += (long)totalUTime;
        this.mCurStepCpuSystemTime += (long)totalSTime;
        this.mCurStepStatUserTime += (long)statUserTime;
        this.mCurStepStatSystemTime += (long)statSystemTime;
        this.mCurStepStatIOWaitTime += (long)statIOWaitTime;
        this.mCurStepStatIrqTime += (long)statIrqTime;
        this.mCurStepStatSoftIrqTime += (long)statSoftIrqTime;
        this.mCurStepStatIdleTime += (long)statIdleTime;
    }

    public void noteProcessDiedLocked(int uid, int pid) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.mPids.remove(pid);
        }
    }

    public long getProcessWakeTime(int uid, int pid, long realtime) {
        BatteryStats.Uid.Pid p;
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null && (p = u.mPids.get(pid)) != null) {
            return p.mWakeSumMs + (p.mWakeNesting > 0 ? realtime - p.mWakeStartMs : 0L);
        }
        return 0L;
    }

    public void reportExcessiveWakeLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.reportExcessiveWakeLocked(proc, overTime, usedTime);
        }
    }

    public void reportExcessiveCpuLocked(int uid, String proc, long overTime, long usedTime) {
        Uid u = this.mUidStats.get(uid = this.mapUid(uid));
        if (u != null) {
            u.reportExcessiveCpuLocked(proc, overTime, usedTime);
        }
    }

    public void noteStartSensorLocked(int uid, int sensor) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states |= 0x800000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mSensorNesting;
        this.getUidStatsLocked(uid).noteStartSensor(sensor, elapsedRealtime);
    }

    public void noteStopSensorLocked(int uid, int sensor) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        --this.mSensorNesting;
        if (this.mSensorNesting == 0) {
            this.mHistoryCur.states &= 0xFF7FFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteStopSensor(sensor, elapsedRealtime);
    }

    public void noteStartGpsLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mGpsNesting;
        this.getUidStatsLocked(uid).noteStartGps(elapsedRealtime);
    }

    public void noteStopGpsLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        --this.mGpsNesting;
        if (this.mGpsNesting == 0) {
            this.mHistoryCur.states &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteStopGps(elapsedRealtime);
    }

    public void noteScreenStateLocked(int state) {
        if (this.mScreenState != state) {
            this.recordDailyStatsIfNeededLocked(true);
            int oldState = this.mScreenState;
            this.mScreenState = state;
            if (state != 0) {
                int stepState = state - 1;
                if (stepState < 4) {
                    this.mModStepMode |= this.mCurStepMode & 3 ^ stepState;
                    this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFC | stepState;
                } else {
                    Slog.wtf(TAG, "Unexpected screen state: " + state);
                }
            }
            if (state == 2) {
                long elapsedRealtime = SystemClock.elapsedRealtime();
                long uptime = SystemClock.uptimeMillis();
                this.mHistoryCur.states |= 0x100000;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
                this.mScreenOnTimer.startRunningLocked(elapsedRealtime);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].startRunningLocked(elapsedRealtime);
                }
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), false, SystemClock.uptimeMillis() * 1000L, elapsedRealtime * 1000L);
                this.noteStartWakeLocked(-1, -1, "screen", null, 0, false, elapsedRealtime, uptime);
                if (this.mOnBatteryInternal) {
                    this.updateDischargeScreenLevelsLocked(false, true);
                }
            } else if (oldState == 2) {
                long elapsedRealtime = SystemClock.elapsedRealtime();
                long uptime = SystemClock.uptimeMillis();
                this.mHistoryCur.states &= 0xFFEFFFFF;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
                this.mScreenOnTimer.stopRunningLocked(elapsedRealtime);
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtime);
                }
                this.noteStopWakeLocked(-1, -1, "screen", "screen", 0, elapsedRealtime, uptime);
                this.updateTimeBasesLocked(this.mOnBatteryTimeBase.isRunning(), true, SystemClock.uptimeMillis() * 1000L, elapsedRealtime * 1000L);
                if (this.mOnBatteryInternal) {
                    this.updateDischargeScreenLevelsLocked(true, false);
                }
            }
        }
    }

    public void noteScreenBrightnessLocked(int brightness) {
        int bin = brightness / 51;
        if (bin < 0) {
            bin = 0;
        } else if (bin >= 5) {
            bin = 4;
        }
        if (this.mScreenBrightnessBin != bin) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFF8 | bin << 0;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mScreenState == 2) {
                if (this.mScreenBrightnessBin >= 0) {
                    this.mScreenBrightnessTimer[this.mScreenBrightnessBin].stopRunningLocked(elapsedRealtime);
                }
                this.mScreenBrightnessTimer[bin].startRunningLocked(elapsedRealtime);
            }
            this.mScreenBrightnessBin = bin;
        }
    }

    public void noteUserActivityLocked(int uid, int event) {
        if (this.mOnBatteryInternal) {
            uid = this.mapUid(uid);
            this.getUidStatsLocked(uid).noteUserActivityLocked(event);
        }
    }

    public void noteWakeUpLocked(String reason, int reasonUid) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 18, reason, reasonUid);
    }

    public void noteInteractiveLocked(boolean interactive) {
        if (this.mInteractive != interactive) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            this.mInteractive = interactive;
            if (interactive) {
                this.mInteractiveTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mInteractiveTimer.stopRunningLocked(elapsedRealtime);
            }
        }
    }

    public void noteConnectivityChangedLocked(int type, String extra) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 9, extra, type);
        ++this.mNumConnectivityChange;
    }

    public void noteMobileRadioPowerState(int powerState, long timestampNs) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mMobileRadioPowerState != powerState) {
            long realElapsedRealtimeMs;
            boolean active;
            boolean bl = active = powerState == DataConnectionRealTimeInfo.DC_POWER_STATE_MEDIUM || powerState == DataConnectionRealTimeInfo.DC_POWER_STATE_HIGH;
            if (active) {
                this.mMobileRadioActiveStartTime = realElapsedRealtimeMs = elapsedRealtime;
                this.mHistoryCur.states |= 0x2000000;
            } else {
                realElapsedRealtimeMs = timestampNs / 1000000L;
                long lastUpdateTimeMs = this.mMobileRadioActiveStartTime;
                if (realElapsedRealtimeMs < lastUpdateTimeMs) {
                    Slog.wtf(TAG, "Data connection inactive timestamp " + realElapsedRealtimeMs + " is before start time " + lastUpdateTimeMs);
                    realElapsedRealtimeMs = elapsedRealtime;
                } else if (realElapsedRealtimeMs < elapsedRealtime) {
                    this.mMobileRadioActiveAdjustedTime.addCountLocked(elapsedRealtime - realElapsedRealtimeMs);
                }
                this.mHistoryCur.states &= 0xFDFFFFFF;
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mMobileRadioPowerState = powerState;
            if (active) {
                this.mMobileRadioActiveTimer.startRunningLocked(elapsedRealtime);
                this.mMobileRadioActivePerAppTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mMobileRadioActiveTimer.stopRunningLocked(realElapsedRealtimeMs);
                this.updateMobileRadioStateLocked(realElapsedRealtimeMs);
                this.mMobileRadioActivePerAppTimer.stopRunningLocked(realElapsedRealtimeMs);
            }
        }
    }

    public void notePowerSaveMode(boolean enabled) {
        if (this.mPowerSaveModeEnabled != enabled) {
            int stepState = enabled ? 4 : 0;
            this.mModStepMode |= this.mCurStepMode & 4 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFFB | stepState;
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mPowerSaveModeEnabled = enabled;
            if (enabled) {
                this.mHistoryCur.states2 |= Integer.MIN_VALUE;
                this.mPowerSaveModeEnabledTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mHistoryCur.states2 &= Integer.MAX_VALUE;
                this.mPowerSaveModeEnabledTimer.stopRunningLocked(elapsedRealtime);
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    public void noteDeviceIdleModeLocked(boolean enabled, String activeReason, int activeUid) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        boolean nowIdling = enabled;
        if (this.mDeviceIdling && !enabled && activeReason == null) {
            nowIdling = true;
        }
        if (this.mDeviceIdling != nowIdling) {
            this.mDeviceIdling = nowIdling;
            int stepState = nowIdling ? 8 : 0;
            this.mModStepMode |= this.mCurStepMode & 8 ^ stepState;
            this.mCurStepMode = this.mCurStepMode & 0xFFFFFFF7 | stepState;
            if (enabled) {
                this.mDeviceIdlingTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mDeviceIdlingTimer.stopRunningLocked(elapsedRealtime);
            }
        }
        if (this.mDeviceIdleModeEnabled != enabled) {
            this.mDeviceIdleModeEnabled = enabled;
            this.addHistoryEventLocked(elapsedRealtime, uptime, 10, activeReason != null ? activeReason : "", activeUid);
            if (enabled) {
                this.mHistoryCur.states2 |= 0x4000000;
                this.mDeviceIdleModeEnabledTimer.startRunningLocked(elapsedRealtime);
            } else {
                this.mHistoryCur.states2 &= 0xFBFFFFFF;
                this.mDeviceIdleModeEnabledTimer.stopRunningLocked(elapsedRealtime);
            }
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    public void notePackageInstalledLocked(String pkgName, int versionCode) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 11, pkgName, versionCode);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        pc.mVersionCode = versionCode;
        this.addPackageChange(pc);
    }

    public void notePackageUninstalledLocked(String pkgName) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        this.addHistoryEventLocked(elapsedRealtime, uptime, 12, pkgName, 0);
        BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
        pc.mPackageName = pkgName;
        pc.mUpdate = true;
        this.addPackageChange(pc);
    }

    private void addPackageChange(BatteryStats.PackageChange pc) {
        if (this.mDailyPackageChanges == null) {
            this.mDailyPackageChanges = new ArrayList();
        }
        this.mDailyPackageChanges.add(pc);
    }

    public void notePhoneOnLocked() {
        if (!this.mPhoneOn) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states2 |= 0x1000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mPhoneOn = true;
            this.mPhoneOnTimer.startRunningLocked(elapsedRealtime);
        }
    }

    public void notePhoneOffLocked() {
        if (this.mPhoneOn) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states2 &= 0xFEFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mPhoneOn = false;
            this.mPhoneOnTimer.stopRunningLocked(elapsedRealtime);
        }
    }

    void stopAllPhoneSignalStrengthTimersLocked(int except) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mPhoneSignalStrengthsTimer[i].isRunningLocked()) {
                this.mPhoneSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    private int fixPhoneServiceState(int state, int signalBin) {
        if (this.mPhoneSimStateRaw == 1 && state == 1 && signalBin > 0) {
            state = 0;
        }
        return state;
    }

    private void updateAllPhoneStateLocked(int state, int simState, int strengthBin) {
        boolean scanning = false;
        boolean newHistory = false;
        this.mPhoneServiceStateRaw = state;
        this.mPhoneSimStateRaw = simState;
        this.mPhoneSignalStrengthBinRaw = strengthBin;
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (simState == 1 && state == 1 && strengthBin > 0) {
            state = 0;
        }
        if (state == 3) {
            strengthBin = -1;
        } else if (state != 0 && state == 1) {
            scanning = true;
            strengthBin = 0;
            if (!this.mPhoneSignalScanningTimer.isRunningLocked()) {
                this.mHistoryCur.states |= 0x200000;
                newHistory = true;
                this.mPhoneSignalScanningTimer.startRunningLocked(elapsedRealtime);
            }
        }
        if (!scanning && this.mPhoneSignalScanningTimer.isRunningLocked()) {
            this.mHistoryCur.states &= 0xFFDFFFFF;
            newHistory = true;
            this.mPhoneSignalScanningTimer.stopRunningLocked(elapsedRealtime);
        }
        if (this.mPhoneServiceState != state) {
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFE3F | state << 6;
            newHistory = true;
            this.mPhoneServiceState = state;
        }
        if (this.mPhoneSignalStrengthBin != strengthBin) {
            if (this.mPhoneSignalStrengthBin >= 0) {
                this.mPhoneSignalStrengthsTimer[this.mPhoneSignalStrengthBin].stopRunningLocked(elapsedRealtime);
            }
            if (strengthBin >= 0) {
                if (!this.mPhoneSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mPhoneSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtime);
                }
                this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFFFC7 | strengthBin << 3;
                newHistory = true;
            } else {
                this.stopAllPhoneSignalStrengthTimersLocked(-1);
            }
            this.mPhoneSignalStrengthBin = strengthBin;
        }
        if (newHistory) {
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    public void notePhoneStateLocked(int state, int simState) {
        this.updateAllPhoneStateLocked(state, simState, this.mPhoneSignalStrengthBinRaw);
    }

    public void notePhoneSignalStrengthLocked(SignalStrength signalStrength) {
        int bin = signalStrength.getLevel();
        this.updateAllPhoneStateLocked(this.mPhoneServiceStateRaw, this.mPhoneSimStateRaw, bin);
    }

    public void notePhoneDataConnectionStateLocked(int dataType, boolean hasData) {
        int bin = 0;
        if (hasData) {
            switch (dataType) {
                case 2: {
                    bin = 2;
                    break;
                }
                case 1: {
                    bin = 1;
                    break;
                }
                case 3: {
                    bin = 3;
                    break;
                }
                case 4: {
                    bin = 4;
                    break;
                }
                case 5: {
                    bin = 5;
                    break;
                }
                case 6: {
                    bin = 6;
                    break;
                }
                case 7: {
                    bin = 7;
                    break;
                }
                case 8: {
                    bin = 8;
                    break;
                }
                case 9: {
                    bin = 9;
                    break;
                }
                case 10: {
                    bin = 10;
                    break;
                }
                case 11: {
                    bin = 11;
                    break;
                }
                case 12: {
                    bin = 12;
                    break;
                }
                case 13: {
                    bin = 13;
                    break;
                }
                case 14: {
                    bin = 14;
                    break;
                }
                case 15: {
                    bin = 15;
                    break;
                }
                default: {
                    bin = 16;
                }
            }
        }
        if (this.mPhoneDataConnectionType != bin) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states = this.mHistoryCur.states & 0xFFFFC1FF | bin << 9;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            if (this.mPhoneDataConnectionType >= 0) {
                this.mPhoneDataConnectionsTimer[this.mPhoneDataConnectionType].stopRunningLocked(elapsedRealtime);
            }
            this.mPhoneDataConnectionType = bin;
            this.mPhoneDataConnectionsTimer[bin].startRunningLocked(elapsedRealtime);
        }
    }

    public void noteWifiOnLocked() {
        if (!this.mWifiOn) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states2 |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiOn = true;
            this.mWifiOnTimer.startRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalWifiStatsLocked("wifi-off");
        }
    }

    public void noteWifiOffLocked() {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mWifiOn) {
            this.mHistoryCur.states2 &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiOn = false;
            this.mWifiOnTimer.stopRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalWifiStatsLocked("wifi-on");
        }
    }

    public void noteAudioOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mAudioOnNesting == 0) {
            this.mHistoryCur.states |= 0x400000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mAudioOnNesting;
        this.getUidStatsLocked(uid).noteAudioTurnedOnLocked(elapsedRealtime);
    }

    public void noteAudioOffLocked(int uid) {
        if (this.mAudioOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (--this.mAudioOnNesting == 0) {
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteAudioTurnedOffLocked(elapsedRealtime);
    }

    public void noteVideoOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 |= 0x40000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.startRunningLocked(elapsedRealtime);
        }
        ++this.mVideoOnNesting;
        this.getUidStatsLocked(uid).noteVideoTurnedOnLocked(elapsedRealtime);
    }

    public void noteVideoOffLocked(int uid) {
        if (this.mVideoOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (--this.mVideoOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteVideoTurnedOffLocked(elapsedRealtime);
    }

    public void noteResetAudioLocked() {
        if (this.mAudioOnNesting > 0) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mAudioOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetAudioLocked(elapsedRealtime);
            }
        }
    }

    public void noteResetVideoLocked() {
        if (this.mVideoOnNesting > 0) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mAudioOnNesting = 0;
            this.mHistoryCur.states2 &= 0xBFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mVideoOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetVideoLocked(elapsedRealtime);
            }
        }
    }

    public void noteActivityResumedLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteActivityResumedLocked(SystemClock.elapsedRealtime());
    }

    public void noteActivityPausedLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteActivityPausedLocked(SystemClock.elapsedRealtime());
    }

    public void noteVibratorOnLocked(int uid, long durationMillis) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteVibratorOnLocked(durationMillis);
    }

    public void noteVibratorOffLocked(int uid) {
        uid = this.mapUid(uid);
        this.getUidStatsLocked(uid).noteVibratorOffLocked();
    }

    public void noteFlashlightOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mFlashlightOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.startRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteFlashlightTurnedOnLocked(elapsedRealtime);
    }

    public void noteFlashlightOffLocked(int uid) {
        if (this.mFlashlightOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (--this.mFlashlightOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteFlashlightTurnedOffLocked(elapsedRealtime);
    }

    public void noteCameraOnLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mCameraOnNesting++ == 0) {
            this.mHistoryCur.states2 |= 0x400000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.startRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteCameraTurnedOnLocked(elapsedRealtime);
    }

    public void noteCameraOffLocked(int uid) {
        if (this.mCameraOnNesting == 0) {
            return;
        }
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (--this.mCameraOnNesting == 0) {
            this.mHistoryCur.states2 &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.stopRunningLocked(elapsedRealtime);
        }
        this.getUidStatsLocked(uid).noteCameraTurnedOffLocked(elapsedRealtime);
    }

    public void noteResetCameraLocked() {
        if (this.mCameraOnNesting > 0) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mCameraOnNesting = 0;
            this.mHistoryCur.states2 &= 0xFFBFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mCameraOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetCameraLocked(elapsedRealtime);
            }
        }
    }

    public void noteResetFlashlightLocked() {
        if (this.mFlashlightOnNesting > 0) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mFlashlightOnNesting = 0;
            this.mHistoryCur.states2 &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mFlashlightOnTimer.stopAllRunningLocked(elapsedRealtime);
            for (int i = 0; i < this.mUidStats.size(); ++i) {
                Uid uid = this.mUidStats.valueAt(i);
                uid.noteResetFlashlightLocked(elapsedRealtime);
            }
        }
    }

    public void noteWifiRadioPowerState(int powerState, long timestampNs) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mWifiRadioPowerState != powerState) {
            boolean active;
            boolean bl = active = powerState == DataConnectionRealTimeInfo.DC_POWER_STATE_MEDIUM || powerState == DataConnectionRealTimeInfo.DC_POWER_STATE_HIGH;
            this.mHistoryCur.states = active ? (this.mHistoryCur.states |= 0x4000000) : (this.mHistoryCur.states &= 0xFBFFFFFF);
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mWifiRadioPowerState = powerState;
        }
    }

    public void noteWifiRunningLocked(WorkSource ws) {
        if (!this.mGlobalWifiRunning) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states2 |= 0x20000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGlobalWifiRunning = true;
            this.mGlobalWifiRunningTimer.startRunningLocked(elapsedRealtime);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.get(i));
                this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
            }
            this.scheduleSyncExternalWifiStatsLocked("wifi-running");
        } else {
            Log.w(TAG, "noteWifiRunningLocked -- called while WIFI running");
        }
    }

    public void noteWifiRunningChangedLocked(WorkSource oldWs, WorkSource newWs) {
        if (this.mGlobalWifiRunning) {
            int uid;
            int i;
            long elapsedRealtime = SystemClock.elapsedRealtime();
            int N = oldWs.size();
            for (i = 0; i < N; ++i) {
                uid = this.mapUid(oldWs.get(i));
                this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
            }
            N = newWs.size();
            for (i = 0; i < N; ++i) {
                uid = this.mapUid(newWs.get(i));
                this.getUidStatsLocked(uid).noteWifiRunningLocked(elapsedRealtime);
            }
        } else {
            Log.w(TAG, "noteWifiRunningChangedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiStoppedLocked(WorkSource ws) {
        if (this.mGlobalWifiRunning) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.mHistoryCur.states2 &= 0xDFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
            this.mGlobalWifiRunning = false;
            this.mGlobalWifiRunningTimer.stopRunningLocked(elapsedRealtime);
            int N = ws.size();
            for (int i = 0; i < N; ++i) {
                int uid = this.mapUid(ws.get(i));
                this.getUidStatsLocked(uid).noteWifiStoppedLocked(elapsedRealtime);
            }
            this.scheduleSyncExternalWifiStatsLocked("wifi-stopped");
        } else {
            Log.w(TAG, "noteWifiStoppedLocked -- called while WIFI not running");
        }
    }

    public void noteWifiStateLocked(int wifiState, String accessPoint) {
        if (this.mWifiState != wifiState) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            if (this.mWifiState >= 0) {
                this.mWifiStateTimer[this.mWifiState].stopRunningLocked(elapsedRealtime);
            }
            this.mWifiState = wifiState;
            this.mWifiStateTimer[wifiState].startRunningLocked(elapsedRealtime);
            this.scheduleSyncExternalWifiStatsLocked("wifi-state");
        }
    }

    public void noteWifiSupplicantStateChangedLocked(int supplState, boolean failedAuth) {
        if (this.mWifiSupplState != supplState) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            if (this.mWifiSupplState >= 0) {
                this.mWifiSupplStateTimer[this.mWifiSupplState].stopRunningLocked(elapsedRealtime);
            }
            this.mWifiSupplState = supplState;
            this.mWifiSupplStateTimer[supplState].startRunningLocked(elapsedRealtime);
            this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFFF0 | supplState << 0;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
    }

    void stopAllWifiSignalStrengthTimersLocked(int except) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        for (int i = 0; i < 5; ++i) {
            if (i == except) continue;
            while (this.mWifiSignalStrengthsTimer[i].isRunningLocked()) {
                this.mWifiSignalStrengthsTimer[i].stopRunningLocked(elapsedRealtime);
            }
        }
    }

    public void noteWifiRssiChangedLocked(int newRssi) {
        int strengthBin = WifiManager.calculateSignalLevel(newRssi, 5);
        if (this.mWifiSignalStrengthBin != strengthBin) {
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            if (this.mWifiSignalStrengthBin >= 0) {
                this.mWifiSignalStrengthsTimer[this.mWifiSignalStrengthBin].stopRunningLocked(elapsedRealtime);
            }
            if (strengthBin >= 0) {
                if (!this.mWifiSignalStrengthsTimer[strengthBin].isRunningLocked()) {
                    this.mWifiSignalStrengthsTimer[strengthBin].startRunningLocked(elapsedRealtime);
                }
                this.mHistoryCur.states2 = this.mHistoryCur.states2 & 0xFFFFFF8F | strengthBin << 4;
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            } else {
                this.stopAllWifiSignalStrengthTimersLocked(-1);
            }
            this.mWifiSignalStrengthBin = strengthBin;
        }
    }

    public void noteFullWifiLockAcquiredLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states |= 0x10000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiFullLockNesting;
        this.getUidStatsLocked(uid).noteFullWifiLockAcquiredLocked(elapsedRealtime);
    }

    public void noteFullWifiLockReleasedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        --this.mWifiFullLockNesting;
        if (this.mWifiFullLockNesting == 0) {
            this.mHistoryCur.states &= 0xEFFFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteFullWifiLockReleasedLocked(elapsedRealtime);
    }

    public void noteWifiScanStartedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states |= 0x8000000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiScanNesting;
        this.getUidStatsLocked(uid).noteWifiScanStartedLocked(elapsedRealtime);
    }

    public void noteWifiScanStoppedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        --this.mWifiScanNesting;
        if (this.mWifiScanNesting == 0) {
            this.mHistoryCur.states &= 0xF7FFFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteWifiScanStoppedLocked(elapsedRealtime);
    }

    public void noteWifiBatchedScanStartedLocked(int uid, int csph) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.getUidStatsLocked(uid).noteWifiBatchedScanStartedLocked(csph, elapsedRealtime);
    }

    public void noteWifiBatchedScanStoppedLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        this.getUidStatsLocked(uid).noteWifiBatchedScanStoppedLocked(elapsedRealtime);
    }

    public void noteWifiMulticastEnabledLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states |= 0x10000;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        ++this.mWifiMulticastNesting;
        this.getUidStatsLocked(uid).noteWifiMulticastEnabledLocked(elapsedRealtime);
    }

    public void noteWifiMulticastDisabledLocked(int uid) {
        uid = this.mapUid(uid);
        long elapsedRealtime = SystemClock.elapsedRealtime();
        long uptime = SystemClock.uptimeMillis();
        --this.mWifiMulticastNesting;
        if (this.mWifiMulticastNesting == 0) {
            this.mHistoryCur.states &= 0xFFFEFFFF;
            this.addHistoryRecordLocked(elapsedRealtime, uptime);
        }
        this.getUidStatsLocked(uid).noteWifiMulticastDisabledLocked(elapsedRealtime);
    }

    public void noteFullWifiLockAcquiredFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteFullWifiLockAcquiredLocked(ws.get(i));
        }
    }

    public void noteFullWifiLockReleasedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteFullWifiLockReleasedLocked(ws.get(i));
        }
    }

    public void noteWifiScanStartedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiScanStartedLocked(ws.get(i));
        }
    }

    public void noteWifiScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiScanStoppedLocked(ws.get(i));
        }
    }

    public void noteWifiBatchedScanStartedFromSourceLocked(WorkSource ws, int csph) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStartedLocked(ws.get(i), csph);
        }
    }

    public void noteWifiBatchedScanStoppedFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiBatchedScanStoppedLocked(ws.get(i));
        }
    }

    public void noteWifiMulticastEnabledFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiMulticastEnabledLocked(ws.get(i));
        }
    }

    public void noteWifiMulticastDisabledFromSourceLocked(WorkSource ws) {
        int N = ws.size();
        for (int i = 0; i < N; ++i) {
            this.noteWifiMulticastDisabledLocked(ws.get(i));
        }
    }

    private static String[] includeInStringArray(String[] array2, String str) {
        if (ArrayUtils.indexOf(array2, str) >= 0) {
            return array2;
        }
        String[] newArray = new String[array2.length + 1];
        System.arraycopy(array2, 0, newArray, 0, array2.length);
        newArray[array2.length] = str;
        return newArray;
    }

    private static String[] excludeFromStringArray(String[] array2, String str) {
        int index = ArrayUtils.indexOf(array2, str);
        if (index >= 0) {
            String[] newArray = new String[array2.length - 1];
            if (index > 0) {
                System.arraycopy(array2, 0, newArray, 0, index);
            }
            if (index < array2.length - 1) {
                System.arraycopy(array2, index + 1, newArray, index, array2.length - index - 1);
            }
            return newArray;
        }
        return array2;
    }

    public void noteNetworkInterfaceTypeLocked(String iface, int networkType) {
        if (TextUtils.isEmpty(iface)) {
            return;
        }
        this.mMobileIfaces = ConnectivityManager.isNetworkTypeMobile(networkType) ? BatteryStatsImpl.includeInStringArray(this.mMobileIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mMobileIfaces, iface);
        this.mWifiIfaces = ConnectivityManager.isNetworkTypeWifi(networkType) ? BatteryStatsImpl.includeInStringArray(this.mWifiIfaces, iface) : BatteryStatsImpl.excludeFromStringArray(this.mWifiIfaces, iface);
    }

    public void noteNetworkStatsEnabledLocked() {
        long elapsedRealtimeMs = SystemClock.elapsedRealtime();
        this.updateMobileRadioStateLocked(elapsedRealtimeMs);
        this.updateWifiStateLocked(null);
    }

    @Override
    public long getScreenOnTime(long elapsedRealtimeUs, int which) {
        return this.mScreenOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getScreenOnCount(int which) {
        return this.mScreenOnTimer.getCountLocked(which);
    }

    @Override
    public long getScreenBrightnessTime(int brightnessBin, long elapsedRealtimeUs, int which) {
        return this.mScreenBrightnessTimer[brightnessBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getInteractiveTime(long elapsedRealtimeUs, int which) {
        return this.mInteractiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getPowerSaveModeEnabledTime(long elapsedRealtimeUs, int which) {
        return this.mPowerSaveModeEnabledTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPowerSaveModeEnabledCount(int which) {
        return this.mPowerSaveModeEnabledTimer.getCountLocked(which);
    }

    @Override
    public long getDeviceIdleModeEnabledTime(long elapsedRealtimeUs, int which) {
        return this.mDeviceIdleModeEnabledTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getDeviceIdleModeEnabledCount(int which) {
        return this.mDeviceIdleModeEnabledTimer.getCountLocked(which);
    }

    @Override
    public long getDeviceIdlingTime(long elapsedRealtimeUs, int which) {
        return this.mDeviceIdlingTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getDeviceIdlingCount(int which) {
        return this.mDeviceIdlingTimer.getCountLocked(which);
    }

    @Override
    public int getNumConnectivityChange(int which) {
        int val = this.mNumConnectivityChange;
        if (which == 1) {
            val -= this.mLoadedNumConnectivityChange;
        } else if (which == 2) {
            val -= this.mUnpluggedNumConnectivityChange;
        }
        return val;
    }

    @Override
    public long getPhoneOnTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPhoneOnCount(int which) {
        return this.mPhoneOnTimer.getCountLocked(which);
    }

    @Override
    public long getPhoneSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getPhoneSignalScanningTime(long elapsedRealtimeUs, int which) {
        return this.mPhoneSignalScanningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPhoneSignalStrengthCount(int strengthBin, int which) {
        return this.mPhoneSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public long getPhoneDataConnectionTime(int dataType, long elapsedRealtimeUs, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getPhoneDataConnectionCount(int dataType, int which) {
        return this.mPhoneDataConnectionsTimer[dataType].getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveTime(long elapsedRealtimeUs, int which) {
        return this.mMobileRadioActiveTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getMobileRadioActiveCount(int which) {
        return this.mMobileRadioActiveTimer.getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveAdjustedTime(int which) {
        return this.mMobileRadioActiveAdjustedTime.getCountLocked(which);
    }

    @Override
    public long getMobileRadioActiveUnknownTime(int which) {
        return this.mMobileRadioActiveUnknownTime.getCountLocked(which);
    }

    @Override
    public int getMobileRadioActiveUnknownCount(int which) {
        return (int)this.mMobileRadioActiveUnknownCount.getCountLocked(which);
    }

    @Override
    public long getWifiOnTime(long elapsedRealtimeUs, int which) {
        return this.mWifiOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getGlobalWifiRunningTime(long elapsedRealtimeUs, int which) {
        return this.mGlobalWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getWifiStateTime(int wifiState, long elapsedRealtimeUs, int which) {
        return this.mWifiStateTimer[wifiState].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiStateCount(int wifiState, int which) {
        return this.mWifiStateTimer[wifiState].getCountLocked(which);
    }

    @Override
    public long getWifiSupplStateTime(int state, long elapsedRealtimeUs, int which) {
        return this.mWifiSupplStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiSupplStateCount(int state, int which) {
        return this.mWifiSupplStateTimer[state].getCountLocked(which);
    }

    @Override
    public long getWifiSignalStrengthTime(int strengthBin, long elapsedRealtimeUs, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public int getWifiSignalStrengthCount(int strengthBin, int which) {
        return this.mWifiSignalStrengthsTimer[strengthBin].getCountLocked(which);
    }

    @Override
    public boolean hasBluetoothActivityReporting() {
        return this.mHasBluetoothEnergyReporting;
    }

    @Override
    public long getBluetoothControllerActivity(int type, int which) {
        if (type >= 0 && type < this.mBluetoothActivityCounters.length) {
            return this.mBluetoothActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public boolean hasWifiActivityReporting() {
        return this.mHasWifiEnergyReporting;
    }

    @Override
    public long getWifiControllerActivity(int type, int which) {
        if (type >= 0 && type < this.mWifiActivityCounters.length) {
            return this.mWifiActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public long getFlashlightOnTime(long elapsedRealtimeUs, int which) {
        return this.mFlashlightOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getFlashlightOnCount(int which) {
        return this.mFlashlightOnTimer.getCountLocked(which);
    }

    @Override
    public long getCameraOnTime(long elapsedRealtimeUs, int which) {
        return this.mCameraOnTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
    }

    @Override
    public long getNetworkActivityBytes(int type, int which) {
        if (type >= 0 && type < this.mNetworkByteActivityCounters.length) {
            return this.mNetworkByteActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public long getNetworkActivityPackets(int type, int which) {
        if (type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
            return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
        }
        return 0L;
    }

    @Override
    public long getStartClockTime() {
        long currentTime = System.currentTimeMillis();
        if (this.ensureStartClockTime(currentTime)) {
            this.recordCurrentTimeChangeLocked(currentTime, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
        return this.mStartClockTime;
    }

    @Override
    public String getStartPlatformVersion() {
        return this.mStartPlatformVersion;
    }

    @Override
    public String getEndPlatformVersion() {
        return this.mEndPlatformVersion;
    }

    @Override
    public int getParcelVersion() {
        return 130;
    }

    @Override
    public boolean getIsOnBattery() {
        return this.mOnBattery;
    }

    @Override
    public SparseArray<? extends BatteryStats.Uid> getUidStats() {
        return this.mUidStats;
    }

    public BatteryStatsImpl(File systemDir, Handler handler, ExternalStatsSync externalSync) {
        int i;
        this.mFile = systemDir != null ? new JournaledFile(new File(systemDir, "batterystats.bin"), new File(systemDir, "batterystats.bin.tmp")) : null;
        this.mCheckinFile = new AtomicFile(new File(systemDir, "batterystats-checkin.bin"));
        this.mDailyFile = new AtomicFile(new File(systemDir, "batterystats-daily.xml"));
        this.mExternalSync = externalSync;
        this.mHandler = new MyHandler(handler.getLooper());
        ++this.mStartCount;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mOnBatteryTimeBase);
        }
        this.mInteractiveTimer = new StopwatchTimer(null, -10, null, this.mOnBatteryTimeBase);
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(null, -2, null, this.mOnBatteryTimeBase);
        this.mDeviceIdleModeEnabledTimer = new StopwatchTimer(null, -11, null, this.mOnBatteryTimeBase);
        this.mDeviceIdlingTimer = new StopwatchTimer(null, -12, null, this.mOnBatteryTimeBase);
        this.mPhoneOnTimer = new StopwatchTimer(null, -3, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mOnBatteryTimeBase);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 4; ++i) {
            this.mBluetoothActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
            this.mWifiActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase);
        }
        this.mMobileRadioActiveTimer = new StopwatchTimer(null, -400, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(null, -401, null, this.mOnBatteryTimeBase);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase);
        this.mWifiOnTimer = new StopwatchTimer(null, -4, null, this.mOnBatteryTimeBase);
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -5, null, this.mOnBatteryTimeBase);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(null, -600 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(null, -700 - i, null, this.mOnBatteryTimeBase);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(null, -800 - i, null, this.mOnBatteryTimeBase);
        }
        this.mAudioOnTimer = new StopwatchTimer(null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnTimer = new StopwatchTimer(null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnTimer = new StopwatchTimer(null, -9, null, this.mOnBatteryTimeBase);
        this.mCameraOnTimer = new StopwatchTimer(null, -13, null, this.mOnBatteryTimeBase);
        this.mOnBatteryInternal = false;
        this.mOnBattery = false;
        long uptime = SystemClock.uptimeMillis() * 1000L;
        long realtime = SystemClock.elapsedRealtime() * 1000L;
        this.initTimes(uptime, realtime);
        this.mStartPlatformVersion = this.mEndPlatformVersion = Build.ID;
        this.mDischargeStartLevel = 0;
        this.mDischargeUnplugLevel = 0;
        this.mDischargePlugLevel = -1;
        this.mDischargeCurrentLevel = 0;
        this.mCurrentBatteryLevel = 0;
        this.initDischarge();
        this.clearHistoryLocked();
        this.updateDailyDeadlineLocked();
    }

    public BatteryStatsImpl(Parcel p) {
        this.mFile = null;
        this.mCheckinFile = null;
        this.mDailyFile = null;
        this.mHandler = null;
        this.mExternalSync = null;
        this.clearHistoryLocked();
        this.readFromParcel(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPowerProfile(PowerProfile profile) {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            this.mPowerProfile = profile;
        }
    }

    public void setCallback(BatteryCallback cb) {
        this.mCallback = cb;
    }

    public void setNumSpeedSteps(int steps) {
        if (sNumSpeedSteps == 0) {
            sNumSpeedSteps = steps;
        }
    }

    public void setRadioScanningTimeout(long timeout) {
        if (this.mPhoneSignalScanningTimer != null) {
            this.mPhoneSignalScanningTimer.setTimeout(timeout);
        }
    }

    public void updateDailyDeadlineLocked() {
        long currentTime = this.mDailyStartTime = System.currentTimeMillis();
        Calendar calDeadline = Calendar.getInstance();
        calDeadline.setTimeInMillis(currentTime);
        calDeadline.set(6, calDeadline.get(6) + 1);
        calDeadline.set(14, 0);
        calDeadline.set(13, 0);
        calDeadline.set(12, 0);
        calDeadline.set(11, 1);
        this.mNextMinDailyDeadline = calDeadline.getTimeInMillis();
        calDeadline.set(11, 3);
        this.mNextMaxDailyDeadline = calDeadline.getTimeInMillis();
    }

    public void recordDailyStatsIfNeededLocked(boolean settled) {
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.mNextMaxDailyDeadline) {
            this.recordDailyStatsLocked();
        } else if (settled && currentTime >= this.mNextMinDailyDeadline) {
            this.recordDailyStatsLocked();
        } else if (currentTime < this.mDailyStartTime - 86400000L) {
            this.recordDailyStatsLocked();
        }
    }

    public void recordDailyStatsLocked() {
        BatteryStats.DailyItem item = new BatteryStats.DailyItem();
        item.mStartTime = this.mDailyStartTime;
        item.mEndTime = System.currentTimeMillis();
        boolean hasData = false;
        if (this.mDailyDischargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mDischargeSteps = new BatteryStats.LevelStepTracker(this.mDailyDischargeStepTracker.mNumStepDurations, this.mDailyDischargeStepTracker.mStepDurations);
        }
        if (this.mDailyChargeStepTracker.mNumStepDurations > 0) {
            hasData = true;
            item.mChargeSteps = new BatteryStats.LevelStepTracker(this.mDailyChargeStepTracker.mNumStepDurations, this.mDailyChargeStepTracker.mStepDurations);
        }
        if (this.mDailyPackageChanges != null) {
            hasData = true;
            item.mPackageChanges = this.mDailyPackageChanges;
            this.mDailyPackageChanges = null;
        }
        this.mDailyDischargeStepTracker.init();
        this.mDailyChargeStepTracker.init();
        this.updateDailyDeadlineLocked();
        if (hasData) {
            this.mDailyItems.add(item);
            while (this.mDailyItems.size() > 10) {
                this.mDailyItems.remove(0);
            }
            final ByteArrayOutputStream memStream = new ByteArrayOutputStream();
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(memStream, StandardCharsets.UTF_8.name());
                this.writeDailyItemsLocked(out);
                BackgroundThread.getHandler().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                        synchronized (atomicFile) {
                            FileOutputStream stream = null;
                            try {
                                stream = BatteryStatsImpl.this.mDailyFile.startWrite();
                                memStream.writeTo(stream);
                                stream.flush();
                                FileUtils.sync(stream);
                                stream.close();
                                BatteryStatsImpl.this.mDailyFile.finishWrite(stream);
                            }
                            catch (IOException e) {
                                Slog.w("BatteryStats", "Error writing battery daily items", e);
                                BatteryStatsImpl.this.mDailyFile.failWrite(stream);
                            }
                        }
                    }
                });
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void writeDailyItemsLocked(XmlSerializer out) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        out.startDocument(null, true);
        out.startTag(null, "daily-items");
        for (int i = 0; i < this.mDailyItems.size(); ++i) {
            BatteryStats.DailyItem dit = this.mDailyItems.get(i);
            out.startTag(null, "item");
            out.attribute(null, "start", Long.toString(dit.mStartTime));
            out.attribute(null, "end", Long.toString(dit.mEndTime));
            this.writeDailyLevelSteps(out, "dis", dit.mDischargeSteps, sb);
            this.writeDailyLevelSteps(out, "chg", dit.mChargeSteps, sb);
            if (dit.mPackageChanges != null) {
                for (int j = 0; j < dit.mPackageChanges.size(); ++j) {
                    BatteryStats.PackageChange pc = dit.mPackageChanges.get(j);
                    if (pc.mUpdate) {
                        out.startTag(null, "upd");
                        out.attribute(null, "pkg", pc.mPackageName);
                        out.attribute(null, "ver", Integer.toString(pc.mVersionCode));
                        out.endTag(null, "upd");
                        continue;
                    }
                    out.startTag(null, "rem");
                    out.attribute(null, "pkg", pc.mPackageName);
                    out.endTag(null, "rem");
                }
            }
            out.endTag(null, "item");
        }
        out.endTag(null, "daily-items");
        out.endDocument();
    }

    private void writeDailyLevelSteps(XmlSerializer out, String tag, BatteryStats.LevelStepTracker steps, StringBuilder tmpBuilder) throws IOException {
        if (steps != null) {
            out.startTag(null, tag);
            out.attribute(null, "n", Integer.toString(steps.mNumStepDurations));
            for (int i = 0; i < steps.mNumStepDurations; ++i) {
                out.startTag(null, "s");
                tmpBuilder.setLength(0);
                steps.encodeEntryAt(i, tmpBuilder);
                out.attribute(null, "v", tmpBuilder.toString());
                out.endTag(null, "s");
            }
            out.endTag(null, tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDailyStatsLocked() {
        FileInputStream stream;
        Slog.d(TAG, "Reading daily items from " + this.mDailyFile.getBaseFile());
        this.mDailyItems.clear();
        try {
            stream = this.mDailyFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            this.readDailyItemsLocked(parser);
        }
        catch (XmlPullParserException e) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    private void readDailyItemsLocked(XmlPullParser parser) {
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("item")) {
                    this.readDailyItemTagLocked(parser);
                    continue;
                }
                Slog.w(TAG, "Unknown element under <daily-items>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing daily " + e);
        }
    }

    void readDailyItemTagLocked(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        BatteryStats.DailyItem dit = new BatteryStats.DailyItem();
        String attr2 = parser.getAttributeValue(null, "start");
        if (attr2 != null) {
            dit.mStartTime = Long.parseLong(attr2);
        }
        if ((attr2 = parser.getAttributeValue(null, "end")) != null) {
            dit.mEndTime = Long.parseLong(attr2);
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            BatteryStats.PackageChange pc;
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("dis")) {
                this.readDailyItemTagDetailsLocked(parser, dit, false, "dis");
                continue;
            }
            if (tagName.equals("chg")) {
                this.readDailyItemTagDetailsLocked(parser, dit, true, "chg");
                continue;
            }
            if (tagName.equals("upd")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = true;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                String verStr = parser.getAttributeValue(null, "ver");
                pc.mVersionCode = verStr != null ? Integer.parseInt(verStr) : 0;
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if (tagName.equals("rem")) {
                if (dit.mPackageChanges == null) {
                    dit.mPackageChanges = new ArrayList();
                }
                pc = new BatteryStats.PackageChange();
                pc.mUpdate = false;
                pc.mPackageName = parser.getAttributeValue(null, "pkg");
                dit.mPackageChanges.add(pc);
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            Slog.w(TAG, "Unknown element under <item>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        this.mDailyItems.add(dit);
    }

    void readDailyItemTagDetailsLocked(XmlPullParser parser, BatteryStats.DailyItem dit, boolean isCharge, String tag) throws NumberFormatException, XmlPullParserException, IOException {
        int type;
        String numAttr = parser.getAttributeValue(null, "n");
        if (numAttr == null) {
            Slog.w(TAG, "Missing 'n' attribute at " + parser.getPositionDescription());
            XmlUtils.skipCurrentTag(parser);
            return;
        }
        int num = Integer.parseInt(numAttr);
        BatteryStats.LevelStepTracker steps = new BatteryStats.LevelStepTracker(num);
        if (isCharge) {
            dit.mChargeSteps = steps;
        } else {
            dit.mDischargeSteps = steps;
        }
        int i = 0;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("s".equals(tagName)) {
                String valueAttr;
                if (i >= num || (valueAttr = parser.getAttributeValue(null, "v")) == null) continue;
                steps.decodeEntryAt(i, valueAttr);
                ++i;
                continue;
            }
            Slog.w(TAG, "Unknown element under <" + tag + ">: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        steps.mNumStepDurations = i;
    }

    @Override
    public BatteryStats.DailyItem getDailyItemLocked(int daysAgo) {
        int index = this.mDailyItems.size() - 1 - daysAgo;
        return index >= 0 ? this.mDailyItems.get(index) : null;
    }

    @Override
    public long getCurrentDailyStartTime() {
        return this.mDailyStartTime;
    }

    @Override
    public long getNextMinDailyDeadline() {
        return this.mNextMinDailyDeadline;
    }

    @Override
    public long getNextMaxDailyDeadline() {
        return this.mNextMaxDailyDeadline;
    }

    @Override
    public boolean startIteratingOldHistoryLocked() {
        this.mHistoryIterator = this.mHistory;
        if (this.mHistoryIterator == null) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryReadTmp.clear();
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        return true;
    }

    @Override
    public boolean getNextOldHistoryLocked(BatteryStats.HistoryItem out) {
        BatteryStats.HistoryItem cur;
        boolean end;
        boolean bl = end = this.mHistoryBuffer.dataPosition() >= this.mHistoryBuffer.dataSize();
        if (!end) {
            this.readHistoryDelta(this.mHistoryBuffer, this.mHistoryReadTmp);
            this.mReadOverflow |= this.mHistoryReadTmp.cmd == 6;
        }
        if ((cur = this.mHistoryIterator) == null) {
            if (!this.mReadOverflow && !end) {
                Slog.w(TAG, "Old history ends before new history!");
            }
            return false;
        }
        out.setTo(cur);
        this.mHistoryIterator = cur.next;
        if (!this.mReadOverflow) {
            if (end) {
                Slog.w(TAG, "New history ends before old history!");
            } else if (!out.same(this.mHistoryReadTmp)) {
                FastPrintWriter pw = new FastPrintWriter(new LogWriter(5, TAG));
                pw.println("Histories differ!");
                pw.println("Old history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, out, 0L, false, true);
                pw.println("New history:");
                new BatteryStats.HistoryPrinter().printNextItem(pw, this.mHistoryReadTmp, 0L, false, true);
                ((PrintWriter)pw).flush();
            }
        }
        return true;
    }

    @Override
    public void finishIteratingOldHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mHistoryIterator = null;
    }

    @Override
    public int getHistoryTotalSize() {
        return 262144;
    }

    @Override
    public int getHistoryUsedSize() {
        return this.mHistoryBuffer.dataSize();
    }

    @Override
    public boolean startIteratingHistoryLocked() {
        if (this.mHistoryBuffer.dataSize() <= 0) {
            return false;
        }
        this.mHistoryBuffer.setDataPosition(0);
        this.mReadOverflow = false;
        this.mIteratingHistory = true;
        this.mReadHistoryStrings = new String[this.mHistoryTagPool.size()];
        this.mReadHistoryUids = new int[this.mHistoryTagPool.size()];
        this.mReadHistoryChars = 0;
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            int idx = ent.getValue();
            this.mReadHistoryStrings[idx] = tag.string;
            this.mReadHistoryUids[idx] = tag.uid;
            this.mReadHistoryChars += tag.string.length() + 1;
        }
        return true;
    }

    @Override
    public int getHistoryStringPoolSize() {
        return this.mReadHistoryStrings.length;
    }

    @Override
    public int getHistoryStringPoolBytes() {
        return this.mReadHistoryStrings.length * 12 + this.mReadHistoryChars * 2;
    }

    @Override
    public String getHistoryTagPoolString(int index) {
        return this.mReadHistoryStrings[index];
    }

    @Override
    public int getHistoryTagPoolUid(int index) {
        return this.mReadHistoryUids[index];
    }

    @Override
    public boolean getNextHistoryLocked(BatteryStats.HistoryItem out) {
        boolean end;
        int pos = this.mHistoryBuffer.dataPosition();
        if (pos == 0) {
            out.clear();
        }
        boolean bl = end = pos >= this.mHistoryBuffer.dataSize();
        if (end) {
            return false;
        }
        long lastRealtime = out.time;
        long lastWalltime = out.currentTime;
        this.readHistoryDelta(this.mHistoryBuffer, out);
        if (out.cmd != 5 && out.cmd != 7 && lastWalltime != 0L) {
            out.currentTime = lastWalltime + (out.time - lastRealtime);
        }
        return true;
    }

    @Override
    public void finishIteratingHistoryLocked() {
        this.mIteratingHistory = false;
        this.mHistoryBuffer.setDataPosition(this.mHistoryBuffer.dataSize());
        this.mReadHistoryStrings = null;
    }

    @Override
    public long getHistoryBaseTime() {
        return this.mHistoryBaseTime;
    }

    @Override
    public int getStartCount() {
        return this.mStartCount;
    }

    public boolean isOnBattery() {
        return this.mOnBattery;
    }

    public boolean isCharging() {
        return this.mCharging;
    }

    public boolean isScreenOn() {
        return this.mScreenState == 2;
    }

    void initTimes(long uptime, long realtime) {
        this.mStartClockTime = System.currentTimeMillis();
        this.mOnBatteryTimeBase.init(uptime, realtime);
        this.mOnBatteryScreenOffTimeBase.init(uptime, realtime);
        this.mRealtime = 0L;
        this.mUptime = 0L;
        this.mRealtimeStart = realtime;
        this.mUptimeStart = uptime;
    }

    void initDischarge() {
        this.mLowDischargeAmountSinceCharge = 0;
        this.mHighDischargeAmountSinceCharge = 0;
        this.mDischargeAmountScreenOn = 0;
        this.mDischargeAmountScreenOnSinceCharge = 0;
        this.mDischargeAmountScreenOff = 0;
        this.mDischargeAmountScreenOffSinceCharge = 0;
        this.mDischargeStepTracker.init();
        this.mChargeStepTracker.init();
    }

    public void resetAllStatsCmdLocked() {
        this.resetAllStatsLocked();
        long mSecUptime = SystemClock.uptimeMillis();
        long uptime = mSecUptime * 1000L;
        long mSecRealtime = SystemClock.elapsedRealtime();
        long realtime = mSecRealtime * 1000L;
        this.mDischargeStartLevel = this.mHistoryCur.batteryLevel;
        this.pullPendingStateUpdatesLocked();
        this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
        byte by = this.mHistoryCur.batteryLevel;
        this.mCurrentBatteryLevel = by;
        this.mDischargePlugLevel = by;
        this.mDischargeUnplugLevel = by;
        this.mDischargeCurrentLevel = by;
        this.mOnBatteryTimeBase.reset(uptime, realtime);
        this.mOnBatteryScreenOffTimeBase.reset(uptime, realtime);
        if ((this.mHistoryCur.states & 0x80000) == 0) {
            if (this.mScreenState == 2) {
                this.mDischargeScreenOnUnplugLevel = this.mHistoryCur.batteryLevel;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = this.mHistoryCur.batteryLevel;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
        }
        this.initActiveHistoryEventsLocked(mSecRealtime, mSecUptime);
    }

    private void resetAllStatsLocked() {
        int i;
        this.mStartCount = 0;
        this.initTimes(SystemClock.uptimeMillis() * 1000L, SystemClock.elapsedRealtime() * 1000L);
        this.mScreenOnTimer.reset(false);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].reset(false);
        }
        this.mInteractiveTimer.reset(false);
        this.mPowerSaveModeEnabledTimer.reset(false);
        this.mDeviceIdleModeEnabledTimer.reset(false);
        this.mDeviceIdlingTimer.reset(false);
        this.mPhoneOnTimer.reset(false);
        this.mAudioOnTimer.reset(false);
        this.mVideoOnTimer.reset(false);
        this.mFlashlightOnTimer.reset(false);
        this.mCameraOnTimer.reset(false);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].reset(false);
        }
        this.mPhoneSignalScanningTimer.reset(false);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].reset(false);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].reset(false);
            this.mNetworkPacketActivityCounters[i].reset(false);
        }
        this.mMobileRadioActiveTimer.reset(false);
        this.mMobileRadioActivePerAppTimer.reset(false);
        this.mMobileRadioActiveAdjustedTime.reset(false);
        this.mMobileRadioActiveUnknownTime.reset(false);
        this.mMobileRadioActiveUnknownCount.reset(false);
        this.mWifiOnTimer.reset(false);
        this.mGlobalWifiRunningTimer.reset(false);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].reset(false);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].reset(false);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].reset(false);
        }
        for (i = 0; i < 4; ++i) {
            this.mBluetoothActivityCounters[i].reset(false);
            this.mWifiActivityCounters[i].reset(false);
        }
        this.mUnpluggedNumConnectivityChange = 0;
        this.mLoadedNumConnectivityChange = 0;
        this.mNumConnectivityChange = 0;
        for (i = 0; i < this.mUidStats.size(); ++i) {
            if (!this.mUidStats.valueAt(i).reset()) continue;
            this.mUidStats.remove(this.mUidStats.keyAt(i));
            --i;
        }
        if (this.mKernelWakelockStats.size() > 0) {
            for (SamplingTimer timer : this.mKernelWakelockStats.values()) {
                this.mOnBatteryScreenOffTimeBase.remove(timer);
            }
            this.mKernelWakelockStats.clear();
        }
        if (this.mWakeupReasonStats.size() > 0) {
            for (SamplingTimer timer : this.mWakeupReasonStats.values()) {
                this.mOnBatteryTimeBase.remove(timer);
            }
            this.mWakeupReasonStats.clear();
        }
        this.mLastHistoryStepDetails = null;
        this.mLastStepCpuSystemTime = 0L;
        this.mLastStepCpuUserTime = 0L;
        this.mCurStepCpuSystemTime = 0L;
        this.mCurStepCpuUserTime = 0L;
        this.mCurStepCpuUserTime = 0L;
        this.mLastStepCpuUserTime = 0L;
        this.mCurStepCpuSystemTime = 0L;
        this.mLastStepCpuSystemTime = 0L;
        this.mCurStepStatUserTime = 0L;
        this.mLastStepStatUserTime = 0L;
        this.mCurStepStatSystemTime = 0L;
        this.mLastStepStatSystemTime = 0L;
        this.mCurStepStatIOWaitTime = 0L;
        this.mLastStepStatIOWaitTime = 0L;
        this.mCurStepStatIrqTime = 0L;
        this.mLastStepStatIrqTime = 0L;
        this.mCurStepStatSoftIrqTime = 0L;
        this.mLastStepStatSoftIrqTime = 0L;
        this.mCurStepStatIdleTime = 0L;
        this.mLastStepStatIdleTime = 0L;
        this.initDischarge();
        this.clearHistoryLocked();
    }

    private void initActiveHistoryEventsLocked(long elapsedRealtimeMs, long uptimeMs) {
        for (int i = 0; i < 19; ++i) {
            HashMap<String, SparseIntArray> active;
            if (!this.mRecordAllHistory && i == 1 || (active = this.mActiveEvents.getStateForEvent(i)) == null) continue;
            for (Map.Entry<String, SparseIntArray> ent : active.entrySet()) {
                SparseIntArray uids = ent.getValue();
                for (int j = 0; j < uids.size(); ++j) {
                    this.addHistoryEventLocked(elapsedRealtimeMs, uptimeMs, i, ent.getKey(), uids.keyAt(j));
                }
            }
        }
    }

    void updateDischargeScreenLevelsLocked(boolean oldScreenOn, boolean newScreenOn) {
        if (oldScreenOn) {
            int diff = this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            if (diff > 0) {
                this.mDischargeAmountScreenOn += diff;
                this.mDischargeAmountScreenOnSinceCharge += diff;
            }
        } else {
            int diff = this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            if (diff > 0) {
                this.mDischargeAmountScreenOff += diff;
                this.mDischargeAmountScreenOffSinceCharge += diff;
            }
        }
        if (newScreenOn) {
            this.mDischargeScreenOnUnplugLevel = this.mDischargeCurrentLevel;
            this.mDischargeScreenOffUnplugLevel = 0;
        } else {
            this.mDischargeScreenOnUnplugLevel = 0;
            this.mDischargeScreenOffUnplugLevel = this.mDischargeCurrentLevel;
        }
    }

    public void pullPendingStateUpdatesLocked() {
        if (this.mOnBatteryInternal) {
            boolean screenOn = this.mScreenState == 2;
            this.updateDischargeScreenLevelsLocked(screenOn, screenOn);
        }
    }

    private NetworkStats getNetworkStatsDeltaLocked(String[] ifaces, NetworkStats[] networkStatsBuffer) throws IOException {
        if (!SystemProperties.getBoolean("net.qtaguid_enabled", false)) {
            return null;
        }
        NetworkStats stats = this.mNetworkStatsFactory.readNetworkStatsDetail(-1, ifaces, 0, networkStatsBuffer[1]);
        networkStatsBuffer[2] = NetworkStats.subtract(stats, networkStatsBuffer[0], null, null, networkStatsBuffer[2]);
        networkStatsBuffer[1] = networkStatsBuffer[0];
        networkStatsBuffer[0] = stats;
        return networkStatsBuffer[2];
    }

    public void updateWifiStateLocked(WifiActivityEnergyInfo info) {
        long elapsedRealtimeMs = SystemClock.elapsedRealtime();
        NetworkStats delta = null;
        try {
            if (!ArrayUtils.isEmpty(this.mWifiIfaces)) {
                delta = this.getNetworkStatsDeltaLocked(this.mWifiIfaces, this.mWifiNetworkStats);
            }
        }
        catch (IOException e) {
            Slog.wtf(TAG, "Failed to get wifi network stats", e);
            return;
        }
        if (!this.mOnBatteryInternal) {
            return;
        }
        SparseLongArray rxPackets = new SparseLongArray();
        SparseLongArray txPackets = new SparseLongArray();
        long totalTxPackets = 0L;
        long totalRxPackets = 0L;
        if (delta != null) {
            int size = delta.size();
            for (int i = 0; i < size; ++i) {
                NetworkStats.Entry entry = delta.getValues(i, this.mTmpNetworkStatsEntry);
                if (entry.rxBytes == 0L || entry.txBytes == 0L) continue;
                Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
                u.noteNetworkActivityLocked(2, entry.rxBytes, entry.rxPackets);
                u.noteNetworkActivityLocked(3, entry.txBytes, entry.txPackets);
                rxPackets.put(u.getUid(), entry.rxPackets);
                txPackets.put(u.getUid(), entry.txPackets);
                totalRxPackets += entry.rxPackets;
                totalTxPackets += entry.txPackets;
                this.mNetworkByteActivityCounters[2].addCountLocked(entry.rxBytes);
                this.mNetworkByteActivityCounters[3].addCountLocked(entry.txBytes);
                this.mNetworkPacketActivityCounters[2].addCountLocked(entry.rxPackets);
                this.mNetworkPacketActivityCounters[3].addCountLocked(entry.txPackets);
            }
        }
        if (info != null) {
            Uid uid;
            int i;
            this.mHasWifiEnergyReporting = true;
            long txTimeMs = info.getControllerTxTimeMillis();
            long rxTimeMs = info.getControllerRxTimeMillis();
            long idleTimeMs = info.getControllerIdleTimeMillis();
            long totalTimeMs = txTimeMs + rxTimeMs + idleTimeMs;
            long leftOverRxTimeMs = rxTimeMs;
            long leftOverTxTimeMs = txTimeMs;
            long totalWifiLockTimeMs = 0L;
            long totalScanTimeMs = 0L;
            int uidStatsSize = this.mUidStats.size();
            for (i = 0; i < uidStatsSize; ++i) {
                uid = this.mUidStats.valueAt(i);
                totalScanTimeMs += uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                totalWifiLockTimeMs += uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
            }
            for (i = 0; i < uidStatsSize; ++i) {
                long wifiLockTimeSinceMarkMs;
                uid = this.mUidStats.valueAt(i);
                long scanTimeSinceMarkMs = uid.mWifiScanTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L;
                if (scanTimeSinceMarkMs > 0L) {
                    uid.mWifiScanTimer.setMark(elapsedRealtimeMs);
                    long scanRxTimeSinceMarkMs = scanTimeSinceMarkMs;
                    long scanTxTimeSinceMarkMs = scanTimeSinceMarkMs;
                    if (totalScanTimeMs > rxTimeMs) {
                        scanRxTimeSinceMarkMs = rxTimeMs * scanRxTimeSinceMarkMs / totalScanTimeMs;
                    }
                    if (totalScanTimeMs > txTimeMs) {
                        scanTxTimeSinceMarkMs = txTimeMs * scanTxTimeSinceMarkMs / totalScanTimeMs;
                    }
                    uid.noteWifiControllerActivityLocked(1, scanRxTimeSinceMarkMs);
                    uid.noteWifiControllerActivityLocked(2, scanTxTimeSinceMarkMs);
                    leftOverRxTimeMs -= scanRxTimeSinceMarkMs;
                    leftOverTxTimeMs -= scanTxTimeSinceMarkMs;
                }
                if ((wifiLockTimeSinceMarkMs = uid.mFullWifiLockTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L) / 1000L) <= 0L) continue;
                uid.mFullWifiLockTimer.setMark(elapsedRealtimeMs);
                long myIdleTimeMs = wifiLockTimeSinceMarkMs * idleTimeMs / totalWifiLockTimeMs;
                uid.noteWifiControllerActivityLocked(0, myIdleTimeMs);
            }
            for (i = 0; i < txPackets.size(); ++i) {
                uid = this.getUidStatsLocked(txPackets.keyAt(i));
                long myTxTimeMs = txPackets.valueAt(i) * leftOverTxTimeMs / totalTxPackets;
                uid.noteWifiControllerActivityLocked(2, myTxTimeMs);
            }
            for (i = 0; i < rxPackets.size(); ++i) {
                uid = this.getUidStatsLocked(rxPackets.keyAt(i));
                long myRxTimeMs = rxPackets.valueAt(i) * leftOverRxTimeMs / totalRxPackets;
                uid.noteWifiControllerActivityLocked(1, myRxTimeMs);
            }
            this.mWifiActivityCounters[1].addCountLocked(info.getControllerRxTimeMillis());
            this.mWifiActivityCounters[2].addCountLocked(info.getControllerTxTimeMillis());
            this.mWifiActivityCounters[0].addCountLocked(info.getControllerIdleTimeMillis());
            double opVolt = this.mPowerProfile.getAveragePower("wifi.controller.voltage") / 1000.0;
            if (opVolt != 0.0) {
                this.mWifiActivityCounters[3].addCountLocked((long)((double)info.getControllerEnergyUsed() / opVolt));
            }
        }
    }

    public void updateMobileRadioStateLocked(long elapsedRealtimeMs) {
        NetworkStats delta = null;
        try {
            if (!ArrayUtils.isEmpty(this.mMobileIfaces)) {
                delta = this.getNetworkStatsDeltaLocked(this.mMobileIfaces, this.mMobileNetworkStats);
            }
        }
        catch (IOException e) {
            Slog.wtf(TAG, "Failed to get mobile network stats", e);
            return;
        }
        if (delta == null || !this.mOnBatteryInternal) {
            return;
        }
        long radioTime = this.mMobileRadioActivePerAppTimer.getTimeSinceMarkLocked(elapsedRealtimeMs * 1000L);
        this.mMobileRadioActivePerAppTimer.setMark(elapsedRealtimeMs);
        long totalPackets = delta.getTotalPackets();
        int size = delta.size();
        for (int i = 0; i < size; ++i) {
            NetworkStats.Entry entry = delta.getValues(i, this.mTmpNetworkStatsEntry);
            if (entry.rxBytes == 0L || entry.txBytes == 0L) continue;
            Uid u = this.getUidStatsLocked(this.mapUid(entry.uid));
            u.noteNetworkActivityLocked(0, entry.rxBytes, entry.rxPackets);
            u.noteNetworkActivityLocked(1, entry.txBytes, entry.txPackets);
            if (radioTime > 0L) {
                long appPackets = entry.rxPackets + entry.txPackets;
                long appRadioTime = radioTime * appPackets / totalPackets;
                u.noteMobileRadioActiveTimeLocked(appRadioTime);
                radioTime -= appRadioTime;
                totalPackets -= appPackets;
            }
            this.mNetworkByteActivityCounters[0].addCountLocked(entry.rxBytes);
            this.mNetworkByteActivityCounters[1].addCountLocked(entry.txBytes);
            this.mNetworkPacketActivityCounters[0].addCountLocked(entry.rxPackets);
            this.mNetworkPacketActivityCounters[1].addCountLocked(entry.txPackets);
        }
        if (radioTime > 0L) {
            this.mMobileRadioActiveUnknownTime.addCountLocked(radioTime);
            this.mMobileRadioActiveUnknownCount.addCountLocked(1L);
        }
    }

    public void updateBluetoothStateLocked(BluetoothActivityEnergyInfo info) {
        if (info != null && this.mOnBatteryInternal) {
            this.mHasBluetoothEnergyReporting = true;
            this.mBluetoothActivityCounters[1].addCountLocked(info.getControllerRxTimeMillis());
            this.mBluetoothActivityCounters[2].addCountLocked(info.getControllerTxTimeMillis());
            this.mBluetoothActivityCounters[0].addCountLocked(info.getControllerIdleTimeMillis());
            double opVolt = this.mPowerProfile.getAveragePower("bluetooth.controller.voltage") / 1000.0;
            if (opVolt != 0.0) {
                this.mBluetoothActivityCounters[3].addCountLocked((long)((double)info.getControllerEnergyUsed() / opVolt));
            }
        }
    }

    public void updateKernelWakelocksLocked() {
        KernelWakelockStats wakelockStats = this.mKernelWakelockReader.readKernelWakelockStats(this.mTmpWakelockStats);
        if (wakelockStats == null) {
            Slog.w(TAG, "Couldn't get kernel wake lock stats");
            return;
        }
        boolean seenNonZeroTime = false;
        for (Map.Entry ent : wakelockStats.entrySet()) {
            String name = (String)ent.getKey();
            KernelWakelockStats.Entry kws = (KernelWakelockStats.Entry)ent.getValue();
            SamplingTimer kwlt = this.mKernelWakelockStats.get(name);
            if (kwlt == null) {
                kwlt = new SamplingTimer(this.mOnBatteryScreenOffTimeBase, true);
                this.mKernelWakelockStats.put(name, kwlt);
            }
            kwlt.updateCurrentReportedCount(kws.mCount);
            kwlt.updateCurrentReportedTotalTime(kws.mTotalTime);
            kwlt.setUpdateVersion(kws.mVersion);
            if (kws.mVersion == wakelockStats.kernelWakelockVersion) continue;
            seenNonZeroTime |= kws.mTotalTime > 0L;
        }
        int numWakelocksSetStale = 0;
        if (wakelockStats.size() != this.mKernelWakelockStats.size()) {
            for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer st = ent.getValue();
                if (st.getUpdateVersion() == wakelockStats.kernelWakelockVersion) continue;
                st.setStale();
                ++numWakelocksSetStale;
            }
        }
        if (!seenNonZeroTime) {
            Slog.wtf(TAG, "All kernel wakelocks had time of zero");
        }
        if (numWakelocksSetStale == this.mKernelWakelockStats.size()) {
            Slog.wtf(TAG, "All kernel wakelocks were set stale. new version=" + wakelockStats.kernelWakelockVersion);
        }
    }

    public void updateCpuTimeLocked() {
        int i;
        int wakelockWeight = 50;
        final int cpuSpeedSteps = this.getCpuSpeedSteps();
        final long[] cpuSpeeds = this.mKernelCpuSpeedReader.readDelta();
        int numWakelocks = 0;
        int numPartialTimers = this.mPartialTimers.size();
        if (this.mOnBatteryScreenOffTimeBase.isRunning()) {
            for (int i2 = 0; i2 < numPartialTimers; ++i2) {
                StopwatchTimer timer = this.mPartialTimers.get(i2);
                if (!timer.mInList || timer.mUid == null || timer.mUid.mUid == 1000) continue;
                ++numWakelocks;
            }
        }
        final int numWakelocksF = numWakelocks;
        this.mTempTotalCpuUserTimeUs = 0L;
        this.mTempTotalCpuSystemTimeUs = 0L;
        long startTimeMs = SystemClock.elapsedRealtime();
        this.mKernelUidCpuTimeReader.readDelta(!this.mOnBatteryInternal ? null : new KernelUidCpuTimeReader.Callback(){

            @Override
            public void onUidCpuTime(int uid, long userTimeUs, long systemTimeUs, long powerMaUs) {
                Uid u = BatteryStatsImpl.this.getUidStatsLocked(BatteryStatsImpl.this.mapUid(uid));
                BatteryStatsImpl.this.mTempTotalCpuUserTimeUs += userTimeUs;
                BatteryStatsImpl.this.mTempTotalCpuSystemTimeUs += systemTimeUs;
                StringBuilder sb = null;
                if (numWakelocksF > 0) {
                    userTimeUs = userTimeUs * 50L / 100L;
                    systemTimeUs = systemTimeUs * 50L / 100L;
                }
                if (sb != null) {
                    sb.append("  adding to uid=").append(u.mUid).append(": u=");
                    TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                    sb.append(" s=");
                    TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                    sb.append(" p=").append(powerMaUs / 1000L).append("mAms");
                    Slog.d(BatteryStatsImpl.TAG, sb.toString());
                }
                u.mUserCpuTime.addCountLocked(userTimeUs);
                u.mSystemCpuTime.addCountLocked(systemTimeUs);
                u.mCpuPower.addCountLocked(powerMaUs);
                for (int i = 0; i < cpuSpeedSteps; ++i) {
                    if (u.mSpeedBins[i] == null) {
                        u.mSpeedBins[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
                    }
                    u.mSpeedBins[i].addCountLocked(cpuSpeeds[i]);
                }
            }
        });
        if (this.mOnBatteryInternal && numWakelocks > 0) {
            this.mTempTotalCpuUserTimeUs = this.mTempTotalCpuUserTimeUs * 50L / 100L;
            this.mTempTotalCpuSystemTimeUs = this.mTempTotalCpuSystemTimeUs * 50L / 100L;
            for (i = 0; i < numPartialTimers; ++i) {
                StopwatchTimer timer = this.mPartialTimers.get(i);
                if (!timer.mInList || timer.mUid == null || timer.mUid.mUid == 1000) continue;
                int userTimeUs = (int)(this.mTempTotalCpuUserTimeUs / (long)numWakelocks);
                int systemTimeUs = (int)(this.mTempTotalCpuSystemTimeUs / (long)numWakelocks);
                timer.mUid.mUserCpuTime.addCountLocked(userTimeUs);
                timer.mUid.mSystemCpuTime.addCountLocked(systemTimeUs);
                Uid.Proc proc = timer.mUid.getProcessStatsLocked("*wakelock*");
                proc.addCpuTimeLocked(userTimeUs / 1000, systemTimeUs / 1000);
                this.mTempTotalCpuUserTimeUs -= (long)userTimeUs;
                this.mTempTotalCpuSystemTimeUs -= (long)systemTimeUs;
                --numWakelocks;
            }
            if (this.mTempTotalCpuUserTimeUs > 0L || this.mTempTotalCpuSystemTimeUs > 0L) {
                Uid u = this.getUidStatsLocked(1000);
                u.mUserCpuTime.addCountLocked(this.mTempTotalCpuUserTimeUs);
                u.mSystemCpuTime.addCountLocked(this.mTempTotalCpuSystemTimeUs);
                Uid.Proc proc = u.getProcessStatsLocked("*lost*");
                proc.addCpuTimeLocked((int)this.mTempTotalCpuUserTimeUs / 1000, (int)this.mTempTotalCpuSystemTimeUs / 1000);
            }
        }
        if (ArrayUtils.referenceEquals(this.mPartialTimers, this.mLastPartialTimers)) {
            for (i = 0; i < numPartialTimers; ++i) {
                this.mPartialTimers.get((int)i).mInList = true;
            }
        } else {
            int i3;
            int numLastPartialTimers = this.mLastPartialTimers.size();
            for (i3 = 0; i3 < numLastPartialTimers; ++i3) {
                this.mLastPartialTimers.get((int)i3).mInList = false;
            }
            this.mLastPartialTimers.clear();
            for (i3 = 0; i3 < numPartialTimers; ++i3) {
                StopwatchTimer timer = this.mPartialTimers.get(i3);
                timer.mInList = true;
                this.mLastPartialTimers.add(timer);
            }
        }
    }

    boolean setChargingLocked(boolean charging) {
        if (this.mCharging != charging) {
            this.mCharging = charging;
            this.mHistoryCur.states2 = charging ? (this.mHistoryCur.states2 |= 0x2000000) : (this.mHistoryCur.states2 &= 0xFDFFFFFF);
            this.mHandler.sendEmptyMessage(3);
            return true;
        }
        return false;
    }

    void setOnBatteryLocked(long mSecRealtime, long mSecUptime, boolean onBattery, int oldStatus, int level) {
        boolean screenOn;
        boolean doWrite = false;
        Message m = this.mHandler.obtainMessage(2);
        m.arg1 = onBattery ? 1 : 0;
        this.mHandler.sendMessage(m);
        long uptime = mSecUptime * 1000L;
        long realtime = mSecRealtime * 1000L;
        boolean bl = screenOn = this.mScreenState == 2;
        if (onBattery) {
            boolean reset = false;
            if (!this.mNoAutoReset && (oldStatus == 5 || level >= 90 || this.mDischargeCurrentLevel < 20 && level >= 80 || this.getHighDischargeAmountSinceCharge() >= 200 && this.mHistoryBuffer.dataSize() >= 262144)) {
                Slog.i(TAG, "Resetting battery stats: level=" + level + " status=" + oldStatus + " dischargeLevel=" + this.mDischargeCurrentLevel + " lowAmount=" + this.getLowDischargeAmountSinceCharge() + " highAmount=" + this.getHighDischargeAmountSinceCharge());
                if (this.getLowDischargeAmountSinceCharge() >= 20) {
                    final Parcel parcel = Parcel.obtain();
                    this.writeSummaryToParcel(parcel, true);
                    BackgroundThread.getHandler().post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            AtomicFile atomicFile = BatteryStatsImpl.this.mCheckinFile;
                            synchronized (atomicFile) {
                                FileOutputStream stream = null;
                                try {
                                    stream = BatteryStatsImpl.this.mCheckinFile.startWrite();
                                    stream.write(parcel.marshall());
                                    stream.flush();
                                    FileUtils.sync(stream);
                                    stream.close();
                                    BatteryStatsImpl.this.mCheckinFile.finishWrite(stream);
                                }
                                catch (IOException e) {
                                    Slog.w("BatteryStats", "Error writing checkin battery statistics", e);
                                    BatteryStatsImpl.this.mCheckinFile.failWrite(stream);
                                }
                                finally {
                                    parcel.recycle();
                                }
                            }
                        }
                    });
                }
                doWrite = true;
                this.resetAllStatsLocked();
                this.mDischargeStartLevel = level;
                reset = true;
                this.mDischargeStepTracker.init();
            }
            if (this.mCharging) {
                this.setChargingLocked(false);
            }
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = true;
            this.mOnBattery = true;
            this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = level;
            this.mDischargeStepTracker.clearTime();
            this.mDailyDischargeStepTracker.clearTime();
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states &= 0xFFF7FFFF;
            if (reset) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(mSecRealtime, mSecUptime, reset);
            }
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargeUnplugLevel = level;
            if (screenOn) {
                this.mDischargeScreenOnUnplugLevel = level;
                this.mDischargeScreenOffUnplugLevel = 0;
            } else {
                this.mDischargeScreenOnUnplugLevel = 0;
                this.mDischargeScreenOffUnplugLevel = level;
            }
            this.mDischargeAmountScreenOn = 0;
            this.mDischargeAmountScreenOff = 0;
            this.updateTimeBasesLocked(true, !screenOn, uptime, realtime);
        } else {
            this.mLastChargingStateLevel = level;
            this.mOnBatteryInternal = false;
            this.mOnBattery = false;
            this.pullPendingStateUpdatesLocked();
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.states |= 0x80000;
            this.addHistoryRecordLocked(mSecRealtime, mSecUptime);
            this.mDischargeCurrentLevel = this.mDischargePlugLevel = level;
            if (level < this.mDischargeUnplugLevel) {
                this.mLowDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level - 1;
                this.mHighDischargeAmountSinceCharge += this.mDischargeUnplugLevel - level;
            }
            this.updateDischargeScreenLevelsLocked(screenOn, screenOn);
            this.updateTimeBasesLocked(false, !screenOn, uptime, realtime);
            this.mChargeStepTracker.init();
            this.mLastChargeStepLevel = level;
            this.mMaxChargeStepLevel = level;
            this.mInitStepMode = this.mCurStepMode;
            this.mModStepMode = 0;
        }
        if ((doWrite || this.mLastWriteTime + 60000L < mSecRealtime) && this.mFile != null) {
            this.writeAsyncLocked();
        }
    }

    private void startRecordingHistory(long elapsedRealtimeMs, long uptimeMs, boolean reset) {
        this.mRecordingHistory = true;
        this.mHistoryCur.currentTime = System.currentTimeMillis();
        this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, reset ? (byte)7 : 5, this.mHistoryCur);
        this.mHistoryCur.currentTime = 0L;
        if (reset) {
            this.initActiveHistoryEventsLocked(elapsedRealtimeMs, uptimeMs);
        }
    }

    private void recordCurrentTimeChangeLocked(long currentTime, long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = currentTime;
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)5, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private void recordShutdownLocked(long elapsedRealtimeMs, long uptimeMs) {
        if (this.mRecordingHistory) {
            this.mHistoryCur.currentTime = System.currentTimeMillis();
            this.addHistoryBufferLocked(elapsedRealtimeMs, uptimeMs, (byte)8, this.mHistoryCur);
            this.mHistoryCur.currentTime = 0L;
        }
    }

    private void scheduleSyncExternalStatsLocked(String reason) {
        if (this.mExternalSync != null) {
            this.mExternalSync.scheduleSync(reason);
        }
    }

    private void scheduleSyncExternalWifiStatsLocked(String reason) {
        if (this.mExternalSync != null) {
            this.mExternalSync.scheduleWifiSync(reason);
        }
    }

    public void setBatteryStateLocked(int status, int health, int plugType, int level, int temp, int volt) {
        boolean onBattery = plugType == 0;
        long uptime = SystemClock.uptimeMillis();
        long elapsedRealtime = SystemClock.elapsedRealtime();
        if (!this.mHaveBatteryLevel) {
            this.mHaveBatteryLevel = true;
            if (onBattery == this.mOnBattery) {
                this.mHistoryCur.states = onBattery ? (this.mHistoryCur.states &= 0xFFF7FFFF) : (this.mHistoryCur.states |= 0x80000);
            }
            this.mHistoryCur.states2 |= 0x2000000;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mLastChargeStepLevel = this.mLastDischargeStepLevel = level;
            this.mMinDischargeStepLevel = this.mLastDischargeStepLevel;
            this.mMaxChargeStepLevel = this.mLastDischargeStepLevel;
            this.mLastChargingStateLevel = level;
        } else if (this.mCurrentBatteryLevel != level || this.mOnBattery != onBattery) {
            this.recordDailyStatsIfNeededLocked(level >= 100 && onBattery);
        }
        byte oldStatus = this.mHistoryCur.batteryStatus;
        if (onBattery) {
            this.mDischargeCurrentLevel = level;
            if (!this.mRecordingHistory) {
                this.mRecordingHistory = true;
                this.startRecordingHistory(elapsedRealtime, uptime, true);
            }
        } else if (level < 96 && !this.mRecordingHistory) {
            this.mRecordingHistory = true;
            this.startRecordingHistory(elapsedRealtime, uptime, true);
        }
        this.mCurrentBatteryLevel = level;
        if (this.mDischargePlugLevel < 0) {
            this.mDischargePlugLevel = level;
        }
        if (onBattery != this.mOnBattery) {
            this.mHistoryCur.batteryLevel = (byte)level;
            this.mHistoryCur.batteryStatus = (byte)status;
            this.mHistoryCur.batteryHealth = (byte)health;
            this.mHistoryCur.batteryPlugType = (byte)plugType;
            this.mHistoryCur.batteryTemperature = (short)temp;
            this.mHistoryCur.batteryVoltage = (char)volt;
            this.setOnBatteryLocked(elapsedRealtime, uptime, onBattery, oldStatus, level);
        } else {
            boolean changed = false;
            if (this.mHistoryCur.batteryLevel != level) {
                this.mHistoryCur.batteryLevel = (byte)level;
                changed = true;
                this.scheduleSyncExternalStatsLocked("battery-level");
            }
            if (this.mHistoryCur.batteryStatus != status) {
                this.mHistoryCur.batteryStatus = (byte)status;
                changed = true;
            }
            if (this.mHistoryCur.batteryHealth != health) {
                this.mHistoryCur.batteryHealth = (byte)health;
                changed = true;
            }
            if (this.mHistoryCur.batteryPlugType != plugType) {
                this.mHistoryCur.batteryPlugType = (byte)plugType;
                changed = true;
            }
            if (temp >= this.mHistoryCur.batteryTemperature + 10 || temp <= this.mHistoryCur.batteryTemperature - 10) {
                this.mHistoryCur.batteryTemperature = (short)temp;
                changed = true;
            }
            if (volt > this.mHistoryCur.batteryVoltage + 20 || volt < this.mHistoryCur.batteryVoltage - 20) {
                this.mHistoryCur.batteryVoltage = (char)volt;
                changed = true;
            }
            long modeBits = (long)this.mInitStepMode << 48 | (long)this.mModStepMode << 56 | (long)(level & 0xFF) << 40;
            if (onBattery) {
                changed |= this.setChargingLocked(false);
                if (this.mLastDischargeStepLevel != level && this.mMinDischargeStepLevel > level) {
                    this.mDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtime);
                    this.mDailyDischargeStepTracker.addLevelSteps(this.mLastDischargeStepLevel - level, modeBits, elapsedRealtime);
                    this.mLastDischargeStepLevel = level;
                    this.mMinDischargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            } else {
                if (level >= 90) {
                    changed |= this.setChargingLocked(true);
                    this.mLastChargeStepLevel = level;
                }
                if (!this.mCharging) {
                    if (this.mLastChargeStepLevel < level) {
                        changed |= this.setChargingLocked(true);
                        this.mLastChargeStepLevel = level;
                    }
                } else if (this.mLastChargeStepLevel > level) {
                    changed |= this.setChargingLocked(false);
                    this.mLastChargeStepLevel = level;
                }
                if (this.mLastChargeStepLevel != level && this.mMaxChargeStepLevel < level) {
                    this.mChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtime);
                    this.mDailyChargeStepTracker.addLevelSteps(level - this.mLastChargeStepLevel, modeBits, elapsedRealtime);
                    this.mLastChargeStepLevel = level;
                    this.mMaxChargeStepLevel = level;
                    this.mInitStepMode = this.mCurStepMode;
                    this.mModStepMode = 0;
                }
            }
            if (changed) {
                this.addHistoryRecordLocked(elapsedRealtime, uptime);
            }
        }
        if (!onBattery && status == 5) {
            this.mRecordingHistory = false;
        }
    }

    public long getAwakeTimeBattery() {
        return this.computeBatteryUptime(this.getBatteryUptimeLocked(), 1);
    }

    public long getAwakeTimePlugged() {
        return SystemClock.uptimeMillis() * 1000L - this.getAwakeTimeBattery();
    }

    @Override
    public long computeUptime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mUptime + (curTime - this.mUptimeStart);
            }
            case 1: {
                return curTime - this.mUptimeStart;
            }
            case 2: {
                return curTime - this.mOnBatteryTimeBase.getUptimeStart();
            }
        }
        return 0L;
    }

    @Override
    public long computeRealtime(long curTime, int which) {
        switch (which) {
            case 0: {
                return this.mRealtime + (curTime - this.mRealtimeStart);
            }
            case 1: {
                return curTime - this.mRealtimeStart;
            }
            case 2: {
                return curTime - this.mOnBatteryTimeBase.getRealtimeStart();
            }
        }
        return 0L;
    }

    @Override
    public long computeBatteryUptime(long curTime, int which) {
        return this.mOnBatteryTimeBase.computeUptime(curTime, which);
    }

    @Override
    public long computeBatteryRealtime(long curTime, int which) {
        return this.mOnBatteryTimeBase.computeRealtime(curTime, which);
    }

    @Override
    public long computeBatteryScreenOffUptime(long curTime, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeUptime(curTime, which);
    }

    @Override
    public long computeBatteryScreenOffRealtime(long curTime, int which) {
        return this.mOnBatteryScreenOffTimeBase.computeRealtime(curTime, which);
    }

    private long computeTimePerLevel(long[] steps, int numSteps) {
        if (numSteps <= 0) {
            return -1L;
        }
        long total = 0L;
        for (int i = 0; i < numSteps; ++i) {
            total += steps[i] & 0xFFFFFFFFFFL;
        }
        return total / (long)numSteps;
    }

    @Override
    public long computeBatteryTimeRemaining(long curTime) {
        if (!this.mOnBattery) {
            return -1L;
        }
        if (this.mDischargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mDischargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)this.mCurrentBatteryLevel * 1000L;
    }

    @Override
    public BatteryStats.LevelStepTracker getDischargeLevelStepTracker() {
        return this.mDischargeStepTracker;
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyDischargeLevelStepTracker() {
        return this.mDailyDischargeStepTracker;
    }

    @Override
    public long computeChargeTimeRemaining(long curTime) {
        if (this.mOnBattery) {
            return -1L;
        }
        if (this.mChargeStepTracker.mNumStepDurations < 1) {
            return -1L;
        }
        long msPerLevel = this.mChargeStepTracker.computeTimePerLevel();
        if (msPerLevel <= 0L) {
            return -1L;
        }
        return msPerLevel * (long)(100 - this.mCurrentBatteryLevel) * 1000L;
    }

    @Override
    public BatteryStats.LevelStepTracker getChargeLevelStepTracker() {
        return this.mChargeStepTracker;
    }

    @Override
    public BatteryStats.LevelStepTracker getDailyChargeLevelStepTracker() {
        return this.mDailyChargeStepTracker;
    }

    @Override
    public ArrayList<BatteryStats.PackageChange> getDailyPackageChanges() {
        return this.mDailyPackageChanges;
    }

    long getBatteryUptimeLocked() {
        return this.mOnBatteryTimeBase.getUptime(SystemClock.uptimeMillis() * 1000L);
    }

    @Override
    public long getBatteryUptime(long curTime) {
        return this.mOnBatteryTimeBase.getUptime(curTime);
    }

    @Override
    public long getBatteryRealtime(long curTime) {
        return this.mOnBatteryTimeBase.getRealtime(curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeStartLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeStartLevelLocked();
        }
    }

    public int getDischargeStartLevelLocked() {
        return this.mDischargeUnplugLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeCurrentLevel() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            return this.getDischargeCurrentLevelLocked();
        }
    }

    public int getDischargeCurrentLevelLocked() {
        return this.mDischargeCurrentLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLowDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mLowDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel - 1;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHighDischargeAmountSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mHighDischargeAmountSinceCharge;
            if (this.mOnBattery && this.mDischargeCurrentLevel < this.mDischargeUnplugLevel) {
                val += this.mDischargeUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @Override
    public int getDischargeAmount(int which) {
        int dischargeAmount;
        int n = dischargeAmount = which == 0 ? this.getHighDischargeAmountSinceCharge() : this.getDischargeStartLevel() - this.getDischargeCurrentLevel();
        if (dischargeAmount < 0) {
            dischargeAmount = 0;
        }
        return dischargeAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOn() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOn;
            if (this.mOnBattery && this.mScreenState == 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOnSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOnSinceCharge;
            if (this.mOnBattery && this.mScreenState == 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOnUnplugLevel) {
                val += this.mDischargeScreenOnUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOff() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOff;
            if (this.mOnBattery && this.mScreenState != 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDischargeAmountScreenOffSinceCharge() {
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            int val = this.mDischargeAmountScreenOffSinceCharge;
            if (this.mOnBattery && this.mScreenState != 2 && this.mDischargeCurrentLevel < this.mDischargeScreenOffUnplugLevel) {
                val += this.mDischargeScreenOffUnplugLevel - this.mDischargeCurrentLevel;
            }
            return val;
        }
    }

    @Override
    public int getCpuSpeedSteps() {
        return sNumSpeedSteps;
    }

    public Uid getUidStatsLocked(int uid) {
        Uid u = this.mUidStats.get(uid);
        if (u == null) {
            u = new Uid(uid);
            this.mUidStats.put(uid, u);
        }
        return u;
    }

    public void removeUidStatsLocked(int uid) {
        this.mKernelUidCpuTimeReader.removeUid(uid);
        this.mUidStats.remove(uid);
    }

    public Uid.Proc getProcessStatsLocked(int uid, String name) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getProcessStatsLocked(name);
    }

    public Uid.Pkg getPackageStatsLocked(int uid, String pkg) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getPackageStatsLocked(pkg);
    }

    public Uid.Pkg.Serv getServiceStatsLocked(int uid, String pkg, String name) {
        uid = this.mapUid(uid);
        Uid u = this.getUidStatsLocked(uid);
        return u.getServiceStatsLocked(pkg, name);
    }

    public void shutdownLocked() {
        this.recordShutdownLocked(SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        this.writeSyncLocked();
        this.mShuttingDown = true;
    }

    public void writeAsyncLocked() {
        this.writeLocked(false);
    }

    public void writeSyncLocked() {
        this.writeLocked(true);
    }

    void writeLocked(boolean sync) {
        if (this.mFile == null) {
            Slog.w("BatteryStats", "writeLocked: no file associated with this instance");
            return;
        }
        if (this.mShuttingDown) {
            return;
        }
        Parcel out = Parcel.obtain();
        this.writeSummaryToParcel(out, true);
        this.mLastWriteTime = SystemClock.elapsedRealtime();
        if (this.mPendingWrite != null) {
            this.mPendingWrite.recycle();
        }
        this.mPendingWrite = out;
        if (sync) {
            this.commitPendingDataToDisk();
        } else {
            BackgroundThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    BatteryStatsImpl.this.commitPendingDataToDisk();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitPendingDataToDisk() {
        Parcel next;
        BatteryStatsImpl batteryStatsImpl = this;
        synchronized (batteryStatsImpl) {
            next = this.mPendingWrite;
            this.mPendingWrite = null;
            if (next == null) {
                return;
            }
            this.mWriteLock.lock();
        }
        try {
            FileOutputStream stream = new FileOutputStream(this.mFile.chooseForWrite());
            stream.write(next.marshall());
            stream.flush();
            FileUtils.sync(stream);
            stream.close();
            this.mFile.commit();
        }
        catch (IOException e) {
            Slog.w("BatteryStats", "Error writing battery statistics", e);
            this.mFile.rollback();
        }
        finally {
            next.recycle();
            this.mWriteLock.unlock();
        }
    }

    public void readLocked() {
        if (this.mDailyFile != null) {
            this.readDailyStatsLocked();
        }
        if (this.mFile == null) {
            Slog.w("BatteryStats", "readLocked: no file associated with this instance");
            return;
        }
        this.mUidStats.clear();
        try {
            File file = this.mFile.chooseForRead();
            if (!file.exists()) {
                return;
            }
            FileInputStream stream = new FileInputStream(file);
            byte[] raw2 = BatteryStatsHelper.readFully(stream);
            Parcel in = Parcel.obtain();
            in.unmarshall(raw2, 0, raw2.length);
            in.setDataPosition(0);
            stream.close();
            this.readSummaryFromParcel(in);
        }
        catch (Exception e) {
            Slog.e("BatteryStats", "Error reading battery statistics", e);
            this.resetAllStatsLocked();
        }
        this.mEndPlatformVersion = Build.ID;
        if (this.mHistoryBuffer.dataPosition() > 0) {
            this.mRecordingHistory = true;
            long elapsedRealtime = SystemClock.elapsedRealtime();
            long uptime = SystemClock.uptimeMillis();
            this.addHistoryBufferLocked(elapsedRealtime, uptime, (byte)4, this.mHistoryCur);
            this.startRecordingHistory(elapsedRealtime, uptime, false);
        }
        this.recordDailyStatsIfNeededLocked(false);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    void readHistory(Parcel in, boolean andOldHistory) throws ParcelFormatException {
        long historyBaseTime = in.readLong();
        this.mHistoryBuffer.setDataSize(0);
        this.mHistoryBuffer.setDataPosition(0);
        this.mHistoryTagPool.clear();
        this.mNextHistoryTagIdx = 0;
        this.mNumHistoryTagChars = 0;
        int numTags = in.readInt();
        for (int i = 0; i < numTags; ++i) {
            int idx = in.readInt();
            String str = in.readString();
            if (str == null) {
                throw new ParcelFormatException("null history tag string");
            }
            int uid = in.readInt();
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.string = str;
            tag.uid = uid;
            tag.poolIdx = idx;
            this.mHistoryTagPool.put(tag, idx);
            if (idx >= this.mNextHistoryTagIdx) {
                this.mNextHistoryTagIdx = idx + 1;
            }
            this.mNumHistoryTagChars += tag.string.length() + 1;
        }
        int bufSize = in.readInt();
        int curPos = in.dataPosition();
        if (bufSize >= 983040) {
            throw new ParcelFormatException("File corrupt: history data buffer too large " + bufSize);
        }
        if ((bufSize & 0xFFFFFFFC) != bufSize) {
            throw new ParcelFormatException("File corrupt: history data buffer not aligned " + bufSize);
        }
        this.mHistoryBuffer.appendFrom(in, curPos, bufSize);
        in.setDataPosition(curPos + bufSize);
        if (andOldHistory) {
            this.readOldHistory(in);
        }
        this.mHistoryBaseTime = historyBaseTime;
        if (this.mHistoryBaseTime > 0L) {
            long oldnow = SystemClock.elapsedRealtime();
            this.mHistoryBaseTime = this.mHistoryBaseTime - oldnow + 1L;
        }
    }

    void readOldHistory(Parcel in) {
    }

    void writeHistory(Parcel out, boolean inclData, boolean andOldHistory) {
        out.writeLong(this.mHistoryBaseTime + this.mLastHistoryElapsedRealtime);
        if (!inclData) {
            out.writeInt(0);
            out.writeInt(0);
            return;
        }
        out.writeInt(this.mHistoryTagPool.size());
        for (Map.Entry<BatteryStats.HistoryTag, Integer> ent : this.mHistoryTagPool.entrySet()) {
            BatteryStats.HistoryTag tag = ent.getKey();
            out.writeInt(ent.getValue());
            out.writeString(tag.string);
            out.writeInt(tag.uid);
        }
        out.writeInt(this.mHistoryBuffer.dataSize());
        out.appendFrom(this.mHistoryBuffer, 0, this.mHistoryBuffer.dataSize());
        if (andOldHistory) {
            this.writeOldHistory(out);
        }
    }

    void writeOldHistory(Parcel out) {
    }

    public void readSummaryFromParcel(Parcel in) throws ParcelFormatException {
        int i;
        int NPKG;
        int version = in.readInt();
        if (version != 130) {
            Slog.w("BatteryStats", "readFromParcel: version got " + version + ", expected " + 130 + "; erasing old stats");
            return;
        }
        this.readHistory(in, true);
        this.mStartCount = in.readInt();
        this.mUptime = in.readLong();
        this.mRealtime = in.readLong();
        this.mStartClockTime = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mOnBatteryTimeBase.readSummaryFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readSummaryFromParcel(in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mDailyDischargeStepTracker.readFromParcel(in);
        this.mDailyChargeStepTracker.readFromParcel(in);
        if (NPKG > 0) {
            this.mDailyPackageChanges = new ArrayList(NPKG);
            for (NPKG = in.readInt(); NPKG > 0; --NPKG) {
                BatteryStats.PackageChange pc = new BatteryStats.PackageChange();
                pc.mPackageName = in.readString();
                pc.mUpdate = in.readInt() != 0;
                pc.mVersionCode = in.readInt();
                this.mDailyPackageChanges.add(pc);
            }
        } else {
            this.mDailyPackageChanges = null;
        }
        this.mDailyStartTime = in.readLong();
        this.mNextMinDailyDeadline = in.readLong();
        this.mNextMaxDailyDeadline = in.readLong();
        ++this.mStartCount;
        this.mScreenState = 0;
        this.mScreenOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdleModeEnabledTimer.readSummaryFromParcelLocked(in);
        this.mDeviceIdlingTimer.readSummaryFromParcelLocked(in);
        this.mPhoneOnTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        this.mPhoneSignalScanningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].readSummaryFromParcelLocked(in);
            this.mNetworkPacketActivityCounters[i].readSummaryFromParcelLocked(in);
        }
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mMobileRadioActiveTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActivePerAppTimer.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveAdjustedTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownTime.readSummaryFromParcelLocked(in);
        this.mMobileRadioActiveUnknownCount.readSummaryFromParcelLocked(in);
        this.mWifiRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mWifiOn = false;
        this.mWifiOnTimer.readSummaryFromParcelLocked(in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer.readSummaryFromParcelLocked(in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 4; ++i) {
            this.mBluetoothActivityCounters[i].readSummaryFromParcelLocked(in);
        }
        for (i = 0; i < 4; ++i) {
            this.mWifiActivityCounters[i].readSummaryFromParcelLocked(in);
        }
        this.mNumConnectivityChange = this.mLoadedNumConnectivityChange = in.readInt();
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer.readSummaryFromParcelLocked(in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer.readSummaryFromParcelLocked(in);
        int NKW = in.readInt();
        if (NKW > 10000) {
            throw new ParcelFormatException("File corrupt: too many kernel wake locks " + NKW);
        }
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String kwltName = in.readString();
            this.getKernelWakelockTimerLocked(kwltName).readSummaryFromParcelLocked(in);
        }
        int NWR = in.readInt();
        if (NWR > 10000) {
            throw new ParcelFormatException("File corrupt: too many wakeup reasons " + NWR);
        }
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            this.getWakeupReasonTimerLocked(reasonName).readSummaryFromParcelLocked(in);
        }
        sNumSpeedSteps = in.readInt();
        if (sNumSpeedSteps < 0 || sNumSpeedSteps > 100) {
            throw new ParcelFormatException("Bad speed steps in data: " + sNumSpeedSteps);
        }
        int NU = in.readInt();
        if (NU > 10000) {
            throw new ParcelFormatException("File corrupt: too many uids " + NU);
        }
        for (int iu = 0; iu < NU; ++iu) {
            TimeBaseObs p;
            int ip;
            int i2;
            int uid = in.readInt();
            Uid u = new Uid(uid);
            this.mUidStats.put(uid, u);
            u.mWifiRunning = false;
            if (in.readInt() != 0) {
                u.mWifiRunningTimer.readSummaryFromParcelLocked(in);
            }
            u.mFullWifiLockOut = false;
            if (in.readInt() != 0) {
                u.mFullWifiLockTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiScanStarted = false;
            if (in.readInt() != 0) {
                u.mWifiScanTimer.readSummaryFromParcelLocked(in);
            }
            u.mWifiBatchedScanBinStarted = -1;
            for (i2 = 0; i2 < 5; ++i2) {
                if (in.readInt() == 0) continue;
                u.makeWifiBatchedScanBin(i2, null);
                u.mWifiBatchedScanTimer[i2].readSummaryFromParcelLocked(in);
            }
            u.mWifiMulticastEnabled = false;
            if (in.readInt() != 0) {
                u.mWifiMulticastTimer.readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createAudioTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVideoTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createFlashlightTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createCameraTurnedOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createForegroundActivityTimerLocked().readSummaryFromParcelLocked(in);
            }
            u.mProcessState = 3;
            for (i2 = 0; i2 < 3; ++i2) {
                if (in.readInt() == 0) continue;
                u.makeProcessState(i2, null);
                u.mProcessStateTimer[i2].readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                u.createVibratorOnTimerLocked().readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                if (u.mUserActivityCounters == null) {
                    u.initUserActivityLocked();
                }
                for (i2 = 0; i2 < 3; ++i2) {
                    u.mUserActivityCounters[i2].readSummaryFromParcelLocked(in);
                }
            }
            if (in.readInt() != 0) {
                if (u.mNetworkByteActivityCounters == null) {
                    u.initNetworkActivityLocked();
                }
                for (i2 = 0; i2 < 4; ++i2) {
                    u.mNetworkByteActivityCounters[i2].readSummaryFromParcelLocked(in);
                    u.mNetworkPacketActivityCounters[i2].readSummaryFromParcelLocked(in);
                }
                u.mMobileRadioActiveTime.readSummaryFromParcelLocked(in);
                u.mMobileRadioActiveCount.readSummaryFromParcelLocked(in);
            }
            u.mUserCpuTime.readSummaryFromParcelLocked(in);
            u.mSystemCpuTime.readSummaryFromParcelLocked(in);
            u.mCpuPower.readSummaryFromParcelLocked(in);
            int NSB = in.readInt();
            if (NSB > 100) {
                throw new ParcelFormatException("File corrupt: too many speed bins " + NSB);
            }
            u.mSpeedBins = new LongSamplingCounter[NSB];
            for (int i3 = 0; i3 < NSB; ++i3) {
                if (in.readInt() == 0) continue;
                u.mSpeedBins[i3] = new LongSamplingCounter(this.mOnBatteryTimeBase);
                u.mSpeedBins[i3].readSummaryFromParcelLocked(in);
            }
            int NW = in.readInt();
            if (NW > 100) {
                throw new ParcelFormatException("File corrupt: too many wake locks " + NW);
            }
            for (int iw = 0; iw < NW; ++iw) {
                String wlName = in.readString();
                u.readWakeSummaryFromParcelLocked(wlName, in);
            }
            int NS = in.readInt();
            if (NS > 100) {
                throw new ParcelFormatException("File corrupt: too many syncs " + NS);
            }
            for (int is = 0; is < NS; ++is) {
                String name = in.readString();
                u.readSyncSummaryFromParcelLocked(name, in);
            }
            int NJ = in.readInt();
            if (NJ > 100) {
                throw new ParcelFormatException("File corrupt: too many job timers " + NJ);
            }
            for (int ij = 0; ij < NJ; ++ij) {
                String name = in.readString();
                u.readJobSummaryFromParcelLocked(name, in);
            }
            int NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many sensors " + NP);
            }
            for (int is = 0; is < NP; ++is) {
                int seNumber = in.readInt();
                if (in.readInt() == 0) continue;
                u.getSensorTimerLocked(seNumber, true).readSummaryFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 1000) {
                throw new ParcelFormatException("File corrupt: too many processes " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String procName = in.readString();
                p = u.getProcessStatsLocked(procName);
                ((Uid.Proc)p).mUserTime = ((Uid.Proc)p).mLoadedUserTime = in.readLong();
                ((Uid.Proc)p).mSystemTime = ((Uid.Proc)p).mLoadedSystemTime = in.readLong();
                ((Uid.Proc)p).mForegroundTime = ((Uid.Proc)p).mLoadedForegroundTime = in.readLong();
                ((Uid.Proc)p).mStarts = ((Uid.Proc)p).mLoadedStarts = in.readInt();
                ((Uid.Proc)p).mNumCrashes = ((Uid.Proc)p).mLoadedNumCrashes = in.readInt();
                ((Uid.Proc)p).mNumAnrs = ((Uid.Proc)p).mLoadedNumAnrs = in.readInt();
                ((Uid.Proc)p).readExcessivePowerFromParcelLocked(in);
            }
            NP = in.readInt();
            if (NP > 10000) {
                throw new ParcelFormatException("File corrupt: too many packages " + NP);
            }
            for (ip = 0; ip < NP; ++ip) {
                String pkgName = in.readString();
                p = u.getPackageStatsLocked(pkgName);
                int NWA = in.readInt();
                if (NWA > 1000) {
                    throw new ParcelFormatException("File corrupt: too many wakeup alarms " + NWA);
                }
                ((Uid.Pkg)p).mWakeupAlarms.clear();
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    String tag = in.readString();
                    Counter c = new Counter(this.mOnBatteryTimeBase);
                    c.readSummaryFromParcelLocked(in);
                    ((Uid.Pkg)p).mWakeupAlarms.put(tag, c);
                }
                NS = in.readInt();
                if (NS > 1000) {
                    throw new ParcelFormatException("File corrupt: too many services " + NS);
                }
                for (int is = 0; is < NS; ++is) {
                    String servName = in.readString();
                    Uid.Pkg.Serv s = u.getServiceStatsLocked(pkgName, servName);
                    s.mStartTime = s.mLoadedStartTime = in.readLong();
                    s.mStarts = s.mLoadedStarts = in.readInt();
                    s.mLaunches = s.mLoadedLaunches = in.readInt();
                }
            }
        }
    }

    public void writeSummaryToParcel(Parcel out, boolean inclHistory) {
        int i;
        this.pullPendingStateUpdatesLocked();
        long startClockTime = this.getStartClockTime();
        long NOW_SYS = SystemClock.uptimeMillis() * 1000L;
        long NOWREAL_SYS = SystemClock.elapsedRealtime() * 1000L;
        out.writeInt(130);
        this.writeHistory(out, inclHistory, true);
        out.writeInt(this.mStartCount);
        out.writeLong(this.computeUptime(NOW_SYS, 0));
        out.writeLong(this.computeRealtime(NOWREAL_SYS, 0));
        out.writeLong(startClockTime);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        this.mOnBatteryTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
        this.mOnBatteryScreenOffTimeBase.writeSummaryToParcel(out, NOW_SYS, NOWREAL_SYS);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.getLowDischargeAmountSinceCharge());
        out.writeInt(this.getHighDischargeAmountSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOnSinceCharge());
        out.writeInt(this.getDischargeAmountScreenOffSinceCharge());
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        this.mDailyDischargeStepTracker.writeToParcel(out);
        this.mDailyChargeStepTracker.writeToParcel(out);
        if (this.mDailyPackageChanges != null) {
            int NPKG = this.mDailyPackageChanges.size();
            out.writeInt(NPKG);
            for (int i2 = 0; i2 < NPKG; ++i2) {
                BatteryStats.PackageChange pc = this.mDailyPackageChanges.get(i2);
                out.writeString(pc.mPackageName);
                out.writeInt(pc.mUpdate ? 1 : 0);
                out.writeInt(pc.mVersionCode);
            }
        } else {
            out.writeInt(0);
        }
        out.writeLong(this.mDailyStartTime);
        out.writeLong(this.mNextMinDailyDeadline);
        out.writeLong(this.mNextMaxDailyDeadline);
        this.mScreenOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mInteractiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mPowerSaveModeEnabledTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceIdleModeEnabledTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mDeviceIdlingTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mPhoneOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        this.mPhoneSignalScanningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].writeSummaryFromParcelLocked(out);
            this.mNetworkPacketActivityCounters[i].writeSummaryFromParcelLocked(out);
        }
        this.mMobileRadioActiveTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mMobileRadioActivePerAppTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mMobileRadioActiveAdjustedTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownTime.writeSummaryFromParcelLocked(out);
        this.mMobileRadioActiveUnknownCount.writeSummaryFromParcelLocked(out);
        this.mWifiOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mGlobalWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        }
        for (i = 0; i < 4; ++i) {
            this.mBluetoothActivityCounters[i].writeSummaryFromParcelLocked(out);
        }
        for (i = 0; i < 4; ++i) {
            this.mWifiActivityCounters[i].writeSummaryFromParcelLocked(out);
        }
        out.writeInt(this.mNumConnectivityChange);
        this.mFlashlightOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        this.mCameraOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
        out.writeInt(this.mKernelWakelockStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
            Timer kwlt = ent.getValue();
            if (kwlt != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                kwlt.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(this.mWakeupReasonStats.size());
        for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
            SamplingTimer timer = ent.getValue();
            if (timer != null) {
                out.writeInt(1);
                out.writeString(ent.getKey());
                timer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(sNumSpeedSteps);
        int NU = this.mUidStats.size();
        out.writeInt(NU);
        for (int iu = 0; iu < NU; ++iu) {
            int i3;
            out.writeInt(this.mUidStats.keyAt(iu));
            Uid u = this.mUidStats.valueAt(iu);
            if (u.mWifiRunningTimer != null) {
                out.writeInt(1);
                u.mWifiRunningTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mFullWifiLockTimer != null) {
                out.writeInt(1);
                u.mFullWifiLockTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mWifiScanTimer != null) {
                out.writeInt(1);
                u.mWifiScanTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            for (i3 = 0; i3 < 5; ++i3) {
                if (u.mWifiBatchedScanTimer[i3] != null) {
                    out.writeInt(1);
                    u.mWifiBatchedScanTimer[i3].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mWifiMulticastTimer != null) {
                out.writeInt(1);
                u.mWifiMulticastTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                u.mAudioTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                u.mVideoTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                u.mFlashlightTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                u.mCameraTurnedOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mForegroundActivityTimer != null) {
                out.writeInt(1);
                u.mForegroundActivityTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            for (i3 = 0; i3 < 3; ++i3) {
                if (u.mProcessStateTimer[i3] != null) {
                    out.writeInt(1);
                    u.mProcessStateTimer[i3].writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            if (u.mVibratorOnTimer != null) {
                out.writeInt(1);
                u.mVibratorOnTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            } else {
                out.writeInt(0);
            }
            if (u.mUserActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i3 = 0; i3 < 3; ++i3) {
                    u.mUserActivityCounters[i3].writeSummaryFromParcelLocked(out);
                }
            }
            if (u.mNetworkByteActivityCounters == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                for (i3 = 0; i3 < 4; ++i3) {
                    u.mNetworkByteActivityCounters[i3].writeSummaryFromParcelLocked(out);
                    u.mNetworkPacketActivityCounters[i3].writeSummaryFromParcelLocked(out);
                }
                u.mMobileRadioActiveTime.writeSummaryFromParcelLocked(out);
                u.mMobileRadioActiveCount.writeSummaryFromParcelLocked(out);
            }
            u.mUserCpuTime.writeSummaryFromParcelLocked(out);
            u.mSystemCpuTime.writeSummaryFromParcelLocked(out);
            u.mCpuPower.writeSummaryFromParcelLocked(out);
            out.writeInt(u.mSpeedBins.length);
            for (i3 = 0; i3 < u.mSpeedBins.length; ++i3) {
                LongSamplingCounter speedBin = u.mSpeedBins[i3];
                if (speedBin != null) {
                    out.writeInt(1);
                    speedBin.writeSummaryFromParcelLocked(out);
                    continue;
                }
                out.writeInt(0);
            }
            ArrayMap<String, Uid.Wakelock> wakeStats = u.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Uid.Wakelock wl = wakeStats.valueAt(iw);
                if (wl.mTimerFull != null) {
                    out.writeInt(1);
                    wl.mTimerFull.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerPartial != null) {
                    out.writeInt(1);
                    wl.mTimerPartial.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerWindow != null) {
                    out.writeInt(1);
                    wl.mTimerWindow.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                } else {
                    out.writeInt(0);
                }
                if (wl.mTimerDraw != null) {
                    out.writeInt(1);
                    wl.mTimerDraw.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            ArrayMap<String, StopwatchTimer> syncStats = u.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                syncStats.valueAt(is).writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            }
            ArrayMap<String, StopwatchTimer> jobStats = u.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                jobStats.valueAt(ij).writeSummaryFromParcelLocked(out, NOWREAL_SYS);
            }
            int NSE = u.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(u.mSensorStats.keyAt(ise));
                Uid.Sensor se = u.mSensorStats.valueAt(ise);
                if (se.mTimer != null) {
                    out.writeInt(1);
                    se.mTimer.writeSummaryFromParcelLocked(out, NOWREAL_SYS);
                    continue;
                }
                out.writeInt(0);
            }
            int NP = u.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(u.mProcessStats.keyAt(ip));
                Uid.Proc ps = u.mProcessStats.valueAt(ip);
                out.writeLong(ps.mUserTime);
                out.writeLong(ps.mSystemTime);
                out.writeLong(ps.mForegroundTime);
                out.writeInt(ps.mStarts);
                out.writeInt(ps.mNumCrashes);
                out.writeInt(ps.mNumAnrs);
                ps.writeExcessivePowerToParcelLocked(out);
            }
            NP = u.mPackageStats.size();
            out.writeInt(NP);
            if (NP <= 0) continue;
            for (Map.Entry<String, Uid.Pkg> ent : u.mPackageStats.entrySet()) {
                out.writeString(ent.getKey());
                Uid.Pkg ps = ent.getValue();
                int NWA = ps.mWakeupAlarms.size();
                out.writeInt(NWA);
                for (int iwa = 0; iwa < NWA; ++iwa) {
                    out.writeString(ps.mWakeupAlarms.keyAt(iwa));
                    ps.mWakeupAlarms.valueAt(iwa).writeSummaryFromParcelLocked(out);
                }
                NS = ps.mServiceStats.size();
                out.writeInt(NS);
                for (int is = 0; is < NS; ++is) {
                    out.writeString(ps.mServiceStats.keyAt(is));
                    Uid.Pkg.Serv ss = ps.mServiceStats.valueAt(is);
                    long time = ss.getStartTimeToNowLocked(this.mOnBatteryTimeBase.getUptime(NOW_SYS));
                    out.writeLong(time);
                    out.writeInt(ss.mStarts);
                    out.writeInt(ss.mLaunches);
                }
            }
        }
    }

    public void readFromParcel(Parcel in) {
        this.readFromParcelLocked(in);
    }

    void readFromParcelLocked(Parcel in) {
        int i;
        int magic = in.readInt();
        if (magic != -1166707595) {
            throw new ParcelFormatException("Bad magic number: #" + Integer.toHexString(magic));
        }
        this.readHistory(in, false);
        this.mStartCount = in.readInt();
        this.mStartClockTime = in.readLong();
        this.mStartPlatformVersion = in.readString();
        this.mEndPlatformVersion = in.readString();
        this.mUptime = in.readLong();
        this.mUptimeStart = in.readLong();
        this.mRealtime = in.readLong();
        this.mRealtimeStart = in.readLong();
        this.mOnBattery = in.readInt() != 0;
        this.mOnBatteryInternal = false;
        this.mOnBatteryTimeBase.readFromParcel(in);
        this.mOnBatteryScreenOffTimeBase.readFromParcel(in);
        this.mScreenState = 0;
        this.mScreenOnTimer = new StopwatchTimer(null, -1, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i] = new StopwatchTimer(null, -100 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mInteractive = false;
        this.mInteractiveTimer = new StopwatchTimer(null, -10, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOn = false;
        this.mPowerSaveModeEnabledTimer = new StopwatchTimer(null, -2, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdleModeEnabledTimer = new StopwatchTimer(null, -11, null, this.mOnBatteryTimeBase, in);
        this.mDeviceIdlingTimer = new StopwatchTimer(null, -12, null, this.mOnBatteryTimeBase, in);
        this.mPhoneOnTimer = new StopwatchTimer(null, -3, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i] = new StopwatchTimer(null, -200 - i, null, this.mOnBatteryTimeBase, in);
        }
        this.mPhoneSignalScanningTimer = new StopwatchTimer(null, -199, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i] = new StopwatchTimer(null, -300 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
            this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        }
        this.mMobileRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mMobileRadioActiveTimer = new StopwatchTimer(null, -400, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActivePerAppTimer = new StopwatchTimer(null, -401, null, this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveAdjustedTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownTime = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mMobileRadioActiveUnknownCount = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        this.mWifiRadioPowerState = DataConnectionRealTimeInfo.DC_POWER_STATE_LOW;
        this.mWifiOn = false;
        this.mWifiOnTimer = new StopwatchTimer(null, -4, null, this.mOnBatteryTimeBase, in);
        this.mGlobalWifiRunning = false;
        this.mGlobalWifiRunningTimer = new StopwatchTimer(null, -5, null, this.mOnBatteryTimeBase, in);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i] = new StopwatchTimer(null, -600 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i] = new StopwatchTimer(null, -700 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i] = new StopwatchTimer(null, -800 - i, null, this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 4; ++i) {
            this.mBluetoothActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        }
        for (i = 0; i < 4; ++i) {
            this.mWifiActivityCounters[i] = new LongSamplingCounter(this.mOnBatteryTimeBase, in);
        }
        this.mHasWifiEnergyReporting = in.readInt() != 0;
        this.mHasBluetoothEnergyReporting = in.readInt() != 0;
        this.mNumConnectivityChange = in.readInt();
        this.mLoadedNumConnectivityChange = in.readInt();
        this.mUnpluggedNumConnectivityChange = in.readInt();
        this.mAudioOnNesting = 0;
        this.mAudioOnTimer = new StopwatchTimer(null, -7, null, this.mOnBatteryTimeBase);
        this.mVideoOnNesting = 0;
        this.mVideoOnTimer = new StopwatchTimer(null, -8, null, this.mOnBatteryTimeBase);
        this.mFlashlightOnNesting = 0;
        this.mFlashlightOnTimer = new StopwatchTimer(null, -9, null, this.mOnBatteryTimeBase, in);
        this.mCameraOnNesting = 0;
        this.mCameraOnTimer = new StopwatchTimer(null, -13, null, this.mOnBatteryTimeBase, in);
        this.mDischargeUnplugLevel = in.readInt();
        this.mDischargePlugLevel = in.readInt();
        this.mDischargeCurrentLevel = in.readInt();
        this.mCurrentBatteryLevel = in.readInt();
        this.mLowDischargeAmountSinceCharge = in.readInt();
        this.mHighDischargeAmountSinceCharge = in.readInt();
        this.mDischargeAmountScreenOn = in.readInt();
        this.mDischargeAmountScreenOnSinceCharge = in.readInt();
        this.mDischargeAmountScreenOff = in.readInt();
        this.mDischargeAmountScreenOffSinceCharge = in.readInt();
        this.mDischargeStepTracker.readFromParcel(in);
        this.mChargeStepTracker.readFromParcel(in);
        this.mLastWriteTime = in.readLong();
        this.mKernelWakelockStats.clear();
        int NKW = in.readInt();
        for (int ikw = 0; ikw < NKW; ++ikw) {
            if (in.readInt() == 0) continue;
            String wakelockName = in.readString();
            SamplingTimer kwlt = new SamplingTimer(this.mOnBatteryScreenOffTimeBase, in);
            this.mKernelWakelockStats.put(wakelockName, kwlt);
        }
        this.mWakeupReasonStats.clear();
        int NWR = in.readInt();
        for (int iwr = 0; iwr < NWR; ++iwr) {
            if (in.readInt() == 0) continue;
            String reasonName = in.readString();
            SamplingTimer timer = new SamplingTimer(this.mOnBatteryTimeBase, in);
            this.mWakeupReasonStats.put(reasonName, timer);
        }
        this.mPartialTimers.clear();
        this.mFullTimers.clear();
        this.mWindowTimers.clear();
        this.mWifiRunningTimers.clear();
        this.mFullWifiLockTimers.clear();
        this.mWifiScanTimers.clear();
        this.mWifiBatchedScanTimers.clear();
        this.mWifiMulticastTimers.clear();
        this.mAudioTurnedOnTimers.clear();
        this.mVideoTurnedOnTimers.clear();
        this.mFlashlightTurnedOnTimers.clear();
        this.mCameraTurnedOnTimers.clear();
        sNumSpeedSteps = in.readInt();
        int numUids = in.readInt();
        this.mUidStats.clear();
        for (int i2 = 0; i2 < numUids; ++i2) {
            int uid = in.readInt();
            Uid u = new Uid(uid);
            u.readFromParcelLocked(this.mOnBatteryTimeBase, this.mOnBatteryScreenOffTimeBase, in);
            this.mUidStats.append(uid, u);
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.writeToParcelLocked(out, true, flags);
    }

    @Override
    public void writeToParcelWithoutUids(Parcel out, int flags) {
        this.writeToParcelLocked(out, false, flags);
    }

    void writeToParcelLocked(Parcel out, boolean inclUids, int flags) {
        int i;
        this.pullPendingStateUpdatesLocked();
        long startClockTime = this.getStartClockTime();
        long uSecUptime = SystemClock.uptimeMillis() * 1000L;
        long uSecRealtime = SystemClock.elapsedRealtime() * 1000L;
        long batteryRealtime = this.mOnBatteryTimeBase.getRealtime(uSecRealtime);
        long batteryScreenOffRealtime = this.mOnBatteryScreenOffTimeBase.getRealtime(uSecRealtime);
        out.writeInt(-1166707595);
        this.writeHistory(out, true, false);
        out.writeInt(this.mStartCount);
        out.writeLong(startClockTime);
        out.writeString(this.mStartPlatformVersion);
        out.writeString(this.mEndPlatformVersion);
        out.writeLong(this.mUptime);
        out.writeLong(this.mUptimeStart);
        out.writeLong(this.mRealtime);
        out.writeLong(this.mRealtimeStart);
        out.writeInt(this.mOnBattery ? 1 : 0);
        this.mOnBatteryTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mOnBatteryScreenOffTimeBase.writeToParcel(out, uSecUptime, uSecRealtime);
        this.mScreenOnTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 5; ++i) {
            this.mScreenBrightnessTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mInteractiveTimer.writeToParcel(out, uSecRealtime);
        this.mPowerSaveModeEnabledTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdleModeEnabledTimer.writeToParcel(out, uSecRealtime);
        this.mDeviceIdlingTimer.writeToParcel(out, uSecRealtime);
        this.mPhoneOnTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 5; ++i) {
            this.mPhoneSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        this.mPhoneSignalScanningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 17; ++i) {
            this.mPhoneDataConnectionsTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 4; ++i) {
            this.mNetworkByteActivityCounters[i].writeToParcel(out);
            this.mNetworkPacketActivityCounters[i].writeToParcel(out);
        }
        this.mMobileRadioActiveTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActivePerAppTimer.writeToParcel(out, uSecRealtime);
        this.mMobileRadioActiveAdjustedTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownTime.writeToParcel(out);
        this.mMobileRadioActiveUnknownCount.writeToParcel(out);
        this.mWifiOnTimer.writeToParcel(out, uSecRealtime);
        this.mGlobalWifiRunningTimer.writeToParcel(out, uSecRealtime);
        for (i = 0; i < 8; ++i) {
            this.mWifiStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 13; ++i) {
            this.mWifiSupplStateTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 5; ++i) {
            this.mWifiSignalStrengthsTimer[i].writeToParcel(out, uSecRealtime);
        }
        for (i = 0; i < 4; ++i) {
            this.mBluetoothActivityCounters[i].writeToParcel(out);
        }
        for (i = 0; i < 4; ++i) {
            this.mWifiActivityCounters[i].writeToParcel(out);
        }
        out.writeInt(this.mHasWifiEnergyReporting ? 1 : 0);
        out.writeInt(this.mHasBluetoothEnergyReporting ? 1 : 0);
        out.writeInt(this.mNumConnectivityChange);
        out.writeInt(this.mLoadedNumConnectivityChange);
        out.writeInt(this.mUnpluggedNumConnectivityChange);
        this.mFlashlightOnTimer.writeToParcel(out, uSecRealtime);
        this.mCameraOnTimer.writeToParcel(out, uSecRealtime);
        out.writeInt(this.mDischargeUnplugLevel);
        out.writeInt(this.mDischargePlugLevel);
        out.writeInt(this.mDischargeCurrentLevel);
        out.writeInt(this.mCurrentBatteryLevel);
        out.writeInt(this.mLowDischargeAmountSinceCharge);
        out.writeInt(this.mHighDischargeAmountSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOn);
        out.writeInt(this.mDischargeAmountScreenOnSinceCharge);
        out.writeInt(this.mDischargeAmountScreenOff);
        out.writeInt(this.mDischargeAmountScreenOffSinceCharge);
        this.mDischargeStepTracker.writeToParcel(out);
        this.mChargeStepTracker.writeToParcel(out);
        out.writeLong(this.mLastWriteTime);
        if (inclUids) {
            out.writeInt(this.mKernelWakelockStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mKernelWakelockStats.entrySet()) {
                SamplingTimer kwlt = ent.getValue();
                if (kwlt != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    kwlt.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
            out.writeInt(this.mWakeupReasonStats.size());
            for (Map.Entry<String, SamplingTimer> ent : this.mWakeupReasonStats.entrySet()) {
                SamplingTimer timer = ent.getValue();
                if (timer != null) {
                    out.writeInt(1);
                    out.writeString(ent.getKey());
                    timer.writeToParcel(out, uSecRealtime);
                    continue;
                }
                out.writeInt(0);
            }
        } else {
            out.writeInt(0);
        }
        out.writeInt(sNumSpeedSteps);
        if (inclUids) {
            int size = this.mUidStats.size();
            out.writeInt(size);
            for (int i2 = 0; i2 < size; ++i2) {
                out.writeInt(this.mUidStats.keyAt(i2));
                Uid uid = this.mUidStats.valueAt(i2);
                uid.writeToParcelLocked(out, uSecRealtime);
            }
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void prepareForDumpLocked() {
        this.pullPendingStateUpdatesLocked();
        this.getStartClockTime();
    }

    @Override
    public void dumpLocked(Context context, PrintWriter pw, int flags, int reqUid, long histStart) {
        super.dumpLocked(context, pw, flags, reqUid, histStart);
    }

    static {
        CREATOR = new Parcelable.Creator<BatteryStatsImpl>(){

            @Override
            public BatteryStatsImpl createFromParcel(Parcel in) {
                return new BatteryStatsImpl(in);
            }

            public BatteryStatsImpl[] newArray(int size) {
                return new BatteryStatsImpl[size];
            }
        };
    }

    public final class Uid
    extends BatteryStats.Uid {
        final int mUid;
        boolean mWifiRunning;
        StopwatchTimer mWifiRunningTimer;
        boolean mFullWifiLockOut;
        StopwatchTimer mFullWifiLockTimer;
        boolean mWifiScanStarted;
        StopwatchTimer mWifiScanTimer;
        static final int NO_BATCHED_SCAN_STARTED = -1;
        int mWifiBatchedScanBinStarted = -1;
        StopwatchTimer[] mWifiBatchedScanTimer;
        boolean mWifiMulticastEnabled;
        StopwatchTimer mWifiMulticastTimer;
        StopwatchTimer mAudioTurnedOnTimer;
        StopwatchTimer mVideoTurnedOnTimer;
        StopwatchTimer mFlashlightTurnedOnTimer;
        StopwatchTimer mCameraTurnedOnTimer;
        StopwatchTimer mForegroundActivityTimer;
        static final int PROCESS_STATE_NONE = 3;
        int mProcessState = 3;
        StopwatchTimer[] mProcessStateTimer;
        BatchTimer mVibratorOnTimer;
        Counter[] mUserActivityCounters;
        LongSamplingCounter[] mNetworkByteActivityCounters;
        LongSamplingCounter[] mNetworkPacketActivityCounters;
        LongSamplingCounter mMobileRadioActiveTime;
        LongSamplingCounter mMobileRadioActiveCount;
        LongSamplingCounter[] mWifiControllerTime = new LongSamplingCounter[4];
        LongSamplingCounter[] mBluetoothControllerTime = new LongSamplingCounter[4];
        long mLastStepUserTime;
        long mLastStepSystemTime;
        long mCurStepUserTime;
        long mCurStepSystemTime;
        LongSamplingCounter mUserCpuTime;
        LongSamplingCounter mSystemCpuTime;
        LongSamplingCounter mCpuPower;
        LongSamplingCounter[] mSpeedBins;
        final OverflowArrayMap<Wakelock> mWakelockStats;
        final OverflowArrayMap<StopwatchTimer> mSyncStats;
        final OverflowArrayMap<StopwatchTimer> mJobStats;
        final SparseArray<Sensor> mSensorStats;
        final ArrayMap<String, Proc> mProcessStats;
        final ArrayMap<String, Pkg> mPackageStats;
        final SparseArray<BatteryStats.Uid.Pid> mPids;

        public Uid(int uid) {
            this.mUserCpuTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mSystemCpuTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mCpuPower = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mWakelockStats = new OverflowArrayMap<Wakelock>(){

                @Override
                public Wakelock instantiateObject() {
                    return new Wakelock();
                }
            };
            this.mSyncStats = new OverflowArrayMap<StopwatchTimer>(){

                @Override
                public StopwatchTimer instantiateObject() {
                    return new StopwatchTimer(Uid.this, 13, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
            };
            this.mJobStats = new OverflowArrayMap<StopwatchTimer>(){

                @Override
                public StopwatchTimer instantiateObject() {
                    return new StopwatchTimer(Uid.this, 14, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
            };
            this.mSensorStats = new SparseArray();
            this.mProcessStats = new ArrayMap();
            this.mPackageStats = new ArrayMap();
            this.mPids = new SparseArray();
            this.mUid = uid;
            this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mWifiScanTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mWifiBatchedScanTimer = new StopwatchTimer[5];
            this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mProcessStateTimer = new StopwatchTimer[3];
            this.mSpeedBins = new LongSamplingCounter[BatteryStatsImpl.this.getCpuSpeedSteps()];
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Wakelock> getWakelockStats() {
            return this.mWakelockStats.getMap();
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getSyncStats() {
            return this.mSyncStats.getMap();
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Timer> getJobStats() {
            return this.mJobStats.getMap();
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Sensor> getSensorStats() {
            return this.mSensorStats;
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Proc> getProcessStats() {
            return this.mProcessStats;
        }

        @Override
        public ArrayMap<String, ? extends BatteryStats.Uid.Pkg> getPackageStats() {
            return this.mPackageStats;
        }

        @Override
        public int getUid() {
            return this.mUid;
        }

        @Override
        public void noteWifiRunningLocked(long elapsedRealtimeMs) {
            if (!this.mWifiRunning) {
                this.mWifiRunning = true;
                if (this.mWifiRunningTimer == null) {
                    this.mWifiRunningTimer = new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mWifiRunningTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiRunning) {
                this.mWifiRunning = false;
                this.mWifiRunningTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteFullWifiLockAcquiredLocked(long elapsedRealtimeMs) {
            if (!this.mFullWifiLockOut) {
                this.mFullWifiLockOut = true;
                if (this.mFullWifiLockTimer == null) {
                    this.mFullWifiLockTimer = new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mFullWifiLockTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteFullWifiLockReleasedLocked(long elapsedRealtimeMs) {
            if (this.mFullWifiLockOut) {
                this.mFullWifiLockOut = false;
                this.mFullWifiLockTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiScanStartedLocked(long elapsedRealtimeMs) {
            if (!this.mWifiScanStarted) {
                this.mWifiScanStarted = true;
                if (this.mWifiScanTimer == null) {
                    this.mWifiScanTimer = new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mWifiScanTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiScanStarted) {
                this.mWifiScanStarted = false;
                this.mWifiScanTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiBatchedScanStartedLocked(int csph, long elapsedRealtimeMs) {
            int bin;
            for (bin = 0; csph > 8 && bin < 4; csph >>= 3, ++bin) {
            }
            if (this.mWifiBatchedScanBinStarted == bin) {
                return;
            }
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mWifiBatchedScanBinStarted = bin;
            if (this.mWifiBatchedScanTimer[bin] == null) {
                this.makeWifiBatchedScanBin(bin, null);
            }
            this.mWifiBatchedScanTimer[bin].startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void noteWifiBatchedScanStoppedLocked(long elapsedRealtimeMs) {
            if (this.mWifiBatchedScanBinStarted != -1) {
                this.mWifiBatchedScanTimer[this.mWifiBatchedScanBinStarted].stopRunningLocked(elapsedRealtimeMs);
                this.mWifiBatchedScanBinStarted = -1;
            }
        }

        @Override
        public void noteWifiMulticastEnabledLocked(long elapsedRealtimeMs) {
            if (!this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = true;
                if (this.mWifiMulticastTimer == null) {
                    this.mWifiMulticastTimer = new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                }
                this.mWifiMulticastTimer.startRunningLocked(elapsedRealtimeMs);
            }
        }

        @Override
        public void noteWifiMulticastDisabledLocked(long elapsedRealtimeMs) {
            if (this.mWifiMulticastEnabled) {
                this.mWifiMulticastEnabled = false;
                this.mWifiMulticastTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteWifiControllerActivityLocked(int type, long timeMs) {
            if (this.mWifiControllerTime[type] == null) {
                this.mWifiControllerTime[type] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            this.mWifiControllerTime[type].addCountLocked(timeMs);
        }

        public StopwatchTimer createAudioTurnedOnTimerLocked() {
            if (this.mAudioTurnedOnTimer == null) {
                this.mAudioTurnedOnTimer = new StopwatchTimer(this, 15, BatteryStatsImpl.this.mAudioTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mAudioTurnedOnTimer;
        }

        public void noteAudioTurnedOnLocked(long elapsedRealtimeMs) {
            this.createAudioTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteAudioTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetAudioLocked(long elapsedRealtimeMs) {
            if (this.mAudioTurnedOnTimer != null) {
                this.mAudioTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createVideoTurnedOnTimerLocked() {
            if (this.mVideoTurnedOnTimer == null) {
                this.mVideoTurnedOnTimer = new StopwatchTimer(this, 8, BatteryStatsImpl.this.mVideoTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mVideoTurnedOnTimer;
        }

        public void noteVideoTurnedOnLocked(long elapsedRealtimeMs) {
            this.createVideoTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteVideoTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetVideoLocked(long elapsedRealtimeMs) {
            if (this.mVideoTurnedOnTimer != null) {
                this.mVideoTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createFlashlightTurnedOnTimerLocked() {
            if (this.mFlashlightTurnedOnTimer == null) {
                this.mFlashlightTurnedOnTimer = new StopwatchTimer(this, 16, BatteryStatsImpl.this.mFlashlightTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mFlashlightTurnedOnTimer;
        }

        public void noteFlashlightTurnedOnLocked(long elapsedRealtimeMs) {
            this.createFlashlightTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteFlashlightTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetFlashlightLocked(long elapsedRealtimeMs) {
            if (this.mFlashlightTurnedOnTimer != null) {
                this.mFlashlightTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createCameraTurnedOnTimerLocked() {
            if (this.mCameraTurnedOnTimer == null) {
                this.mCameraTurnedOnTimer = new StopwatchTimer(this, 17, BatteryStatsImpl.this.mCameraTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mCameraTurnedOnTimer;
        }

        public void noteCameraTurnedOnLocked(long elapsedRealtimeMs) {
            this.createCameraTurnedOnTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        public void noteCameraTurnedOffLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteResetCameraLocked(long elapsedRealtimeMs) {
            if (this.mCameraTurnedOnTimer != null) {
                this.mCameraTurnedOnTimer.stopAllRunningLocked(elapsedRealtimeMs);
            }
        }

        public StopwatchTimer createForegroundActivityTimerLocked() {
            if (this.mForegroundActivityTimer == null) {
                this.mForegroundActivityTimer = new StopwatchTimer(this, 10, null, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mForegroundActivityTimer;
        }

        @Override
        public void noteActivityResumedLocked(long elapsedRealtimeMs) {
            this.createForegroundActivityTimerLocked().startRunningLocked(elapsedRealtimeMs);
        }

        @Override
        public void noteActivityPausedLocked(long elapsedRealtimeMs) {
            if (this.mForegroundActivityTimer != null) {
                this.mForegroundActivityTimer.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        void updateUidProcessStateLocked(int state, long elapsedRealtimeMs) {
            if (this.mProcessState == state) {
                return;
            }
            if (this.mProcessState != 3) {
                this.mProcessStateTimer[this.mProcessState].stopRunningLocked(elapsedRealtimeMs);
            }
            this.mProcessState = state;
            if (state != 3) {
                if (this.mProcessStateTimer[state] == null) {
                    this.makeProcessState(state, null);
                }
                this.mProcessStateTimer[state].startRunningLocked(elapsedRealtimeMs);
            }
        }

        public BatchTimer createVibratorOnTimerLocked() {
            if (this.mVibratorOnTimer == null) {
                this.mVibratorOnTimer = new BatchTimer(this, 9, BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            return this.mVibratorOnTimer;
        }

        public void noteVibratorOnLocked(long durationMillis) {
            this.createVibratorOnTimerLocked().addDuration(BatteryStatsImpl.this, durationMillis);
        }

        public void noteVibratorOffLocked() {
            if (this.mVibratorOnTimer != null) {
                this.mVibratorOnTimer.abortLastDuration(BatteryStatsImpl.this);
            }
        }

        @Override
        public long getWifiRunningTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiRunningTimer == null) {
                return 0L;
            }
            return this.mWifiRunningTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public long getFullWifiLockTime(long elapsedRealtimeUs, int which) {
            if (this.mFullWifiLockTimer == null) {
                return 0L;
            }
            return this.mFullWifiLockTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public long getWifiScanTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiScanTimer == null) {
                return 0L;
            }
            return this.mWifiScanTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public int getWifiScanCount(int which) {
            if (this.mWifiScanTimer == null) {
                return 0;
            }
            return this.mWifiScanTimer.getCountLocked(which);
        }

        @Override
        public long getWifiBatchedScanTime(int csphBin, long elapsedRealtimeUs, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0L;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0L;
            }
            return this.mWifiBatchedScanTimer[csphBin].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public int getWifiBatchedScanCount(int csphBin, int which) {
            if (csphBin < 0 || csphBin >= 5) {
                return 0;
            }
            if (this.mWifiBatchedScanTimer[csphBin] == null) {
                return 0;
            }
            return this.mWifiBatchedScanTimer[csphBin].getCountLocked(which);
        }

        @Override
        public long getWifiMulticastTime(long elapsedRealtimeUs, int which) {
            if (this.mWifiMulticastTimer == null) {
                return 0L;
            }
            return this.mWifiMulticastTimer.getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public Timer getAudioTurnedOnTimer() {
            return this.mAudioTurnedOnTimer;
        }

        @Override
        public Timer getVideoTurnedOnTimer() {
            return this.mVideoTurnedOnTimer;
        }

        @Override
        public Timer getFlashlightTurnedOnTimer() {
            return this.mFlashlightTurnedOnTimer;
        }

        @Override
        public Timer getCameraTurnedOnTimer() {
            return this.mCameraTurnedOnTimer;
        }

        @Override
        public Timer getForegroundActivityTimer() {
            return this.mForegroundActivityTimer;
        }

        void makeProcessState(int i, Parcel in) {
            if (i < 0 || i >= 3) {
                return;
            }
            this.mProcessStateTimer[i] = in == null ? new StopwatchTimer(this, 12, null, BatteryStatsImpl.this.mOnBatteryTimeBase) : new StopwatchTimer(this, 12, null, BatteryStatsImpl.this.mOnBatteryTimeBase, in);
        }

        @Override
        public long getProcessStateTime(int state, long elapsedRealtimeUs, int which) {
            if (state < 0 || state >= 3) {
                return 0L;
            }
            if (this.mProcessStateTimer[state] == null) {
                return 0L;
            }
            return this.mProcessStateTimer[state].getTotalTimeLocked(elapsedRealtimeUs, which);
        }

        @Override
        public Timer getVibratorOnTimer() {
            return this.mVibratorOnTimer;
        }

        @Override
        public void noteUserActivityLocked(int type) {
            if (this.mUserActivityCounters == null) {
                this.initUserActivityLocked();
            }
            if (type >= 0 && type < 3) {
                this.mUserActivityCounters[type].stepAtomic();
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown user activity type " + type + " was specified.", new Throwable());
            }
        }

        @Override
        public boolean hasUserActivity() {
            return this.mUserActivityCounters != null;
        }

        @Override
        public int getUserActivityCount(int type, int which) {
            if (this.mUserActivityCounters == null) {
                return 0;
            }
            return this.mUserActivityCounters[type].getCountLocked(which);
        }

        void makeWifiBatchedScanBin(int i, Parcel in) {
            if (i < 0 || i >= 5) {
                return;
            }
            ArrayList<StopwatchTimer> collected = BatteryStatsImpl.this.mWifiBatchedScanTimers.get(i);
            if (collected == null) {
                collected = new ArrayList();
                BatteryStatsImpl.this.mWifiBatchedScanTimers.put(i, collected);
            }
            this.mWifiBatchedScanTimer[i] = in == null ? new StopwatchTimer(this, 11, collected, BatteryStatsImpl.this.mOnBatteryTimeBase) : new StopwatchTimer(this, 11, collected, BatteryStatsImpl.this.mOnBatteryTimeBase, in);
        }

        void initUserActivityLocked() {
            this.mUserActivityCounters = new Counter[3];
            for (int i = 0; i < 3; ++i) {
                this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
        }

        void noteNetworkActivityLocked(int type, long deltaBytes, long deltaPackets) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            if (type >= 0 && type < 4) {
                this.mNetworkByteActivityCounters[type].addCountLocked(deltaBytes);
                this.mNetworkPacketActivityCounters[type].addCountLocked(deltaPackets);
            } else {
                Slog.w(BatteryStatsImpl.TAG, "Unknown network activity type " + type + " was specified.", new Throwable());
            }
        }

        void noteMobileRadioActiveTimeLocked(long batteryUptime) {
            if (this.mNetworkByteActivityCounters == null) {
                this.initNetworkActivityLocked();
            }
            this.mMobileRadioActiveTime.addCountLocked(batteryUptime);
            this.mMobileRadioActiveCount.addCountLocked(1L);
        }

        @Override
        public boolean hasNetworkActivity() {
            return this.mNetworkByteActivityCounters != null;
        }

        @Override
        public long getNetworkActivityBytes(int type, int which) {
            if (this.mNetworkByteActivityCounters != null && type >= 0 && type < this.mNetworkByteActivityCounters.length) {
                return this.mNetworkByteActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getNetworkActivityPackets(int type, int which) {
            if (this.mNetworkPacketActivityCounters != null && type >= 0 && type < this.mNetworkPacketActivityCounters.length) {
                return this.mNetworkPacketActivityCounters[type].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getMobileRadioActiveTime(int which) {
            return this.mMobileRadioActiveTime != null ? this.mMobileRadioActiveTime.getCountLocked(which) : 0L;
        }

        @Override
        public int getMobileRadioActiveCount(int which) {
            return this.mMobileRadioActiveCount != null ? (int)this.mMobileRadioActiveCount.getCountLocked(which) : 0;
        }

        @Override
        public long getUserCpuTimeUs(int which) {
            return this.mUserCpuTime.getCountLocked(which);
        }

        @Override
        public long getSystemCpuTimeUs(int which) {
            return this.mSystemCpuTime.getCountLocked(which);
        }

        @Override
        public long getCpuPowerMaUs(int which) {
            return this.mCpuPower.getCountLocked(which);
        }

        @Override
        public long getTimeAtCpuSpeed(int step, int which) {
            if (step >= 0 && step < this.mSpeedBins.length && this.mSpeedBins[step] != null) {
                return this.mSpeedBins[step].getCountLocked(which);
            }
            return 0L;
        }

        @Override
        public long getWifiControllerActivity(int type, int which) {
            if (type >= 0 && type < 4 && this.mWifiControllerTime[type] != null) {
                return this.mWifiControllerTime[type].getCountLocked(which);
            }
            return 0L;
        }

        void initNetworkActivityLocked() {
            this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
            this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
            for (int i = 0; i < 4; ++i) {
                this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
                this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            }
            this.mMobileRadioActiveTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
            this.mMobileRadioActiveCount = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase);
        }

        boolean reset() {
            int i;
            boolean active = false;
            if (this.mWifiRunningTimer != null) {
                active |= !this.mWifiRunningTimer.reset(false);
                active |= this.mWifiRunning;
            }
            if (this.mFullWifiLockTimer != null) {
                active |= !this.mFullWifiLockTimer.reset(false);
                active |= this.mFullWifiLockOut;
            }
            if (this.mWifiScanTimer != null) {
                active |= !this.mWifiScanTimer.reset(false);
                active |= this.mWifiScanStarted;
            }
            if (this.mWifiBatchedScanTimer != null) {
                for (i = 0; i < 5; ++i) {
                    if (this.mWifiBatchedScanTimer[i] == null) continue;
                    active |= !this.mWifiBatchedScanTimer[i].reset(false);
                }
                active |= this.mWifiBatchedScanBinStarted != -1;
            }
            if (this.mWifiMulticastTimer != null) {
                active |= !this.mWifiMulticastTimer.reset(false);
                active |= this.mWifiMulticastEnabled;
            }
            if (this.mAudioTurnedOnTimer != null) {
                active |= !this.mAudioTurnedOnTimer.reset(false);
            }
            if (this.mVideoTurnedOnTimer != null) {
                active |= !this.mVideoTurnedOnTimer.reset(false);
            }
            if (this.mFlashlightTurnedOnTimer != null) {
                active |= !this.mFlashlightTurnedOnTimer.reset(false);
            }
            if (this.mCameraTurnedOnTimer != null) {
                active |= !this.mCameraTurnedOnTimer.reset(false);
            }
            if (this.mForegroundActivityTimer != null) {
                active |= !this.mForegroundActivityTimer.reset(false);
            }
            if (this.mProcessStateTimer != null) {
                for (i = 0; i < 3; ++i) {
                    if (this.mProcessStateTimer[i] == null) continue;
                    active |= !this.mProcessStateTimer[i].reset(false);
                }
                active |= this.mProcessState != 3;
            }
            if (this.mVibratorOnTimer != null) {
                if (this.mVibratorOnTimer.reset(false)) {
                    this.mVibratorOnTimer.detach();
                    this.mVibratorOnTimer = null;
                } else {
                    active = true;
                }
            }
            if (this.mUserActivityCounters != null) {
                for (i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i].reset(false);
                }
            }
            if (this.mNetworkByteActivityCounters != null) {
                for (i = 0; i < 4; ++i) {
                    this.mNetworkByteActivityCounters[i].reset(false);
                    this.mNetworkPacketActivityCounters[i].reset(false);
                }
                this.mMobileRadioActiveTime.reset(false);
                this.mMobileRadioActiveCount.reset(false);
            }
            for (i = 0; i < 4; ++i) {
                if (this.mWifiControllerTime[i] != null) {
                    this.mWifiControllerTime[i].reset(false);
                }
                if (this.mBluetoothControllerTime[i] == null) continue;
                this.mBluetoothControllerTime[i].reset(false);
            }
            this.mUserCpuTime.reset(false);
            this.mSystemCpuTime.reset(false);
            this.mCpuPower.reset(false);
            for (i = 0; i < this.mSpeedBins.length; ++i) {
                LongSamplingCounter c = this.mSpeedBins[i];
                if (c == null) continue;
                c.reset(false);
            }
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            for (int iw = wakeStats.size() - 1; iw >= 0; --iw) {
                Wakelock wl = wakeStats.valueAt(iw);
                if (wl.reset()) {
                    wakeStats.removeAt(iw);
                    continue;
                }
                active = true;
            }
            this.mWakelockStats.cleanup();
            ArrayMap<String, StopwatchTimer> syncStats = this.mSyncStats.getMap();
            for (int is = syncStats.size() - 1; is >= 0; --is) {
                StopwatchTimer timer = syncStats.valueAt(is);
                if (timer.reset(false)) {
                    syncStats.removeAt(is);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mSyncStats.cleanup();
            ArrayMap<String, StopwatchTimer> jobStats = this.mJobStats.getMap();
            for (int ij = jobStats.size() - 1; ij >= 0; --ij) {
                StopwatchTimer timer = jobStats.valueAt(ij);
                if (timer.reset(false)) {
                    jobStats.removeAt(ij);
                    timer.detach();
                    continue;
                }
                active = true;
            }
            this.mJobStats.cleanup();
            for (int ise = this.mSensorStats.size() - 1; ise >= 0; --ise) {
                Sensor s = this.mSensorStats.valueAt(ise);
                if (s.reset()) {
                    this.mSensorStats.removeAt(ise);
                    continue;
                }
                active = true;
            }
            for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                Proc proc = this.mProcessStats.valueAt(ip);
                if (proc.mProcessState == 3) {
                    proc.detach();
                    this.mProcessStats.removeAt(ip);
                    continue;
                }
                proc.reset();
                active = true;
            }
            if (this.mPids.size() > 0) {
                for (int i2 = this.mPids.size() - 1; i2 >= 0; --i2) {
                    BatteryStats.Uid.Pid pid = this.mPids.valueAt(i2);
                    if (pid.mWakeNesting > 0) {
                        active = true;
                        continue;
                    }
                    this.mPids.removeAt(i2);
                }
            }
            if (this.mPackageStats.size() > 0) {
                for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                    Pkg p = pkgEntry.getValue();
                    p.detach();
                    if (p.mServiceStats.size() <= 0) continue;
                    for (Map.Entry<String, Pkg.Serv> servEntry : p.mServiceStats.entrySet()) {
                        servEntry.getValue().detach();
                    }
                }
                this.mPackageStats.clear();
            }
            this.mLastStepSystemTime = 0L;
            this.mLastStepUserTime = 0L;
            this.mCurStepSystemTime = 0L;
            this.mCurStepUserTime = 0L;
            if (!active) {
                int i3;
                if (this.mWifiRunningTimer != null) {
                    this.mWifiRunningTimer.detach();
                }
                if (this.mFullWifiLockTimer != null) {
                    this.mFullWifiLockTimer.detach();
                }
                if (this.mWifiScanTimer != null) {
                    this.mWifiScanTimer.detach();
                }
                for (i3 = 0; i3 < 5; ++i3) {
                    if (this.mWifiBatchedScanTimer[i3] == null) continue;
                    this.mWifiBatchedScanTimer[i3].detach();
                }
                if (this.mWifiMulticastTimer != null) {
                    this.mWifiMulticastTimer.detach();
                }
                if (this.mAudioTurnedOnTimer != null) {
                    this.mAudioTurnedOnTimer.detach();
                    this.mAudioTurnedOnTimer = null;
                }
                if (this.mVideoTurnedOnTimer != null) {
                    this.mVideoTurnedOnTimer.detach();
                    this.mVideoTurnedOnTimer = null;
                }
                if (this.mFlashlightTurnedOnTimer != null) {
                    this.mFlashlightTurnedOnTimer.detach();
                    this.mFlashlightTurnedOnTimer = null;
                }
                if (this.mCameraTurnedOnTimer != null) {
                    this.mCameraTurnedOnTimer.detach();
                    this.mCameraTurnedOnTimer = null;
                }
                if (this.mForegroundActivityTimer != null) {
                    this.mForegroundActivityTimer.detach();
                    this.mForegroundActivityTimer = null;
                }
                if (this.mUserActivityCounters != null) {
                    for (i3 = 0; i3 < 3; ++i3) {
                        this.mUserActivityCounters[i3].detach();
                    }
                }
                if (this.mNetworkByteActivityCounters != null) {
                    for (i3 = 0; i3 < 4; ++i3) {
                        this.mNetworkByteActivityCounters[i3].detach();
                        this.mNetworkPacketActivityCounters[i3].detach();
                    }
                }
                for (i3 = 0; i3 < 4; ++i3) {
                    if (this.mWifiControllerTime[i3] != null) {
                        this.mWifiControllerTime[i3].detach();
                    }
                    if (this.mBluetoothControllerTime[i3] == null) continue;
                    this.mBluetoothControllerTime[i3].detach();
                }
                this.mPids.clear();
                this.mUserCpuTime.detach();
                this.mSystemCpuTime.detach();
                this.mCpuPower.detach();
                for (i3 = 0; i3 < this.mSpeedBins.length; ++i3) {
                    LongSamplingCounter c = this.mSpeedBins[i3];
                    if (c == null) continue;
                    c.detach();
                }
            }
            return !active;
        }

        void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
            int i;
            ArrayMap<String, Wakelock> wakeStats = this.mWakelockStats.getMap();
            int NW = wakeStats.size();
            out.writeInt(NW);
            for (int iw = 0; iw < NW; ++iw) {
                out.writeString(wakeStats.keyAt(iw));
                Wakelock wakelock = wakeStats.valueAt(iw);
                wakelock.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            ArrayMap<String, StopwatchTimer> syncStats = this.mSyncStats.getMap();
            int NS = syncStats.size();
            out.writeInt(NS);
            for (int is = 0; is < NS; ++is) {
                out.writeString(syncStats.keyAt(is));
                StopwatchTimer timer = syncStats.valueAt(is);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            ArrayMap<String, StopwatchTimer> jobStats = this.mJobStats.getMap();
            int NJ = jobStats.size();
            out.writeInt(NJ);
            for (int ij = 0; ij < NJ; ++ij) {
                out.writeString(jobStats.keyAt(ij));
                StopwatchTimer timer = jobStats.valueAt(ij);
                Timer.writeTimerToParcel(out, timer, elapsedRealtimeUs);
            }
            int NSE = this.mSensorStats.size();
            out.writeInt(NSE);
            for (int ise = 0; ise < NSE; ++ise) {
                out.writeInt(this.mSensorStats.keyAt(ise));
                Sensor sensor = this.mSensorStats.valueAt(ise);
                sensor.writeToParcelLocked(out, elapsedRealtimeUs);
            }
            int NP = this.mProcessStats.size();
            out.writeInt(NP);
            for (int ip = 0; ip < NP; ++ip) {
                out.writeString(this.mProcessStats.keyAt(ip));
                Proc proc = this.mProcessStats.valueAt(ip);
                proc.writeToParcelLocked(out);
            }
            out.writeInt(this.mPackageStats.size());
            for (Map.Entry<String, Pkg> pkgEntry : this.mPackageStats.entrySet()) {
                out.writeString(pkgEntry.getKey());
                Pkg pkg = pkgEntry.getValue();
                pkg.writeToParcelLocked(out);
            }
            if (this.mWifiRunningTimer != null) {
                out.writeInt(1);
                this.mWifiRunningTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFullWifiLockTimer != null) {
                out.writeInt(1);
                this.mFullWifiLockTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mWifiScanTimer != null) {
                out.writeInt(1);
                this.mWifiScanTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 5; ++i) {
                if (this.mWifiBatchedScanTimer[i] != null) {
                    out.writeInt(1);
                    this.mWifiBatchedScanTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mWifiMulticastTimer != null) {
                out.writeInt(1);
                this.mWifiMulticastTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mAudioTurnedOnTimer != null) {
                out.writeInt(1);
                this.mAudioTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mVideoTurnedOnTimer != null) {
                out.writeInt(1);
                this.mVideoTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mFlashlightTurnedOnTimer != null) {
                out.writeInt(1);
                this.mFlashlightTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mCameraTurnedOnTimer != null) {
                out.writeInt(1);
                this.mCameraTurnedOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mForegroundActivityTimer != null) {
                out.writeInt(1);
                this.mForegroundActivityTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 3; ++i) {
                if (this.mProcessStateTimer[i] != null) {
                    out.writeInt(1);
                    this.mProcessStateTimer[i].writeToParcel(out, elapsedRealtimeUs);
                    continue;
                }
                out.writeInt(0);
            }
            if (this.mVibratorOnTimer != null) {
                out.writeInt(1);
                this.mVibratorOnTimer.writeToParcel(out, elapsedRealtimeUs);
            } else {
                out.writeInt(0);
            }
            if (this.mUserActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i].writeToParcel(out);
                }
            } else {
                out.writeInt(0);
            }
            if (this.mNetworkByteActivityCounters != null) {
                out.writeInt(1);
                for (i = 0; i < 4; ++i) {
                    this.mNetworkByteActivityCounters[i].writeToParcel(out);
                    this.mNetworkPacketActivityCounters[i].writeToParcel(out);
                }
                this.mMobileRadioActiveTime.writeToParcel(out);
                this.mMobileRadioActiveCount.writeToParcel(out);
            } else {
                out.writeInt(0);
            }
            for (i = 0; i < 4; ++i) {
                if (this.mWifiControllerTime[i] != null) {
                    out.writeInt(1);
                    this.mWifiControllerTime[i].writeToParcel(out);
                    continue;
                }
                out.writeInt(0);
            }
            for (i = 0; i < 4; ++i) {
                if (this.mBluetoothControllerTime[i] != null) {
                    out.writeInt(1);
                    this.mBluetoothControllerTime[i].writeToParcel(out);
                    continue;
                }
                out.writeInt(0);
            }
            this.mUserCpuTime.writeToParcel(out);
            this.mSystemCpuTime.writeToParcel(out);
            this.mCpuPower.writeToParcel(out);
            out.writeInt(this.mSpeedBins.length);
            for (i = 0; i < this.mSpeedBins.length; ++i) {
                LongSamplingCounter c = this.mSpeedBins[i];
                if (c != null) {
                    out.writeInt(1);
                    c.writeToParcel(out);
                    continue;
                }
                out.writeInt(0);
            }
        }

        void readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, Parcel in) {
            int steps;
            int i;
            int numWakelocks = in.readInt();
            this.mWakelockStats.clear();
            for (int j = 0; j < numWakelocks; ++j) {
                String wakelockName = in.readString();
                Wakelock wakelock = new Wakelock();
                wakelock.readFromParcelLocked(timeBase, screenOffTimeBase, in);
                this.mWakelockStats.add(wakelockName, wakelock);
            }
            int numSyncs = in.readInt();
            this.mSyncStats.clear();
            for (int j = 0; j < numSyncs; ++j) {
                String syncName = in.readString();
                if (in.readInt() == 0) continue;
                this.mSyncStats.add(syncName, new StopwatchTimer(this, 13, null, timeBase, in));
            }
            int numJobs = in.readInt();
            this.mJobStats.clear();
            for (int j = 0; j < numJobs; ++j) {
                String jobName = in.readString();
                if (in.readInt() == 0) continue;
                this.mJobStats.add(jobName, new StopwatchTimer(this, 14, null, timeBase, in));
            }
            int numSensors = in.readInt();
            this.mSensorStats.clear();
            for (int k = 0; k < numSensors; ++k) {
                int sensorNumber = in.readInt();
                Sensor sensor = new Sensor(sensorNumber);
                sensor.readFromParcelLocked(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
                this.mSensorStats.put(sensorNumber, sensor);
            }
            int numProcs = in.readInt();
            this.mProcessStats.clear();
            for (int k = 0; k < numProcs; ++k) {
                String processName = in.readString();
                Proc proc = new Proc(processName);
                proc.readFromParcelLocked(in);
                this.mProcessStats.put(processName, proc);
            }
            int numPkgs = in.readInt();
            this.mPackageStats.clear();
            for (int l = 0; l < numPkgs; ++l) {
                String packageName = in.readString();
                Pkg pkg = new Pkg();
                pkg.readFromParcelLocked(in);
                this.mPackageStats.put(packageName, pkg);
            }
            this.mWifiRunning = false;
            this.mWifiRunningTimer = in.readInt() != 0 ? new StopwatchTimer(this, 4, BatteryStatsImpl.this.mWifiRunningTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mFullWifiLockOut = false;
            this.mFullWifiLockTimer = in.readInt() != 0 ? new StopwatchTimer(this, 5, BatteryStatsImpl.this.mFullWifiLockTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mWifiScanStarted = false;
            this.mWifiScanTimer = in.readInt() != 0 ? new StopwatchTimer(this, 6, BatteryStatsImpl.this.mWifiScanTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mWifiBatchedScanBinStarted = -1;
            for (i = 0; i < 5; ++i) {
                if (in.readInt() != 0) {
                    this.makeWifiBatchedScanBin(i, in);
                    continue;
                }
                this.mWifiBatchedScanTimer[i] = null;
            }
            this.mWifiMulticastEnabled = false;
            this.mWifiMulticastTimer = in.readInt() != 0 ? new StopwatchTimer(this, 7, BatteryStatsImpl.this.mWifiMulticastTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mAudioTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this, 15, BatteryStatsImpl.this.mAudioTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mVideoTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this, 8, BatteryStatsImpl.this.mVideoTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mFlashlightTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this, 16, BatteryStatsImpl.this.mFlashlightTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mCameraTurnedOnTimer = in.readInt() != 0 ? new StopwatchTimer(this, 17, BatteryStatsImpl.this.mCameraTurnedOnTimers, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mForegroundActivityTimer = in.readInt() != 0 ? new StopwatchTimer(this, 10, null, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            this.mProcessState = 3;
            for (i = 0; i < 3; ++i) {
                if (in.readInt() != 0) {
                    this.makeProcessState(i, in);
                    continue;
                }
                this.mProcessStateTimer[i] = null;
            }
            this.mVibratorOnTimer = in.readInt() != 0 ? new BatchTimer(this, 9, BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            if (in.readInt() != 0) {
                this.mUserActivityCounters = new Counter[3];
                for (i = 0; i < 3; ++i) {
                    this.mUserActivityCounters[i] = new Counter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
                }
            } else {
                this.mUserActivityCounters = null;
            }
            if (in.readInt() != 0) {
                this.mNetworkByteActivityCounters = new LongSamplingCounter[4];
                this.mNetworkPacketActivityCounters = new LongSamplingCounter[4];
                for (i = 0; i < 4; ++i) {
                    this.mNetworkByteActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
                    this.mNetworkPacketActivityCounters[i] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
                }
                this.mMobileRadioActiveTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
                this.mMobileRadioActiveCount = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
            } else {
                this.mNetworkByteActivityCounters = null;
                this.mNetworkPacketActivityCounters = null;
            }
            for (i = 0; i < 4; ++i) {
                this.mWifiControllerTime[i] = in.readInt() != 0 ? new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            }
            for (i = 0; i < 4; ++i) {
                this.mBluetoothControllerTime[i] = in.readInt() != 0 ? new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in) : null;
            }
            this.mUserCpuTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
            this.mSystemCpuTime = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
            this.mCpuPower = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
            int bins = in.readInt();
            this.mSpeedBins = new LongSamplingCounter[bins >= (steps = BatteryStatsImpl.this.getCpuSpeedSteps()) ? bins : steps];
            for (int i2 = 0; i2 < bins; ++i2) {
                if (in.readInt() == 0) continue;
                this.mSpeedBins[i2] = new LongSamplingCounter(BatteryStatsImpl.this.mOnBatteryTimeBase, in);
            }
        }

        public Proc getProcessStatsLocked(String name) {
            Proc ps = this.mProcessStats.get(name);
            if (ps == null) {
                ps = new Proc(name);
                this.mProcessStats.put(name, ps);
            }
            return ps;
        }

        public void updateProcessStateLocked(String procName, int state, long elapsedRealtimeMs) {
            int procState = state <= 6 ? 0 : (state <= 11 ? 1 : 2);
            this.updateRealProcessStateLocked(procName, procState, elapsedRealtimeMs);
        }

        public void updateRealProcessStateLocked(String procName, int procState, long elapsedRealtimeMs) {
            Proc proc = this.getProcessStatsLocked(procName);
            if (proc.mProcessState != procState) {
                boolean changed = procState < proc.mProcessState ? this.mProcessState > procState : this.mProcessState == proc.mProcessState;
                proc.mProcessState = procState;
                if (changed) {
                    int uidProcState = 3;
                    for (int ip = this.mProcessStats.size() - 1; ip >= 0; --ip) {
                        proc = this.mProcessStats.valueAt(ip);
                        if (proc.mProcessState >= uidProcState) continue;
                        uidProcState = proc.mProcessState;
                    }
                    this.updateUidProcessStateLocked(uidProcState, elapsedRealtimeMs);
                }
            }
        }

        @Override
        public SparseArray<? extends BatteryStats.Uid.Pid> getPidStats() {
            return this.mPids;
        }

        public BatteryStats.Uid.Pid getPidStatsLocked(int pid) {
            BatteryStats.Uid.Pid p = this.mPids.get(pid);
            if (p == null) {
                p = new BatteryStats.Uid.Pid(this);
                this.mPids.put(pid, p);
            }
            return p;
        }

        public Pkg getPackageStatsLocked(String name) {
            Pkg ps = this.mPackageStats.get(name);
            if (ps == null) {
                ps = new Pkg();
                this.mPackageStats.put(name, ps);
            }
            return ps;
        }

        public Pkg.Serv getServiceStatsLocked(String pkg, String serv) {
            Pkg ps = this.getPackageStatsLocked(pkg);
            Pkg.Serv ss = ps.mServiceStats.get(serv);
            if (ss == null) {
                ss = ps.newServiceStatsLocked();
                ps.mServiceStats.put(serv, ss);
            }
            return ss;
        }

        public void readSyncSummaryFromParcelLocked(String name, Parcel in) {
            StopwatchTimer timer = this.mSyncStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mSyncStats.add(name, timer);
        }

        public void readJobSummaryFromParcelLocked(String name, Parcel in) {
            StopwatchTimer timer = this.mJobStats.instantiateObject();
            timer.readSummaryFromParcelLocked(in);
            this.mJobStats.add(name, timer);
        }

        public void readWakeSummaryFromParcelLocked(String wlName, Parcel in) {
            Wakelock wl = new Wakelock();
            this.mWakelockStats.add(wlName, wl);
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(1).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(0).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(2).readSummaryFromParcelLocked(in);
            }
            if (in.readInt() != 0) {
                wl.getStopwatchTimer(18).readSummaryFromParcelLocked(in);
            }
        }

        public StopwatchTimer getSensorTimerLocked(int sensor, boolean create) {
            StopwatchTimer t;
            Sensor se = this.mSensorStats.get(sensor);
            if (se == null) {
                if (!create) {
                    return null;
                }
                se = new Sensor(sensor);
                this.mSensorStats.put(sensor, se);
            }
            if ((t = se.mTimer) != null) {
                return t;
            }
            ArrayList<StopwatchTimer> timers = BatteryStatsImpl.this.mSensorTimers.get(sensor);
            if (timers == null) {
                timers = new ArrayList();
                BatteryStatsImpl.this.mSensorTimers.put(sensor, timers);
            }
            se.mTimer = t = new StopwatchTimer(this, 3, timers, BatteryStatsImpl.this.mOnBatteryTimeBase);
            return t;
        }

        public void noteStartSyncLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mSyncStats.startObject(name);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopSyncLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mSyncStats.stopObject(name);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartJobLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mJobStats.startObject(name);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopJobLocked(String name, long elapsedRealtimeMs) {
            StopwatchTimer t = this.mJobStats.stopObject(name);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            Wakelock wl = this.mWakelockStats.startObject(name);
            if (wl != null) {
                wl.getStopwatchTimer(type).startRunningLocked(elapsedRealtimeMs);
            }
            if (pid >= 0 && type == 0) {
                BatteryStats.Uid.Pid p = this.getPidStatsLocked(pid);
                if (p.mWakeNesting++ == 0) {
                    p.mWakeStartMs = elapsedRealtimeMs;
                }
            }
        }

        public void noteStopWakeLocked(int pid, String name, int type, long elapsedRealtimeMs) {
            BatteryStats.Uid.Pid p;
            Wakelock wl = this.mWakelockStats.stopObject(name);
            if (wl != null) {
                wl.getStopwatchTimer(type).stopRunningLocked(elapsedRealtimeMs);
            }
            if (pid >= 0 && type == 0 && (p = this.mPids.get(pid)) != null && p.mWakeNesting > 0 && p.mWakeNesting-- == 1) {
                p.mWakeSumMs += elapsedRealtimeMs - p.mWakeStartMs;
                p.mWakeStartMs = 0L;
            }
        }

        public void reportExcessiveWakeLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveWake(overTime, usedTime);
            }
        }

        public void reportExcessiveCpuLocked(String proc, long overTime, long usedTime) {
            Proc p = this.getProcessStatsLocked(proc);
            if (p != null) {
                p.addExcessiveCpu(overTime, usedTime);
            }
        }

        public void noteStartSensor(int sensor, long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(sensor, true);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopSensor(int sensor, long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(sensor, false);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStartGps(long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(-10000, true);
            if (t != null) {
                t.startRunningLocked(elapsedRealtimeMs);
            }
        }

        public void noteStopGps(long elapsedRealtimeMs) {
            StopwatchTimer t = this.getSensorTimerLocked(-10000, false);
            if (t != null) {
                t.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        public BatteryStatsImpl getBatteryStats() {
            return BatteryStatsImpl.this;
        }

        public final class Pkg
        extends BatteryStats.Uid.Pkg
        implements TimeBaseObs {
            ArrayMap<String, Counter> mWakeupAlarms = new ArrayMap();
            final ArrayMap<String, Serv> mServiceStats = new ArrayMap();

            Pkg() {
                BatteryStatsImpl.this.mOnBatteryScreenOffTimeBase.add(this);
            }

            @Override
            public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            @Override
            public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            void detach() {
                BatteryStatsImpl.this.mOnBatteryScreenOffTimeBase.remove(this);
            }

            void readFromParcelLocked(Parcel in) {
                int numWA = in.readInt();
                this.mWakeupAlarms.clear();
                for (int i = 0; i < numWA; ++i) {
                    String tag = in.readString();
                    this.mWakeupAlarms.put(tag, new Counter(BatteryStatsImpl.this.mOnBatteryTimeBase, in));
                }
                int numServs = in.readInt();
                this.mServiceStats.clear();
                for (int m = 0; m < numServs; ++m) {
                    String serviceName = in.readString();
                    Serv serv = new Serv();
                    this.mServiceStats.put(serviceName, serv);
                    serv.readFromParcelLocked(in);
                }
            }

            void writeToParcelLocked(Parcel out) {
                int numWA = this.mWakeupAlarms.size();
                out.writeInt(numWA);
                for (int i = 0; i < numWA; ++i) {
                    out.writeString(this.mWakeupAlarms.keyAt(i));
                    this.mWakeupAlarms.valueAt(i).writeToParcel(out);
                }
                int NS = this.mServiceStats.size();
                out.writeInt(NS);
                for (int i = 0; i < NS; ++i) {
                    out.writeString(this.mServiceStats.keyAt(i));
                    Serv serv = this.mServiceStats.valueAt(i);
                    serv.writeToParcelLocked(out);
                }
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Counter> getWakeupAlarmStats() {
                return this.mWakeupAlarms;
            }

            public void noteWakeupAlarmLocked(String tag) {
                Counter c = this.mWakeupAlarms.get(tag);
                if (c == null) {
                    c = new Counter(BatteryStatsImpl.this.mOnBatteryTimeBase);
                    this.mWakeupAlarms.put(tag, c);
                }
                c.stepAtomic();
            }

            @Override
            public ArrayMap<String, ? extends BatteryStats.Uid.Pkg.Serv> getServiceStats() {
                return this.mServiceStats;
            }

            final Serv newServiceStatsLocked() {
                return new Serv();
            }

            public final class Serv
            extends BatteryStats.Uid.Pkg.Serv
            implements TimeBaseObs {
                long mStartTime;
                long mRunningSince;
                boolean mRunning;
                int mStarts;
                long mLaunchedTime;
                long mLaunchedSince;
                boolean mLaunched;
                int mLaunches;
                long mLoadedStartTime;
                int mLoadedStarts;
                int mLoadedLaunches;
                long mLastStartTime;
                int mLastStarts;
                int mLastLaunches;
                long mUnpluggedStartTime;
                int mUnpluggedStarts;
                int mUnpluggedLaunches;

                Serv() {
                    super(Pkg.this);
                    BatteryStatsImpl.this.mOnBatteryTimeBase.add(this);
                }

                @Override
                public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
                    this.mUnpluggedStartTime = this.getStartTimeToNowLocked(baseUptime);
                    this.mUnpluggedStarts = this.mStarts;
                    this.mUnpluggedLaunches = this.mLaunches;
                }

                @Override
                public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
                }

                void detach() {
                    BatteryStatsImpl.this.mOnBatteryTimeBase.remove(this);
                }

                void readFromParcelLocked(Parcel in) {
                    this.mStartTime = in.readLong();
                    this.mRunningSince = in.readLong();
                    this.mRunning = in.readInt() != 0;
                    this.mStarts = in.readInt();
                    this.mLaunchedTime = in.readLong();
                    this.mLaunchedSince = in.readLong();
                    this.mLaunched = in.readInt() != 0;
                    this.mLaunches = in.readInt();
                    this.mLoadedStartTime = in.readLong();
                    this.mLoadedStarts = in.readInt();
                    this.mLoadedLaunches = in.readInt();
                    this.mLastStartTime = 0L;
                    this.mLastStarts = 0;
                    this.mLastLaunches = 0;
                    this.mUnpluggedStartTime = in.readLong();
                    this.mUnpluggedStarts = in.readInt();
                    this.mUnpluggedLaunches = in.readInt();
                }

                void writeToParcelLocked(Parcel out) {
                    out.writeLong(this.mStartTime);
                    out.writeLong(this.mRunningSince);
                    out.writeInt(this.mRunning ? 1 : 0);
                    out.writeInt(this.mStarts);
                    out.writeLong(this.mLaunchedTime);
                    out.writeLong(this.mLaunchedSince);
                    out.writeInt(this.mLaunched ? 1 : 0);
                    out.writeInt(this.mLaunches);
                    out.writeLong(this.mLoadedStartTime);
                    out.writeInt(this.mLoadedStarts);
                    out.writeInt(this.mLoadedLaunches);
                    out.writeLong(this.mUnpluggedStartTime);
                    out.writeInt(this.mUnpluggedStarts);
                    out.writeInt(this.mUnpluggedLaunches);
                }

                long getLaunchTimeToNowLocked(long batteryUptime) {
                    if (!this.mLaunched) {
                        return this.mLaunchedTime;
                    }
                    return this.mLaunchedTime + batteryUptime - this.mLaunchedSince;
                }

                long getStartTimeToNowLocked(long batteryUptime) {
                    if (!this.mRunning) {
                        return this.mStartTime;
                    }
                    return this.mStartTime + batteryUptime - this.mRunningSince;
                }

                public void startLaunchedLocked() {
                    if (!this.mLaunched) {
                        ++this.mLaunches;
                        this.mLaunchedSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mLaunched = true;
                    }
                }

                public void stopLaunchedLocked() {
                    if (this.mLaunched) {
                        long time = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mLaunchedSince;
                        if (time > 0L) {
                            this.mLaunchedTime += time;
                        } else {
                            --this.mLaunches;
                        }
                        this.mLaunched = false;
                    }
                }

                public void startRunningLocked() {
                    if (!this.mRunning) {
                        ++this.mStarts;
                        this.mRunningSince = BatteryStatsImpl.this.getBatteryUptimeLocked();
                        this.mRunning = true;
                    }
                }

                public void stopRunningLocked() {
                    if (this.mRunning) {
                        long time = BatteryStatsImpl.this.getBatteryUptimeLocked() - this.mRunningSince;
                        if (time > 0L) {
                            this.mStartTime += time;
                        } else {
                            --this.mStarts;
                        }
                        this.mRunning = false;
                    }
                }

                public BatteryStatsImpl getBatteryStats() {
                    return BatteryStatsImpl.this;
                }

                @Override
                public int getLaunches(int which) {
                    int val = this.mLaunches;
                    if (which == 1) {
                        val -= this.mLoadedLaunches;
                    } else if (which == 2) {
                        val -= this.mUnpluggedLaunches;
                    }
                    return val;
                }

                @Override
                public long getStartTime(long now, int which) {
                    long val = this.getStartTimeToNowLocked(now);
                    if (which == 1) {
                        val -= this.mLoadedStartTime;
                    } else if (which == 2) {
                        val -= this.mUnpluggedStartTime;
                    }
                    return val;
                }

                @Override
                public int getStarts(int which) {
                    int val = this.mStarts;
                    if (which == 1) {
                        val -= this.mLoadedStarts;
                    } else if (which == 2) {
                        val -= this.mUnpluggedStarts;
                    }
                    return val;
                }
            }
        }

        public final class Proc
        extends BatteryStats.Uid.Proc
        implements TimeBaseObs {
            final String mName;
            boolean mActive = true;
            long mUserTime;
            long mSystemTime;
            long mForegroundTime;
            int mStarts;
            int mNumCrashes;
            int mNumAnrs;
            long mLoadedUserTime;
            long mLoadedSystemTime;
            long mLoadedForegroundTime;
            int mLoadedStarts;
            int mLoadedNumCrashes;
            int mLoadedNumAnrs;
            long mUnpluggedUserTime;
            long mUnpluggedSystemTime;
            long mUnpluggedForegroundTime;
            int mUnpluggedStarts;
            int mUnpluggedNumCrashes;
            int mUnpluggedNumAnrs;
            int mProcessState = 3;
            ArrayList<BatteryStats.Uid.Proc.ExcessivePower> mExcessivePower;

            Proc(String name) {
                this.mName = name;
                BatteryStatsImpl.this.mOnBatteryTimeBase.add(this);
            }

            @Override
            public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
                this.mUnpluggedUserTime = this.mUserTime;
                this.mUnpluggedSystemTime = this.mSystemTime;
                this.mUnpluggedForegroundTime = this.mForegroundTime;
                this.mUnpluggedStarts = this.mStarts;
                this.mUnpluggedNumCrashes = this.mNumCrashes;
                this.mUnpluggedNumAnrs = this.mNumAnrs;
            }

            @Override
            public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            }

            void reset() {
                this.mForegroundTime = 0L;
                this.mSystemTime = 0L;
                this.mUserTime = 0L;
                this.mNumAnrs = 0;
                this.mNumCrashes = 0;
                this.mStarts = 0;
                this.mLoadedForegroundTime = 0L;
                this.mLoadedSystemTime = 0L;
                this.mLoadedUserTime = 0L;
                this.mLoadedNumAnrs = 0;
                this.mLoadedNumCrashes = 0;
                this.mLoadedStarts = 0;
                this.mUnpluggedForegroundTime = 0L;
                this.mUnpluggedSystemTime = 0L;
                this.mUnpluggedUserTime = 0L;
                this.mUnpluggedNumAnrs = 0;
                this.mUnpluggedNumCrashes = 0;
                this.mUnpluggedStarts = 0;
                this.mExcessivePower = null;
            }

            void detach() {
                this.mActive = false;
                BatteryStatsImpl.this.mOnBatteryTimeBase.remove(this);
            }

            @Override
            public int countExcessivePowers() {
                return this.mExcessivePower != null ? this.mExcessivePower.size() : 0;
            }

            @Override
            public BatteryStats.Uid.Proc.ExcessivePower getExcessivePower(int i) {
                if (this.mExcessivePower != null) {
                    return this.mExcessivePower.get(i);
                }
                return null;
            }

            public void addExcessiveWake(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 1;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            public void addExcessiveCpu(long overTime, long usedTime) {
                if (this.mExcessivePower == null) {
                    this.mExcessivePower = new ArrayList();
                }
                BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                ew.type = 2;
                ew.overTime = overTime;
                ew.usedTime = usedTime;
                this.mExcessivePower.add(ew);
            }

            void writeExcessivePowerToParcelLocked(Parcel out) {
                if (this.mExcessivePower == null) {
                    out.writeInt(0);
                    return;
                }
                int N = this.mExcessivePower.size();
                out.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = this.mExcessivePower.get(i);
                    out.writeInt(ew.type);
                    out.writeLong(ew.overTime);
                    out.writeLong(ew.usedTime);
                }
            }

            void readExcessivePowerFromParcelLocked(Parcel in) {
                int N = in.readInt();
                if (N == 0) {
                    this.mExcessivePower = null;
                    return;
                }
                if (N > 10000) {
                    throw new ParcelFormatException("File corrupt: too many excessive power entries " + N);
                }
                this.mExcessivePower = new ArrayList();
                for (int i = 0; i < N; ++i) {
                    BatteryStats.Uid.Proc.ExcessivePower ew = new BatteryStats.Uid.Proc.ExcessivePower();
                    ew.type = in.readInt();
                    ew.overTime = in.readLong();
                    ew.usedTime = in.readLong();
                    this.mExcessivePower.add(ew);
                }
            }

            void writeToParcelLocked(Parcel out) {
                out.writeLong(this.mUserTime);
                out.writeLong(this.mSystemTime);
                out.writeLong(this.mForegroundTime);
                out.writeInt(this.mStarts);
                out.writeInt(this.mNumCrashes);
                out.writeInt(this.mNumAnrs);
                out.writeLong(this.mLoadedUserTime);
                out.writeLong(this.mLoadedSystemTime);
                out.writeLong(this.mLoadedForegroundTime);
                out.writeInt(this.mLoadedStarts);
                out.writeInt(this.mLoadedNumCrashes);
                out.writeInt(this.mLoadedNumAnrs);
                out.writeLong(this.mUnpluggedUserTime);
                out.writeLong(this.mUnpluggedSystemTime);
                out.writeLong(this.mUnpluggedForegroundTime);
                out.writeInt(this.mUnpluggedStarts);
                out.writeInt(this.mUnpluggedNumCrashes);
                out.writeInt(this.mUnpluggedNumAnrs);
                this.writeExcessivePowerToParcelLocked(out);
            }

            void readFromParcelLocked(Parcel in) {
                this.mUserTime = in.readLong();
                this.mSystemTime = in.readLong();
                this.mForegroundTime = in.readLong();
                this.mStarts = in.readInt();
                this.mNumCrashes = in.readInt();
                this.mNumAnrs = in.readInt();
                this.mLoadedUserTime = in.readLong();
                this.mLoadedSystemTime = in.readLong();
                this.mLoadedForegroundTime = in.readLong();
                this.mLoadedStarts = in.readInt();
                this.mLoadedNumCrashes = in.readInt();
                this.mLoadedNumAnrs = in.readInt();
                this.mUnpluggedUserTime = in.readLong();
                this.mUnpluggedSystemTime = in.readLong();
                this.mUnpluggedForegroundTime = in.readLong();
                this.mUnpluggedStarts = in.readInt();
                this.mUnpluggedNumCrashes = in.readInt();
                this.mUnpluggedNumAnrs = in.readInt();
                this.readExcessivePowerFromParcelLocked(in);
            }

            public void addCpuTimeLocked(int utime, int stime) {
                this.mUserTime += (long)utime;
                this.mSystemTime += (long)stime;
            }

            public void addForegroundTimeLocked(long ttime) {
                this.mForegroundTime += ttime;
            }

            public void incStartsLocked() {
                ++this.mStarts;
            }

            public void incNumCrashesLocked() {
                ++this.mNumCrashes;
            }

            public void incNumAnrsLocked() {
                ++this.mNumAnrs;
            }

            @Override
            public boolean isActive() {
                return this.mActive;
            }

            @Override
            public long getUserTime(int which) {
                long val = this.mUserTime;
                if (which == 1) {
                    val -= this.mLoadedUserTime;
                } else if (which == 2) {
                    val -= this.mUnpluggedUserTime;
                }
                return val;
            }

            @Override
            public long getSystemTime(int which) {
                long val = this.mSystemTime;
                if (which == 1) {
                    val -= this.mLoadedSystemTime;
                } else if (which == 2) {
                    val -= this.mUnpluggedSystemTime;
                }
                return val;
            }

            @Override
            public long getForegroundTime(int which) {
                long val = this.mForegroundTime;
                if (which == 1) {
                    val -= this.mLoadedForegroundTime;
                } else if (which == 2) {
                    val -= this.mUnpluggedForegroundTime;
                }
                return val;
            }

            @Override
            public int getStarts(int which) {
                int val = this.mStarts;
                if (which == 1) {
                    val -= this.mLoadedStarts;
                } else if (which == 2) {
                    val -= this.mUnpluggedStarts;
                }
                return val;
            }

            @Override
            public int getNumCrashes(int which) {
                int val = this.mNumCrashes;
                if (which == 1) {
                    val -= this.mLoadedNumCrashes;
                } else if (which == 2) {
                    val -= this.mUnpluggedNumCrashes;
                }
                return val;
            }

            @Override
            public int getNumAnrs(int which) {
                int val = this.mNumAnrs;
                if (which == 1) {
                    val -= this.mLoadedNumAnrs;
                } else if (which == 2) {
                    val -= this.mUnpluggedNumAnrs;
                }
                return val;
            }
        }

        public final class Sensor
        extends BatteryStats.Uid.Sensor {
            final int mHandle;
            StopwatchTimer mTimer;

            public Sensor(int handle) {
                this.mHandle = handle;
            }

            private StopwatchTimer readTimerFromParcel(TimeBase timeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                ArrayList<StopwatchTimer> pool = BatteryStatsImpl.this.mSensorTimers.get(this.mHandle);
                if (pool == null) {
                    pool = new ArrayList();
                    BatteryStatsImpl.this.mSensorTimers.put(this.mHandle, pool);
                }
                return new StopwatchTimer(Uid.this, 0, pool, timeBase, in);
            }

            boolean reset() {
                if (this.mTimer.reset(true)) {
                    this.mTimer = null;
                    return true;
                }
                return false;
            }

            void readFromParcelLocked(TimeBase timeBase, Parcel in) {
                this.mTimer = this.readTimerFromParcel(timeBase, in);
            }

            void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimer, elapsedRealtimeUs);
            }

            @Override
            public Timer getSensorTime() {
                return this.mTimer;
            }

            @Override
            public int getHandle() {
                return this.mHandle;
            }
        }

        public final class Wakelock
        extends BatteryStats.Uid.Wakelock {
            StopwatchTimer mTimerPartial;
            StopwatchTimer mTimerFull;
            StopwatchTimer mTimerWindow;
            StopwatchTimer mTimerDraw;

            private StopwatchTimer readTimerFromParcel(int type, ArrayList<StopwatchTimer> pool, TimeBase timeBase, Parcel in) {
                if (in.readInt() == 0) {
                    return null;
                }
                return new StopwatchTimer(Uid.this, type, pool, timeBase, in);
            }

            boolean reset() {
                boolean wlactive = false;
                if (this.mTimerFull != null) {
                    wlactive |= !this.mTimerFull.reset(false);
                }
                if (this.mTimerPartial != null) {
                    wlactive |= !this.mTimerPartial.reset(false);
                }
                if (this.mTimerWindow != null) {
                    wlactive |= !this.mTimerWindow.reset(false);
                }
                if (this.mTimerDraw != null) {
                    wlactive |= !this.mTimerDraw.reset(false);
                }
                if (!wlactive) {
                    if (this.mTimerFull != null) {
                        this.mTimerFull.detach();
                        this.mTimerFull = null;
                    }
                    if (this.mTimerPartial != null) {
                        this.mTimerPartial.detach();
                        this.mTimerPartial = null;
                    }
                    if (this.mTimerWindow != null) {
                        this.mTimerWindow.detach();
                        this.mTimerWindow = null;
                    }
                    if (this.mTimerDraw != null) {
                        this.mTimerDraw.detach();
                        this.mTimerDraw = null;
                    }
                }
                return !wlactive;
            }

            void readFromParcelLocked(TimeBase timeBase, TimeBase screenOffTimeBase, Parcel in) {
                this.mTimerPartial = this.readTimerFromParcel(0, BatteryStatsImpl.this.mPartialTimers, screenOffTimeBase, in);
                this.mTimerFull = this.readTimerFromParcel(1, BatteryStatsImpl.this.mFullTimers, timeBase, in);
                this.mTimerWindow = this.readTimerFromParcel(2, BatteryStatsImpl.this.mWindowTimers, timeBase, in);
                this.mTimerDraw = this.readTimerFromParcel(18, BatteryStatsImpl.this.mDrawTimers, timeBase, in);
            }

            void writeToParcelLocked(Parcel out, long elapsedRealtimeUs) {
                Timer.writeTimerToParcel(out, this.mTimerPartial, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerFull, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerWindow, elapsedRealtimeUs);
                Timer.writeTimerToParcel(out, this.mTimerDraw, elapsedRealtimeUs);
            }

            @Override
            public Timer getWakeTime(int type) {
                switch (type) {
                    case 1: {
                        return this.mTimerFull;
                    }
                    case 0: {
                        return this.mTimerPartial;
                    }
                    case 2: {
                        return this.mTimerWindow;
                    }
                    case 18: {
                        return this.mTimerDraw;
                    }
                }
                throw new IllegalArgumentException("type = " + type);
            }

            public StopwatchTimer getStopwatchTimer(int type) {
                switch (type) {
                    case 0: {
                        StopwatchTimer t = this.mTimerPartial;
                        if (t == null) {
                            this.mTimerPartial = t = new StopwatchTimer(Uid.this, 0, BatteryStatsImpl.this.mPartialTimers, BatteryStatsImpl.this.mOnBatteryScreenOffTimeBase);
                        }
                        return t;
                    }
                    case 1: {
                        StopwatchTimer t = this.mTimerFull;
                        if (t == null) {
                            this.mTimerFull = t = new StopwatchTimer(Uid.this, 1, BatteryStatsImpl.this.mFullTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                        }
                        return t;
                    }
                    case 2: {
                        StopwatchTimer t = this.mTimerWindow;
                        if (t == null) {
                            this.mTimerWindow = t = new StopwatchTimer(Uid.this, 2, BatteryStatsImpl.this.mWindowTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                        }
                        return t;
                    }
                    case 18: {
                        StopwatchTimer t = this.mTimerDraw;
                        if (t == null) {
                            this.mTimerDraw = t = new StopwatchTimer(Uid.this, 18, BatteryStatsImpl.this.mDrawTimers, BatteryStatsImpl.this.mOnBatteryTimeBase);
                        }
                        return t;
                    }
                }
                throw new IllegalArgumentException("type=" + type);
            }
        }
    }

    public abstract class OverflowArrayMap<T> {
        private static final String OVERFLOW_NAME = "*overflow*";
        final ArrayMap<String, T> mMap = new ArrayMap();
        T mCurOverflow;
        ArrayMap<String, MutableInt> mActiveOverflow;

        public ArrayMap<String, T> getMap() {
            return this.mMap;
        }

        public void clear() {
            this.mMap.clear();
            this.mCurOverflow = null;
            this.mActiveOverflow = null;
        }

        public void add(String name, T obj) {
            this.mMap.put(name, obj);
            if (OVERFLOW_NAME.equals(name)) {
                this.mCurOverflow = obj;
            }
        }

        public void cleanup() {
            if (this.mActiveOverflow != null && this.mActiveOverflow.size() == 0) {
                this.mActiveOverflow = null;
            }
            if (this.mActiveOverflow == null) {
                if (this.mMap.containsKey(OVERFLOW_NAME)) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with no active overflow, but have overflow entry " + this.mMap.get(OVERFLOW_NAME));
                    this.mMap.remove(OVERFLOW_NAME);
                }
                this.mCurOverflow = null;
            } else if (this.mCurOverflow == null || !this.mMap.containsKey(OVERFLOW_NAME)) {
                Slog.wtf(BatteryStatsImpl.TAG, "Cleaning up with active overflow, but no overflow entry: cur=" + this.mCurOverflow + " map=" + this.mMap.get(OVERFLOW_NAME));
            }
        }

        public T startObject(String name) {
            MutableInt over;
            T obj = this.mMap.get(name);
            if (obj != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    Slog.wtf(BatteryStatsImpl.TAG, "Have active overflow " + name + " but null overflow");
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put(OVERFLOW_NAME, obj);
                }
                ++over.value;
                return obj;
            }
            int N = this.mMap.size();
            if (N >= 100) {
                obj = this.mCurOverflow;
                if (obj == null) {
                    this.mCurOverflow = this.instantiateObject();
                    obj = this.mCurOverflow;
                    this.mMap.put(OVERFLOW_NAME, obj);
                }
                if (this.mActiveOverflow == null) {
                    this.mActiveOverflow = new ArrayMap();
                }
                this.mActiveOverflow.put(name, new MutableInt(1));
                return obj;
            }
            obj = this.instantiateObject();
            this.mMap.put(name, obj);
            return obj;
        }

        public T stopObject(String name) {
            MutableInt over;
            T obj = this.mMap.get(name);
            if (obj != null) {
                return obj;
            }
            if (this.mActiveOverflow != null && (over = this.mActiveOverflow.get(name)) != null && (obj = this.mCurOverflow) != null) {
                --over.value;
                if (over.value <= 0) {
                    this.mActiveOverflow.remove(name);
                }
                return obj;
            }
            Slog.wtf(BatteryStatsImpl.TAG, "Unable to find object for " + name + " mapsize=" + this.mMap.size() + " activeoverflow=" + this.mActiveOverflow + " curoverflow=" + this.mCurOverflow);
            return null;
        }

        public abstract T instantiateObject();
    }

    public static final class StopwatchTimer
    extends Timer {
        final Uid mUid;
        final ArrayList<StopwatchTimer> mTimerPool;
        int mNesting;
        long mUpdateTime;
        long mAcquireTime;
        long mTimeout;
        boolean mInList;

        StopwatchTimer(Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase, Parcel in) {
            super(type, timeBase, in);
            this.mUid = uid;
            this.mTimerPool = timerPool;
            this.mUpdateTime = in.readLong();
        }

        StopwatchTimer(Uid uid, int type, ArrayList<StopwatchTimer> timerPool, TimeBase timeBase) {
            super(type, timeBase);
            this.mUid = uid;
            this.mTimerPool = timerPool;
        }

        void setTimeout(long timeout) {
            this.mTimeout = timeout;
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mUpdateTime);
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            if (this.mNesting > 0) {
                super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
                this.mUpdateTime = baseRealtime;
            }
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mNesting=" + this.mNesting + " mUpdateTime=" + this.mUpdateTime + " mAcquireTime=" + this.mAcquireTime);
        }

        void startRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting++ == 0) {
                long batteryRealtime;
                this.mUpdateTime = batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, null);
                    this.mTimerPool.add(this);
                }
                ++this.mCount;
                this.mAcquireTime = this.mTotalTime;
            }
        }

        boolean isRunningLocked() {
            return this.mNesting > 0;
        }

        void stopRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting == 0) {
                return;
            }
            if (--this.mNesting == 0) {
                long batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, null);
                    this.mTimerPool.remove(this);
                } else {
                    this.mNesting = 1;
                    this.mTotalTime = this.computeRunTimeLocked(batteryRealtime);
                    this.mNesting = 0;
                }
                if (this.mTotalTime == this.mAcquireTime) {
                    --this.mCount;
                }
            }
        }

        void stopAllRunningLocked(long elapsedRealtimeMs) {
            if (this.mNesting > 0) {
                this.mNesting = 1;
                this.stopRunningLocked(elapsedRealtimeMs);
            }
        }

        private static long refreshTimersLocked(long batteryRealtime, ArrayList<StopwatchTimer> pool, StopwatchTimer self) {
            long selfTime = 0L;
            int N = pool.size();
            for (int i = N - 1; i >= 0; --i) {
                StopwatchTimer t = pool.get(i);
                long heldTime = batteryRealtime - t.mUpdateTime;
                if (heldTime > 0L) {
                    long myTime = heldTime / (long)N;
                    if (t == self) {
                        selfTime = myTime;
                    }
                    t.mTotalTime += myTime;
                }
                t.mUpdateTime = batteryRealtime;
            }
            return selfTime;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            if (this.mTimeout > 0L && curBatteryRealtime > this.mUpdateTime + this.mTimeout) {
                curBatteryRealtime = this.mUpdateTime + this.mTimeout;
            }
            return this.mTotalTime + (this.mNesting > 0 ? (curBatteryRealtime - this.mUpdateTime) / (long)(this.mTimerPool != null ? this.mTimerPool.size() : 1) : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        boolean reset(boolean detachIfReset) {
            boolean canDetach = this.mNesting <= 0;
            super.reset(canDetach && detachIfReset);
            if (this.mNesting > 0) {
                this.mUpdateTime = this.mTimeBase.getRealtime(SystemClock.elapsedRealtime() * 1000L);
            }
            this.mAcquireTime = this.mTotalTime;
            return canDetach;
        }

        @Override
        void detach() {
            super.detach();
            if (this.mTimerPool != null) {
                this.mTimerPool.remove(this);
            }
        }

        @Override
        void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mNesting = 0;
        }

        public void setMark(long elapsedRealtimeMs) {
            long batteryRealtime = this.mTimeBase.getRealtime(elapsedRealtimeMs * 1000L);
            if (this.mNesting > 0) {
                if (this.mTimerPool != null) {
                    StopwatchTimer.refreshTimersLocked(batteryRealtime, this.mTimerPool, this);
                } else {
                    this.mTotalTime += batteryRealtime - this.mUpdateTime;
                    this.mUpdateTime = batteryRealtime;
                }
            }
            this.mTimeBeforeMark = this.mTotalTime;
        }
    }

    public static final class BatchTimer
    extends Timer {
        final Uid mUid;
        long mLastAddedTime;
        long mLastAddedDuration;
        boolean mInDischarge;

        BatchTimer(Uid uid, int type, TimeBase timeBase, Parcel in) {
            super(type, timeBase, in);
            this.mUid = uid;
            this.mLastAddedTime = in.readLong();
            this.mLastAddedDuration = in.readLong();
            this.mInDischarge = timeBase.isRunning();
        }

        BatchTimer(Uid uid, int type, TimeBase timeBase) {
            super(type, timeBase);
            this.mUid = uid;
            this.mInDischarge = timeBase.isRunning();
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeLong(this.mLastAddedTime);
            out.writeLong(this.mLastAddedDuration);
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.recomputeLastDuration(SystemClock.elapsedRealtime() * 1000L, false);
            this.mInDischarge = false;
            super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.recomputeLastDuration(elapsedRealtime, false);
            this.mInDischarge = true;
            if (this.mLastAddedTime == elapsedRealtime) {
                this.mTotalTime += this.mLastAddedDuration;
            }
            super.onTimeStarted(elapsedRealtime, baseUptime, baseRealtime);
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mLastAddedTime=" + this.mLastAddedTime + " mLastAddedDuration=" + this.mLastAddedDuration);
        }

        private long computeOverage(long curTime) {
            if (this.mLastAddedTime > 0L) {
                return this.mLastTime + this.mLastAddedDuration - curTime;
            }
            return 0L;
        }

        private void recomputeLastDuration(long curTime, boolean abort) {
            long overage = this.computeOverage(curTime);
            if (overage > 0L) {
                if (this.mInDischarge) {
                    this.mTotalTime -= overage;
                }
                if (abort) {
                    this.mLastAddedTime = 0L;
                } else {
                    this.mLastAddedTime = curTime;
                    this.mLastAddedDuration -= overage;
                }
            }
        }

        public void addDuration(BatteryStatsImpl stats, long durationMillis) {
            long now = SystemClock.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            this.mLastAddedTime = now;
            this.mLastAddedDuration = durationMillis * 1000L;
            if (this.mInDischarge) {
                this.mTotalTime += this.mLastAddedDuration;
                ++this.mCount;
            }
        }

        public void abortLastDuration(BatteryStatsImpl stats) {
            long now = SystemClock.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount;
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            long overage = this.computeOverage(SystemClock.elapsedRealtime() * 1000L);
            if (overage > 0L) {
                this.mTotalTime = overage;
                return this.mTotalTime;
            }
            return this.mTotalTime;
        }

        @Override
        boolean reset(boolean detachIfReset) {
            long now = SystemClock.elapsedRealtime() * 1000L;
            this.recomputeLastDuration(now, true);
            boolean stillActive = this.mLastAddedTime == now;
            super.reset(!stillActive && detachIfReset);
            return !stillActive;
        }
    }

    public static final class SamplingTimer
    extends Timer {
        int mCurrentReportedCount;
        int mUnpluggedReportedCount;
        long mCurrentReportedTotalTime;
        long mUnpluggedReportedTotalTime;
        boolean mTimeBaseRunning;
        boolean mTrackingReportedValues;
        int mUpdateVersion;

        SamplingTimer(TimeBase timeBase, Parcel in) {
            super(0, timeBase, in);
            this.mCurrentReportedCount = in.readInt();
            this.mUnpluggedReportedCount = in.readInt();
            this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedTotalTime = in.readLong();
            this.mTrackingReportedValues = in.readInt() == 1;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        SamplingTimer(TimeBase timeBase, boolean trackReportedValues) {
            super(0, timeBase);
            this.mTrackingReportedValues = trackReportedValues;
            this.mTimeBaseRunning = timeBase.isRunning();
        }

        public void setStale() {
            this.mTrackingReportedValues = false;
            this.mUnpluggedReportedTotalTime = 0L;
            this.mUnpluggedReportedCount = 0;
        }

        public void setUpdateVersion(int version) {
            this.mUpdateVersion = version;
        }

        public int getUpdateVersion() {
            return this.mUpdateVersion;
        }

        public void updateCurrentReportedCount(int count) {
            if (this.mTimeBaseRunning && this.mUnpluggedReportedCount == 0) {
                this.mUnpluggedReportedCount = count;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedCount = count;
        }

        public void addCurrentReportedCount(int delta) {
            this.updateCurrentReportedCount(this.mCurrentReportedCount + delta);
        }

        public void updateCurrentReportedTotalTime(long totalTime) {
            if (this.mTimeBaseRunning && this.mUnpluggedReportedTotalTime == 0L) {
                this.mUnpluggedReportedTotalTime = totalTime;
                this.mTrackingReportedValues = true;
            }
            this.mCurrentReportedTotalTime = totalTime;
        }

        public void addCurrentReportedTotalTime(long delta) {
            this.updateCurrentReportedTotalTime(this.mCurrentReportedTotalTime + delta);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            super.onTimeStarted(elapsedRealtime, baseUptime, baseRealtime);
            if (this.mTrackingReportedValues) {
                this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime;
                this.mUnpluggedReportedCount = this.mCurrentReportedCount;
            }
            this.mTimeBaseRunning = true;
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            super.onTimeStopped(elapsedRealtime, baseUptime, baseRealtime);
            this.mTimeBaseRunning = false;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            super.logState(pw, prefix);
            pw.println(prefix + "mCurrentReportedCount=" + this.mCurrentReportedCount + " mUnpluggedReportedCount=" + this.mUnpluggedReportedCount + " mCurrentReportedTotalTime=" + this.mCurrentReportedTotalTime + " mUnpluggedReportedTotalTime=" + this.mUnpluggedReportedTotalTime);
        }

        @Override
        protected long computeRunTimeLocked(long curBatteryRealtime) {
            return this.mTotalTime + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedTotalTime - this.mUnpluggedReportedTotalTime : 0L);
        }

        @Override
        protected int computeCurrentCountLocked() {
            return this.mCount + (this.mTimeBaseRunning && this.mTrackingReportedValues ? this.mCurrentReportedCount - this.mUnpluggedReportedCount : 0);
        }

        @Override
        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            super.writeToParcel(out, elapsedRealtimeUs);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mUnpluggedReportedCount);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeLong(this.mUnpluggedReportedTotalTime);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        @Override
        boolean reset(boolean detachIfReset) {
            super.reset(detachIfReset);
            this.setStale();
            return true;
        }

        @Override
        void writeSummaryFromParcelLocked(Parcel out, long batteryRealtime) {
            super.writeSummaryFromParcelLocked(out, batteryRealtime);
            out.writeLong(this.mCurrentReportedTotalTime);
            out.writeInt(this.mCurrentReportedCount);
            out.writeInt(this.mTrackingReportedValues ? 1 : 0);
        }

        @Override
        void readSummaryFromParcelLocked(Parcel in) {
            super.readSummaryFromParcelLocked(in);
            this.mUnpluggedReportedTotalTime = this.mCurrentReportedTotalTime = in.readLong();
            this.mUnpluggedReportedCount = this.mCurrentReportedCount = in.readInt();
            this.mTrackingReportedValues = in.readInt() == 1;
        }
    }

    public static abstract class Timer
    extends BatteryStats.Timer
    implements TimeBaseObs {
        final int mType;
        final TimeBase mTimeBase;
        int mCount;
        int mLoadedCount;
        int mLastCount;
        int mUnpluggedCount;
        long mTotalTime;
        long mLoadedTime;
        long mLastTime;
        long mUnpluggedTime;
        long mTimeBeforeMark;

        Timer(int type, TimeBase timeBase, Parcel in) {
            this.mType = type;
            this.mTimeBase = timeBase;
            this.mCount = in.readInt();
            this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = in.readInt();
            this.mTotalTime = in.readLong();
            this.mLoadedTime = in.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = in.readLong();
            this.mTimeBeforeMark = in.readLong();
            timeBase.add(this);
        }

        Timer(int type, TimeBase timeBase) {
            this.mType = type;
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        protected abstract long computeRunTimeLocked(long var1);

        protected abstract int computeCurrentCountLocked();

        boolean reset(boolean detachIfReset) {
            this.mTimeBeforeMark = 0L;
            this.mLastTime = 0L;
            this.mLoadedTime = 0L;
            this.mTotalTime = 0L;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            this.mCount = 0;
            if (detachIfReset) {
                this.detach();
            }
            return true;
        }

        void detach() {
            this.mTimeBase.remove(this);
        }

        public void writeToParcel(Parcel out, long elapsedRealtimeUs) {
            out.writeInt(this.mCount);
            out.writeInt(this.mLoadedCount);
            out.writeInt(this.mUnpluggedCount);
            out.writeLong(this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs)));
            out.writeLong(this.mLoadedTime);
            out.writeLong(this.mUnpluggedTime);
            out.writeLong(this.mTimeBeforeMark);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long timeBaseUptime, long baseRealtime) {
            this.mUnpluggedTime = this.computeRunTimeLocked(baseRealtime);
            this.mUnpluggedCount = this.mCount;
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mTotalTime = this.computeRunTimeLocked(baseRealtime);
            this.mCount = this.computeCurrentCountLocked();
        }

        public static void writeTimerToParcel(Parcel out, Timer timer, long elapsedRealtimeUs) {
            if (timer == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            timer.writeToParcel(out, elapsedRealtimeUs);
        }

        @Override
        public long getTotalTimeLocked(long elapsedRealtimeUs, int which) {
            long val = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            if (which == 2) {
                val -= this.mUnpluggedTime;
            } else if (which != 0) {
                val -= this.mLoadedTime;
            }
            return val;
        }

        @Override
        public int getCountLocked(int which) {
            int val = this.computeCurrentCountLocked();
            if (which == 2) {
                val -= this.mUnpluggedCount;
            } else if (which != 0) {
                val -= this.mLoadedCount;
            }
            return val;
        }

        @Override
        public long getTimeSinceMarkLocked(long elapsedRealtimeUs) {
            long val = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            return val - this.mTimeBeforeMark;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount);
            pw.println(prefix + "mTotalTime=" + this.mTotalTime + " mLoadedTime=" + this.mLoadedTime);
            pw.println(prefix + "mLastTime=" + this.mLastTime + " mUnpluggedTime=" + this.mUnpluggedTime);
        }

        void writeSummaryFromParcelLocked(Parcel out, long elapsedRealtimeUs) {
            long runTime = this.computeRunTimeLocked(this.mTimeBase.getRealtime(elapsedRealtimeUs));
            out.writeLong(runTime);
            out.writeInt(this.mCount);
        }

        void readSummaryFromParcelLocked(Parcel in) {
            this.mTotalTime = this.mLoadedTime = in.readLong();
            this.mLastTime = 0L;
            this.mUnpluggedTime = this.mTotalTime;
            this.mCount = this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mCount;
            this.mTimeBeforeMark = this.mTotalTime;
        }
    }

    public static class LongSamplingCounter
    extends BatteryStats.LongCounter
    implements TimeBaseObs {
        final TimeBase mTimeBase;
        long mCount;
        long mLoadedCount;
        long mLastCount;
        long mUnpluggedCount;
        long mPluggedCount;

        LongSamplingCounter(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mCount = this.mPluggedCount = in.readLong();
            this.mLoadedCount = in.readLong();
            this.mLastCount = 0L;
            this.mUnpluggedCount = in.readLong();
            timeBase.add(this);
        }

        LongSamplingCounter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeLong(this.mCount);
            out.writeLong(this.mLoadedCount);
            out.writeLong(this.mUnpluggedCount);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount = this.mPluggedCount;
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mPluggedCount = this.mCount;
        }

        @Override
        public long getCountLocked(int which) {
            long val = this.mCount;
            if (which == 2) {
                val -= this.mUnpluggedCount;
            } else if (which != 0) {
                val -= this.mLoadedCount;
            }
            return val;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        void addCountLocked(long count) {
            this.mCount += count;
        }

        void reset(boolean detachIfReset) {
            this.mCount = 0L;
            this.mUnpluggedCount = 0L;
            this.mPluggedCount = 0L;
            this.mLastCount = 0L;
            this.mLoadedCount = 0L;
            if (detachIfReset) {
                this.detach();
            }
        }

        void detach() {
            this.mTimeBase.remove(this);
        }

        void writeSummaryFromParcelLocked(Parcel out) {
            out.writeLong(this.mCount);
        }

        void readSummaryFromParcelLocked(Parcel in) {
            this.mCount = this.mLoadedCount = in.readLong();
            this.mLastCount = 0L;
            this.mUnpluggedCount = this.mPluggedCount = this.mLoadedCount;
        }
    }

    public static class Counter
    extends BatteryStats.Counter
    implements TimeBaseObs {
        final AtomicInteger mCount = new AtomicInteger();
        final TimeBase mTimeBase;
        int mLoadedCount;
        int mLastCount;
        int mUnpluggedCount;
        int mPluggedCount;

        Counter(TimeBase timeBase, Parcel in) {
            this.mTimeBase = timeBase;
            this.mPluggedCount = in.readInt();
            this.mCount.set(this.mPluggedCount);
            this.mLoadedCount = in.readInt();
            this.mLastCount = 0;
            this.mUnpluggedCount = in.readInt();
            timeBase.add(this);
        }

        Counter(TimeBase timeBase) {
            this.mTimeBase = timeBase;
            timeBase.add(this);
        }

        public void writeToParcel(Parcel out) {
            out.writeInt(this.mCount.get());
            out.writeInt(this.mLoadedCount);
            out.writeInt(this.mUnpluggedCount);
        }

        @Override
        public void onTimeStarted(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mUnpluggedCount = this.mPluggedCount;
            this.mCount.set(this.mPluggedCount);
        }

        @Override
        public void onTimeStopped(long elapsedRealtime, long baseUptime, long baseRealtime) {
            this.mPluggedCount = this.mCount.get();
        }

        public static void writeCounterToParcel(Parcel out, Counter counter) {
            if (counter == null) {
                out.writeInt(0);
                return;
            }
            out.writeInt(1);
            counter.writeToParcel(out);
        }

        @Override
        public int getCountLocked(int which) {
            int val = this.mCount.get();
            if (which == 2) {
                val -= this.mUnpluggedCount;
            } else if (which != 0) {
                val -= this.mLoadedCount;
            }
            return val;
        }

        @Override
        public void logState(Printer pw, String prefix) {
            pw.println(prefix + "mCount=" + this.mCount.get() + " mLoadedCount=" + this.mLoadedCount + " mLastCount=" + this.mLastCount + " mUnpluggedCount=" + this.mUnpluggedCount + " mPluggedCount=" + this.mPluggedCount);
        }

        void stepAtomic() {
            this.mCount.incrementAndGet();
        }

        void reset(boolean detachIfReset) {
            this.mCount.set(0);
            this.mUnpluggedCount = 0;
            this.mPluggedCount = 0;
            this.mLastCount = 0;
            this.mLoadedCount = 0;
            if (detachIfReset) {
                this.detach();
            }
        }

        void detach() {
            this.mTimeBase.remove(this);
        }

        void writeSummaryFromParcelLocked(Parcel out) {
            int count = this.mCount.get();
            out.writeInt(count);
        }

        void readSummaryFromParcelLocked(Parcel in) {
            this.mLoadedCount = in.readInt();
            this.mCount.set(this.mLoadedCount);
            this.mLastCount = 0;
            this.mUnpluggedCount = this.mPluggedCount = this.mLoadedCount;
        }
    }

    static class TimeBase {
        private final ArrayList<TimeBaseObs> mObservers = new ArrayList();
        private long mUptime;
        private long mRealtime;
        private boolean mRunning;
        private long mPastUptime;
        private long mUptimeStart;
        private long mPastRealtime;
        private long mRealtimeStart;
        private long mUnpluggedUptime;
        private long mUnpluggedRealtime;

        TimeBase() {
        }

        public void dump(PrintWriter pw, String prefix) {
            StringBuilder sb = new StringBuilder(128);
            pw.print(prefix);
            pw.print("mRunning=");
            pw.println(this.mRunning);
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mUptime=");
            BatteryStats.formatTimeMs(sb, this.mUptime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mRealtime=");
            BatteryStats.formatTimeMs(sb, this.mRealtime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastUptime=");
            BatteryStats.formatTimeMs(sb, this.mPastUptime / 1000L);
            sb.append("mUptimeStart=");
            BatteryStats.formatTimeMs(sb, this.mUptimeStart / 1000L);
            sb.append("mUnpluggedUptime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedUptime / 1000L);
            pw.println(sb.toString());
            sb.setLength(0);
            sb.append(prefix);
            sb.append("mPastRealtime=");
            BatteryStats.formatTimeMs(sb, this.mPastRealtime / 1000L);
            sb.append("mRealtimeStart=");
            BatteryStats.formatTimeMs(sb, this.mRealtimeStart / 1000L);
            sb.append("mUnpluggedRealtime=");
            BatteryStats.formatTimeMs(sb, this.mUnpluggedRealtime / 1000L);
            pw.println(sb.toString());
        }

        public void add(TimeBaseObs observer) {
            this.mObservers.add(observer);
        }

        public void remove(TimeBaseObs observer) {
            if (!this.mObservers.remove(observer)) {
                Slog.wtf(BatteryStatsImpl.TAG, "Removed unknown observer: " + observer);
            }
        }

        public void init(long uptime, long realtime) {
            this.mRealtime = 0L;
            this.mUptime = 0L;
            this.mPastUptime = 0L;
            this.mPastRealtime = 0L;
            this.mUptimeStart = uptime;
            this.mRealtimeStart = realtime;
            this.mUnpluggedUptime = this.getUptime(this.mUptimeStart);
            this.mUnpluggedRealtime = this.getRealtime(this.mRealtimeStart);
        }

        public void reset(long uptime, long realtime) {
            if (!this.mRunning) {
                this.mPastUptime = 0L;
                this.mPastRealtime = 0L;
            } else {
                this.mUptimeStart = uptime;
                this.mRealtimeStart = realtime;
                this.mUnpluggedUptime = this.getUptime(uptime);
                this.mUnpluggedRealtime = this.getRealtime(realtime);
            }
        }

        public long computeUptime(long curTime, int which) {
            switch (which) {
                case 0: {
                    return this.mUptime + this.getUptime(curTime);
                }
                case 1: {
                    return this.getUptime(curTime);
                }
                case 2: {
                    return this.getUptime(curTime) - this.mUnpluggedUptime;
                }
            }
            return 0L;
        }

        public long computeRealtime(long curTime, int which) {
            switch (which) {
                case 0: {
                    return this.mRealtime + this.getRealtime(curTime);
                }
                case 1: {
                    return this.getRealtime(curTime);
                }
                case 2: {
                    return this.getRealtime(curTime) - this.mUnpluggedRealtime;
                }
            }
            return 0L;
        }

        public long getUptime(long curTime) {
            long time = this.mPastUptime;
            if (this.mRunning) {
                time += curTime - this.mUptimeStart;
            }
            return time;
        }

        public long getRealtime(long curTime) {
            long time = this.mPastRealtime;
            if (this.mRunning) {
                time += curTime - this.mRealtimeStart;
            }
            return time;
        }

        public long getUptimeStart() {
            return this.mUptimeStart;
        }

        public long getRealtimeStart() {
            return this.mRealtimeStart;
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public boolean setRunning(boolean running, long uptime, long realtime) {
            if (this.mRunning != running) {
                this.mRunning = running;
                if (running) {
                    this.mUptimeStart = uptime;
                    this.mRealtimeStart = realtime;
                    long batteryUptime = this.mUnpluggedUptime = this.getUptime(uptime);
                    long batteryRealtime = this.mUnpluggedRealtime = this.getRealtime(realtime);
                    for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                        this.mObservers.get(i).onTimeStarted(realtime, batteryUptime, batteryRealtime);
                    }
                } else {
                    this.mPastUptime += uptime - this.mUptimeStart;
                    this.mPastRealtime += realtime - this.mRealtimeStart;
                    long batteryUptime = this.getUptime(uptime);
                    long batteryRealtime = this.getRealtime(realtime);
                    for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                        this.mObservers.get(i).onTimeStopped(realtime, batteryUptime, batteryRealtime);
                    }
                }
                return true;
            }
            return false;
        }

        public void readSummaryFromParcel(Parcel in) {
            this.mUptime = in.readLong();
            this.mRealtime = in.readLong();
        }

        public void writeSummaryToParcel(Parcel out, long uptime, long realtime) {
            out.writeLong(this.computeUptime(uptime, 0));
            out.writeLong(this.computeRealtime(realtime, 0));
        }

        public void readFromParcel(Parcel in) {
            this.mRunning = false;
            this.mUptime = in.readLong();
            this.mPastUptime = in.readLong();
            this.mUptimeStart = in.readLong();
            this.mRealtime = in.readLong();
            this.mPastRealtime = in.readLong();
            this.mRealtimeStart = in.readLong();
            this.mUnpluggedUptime = in.readLong();
            this.mUnpluggedRealtime = in.readLong();
        }

        public void writeToParcel(Parcel out, long uptime, long realtime) {
            long runningUptime = this.getUptime(uptime);
            long runningRealtime = this.getRealtime(realtime);
            out.writeLong(this.mUptime);
            out.writeLong(runningUptime);
            out.writeLong(this.mUptimeStart);
            out.writeLong(this.mRealtime);
            out.writeLong(runningRealtime);
            out.writeLong(this.mRealtimeStart);
            out.writeLong(this.mUnpluggedUptime);
            out.writeLong(this.mUnpluggedRealtime);
        }
    }

    public static interface TimeBaseObs {
        public void onTimeStarted(long var1, long var3, long var5);

        public void onTimeStopped(long var1, long var3, long var5);
    }

    public static interface ExternalStatsSync {
        public void scheduleSync(String var1);

        public void scheduleWifiSync(String var1);

        public void scheduleCpuSyncDueToRemovedUid(int var1);
    }

    final class MyHandler
    extends Handler {
        public MyHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            BatteryCallback cb = BatteryStatsImpl.this.mCallback;
            switch (msg.what) {
                case 1: {
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    synchronized (batteryStatsImpl) {
                        BatteryStatsImpl.this.updateCpuTimeLocked();
                    }
                    if (cb == null) break;
                    cb.batteryNeedsCpuUpdate();
                    break;
                }
                case 2: {
                    if (cb == null) break;
                    cb.batteryPowerChanged(msg.arg1 != 0);
                    break;
                }
                case 3: {
                    String action;
                    if (cb == null) break;
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsImpl.this;
                    synchronized (batteryStatsImpl) {
                        action = BatteryStatsImpl.this.mCharging ? "android.os.action.CHARGING" : "android.os.action.DISCHARGING";
                    }
                    Intent intent = new Intent(action);
                    intent.addFlags(0x4000000);
                    cb.batterySendBroadcast(intent);
                }
            }
        }
    }

    public static interface BatteryCallback {
        public void batteryNeedsCpuUpdate();

        public void batteryPowerChanged(boolean var1);

        public void batterySendBroadcast(Intent var1);
    }
}

