/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.ArrayMap;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class CpuPowerCalculator
extends PowerCalculator {
    private static final String TAG = "CpuPowerCalculator";
    private static final boolean DEBUG = false;
    private final double[] mPowerCpuNormal;
    private final long[] mSpeedStepTimes;

    public CpuPowerCalculator(PowerProfile profile) {
        int speedSteps = profile.getNumSpeedSteps();
        this.mPowerCpuNormal = new double[speedSteps];
        this.mSpeedStepTimes = new long[speedSteps];
        for (int p = 0; p < speedSteps; ++p) {
            this.mPowerCpuNormal[p] = profile.getAveragePower("cpu.active", p);
        }
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        int speedSteps = this.mSpeedStepTimes.length;
        long totalTimeAtSpeeds = 0L;
        for (int step = 0; step < speedSteps; ++step) {
            this.mSpeedStepTimes[step] = u.getTimeAtCpuSpeed(step, statsType);
            totalTimeAtSpeeds += this.mSpeedStepTimes[step];
        }
        totalTimeAtSpeeds = Math.max(totalTimeAtSpeeds, 1L);
        app.cpuTimeMs = (u.getUserCpuTimeUs(statsType) + u.getSystemCpuTimeUs(statsType)) / 1000L;
        double cpuPowerMaMs = 0.0;
        for (int step = 0; step < speedSteps; ++step) {
            double ratio = (double)this.mSpeedStepTimes[step] / (double)totalTimeAtSpeeds;
            double cpuSpeedStepPower = ratio * (double)app.cpuTimeMs * this.mPowerCpuNormal[step];
            cpuPowerMaMs += cpuSpeedStepPower;
        }
        double highestDrain = 0.0;
        app.cpuFgTimeMs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
        int processStatsCount = processStats.size();
        for (int i = 0; i < processStatsCount; ++i) {
            BatteryStats.Uid.Proc ps = processStats.valueAt(i);
            String processName = processStats.keyAt(i);
            app.cpuFgTimeMs += ps.getForegroundTime(statsType);
            long costValue = ps.getUserTime(statsType) + ps.getSystemTime(statsType) + ps.getForegroundTime(statsType);
            if (app.packageWithHighestDrain == null || app.packageWithHighestDrain.startsWith("*")) {
                highestDrain = costValue;
                app.packageWithHighestDrain = processName;
                continue;
            }
            if (!(highestDrain < (double)costValue) || processName.startsWith("*")) continue;
            highestDrain = costValue;
            app.packageWithHighestDrain = processName;
        }
        if (app.cpuFgTimeMs > app.cpuTimeMs) {
            app.cpuTimeMs = app.cpuFgTimeMs;
        }
        app.cpuPowerMah = cpuPowerMaMs / 3600000.0;
    }
}

