/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Slog;
import android.util.SparseLongArray;
import android.util.TimeUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class KernelUidCpuTimeReader {
    private static final String TAG = "KernelUidCpuTimeReader";
    private static final String sProcFile = "/proc/uid_cputime/show_uid_stat";
    private static final String sRemoveUidProcFile = "/proc/uid_cputime/remove_uid_range";
    private SparseLongArray mLastUserTimeUs = new SparseLongArray();
    private SparseLongArray mLastSystemTimeUs = new SparseLongArray();
    private SparseLongArray mLastPowerMaUs = new SparseLongArray();
    private long mLastTimeReadUs = 0L;

    public void readDelta(Callback callback) {
        long nowUs = SystemClock.elapsedRealtime() * 1000L;
        try (BufferedReader reader = new BufferedReader(new FileReader(sProcFile));){
            String line;
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
            while ((line = reader.readLine()) != null) {
                splitter.setString(line);
                String uidStr = splitter.next();
                int uid = Integer.parseInt(uidStr.substring(0, uidStr.length() - 1), 10);
                long userTimeUs = Long.parseLong(splitter.next(), 10);
                long systemTimeUs = Long.parseLong(splitter.next(), 10);
                long powerMaUs = splitter.hasNext() ? Long.parseLong(splitter.next(), 10) / 1000L : 0L;
                if (callback != null) {
                    long userTimeDeltaUs = userTimeUs;
                    long systemTimeDeltaUs = systemTimeUs;
                    long powerDeltaMaUs = powerMaUs;
                    int index = this.mLastUserTimeUs.indexOfKey(uid);
                    if (index >= 0) {
                        long timeDiffUs = nowUs - this.mLastTimeReadUs;
                        if ((userTimeDeltaUs -= this.mLastUserTimeUs.valueAt(index)) < 0L || (systemTimeDeltaUs -= this.mLastSystemTimeUs.valueAt(index)) < 0L || (powerDeltaMaUs -= this.mLastPowerMaUs.valueAt(index)) < 0L) {
                            StringBuilder sb = new StringBuilder("Malformed cpu data for UID=");
                            sb.append(uid).append("!\n");
                            sb.append("Time between reads: ");
                            TimeUtils.formatDuration(timeDiffUs / 1000L, sb);
                            sb.append("\n");
                            sb.append("Previous times: u=");
                            TimeUtils.formatDuration(this.mLastUserTimeUs.valueAt(index) / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(this.mLastSystemTimeUs.valueAt(index) / 1000L, sb);
                            sb.append(" p=").append(this.mLastPowerMaUs.valueAt(index) / 1000L);
                            sb.append("mAms\n");
                            sb.append("Current times: u=");
                            TimeUtils.formatDuration(userTimeUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeUs / 1000L, sb);
                            sb.append(" p=").append(powerMaUs / 1000L);
                            sb.append("mAms\n");
                            sb.append("Delta: u=");
                            TimeUtils.formatDuration(userTimeDeltaUs / 1000L, sb);
                            sb.append(" s=");
                            TimeUtils.formatDuration(systemTimeDeltaUs / 1000L, sb);
                            sb.append(" p=").append(powerDeltaMaUs / 1000L).append("mAms");
                            Slog.wtf(TAG, sb.toString());
                            userTimeDeltaUs = 0L;
                            systemTimeDeltaUs = 0L;
                            powerDeltaMaUs = 0L;
                        }
                    }
                    if (userTimeDeltaUs != 0L || systemTimeDeltaUs != 0L || powerDeltaMaUs != 0L) {
                        callback.onUidCpuTime(uid, userTimeDeltaUs, systemTimeDeltaUs, powerDeltaMaUs);
                    }
                }
                this.mLastUserTimeUs.put(uid, userTimeUs);
                this.mLastSystemTimeUs.put(uid, systemTimeUs);
                this.mLastPowerMaUs.put(uid, powerMaUs);
            }
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to read uid_cputime", e);
        }
        this.mLastTimeReadUs = nowUs;
    }

    public void removeUid(int uid) {
        int index = this.mLastUserTimeUs.indexOfKey(uid);
        if (index >= 0) {
            this.mLastUserTimeUs.removeAt(index);
            this.mLastSystemTimeUs.removeAt(index);
            this.mLastPowerMaUs.removeAt(index);
        }
        try (FileWriter writer = new FileWriter(sRemoveUidProcFile);){
            writer.write(Integer.toString(uid) + "-" + Integer.toString(uid));
            writer.flush();
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to remove uid from uid_cputime module", e);
        }
    }

    public static interface Callback {
        public void onUidCpuTime(int var1, long var2, long var4, long var6);
    }
}

