/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.app.KeyguardManager;
import android.app.SearchManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.session.MediaSessionLegacyHelper;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.FallbackEventHandler;
import android.view.KeyEvent;
import android.view.View;
import com.android.internal.policy.PhoneWindow;

public class PhoneFallbackEventHandler
implements FallbackEventHandler {
    private static String TAG = "PhoneFallbackEventHandler";
    private static final boolean DEBUG = false;
    Context mContext;
    View mView;
    AudioManager mAudioManager;
    KeyguardManager mKeyguardManager;
    SearchManager mSearchManager;
    TelephonyManager mTelephonyManager;

    public PhoneFallbackEventHandler(Context context) {
        this.mContext = context;
    }

    @Override
    public void setView(View v) {
        this.mView = v;
    }

    @Override
    public void preDispatchKeyEvent(KeyEvent event) {
        this.getAudioManager().preDispatchKeyEvent(event, Integer.MIN_VALUE);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        int action = event.getAction();
        int keyCode = event.getKeyCode();
        if (action == 0) {
            return this.onKeyDown(keyCode, event);
        }
        return this.onKeyUp(keyCode, event);
    }

    boolean onKeyDown(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, false);
                return true;
            }
            case 85: 
            case 126: 
            case 127: {
                if (this.getTelephonyManager().getCallState() != 0) {
                    return true;
                }
            }
            case 79: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 130: 
            case 222: {
                this.handleMediaKeyEvent(event);
                return true;
            }
            case 5: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    if (this.isUserSetupComplete()) {
                        this.mView.performHapticFeedback(0);
                        Intent intent = new Intent("android.intent.action.VOICE_COMMAND");
                        intent.setFlags(0x10000000);
                        try {
                            this.sendCloseSystemWindows();
                            this.mContext.startActivity(intent);
                        }
                        catch (ActivityNotFoundException e) {
                            this.startCallActivity();
                        }
                    } else {
                        Log.i(TAG, "Not starting call activity because user setup is in progress.");
                    }
                }
                return true;
            }
            case 27: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    if (this.isUserSetupComplete()) {
                        this.mView.performHapticFeedback(0);
                        this.sendCloseSystemWindows();
                        Intent intent = new Intent("android.intent.action.CAMERA_BUTTON", null);
                        intent.putExtra("android.intent.extra.KEY_EVENT", event);
                        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT_OR_SELF, null, null, null, 0, null, null);
                    } else {
                        Log.i(TAG, "Not dispatching CAMERA long press because user setup is in progress.");
                    }
                }
                return true;
            }
            case 84: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                    break;
                }
                if (!event.isLongPress() || !dispatcher.isTracking(event)) break;
                Configuration config = this.mContext.getResources().getConfiguration();
                if (config.keyboard != 1 && config.hardKeyboardHidden != 2) break;
                if (this.isUserSetupComplete()) {
                    Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
                    intent.setFlags(0x10000000);
                    try {
                        this.mView.performHapticFeedback(0);
                        this.sendCloseSystemWindows();
                        this.getSearchManager().stopSearch();
                        this.mContext.startActivity(intent);
                        dispatcher.performedLongPress(event);
                        return true;
                    }
                    catch (ActivityNotFoundException e) {
                        break;
                    }
                }
                Log.i(TAG, "Not dispatching SEARCH long press because user setup is in progress.");
            }
        }
        return false;
    }

    boolean onKeyUp(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (!event.isCanceled()) {
                    MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, false);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                this.handleMediaKeyEvent(event);
                return true;
            }
            case 27: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (!event.isTracking() || !event.isCanceled()) {
                    // empty if block
                }
                return true;
            }
            case 5: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (event.isTracking() && !event.isCanceled()) {
                    if (this.isUserSetupComplete()) {
                        this.startCallActivity();
                    } else {
                        Log.i(TAG, "Not starting call activity because user setup is in progress.");
                    }
                }
                return true;
            }
        }
        return false;
    }

    void startCallActivity() {
        this.sendCloseSystemWindows();
        Intent intent = new Intent("android.intent.action.CALL_BUTTON");
        intent.setFlags(0x10000000);
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w(TAG, "No activity found for android.intent.action.CALL_BUTTON.");
        }
    }

    SearchManager getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    TelephonyManager getTelephonyManager() {
        if (this.mTelephonyManager == null) {
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        }
        return this.mTelephonyManager;
    }

    KeyguardManager getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        return this.mAudioManager;
    }

    void sendCloseSystemWindows() {
        PhoneWindow.sendCloseSystemWindows(this.mContext, null);
    }

    private void handleMediaKeyEvent(KeyEvent keyEvent) {
        MediaSessionLegacyHelper.getHelper(this.mContext).sendMediaButtonEvent(keyEvent, false);
    }

    private boolean isUserSetupComplete() {
        return Settings.Secure.getInt(this.mContext.getContentResolver(), "user_setup_complete", 0) != 0;
    }
}

