/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telecom;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telecom.CallAudioState;
import android.telecom.ConnectionRequest;
import android.telecom.PhoneAccountHandle;
import com.android.internal.telecom.IConnectionServiceAdapter;

public interface IConnectionService
extends IInterface {
    public void addConnectionServiceAdapter(IConnectionServiceAdapter var1) throws RemoteException;

    public void removeConnectionServiceAdapter(IConnectionServiceAdapter var1) throws RemoteException;

    public void createConnection(PhoneAccountHandle var1, String var2, ConnectionRequest var3, boolean var4, boolean var5) throws RemoteException;

    public void abort(String var1) throws RemoteException;

    public void answerVideo(String var1, int var2) throws RemoteException;

    public void answer(String var1) throws RemoteException;

    public void reject(String var1) throws RemoteException;

    public void disconnect(String var1) throws RemoteException;

    public void hold(String var1) throws RemoteException;

    public void unhold(String var1) throws RemoteException;

    public void onCallAudioStateChanged(String var1, CallAudioState var2) throws RemoteException;

    public void playDtmfTone(String var1, char var2) throws RemoteException;

    public void stopDtmfTone(String var1) throws RemoteException;

    public void conference(String var1, String var2) throws RemoteException;

    public void splitFromConference(String var1) throws RemoteException;

    public void mergeConference(String var1) throws RemoteException;

    public void swapConference(String var1) throws RemoteException;

    public void onPostDialContinue(String var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IConnectionService {
        private static final String DESCRIPTOR = "com.android.internal.telecom.IConnectionService";
        static final int TRANSACTION_addConnectionServiceAdapter = 1;
        static final int TRANSACTION_removeConnectionServiceAdapter = 2;
        static final int TRANSACTION_createConnection = 3;
        static final int TRANSACTION_abort = 4;
        static final int TRANSACTION_answerVideo = 5;
        static final int TRANSACTION_answer = 6;
        static final int TRANSACTION_reject = 7;
        static final int TRANSACTION_disconnect = 8;
        static final int TRANSACTION_hold = 9;
        static final int TRANSACTION_unhold = 10;
        static final int TRANSACTION_onCallAudioStateChanged = 11;
        static final int TRANSACTION_playDtmfTone = 12;
        static final int TRANSACTION_stopDtmfTone = 13;
        static final int TRANSACTION_conference = 14;
        static final int TRANSACTION_splitFromConference = 15;
        static final int TRANSACTION_mergeConference = 16;
        static final int TRANSACTION_swapConference = 17;
        static final int TRANSACTION_onPostDialContinue = 18;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IConnectionService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IConnectionService) {
                return (IConnectionService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    IConnectionServiceAdapter _arg0 = IConnectionServiceAdapter.Stub.asInterface(data.readStrongBinder());
                    this.addConnectionServiceAdapter(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    IConnectionServiceAdapter _arg0 = IConnectionServiceAdapter.Stub.asInterface(data.readStrongBinder());
                    this.removeConnectionServiceAdapter(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    PhoneAccountHandle _arg0 = 0 != data.readInt() ? PhoneAccountHandle.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    ConnectionRequest _arg2 = 0 != data.readInt() ? ConnectionRequest.CREATOR.createFromParcel(data) : null;
                    boolean _arg3 = 0 != data.readInt();
                    boolean _arg4 = 0 != data.readInt();
                    this.createConnection(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.abort(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.answerVideo(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.answer(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.reject(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.disconnect(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.hold(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.unhold(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    CallAudioState _arg1 = 0 != data.readInt() ? CallAudioState.CREATOR.createFromParcel(data) : null;
                    this.onCallAudioStateChanged(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    char _arg1 = (char)data.readInt();
                    this.playDtmfTone(_arg0, _arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.stopDtmfTone(_arg0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.conference(_arg0, _arg1);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.splitFromConference(_arg0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.mergeConference(_arg0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    this.swapConference(_arg0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.onPostDialContinue(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IConnectionService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addConnectionServiceAdapter(IConnectionServiceAdapter adapter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeConnectionServiceAdapter(IConnectionServiceAdapter adapter) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(adapter != null ? adapter.asBinder() : null);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createConnection(PhoneAccountHandle connectionManagerPhoneAccount, String callId, ConnectionRequest request, boolean isIncoming, boolean isUnknown) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (connectionManagerPhoneAccount != null) {
                        _data.writeInt(1);
                        connectionManagerPhoneAccount.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(callId);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(isIncoming ? 1 : 0);
                    _data.writeInt(isUnknown ? 1 : 0);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abort(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void answerVideo(String callId, int videoState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(videoState);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void answer(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reject(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disconnect(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hold(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unhold(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallAudioStateChanged(String activeCallId, CallAudioState callAudioState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(activeCallId);
                    if (callAudioState != null) {
                        _data.writeInt(1);
                        callAudioState.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playDtmfTone(String callId, char digit) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(digit);
                    this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDtmfTone(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void conference(String conferenceCallId, String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(conferenceCallId);
                    _data.writeString(callId);
                    this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void splitFromConference(String callId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mergeConference(String conferenceCallId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(conferenceCallId);
                    this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void swapConference(String conferenceCallId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(conferenceCallId);
                    this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPostDialContinue(String callId, boolean proceed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callId);
                    _data.writeInt(proceed ? 1 : 0);
                    this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

