/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.res.Resources;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.util.Slog;
import java.util.ArrayList;
import java.util.List;

public final class CarrierAppUtils {
    private static final String TAG = "CarrierAppUtils";
    private static final boolean DEBUG = false;

    private CarrierAppUtils() {
    }

    public static synchronized void disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, int userId) {
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236020);
        CarrierAppUtils.disableCarrierAppsUntilPrivileged(callingPackage, packageManager, telephonyManager, userId, systemCarrierAppsDisabledUntilUsed);
    }

    public static void disableCarrierAppsUntilPrivileged(String callingPackage, IPackageManager packageManager, TelephonyManager telephonyManager, int userId, String[] systemCarrierAppsDisabledUntilUsed) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
        if (candidates == null || candidates.isEmpty()) {
            return;
        }
        ArrayList<String> enabledCarrierPackages = new ArrayList<String>();
        try {
            for (ApplicationInfo ai : candidates) {
                boolean hasPrivileges;
                String packageName = ai.packageName;
                boolean bl = hasPrivileges = telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
                if (!ai.isUpdatedSystemApp()) {
                    if (hasPrivileges && (ai.enabledSetting == 0 || ai.enabledSetting == 4)) {
                        Slog.i(TAG, "Update state(" + packageName + "): ENABLED for user " + userId);
                        packageManager.setApplicationEnabledSetting(packageName, 1, 1, userId, callingPackage);
                    } else if (!hasPrivileges && ai.enabledSetting == 0) {
                        Slog.i(TAG, "Update state(" + packageName + "): DISABLED_UNTIL_USED for user " + userId);
                        packageManager.setApplicationEnabledSetting(packageName, 4, 0, userId, callingPackage);
                    }
                }
                if (!hasPrivileges) continue;
                enabledCarrierPackages.add(ai.packageName);
            }
            if (!enabledCarrierPackages.isEmpty()) {
                String[] packageNames = new String[enabledCarrierPackages.size()];
                enabledCarrierPackages.toArray(packageNames);
                packageManager.grantDefaultPermissionsToEnabledCarrierApps(packageNames, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not reach PackageManager", e);
        }
    }

    public static List<ApplicationInfo> getDefaultCarrierApps(IPackageManager packageManager, TelephonyManager telephonyManager, int userId) {
        List<ApplicationInfo> candidates = CarrierAppUtils.getDefaultCarrierAppCandidates(packageManager, userId);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        for (int i = candidates.size() - 1; i >= 0; --i) {
            boolean hasPrivileges;
            ApplicationInfo ai = candidates.get(i);
            String packageName = ai.packageName;
            boolean bl = hasPrivileges = telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
            if (hasPrivileges) continue;
            candidates.remove(i);
        }
        return candidates;
    }

    public static List<ApplicationInfo> getDefaultCarrierAppCandidates(IPackageManager packageManager, int userId) {
        String[] systemCarrierAppsDisabledUntilUsed = Resources.getSystem().getStringArray(17236020);
        return CarrierAppUtils.getDefaultCarrierAppCandidatesHelper(packageManager, userId, systemCarrierAppsDisabledUntilUsed);
    }

    private static List<ApplicationInfo> getDefaultCarrierAppCandidatesHelper(IPackageManager packageManager, int userId, String[] systemCarrierAppsDisabledUntilUsed) {
        if (systemCarrierAppsDisabledUntilUsed == null || systemCarrierAppsDisabledUntilUsed.length == 0) {
            return null;
        }
        ArrayList<ApplicationInfo> apps = null;
        try {
            apps = new ArrayList<ApplicationInfo>(systemCarrierAppsDisabledUntilUsed.length);
            for (String packageName : systemCarrierAppsDisabledUntilUsed) {
                ApplicationInfo ai = packageManager.getApplicationInfo(packageName, 32768, userId);
                if (ai == null || !ai.isSystemApp()) continue;
                apps.add(ai);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not reach PackageManager", e);
        }
        return apps;
    }
}

