/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.UserHandle;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;

public class CarrierServiceBindHelper {
    private static final String LOG_TAG = CarrierServiceBindHelper.class.getSimpleName();
    private Context mContext;
    private AppBinding[] mBindings;
    private final BroadcastReceiver mReceiver = new PackageChangedBroadcastReceiver();
    private static final int EVENT_BIND = 0;
    private static final int EVENT_UNBIND = 1;
    private static final int EVENT_BIND_TIMEOUT = 2;
    private static final int EVENT_PACKAGE_CHANGED = 3;
    private static final int BIND_TIMEOUT_MILLIS = 10000;
    private Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            CarrierServiceBindHelper.log("mHandler: " + msg.what);
            switch (msg.what) {
                case 0: {
                    AppBinding binding = (AppBinding)msg.obj;
                    CarrierServiceBindHelper.log("Binding to phoneId: " + binding.getPhoneId());
                    binding.bind();
                    break;
                }
                case 2: {
                    AppBinding binding = (AppBinding)msg.obj;
                    CarrierServiceBindHelper.log("Bind timeout for phoneId: " + binding.getPhoneId());
                    binding.unbind();
                    break;
                }
                case 1: {
                    AppBinding binding = (AppBinding)msg.obj;
                    CarrierServiceBindHelper.log("Unbinding for phoneId: " + binding.getPhoneId());
                    binding.unbind();
                    break;
                }
                case 3: {
                    String carrierPackageName = (String)msg.obj;
                    for (AppBinding appBinding : CarrierServiceBindHelper.this.mBindings) {
                        if (!carrierPackageName.equals(appBinding.getPackage())) continue;
                        CarrierServiceBindHelper.log(carrierPackageName + " changed and corresponds to a phone. Rebinding.");
                        appBinding.bind();
                    }
                    break;
                }
            }
        }
    };

    public CarrierServiceBindHelper(Context context) {
        this.mContext = context;
        int numPhones = TelephonyManager.from(context).getPhoneCount();
        this.mBindings = new AppBinding[numPhones];
        for (int phoneId = 0; phoneId < numPhones; ++phoneId) {
            this.mBindings[phoneId] = new AppBinding(phoneId);
        }
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_ADDED");
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_REPLACED");
        pkgFilter.addDataScheme("package");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, pkgFilter, null, null);
    }

    public void updateForPhoneId(int phoneId, String simState) {
        CarrierServiceBindHelper.log("update binding for phoneId: " + phoneId + " simState: " + simState);
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            return;
        }
        switch (simState) {
            case "ABSENT": 
            case "CARD_IO_ERROR": 
            case "UNKNOWN": {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(1, this.mBindings[phoneId]));
                break;
            }
            case "LOADED": 
            case "LOCKED": {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(0, this.mBindings[phoneId]));
            }
        }
    }

    private static void log(String message) {
        Log.d(LOG_TAG, message);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CarrierServiceBindHelper:");
        for (AppBinding binding : this.mBindings) {
            binding.dump(fd, pw, args);
        }
    }

    private class PackageChangedBroadcastReceiver
    extends BroadcastReceiver {
        private PackageChangedBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            CarrierServiceBindHelper.log("Receive action: " + action);
            switch (action) {
                case "android.intent.action.PACKAGE_ADDED": 
                case "android.intent.action.PACKAGE_REMOVED": 
                case "android.intent.action.PACKAGE_REPLACED": {
                    int uid = intent.getIntExtra("android.intent.extra.UID", -1);
                    String packageName = CarrierServiceBindHelper.this.mContext.getPackageManager().getNameForUid(uid);
                    if (packageName == null) break;
                    CarrierServiceBindHelper.this.mHandler.sendMessage(CarrierServiceBindHelper.this.mHandler.obtainMessage(3, packageName));
                }
            }
        }
    }

    private class CarrierServiceConnection
    implements ServiceConnection {
        private IBinder service;
        private AppBinding binding;

        public CarrierServiceConnection(AppBinding binding) {
            this.binding = binding;
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            CarrierServiceBindHelper.log("Connected to carrier app: " + name.flattenToString());
            CarrierServiceBindHelper.this.mHandler.removeMessages(2, this.binding);
            this.service = service;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            CarrierServiceBindHelper.log("Disconnected from carrier app: " + name.flattenToString());
            this.service = null;
            this.binding.handleConnectionDown();
        }
    }

    private class AppBinding {
        private int phoneId;
        private CarrierServiceConnection connection;
        private int bindCount;
        private long lastBindStartMillis;
        private int unbindCount;
        private long lastUnbindMillis;
        private String carrierPackage;

        public AppBinding(int phoneId) {
            this.phoneId = phoneId;
        }

        public int getPhoneId() {
            return this.phoneId;
        }

        public String getPackage() {
            return this.carrierPackage;
        }

        public void handleConnectionDown() {
            this.connection = null;
        }

        public boolean bind() {
            String error;
            this.unbind();
            List<String> carrierPackageNames = TelephonyManager.from(CarrierServiceBindHelper.this.mContext).getCarrierPackageNamesForIntentAndPhone(new Intent("android.service.carrier.CarrierService"), this.phoneId);
            if (carrierPackageNames == null || carrierPackageNames.size() <= 0) {
                CarrierServiceBindHelper.log("No carrier app for: " + this.phoneId);
                return false;
            }
            CarrierServiceBindHelper.log("Found carrier app: " + carrierPackageNames);
            this.carrierPackage = carrierPackageNames.get(0);
            ++this.bindCount;
            this.lastBindStartMillis = System.currentTimeMillis();
            Intent carrierService = new Intent("android.service.carrier.CarrierService");
            carrierService.setPackage(this.carrierPackage);
            ResolveInfo carrierResolveInfo = CarrierServiceBindHelper.this.mContext.getPackageManager().resolveService(carrierService, 128);
            Bundle metadata = null;
            if (carrierResolveInfo != null) {
                metadata = carrierResolveInfo.serviceInfo.metaData;
            }
            if (metadata == null || !metadata.getBoolean("android.service.carrier.LONG_LIVED_BINDING", false)) {
                CarrierServiceBindHelper.log("Carrier app does not want a long lived binding");
                return false;
            }
            CarrierServiceBindHelper.log("Binding to " + this.carrierPackage + " for phone " + this.phoneId);
            this.connection = new CarrierServiceConnection(this);
            CarrierServiceBindHelper.this.mHandler.sendMessageDelayed(CarrierServiceBindHelper.this.mHandler.obtainMessage(2, this), 10000L);
            try {
                if (CarrierServiceBindHelper.this.mContext.bindService(carrierService, this.connection, 1)) {
                    return true;
                }
                error = "bindService returned false";
            }
            catch (SecurityException ex) {
                error = ex.getMessage();
            }
            CarrierServiceBindHelper.log("Unable to bind to " + this.carrierPackage + " for phone " + this.phoneId + ". Error: " + error);
            return false;
        }

        public void unbind() {
            CarrierServiceBindHelper.this.mHandler.removeMessages(2, this);
            if (this.connection == null) {
                return;
            }
            ++this.unbindCount;
            this.lastUnbindMillis = System.currentTimeMillis();
            CarrierServiceBindHelper.log("Unbinding from carrier app");
            CarrierServiceBindHelper.this.mContext.unbindService(this.connection);
            this.connection = null;
        }

        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            pw.println("Carrier app binding for phone " + this.phoneId);
            pw.println("  connection: " + this.connection);
            pw.println("  bindCount: " + this.bindCount);
            pw.println("  lastBindStartMillis: " + this.lastBindStartMillis);
            pw.println("  unbindCount: " + this.unbindCount);
            pw.println("  lastUnbindMillis: " + this.lastUnbindMillis);
            pw.println();
        }
    }
}

