/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.CellInfo;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.VoLteServiceState;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import java.util.List;

public class DefaultPhoneNotifier
implements PhoneNotifier {
    private static final String LOG_TAG = "DefaultPhoneNotifier";
    private static final boolean DBG = false;
    protected ITelephonyRegistry mRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));

    protected DefaultPhoneNotifier() {
    }

    @Override
    public void notifyPhoneState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        int subId = sender.getSubId();
        String incomingNumber = "";
        if (ringingCall != null && ringingCall.getEarliestConnection() != null) {
            incomingNumber = ringingCall.getEarliestConnection().getAddress();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCallStateForSubscriber(subId, DefaultPhoneNotifier.convertCallState(sender.getState()), incomingNumber);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyServiceState(Phone sender) {
        ServiceState ss = sender.getServiceState();
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        Rlog.d(LOG_TAG, "nofityServiceState: mRegistry=" + this.mRegistry + " ss=" + ss + " sender=" + sender + " phondId=" + phoneId + " subId=" + subId);
        if (ss == null) {
            ss = new ServiceState();
            ss.setStateOutOfService();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyServiceStateForPhoneId(phoneId, subId, ss);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifySignalStrength(Phone sender) {
        int subId = sender.getSubId();
        Rlog.d(LOG_TAG, "notifySignalStrength: mRegistry=" + this.mRegistry + " ss=" + sender.getSignalStrength() + " sender=" + sender);
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifySignalStrengthForSubscriber(subId, sender.getSignalStrength());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyMessageWaitingChanged(Phone sender) {
        int phoneId = sender.getPhoneId();
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyMessageWaitingChangedForPhoneId(phoneId, subId, sender.getMessageWaitingIndicator());
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyCallForwardingChanged(Phone sender) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCallForwardingChangedForSubscriber(subId, sender.getCallForwardingIndicator());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataActivity(Phone sender) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataActivityForSubscriber(subId, DefaultPhoneNotifier.convertDataActivityState(sender.getDataActivityState()));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnection(Phone sender, String reason, String apnType, PhoneConstants.DataState state) {
        this.doNotifyDataConnection(sender, reason, apnType, state);
    }

    private void doNotifyDataConnection(Phone sender, String reason, String apnType, PhoneConstants.DataState state) {
        ServiceState ss;
        int subId = sender.getSubId();
        long dds = SubscriptionManager.getDefaultDataSubId();
        TelephonyManager telephony = TelephonyManager.getDefault();
        LinkProperties linkProperties = null;
        NetworkCapabilities networkCapabilities = null;
        boolean roaming = false;
        if (state == PhoneConstants.DataState.CONNECTED) {
            linkProperties = sender.getLinkProperties(apnType);
            networkCapabilities = sender.getNetworkCapabilities(apnType);
        }
        if ((ss = sender.getServiceState()) != null) {
            roaming = ss.getDataRoaming();
        }
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataConnectionForSubscriber(subId, DefaultPhoneNotifier.convertDataState(state), sender.isDataConnectivityPossible(apnType), reason, sender.getActiveApnHost(apnType), apnType, linkProperties, networkCapabilities, telephony != null ? telephony.getDataNetworkType(subId) : 0, roaming);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnectionFailed(Phone sender, String reason, String apnType) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyDataConnectionFailedForSubscriber(subId, reason, apnType);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyCellLocation(Phone sender) {
        int subId = sender.getSubId();
        Bundle data = new Bundle();
        sender.getCellLocation().fillInNotifierBundle(data);
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCellLocationForSubscriber(subId, data);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyCellInfo(Phone sender, List<CellInfo> cellInfo) {
        int subId = sender.getSubId();
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyCellInfoForSubscriber(subId, cellInfo);
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyDataConnectionRealTimeInfo(Phone sender, DataConnectionRealTimeInfo dcRtInfo) {
        try {
            this.mRegistry.notifyDataConnectionRealTimeInfo(dcRtInfo);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyOtaspChanged(Phone sender, int otaspMode) {
        try {
            if (this.mRegistry != null) {
                this.mRegistry.notifyOtaspChanged(otaspMode);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyPreciseCallState(Phone sender) {
        Call ringingCall = sender.getRingingCall();
        Call foregroundCall = sender.getForegroundCall();
        Call backgroundCall = sender.getBackgroundCall();
        if (ringingCall != null && foregroundCall != null && backgroundCall != null) {
            try {
                this.mRegistry.notifyPreciseCallState(DefaultPhoneNotifier.convertPreciseCallState(ringingCall.getState()), DefaultPhoneNotifier.convertPreciseCallState(foregroundCall.getState()), DefaultPhoneNotifier.convertPreciseCallState(backgroundCall.getState()));
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void notifyDisconnectCause(int cause, int preciseCause) {
        try {
            this.mRegistry.notifyDisconnectCause(cause, preciseCause);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyPreciseDataConnectionFailed(Phone sender, String reason, String apnType, String apn, String failCause) {
        try {
            this.mRegistry.notifyPreciseDataConnectionFailed(reason, apnType, apn, failCause);
        }
        catch (RemoteException ex) {
            // empty catch block
        }
    }

    @Override
    public void notifyVoLteServiceStateChanged(Phone sender, VoLteServiceState lteState) {
        try {
            this.mRegistry.notifyVoLteServiceStateChanged(lteState);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void notifyOemHookRawEventForSubscriber(int subId, byte[] rawData) {
        try {
            this.mRegistry.notifyOemHookRawEventForSubscriber(subId, rawData);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static int convertCallState(PhoneConstants.State state) {
        switch (state) {
            case RINGING: {
                return 1;
            }
            case OFFHOOK: {
                return 2;
            }
        }
        return 0;
    }

    public static PhoneConstants.State convertCallState(int state) {
        switch (state) {
            case 1: {
                return PhoneConstants.State.RINGING;
            }
            case 2: {
                return PhoneConstants.State.OFFHOOK;
            }
        }
        return PhoneConstants.State.IDLE;
    }

    public static int convertDataState(PhoneConstants.DataState state) {
        switch (state) {
            case CONNECTING: {
                return 1;
            }
            case CONNECTED: {
                return 2;
            }
            case SUSPENDED: {
                return 3;
            }
        }
        return 0;
    }

    public static PhoneConstants.DataState convertDataState(int state) {
        switch (state) {
            case 1: {
                return PhoneConstants.DataState.CONNECTING;
            }
            case 2: {
                return PhoneConstants.DataState.CONNECTED;
            }
            case 3: {
                return PhoneConstants.DataState.SUSPENDED;
            }
        }
        return PhoneConstants.DataState.DISCONNECTED;
    }

    public static int convertDataActivityState(Phone.DataActivityState state) {
        switch (state) {
            case DATAIN: {
                return 1;
            }
            case DATAOUT: {
                return 2;
            }
            case DATAINANDOUT: {
                return 3;
            }
            case DORMANT: {
                return 4;
            }
        }
        return 0;
    }

    public static Phone.DataActivityState convertDataActivityState(int state) {
        switch (state) {
            case 1: {
                return Phone.DataActivityState.DATAIN;
            }
            case 2: {
                return Phone.DataActivityState.DATAOUT;
            }
            case 3: {
                return Phone.DataActivityState.DATAINANDOUT;
            }
            case 4: {
                return Phone.DataActivityState.DORMANT;
            }
        }
        return Phone.DataActivityState.NONE;
    }

    public static int convertPreciseCallState(Call.State state) {
        switch (state) {
            case ACTIVE: {
                return 1;
            }
            case HOLDING: {
                return 2;
            }
            case DIALING: {
                return 3;
            }
            case ALERTING: {
                return 4;
            }
            case INCOMING: {
                return 5;
            }
            case WAITING: {
                return 6;
            }
            case DISCONNECTED: {
                return 7;
            }
            case DISCONNECTING: {
                return 8;
            }
        }
        return 0;
    }

    public static Call.State convertPreciseCallState(int state) {
        switch (state) {
            case 1: {
                return Call.State.ACTIVE;
            }
            case 2: {
                return Call.State.HOLDING;
            }
            case 3: {
                return Call.State.DIALING;
            }
            case 4: {
                return Call.State.ALERTING;
            }
            case 5: {
                return Call.State.INCOMING;
            }
            case 6: {
                return Call.State.WAITING;
            }
            case 7: {
                return Call.State.DISCONNECTED;
            }
            case 8: {
                return Call.State.DISCONNECTING;
            }
        }
        return Call.State.IDLE;
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    public static interface IDataStateChangedCallback {
        public void onDataStateChanged(int var1, String var2, String var3, String var4, String var5, boolean var6);
    }
}

