/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IccPhoneBookInterfaceManager {
    protected static final boolean DBG = true;
    protected PhoneBase mPhone;
    private UiccCardApplication mCurrentApp = null;
    protected AdnRecordCache mAdnCache;
    protected final Object mLock = new Object();
    protected int[] mRecordSize;
    protected boolean mSuccess;
    private boolean mIs3gCard = false;
    protected List<AdnRecord> mRecords;
    protected static final boolean ALLOW_SIM_OP_IN_UI_THREAD = false;
    protected static final int EVENT_GET_SIZE_DONE = 1;
    protected static final int EVENT_LOAD_DONE = 2;
    protected static final int EVENT_UPDATE_DONE = 3;
    protected Handler mBaseHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccPhoneBookInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            IccPhoneBookInterfaceManager.this.mRecordSize = (int[])ar.result;
                            IccPhoneBookInterfaceManager.this.logd("GET_RECORD_SIZE Size " + IccPhoneBookInterfaceManager.this.mRecordSize[0] + " total " + IccPhoneBookInterfaceManager.this.mRecordSize[1] + " #record " + IccPhoneBookInterfaceManager.this.mRecordSize[2]);
                        }
                        this.notifyPending(ar);
                        break;
                    }
                }
                case 3: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccPhoneBookInterfaceManager.this.mLock;
                    synchronized (object) {
                        IccPhoneBookInterfaceManager.this.mSuccess = ar.exception == null;
                        this.notifyPending(ar);
                        break;
                    }
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    Object object = IccPhoneBookInterfaceManager.this.mLock;
                    synchronized (object) {
                        if (ar.exception == null) {
                            IccPhoneBookInterfaceManager.this.mRecords = (List)ar.result;
                        } else {
                            IccPhoneBookInterfaceManager.this.logd("Cannot load ADN records");
                            if (IccPhoneBookInterfaceManager.this.mRecords != null) {
                                IccPhoneBookInterfaceManager.this.mRecords.clear();
                            }
                        }
                        this.notifyPending(ar);
                        break;
                    }
                }
            }
        }

        private void notifyPending(AsyncResult ar) {
            if (ar.userObj != null) {
                AtomicBoolean status = (AtomicBoolean)ar.userObj;
                status.set(true);
            }
            IccPhoneBookInterfaceManager.this.mLock.notifyAll();
        }
    };

    public IccPhoneBookInterfaceManager(PhoneBase phone) {
        this.mPhone = phone;
        IccRecords r = phone.mIccRecords.get();
        if (r != null) {
            this.mAdnCache = r.getAdnCache();
        }
    }

    public void dispose() {
    }

    public void updateIccRecords(IccRecords iccRecords) {
        this.mAdnCache = iccRecords != null ? iccRecords.getAdnCache() : null;
    }

    protected abstract void logd(String var1);

    protected abstract void loge(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAdnRecordsInEfBySearch(int efid, String oldTag, String oldPhoneNumber, String newTag, String newPhoneNumber, String pin2) {
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfBySearch: efid=" + efid + " (" + oldTag + "," + oldPhoneNumber + ")" + "==>" + " (" + newTag + "," + newPhoneNumber + ")" + " pin2=" + pin2);
        efid = this.updateEfForIccType(efid);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.mSuccess = false;
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(3, status);
            AdnRecord oldAdn = new AdnRecord(oldTag, oldPhoneNumber);
            AdnRecord newAdn = new AdnRecord(newTag, newPhoneNumber);
            if (this.mAdnCache != null) {
                this.mAdnCache.updateAdnBySearch(efid, oldAdn, newAdn, pin2, response);
                this.waitForResult(status);
            } else {
                this.loge("Failure while trying to update by search due to uninitialised adncache");
            }
        }
        return this.mSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAdnRecordsInEfByIndex(int efid, String newTag, String newPhoneNumber, int index, String pin2) {
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.WRITE_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.WRITE_CONTACTS permission");
        }
        this.logd("updateAdnRecordsInEfByIndex: efid=" + efid + " Index=" + index + " ==> " + "(" + newTag + "," + newPhoneNumber + ")" + " pin2=" + pin2);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.mSuccess = false;
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(3, status);
            AdnRecord newAdn = new AdnRecord(newTag, newPhoneNumber);
            if (this.mAdnCache != null) {
                this.mAdnCache.updateAdnByIndex(efid, newAdn, index, pin2, response);
                this.waitForResult(status);
            } else {
                this.loge("Failure while trying to update by index due to uninitialised adncache");
            }
        }
        return this.mSuccess;
    }

    public abstract int[] getAdnRecordsSize(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AdnRecord> getAdnRecordsInEf(int efid) {
        if (this.mPhone.getContext().checkCallingOrSelfPermission("android.permission.READ_CONTACTS") != 0) {
            throw new SecurityException("Requires android.permission.READ_CONTACTS permission");
        }
        efid = this.updateEfForIccType(efid);
        this.logd("getAdnRecordsInEF: efid=" + efid);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            AtomicBoolean status = new AtomicBoolean(false);
            Message response = this.mBaseHandler.obtainMessage(2, status);
            if (this.mAdnCache != null) {
                this.mAdnCache.requestLoadAllAdnLike(efid, this.mAdnCache.extensionEfForEf(efid), response);
                this.waitForResult(status);
            } else {
                this.loge("Failure while trying to load from SIM due to uninitialised adncache");
            }
        }
        return this.mRecords;
    }

    protected void checkThread() {
        if (this.mBaseHandler.getLooper().equals(Looper.myLooper())) {
            this.loge("query() called on the main UI thread!");
            throw new IllegalStateException("You cannot call query on this provder from the main UI thread.");
        }
    }

    protected void waitForResult(AtomicBoolean status) {
        while (!status.get()) {
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.logd("interrupted while trying to update by search");
            }
        }
    }

    private int updateEfForIccType(int efid) {
        if (efid == 28474 && this.mPhone.getCurrentUiccAppType() == IccCardApplicationStatus.AppType.APPTYPE_USIM) {
            return 20272;
        }
        return efid;
    }
}

