/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telecom.VideoProfile;
import android.telephony.CellIdentityCdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.VoLteServiceState;
import android.text.TextUtils;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyTester;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class PhoneBase
extends Handler
implements Phone {
    private static final String LOG_TAG = "PhoneBase";
    private boolean mImsIntentReceiverRegistered = false;
    private BroadcastReceiver mImsIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Rlog.d(PhoneBase.LOG_TAG, "mImsIntentReceiver: action " + intent.getAction());
            if (intent.hasExtra("android:phone_id")) {
                int extraPhoneId = intent.getIntExtra("android:phone_id", -1);
                Rlog.d(PhoneBase.LOG_TAG, "mImsIntentReceiver: extraPhoneId = " + extraPhoneId);
                if (extraPhoneId == -1 || extraPhoneId != PhoneBase.this.getPhoneId()) {
                    return;
                }
            }
            Object object = PhoneProxy.lockForRadioTechnologyChange;
            synchronized (object) {
                if (intent.getAction().equals("com.android.ims.IMS_SERVICE_UP")) {
                    PhoneBase.this.mImsServiceReady = true;
                    PhoneBase.this.updateImsPhone();
                } else if (intent.getAction().equals("com.android.ims.IMS_SERVICE_DOWN")) {
                    PhoneBase.this.mImsServiceReady = false;
                    PhoneBase.this.updateImsPhone();
                }
            }
        }
    };
    public static final String NETWORK_SELECTION_KEY = "network_selection_key";
    public static final String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public static final String NETWORK_SELECTION_SHORT_KEY = "network_selection_short_key";
    public static final String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    protected static final int EVENT_RADIO_AVAILABLE = 1;
    protected static final int EVENT_SSN = 2;
    protected static final int EVENT_SIM_RECORDS_LOADED = 3;
    protected static final int EVENT_MMI_DONE = 4;
    protected static final int EVENT_RADIO_ON = 5;
    protected static final int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    protected static final int EVENT_USSD = 7;
    protected static final int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    protected static final int EVENT_GET_IMEI_DONE = 9;
    protected static final int EVENT_GET_IMEISV_DONE = 10;
    protected static final int EVENT_GET_SIM_STATUS_DONE = 11;
    protected static final int EVENT_SET_CALL_FORWARD_DONE = 12;
    protected static final int EVENT_GET_CALL_FORWARD_DONE = 13;
    protected static final int EVENT_CALL_RING = 14;
    protected static final int EVENT_CALL_RING_CONTINUE = 15;
    protected static final int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    protected static final int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    protected static final int EVENT_SET_CLIR_COMPLETE = 18;
    protected static final int EVENT_REGISTERED_TO_NETWORK = 19;
    protected static final int EVENT_SET_VM_NUMBER_DONE = 20;
    protected static final int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 22;
    protected static final int EVENT_NV_READY = 23;
    protected static final int EVENT_SET_ENHANCED_VP = 24;
    protected static final int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    protected static final int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    protected static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 27;
    protected static final int EVENT_SET_NETWORK_AUTOMATIC = 28;
    protected static final int EVENT_ICC_RECORD_EVENTS = 29;
    protected static final int EVENT_ICC_CHANGED = 30;
    protected static final int EVENT_SRVCC_STATE_CHANGED = 31;
    protected static final int EVENT_INITIATE_SILENT_REDIAL = 32;
    protected static final int EVENT_RADIO_NOT_AVAILABLE = 33;
    protected static final int EVENT_UNSOL_OEM_HOOK_RAW = 34;
    protected static final int EVENT_GET_RADIO_CAPABILITY = 35;
    protected static final int EVENT_SS = 36;
    protected static final int EVENT_CONFIG_LCE = 37;
    private static final int EVENT_CHECK_FOR_NETWORK_AUTOMATIC = 38;
    protected static final int EVENT_LAST = 38;
    private static final String GSM_ROAMING_LIST_OVERRIDE_PREFIX = "gsm_roaming_list_";
    private static final String GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX = "gsm_non_roaming_list_";
    private static final String CDMA_ROAMING_LIST_OVERRIDE_PREFIX = "cdma_roaming_list_";
    private static final String CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX = "cdma_non_roaming_list_";
    public static final String CLIR_KEY = "clir_key";
    public static final String VM_COUNT = "vm_count_key";
    public static final String VM_ID = "vm_id_key";
    public static final String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    public CommandsInterface mCi;
    private int mVmCount = 0;
    boolean mDnsCheckDisabled;
    public DcTrackerBase mDcTracker;
    boolean mDoesRilSendMultipleCallRing;
    int mCallRingContinueToken;
    int mCallRingDelay;
    public boolean mIsTheCurrentActivePhone = true;
    boolean mIsVoiceCapable = true;
    protected boolean mIsVideoCapable = false;
    protected UiccController mUiccController = null;
    public final AtomicReference<IccRecords> mIccRecords = new AtomicReference();
    public SmsStorageMonitor mSmsStorageMonitor;
    public SmsUsageMonitor mSmsUsageMonitor;
    protected AtomicReference<UiccCardApplication> mUiccApplication = new AtomicReference();
    private TelephonyTester mTelephonyTester;
    private final String mName;
    private final String mActionDetached;
    private final String mActionAttached;
    protected int mPhoneId;
    private boolean mImsServiceReady = false;
    protected ImsPhone mImsPhone = null;
    private final AtomicReference<RadioCapability> mRadioCapability = new AtomicReference();
    protected static final int DEFAULT_REPORT_INTERVAL_MS = 200;
    protected static final boolean LCE_PULL_MODE = true;
    protected int mReportInterval = 0;
    protected int mLceStatus = -1;
    protected final RegistrantList mPreciseCallStateRegistrants = new RegistrantList();
    protected final RegistrantList mHandoverRegistrants = new RegistrantList();
    protected final RegistrantList mNewRingingConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mIncomingRingRegistrants = new RegistrantList();
    protected final RegistrantList mDisconnectRegistrants = new RegistrantList();
    protected final RegistrantList mServiceStateRegistrants = new RegistrantList();
    protected final RegistrantList mMmiCompleteRegistrants = new RegistrantList();
    protected final RegistrantList mMmiRegistrants = new RegistrantList();
    protected final RegistrantList mUnknownConnectionRegistrants = new RegistrantList();
    protected final RegistrantList mSuppServiceFailedRegistrants = new RegistrantList();
    protected final RegistrantList mRadioOffOrNotAvailableRegistrants = new RegistrantList();
    protected final RegistrantList mSimRecordsLoadedRegistrants = new RegistrantList();
    protected final RegistrantList mVideoCapabilityChangedRegistrants = new RegistrantList();
    protected final RegistrantList mEmergencyCallToggledRegistrants = new RegistrantList();
    protected Looper mLooper;
    protected final Context mContext;
    protected PhoneNotifier mNotifier;
    protected SimulatedRadioControl mSimulatedRadioControl;
    boolean mUnitTestMode;

    @Override
    public String getPhoneName() {
        return this.mName;
    }

    @Override
    public String getNai() {
        return null;
    }

    public String getActionDetached() {
        return this.mActionDetached;
    }

    public String getActionAttached() {
        return this.mActionAttached;
    }

    public void setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(property, value);
    }

    public String getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return SystemProperties.get(property, defValue);
    }

    protected PhoneBase(String name, PhoneNotifier notifier, Context context, CommandsInterface ci) {
        this(name, notifier, context, ci, false);
    }

    protected PhoneBase(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode) {
        this(name, notifier, context, ci, unitTestMode, Integer.MAX_VALUE);
    }

    protected PhoneBase(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode, int phoneId) {
        this.mPhoneId = phoneId;
        this.mName = name;
        this.mNotifier = notifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.mCi = ci;
        this.mActionDetached = this.getClass().getPackage().getName() + ".action_detached";
        this.mActionAttached = this.getClass().getPackage().getName() + ".action_attached";
        if (Build.IS_DEBUGGABLE) {
            this.mTelephonyTester = new TelephonyTester(this);
        }
        this.setUnitTestMode(unitTestMode);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        this.mDnsCheckDisabled = sp.getBoolean(DNS_SERVER_CHECK_DISABLED_KEY, false);
        this.mCi.setOnCallRing(this, 14, null);
        this.mIsVoiceCapable = this.mContext.getResources().getBoolean(17956947);
        this.mDoesRilSendMultipleCallRing = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        Rlog.d(LOG_TAG, "mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        this.mCallRingDelay = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        Rlog.d(LOG_TAG, "mCallRingDelay=" + this.mCallRingDelay);
        if (this.getPhoneType() == 5) {
            return;
        }
        Locale carrierLocale = PhoneBase.getLocaleFromCarrierProperties(this.mContext);
        if (carrierLocale != null && !TextUtils.isEmpty(carrierLocale.getCountry())) {
            String country = carrierLocale.getCountry();
            try {
                Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_country_code");
            }
            catch (Settings.SettingNotFoundException e) {
                WifiManager wM = (WifiManager)this.mContext.getSystemService("wifi");
                wM.setCountryCode(country, false);
            }
        }
        this.mSmsStorageMonitor = new SmsStorageMonitor(this);
        this.mSmsUsageMonitor = new SmsUsageMonitor(context);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 30, null);
        if (this.getPhoneType() != 3) {
            this.mCi.registerForSrvccStateChanged(this, 31, null);
        }
        this.mCi.setOnUnsolOemHookRaw(this, 34, null);
        this.mCi.startLceService(200, true, this.obtainMessage(37));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startMonitoringImsService() {
        if (this.getPhoneType() == 3) {
            return;
        }
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.android.ims.IMS_SERVICE_UP");
            filter.addAction("com.android.ims.IMS_SERVICE_DOWN");
            this.mContext.registerReceiver(this.mImsIntentReceiver, filter);
            this.mImsIntentReceiverRegistered = true;
            ImsManager imsManager = ImsManager.getInstance((Context)this.mContext, (int)this.getPhoneId());
            if (imsManager != null && imsManager.isServiceAvailable()) {
                this.mImsServiceReady = true;
                this.updateImsPhone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            ImsPhone imsPhone;
            if (this.mImsIntentReceiverRegistered) {
                this.mContext.unregisterReceiver(this.mImsIntentReceiver);
                this.mImsIntentReceiverRegistered = false;
            }
            this.mCi.unSetOnCallRing(this);
            this.mDcTracker.cleanUpAllConnections(null);
            this.mIsTheCurrentActivePhone = false;
            this.mSmsStorageMonitor.dispose();
            this.mSmsUsageMonitor.dispose();
            this.mUiccController.unregisterForIccChanged(this);
            this.mCi.unregisterForSrvccStateChanged(this);
            this.mCi.unSetOnUnsolOemHookRaw(this);
            this.mCi.stopLceService(this.obtainMessage(37));
            if (this.mTelephonyTester != null) {
                this.mTelephonyTester.dispose();
            }
            if ((imsPhone = this.mImsPhone) != null) {
                imsPhone.unregisterForSilentRedial(this);
                imsPhone.dispose();
            }
        }
    }

    @Override
    public void removeReferences() {
        this.mSmsStorageMonitor = null;
        this.mSmsUsageMonitor = null;
        this.mIccRecords.set(null);
        this.mUiccApplication.set(null);
        this.mDcTracker = null;
        this.mUiccController = null;
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null) {
            imsPhone.removeReferences();
            this.mImsPhone = null;
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 16: 
            case 17: {
                this.handleSetSelectNetwork((AsyncResult)msg.obj);
                return;
            }
        }
        if (!this.mIsTheCurrentActivePhone) {
            Rlog.e(LOG_TAG, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 14: {
                Rlog.d(LOG_TAG, "Event EVENT_CALL_RING Received state=" + (Object)((Object)this.getState()));
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                PhoneConstants.State state = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state != PhoneConstants.State.RINGING && state != PhoneConstants.State.IDLE)) {
                    ++this.mCallRingContinueToken;
                    this.sendIncomingCallRingNotification(this.mCallRingContinueToken);
                    break;
                }
                this.notifyIncomingRing();
                break;
            }
            case 15: {
                Rlog.d(LOG_TAG, "Event EVENT_CALL_RING_CONTINUE Received stat=" + (Object)((Object)this.getState()));
                if (this.getState() != PhoneConstants.State.RINGING) break;
                this.sendIncomingCallRingNotification(msg.arg1);
                break;
            }
            case 30: {
                this.onUpdateIccAvailability();
                break;
            }
            case 32: {
                Rlog.d(LOG_TAG, "Event EVENT_INITIATE_SILENT_REDIAL Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || ar.result == null) break;
                String dialString = (String)ar.result;
                if (TextUtils.isEmpty(dialString)) {
                    return;
                }
                try {
                    this.dialInternal(dialString, null, 0, null);
                }
                catch (CallStateException e) {
                    Rlog.e(LOG_TAG, "silent redial failed: " + e);
                }
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleSrvccStateChanged((int[])ar.result);
                    break;
                }
                Rlog.e(LOG_TAG, "Srvcc exception: " + ar.exception);
                break;
            }
            case 34: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    Rlog.d(LOG_TAG, "EVENT_UNSOL_OEM_HOOK_RAW data=" + IccUtils.bytesToHexString(data));
                    this.mNotifier.notifyOemHookRawEventForSubscriber(this.getSubId(), data);
                    break;
                }
                Rlog.e(LOG_TAG, "OEM hook raw exception: " + ar.exception);
                break;
            }
            case 35: {
                AsyncResult ar = (AsyncResult)msg.obj;
                RadioCapability rc = (RadioCapability)ar.result;
                if (ar.exception != null) {
                    Rlog.d(LOG_TAG, "get phone radio capability fail,no need to change mRadioCapability");
                } else {
                    this.radioCapabilityUpdated(rc);
                }
                Rlog.d(LOG_TAG, "EVENT_GET_RADIO_CAPABILITY :phone rc : " + rc);
                break;
            }
            case 37: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.d(LOG_TAG, "config LCE service failed: " + ar.exception);
                    break;
                }
                ArrayList statusInfo = (ArrayList)ar.result;
                this.mLceStatus = (Integer)statusInfo.get(0);
                this.mReportInterval = (Integer)statusInfo.get(1);
                break;
            }
            case 38: {
                this.onCheckForNetworkSelectionModeAutomatic(msg);
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    private void handleSrvccStateChanged(int[] ret) {
        Rlog.d(LOG_TAG, "handleSrvccStateChanged");
        ArrayList<Connection> conn = null;
        ImsPhone imsPhone = this.mImsPhone;
        Call.SrvccState srvccState = Call.SrvccState.NONE;
        if (ret != null && ret.length != 0) {
            int state = ret[0];
            switch (state) {
                case 0: {
                    srvccState = Call.SrvccState.STARTED;
                    if (imsPhone != null) {
                        conn = imsPhone.getHandoverConnection();
                        this.migrateFrom(imsPhone);
                        break;
                    }
                    Rlog.d(LOG_TAG, "HANDOVER_STARTED: mImsPhone null");
                    break;
                }
                case 1: {
                    srvccState = Call.SrvccState.COMPLETED;
                    if (imsPhone != null) {
                        imsPhone.notifySrvccState(srvccState);
                        break;
                    }
                    Rlog.d(LOG_TAG, "HANDOVER_COMPLETED: mImsPhone null");
                    break;
                }
                case 2: 
                case 3: {
                    srvccState = Call.SrvccState.FAILED;
                    break;
                }
                default: {
                    return;
                }
            }
            this.getCallTracker().notifySrvccState(srvccState, conn);
            VoLteServiceState lteState = new VoLteServiceState(state);
            this.notifyVoLteServiceStateChanged(lteState);
        }
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    protected abstract void onUpdateIccAvailability();

    @Override
    public void disableDnsCheck(boolean b) {
        this.mDnsCheckDisabled = b;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean(DNS_SERVER_CHECK_DISABLED_KEY, b);
        editor.apply();
    }

    @Override
    public boolean isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    @Override
    public void registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    protected void notifyPreciseCallStateChangedP() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyPreciseCallState(this);
    }

    @Override
    public void registerForHandoverStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mHandoverRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForHandoverStateChanged(Handler h) {
        this.mHandoverRegistrants.remove(h);
    }

    public void notifyHandoverStateChanged(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mHandoverRegistrants.notifyRegistrants(ar);
    }

    public void migrateFrom(PhoneBase from) {
        this.migrate(this.mHandoverRegistrants, from.mHandoverRegistrants);
        this.migrate(this.mPreciseCallStateRegistrants, from.mPreciseCallStateRegistrants);
        this.migrate(this.mNewRingingConnectionRegistrants, from.mNewRingingConnectionRegistrants);
        this.migrate(this.mIncomingRingRegistrants, from.mIncomingRingRegistrants);
        this.migrate(this.mDisconnectRegistrants, from.mDisconnectRegistrants);
        this.migrate(this.mServiceStateRegistrants, from.mServiceStateRegistrants);
        this.migrate(this.mMmiCompleteRegistrants, from.mMmiCompleteRegistrants);
        this.migrate(this.mMmiRegistrants, from.mMmiRegistrants);
        this.migrate(this.mUnknownConnectionRegistrants, from.mUnknownConnectionRegistrants);
        this.migrate(this.mSuppServiceFailedRegistrants, from.mSuppServiceFailedRegistrants);
    }

    public void migrate(RegistrantList to, RegistrantList from) {
        from.removeCleared();
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            to.add((Registrant)from.get(i));
        }
    }

    @Override
    public void registerForUnknownConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    @Override
    public void registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    @Override
    public void registerForVideoCapabilityChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mVideoCapabilityChangedRegistrants.addUnique(h, what, obj);
        this.notifyForVideoCapabilityChanged(this.mIsVideoCapable);
    }

    @Override
    public void unregisterForVideoCapabilityChanged(Handler h) {
        this.mVideoCapabilityChangedRegistrants.remove(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOn(h);
    }

    @Override
    public void registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    @Override
    public void unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOff(h);
    }

    @Override
    public void registerForIncomingRing(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    @Override
    public void registerForDisconnect(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    @Override
    public void registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    @Override
    public void registerForMmiInitiate(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForMmiInitiate(Handler h) {
        this.mMmiRegistrants.remove(h);
    }

    @Override
    public void registerForMmiComplete(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForMmiComplete(Handler h) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.remove(h);
    }

    @Override
    public void registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForSimRecordsLoaded");
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForSimRecordsLoaded");
    }

    @Override
    public void registerForTtyModeReceived(Handler h, int what, Object obj) {
    }

    @Override
    public void unregisterForTtyModeReceived(Handler h) {
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message response) {
        Rlog.d(LOG_TAG, "setNetworkSelectionModeAutomatic, querying current mode");
        Message msg = this.obtainMessage(38);
        msg.obj = response;
        this.mCi.getNetworkSelectionMode(msg);
    }

    private void onCheckForNetworkSelectionModeAutomatic(Message fromRil) {
        AsyncResult ar = (AsyncResult)fromRil.obj;
        Message response = (Message)ar.userObj;
        boolean doAutomatic = true;
        if (ar.exception == null && ar.result != null) {
            try {
                int[] modes = (int[])ar.result;
                if (modes[0] == 0) {
                    doAutomatic = false;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (doAutomatic) {
            NetworkSelectMessage nsm = new NetworkSelectMessage();
            nsm.message = response;
            nsm.operatorNumeric = "";
            nsm.operatorAlphaLong = "";
            nsm.operatorAlphaShort = "";
            Message msg = this.obtainMessage(17, nsm);
            this.mCi.setNetworkSelectionModeAutomatic(msg);
            this.updateSavedNetworkOperator(nsm);
        } else {
            Rlog.d(LOG_TAG, "setNetworkSelectionModeAutomatic - already auto, ignoring");
        }
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        this.mCi.getNetworkSelectionMode(message);
    }

    @Override
    public void selectNetworkManually(OperatorInfo network, Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = network.getOperatorNumeric();
        nsm.operatorAlphaLong = network.getOperatorAlphaLong();
        nsm.operatorAlphaShort = network.getOperatorAlphaShort();
        Message msg = this.obtainMessage(16, nsm);
        this.mCi.setNetworkSelectionModeManual(network.getOperatorNumeric(), msg);
        this.updateSavedNetworkOperator(nsm);
    }

    public void registerForEmergencyCallToggle(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEmergencyCallToggledRegistrants.add(r);
    }

    public void unregisterForEmergencyCallToggle(Handler h) {
        this.mEmergencyCallToggledRegistrants.remove(h);
    }

    private void updateSavedNetworkOperator(NetworkSelectMessage nsm) {
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(NETWORK_SELECTION_KEY + subId, nsm.operatorNumeric);
            editor.putString(NETWORK_SELECTION_NAME_KEY + subId, nsm.operatorAlphaLong);
            editor.putString(NETWORK_SELECTION_SHORT_KEY + subId, nsm.operatorAlphaShort);
            if (!editor.commit()) {
                Rlog.e(LOG_TAG, "failed to commit network selection preference");
            }
        } else {
            Rlog.e(LOG_TAG, "Cannot update network selection preference due to invalid subId " + subId);
        }
    }

    private void handleSetSelectNetwork(AsyncResult ar) {
        if (!(ar.userObj instanceof NetworkSelectMessage)) {
            Rlog.e(LOG_TAG, "unexpected result from user object.");
            return;
        }
        NetworkSelectMessage nsm = (NetworkSelectMessage)ar.userObj;
        if (nsm.message != null) {
            AsyncResult.forMessage(nsm.message, ar.result, ar.exception);
            nsm.message.sendToTarget();
        }
    }

    private OperatorInfo getSavedNetworkSelection() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        String numeric = sp.getString(NETWORK_SELECTION_KEY + this.getSubId(), "");
        String name = sp.getString(NETWORK_SELECTION_NAME_KEY + this.getSubId(), "");
        String shrt = sp.getString(NETWORK_SELECTION_SHORT_KEY + this.getSubId(), "");
        return new OperatorInfo(numeric, name, shrt);
    }

    public void restoreSavedNetworkSelection(Message response) {
        OperatorInfo networkSelection = this.getSavedNetworkSelection();
        if (networkSelection == null || TextUtils.isEmpty(networkSelection.getOperatorNumeric())) {
            this.setNetworkSelectionModeAutomatic(response);
        } else {
            this.selectNetworkManually(networkSelection, response);
        }
    }

    @Override
    public void setUnitTestMode(boolean f) {
        this.mUnitTestMode = f;
    }

    @Override
    public boolean getUnitTestMode() {
        return this.mUnitTestMode;
    }

    protected void notifyDisconnectP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mDisconnectRegistrants.notifyRegistrants(ar);
    }

    @Override
    public void registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mServiceStateRegistrants.add(h, what, obj);
    }

    @Override
    public void unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateRegistrants.remove(h);
    }

    @Override
    public void registerForRingbackTone(Handler h, int what, Object obj) {
        this.mCi.registerForRingbackTone(h, what, obj);
    }

    @Override
    public void unregisterForRingbackTone(Handler h) {
        this.mCi.unregisterForRingbackTone(h);
    }

    @Override
    public void registerForOnHoldTone(Handler h, int what, Object obj) {
    }

    @Override
    public void unregisterForOnHoldTone(Handler h) {
    }

    @Override
    public void registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mCi.registerForResendIncallMute(h, what, obj);
    }

    @Override
    public void unregisterForResendIncallMute(Handler h) {
        this.mCi.unregisterForResendIncallMute(h);
    }

    @Override
    public void setEchoSuppressionEnabled() {
    }

    protected void notifyServiceStateChangedP(ServiceState ss) {
        AsyncResult ar = new AsyncResult(null, ss, null);
        this.mServiceStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyServiceState(this);
    }

    @Override
    public SimulatedRadioControl getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    private void checkCorrectThread(Handler h) {
        if (h.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    private static Locale getLocaleFromCarrierProperties(Context ctx) {
        String carrier = SystemProperties.get("ro.carrier");
        if (null == carrier || 0 == carrier.length() || "unknown".equals(carrier)) {
            return null;
        }
        CharSequence[] carrierLocales = ctx.getResources().getTextArray(17236046);
        for (int i = 0; i < carrierLocales.length; i += 3) {
            String c = carrierLocales[i].toString();
            if (!carrier.equals(c)) continue;
            return Locale.forLanguageTag(carrierLocales[i + 1].toString().replace('_', '-'));
        }
        return null;
    }

    @Override
    public abstract PhoneConstants.State getState();

    public IccFileHandler getIccFileHandler() {
        IccFileHandler fh;
        UiccCardApplication uiccApplication = this.mUiccApplication.get();
        if (uiccApplication == null) {
            Rlog.d(LOG_TAG, "getIccFileHandler: uiccApplication == null, return null");
            fh = null;
        } else {
            fh = uiccApplication.getIccFileHandler();
        }
        Rlog.d(LOG_TAG, "getIccFileHandler: fh=" + fh);
        return fh;
    }

    public Handler getHandler() {
        return this;
    }

    @Override
    public void updatePhoneObject(int voiceRadioTech) {
        PhoneFactory.getDefaultPhone().updatePhoneObject(voiceRadioTech);
    }

    public ServiceStateTracker getServiceStateTracker() {
        return null;
    }

    public CallTracker getCallTracker() {
        return null;
    }

    public IccCardApplicationStatus.AppType getCurrentUiccAppType() {
        UiccCardApplication currentApp = this.mUiccApplication.get();
        if (currentApp != null) {
            return currentApp.getType();
        }
        return IccCardApplicationStatus.AppType.APPTYPE_UNKNOWN;
    }

    @Override
    public IccCard getIccCard() {
        return null;
    }

    @Override
    public String getIccSerialNumber() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getIccId() : null;
    }

    @Override
    public boolean getIccRecordsLoaded() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getRecordsLoaded() : false;
    }

    @Override
    public List<CellInfo> getAllCellInfo() {
        List<CellInfo> cellInfoList = this.getServiceStateTracker().getAllCellInfo();
        return this.privatizeCellInfoList(cellInfoList);
    }

    private List<CellInfo> privatizeCellInfoList(List<CellInfo> cellInfoList) {
        if (cellInfoList == null) {
            return null;
        }
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            ArrayList<CellInfo> privateCellInfoList = new ArrayList<CellInfo>(cellInfoList.size());
            for (CellInfo c : cellInfoList) {
                if (c instanceof CellInfoCdma) {
                    CellInfoCdma cellInfoCdma = (CellInfoCdma)c;
                    CellIdentityCdma cellIdentity = cellInfoCdma.getCellIdentity();
                    CellIdentityCdma maskedCellIdentity = new CellIdentityCdma(cellIdentity.getNetworkId(), cellIdentity.getSystemId(), cellIdentity.getBasestationId(), Integer.MAX_VALUE, Integer.MAX_VALUE);
                    CellInfoCdma privateCellInfoCdma = new CellInfoCdma(cellInfoCdma);
                    privateCellInfoCdma.setCellIdentity(maskedCellIdentity);
                    privateCellInfoList.add(privateCellInfoCdma);
                    continue;
                }
                privateCellInfoList.add(c);
            }
            cellInfoList = privateCellInfoList;
        }
        return cellInfoList;
    }

    @Override
    public void setCellInfoListRate(int rateInMillis) {
        this.mCi.setCellInfoListRate(rateInMillis, null);
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return this.mVmCount != 0;
    }

    @Override
    public boolean getCallForwardingIndicator() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getVoiceCallForwardingFlag() : false;
    }

    @Override
    public void queryCdmaRoamingPreference(Message response) {
        this.mCi.queryCdmaRoamingPreference(response);
    }

    @Override
    public SignalStrength getSignalStrength() {
        ServiceStateTracker sst = this.getServiceStateTracker();
        if (sst == null) {
            return new SignalStrength();
        }
        return sst.getSignalStrength();
    }

    @Override
    public void setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mCi.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    @Override
    public void setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mCi.setCdmaSubscriptionSource(cdmaSubscriptionType, response);
    }

    @Override
    public void setPreferredNetworkType(int networkType, Message response) {
        int modemRaf = this.getRadioAccessFamily();
        int rafFromType = RadioAccessFamily.getRafFromNetworkType(networkType);
        if (modemRaf == 1 || rafFromType == 1) {
            Rlog.d(LOG_TAG, "setPreferredNetworkType: Abort, unknown RAF: " + modemRaf + " " + rafFromType);
            if (response != null) {
                CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                AsyncResult.forMessage(response, null, ex);
                response.sendToTarget();
            }
            return;
        }
        int filteredRaf = rafFromType & modemRaf;
        int filteredType = RadioAccessFamily.getNetworkTypeFromRaf(filteredRaf);
        Rlog.d(LOG_TAG, "setPreferredNetworkType: networkType = " + networkType + " modemRaf = " + modemRaf + " rafFromType = " + rafFromType + " filteredType = " + filteredType);
        this.mCi.setPreferredNetworkType(filteredType, response);
    }

    @Override
    public void getPreferredNetworkType(Message response) {
        this.mCi.getPreferredNetworkType(response);
    }

    @Override
    public void getSmscAddress(Message result) {
        this.mCi.getSmscAddress(result);
    }

    @Override
    public void setSmscAddress(String address, Message result) {
        this.mCi.setSmscAddress(address, result);
    }

    @Override
    public void setTTYMode(int ttyMode, Message onComplete) {
        this.mCi.setTTYMode(ttyMode, onComplete);
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        Rlog.d(LOG_TAG, "unexpected setUiTTYMode method call");
    }

    @Override
    public void queryTTYMode(Message onComplete) {
        this.mCi.queryTTYMode(onComplete);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        PhoneBase.logUnexpectedCdmaMethodCall("enableEnhancedVoicePrivacy");
    }

    @Override
    public void getEnhancedVoicePrivacy(Message onComplete) {
        PhoneBase.logUnexpectedCdmaMethodCall("getEnhancedVoicePrivacy");
    }

    @Override
    public void setBandMode(int bandMode, Message response) {
        this.mCi.setBandMode(bandMode, response);
    }

    @Override
    public void queryAvailableBandMode(Message response) {
        this.mCi.queryAvailableBandMode(response);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mCi.invokeOemRilRequestRaw(data, response);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mCi.invokeOemRilRequestStrings(strings, response);
    }

    @Override
    public void nvReadItem(int itemID, Message response) {
        this.mCi.nvReadItem(itemID, response);
    }

    @Override
    public void nvWriteItem(int itemID, String itemValue, Message response) {
        this.mCi.nvWriteItem(itemID, itemValue, response);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.mCi.nvWriteCdmaPrl(preferredRoamingList, response);
    }

    @Override
    public void nvResetConfig(int resetType, Message response) {
        this.mCi.nvResetConfig(resetType, response);
    }

    @Override
    public void notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    public void notifyMessageWaitingIndicator() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    public void notifyDataConnection(String reason, String apnType, PhoneConstants.DataState state) {
        this.mNotifier.notifyDataConnection(this, reason, apnType, state);
    }

    public void notifyDataConnection(String reason, String apnType) {
        this.mNotifier.notifyDataConnection(this, reason, apnType, this.getDataConnectionState(apnType));
    }

    public void notifyDataConnection(String reason) {
        String[] types;
        for (String apnType : types = this.getActiveApnTypes()) {
            this.mNotifier.notifyDataConnection(this, reason, apnType, this.getDataConnectionState(apnType));
        }
    }

    public void notifyOtaspChanged(int otaspMode) {
        this.mNotifier.notifyOtaspChanged(this, otaspMode);
    }

    public void notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    public void notifyCellInfo(List<CellInfo> cellInfo) {
        this.mNotifier.notifyCellInfo(this, this.privatizeCellInfoList(cellInfo));
    }

    public void notifyDataConnectionRealTimeInfo(DataConnectionRealTimeInfo dcRtInfo) {
        this.mNotifier.notifyDataConnectionRealTimeInfo(this, dcRtInfo);
    }

    public void notifyVoLteServiceStateChanged(VoLteServiceState lteState) {
        this.mNotifier.notifyVoLteServiceStateChanged(this, lteState);
    }

    public boolean isInEmergencyCall() {
        return false;
    }

    @Override
    public boolean isInEcm() {
        return false;
    }

    private static int getVideoState(Call call) {
        int videoState = 0;
        ImsPhoneConnection conn = (ImsPhoneConnection)call.getEarliestConnection();
        if (conn != null) {
            videoState = conn.getVideoState();
        }
        return videoState;
    }

    private boolean isVideoCall(Call call) {
        int videoState = PhoneBase.getVideoState(call);
        return VideoProfile.isVideo(videoState);
    }

    @Override
    public boolean isVideoCallPresent() {
        boolean isVideoCallActive = false;
        if (this.mImsPhone != null) {
            isVideoCallActive = this.isVideoCall(this.mImsPhone.getForegroundCall()) || this.isVideoCall(this.mImsPhone.getBackgroundCall()) || this.isVideoCall(this.mImsPhone.getRingingCall());
        }
        Rlog.d(LOG_TAG, "isVideoCallActive: " + isVideoCallActive);
        return isVideoCallActive;
    }

    @Override
    public abstract int getPhoneType();

    @Override
    public int getVoiceMessageCount() {
        return this.mVmCount;
    }

    public void setVoiceMessageCount(int countWaiting) {
        this.mVmCount = countWaiting;
        this.notifyMessageWaitingIndicator();
    }

    protected int getStoredVoiceMessageCount() {
        int countVoiceMessages = 0;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        String subscriberId = sp.getString(VM_ID, null);
        String currentSubscriberId = this.getSubscriberId();
        if (subscriberId != null && currentSubscriberId != null && currentSubscriberId.equals(subscriberId)) {
            countVoiceMessages = sp.getInt(VM_COUNT, 0);
            Rlog.d(LOG_TAG, "Voice Mail Count from preference = " + countVoiceMessages);
        } else {
            Rlog.d(LOG_TAG, "Voicemail count retrieval returning 0 as count for matching subscriberId not found");
        }
        return countVoiceMessages;
    }

    @Override
    public int getCdmaEriIconIndex() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaEriIconIndex");
        return -1;
    }

    @Override
    public int getCdmaEriIconMode() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaEriIconMode");
        return -1;
    }

    @Override
    public String getCdmaEriText() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaEriText");
        return "GSM nw, no ERI";
    }

    @Override
    public String getCdmaMin() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaMin");
        return null;
    }

    @Override
    public boolean isMinInfoReady() {
        PhoneBase.logUnexpectedCdmaMethodCall("isMinInfoReady");
        return false;
    }

    @Override
    public String getCdmaPrlVersion() {
        PhoneBase.logUnexpectedCdmaMethodCall("getCdmaPrlVersion");
        return null;
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        PhoneBase.logUnexpectedCdmaMethodCall("sendBurstDtmf");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        PhoneBase.logUnexpectedCdmaMethodCall("exitEmergencyCallbackMode");
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForCdmaOtaStatusChange");
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForCdmaOtaStatusChange");
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForSubscriptionInfoReady");
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForSubscriptionInfoReady");
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return false;
    }

    @Override
    public boolean isOtaSpNumber(String dialStr) {
        return false;
    }

    @Override
    public void registerForCallWaiting(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForCallWaiting");
    }

    @Override
    public void unregisterForCallWaiting(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForCallWaiting");
    }

    @Override
    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("registerForEcmTimerReset");
    }

    @Override
    public void unregisterForEcmTimerReset(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unregisterForEcmTimerReset");
    }

    @Override
    public void registerForSignalInfo(Handler h, int what, Object obj) {
        this.mCi.registerForSignalInfo(h, what, obj);
    }

    @Override
    public void unregisterForSignalInfo(Handler h) {
        this.mCi.unregisterForSignalInfo(h);
    }

    @Override
    public void registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mCi.registerForDisplayInfo(h, what, obj);
    }

    @Override
    public void unregisterForDisplayInfo(Handler h) {
        this.mCi.unregisterForDisplayInfo(h);
    }

    @Override
    public void registerForNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForNumberInfo(Handler h) {
        this.mCi.unregisterForNumberInfo(h);
    }

    @Override
    public void registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForRedirectedNumberInfo(h, what, obj);
    }

    @Override
    public void unregisterForRedirectedNumberInfo(Handler h) {
        this.mCi.unregisterForRedirectedNumberInfo(h);
    }

    @Override
    public void registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForLineControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForLineControlInfo(Handler h) {
        this.mCi.unregisterForLineControlInfo(h);
    }

    @Override
    public void registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mCi.registerFoT53ClirlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53ClirInfo(Handler h) {
        this.mCi.unregisterForT53ClirInfo(h);
    }

    @Override
    public void registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForT53AudioControlInfo(h, what, obj);
    }

    @Override
    public void unregisterForT53AudioControlInfo(Handler h) {
        this.mCi.unregisterForT53AudioControlInfo(h);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        PhoneBase.logUnexpectedCdmaMethodCall("setOnEcbModeExitResponse");
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        PhoneBase.logUnexpectedCdmaMethodCall("unsetOnEcbModeExitResponse");
    }

    @Override
    public void registerForRadioOffOrNotAvailable(Handler h, int what, Object obj) {
        this.mRadioOffOrNotAvailableRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForRadioOffOrNotAvailable(Handler h) {
        this.mRadioOffOrNotAvailableRegistrants.remove(h);
    }

    @Override
    public String[] getActiveApnTypes() {
        return this.mDcTracker.getActiveApnTypes();
    }

    @Override
    public boolean hasMatchedTetherApnSetting() {
        return this.mDcTracker.hasMatchedTetherApnSetting();
    }

    @Override
    public String getActiveApnHost(String apnType) {
        return this.mDcTracker.getActiveApnString(apnType);
    }

    @Override
    public LinkProperties getLinkProperties(String apnType) {
        return this.mDcTracker.getLinkProperties(apnType);
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(String apnType) {
        return this.mDcTracker.getNetworkCapabilities(apnType);
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return this.isDataConnectivityPossible("default");
    }

    @Override
    public boolean isDataConnectivityPossible(String apnType) {
        return this.mDcTracker != null && this.mDcTracker.isDataPossible(apnType);
    }

    public void notifyNewRingingConnectionP(Connection cn) {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(ar);
    }

    public void notifyForVideoCapabilityChanged(boolean isVideoCallCapable) {
        this.mIsVideoCapable = isVideoCallCapable;
        AsyncResult ar = new AsyncResult(null, isVideoCallCapable, null);
        this.mVideoCapabilityChangedRegistrants.notifyRegistrants(ar);
    }

    private void notifyIncomingRing() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(ar);
    }

    private void sendIncomingCallRingNotification(int token) {
        if (this.mIsVoiceCapable && !this.mDoesRilSendMultipleCallRing && token == this.mCallRingContinueToken) {
            Rlog.d(LOG_TAG, "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            this.sendMessageDelayed(this.obtainMessage(15, token, 0), this.mCallRingDelay);
        } else {
            Rlog.d(LOG_TAG, "Ignoring ring notification request, mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing + " token=" + token + " mCallRingContinueToken=" + this.mCallRingContinueToken + " mIsVoiceCapable=" + this.mIsVoiceCapable);
        }
    }

    @Override
    public boolean isCspPlmnEnabled() {
        PhoneBase.logUnexpectedGsmMethodCall("isCspPlmnEnabled");
        return false;
    }

    @Override
    public IsimRecords getIsimRecords() {
        Rlog.e(LOG_TAG, "getIsimRecords() is only supported on LTE devices");
        return null;
    }

    @Override
    public String getMsisdn() {
        PhoneBase.logUnexpectedGsmMethodCall("getMsisdn");
        return null;
    }

    private static void logUnexpectedCdmaMethodCall(String name) {
        Rlog.e(LOG_TAG, "Error! " + name + "() in PhoneBase should not be " + "called, CDMAPhone inactive.");
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState() {
        return this.getDataConnectionState("default");
    }

    private static void logUnexpectedGsmMethodCall(String name) {
        Rlog.e(LOG_TAG, "Error! " + name + "() in PhoneBase should not be " + "called, GSMPhone inactive.");
    }

    public void notifyCallForwardingIndicator() {
        Rlog.e(LOG_TAG, "Error! This function should never be executed, inactive CDMAPhone.");
    }

    public void notifyDataConnectionFailed(String reason, String apnType) {
        this.mNotifier.notifyDataConnectionFailed(this, reason, apnType);
    }

    public void notifyPreciseDataConnectionFailed(String reason, String apnType, String apn, String failCause) {
        this.mNotifier.notifyPreciseDataConnectionFailed(this, reason, apnType, apn, failCause);
    }

    @Override
    public int getLteOnCdmaMode() {
        return this.mCi.getLteOnCdmaMode();
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
        Rlog.e(LOG_TAG, "Error! This function should never be executed, inactive Phone.");
    }

    @Override
    public UsimServiceTable getUsimServiceTable() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getUsimServiceTable() : null;
    }

    @Override
    public UiccCard getUiccCard() {
        return this.mUiccController.getUiccCard(this.mPhoneId);
    }

    @Override
    public String[] getPcscfAddress(String apnType) {
        return this.mDcTracker.getPcscfAddress(apnType);
    }

    @Override
    public void setImsRegistrationState(boolean registered) {
        this.mDcTracker.setImsRegistrationState(registered);
    }

    @Override
    public Phone getImsPhone() {
        return this.mImsPhone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImsPhone relinquishOwnershipOfImsPhone() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            if (this.mImsPhone == null) {
                return null;
            }
            if (this.mImsIntentReceiverRegistered) {
                this.mContext.unregisterReceiver(this.mImsIntentReceiver);
                this.mImsIntentReceiverRegistered = false;
            }
            ImsPhone imsPhone = this.mImsPhone;
            this.mImsPhone = null;
            CallManager.getInstance().unregisterPhone(imsPhone);
            imsPhone.unregisterForSilentRedial(this);
            return imsPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireOwnershipOfImsPhone(ImsPhone imsPhone) {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            if (imsPhone == null) {
                return;
            }
            if (this.mImsPhone != null) {
                Rlog.e(LOG_TAG, "acquireOwnershipOfImsPhone: non-null mImsPhone. Shouldn't happen - but disposing");
                this.mImsPhone.dispose();
            }
            this.mImsPhone = imsPhone;
            this.mImsServiceReady = true;
            this.mImsPhone.updateParentPhone(this);
            CallManager.getInstance().registerPhone(this.mImsPhone);
            this.mImsPhone.registerForSilentRedial(this, 32, null);
        }
    }

    protected void updateImsPhone() {
        Rlog.d(LOG_TAG, "updateImsPhone mImsServiceReady=" + this.mImsServiceReady);
        if (this.mImsServiceReady && this.mImsPhone == null) {
            this.mImsPhone = PhoneFactory.makeImsPhone(this.mNotifier, this);
            CallManager.getInstance().registerPhone(this.mImsPhone);
            this.mImsPhone.registerForSilentRedial(this, 32, null);
        } else if (!this.mImsServiceReady && this.mImsPhone != null) {
            CallManager.getInstance().unregisterPhone(this.mImsPhone);
            this.mImsPhone.unregisterForSilentRedial(this);
            this.mImsPhone.dispose();
            this.mImsPhone = null;
        }
    }

    protected Connection dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        return null;
    }

    @Override
    public int getSubId() {
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhoneId);
    }

    @Override
    public int getPhoneId() {
        return this.mPhoneId;
    }

    @Override
    public int getVoicePhoneServiceState() {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return 0;
        }
        return this.getServiceState().getState();
    }

    @Override
    public boolean setOperatorBrandOverride(String brand) {
        return false;
    }

    @Override
    public boolean setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        String iccId = this.getIccSerialNumber();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        this.setRoamingOverrideHelper(gsmRoamingList, GSM_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        this.setRoamingOverrideHelper(gsmNonRoamingList, GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        this.setRoamingOverrideHelper(cdmaRoamingList, CDMA_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        this.setRoamingOverrideHelper(cdmaNonRoamingList, CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX, iccId);
        ServiceStateTracker tracker = this.getServiceStateTracker();
        if (tracker != null) {
            tracker.pollState();
        }
        return true;
    }

    private void setRoamingOverrideHelper(List<String> list, String prefix, String iccId) {
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = prefix + iccId;
        if (list == null || list.isEmpty()) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putStringSet(key, new HashSet<String>(list)).commit();
        }
    }

    public boolean isMccMncMarkedAsRoaming(String mccMnc) {
        return this.getRoamingOverrideHelper(GSM_ROAMING_LIST_OVERRIDE_PREFIX, mccMnc);
    }

    public boolean isMccMncMarkedAsNonRoaming(String mccMnc) {
        return this.getRoamingOverrideHelper(GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX, mccMnc);
    }

    public boolean isSidMarkedAsRoaming(int SID) {
        return this.getRoamingOverrideHelper(CDMA_ROAMING_LIST_OVERRIDE_PREFIX, Integer.toString(SID));
    }

    public boolean isSidMarkedAsNonRoaming(int SID) {
        return this.getRoamingOverrideHelper(CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX, Integer.toString(SID));
    }

    @Override
    public boolean isImsRegistered() {
        ImsPhone imsPhone = this.mImsPhone;
        boolean isImsRegistered = false;
        if (imsPhone != null) {
            isImsRegistered = imsPhone.isImsRegistered();
        } else {
            ServiceStateTracker sst = this.getServiceStateTracker();
            if (sst != null) {
                isImsRegistered = sst.isImsRegistered();
            }
        }
        Rlog.d(LOG_TAG, "isImsRegistered =" + isImsRegistered);
        return isImsRegistered;
    }

    @Override
    public boolean isWifiCallingEnabled() {
        ImsPhone imsPhone = this.mImsPhone;
        boolean isWifiCallingEnabled = false;
        if (imsPhone != null) {
            isWifiCallingEnabled = imsPhone.isVowifiEnabled();
        }
        Rlog.d(LOG_TAG, "isWifiCallingEnabled =" + isWifiCallingEnabled);
        return isWifiCallingEnabled;
    }

    @Override
    public boolean isVolteEnabled() {
        ImsPhone imsPhone = this.mImsPhone;
        boolean isVolteEnabled = false;
        if (imsPhone != null) {
            isVolteEnabled = imsPhone.isVolteEnabled();
        }
        Rlog.d(LOG_TAG, "isImsRegistered =" + isVolteEnabled);
        return isVolteEnabled;
    }

    private boolean getRoamingOverrideHelper(String prefix, String key) {
        String iccId = this.getIccSerialNumber();
        if (TextUtils.isEmpty(iccId) || TextUtils.isEmpty(key)) {
            return false;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        Set<String> value = sp.getStringSet(prefix + iccId, null);
        if (value == null) {
            return false;
        }
        return value.contains(key);
    }

    @Override
    public boolean isRadioAvailable() {
        return this.mCi.getRadioState().isAvailable();
    }

    @Override
    public boolean isRadioOn() {
        return this.mCi.getRadioState().isOn();
    }

    @Override
    public void shutdownRadio() {
        this.getServiceStateTracker().requestShutdown();
    }

    @Override
    public void setRadioCapability(RadioCapability rc, Message response) {
        this.mCi.setRadioCapability(rc, response);
    }

    @Override
    public int getRadioAccessFamily() {
        RadioCapability rc = this.getRadioCapability();
        return rc == null ? 1 : rc.getRadioAccessFamily();
    }

    @Override
    public String getModemUuId() {
        RadioCapability rc = this.getRadioCapability();
        return rc == null ? "" : rc.getLogicalModemUuid();
    }

    @Override
    public RadioCapability getRadioCapability() {
        return this.mRadioCapability.get();
    }

    @Override
    public void radioCapabilityUpdated(RadioCapability rc) {
        this.mRadioCapability.set(rc);
        if (SubscriptionManager.isValidSubscriptionId(this.getSubId())) {
            this.sendSubscriptionSettings(true);
        }
    }

    public void sendSubscriptionSettings(boolean restoreNetworkSelection) {
        int type = PhoneFactory.calculatePreferredNetworkType(this.mContext, this.getSubId());
        this.setPreferredNetworkType(type, null);
        if (restoreNetworkSelection) {
            this.restoreSavedNetworkSelection(null);
        }
        this.mDcTracker.setDataEnabled(this.getDataEnabled());
    }

    protected void setPreferredNetworkTypeIfSimLoaded() {
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int type = PhoneFactory.calculatePreferredNetworkType(this.mContext, this.getSubId());
            this.setPreferredNetworkType(type, null);
        }
    }

    @Override
    public void registerForRadioCapabilityChanged(Handler h, int what, Object obj) {
        this.mCi.registerForRadioCapabilityChanged(h, what, obj);
    }

    @Override
    public void unregisterForRadioCapabilityChanged(Handler h) {
        this.mCi.unregisterForRadioCapabilityChanged(this);
    }

    public boolean isImsUseEnabled() {
        boolean imsUseEnabled = ImsManager.isVolteEnabledByPlatform((Context)this.mContext) && ImsManager.isEnhanced4gLteModeSettingEnabledByUser((Context)this.mContext) || ImsManager.isWfcEnabledByPlatform((Context)this.mContext) && ImsManager.isWfcEnabledByUser((Context)this.mContext) && ImsManager.isNonTtyOrTtyOnVolteEnabled((Context)this.mContext);
        return imsUseEnabled;
    }

    @Override
    public boolean isVideoEnabled() {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return imsPhone.isVideoEnabled();
        }
        return false;
    }

    @Override
    public int getLceStatus() {
        return this.mLceStatus;
    }

    @Override
    public void getModemActivityInfo(Message response) {
        this.mCi.getModemActivityInfo(response);
    }

    public void startLceAfterRadioIsAvailable() {
        if (this.mIsTheCurrentActivePhone) {
            this.mCi.startLceService(200, true, this.obtainMessage(37));
        }
    }

    @Override
    public Locale getLocaleFromSimAndCarrierPrefs() {
        IccRecords records = this.mIccRecords.get();
        if (records != null && records.getSimLanguage() != null) {
            return new Locale(records.getSimLanguage());
        }
        return PhoneBase.getLocaleFromCarrierProperties(this.mContext);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("PhoneBase: subId=" + this.getSubId());
        pw.println(" mPhoneId=" + this.mPhoneId);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mDnsCheckDisabled=" + this.mDnsCheckDisabled);
        pw.println(" mDcTracker=" + this.mDcTracker);
        pw.println(" mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        pw.println(" mCallRingContinueToken=" + this.mCallRingContinueToken);
        pw.println(" mCallRingDelay=" + this.mCallRingDelay);
        pw.println(" mIsTheCurrentActivePhone=" + this.mIsTheCurrentActivePhone);
        pw.println(" mIsVoiceCapable=" + this.mIsVoiceCapable);
        pw.println(" mIccRecords=" + this.mIccRecords.get());
        pw.println(" mUiccApplication=" + this.mUiccApplication.get());
        pw.println(" mSmsStorageMonitor=" + this.mSmsStorageMonitor);
        pw.println(" mSmsUsageMonitor=" + this.mSmsUsageMonitor);
        pw.flush();
        pw.println(" mLooper=" + this.mLooper);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mNotifier=" + this.mNotifier);
        pw.println(" mSimulatedRadioControl=" + this.mSimulatedRadioControl);
        pw.println(" mUnitTestMode=" + this.mUnitTestMode);
        pw.println(" isDnsCheckDisabled()=" + this.isDnsCheckDisabled());
        pw.println(" getUnitTestMode()=" + this.getUnitTestMode());
        pw.println(" getState()=" + (Object)((Object)this.getState()));
        pw.println(" getIccSerialNumber()=" + this.getIccSerialNumber());
        pw.println(" getIccRecordsLoaded()=" + this.getIccRecordsLoaded());
        pw.println(" getMessageWaitingIndicator()=" + this.getMessageWaitingIndicator());
        pw.println(" getCallForwardingIndicator()=" + this.getCallForwardingIndicator());
        pw.println(" isInEmergencyCall()=" + this.isInEmergencyCall());
        pw.flush();
        pw.println(" isInEcm()=" + this.isInEcm());
        pw.println(" getPhoneName()=" + this.getPhoneName());
        pw.println(" getPhoneType()=" + this.getPhoneType());
        pw.println(" getVoiceMessageCount()=" + this.getVoiceMessageCount());
        pw.println(" getActiveApnTypes()=" + this.getActiveApnTypes());
        pw.println(" isDataConnectivityPossible()=" + this.isDataConnectivityPossible());
        pw.println(" needsOtaServiceProvisioning=" + this.needsOtaServiceProvisioning());
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            this.mDcTracker.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            this.getServiceStateTracker().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            this.getCallTracker().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            ((RIL)this.mCi).dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
    }

    protected static class NetworkSelectMessage {
        public Message message;
        public String operatorNumeric;
        public String operatorAlphaLong;
        public String operatorAlphaShort;

        protected NetworkSelectMessage() {
        }
    }
}

