/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.LocalServerSocket;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.SubscriptionInfoUpdater;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.dataconnection.DctController;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneFactory;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public class PhoneFactory {
    static final String LOG_TAG = "PhoneFactory";
    static final int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static final int SOCKET_OPEN_MAX_RETRY = 3;
    static final boolean DBG = false;
    static final Object sLockProxyPhones = new Object();
    private static PhoneProxy[] sProxyPhones = null;
    private static PhoneProxy sProxyPhone = null;
    private static CommandsInterface[] sCommandsInterfaces = null;
    private static ProxyController mProxyController;
    private static UiccController mUiccController;
    private static CommandsInterface sCommandsInterface;
    private static SubscriptionInfoUpdater sSubInfoRecordUpdater;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Context sContext;
    private static final HashMap<String, LocalLog> sLocalLogs;

    public static void makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDefaultPhone(Context context) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                int i;
                sContext = context;
                TelephonyDevController.create();
                int retryCount = 0;
                while (true) {
                    boolean hasException = false;
                    ++retryCount;
                    try {
                        new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException ex) {
                        hasException = true;
                    }
                    if (!hasException) break;
                    if (retryCount > 3) {
                        throw new RuntimeException("PhoneFactory probably already running");
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException er) {}
                }
                sPhoneNotifier = new DefaultPhoneNotifier();
                int cdmaSubscription = CdmaSubscriptionSourceManager.getDefault(context);
                Rlog.i(LOG_TAG, "Cdma Subscription set to " + cdmaSubscription);
                int numPhones = TelephonyManager.getDefault().getPhoneCount();
                int[] networkModes = new int[numPhones];
                sProxyPhones = new PhoneProxy[numPhones];
                sCommandsInterfaces = new RIL[numPhones];
                for (i = 0; i < numPhones; ++i) {
                    networkModes[i] = RILConstants.PREFERRED_NETWORK_MODE;
                    Rlog.i(LOG_TAG, "Network Mode set to " + Integer.toString(networkModes[i]));
                    PhoneFactory.sCommandsInterfaces[i] = new RIL(context, networkModes[i], cdmaSubscription, i);
                }
                Rlog.i(LOG_TAG, "Creating SubscriptionController");
                SubscriptionController.init(context, sCommandsInterfaces);
                mUiccController = UiccController.make(context, sCommandsInterfaces);
                for (i = 0; i < numPhones; ++i) {
                    PhoneBase phone = null;
                    int phoneType = TelephonyManager.getPhoneType(networkModes[i]);
                    if (phoneType == 1) {
                        phone = new GSMPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i);
                        phone.startMonitoringImsService();
                    } else if (phoneType == 2) {
                        phone = new CDMALTEPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i);
                        phone.startMonitoringImsService();
                    }
                    Rlog.i(LOG_TAG, "Creating Phone with type = " + phoneType + " sub = " + i);
                    PhoneFactory.sProxyPhones[i] = new PhoneProxy(phone);
                }
                mProxyController = ProxyController.getInstance(context, sProxyPhones, mUiccController, sCommandsInterfaces);
                sProxyPhone = sProxyPhones[0];
                sCommandsInterface = sCommandsInterfaces[0];
                ComponentName componentName = SmsApplication.getDefaultSmsApplication(context, true);
                String packageName = "NONE";
                if (componentName != null) {
                    packageName = componentName.getPackageName();
                }
                Rlog.i(LOG_TAG, "defaultSmsApplication: " + packageName);
                SmsApplication.initSmsPackageMonitor(context);
                sMadeDefaults = true;
                Rlog.i(LOG_TAG, "Creating SubInfoRecordUpdater ");
                sSubInfoRecordUpdater = new SubscriptionInfoUpdater(context, sProxyPhones, sCommandsInterfaces);
                SubscriptionController.getInstance().updatePhonesAvailability(sProxyPhones);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getCdmaPhone(int phoneId) {
        CDMALTEPhone phone;
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            phone = new CDMALTEPhone(sContext, sCommandsInterfaces[phoneId], sPhoneNotifier, phoneId);
        }
        return phone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getGsmPhone(int phoneId) {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            GSMPhone phone = new GSMPhone(sContext, sCommandsInterfaces[phoneId], sPhoneNotifier, phoneId);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getDefaultPhone() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sProxyPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getPhone(int phoneId) {
        String dbgInfo = "";
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            PhoneProxy phone = phoneId == Integer.MAX_VALUE ? sProxyPhone : (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount() ? sProxyPhones[phoneId] : null);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone[] getPhones() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sProxyPhones;
        }
    }

    public static SipPhone makeSipPhone(String sipUri) {
        return SipPhoneFactory.makePhone(sipUri, sContext, sPhoneNotifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultSubscription(int subId) {
        SystemProperties.set("persist.radio.default.sub", Integer.toString(subId));
        int phoneId = SubscriptionController.getInstance().getPhoneId(subId);
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (phoneId >= 0 && phoneId < sProxyPhones.length) {
                sProxyPhone = sProxyPhones[phoneId];
                sCommandsInterface = sCommandsInterfaces[phoneId];
                sMadeDefaults = true;
            }
        }
        String defaultMccMnc = TelephonyManager.getDefault().getSimOperatorNumericForPhone(phoneId);
        MccTable.updateMccMncConfiguration(sContext, defaultMccMnc, false);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x20000000);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId);
        Rlog.d(LOG_TAG, "setDefaultSubscription : " + subId + " Broadcasting Default Subscription Changed...");
        sContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    public static int calculatePreferredNetworkType(Context context, int phoneSubId) {
        int networkType = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + phoneSubId, RILConstants.PREFERRED_NETWORK_MODE);
        Rlog.d(LOG_TAG, "calculatePreferredNetworkType: phoneSubId = " + phoneSubId + " networkType = " + networkType);
        return networkType;
    }

    public static int getDefaultSubscription() {
        return SubscriptionController.getInstance().getDefaultSubId();
    }

    public static int getVoiceSubscription() {
        int subId = -1;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_voice_call");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim Voice Call Values");
        }
        return subId;
    }

    public static boolean isPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_voice_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim Voice Prompt Values");
        }
        prompt = value != 0;
        Rlog.d(LOG_TAG, "Prompt option:" + prompt);
        return prompt;
    }

    public static void setPromptEnabled(boolean enabled) {
        int value = !enabled ? 0 : 1;
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_voice_prompt", value);
        Rlog.d(LOG_TAG, "setVoicePromptOption to " + enabled);
    }

    public static boolean isSMSPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim SMS Prompt Values");
        }
        prompt = value != 0;
        Rlog.d(LOG_TAG, "SMS Prompt option:" + prompt);
        return prompt;
    }

    public static void setSMSPromptEnabled(boolean enabled) {
        int value = !enabled ? 0 : 1;
        Settings.Global.putInt(sContext.getContentResolver(), "multi_sim_sms_prompt", value);
        Rlog.d(LOG_TAG, "setSMSPromptOption to " + enabled);
    }

    public static long getDataSubscription() {
        int subId = -1;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_data_call");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim Data Call Values");
        }
        return subId;
    }

    public static int getSMSSubscription() {
        int subId = -1;
        try {
            subId = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim SMS Values");
        }
        return subId;
    }

    public static ImsPhone makeImsPhone(PhoneNotifier phoneNotifier, Phone defaultPhone) {
        return ImsPhoneFactory.makePhone(sContext, phoneNotifier, defaultPhone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalLog(String key, int size) {
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            if (sLocalLogs.containsKey(key)) {
                throw new IllegalArgumentException("key " + key + " already present");
            }
            sLocalLogs.put(key, new LocalLog(size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localLog(String key, String log) {
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            if (!sLocalLogs.containsKey(key)) {
                throw new IllegalArgumentException("key " + key + " not found");
            }
            sLocalLogs.get(key).log(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("PhoneFactory:");
        PhoneProxy[] phones = (PhoneProxy[])PhoneFactory.getPhones();
        int i = -1;
        for (PhoneProxy phoneProxy : phones) {
            ++i;
            try {
                PhoneBase phoneBase = (PhoneBase)phoneProxy.getActivePhone();
                phoneBase.dump(fd, pw, args);
            }
            catch (Exception e) {
                pw.println("Telephony DebugService: Could not get Phone[" + i + "] e=" + e);
                continue;
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            try {
                ((IccCardProxy)phoneProxy.getIccCard()).dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        try {
            DctController.getInstance().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mUiccController.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            SubscriptionController.getInstance().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            sSubInfoRecordUpdater.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
            for (String key : sLocalLogs.keySet()) {
                ipw.println(key);
                ipw.increaseIndent();
                sLocalLogs.get(key).dump(fd, ipw, args);
                ipw.decreaseIndent();
            }
            ipw.flush();
        }
    }

    static {
        sCommandsInterface = null;
        sSubInfoRecordUpdater = null;
        sMadeDefaults = false;
        sLocalLogs = new HashMap();
    }
}

