/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Binder;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class PhoneSubInfo {
    static final String LOG_TAG = "PhoneSubInfo";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private Phone mPhone;
    private Context mContext;
    private AppOpsManager mAppOps;
    private static final String READ_PHONE_STATE = "android.permission.READ_PHONE_STATE";
    private static final String CALL_PRIVILEGED = "android.permission.CALL_PRIVILEGED";
    private static final String READ_PRIVILEGED_PHONE_STATE = "android.permission.READ_PRIVILEGED_PHONE_STATE";

    public PhoneSubInfo(Phone phone) {
        this.mPhone = phone;
        this.mContext = phone.getContext();
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
    }

    public void dispose() {
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            this.loge("Error while finalizing:", throwable);
        }
        this.log("PhoneSubInfo finalized");
    }

    public String getDeviceId(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getDeviceId")) {
            return null;
        }
        return this.mPhone.getDeviceId();
    }

    public String getImei(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getImei")) {
            return null;
        }
        return this.mPhone.getImei();
    }

    public String getNai(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getNai")) {
            return null;
        }
        return this.mPhone.getNai();
    }

    public String getDeviceSvn(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getDeviceSvn")) {
            return null;
        }
        return this.mPhone.getDeviceSvn();
    }

    public String getSubscriberId(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getSubscriberId")) {
            return null;
        }
        return this.mPhone.getSubscriberId();
    }

    public String getGroupIdLevel1(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getGroupIdLevel1")) {
            return null;
        }
        return this.mPhone.getGroupIdLevel1();
    }

    public String getIccSerialNumber(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getIccSerialNumber")) {
            return null;
        }
        return this.mPhone.getIccSerialNumber();
    }

    public String getLine1Number(String callingPackage) {
        if (!this.checkReadPhoneNumber(callingPackage, "getLine1Number")) {
            return null;
        }
        return this.mPhone.getLine1Number();
    }

    public String getLine1AlphaTag(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getLine1AlphaTag")) {
            return null;
        }
        return this.mPhone.getLine1AlphaTag();
    }

    public String getMsisdn(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getMsisdn")) {
            return null;
        }
        return this.mPhone.getMsisdn();
    }

    public String getVoiceMailNumber(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getVoiceMailNumber")) {
            return null;
        }
        String number = PhoneNumberUtils.extractNetworkPortion(this.mPhone.getVoiceMailNumber());
        return number;
    }

    public String getCompleteVoiceMailNumber() {
        this.mContext.enforceCallingOrSelfPermission(CALL_PRIVILEGED, "Requires CALL_PRIVILEGED");
        String number = this.mPhone.getVoiceMailNumber();
        return number;
    }

    public String getVoiceMailAlphaTag(String callingPackage) {
        if (!this.checkReadPhoneState(callingPackage, "getVoiceMailAlphaTag")) {
            return null;
        }
        return this.mPhone.getVoiceMailAlphaTag();
    }

    public String getIsimImpi() {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = this.mPhone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimImpi();
        }
        return null;
    }

    public String getIsimDomain() {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = this.mPhone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimDomain();
        }
        return null;
    }

    public String[] getIsimImpu() {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = this.mPhone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimImpu();
        }
        return null;
    }

    public String getIsimIst() {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = this.mPhone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimIst();
        }
        return null;
    }

    public String[] getIsimPcscf() {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = this.mPhone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimPcscf();
        }
        return null;
    }

    public String getIsimChallengeResponse(String nonce) {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        IsimRecords isim = this.mPhone.getIsimRecords();
        if (isim != null) {
            return isim.getIsimChallengeResponse(nonce);
        }
        return null;
    }

    public String getIccSimChallengeResponse(int subId, int appType, String data) {
        this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, "Requires READ_PRIVILEGED_PHONE_STATE");
        UiccCard uiccCard = this.mPhone.getUiccCard();
        if (uiccCard == null) {
            Rlog.e(LOG_TAG, "getIccSimChallengeResponse() UiccCard is null");
            return null;
        }
        UiccCardApplication uiccApp = uiccCard.getApplicationByType(appType);
        if (uiccApp == null) {
            Rlog.e(LOG_TAG, "getIccSimChallengeResponse() no app with specified type -- " + appType);
            return null;
        }
        Rlog.e(LOG_TAG, "getIccSimChallengeResponse() found app " + uiccApp.getAid() + "specified type -- " + appType);
        int authContext = uiccApp.getAuthContext();
        if (data.length() < 32) {
            Rlog.e(LOG_TAG, "data is too small to use EAP_AKA, using EAP_SIM instead");
            authContext = 128;
        }
        if (authContext == -1) {
            Rlog.e(LOG_TAG, "getIccSimChallengeResponse() authContext undefined for app type " + appType);
            return null;
        }
        return uiccApp.getIccRecords().getIccSimChallengeResponse(authContext, data);
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private void loge(String s, Throwable e) {
        Rlog.e(LOG_TAG, s, e);
    }

    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump PhoneSubInfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        pw.println("Phone Subscriber Info:");
        pw.println("  Phone Type = " + this.mPhone.getPhoneName());
        pw.println("  Device ID = " + this.mPhone.getDeviceId());
    }

    private boolean checkReadPhoneState(String callingPackage, String message) {
        try {
            this.mContext.enforceCallingOrSelfPermission(READ_PRIVILEGED_PHONE_STATE, message);
            return true;
        }
        catch (SecurityException e) {
            this.mContext.enforceCallingOrSelfPermission(READ_PHONE_STATE, message);
            return this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0;
        }
    }

    private boolean checkReadPhoneNumber(String callingPackage, String message) {
        if (this.mAppOps.noteOp(15, Binder.getCallingUid(), callingPackage) == 0) {
            return true;
        }
        try {
            return this.checkReadPhoneState(callingPackage, message);
        }
        catch (SecurityException e) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SMS", message);
            return this.mAppOps.noteOp(14, Binder.getCallingUid(), callingPackage) == 0;
        }
    }
}

