/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfoProxy;

public class PhoneSubInfoController
extends IPhoneSubInfo.Stub {
    private static final String TAG = "PhoneSubInfoController";
    private Phone[] mPhone;

    public PhoneSubInfoController(Phone[] phone) {
        this.mPhone = phone;
        if (ServiceManager.getService("iphonesubinfo") == null) {
            ServiceManager.addService("iphonesubinfo", this);
        }
    }

    @Override
    public String getDeviceId(String callingPackage) {
        return this.getDeviceIdForPhone(SubscriptionManager.getPhoneId(this.getDefaultSubscription()));
    }

    @Override
    public String getDeviceIdForPhone(int phoneId) {
        PhoneProxy phone = this.getPhone(phoneId);
        if (phone != null) {
            return phone.getDeviceId();
        }
        Rlog.e(TAG, "getDeviceIdForPhone phone " + phoneId + " is null");
        return null;
    }

    @Override
    public String getNaiForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getNai(callingPackage);
        }
        Rlog.e(TAG, "getNai phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getImeiForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getImei(callingPackage);
        }
        Rlog.e(TAG, "getDeviceId phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getDeviceSvn(String callingPackage) {
        return this.getDeviceSvnUsingSubId(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getDeviceSvnUsingSubId(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getDeviceSvn(callingPackage);
        }
        Rlog.e(TAG, "getDeviceSvn phoneSubInfoProxy is null");
        return null;
    }

    @Override
    public String getSubscriberId(String callingPackage) {
        return this.getSubscriberIdForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getSubscriberIdForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getSubscriberId(callingPackage);
        }
        Rlog.e(TAG, "getSubscriberId phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getIccSerialNumber(String callingPackage) {
        return this.getIccSerialNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getIccSerialNumberForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getIccSerialNumber(callingPackage);
        }
        Rlog.e(TAG, "getIccSerialNumber phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getLine1Number(String callingPackage) {
        return this.getLine1NumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getLine1NumberForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getLine1Number(callingPackage);
        }
        Rlog.e(TAG, "getLine1Number phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getLine1AlphaTag(String callingPackage) {
        return this.getLine1AlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getLine1AlphaTagForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getLine1AlphaTag(callingPackage);
        }
        Rlog.e(TAG, "getLine1AlphaTag phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getMsisdn(String callingPackage) {
        return this.getMsisdnForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getMsisdnForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getMsisdn(callingPackage);
        }
        Rlog.e(TAG, "getMsisdn phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getVoiceMailNumber(String callingPackage) {
        return this.getVoiceMailNumberForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getVoiceMailNumberForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getVoiceMailNumber(callingPackage);
        }
        Rlog.e(TAG, "getVoiceMailNumber phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumberForSubscriber(this.getDefaultSubscription());
    }

    @Override
    public String getCompleteVoiceMailNumberForSubscriber(int subId) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getCompleteVoiceMailNumber();
        }
        Rlog.e(TAG, "getCompleteVoiceMailNumber phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    @Override
    public String getVoiceMailAlphaTag(String callingPackage) {
        return this.getVoiceMailAlphaTagForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getVoiceMailAlphaTagForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getVoiceMailAlphaTag(callingPackage);
        }
        Rlog.e(TAG, "getVoiceMailAlphaTag phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }

    private PhoneSubInfoProxy getPhoneSubInfoProxy(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        try {
            return this.getPhone(phoneId).getPhoneSubInfoProxy();
        }
        catch (NullPointerException e) {
            Rlog.e(TAG, "Exception is :" + e.toString() + " For subId :" + subId);
            e.printStackTrace();
            return null;
        }
    }

    private PhoneProxy getPhone(int phoneId) {
        if (phoneId < 0 || phoneId >= TelephonyManager.getDefault().getPhoneCount()) {
            phoneId = 0;
        }
        return (PhoneProxy)this.mPhone[phoneId];
    }

    private int getDefaultSubscription() {
        return PhoneFactory.getDefaultSubscription();
    }

    @Override
    public String getIsimImpi() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimImpi();
    }

    @Override
    public String getIsimDomain() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimDomain();
    }

    @Override
    public String[] getIsimImpu() {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimImpu();
    }

    @Override
    public String getIsimIst() throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimIst();
    }

    @Override
    public String[] getIsimPcscf() throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimPcscf();
    }

    @Override
    public String getIsimChallengeResponse(String nonce) throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(this.getDefaultSubscription());
        return phoneSubInfoProxy.getIsimChallengeResponse(nonce);
    }

    @Override
    public String getIccSimChallengeResponse(int subId, int appType, String data) throws RemoteException {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        return phoneSubInfoProxy.getIccSimChallengeResponse(subId, appType, data);
    }

    @Override
    public String getGroupIdLevel1(String callingPackage) {
        return this.getGroupIdLevel1ForSubscriber(this.getDefaultSubscription(), callingPackage);
    }

    @Override
    public String getGroupIdLevel1ForSubscriber(int subId, String callingPackage) {
        PhoneSubInfoProxy phoneSubInfoProxy = this.getPhoneSubInfoProxy(subId);
        if (phoneSubInfoProxy != null) {
            return phoneSubInfoProxy.getGroupIdLevel1(callingPackage);
        }
        Rlog.e(TAG, "getGroupIdLevel1 phoneSubInfoProxy is null for Subscription:" + subId);
        return null;
    }
}

