/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncResult;
import android.os.BaseBundle;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemClock;
import android.preference.PreferenceManager;
import android.telephony.CellInfo;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Pair;
import android.util.TimeUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.RestrictedState;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ServiceStateTracker
extends Handler {
    private static final String LOG_TAG = "SST";
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    protected static final String PROP_FORCE_ROAMING = "telephony.test.forceRoaming";
    protected CommandsInterface mCi;
    protected UiccController mUiccController = null;
    protected UiccCardApplication mUiccApplcation = null;
    protected IccRecords mIccRecords = null;
    protected PhoneBase mPhoneBase;
    protected boolean mVoiceCapable;
    public ServiceState mSS = new ServiceState();
    protected ServiceState mNewSS = new ServiceState();
    private static final long LAST_CELL_INFO_LIST_MAX_AGE_MS = 2000L;
    protected long mLastCellInfoListTime;
    protected List<CellInfo> mLastCellInfoList = null;
    protected final CellInfo mCellInfo;
    protected SignalStrength mSignalStrength = new SignalStrength();
    public RestrictedState mRestrictedState = new RestrictedState();
    public static final int OTASP_UNINITIALIZED = 0;
    public static final int OTASP_UNKNOWN = 1;
    public static final int OTASP_NEEDED = 2;
    public static final int OTASP_NOT_NEEDED = 3;
    protected int[] mPollingContext;
    protected boolean mDesiredPowerState;
    protected boolean mDontPollSignalStrength = false;
    protected RegistrantList mVoiceRoamingOnRegistrants = new RegistrantList();
    protected RegistrantList mVoiceRoamingOffRegistrants = new RegistrantList();
    protected RegistrantList mDataRoamingOnRegistrants = new RegistrantList();
    protected RegistrantList mDataRoamingOffRegistrants = new RegistrantList();
    protected RegistrantList mAttachedRegistrants = new RegistrantList();
    protected RegistrantList mDetachedRegistrants = new RegistrantList();
    protected RegistrantList mDataRegStateOrRatChangedRegistrants = new RegistrantList();
    protected RegistrantList mNetworkAttachedRegistrants = new RegistrantList();
    protected RegistrantList mPsRestrictEnabledRegistrants = new RegistrantList();
    protected RegistrantList mPsRestrictDisabledRegistrants = new RegistrantList();
    protected boolean mPendingRadioPowerOffAfterDataOff = false;
    protected int mPendingRadioPowerOffAfterDataOffTag = 0;
    protected static final int POLL_PERIOD_MILLIS = 20000;
    public static final int DEFAULT_GPRS_CHECK_PERIOD_MILLIS = 60000;
    protected static final int EVENT_RADIO_STATE_CHANGED = 1;
    protected static final int EVENT_NETWORK_STATE_CHANGED = 2;
    protected static final int EVENT_GET_SIGNAL_STRENGTH = 3;
    protected static final int EVENT_POLL_STATE_REGISTRATION = 4;
    protected static final int EVENT_POLL_STATE_GPRS = 5;
    protected static final int EVENT_POLL_STATE_OPERATOR = 6;
    protected static final int EVENT_POLL_SIGNAL_STRENGTH = 10;
    protected static final int EVENT_NITZ_TIME = 11;
    protected static final int EVENT_SIGNAL_STRENGTH_UPDATE = 12;
    protected static final int EVENT_RADIO_AVAILABLE = 13;
    protected static final int EVENT_POLL_STATE_NETWORK_SELECTION_MODE = 14;
    protected static final int EVENT_GET_LOC_DONE = 15;
    protected static final int EVENT_SIM_RECORDS_LOADED = 16;
    protected static final int EVENT_SIM_READY = 17;
    protected static final int EVENT_LOCATION_UPDATES_ENABLED = 18;
    protected static final int EVENT_GET_PREFERRED_NETWORK_TYPE = 19;
    protected static final int EVENT_SET_PREFERRED_NETWORK_TYPE = 20;
    protected static final int EVENT_RESET_PREFERRED_NETWORK_TYPE = 21;
    protected static final int EVENT_CHECK_REPORT_GPRS = 22;
    protected static final int EVENT_RESTRICTED_STATE_CHANGED = 23;
    protected static final int EVENT_POLL_STATE_REGISTRATION_CDMA = 24;
    protected static final int EVENT_POLL_STATE_OPERATOR_CDMA = 25;
    protected static final int EVENT_RUIM_READY = 26;
    protected static final int EVENT_RUIM_RECORDS_LOADED = 27;
    protected static final int EVENT_POLL_SIGNAL_STRENGTH_CDMA = 28;
    protected static final int EVENT_GET_SIGNAL_STRENGTH_CDMA = 29;
    protected static final int EVENT_NETWORK_STATE_CHANGED_CDMA = 30;
    protected static final int EVENT_GET_LOC_DONE_CDMA = 31;
    protected static final int EVENT_NV_LOADED = 33;
    protected static final int EVENT_POLL_STATE_CDMA_SUBSCRIPTION = 34;
    protected static final int EVENT_NV_READY = 35;
    protected static final int EVENT_ERI_FILE_LOADED = 36;
    protected static final int EVENT_OTA_PROVISION_STATUS_CHANGE = 37;
    protected static final int EVENT_SET_RADIO_POWER_OFF = 38;
    protected static final int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 39;
    protected static final int EVENT_CDMA_PRL_VERSION_CHANGED = 40;
    protected static final int EVENT_RADIO_ON = 41;
    public static final int EVENT_ICC_CHANGED = 42;
    protected static final int EVENT_GET_CELL_INFO_LIST = 43;
    protected static final int EVENT_UNSOL_CELL_INFO_LIST = 44;
    protected static final int EVENT_CHANGE_IMS_STATE = 45;
    protected static final int EVENT_IMS_STATE_CHANGED = 46;
    protected static final int EVENT_IMS_STATE_DONE = 47;
    protected static final int EVENT_IMS_CAPABILITY_CHANGED = 48;
    protected static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    protected static final String[] GMT_COUNTRY_CODES = new String[]{"bf", "ci", "eh", "fo", "gb", "gh", "gm", "gn", "gw", "ie", "lr", "is", "ma", "ml", "mr", "pt", "sl", "sn", "st", "tg"};
    protected static final String REGISTRATION_DENIED_GEN = "General";
    protected static final String REGISTRATION_DENIED_AUTH = "Authentication Failure";
    protected boolean mImsRegistrationOnOff = false;
    protected boolean mAlarmSwitch = false;
    protected IntentFilter mIntentFilter = null;
    protected PendingIntent mRadioOffIntent = null;
    protected static final String ACTION_RADIO_OFF = "android.intent.action.ACTION_RADIO_OFF";
    protected boolean mPowerOffDelayNeed = true;
    protected boolean mDeviceShuttingDown = false;
    protected boolean mSpnUpdatePending = false;
    protected String mCurSpn = null;
    protected String mCurDataSpn = null;
    protected String mCurPlmn = null;
    protected boolean mCurShowPlmn = false;
    protected boolean mCurShowSpn = false;
    protected int mSubId = -1;
    private boolean mImsRegistered = false;
    protected SubscriptionManager mSubscriptionManager;
    protected SubscriptionController mSubscriptionController;
    protected final SstSubscriptionsChangedListener mOnSubscriptionsChangedListener = new SstSubscriptionsChangedListener();
    private SignalStrength mLastSignalStrength = null;
    private boolean mWantContinuousLocationUpdates;
    private boolean mWantSingleLocationUpdate;

    protected ServiceStateTracker(PhoneBase phoneBase, CommandsInterface ci, CellInfo cellInfo) {
        this.mPhoneBase = phoneBase;
        this.mCellInfo = cellInfo;
        this.mCi = ci;
        this.mVoiceCapable = this.mPhoneBase.getContext().getResources().getBoolean(17956947);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 42, null);
        this.mCi.setOnSignalStrengthUpdate(this, 12, null);
        this.mCi.registerForCellInfoList(this, 44, null);
        this.mSubscriptionController = SubscriptionController.getInstance();
        this.mSubscriptionManager = SubscriptionManager.from(phoneBase.getContext());
        this.mSubscriptionManager.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mPhoneBase.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(0));
        this.mCi.registerForImsNetworkStateChanged(this, 46, null);
    }

    void requestShutdown() {
        if (this.mDeviceShuttingDown) {
            return;
        }
        this.mDeviceShuttingDown = true;
        this.mDesiredPowerState = false;
        this.setPowerStateToDesired();
    }

    public void dispose() {
        this.mCi.unSetOnSignalStrengthUpdate(this);
        this.mUiccController.unregisterForIccChanged(this);
        this.mCi.unregisterForCellInfoList(this);
        this.mSubscriptionManager.removeOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
    }

    public boolean getDesiredPowerState() {
        return this.mDesiredPowerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifySignalStrength() {
        boolean notified = false;
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            if (!this.mSignalStrength.equals(this.mLastSignalStrength)) {
                try {
                    this.mPhoneBase.notifySignalStrength();
                    notified = true;
                }
                catch (NullPointerException ex) {
                    this.loge("updateSignalStrength() Phone already destroyed: " + ex + "SignalStrength not notified");
                }
            }
        }
        return notified;
    }

    protected void notifyDataRegStateRilRadioTechnologyChanged() {
        int rat = this.mSS.getRilDataRadioTechnology();
        int drs = this.mSS.getDataRegState();
        this.log("notifyDataRegStateRilRadioTechnologyChanged: drs=" + drs + " rat=" + rat);
        this.mPhoneBase.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(rat));
        this.mDataRegStateOrRatChangedRegistrants.notifyResult(new Pair<Integer, Integer>(drs, rat));
    }

    protected void useDataRegStateForDataOnlyDevices() {
        if (!this.mVoiceCapable) {
            this.log("useDataRegStateForDataOnlyDevice: VoiceRegState=" + this.mNewSS.getVoiceRegState() + " DataRegState=" + this.mNewSS.getDataRegState());
            this.mNewSS.setVoiceRegState(this.mNewSS.getDataRegState());
        }
    }

    protected void updatePhoneObject() {
        if (this.mPhoneBase.getContext().getResources().getBoolean(17957009)) {
            boolean isRegistered;
            boolean bl = isRegistered = this.mSS.getVoiceRegState() == 0 || this.mSS.getVoiceRegState() == 2;
            if (!isRegistered) {
                Rlog.d(LOG_TAG, "updatePhoneObject: Ignore update");
                return;
            }
            this.mPhoneBase.updatePhoneObject(this.mSS.getRilVoiceRadioTechnology());
        }
    }

    public void registerForVoiceRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRoamingOnRegistrants.add(r);
        if (this.mSS.getVoiceRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForVoiceRoamingOn(Handler h) {
        this.mVoiceRoamingOnRegistrants.remove(h);
    }

    public void registerForVoiceRoamingOff(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceRoamingOffRegistrants.add(r);
        if (!this.mSS.getVoiceRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForVoiceRoamingOff(Handler h) {
        this.mVoiceRoamingOffRegistrants.remove(h);
    }

    public void registerForDataRoamingOn(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRoamingOnRegistrants.add(r);
        if (this.mSS.getDataRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataRoamingOn(Handler h) {
        this.mDataRoamingOnRegistrants.remove(h);
    }

    public void registerForDataRoamingOff(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRoamingOffRegistrants.add(r);
        if (!this.mSS.getDataRoaming()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataRoamingOff(Handler h) {
        this.mDataRoamingOffRegistrants.remove(h);
    }

    public void reRegisterNetwork(Message onComplete) {
        this.mCi.getPreferredNetworkType(this.obtainMessage(19, onComplete));
    }

    public void setRadioPower(boolean power) {
        this.mDesiredPowerState = power;
        this.setPowerStateToDesired();
    }

    public void enableSingleLocationUpdate() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantSingleLocationUpdate = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    public void enableLocationUpdates() {
        if (this.mWantSingleLocationUpdate || this.mWantContinuousLocationUpdates) {
            return;
        }
        this.mWantContinuousLocationUpdates = true;
        this.mCi.setLocationUpdates(true, this.obtainMessage(18));
    }

    protected void disableSingleLocationUpdate() {
        this.mWantSingleLocationUpdate = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    public void disableLocationUpdates() {
        this.mWantContinuousLocationUpdates = false;
        if (!this.mWantSingleLocationUpdate && !this.mWantContinuousLocationUpdates) {
            this.mCi.setLocationUpdates(false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 38: {
                ServiceStateTracker serviceStateTracker = this;
                synchronized (serviceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff && msg.arg1 == this.mPendingRadioPowerOffAfterDataOffTag) {
                        this.log("EVENT_SET_RADIO_OFF, turn radio off now.");
                        this.hangupAndPowerOff();
                        ++this.mPendingRadioPowerOffAfterDataOffTag;
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_SET_RADIO_OFF is stale arg1=" + msg.arg1 + "!= tag=" + this.mPendingRadioPowerOffAfterDataOffTag);
                    }
                    break;
                }
            }
            case 42: {
                this.onUpdateIccAvailability();
                break;
            }
            case 43: {
                AsyncResult ar = (AsyncResult)msg.obj;
                CellInfoResult result = (CellInfoResult)ar.userObj;
                Object object = result.lockObj;
                synchronized (object) {
                    if (ar.exception != null) {
                        this.log("EVENT_GET_CELL_INFO_LIST: error ret null, e=" + ar.exception);
                        result.list = null;
                    } else {
                        result.list = (List)ar.result;
                    }
                    this.mLastCellInfoListTime = SystemClock.elapsedRealtime();
                    this.mLastCellInfoList = result.list;
                    result.lockObj.notify();
                    break;
                }
            }
            case 44: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    this.log("EVENT_UNSOL_CELL_INFO_LIST: error ignoring, e=" + ar.exception);
                    break;
                }
                List list = (List)ar.result;
                this.log("EVENT_UNSOL_CELL_INFO_LIST: size=" + list.size() + " list=" + list);
                this.mLastCellInfoListTime = SystemClock.elapsedRealtime();
                this.mLastCellInfoList = list;
                this.mPhoneBase.notifyCellInfo(list);
                break;
            }
            case 46: {
                this.mCi.getImsRegistrationState(this.obtainMessage(47));
                break;
            }
            case 47: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                int[] responseArray = (int[])ar.result;
                this.mImsRegistered = responseArray[0] == 1;
                break;
            }
            default: {
                this.log("Unhandled message with number: " + msg.what);
            }
        }
    }

    protected abstract Phone getPhone();

    protected abstract void handlePollStateResult(int var1, AsyncResult var2);

    protected abstract void updateSpnDisplay();

    protected abstract void setPowerStateToDesired();

    protected abstract void onUpdateIccAvailability();

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    public abstract int getCurrentDataConnectionState();

    public abstract boolean isConcurrentVoiceAndDataAllowed();

    public abstract void setImsRegistrationState(boolean var1);

    public void onImsCapabilityChanged() {
    }

    public abstract void pollState();

    public void registerForDataConnectionAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mAttachedRegistrants.add(r);
        if (this.getCurrentDataConnectionState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataConnectionAttached(Handler h) {
        this.mAttachedRegistrants.remove(h);
    }

    public void registerForDataConnectionDetached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDetachedRegistrants.add(r);
        if (this.getCurrentDataConnectionState() != 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForDataConnectionDetached(Handler h) {
        this.mDetachedRegistrants.remove(h);
    }

    public void registerForDataRegStateOrRatChanged(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mDataRegStateOrRatChangedRegistrants.add(r);
        this.notifyDataRegStateRilRadioTechnologyChanged();
    }

    public void unregisterForDataRegStateOrRatChanged(Handler h) {
        this.mDataRegStateOrRatChangedRegistrants.remove(h);
    }

    public void registerForNetworkAttached(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkAttachedRegistrants.add(r);
        if (this.mSS.getVoiceRegState() == 0) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForNetworkAttached(Handler h) {
        this.mNetworkAttachedRegistrants.remove(h);
    }

    public void registerForPsRestrictedEnabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictEnabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedEnabled(Handler h) {
        this.mPsRestrictEnabledRegistrants.remove(h);
    }

    public void registerForPsRestrictedDisabled(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mPsRestrictDisabledRegistrants.add(r);
        if (this.mRestrictedState.isPsRestricted()) {
            r.notifyRegistrant();
        }
    }

    public void unregisterForPsRestrictedDisabled(Handler h) {
        this.mPsRestrictDisabledRegistrants.remove(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void powerOffRadioSafely(DcTrackerBase dcTracker) {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                String[] networkNotClearData = this.mPhoneBase.getContext().getResources().getStringArray(17236032);
                String currentNetwork = this.mSS.getOperatorNumeric();
                if (networkNotClearData != null && currentNetwork != null) {
                    for (int i = 0; i < networkNotClearData.length; ++i) {
                        if (!currentNetwork.equals(networkNotClearData[i])) continue;
                        this.log("Not disconnecting data for " + currentNetwork);
                        this.hangupAndPowerOff();
                        return;
                    }
                }
                if (dcTracker.isDisconnected()) {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    Message msg = Message.obtain(this);
                    msg.what = 38;
                    msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                    if (this.sendMessageDelayed(msg, 30000L)) {
                        this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    } else {
                        this.log("Cannot send delayed Msg, turn off radio right away.");
                        this.hangupAndPowerOff();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processPendingRadioPowerOffAfterDataOff() {
        ServiceStateTracker serviceStateTracker = this;
        synchronized (serviceStateTracker) {
            if (this.mPendingRadioPowerOffAfterDataOff) {
                this.log("Process pending request to turn radio off.");
                ++this.mPendingRadioPowerOffAfterDataOffTag;
                this.hangupAndPowerOff();
                this.mPendingRadioPowerOffAfterDataOff = false;
                return true;
            }
            return false;
        }
    }

    protected boolean onSignalStrengthResult(AsyncResult ar, boolean isGsm) {
        SignalStrength oldSignalStrength = this.mSignalStrength;
        if (ar.exception == null && ar.result != null) {
            this.mSignalStrength = (SignalStrength)ar.result;
            this.mSignalStrength.validateInput();
            this.mSignalStrength.setGsm(isGsm);
        } else {
            this.log("onSignalStrengthResult() Exception from RIL : " + ar.exception);
            this.mSignalStrength = new SignalStrength(isGsm);
        }
        return this.notifySignalStrength();
    }

    protected abstract void hangupAndPowerOff();

    protected void cancelPollState() {
        this.mPollingContext = new int[1];
    }

    protected boolean shouldFixTimeZoneNow(PhoneBase phoneBase, String operatorNumeric, String prevOperatorNumeric, boolean needToFixTimeZone) {
        int prevMcc;
        int mcc;
        try {
            mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            this.log("shouldFixTimeZoneNow: no mcc, operatorNumeric=" + operatorNumeric + " retVal=false");
            return false;
        }
        try {
            prevMcc = Integer.parseInt(prevOperatorNumeric.substring(0, 3));
        }
        catch (Exception e) {
            prevMcc = mcc + 1;
        }
        boolean iccCardExist = false;
        if (this.mUiccApplcation != null) {
            iccCardExist = this.mUiccApplcation.getState() != IccCardApplicationStatus.AppState.APPSTATE_UNKNOWN;
        }
        boolean retVal = iccCardExist && mcc != prevMcc || needToFixTimeZone;
        long ctm = System.currentTimeMillis();
        this.log("shouldFixTimeZoneNow: retVal=" + retVal + " iccCardExist=" + iccCardExist + " operatorNumeric=" + operatorNumeric + " mcc=" + mcc + " prevOperatorNumeric=" + prevOperatorNumeric + " prevMcc=" + prevMcc + " needToFixTimeZone=" + needToFixTimeZone + " ltod=" + TimeUtils.logTimeOfDay(ctm));
        return retVal;
    }

    public String getSystemProperty(String property, String defValue) {
        return TelephonyManager.getTelephonyProperty(this.mPhoneBase.getPhoneId(), property, defValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CellInfo> getAllCellInfo() {
        CellInfoResult result = new CellInfoResult();
        int ver = this.mCi.getRilVersion();
        if (ver >= 8) {
            if (this.isCallerOnDifferentThread()) {
                if (SystemClock.elapsedRealtime() - this.mLastCellInfoListTime > 2000L) {
                    Message msg = this.obtainMessage(43, result);
                    Object object = result.lockObj;
                    synchronized (object) {
                        result.list = null;
                        this.mCi.getCellInfoList(msg);
                        try {
                            result.lockObj.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
                this.log("SST.getAllCellInfo(): return last, back to back calls");
                result.list = this.mLastCellInfoList;
            } else {
                this.log("SST.getAllCellInfo(): return last, same thread can't block");
                result.list = this.mLastCellInfoList;
            }
        } else {
            this.log("SST.getAllCellInfo(): not implemented");
            result.list = null;
        }
        Object object = result.lockObj;
        synchronized (object) {
            if (result.list != null) {
                this.log("SST.getAllCellInfo(): X size=" + result.list.size() + " list=" + result.list);
                return result.list;
            }
            this.log("SST.getAllCellInfo(): X size=0 list=null");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalStrength getSignalStrength() {
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            return this.mSignalStrength;
        }
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ServiceStateTracker:");
        pw.println(" mSS=" + this.mSS);
        pw.println(" mNewSS=" + this.mNewSS);
        pw.println(" mCellInfo=" + this.mCellInfo);
        pw.println(" mRestrictedState=" + this.mRestrictedState);
        pw.println(" mPollingContext=" + this.mPollingContext);
        pw.println(" mDesiredPowerState=" + this.mDesiredPowerState);
        pw.println(" mDontPollSignalStrength=" + this.mDontPollSignalStrength);
        pw.println(" mPendingRadioPowerOffAfterDataOff=" + this.mPendingRadioPowerOffAfterDataOff);
        pw.println(" mPendingRadioPowerOffAfterDataOffTag=" + this.mPendingRadioPowerOffAfterDataOffTag);
        pw.flush();
    }

    public boolean isImsRegistered() {
        return this.mImsRegistered;
    }

    protected void checkCorrectThread() {
        if (Thread.currentThread() != this.getLooper().getThread()) {
            throw new RuntimeException("ServiceStateTracker must be used from within one thread");
        }
    }

    protected boolean isCallerOnDifferentThread() {
        boolean value = Thread.currentThread() != this.getLooper().getThread();
        return value;
    }

    protected void updateCarrierMccMncConfiguration(String newOp, String oldOp, Context context) {
        if (newOp == null && !TextUtils.isEmpty(oldOp) || newOp != null && !newOp.equals(oldOp)) {
            this.log("update mccmnc=" + newOp + " fromServiceState=true");
            MccTable.updateMccMncConfiguration(context, newOp, true);
        }
    }

    protected boolean inSameCountry(String operatorNumeric) {
        if (TextUtils.isEmpty(operatorNumeric) || operatorNumeric.length() < 5) {
            return false;
        }
        String homeNumeric = this.getHomeOperatorNumeric();
        if (TextUtils.isEmpty(homeNumeric) || homeNumeric.length() < 5) {
            return false;
        }
        boolean inSameCountry = true;
        String networkMCC = operatorNumeric.substring(0, 3);
        String homeMCC = homeNumeric.substring(0, 3);
        String networkCountry = MccTable.countryCodeForMcc(Integer.parseInt(networkMCC));
        String homeCountry = MccTable.countryCodeForMcc(Integer.parseInt(homeMCC));
        if (networkCountry.isEmpty() || homeCountry.isEmpty()) {
            return false;
        }
        inSameCountry = homeCountry.equals(networkCountry);
        if (inSameCountry) {
            return inSameCountry;
        }
        if ("us".equals(homeCountry) && "vi".equals(networkCountry)) {
            inSameCountry = true;
        } else if ("vi".equals(homeCountry) && "us".equals(networkCountry)) {
            inSameCountry = true;
        }
        return inSameCountry;
    }

    protected abstract void setRoamingType(ServiceState var1);

    protected String getHomeOperatorNumeric() {
        return ((TelephonyManager)this.mPhoneBase.getContext().getSystemService("phone")).getSimOperatorNumericForPhone(this.mPhoneBase.getPhoneId());
    }

    protected int getPhoneId() {
        return this.mPhoneBase.getPhoneId();
    }

    protected void resetServiceStateInIwlanMode() {
        if (this.mCi.getRadioState() == CommandsInterface.RadioState.RADIO_OFF) {
            boolean resetIwlanRatVal = false;
            this.log("set service state as POWER_OFF");
            if (18 == this.mNewSS.getRilDataRadioTechnology()) {
                this.log("pollStateDone: mNewSS = " + this.mNewSS);
                this.log("pollStateDone: reset iwlan RAT value");
                resetIwlanRatVal = true;
            }
            this.mNewSS.setStateOff();
            if (resetIwlanRatVal) {
                this.mNewSS.setRilDataRadioTechnology(18);
                this.mNewSS.setDataRegState(0);
                this.log("pollStateDone: mNewSS = " + this.mNewSS);
            }
        }
    }

    protected final boolean alwaysOnHomeNetwork(BaseBundle b) {
        return b.getBoolean("force_home_network_bool");
    }

    private boolean isInNetwork(BaseBundle b, String network, String key) {
        String[] networks = b.getStringArray(key);
        return networks != null && Arrays.asList(networks).contains(network);
    }

    protected final boolean isRoamingInGsmNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "gsm_roaming_networks_string_array");
    }

    protected final boolean isNonRoamingInGsmNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "gsm_nonroaming_networks_string_array");
    }

    protected final boolean isRoamingInCdmaNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "cdma_roaming_networks_string_array");
    }

    protected final boolean isNonRoamingInCdmaNetwork(BaseBundle b, String network) {
        return this.isInNetwork(b, network, "cdma_nonroaming_networks_string_array");
    }

    protected class SstSubscriptionsChangedListener
    extends SubscriptionManager.OnSubscriptionsChangedListener {
        public final AtomicInteger mPreviousSubId = new AtomicInteger(-1);

        protected SstSubscriptionsChangedListener() {
        }

        @Override
        public void onSubscriptionsChanged() {
            ServiceStateTracker.this.log("SubscriptionListener.onSubscriptionInfoChanged");
            int subId = ServiceStateTracker.this.mPhoneBase.getSubId();
            if (this.mPreviousSubId.getAndSet(subId) != subId && SubscriptionManager.isValidSubscriptionId(subId)) {
                Context context = ServiceStateTracker.this.mPhoneBase.getContext();
                ServiceStateTracker.this.mPhoneBase.notifyCallForwardingIndicator();
                boolean restoreSelection = !context.getResources().getBoolean(17956953);
                ServiceStateTracker.this.mPhoneBase.sendSubscriptionSettings(restoreSelection);
                ServiceStateTracker.this.mPhoneBase.setSystemProperty("gsm.network.type", ServiceState.rilRadioTechnologyToString(ServiceStateTracker.this.mSS.getRilDataRadioTechnology()));
                if (ServiceStateTracker.this.mSpnUpdatePending) {
                    ServiceStateTracker.this.mSubscriptionController.setPlmnSpn(ServiceStateTracker.this.mPhoneBase.getPhoneId(), ServiceStateTracker.this.mCurShowPlmn, ServiceStateTracker.this.mCurPlmn, ServiceStateTracker.this.mCurShowSpn, ServiceStateTracker.this.mCurSpn);
                    ServiceStateTracker.this.mSpnUpdatePending = false;
                }
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
                String oldNetworkSelection = sp.getString("network_selection_key", "");
                String oldNetworkSelectionName = sp.getString("network_selection_name_key", "");
                String oldNetworkSelectionShort = sp.getString("network_selection_short_key", "");
                if (!(TextUtils.isEmpty(oldNetworkSelection) && TextUtils.isEmpty(oldNetworkSelectionName) && TextUtils.isEmpty(oldNetworkSelectionShort))) {
                    SharedPreferences.Editor editor = sp.edit();
                    editor.putString("network_selection_key" + subId, oldNetworkSelection);
                    editor.putString("network_selection_name_key" + subId, oldNetworkSelectionName);
                    editor.putString("network_selection_short_key" + subId, oldNetworkSelectionShort);
                    editor.remove("network_selection_key");
                    editor.remove("network_selection_name_key");
                    editor.remove("network_selection_short_key");
                    editor.commit();
                }
                ServiceStateTracker.this.updateSpnDisplay();
            }
        }
    }

    private class CellInfoResult {
        List<CellInfo> list;
        Object lockObj = new Object();

        private CellInfoResult() {
        }
    }
}

