/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.app.ActivityManagerNative;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.Log;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCall;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaMmiCode;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.cdma.RuimPhoneBookInterfaceManager;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CDMAPhone
extends PhoneBase {
    static final String LOG_TAG = "CDMAPhone";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    private static final String VM_NUMBER_CDMA = "vm_number_key_cdma";
    private String mVmNumber = null;
    static final int RESTART_ECM_TIMER = 0;
    static final int CANCEL_ECM_TIMER = 1;
    CdmaCallTracker mCT;
    CdmaServiceStateTracker mSST;
    CdmaSubscriptionSourceManager mCdmaSSM;
    ArrayList<CdmaMmiCode> mPendingMmis = new ArrayList();
    RuimPhoneBookInterfaceManager mRuimPhoneBookInterfaceManager;
    int mCdmaSubscriptionSource = -1;
    PhoneSubInfo mSubInfo;
    EriManager mEriManager;
    PowerManager.WakeLock mWakeLock;
    private final RegistrantList mEriFileLoadedRegistrants = new RegistrantList();
    private final RegistrantList mEcmTimerResetRegistrants = new RegistrantList();
    protected boolean mIsPhoneInEcmState;
    private Registrant mEcmExitRespRegistrant;
    protected String mImei;
    protected String mImeiSv;
    private String mEsn;
    private String mMeid;
    protected String mCarrierOtaSpNumSchema;
    private Runnable mExitEcmRunnable = new Runnable(){

        @Override
        public void run() {
            CDMAPhone.this.exitEmergencyCallbackMode();
        }
    };
    Registrant mPostDialHandler;
    static String PROPERTY_CDMA_HOME_OPERATOR_NUMERIC = "ro.cdma.home.operator.numeric";
    private static final String IS683A_FEATURE_CODE = "*228";
    private static final int IS683A_FEATURE_CODE_NUM_DIGITS = 4;
    private static final int IS683A_SYS_SEL_CODE_NUM_DIGITS = 2;
    private static final int IS683A_SYS_SEL_CODE_OFFSET = 4;
    private static final int IS683_CONST_800MHZ_A_BAND = 0;
    private static final int IS683_CONST_800MHZ_B_BAND = 1;
    private static final int IS683_CONST_1900MHZ_A_BLOCK = 2;
    private static final int IS683_CONST_1900MHZ_B_BLOCK = 3;
    private static final int IS683_CONST_1900MHZ_C_BLOCK = 4;
    private static final int IS683_CONST_1900MHZ_D_BLOCK = 5;
    private static final int IS683_CONST_1900MHZ_E_BLOCK = 6;
    private static final int IS683_CONST_1900MHZ_F_BLOCK = 7;
    private static final int INVALID_SYSTEM_SELECTION_CODE = -1;
    private static Pattern pOtaSpNumSchema = Pattern.compile("[,\\s]+");

    public CDMAPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId) {
        super("CDMA", notifier, context, ci, false, phoneId);
        this.initSstIcc();
        this.init(context, notifier);
    }

    protected void initSstIcc() {
        this.mSST = new CdmaServiceStateTracker(this);
    }

    protected void init(Context context, PhoneNotifier notifier) {
        this.mCi.setPhoneType(2);
        this.mCT = new CdmaCallTracker(this);
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(context, this.mCi, this, 27, null);
        this.mDcTracker = new DcTracker(this);
        this.mRuimPhoneBookInterfaceManager = new RuimPhoneBookInterfaceManager(this);
        this.mSubInfo = new PhoneSubInfo(this);
        this.mEriManager = new EriManager(this, context, 0);
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mCi.setEmergencyCallbackMode(this, 25, null);
        this.mCi.registerForExitEmergencyCallbackMode(this, 26, null);
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, LOG_TAG);
        TelephonyManager tm = TelephonyManager.from(this.mContext);
        tm.setPhoneType(this.getPhoneId(), 2);
        String inEcm = SystemProperties.get("ril.cdma.inecmmode", "false");
        this.mIsPhoneInEcmState = inEcm.equals("true");
        if (this.mIsPhoneInEcmState) {
            this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
        }
        this.mCarrierOtaSpNumSchema = tm.getOtaSpNumberSchemaForPhone(this.getPhoneId(), "");
        String operatorAlpha = SystemProperties.get("ro.cdma.home.operator.alpha");
        String operatorNumeric = SystemProperties.get(PROPERTY_CDMA_HOME_OPERATOR_NUMERIC);
        this.log("init: operatorAlpha='" + operatorAlpha + "' operatorNumeric='" + operatorNumeric + "'");
        if (this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null) {
            this.log("init: APP_FAM_3GPP == NULL");
            if (!TextUtils.isEmpty(operatorAlpha)) {
                this.log("init: set 'gsm.sim.operator.alpha' to operator='" + operatorAlpha + "'");
                tm.setSimOperatorNameForPhone(this.mPhoneId, operatorAlpha);
            }
            if (!TextUtils.isEmpty(operatorNumeric)) {
                this.log("init: set 'gsm.sim.operator.numeric' to operator='" + operatorNumeric + "'");
                this.log("update icc_operator_numeric=" + operatorNumeric);
                tm.setSimOperatorNumericForPhone(this.mPhoneId, operatorNumeric);
                SubscriptionController.getInstance().setMccMnc(operatorNumeric, this.getSubId());
            }
            this.setIsoCountryProperty(operatorNumeric);
        }
        this.updateCurrentCarrierInProvider(operatorNumeric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.log("dispose");
            this.unregisterForRuimRecordEvents();
            this.mCi.unregisterForAvailable(this);
            this.mCi.unregisterForOffOrNotAvailable(this);
            this.mCi.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttached(this);
            this.mCi.unSetOnSuppServiceNotification(this);
            this.mCi.unregisterForExitEmergencyCallbackMode(this);
            this.removeCallbacks(this.mExitEcmRunnable);
            this.mPendingMmis.clear();
            this.mCT.dispose();
            this.mDcTracker.dispose();
            this.mSST.dispose();
            this.mCdmaSSM.dispose(this);
            this.mRuimPhoneBookInterfaceManager.dispose();
            this.mSubInfo.dispose();
            this.mEriManager.dispose();
        }
    }

    @Override
    public void removeReferences() {
        this.log("removeReferences");
        this.mRuimPhoneBookInterfaceManager = null;
        this.mSubInfo = null;
        this.mCT = null;
        this.mSST = null;
        this.mEriManager = null;
        this.mExitEcmRunnable = null;
        super.removeReferences();
    }

    protected void finalize() {
        Rlog.d(LOG_TAG, "CDMAPhone finalized");
        if (this.mWakeLock.isHeld()) {
            Rlog.e(LOG_TAG, "UNEXPECTED; mWakeLock is held when finalizing.");
            this.mWakeLock.release();
        }
    }

    @Override
    public ServiceState getServiceState() {
        if ((this.mSST == null || this.mSST.mSS.getState() != 0) && this.mImsPhone != null) {
            return ServiceState.mergeServiceStates(this.mSST == null ? new ServiceState() : this.mSST.mSS, this.mImsPhone.getServiceState());
        }
        if (this.mSST != null) {
            return this.mSST.mSS;
        }
        return new ServiceState();
    }

    @Override
    public CallTracker getCallTracker() {
        return this.mCT;
    }

    @Override
    public PhoneConstants.State getState() {
        PhoneConstants.State imsState;
        if (this.mImsPhone != null && (imsState = this.mImsPhone.getState()) != PhoneConstants.State.IDLE) {
            return imsState;
        }
        return this.mCT.mState;
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return this.mSST;
    }

    @Override
    public int getPhoneType() {
        return 2;
    }

    @Override
    public boolean canTransfer() {
        Rlog.e(LOG_TAG, "canTransfer: not possible in CDMA");
        return false;
    }

    @Override
    public Call getRingingCall() {
        ImsPhone imPhone = this.mImsPhone;
        if (this.mCT.mRingingCall != null && this.mCT.mRingingCall.isRinging()) {
            return this.mCT.mRingingCall;
        }
        if (imPhone != null) {
            return imPhone.getRingingCall();
        }
        return this.mCT.mRingingCall;
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsPhone != null) {
            this.mImsPhone.setUiTTYMode(uiTtyMode, onComplete);
        }
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void conference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            this.log("conference() - delegated to IMS phone");
            this.mImsPhone.conference();
            return;
        }
        Rlog.e(LOG_TAG, "conference: not possible in CDMA");
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        this.mCi.setPreferredVoicePrivacy(enable, onComplete);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message onComplete) {
        this.mCi.getPreferredVoicePrivacy(onComplete);
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        Phone.DataActivityState ret = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentDataConnectionState() == 0) {
            switch (this.mDcTracker.getActivity()) {
                case DATAIN: {
                    ret = Phone.DataActivityState.DATAIN;
                    break;
                }
                case DATAOUT: {
                    ret = Phone.DataActivityState.DATAOUT;
                    break;
                }
                case DATAINANDOUT: {
                    ret = Phone.DataActivityState.DATAINANDOUT;
                    break;
                }
                case DORMANT: {
                    ret = Phone.DataActivityState.DORMANT;
                    break;
                }
                default: {
                    ret = Phone.DataActivityState.NONE;
                }
            }
        }
        return ret;
    }

    @Override
    public Connection dial(String dialString, int videoState) throws CallStateException {
        return this.dial(dialString, null, videoState, null);
    }

    @Override
    protected Connection dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        return this.mCT.dial(newDialString);
    }

    @Override
    public Connection dial(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        boolean isEmergency;
        block5: {
            if (uusInfo != null) {
                throw new CallStateException("Sending UUS information NOT supported in CDMA!");
            }
            isEmergency = PhoneNumberUtils.isEmergencyNumber(dialString);
            ImsPhone imsPhone = this.mImsPhone;
            boolean imsUseEnabled = this.isImsUseEnabled() && imsPhone != null && (imsPhone.isVolteEnabled() || imsPhone.isVowifiEnabled()) && imsPhone.getServiceState().getState() == 0;
            boolean useImsForEmergency = ImsManager.isVolteEnabledByPlatform((Context)this.mContext) && imsPhone != null && isEmergency && this.mContext.getResources().getBoolean(17956994) && ImsManager.isNonTtyOrTtyOnVolteEnabled((Context)this.mContext) && imsPhone.getServiceState().getState() != 3;
            Rlog.d(LOG_TAG, "imsUseEnabled=" + imsUseEnabled + ", useImsForEmergency=" + useImsForEmergency + ", imsPhone=" + imsPhone + ", imsPhone.isVolteEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVolteEnabled()) : "N/A") + ", imsPhone.isVowifiEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVowifiEnabled()) : "N/A") + ", imsPhone.getServiceState().getState()=" + (imsPhone != null ? Integer.valueOf(imsPhone.getServiceState().getState()) : "N/A"));
            ImsPhone.checkWfcWifiOnlyModeBeforeDial(this.mImsPhone, this.mContext);
            if (imsUseEnabled || useImsForEmergency) {
                try {
                    Rlog.d(LOG_TAG, "Trying IMS PS call");
                    return imsPhone.dial(dialString, uusInfo, videoState, intentExtras);
                }
                catch (CallStateException e) {
                    Rlog.d(LOG_TAG, "IMS PS call exception " + e + "imsUseEnabled =" + imsUseEnabled + ", imsPhone =" + imsPhone);
                    if ("cs_fallback".equals(e.getMessage())) break block5;
                    CallStateException ce = new CallStateException(e.getMessage());
                    ce.setStackTrace(e.getStackTrace());
                    throw ce;
                }
            }
        }
        if (this.mSST != null && this.mSST.mSS.getState() == 1 && this.mSST.mSS.getDataRegState() != 0 && !isEmergency) {
            throw new CallStateException("cannot dial in current state");
        }
        Rlog.d(LOG_TAG, "Trying (non-IMS) CS call");
        return this.dialInternal(dialString, null, videoState, intentExtras);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMmis;
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        Rlog.e(LOG_TAG, "method registerForSuppServiceNotification is NOT supported in CDMA!");
    }

    @Override
    public CdmaCall getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) {
        Rlog.e(LOG_TAG, "method handleInCallMmiCommands is NOT supported in CDMA!");
        return false;
    }

    boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        Rlog.e(LOG_TAG, "method unregisterForSuppServiceNotification is NOT supported in CDMA!");
    }

    @Override
    public void acceptCall(int videoState) throws CallStateException {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            imsPhone.acceptCall(videoState);
        } else {
            this.mCT.acceptCall();
        }
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public String getIccSerialNumber() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            r = this.mUiccController.getIccRecords(this.mPhoneId, 1);
        }
        return r != null ? r.getIccId() : null;
    }

    @Override
    public String getLine1Number() {
        return this.mSST.getMdnNumber();
    }

    @Override
    public String getCdmaPrlVersion() {
        return this.mSST.getPrlVersion();
    }

    @Override
    public String getCdmaMin() {
        return this.mSST.getCdmaMin();
    }

    @Override
    public boolean isMinInfoReady() {
        return this.mSST.isMinInfoReady();
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        this.mCi.queryCallWaiting(1, onComplete);
    }

    @Override
    public void setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    @Override
    public String getEsn() {
        return this.mEsn;
    }

    @Override
    public String getMeid() {
        return this.mMeid;
    }

    @Override
    public String getNai() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (Log.isLoggable(LOG_TAG, 2)) {
            Rlog.v(LOG_TAG, "IccRecords is " + r);
        }
        return r != null ? r.getNAI() : null;
    }

    @Override
    public String getDeviceId() {
        String id2 = this.getMeid();
        if (id2 == null || id2.matches("^0*$")) {
            Rlog.d(LOG_TAG, "getDeviceId(): MEID is not initialized use ESN");
            id2 = this.getEsn();
        }
        return id2;
    }

    @Override
    public String getDeviceSvn() {
        Rlog.d(LOG_TAG, "getDeviceSvn(): return 0");
        return "0";
    }

    @Override
    public String getSubscriberId() {
        return this.mSST.getImsi();
    }

    @Override
    public String getGroupIdLevel1() {
        Rlog.e(LOG_TAG, "GID1 is not available in CDMA");
        return null;
    }

    @Override
    public String getGroupIdLevel2() {
        Rlog.e(LOG_TAG, "GID2 is not available in CDMA");
        return null;
    }

    @Override
    public String getImei() {
        Rlog.e(LOG_TAG, "getImei() called for CDMAPhone");
        return this.mImei;
    }

    @Override
    public boolean canConference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            return true;
        }
        Rlog.e(LOG_TAG, "canConference: not possible in CDMA");
        return false;
    }

    @Override
    public CellLocation getCellLocation() {
        CdmaCellLocation loc = this.mSST.mCellLoc;
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            CdmaCellLocation privateLoc = new CdmaCellLocation();
            privateLoc.setCellLocationData(loc.getBaseStationId(), Integer.MAX_VALUE, Integer.MAX_VALUE, loc.getSystemId(), loc.getNetworkId());
            loc = privateLoc;
        }
        return loc;
    }

    @Override
    public CdmaCall getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    @Override
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    @Override
    public boolean handlePinMmi(String dialString) {
        CdmaMmiCode mmi = CdmaMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get());
        if (mmi == null) {
            Rlog.e(LOG_TAG, "Mmi is NULL!");
            return false;
        }
        if (mmi.isPinPukCommand()) {
            this.mPendingMmis.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return true;
        }
        Rlog.e(LOG_TAG, "Unrecognized mmi!");
        return false;
    }

    void onMMIDone(CdmaMmiCode mmi) {
        if (this.mPendingMmis.remove(mmi)) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        }
    }

    @Override
    public boolean setLine1Number(String alphaTag, String number, Message onComplete) {
        Rlog.e(LOG_TAG, "setLine1Number: not possible in CDMA");
        return false;
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        Rlog.e(LOG_TAG, "method setCallWaiting is NOT supported in CDMA!");
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    @Override
    public void setDataRoamingEnabled(boolean enable) {
        this.mDcTracker.setDataOnRoamingEnabled(enable);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCi.registerForCdmaOtaProvision(h, what, obj);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCi.unregisterForCdmaOtaProvision(h);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSST.registerForSubscriptionInfoReady(h, what, obj);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler h) {
        this.mSST.unregisterForSubscriptionInfoReady(h);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    @Override
    public void registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCT.registerForCallWaiting(h, what, obj);
    }

    @Override
    public void unregisterForCallWaiting(Handler h) {
        this.mCT.unregisterForCallWaiting(h);
    }

    @Override
    public void getNeighboringCids(Message response) {
        if (response != null) {
            CommandException ce = new CommandException(CommandException.Error.REQUEST_NOT_SUPPORTED);
            AsyncResult.forMessage((Message)response).exception = ce;
            response.sendToTarget();
        }
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (this.mSST.getCurrentDataConnectionState() != 0) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!this.mDcTracker.isApnTypeEnabled(apnType) || !this.mDcTracker.isApnTypeActive(apnType)) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (this.mDcTracker.getState(apnType)) {
                case RETRYING: 
                case FAILED: 
                case IDLE: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case CONNECTED: 
                case DISCONNECTING: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case CONNECTING: 
                case SCANNING: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        this.log("getDataConnectionState apnType=" + apnType + " ret=" + (Object)((Object)ret));
        return ret;
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        Rlog.e(LOG_TAG, "sendUssdResponse: not possible in CDMA");
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCi.sendDtmf(c, null);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCi.startDtmf(c, null);
        }
    }

    @Override
    public void stopDtmf() {
        this.mCi.stopDtmf(null);
    }

    @Override
    public void sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        boolean check = true;
        for (int itr = 0; itr < dtmfString.length(); ++itr) {
            if (PhoneNumberUtils.is12Key(dtmfString.charAt(itr))) continue;
            Rlog.e(LOG_TAG, "sendDtmf called with invalid character '" + dtmfString.charAt(itr) + "'");
            check = false;
            break;
        }
        if (this.mCT.mState == PhoneConstants.State.OFFHOOK && check) {
            this.mCi.sendBurstDtmf(dtmfString, on, off, onComplete);
        }
    }

    @Override
    public void getAvailableNetworks(Message response) {
        Rlog.e(LOG_TAG, "getAvailableNetworks: not possible in CDMA");
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        Rlog.e(LOG_TAG, "setOutgoingCallerIdDisplay: not possible in CDMA");
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    @Override
    public void getDataCallList(Message response) {
        this.mCi.getDataCallList(response);
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDcTracker.getDataOnRoamingEnabled();
    }

    @Override
    public void setDataEnabled(boolean enable) {
        this.mDcTracker.setDataEnabled(enable);
    }

    @Override
    public boolean getDataEnabled() {
        return this.mDcTracker.getDataEnabled();
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
        }
    }

    @Override
    public String getVoiceMailNumber() {
        String[] listArray;
        String number = null;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        number = sp.getString(VM_NUMBER_CDMA + this.getPhoneId(), null);
        if (TextUtils.isEmpty(number) && (listArray = this.getContext().getResources().getStringArray(17236030)) != null && listArray.length > 0) {
            for (int i = 0; i < listArray.length; ++i) {
                String[] defaultVMNumberArray;
                if (TextUtils.isEmpty(listArray[i]) || (defaultVMNumberArray = listArray[i].split(";")) == null || defaultVMNumberArray.length <= 0) continue;
                if (defaultVMNumberArray.length == 1) {
                    number = defaultVMNumberArray[0];
                    continue;
                }
                if (defaultVMNumberArray.length != 2 || TextUtils.isEmpty(defaultVMNumberArray[1]) || !defaultVMNumberArray[1].equalsIgnoreCase(this.getGroupIdLevel1())) continue;
                number = defaultVMNumberArray[0];
                break;
            }
        }
        if (TextUtils.isEmpty(number)) {
            number = this.getContext().getResources().getBoolean(17956955) ? this.getLine1Number() : "*86";
        }
        return number;
    }

    private void updateVoiceMail() {
        this.setVoiceMessageCount(this.getStoredVoiceMessageCount());
    }

    @Override
    public String getVoiceMailAlphaTag() {
        String ret = "";
        if (ret == null || ret.length() == 0) {
            return this.mContext.getText(0x1040004).toString();
        }
        return ret;
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        Rlog.e(LOG_TAG, "getCallForwardingOption: not possible in CDMA");
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        Rlog.e(LOG_TAG, "setCallForwardingOption: not possible in CDMA");
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        Rlog.e(LOG_TAG, "getOutgoingCallerIdDisplay: not possible in CDMA");
    }

    @Override
    public boolean getCallForwardingIndicator() {
        Rlog.e(LOG_TAG, "getCallForwardingIndicator: not possible in CDMA");
        return false;
    }

    @Override
    public void explicitCallTransfer() {
        Rlog.e(LOG_TAG, "explicitCallTransfer: not possible in CDMA");
    }

    @Override
    public String getLine1AlphaTag() {
        Rlog.e(LOG_TAG, "getLine1AlphaTag: not possible in CDMA");
        return null;
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    public void notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    void notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
        this.mNotifier.notifyDisconnectCause(cn.getDisconnectCause(), cn.getPreciseDisconnectCause());
    }

    void notifyUnknownConnection(Connection connection) {
        this.mUnknownConnectionRegistrants.notifyResult(connection);
    }

    @Override
    public boolean isInEmergencyCall() {
        return this.mCT.isInEmergencyCall();
    }

    @Override
    public boolean isInEcm() {
        return this.mIsPhoneInEcmState;
    }

    void sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.mIsPhoneInEcmState);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
        Rlog.d(LOG_TAG, "sendEmergencyCallbackModeChange");
    }

    @Override
    public void exitEmergencyCallbackMode() {
        if (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
        this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
    }

    private void handleEnterEmergencyCallbackMode(Message msg) {
        Rlog.d(LOG_TAG, "handleEnterEmergencyCallbackMode,mIsPhoneInEcmState= " + this.mIsPhoneInEcmState);
        if (!this.mIsPhoneInEcmState) {
            this.mIsPhoneInEcmState = true;
            this.sendEmergencyCallbackModeChange();
            this.setSystemProperty("ril.cdma.inecmmode", "true");
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private void handleExitEmergencyCallbackMode(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d(LOG_TAG, "handleExitEmergencyCallbackMode,ar.exception , mIsPhoneInEcmState " + ar.exception + this.mIsPhoneInEcmState);
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyRegistrant(ar);
        }
        if (ar.exception == null) {
            if (this.mIsPhoneInEcmState) {
                this.mIsPhoneInEcmState = false;
                this.setSystemProperty("ril.cdma.inecmmode", "false");
            }
            this.sendEmergencyCallbackModeChange();
            this.mDcTracker.setInternalDataEnabled(true);
            this.notifyEmergencyCallRegistrants(false);
        }
    }

    protected void notifyEmergencyCallRegistrants(boolean started) {
        this.mEmergencyCallToggledRegistrants.notifyResult(started ? 1 : 0);
    }

    void handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e(LOG_TAG, "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    public void notifyEcbmTimerReset(Boolean flag) {
        this.mEcmTimerResetRegistrants.notifyResult(flag);
    }

    @Override
    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 16: 
            case 17: {
                super.handleMessage(msg);
                return;
            }
        }
        if (!this.mIsTheCurrentActivePhone) {
            Rlog.e(LOG_TAG, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 1: {
                this.mCi.getBasebandVersion(this.obtainMessage(6));
                this.mCi.getDeviceIdentity(this.obtainMessage(21));
                this.mCi.getRadioCapability(this.obtainMessage(35));
                this.startLceAfterRadioIsAvailable();
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                Rlog.d(LOG_TAG, "Baseband version: " + ar.result);
                TelephonyManager.from(this.mContext).setBasebandVersionForPhone(this.getPhoneId(), (String)ar.result);
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] respId = (String[])ar.result;
                this.mImei = respId[0];
                this.mImeiSv = respId[1];
                this.mEsn = respId[2];
                this.mMeid = respId[3];
                break;
            }
            case 25: {
                this.handleEnterEmergencyCallbackMode(msg);
                break;
            }
            case 26: {
                this.handleExitEmergencyCallbackMode(msg);
                break;
            }
            case 22: {
                Rlog.d(LOG_TAG, "Event EVENT_RUIM_RECORDS_LOADED Received");
                this.updateCurrentCarrierInProvider();
                this.log("notifyMessageWaitingChanged");
                this.mNotifier.notifyMessageWaitingChanged(this);
                this.updateVoiceMail();
                break;
            }
            case 8: {
                Rlog.d(LOG_TAG, "Event EVENT_RADIO_OFF_OR_NOT_AVAILABLE Received");
                ImsPhone imsPhone = this.mImsPhone;
                if (imsPhone == null) break;
                imsPhone.getServiceState().setStateOff();
                break;
            }
            case 5: {
                Rlog.d(LOG_TAG, "Event EVENT_RADIO_ON Received");
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                this.setPreferredNetworkTypeIfSimLoaded();
                break;
            }
            case 27: {
                Rlog.d(LOG_TAG, "EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED");
                this.handleCdmaSubscriptionSource(this.mCdmaSSM.getCdmaSubscriptionSource());
                break;
            }
            case 2: {
                Rlog.d(LOG_TAG, "Event EVENT_SSN Received");
                break;
            }
            case 19: {
                Rlog.d(LOG_TAG, "Event EVENT_REGISTERED_TO_NETWORK Received");
                break;
            }
            case 23: {
                Rlog.d(LOG_TAG, "Event EVENT_NV_READY Received");
                this.prepareEri();
                this.log("notifyMessageWaitingChanged");
                this.mNotifier.notifyMessageWaitingChanged(this);
                this.updateVoiceMail();
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (IccException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected UiccCardApplication getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(this.mPhoneId, 2);
    }

    @Override
    protected void onUpdateIccAvailability() {
        UiccCardApplication app;
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.getUiccCardApplication();
        if (newUiccApplication == null) {
            this.log("can't find 3GPP2 application; trying APP_FAM_3GPP");
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        }
        if ((app = (UiccCardApplication)this.mUiccApplication.get()) != newUiccApplication) {
            if (app != null) {
                this.log("Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.unregisterForRuimRecordEvents();
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                this.log("New Uicc application found");
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                this.registerForRuimRecordEvents();
            }
        }
    }

    private void handleCdmaSubscriptionSource(int newSubscriptionSource) {
        if (newSubscriptionSource != this.mCdmaSubscriptionSource) {
            this.mCdmaSubscriptionSource = newSubscriptionSource;
            if (newSubscriptionSource == 1) {
                this.sendMessage(this.obtainMessage(23));
            }
        }
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mSubInfo;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mRuimPhoneBookInterfaceManager;
    }

    public void registerForEriFileLoaded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEriFileLoadedRegistrants.add(r);
    }

    public void unregisterForEriFileLoaded(Handler h) {
        this.mEriFileLoadedRegistrants.remove(h);
    }

    @Override
    public void setSystemProperty(String property, String value) {
        super.setSystemProperty(property, value);
    }

    @Override
    public String getSystemProperty(String property, String defValue) {
        return super.getSystemProperty(property, defValue);
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        Rlog.e(LOG_TAG, "[CDMAPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        Rlog.e(LOG_TAG, "[CDMAPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        Rlog.e(LOG_TAG, "[CDMAPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return this.mSST.getOtasp() != 3;
    }

    private static boolean isIs683OtaSpDialStr(String dialStr) {
        boolean isOtaspDialString = false;
        int dialStrLen = dialStr.length();
        if (dialStrLen == 4) {
            if (dialStr.equals(IS683A_FEATURE_CODE)) {
                isOtaspDialString = true;
            }
        } else {
            int sysSelCodeInt = CDMAPhone.extractSelCodeFromOtaSpNum(dialStr);
            switch (sysSelCodeInt) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    isOtaspDialString = true;
                    break;
                }
            }
        }
        return isOtaspDialString;
    }

    private static int extractSelCodeFromOtaSpNum(String dialStr) {
        int dialStrLen = dialStr.length();
        int sysSelCodeInt = -1;
        if (dialStr.regionMatches(0, IS683A_FEATURE_CODE, 0, 4) && dialStrLen >= 6) {
            sysSelCodeInt = Integer.parseInt(dialStr.substring(4, 6));
        }
        Rlog.d(LOG_TAG, "extractSelCodeFromOtaSpNum " + sysSelCodeInt);
        return sysSelCodeInt;
    }

    private static boolean checkOtaSpNumBasedOnSysSelCode(int sysSelCodeInt, String[] sch) {
        boolean isOtaSpNum = false;
        try {
            int selRc = Integer.parseInt(sch[1]);
            for (int i = 0; i < selRc; ++i) {
                if (TextUtils.isEmpty(sch[i + 2]) || TextUtils.isEmpty(sch[i + 3])) continue;
                int selMin = Integer.parseInt(sch[i + 2]);
                int selMax = Integer.parseInt(sch[i + 3]);
                if (sysSelCodeInt < selMin || sysSelCodeInt > selMax) continue;
                isOtaSpNum = true;
                break;
            }
        }
        catch (NumberFormatException ex) {
            Rlog.e(LOG_TAG, "checkOtaSpNumBasedOnSysSelCode, error", ex);
        }
        return isOtaSpNum;
    }

    private boolean isCarrierOtaSpNum(String dialStr) {
        boolean isOtaSpNum = false;
        int sysSelCodeInt = CDMAPhone.extractSelCodeFromOtaSpNum(dialStr);
        if (sysSelCodeInt == -1) {
            return isOtaSpNum;
        }
        if (!TextUtils.isEmpty(this.mCarrierOtaSpNumSchema)) {
            Matcher m = pOtaSpNumSchema.matcher(this.mCarrierOtaSpNumSchema);
            Rlog.d(LOG_TAG, "isCarrierOtaSpNum,schema" + this.mCarrierOtaSpNumSchema);
            if (m.find()) {
                String[] sch = pOtaSpNumSchema.split(this.mCarrierOtaSpNumSchema);
                if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("SELC")) {
                    if (sysSelCodeInt != -1) {
                        isOtaSpNum = CDMAPhone.checkOtaSpNumBasedOnSysSelCode(sysSelCodeInt, sch);
                    } else {
                        Rlog.d(LOG_TAG, "isCarrierOtaSpNum,sysSelCodeInt is invalid");
                    }
                } else if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("FC")) {
                    String fc = sch[2];
                    int fcLen = Integer.parseInt(sch[1]);
                    if (dialStr.regionMatches(0, fc, 0, fcLen)) {
                        isOtaSpNum = true;
                    } else {
                        Rlog.d(LOG_TAG, "isCarrierOtaSpNum,not otasp number");
                    }
                } else {
                    Rlog.d(LOG_TAG, "isCarrierOtaSpNum,ota schema not supported" + sch[0]);
                }
            } else {
                Rlog.d(LOG_TAG, "isCarrierOtaSpNum,ota schema pattern not right" + this.mCarrierOtaSpNumSchema);
            }
        } else {
            Rlog.d(LOG_TAG, "isCarrierOtaSpNum,ota schema pattern empty");
        }
        return isOtaSpNum;
    }

    @Override
    public boolean isOtaSpNumber(String dialStr) {
        boolean isOtaSpNum = false;
        String dialableStr = PhoneNumberUtils.extractNetworkPortionAlt(dialStr);
        if (dialableStr != null && !(isOtaSpNum = CDMAPhone.isIs683OtaSpDialStr(dialableStr))) {
            isOtaSpNum = this.isCarrierOtaSpNum(dialableStr);
        }
        Rlog.d(LOG_TAG, "isOtaSpNumber " + isOtaSpNum);
        return isOtaSpNum;
    }

    @Override
    public int getCdmaEriIconIndex() {
        return this.getServiceState().getCdmaEriIconIndex();
    }

    @Override
    public int getCdmaEriIconMode() {
        return this.getServiceState().getCdmaEriIconMode();
    }

    @Override
    public String getCdmaEriText() {
        int roamInd = this.getServiceState().getCdmaRoamingIndicator();
        int defRoamInd = this.getServiceState().getCdmaDefaultRoamingIndicator();
        return this.mEriManager.getCdmaEriText(roamInd, defRoamInd);
    }

    private void storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(VM_NUMBER_CDMA + this.getPhoneId(), number);
        editor.apply();
    }

    protected void setIsoCountryProperty(String operatorNumeric) {
        TelephonyManager tm = TelephonyManager.from(this.mContext);
        if (TextUtils.isEmpty(operatorNumeric)) {
            this.log("setIsoCountryProperty: clear 'gsm.sim.operator.iso-country'");
            tm.setSimCountryIsoForPhone(this.mPhoneId, "");
        } else {
            String iso = "";
            try {
                iso = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
            }
            catch (NumberFormatException ex) {
                this.loge("setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            catch (StringIndexOutOfBoundsException ex) {
                this.loge("setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            this.log("setIsoCountryProperty: set 'gsm.sim.operator.iso-country' to iso=" + iso);
            tm.setSimCountryIsoForPhone(this.mPhoneId, iso);
        }
    }

    boolean updateCurrentCarrierInProvider(String operatorNumeric) {
        this.log("CDMAPhone: updateCurrentCarrierInProvider called");
        if (!TextUtils.isEmpty(operatorNumeric)) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                map.put("numeric", operatorNumeric);
                this.log("updateCurrentCarrierInProvider from system: numeric=" + operatorNumeric);
                this.getContext().getContentResolver().insert(uri, map);
                this.log("update mccmnc=" + operatorNumeric);
                MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
                return true;
            }
            catch (SQLException e) {
                Rlog.e(LOG_TAG, "Can't store current operator", e);
            }
        }
        return false;
    }

    boolean updateCurrentCarrierInProvider() {
        return true;
    }

    public void prepareEri() {
        if (this.mEriManager == null) {
            Rlog.e(LOG_TAG, "PrepareEri: Trying to access stale objects");
            return;
        }
        this.mEriManager.loadEriFile();
        if (this.mEriManager.isEriFileLoaded()) {
            this.log("ERI read, notify registrants");
            this.mEriFileLoadedRegistrants.notifyRegistrants();
        }
    }

    public boolean isEriFileLoaded() {
        return this.mEriManager.isEriFileLoaded();
    }

    protected void registerForRuimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.registerForRecordsLoaded(this, 22, null);
    }

    protected void unregisterForRuimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.unregisterForRecordsLoaded(this);
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
        this.setVoiceMessageCount(countWaiting);
    }

    protected void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    protected void loge(String s, Exception e) {
        Rlog.e(LOG_TAG, s, e);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CDMAPhone extends:");
        super.dump(fd, pw, args);
        pw.println(" mVmNumber=" + this.mVmNumber);
        pw.println(" mCT=" + this.mCT);
        pw.println(" mSST=" + this.mSST);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mPendingMmis=" + this.mPendingMmis);
        pw.println(" mRuimPhoneBookInterfaceManager=" + this.mRuimPhoneBookInterfaceManager);
        pw.println(" mCdmaSubscriptionSource=" + this.mCdmaSubscriptionSource);
        pw.println(" mSubInfo=" + this.mSubInfo);
        pw.println(" mEriManager=" + this.mEriManager);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" mIsPhoneInEcmState=" + this.mIsPhoneInEcmState);
        pw.println(" mCarrierOtaSpNumSchema=" + this.mCarrierOtaSpNumSchema);
        pw.println(" getCdmaEriIconIndex()=" + this.getCdmaEriIconIndex());
        pw.println(" getCdmaEriIconMode()=" + this.getCdmaEriIconMode());
        pw.println(" getCdmaEriText()=" + this.getCdmaEriText());
        pw.println(" isMinInfoReady()=" + this.isMinInfoReady());
        pw.println(" isCspPlmnEnabled()=" + this.isCspPlmnEnabled());
    }

    @Override
    public boolean setOperatorBrandOverride(String brand) {
        if (this.mUiccController == null) {
            return false;
        }
        UiccCard card = this.mUiccController.getUiccCard(this.getPhoneId());
        if (card == null) {
            return false;
        }
        boolean status = card.setOperatorBrandOverride(brand);
        if (status) {
            IccRecords iccRecords = (IccRecords)this.mIccRecords.get();
            if (iccRecords != null) {
                TelephonyManager.from(this.mContext).setSimOperatorNameForPhone(this.mPhoneId, iccRecords.getServiceProviderName());
            }
            if (this.mSST != null) {
                this.mSST.pollState();
            }
        }
        return status;
    }
}

